--[[
	Informant - An addon for World of Warcraft that shows pertinent information about
	an item in a tooltip when you hover over the item in the game.
	Version: 5.7.4504 (KillerKoala)
	Revision: $Id: InfData.lua 6374 2019-09-22 00:20:05Z none $
	URL: http://auctioneeraddon.com/dl/Informant/

	Informant ItemData

	License:
		This program is free software; you can redistribute it and/or
		modify it under the terms of the GNU General Public License
		as published by the Free Software Foundation; either version 2
		of the License, or (at your option) any later version.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program(see GPL.txt); if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Note:
		This AddOn's source code is specifically designed to work with
		World of Warcraft's interpreted AddOn system.
		You have an implicit licence to use this AddOn with these facilities
		since that is its designated purpose as per:
		http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat
		Many thanks to the folks at http://www.wowhead.com for providing this data.
--]]
-- Numeric Codes and the Skills associated with them.
Informant.SetSkills({
	[171]="Alchemy",
	[164]="Blacksmithing",
	[185]="Cooking",
	[333]="Enchanting",
	[202]="Engineering",
	[129]="FirstAid",
	[356]="Fishing",
	[182]="Herbalism",
	[773]="Inscription",
	[755]="Jewelcrafting",
	[165]="Leatherworking",
	[186]="Mining",
	[762]="Riding",
	[197]="Tailoring",
	[-11]="Druid",
	[-8]="Mage",
	[237]="Mage",
	[-2]="Paladin",
	[-5]="Priest",
	[40]="Rogue",
	[-4]="Rogue",
	[-7]="Shaman",
	[354]="Warlock",
	[-9]="Warlock",
	[-6]="DeathKnight",
})

-- A list of recipes mapped to items that they produce
Informant.SetCrafted({
	[728]=57991, -- Recipe: Westfall Stew
	[2406]=2307, -- Pattern: Fine Leather Boots
	[2407]=2311, -- Pattern: White Leather Jerkin
	[2408]=2312, -- Pattern: Fine Leather Gloves
	[2409]=2317, -- Pattern: Dark Leather Tunic
	[2553]=2457, -- Recipe: Elixir of Minor Agility
	[2555]=2459, -- Recipe: Swiftness Potion
	[2598]=2572, -- Pattern: Red Linen Robe
	[2601]=2585, -- Pattern: Gray Woolen Robe
	[2697]=724, -- Recipe: Goretusk Liver Pie
	[2698]=2682, -- Recipe: Cooked Crab Claw
	[2699]=1082, -- Recipe: Redridge Goulash
	[2700]=2685, -- Recipe: Succulent Pork Ribs
	[2701]=1017, -- Recipe: Seasoned Wolf Kabob
	[2881]=2864, -- Plans: Runed Copper Breastplate
	[2882]=54783, -- Plans: Silvered Bronze Shoulders
	[2883]=3490, -- Plans: Deadly Bronze Poniard
	[2889]=2888, -- Recipe: Beer Basted Boar Ribs
	[3393]=3384, -- Recipe: Minor Magic Resistance Potion
	[3394]=3386, -- Recipe: Potion of Curing
	[3395]=3387, -- Recipe: Limited Invulnerability Potion
	[3396]=3390, -- Recipe: Elixir of Lesser Agility
	[3608]=3492, -- Plans: Mighty Iron Hammer
	[3609]=3471, -- Plans: Copper Chain Vest
	[3610]=3474, -- Plans: Gemmed Copper Gauntlets
	[3611]=3484, -- Plans: Green Iron Boots
	[3612]=3485, -- Plans: Green Iron Gauntlets
	[3678]=3662, -- Recipe: Crocolisk Steak
	[3679]=3220, -- Recipe: Blood Sausage
	[3680]=3663, -- Recipe: Murloc Fin Soup
	[3681]=3664, -- Recipe: Crocolisk Gumbo
	[3682]=3665, -- Recipe: Curiously Tasty Omelet
	[3683]=3666, -- Recipe: Gooey Spider Cake
	[3734]=3726, -- Recipe: Big Bear Steak
	[3735]=3727, -- Recipe: Hot Lion Chops
	[3736]=3728, -- Recipe: Tasty Lion Steak
	[3737]=3729, -- Recipe: Soothing Turtle Bisque
	[3830]=3825, -- Recipe: Elixir of Fortitude
	[3831]=3826, -- Recipe: Major Troll's Blood Elixir
	[3832]=3828, -- Recipe: Elixir of Detect Lesser Invisibility
	[3866]=3850, -- Plans: Jade Serpentblade
	[3867]=3852, -- Plans: Golden Iron Destroyer
	[3868]=3854, -- Plans: Frost Tiger Blade
	[3869]=3856, -- Plans: Shadow Crescent Axe
	[3870]=3840, -- Plans: Green Iron Shoulders
	[3871]=3841, -- Plans: Golden Scale Shoulders
	[3872]=3843, -- Plans: Golden Scale Leggings
	[3873]=3845, -- Plans: Golden Scale Cuirass
	[3874]=3846, -- Plans: Polished Steel Boots
	[3875]=3847, -- Plans: Golden Scale Boots
	[4292]=4241, -- Pattern: Green Woolen Bag
	[4293]=54670, -- Pattern: Hillman's Leather Vest
	[4294]=4250, -- Pattern: Hillman's Belt
	[4296]=4252, -- Pattern: Dark Leather Shoulders
	[4297]=4254, -- Pattern: Barbaric Gloves
	[4298]=4258, -- Pattern: Guardian Belt
	[4299]=54684, -- Pattern: Guardian Armor
	[4300]=4260, -- Pattern: Guardian Leather Bracers
	[4301]=4264, -- Pattern: Barbaric Belt
	[4345]=4313, -- Pattern: Red Woolen Boots
	[4346]=4311, -- Pattern: Heavy Woolen Cloak
	[4347]=4315, -- Pattern: Reinforced Woolen Shoulders
	[4348]=4331, -- Pattern: Phoenix Gloves
	[4349]=4317, -- Pattern: Phoenix Pants
	[4350]=4321, -- Pattern: Spider Silk Slippers
	[4351]=4323, -- Pattern: Shadow Hood
	[4352]=4325, -- Pattern: Boots of the Enchanter
	[4353]=4328, -- Pattern: Spider Belt
	[4354]=4335, -- Pattern: Rich Purple Silk Shirt
	[4355]=4327, -- Pattern: Icy Cloak
	[4356]=4329, -- Pattern: Star Belt
	[4408]=4401, -- Schematic: Mechanical Squirrel Box
	[4409]=4367, -- Schematic: Small Seaforium Charge
	[4410]=4373, -- Schematic: Shadow Goggles
	[4411]=4376, -- Schematic: Flame Deflector
	[4412]=4383, -- Schematic: Moonsight Rifle
	[4413]=4388, -- Schematic: Discombobulator Ray
	[4414]=4403, -- Schematic: Portable Bronze Mortar
	[4415]=4393, -- Schematic: Craftsman's Monocle
	[4416]=4395, -- Schematic: Goblin Land Mine
	[4417]=4398, -- Schematic: Large Seaforium Charge
	[4597]=4596, -- Recipe: Discolored Healing Potion
	[4609]=4457, -- Recipe: Barbecued Buzzard Wing
	[4624]=4623, -- Recipe: Lesser Stoneshield Potion
	[5083]=5081, -- Pattern: Kodo Hide Bag
	[5482]=5472, -- Recipe: Kaldorei Spider Kabob
	[5483]=5473, -- Recipe: Scorpid Surprise
	[5484]=5474, -- Recipe: Roasted Kodo Meat
	[5485]=5476, -- Recipe: Fillet of Frenzy
	[5486]=5477, -- Recipe: Strider Stew
	[5487]=5478, -- Recipe: Dig Rat Stew
	[5488]=5479, -- Recipe: Crispy Lizard Tail
	[5489]=5480, -- Recipe: Lean Venison
	[5528]=5526, -- Recipe: Clam Chowder
	[5543]=5541, -- Plans: Iridescent Hammer
	[5578]=2869, -- Plans: Silvered Bronze Breastplate
	[5640]=5631, -- Recipe: Rage Potion
	[5642]=5634, -- Recipe: Free Action Potion
	[5643]=5633, -- Recipe: Great Rage Potion
	[5771]=5762, -- Pattern: Red Linen Bag
	[5772]=5763, -- Pattern: Red Woolen Bag
	[5773]=5770, -- Pattern: Robes of Arcana
	[5774]=5764, -- Pattern: Green Silk Pack
	[5775]=5765, -- Pattern: Black Silk Pack
	[5786]=5780, -- Pattern: Murloc Scale Belt
	[5787]=54668, -- Pattern: Murloc Scale Breastplate
	[5788]=54681, -- Pattern: Thick Murloc Armor
	[5789]=5783, -- Pattern: Murloc Scale Bracers
	[5972]=5958, -- Pattern: Fine Leather Pants
	[5973]=5963, -- Pattern: Barbaric Leggings
	[5974]=5965, -- Pattern: Guardian Cloak
	[6039]=6038, -- Recipe: Giant Clam Scorcho
	[6044]=6042, -- Plans: Iron Shield Spike
	[6045]=6043, -- Plans: Iron Counterweight
	[6046]=6041, -- Plans: Steel Weapon Chain
	[6047]=3837, -- Plans: Golden Scale Coif
	[6053]=6051, -- Recipe: Holy Protection Potion
	[6054]=6048, -- Recipe: Shadow Protection Potion
	[6055]=6049, -- Recipe: Fire Protection Potion
	[6056]=6050, -- Recipe: Frost Protection Potion
	[6057]=6052, -- Recipe: Nature Protection Potion
	[6068]=3824, -- Recipe: Shadow Oil
	[6211]=3391, -- Recipe: Elixir of Ogre's Strength
	[6270]=6240, -- Pattern: Blue Linen Vest
	[6271]=6239, -- Pattern: Red Linen Vest
	[6272]=6242, -- Pattern: Blue Linen Robe
	[6274]=6263, -- Pattern: Blue Overalls
	[6275]=6264, -- Pattern: Greater Adept's Robe
	[6325]=6290, -- Recipe: Brilliant Smallfish
	[6326]=787, -- Recipe: Slitherskin Mackerel
	[6328]=4592, -- Recipe: Longjaw Mud Snapper
	[6329]=6316, -- Recipe: Loch Frenzy Delight
	[6330]=4593, -- Recipe: Bristle Whisker Catfish
	[6368]=5095, -- Recipe: Rainbow Fin Albacore
	[6369]=4594, -- Recipe: Rockscale Cod
	[6390]=6384, -- Pattern: Stylish Blue Shirt
	[6391]=6385, -- Pattern: Stylish Green Shirt
	[6401]=4333, -- Pattern: Dark Silk Shirt
	[6476]=6468, -- Pattern: Deviate Scale Belt
	[6661]=6657, -- Recipe: Savory Deviate Delight
	[6663]=6662, -- Recipe: Elixir of Giant Growth
	[6672]=4852, -- Schematic: Flash Bomb
	[6710]=6709, -- Pattern: Moonglow Vest
	[6716]=6714, -- Schematic: EZ-Thro Dynamite
	[6735]=6731, -- Plans: Ironforge Breastplate
	[6892]=6890, -- Recipe: Smoked Bear Meat
	[7084]=7059, -- Pattern: Crimson Silk Shoulders
	[7085]=7060, -- Pattern: Azure Shoulders
	[7086]=7061, -- Pattern: Earthen Silk Belt
	[7087]=7056, -- Pattern: Crimson Silk Cloak
	[7088]=7063, -- Pattern: Crimson Silk Robe
	[7089]=7053, -- Pattern: Azure Silk Cloak
	[7090]=7065, -- Pattern: Green Silk Armor
	[7091]=7049, -- Pattern: Truefaith Gloves
	[7092]=7047, -- Pattern: Hands of Darkness
	[7114]=4319, -- Pattern: Azure Silk Gloves
	[7288]=7280, -- Pattern: Rugged Leather Pants
	[7289]=7283, -- Pattern: Black Whelp Cloak
	[7290]=7284, -- Pattern: Red Whelp Gloves
	[7360]=4248, -- Pattern: Dark Leather Gloves
	[7361]=7349, -- Pattern: Herbalist's Gloves
	[7362]=7352, -- Pattern: Earthen Leather Shoulders
	[7363]=7358, -- Pattern: Pilferer's Gloves
	[7364]=7359, -- Pattern: Heavy Earthen Gloves
	[7449]=7373, -- Pattern: Dusky Leather Leggings
	[7450]=54682, -- Pattern: Green Whelp Armor
	[7451]=7386, -- Pattern: Green Whelp Bracers
	[7452]=7390, -- Pattern: Dusky Boots
	[7453]=7391, -- Pattern: Swift Boots
	[7560]=7506, -- Schematic: Gnomish Universal Remote
	[7561]=7148, -- Schematic: Goblin Jumper Cables
	[7613]=4255, -- Pattern: Green Leather Armor
	[7678]=7676, -- Recipe: Thistle Tea
	[7742]=4397, -- Schematic: Gnomish Cloaking Device
	[7975]=7921, -- Plans: Heavy Mithril Pants
	[7976]=7967, -- Plans: Mithril Shield Spike
	[7978]=7913, -- Plans: Barbaric Iron Shoulders
	[7979]=7914, -- Plans: Barbaric Iron Breastplate
	[7980]=7915, -- Plans: Barbaric Iron Helm
	[7981]=7916, -- Plans: Barbaric Iron Boots
	[7982]=7917, -- Plans: Barbaric Iron Gloves
	[7983]=7926, -- Plans: Ornate Mithril Pants
	[7984]=7927, -- Plans: Ornate Mithril Gloves
	[7985]=7928, -- Plans: Ornate Mithril Shoulder
	[7989]=7969, -- Plans: Mithril Spurs
	[7990]=7934, -- Plans: Heavy Mithril Helm
	[7991]=7932, -- Plans: Mithril Scale Shoulders
	[7992]=7942, -- Plans: Blue Glittering Axe
	[7993]=7944, -- Plans: Dazzling Mithril Rapier
	[7995]=7924, -- Plans: Mithril Scale Bracers
	[8028]=7946, -- Plans: Runed Mithril Hammer
	[8029]=7943, -- Plans: Wicked Mithril Blade
	[8030]=7947, -- Plans: Ebon Shiv
	[8384]=8174, -- Pattern: Comfortable Leather Hat
	[8385]=8187, -- Pattern: Turtle Scale Gloves
	[8386]=8200, -- Pattern: Big Voodoo Robe
	[8387]=8201, -- Pattern: Big Voodoo Mask
	[8389]=8202, -- Pattern: Big Voodoo Pants
	[8390]=8216, -- Pattern: Big Voodoo Cloak
	[8395]=8203, -- Pattern: Tough Scorpid Breastplate
	[8397]=8205, -- Pattern: Tough Scorpid Bracers
	[8398]=8204, -- Pattern: Tough Scorpid Gloves
	[8399]=8209, -- Pattern: Tough Scorpid Boots
	[8400]=8207, -- Pattern: Tough Scorpid Shoulders
	[8401]=8206, -- Pattern: Tough Scorpid Leggings
	[8402]=8208, -- Pattern: Tough Scorpid Helm
	[8403]=8210, -- Pattern: Wild Leather Shoulders
	[8404]=8211, -- Pattern: Wild Leather Vest
	[8405]=8214, -- Pattern: Wild Leather Helmet
	[8406]=8213, -- Pattern: Wild Leather Boots
	[8407]=8212, -- Pattern: Wild Leather Leggings
	[8408]=8215, -- Pattern: Wild Leather Cloak
	[8409]=8192, -- Pattern: Nightscape Shoulders
	[9293]=9036, -- Recipe: Magic Resistance Potion
	[9294]=9144, -- Recipe: Wildvine Potion
	[9295]=9172, -- Recipe: Invisibility Potion
	[9296]=9088, -- Recipe: Gift of Arthas
	[9297]=9197, -- Recipe: Elixir of Dream Vision
	[9298]=9206, -- Recipe: Elixir of Giants
	[9300]=9224, -- Recipe: Elixir of Demonslaying
	[9301]=9264, -- Recipe: Elixir of Shadow Power
	[9302]=9210, -- Recipe: Ghost Dye
	[9303]=9149, -- Recipe: Philosopher's Stone
	[9367]=9366, -- Plans: Golden Scale Gauntlets
	[10300]=10007, -- Pattern: Red Mageweave Vest
	[10301]=10008, -- Pattern: White Bandit Mask
	[10302]=10009, -- Pattern: Red Mageweave Pants
	[10311]=10052, -- Pattern: Orange Martial Shirt
	[10312]=10018, -- Pattern: Red Mageweave Gloves
	[10314]=10054, -- Pattern: Lavender Mageweave Shirt
	[10315]=10029, -- Pattern: Red Mageweave Shoulders
	[10316]=10048, -- Pattern: Colorful Kilt
	[10317]=10055, -- Pattern: Pink Mageweave Shirt
	[10318]=10030, -- Pattern: Admiral's Hat
	[10320]=10033, -- Pattern: Red Mageweave Headband
	[10321]=10034, -- Pattern: Tuxedo Shirt
	[10323]=10035, -- Pattern: Tuxedo Pants
	[10325]=10040, -- Pattern: White Wedding Dress
	[10326]=10036, -- Pattern: Tuxedo Jacket
	[10424]=10423, -- Plans: Silvered Bronze Leggings
	[10463]=10025, -- Pattern: Shadoweave Mask
	[10601]=10499, -- Schematic: Bright-Eye Goggles
	[10602]=10546, -- Schematic: Deadly Scope
	[10603]=10501, -- Schematic: Catseye Ultra Goggles
	[10604]=10510, -- Schematic: Mithril Heavy-Bore Rifle
	[10605]=10502, -- Schematic: Spellpower Goggles Xtreme
	[10606]=10518, -- Schematic: Parachute Cloak
	[10607]=10506, -- Schematic: Deepdive Helmet
	[10608]=10548, -- Schematic: Sniper Scope
	[10609]=10576, -- Schematic: Mithril Mechanical Dragonling
	[10644]=9061, -- Recipe: Goblin Rocket Fuel
	[10713]=9060, -- Plans: Inlaid Mithril Cylinder
	[10728]=4336, -- Pattern: Black Swashbuckler's Shirt
	[10858]=3851, -- Plans: Solid Iron Maul
	[11610]=11608, -- Plans: Dark Iron Pulverizer
	[11611]=11607, -- Plans: Dark Iron Sunderer
	[11612]=11604, -- Plans: Dark Iron Plate
	[11614]=11606, -- Plans: Dark Iron Mail
	[11615]=11605, -- Plans: Dark Iron Shoulders
	[11827]=11826, -- Schematic: Lil' Smoky
	[11828]=11825, -- Schematic: Pet Bombling
	[12162]=3849, -- Plans: Hardened Iron Shortsword
	[12163]=3853, -- Plans: Moonsteel Broadsword
	[12164]=3855, -- Plans: Massive Iron Axe
	[12226]=12224, -- Recipe: Crispy Bat Wing
	[12227]=12209, -- Recipe: Lean Wolf Steak
	[12228]=12210, -- Recipe: Roast Raptor
	[12229]=13851, -- Recipe: Hot Wolf Ribs
	[12231]=12212, -- Recipe: Jungle Stew
	[12232]=12213, -- Recipe: Carrion Surprise
	[12233]=12214, -- Recipe: Mystery Stew
	[12239]=12217, -- Recipe: Dragonbreath Chili
	[12240]=12215, -- Recipe: Heavy Kodo Stew
	[12261]=12260, -- Plans: Searing Golden Blade
	[12682]=12405, -- Plans: Thorium Armor
	[12683]=12406, -- Plans: Thorium Belt
	[12684]=12408, -- Plans: Thorium Bracers
	[12685]=12416, -- Plans: Radiant Belt
	[12687]=12428, -- Plans: Imperial Plate Shoulders
	[12688]=12424, -- Plans: Imperial Plate Belt
	[12689]=12415, -- Plans: Radiant Breastplate
	[12690]=12425, -- Plans: Imperial Plate Bracers
	[12691]=12624, -- Plans: Wildthorn Mail
	[12692]=12645, -- Plans: Thorium Shield Spike
	[12693]=12409, -- Plans: Thorium Boots
	[12694]=12410, -- Plans: Thorium Helm
	[12695]=12418, -- Plans: Radiant Gloves
	[12696]=12628, -- Plans: Demon Forged Breastplate
	[12697]=12419, -- Plans: Radiant Boots
	[12698]=12625, -- Plans: Dawnbringer Shoulders
	[12699]=12631, -- Plans: Fiery Plate Gauntlets
	[12700]=12426, -- Plans: Imperial Plate Boots
	[12701]=12427, -- Plans: Imperial Plate Helm
	[12702]=12417, -- Plans: Radiant Circlet
	[12703]=12632, -- Plans: Storm Gauntlets
	[12704]=12414, -- Plans: Thorium Leggings
	[12705]=12422, -- Plans: Imperial Plate Chest
	[12706]=12610, -- Plans: Runic Plate Shoulders
	[12707]=12611, -- Plans: Runic Plate Boots
	[12711]=12633, -- Plans: Whitesoul Helm
	[12713]=12420, -- Plans: Radiant Leggings
	[12714]=12612, -- Plans: Runic Plate Helm
	[12715]=12429, -- Plans: Imperial Plate Leggings
	[12716]=12636, -- Plans: Helm of the Great Chief
	[12717]=12640, -- Plans: Lionheart Helm
	[12718]=12613, -- Plans: Runic Breastplate
	[12719]=12614, -- Plans: Runic Plate Leggings
	[12720]=12639, -- Plans: Stronghold Gauntlets
	[12725]=12620, -- Plans: Enchanted Thorium Helm
	[12726]=12619, -- Plans: Enchanted Thorium Leggings
	[12727]=12618, -- Plans: Enchanted Thorium Breastplate
	[12728]=12641, -- Plans: Invulnerable Mail
	[12819]=12773, -- Plans: Ornate Thorium Handaxe
	[12821]=12774, -- Plans: Dawn's Edge
	[12823]=12775, -- Plans: Huge Thorium Battleaxe
	[12824]=12776, -- Plans: Enchanted Battlehammer
	[12825]=12777, -- Plans: Blazing Rapier
	[12827]=12781, -- Plans: Serenity
	[12828]=12792, -- Plans: Volcanic Hammer
	[12830]=12782, -- Plans: Corruption
	[12833]=12796, -- Plans: Hammer of the Titans
	[12834]=12790, -- Plans: Arcanite Champion
	[12835]=12798, -- Plans: Annihilator
	[12836]=12797, -- Plans: Frostguard
	[12837]=12794, -- Plans: Masterwork Stormhammer
	[12838]=12784, -- Plans: Arcanite Reaper
	[12839]=12783, -- Plans: Heartseeker
	[13287]=54680, -- Pattern: Raptor Hide Harness
	[13288]=4456, -- Pattern: Raptor Hide Belt
	[13308]=4386, -- Schematic: Ice Deflector
	[13309]=4372, -- Schematic: Lovingly Crafted Boomstick
	[13310]=4407, -- Schematic: Accurate Scope
	[13311]=4396, -- Schematic: Mechanical Dragonling
	[13476]=13442, -- Recipe: Mighty Rage Potion
	[13477]=13443, -- Recipe: Superior Mana Potion
	[13478]=13445, -- Recipe: Elixir of Superior Defense
	[13479]=13447, -- Recipe: Elixir of the Sages
	[13480]=13446, -- Recipe: Major Healing Potion
	[13481]=13453, -- Recipe: Elixir of Brute Force
	[13490]=13455, -- Recipe: Greater Stoneshield Potion
	[13491]=13452, -- Recipe: Elixir of the Mongoose
	[13492]=13462, -- Recipe: Purification Potion
	[13493]=13454, -- Recipe: Greater Arcane Elixir
	[13494]=13457, -- Recipe: Greater Fire Protection Potion
	[13495]=13456, -- Recipe: Greater Frost Protection Potion
	[13496]=13458, -- Recipe: Greater Nature Protection Potion
	[13497]=13461, -- Recipe: Greater Arcane Protection Potion
	[13499]=13459, -- Recipe: Greater Shadow Protection Potion
	[13501]=13444, -- Recipe: Major Mana Potion
	[13517]=13503, -- Recipe: Alchemist Stone
	[13518]=13506, -- Recipe: Potion of Petrification
	[13519]=13510, -- Recipe: Flask of the Titans
	[13520]=13511, -- Recipe: Flask of Distilled Wisdom
	[13521]=13512, -- Recipe: Flask of Supreme Power
	[13522]=13513, -- Recipe: Flask of Chromatic Resistance
	[13940]=13927, -- Recipe: Cooked Glossy Mightfish
	[13941]=13930, -- Recipe: Filet of Redgill
	[13943]=13929, -- Recipe: Hot Smoked Bass
	[13947]=13933, -- Recipe: Lobster Stew
	[13948]=13934, -- Recipe: Mightfish Steak
	[13949]=13935, -- Recipe: Baked Salmon
	[14466]=13869, -- Pattern: Frostweave Tunic
	[14467]=13868, -- Pattern: Frostweave Robe
	[14468]=14046, -- Pattern: Runecloth Bag
	[14469]=13858, -- Pattern: Runecloth Robe
	[14470]=13857, -- Pattern: Runecloth Tunic
	[14471]=14042, -- Pattern: Cindercloth Vest
	[14472]=13860, -- Pattern: Runecloth Cloak
	[14473]=14143, -- Pattern: Ghostweave Belt
	[14474]=13870, -- Pattern: Frostweave Gloves
	[14476]=14043, -- Pattern: Cindercloth Gloves
	[14477]=14142, -- Pattern: Ghostweave Gloves
	[14478]=14100, -- Pattern: Brightcloth Robe
	[14479]=14101, -- Pattern: Brightcloth Gloves
	[14480]=14141, -- Pattern: Ghostweave Vest
	[14481]=13863, -- Pattern: Runecloth Gloves
	[14482]=14044, -- Pattern: Cindercloth Cloak
	[14483]=14107, -- Pattern: Felcloth Pants
	[14484]=14103, -- Pattern: Brightcloth Cloak
	[14485]=14132, -- Pattern: Wizardweave Leggings
	[14486]=14134, -- Pattern: Cloak of Fire
	[14488]=13864, -- Pattern: Runecloth Boots
	[14489]=13871, -- Pattern: Frostweave Pants
	[14490]=14045, -- Pattern: Cindercloth Pants
	[14491]=13865, -- Pattern: Runecloth Pants
	[14492]=14108, -- Pattern: Felcloth Boots
	[14493]=14136, -- Pattern: Robe of Winter Night
	[14494]=14104, -- Pattern: Brightcloth Pants
	[14495]=14144, -- Pattern: Ghostweave Pants
	[14496]=14111, -- Pattern: Felcloth Hood
	[14497]=14137, -- Pattern: Mooncloth Leggings
	[14498]=13866, -- Pattern: Runecloth Headband
	[14499]=14155, -- Pattern: Mooncloth Bag
	[14500]=14128, -- Pattern: Wizardweave Robe
	[14501]=14138, -- Pattern: Mooncloth Vest
	[14504]=13867, -- Pattern: Runecloth Shoulders
	[14505]=14130, -- Pattern: Wizardweave Turban
	[14506]=14106, -- Pattern: Felcloth Robe
	[14507]=14139, -- Pattern: Mooncloth Shoulders
	[14508]=14112, -- Pattern: Felcloth Shoulders
	[14509]=14140, -- Pattern: Mooncloth Circlet
	[14510]=14156, -- Pattern: Bottomless Bag
	[14511]=14146, -- Pattern: Gloves of Spell Mastery
	[14512]=14154, -- Pattern: Truefaith Vestments
	[14513]=14152, -- Pattern: Robe of the Archmage
	[14514]=14153, -- Pattern: Robe of the Void
	[14526]=14342, -- Pattern: Mooncloth
	[14627]=4332, -- Pattern: Bright Yellow Shirt
	[14630]=4322, -- Pattern: Enchanter's Cowl
	[14634]=3829, -- Recipe: Frost Oil
	[14635]=4262, -- Pattern: Gem-Studded Leather Belt
	[14639]=4381, -- Schematic: Minor Recombobulator
	[15724]=15077, -- Pattern: Heavy Scorpid Bracers
	[15725]=15083, -- Pattern: Wicked Leather Gauntlets
	[15726]=15045, -- Pattern: Green Dragonscale Breastplate
	[15727]=15076, -- Pattern: Heavy Scorpid Vest
	[15728]=15084, -- Pattern: Wicked Leather Bracers
	[15729]=15074, -- Pattern: Chimeric Gloves
	[15730]=15047, -- Pattern: Red Dragonscale Breastplate
	[15731]=15091, -- Pattern: Runic Leather Gauntlets
	[15732]=15054, -- Pattern: Volcanic Leggings
	[15733]=15046, -- Pattern: Green Dragonscale Leggings
	[15734]=15061, -- Pattern: Living Shoulders
	[15735]=15067, -- Pattern: Ironfeather Shoulders
	[15737]=15073, -- Pattern: Chimeric Boots
	[15738]=15078, -- Pattern: Heavy Scorpid Gauntlets
	[15739]=15092, -- Pattern: Runic Leather Bracers
	[15740]=15071, -- Pattern: Frostsaber Boots
	[15741]=15057, -- Pattern: Stormshroud Pants
	[15742]=15064, -- Pattern: Warbear Harness
	[15743]=15082, -- Pattern: Heavy Scorpid Belt
	[15744]=15086, -- Pattern: Wicked Leather Headband
	[15745]=15093, -- Pattern: Runic Leather Belt
	[15746]=15072, -- Pattern: Chimeric Leggings
	[15747]=15069, -- Pattern: Frostsaber Leggings
	[15748]=15079, -- Pattern: Heavy Scorpid Leggings
	[15749]=15053, -- Pattern: Volcanic Breastplate
	[15751]=15048, -- Pattern: Blue Dragonscale Breastplate
	[15752]=54723, -- Pattern: Living Leggings
	[15753]=54655, -- Pattern: Stormshroud Armor
	[15754]=15065, -- Pattern: Warbear Woolies
	[15755]=15075, -- Pattern: Chimeric Vest
	[15756]=15094, -- Pattern: Runic Leather Headband
	[15757]=15087, -- Pattern: Wicked Leather Pants
	[15758]=15063, -- Pattern: Devilsaur Gauntlets
	[15759]=15050, -- Pattern: Black Dragonscale Breastplate
	[15760]=15066, -- Pattern: Ironfeather Breastplate
	[15761]=15070, -- Pattern: Frostsaber Gloves
	[15762]=15080, -- Pattern: Heavy Scorpid Helm
	[15763]=15049, -- Pattern: Blue Dragonscale Shoulders
	[15764]=15058, -- Pattern: Stormshroud Shoulders
	[15765]=15095, -- Pattern: Runic Leather Pants
	[15768]=15088, -- Pattern: Wicked Leather Belt
	[15770]=15051, -- Pattern: Black Dragonscale Shoulders
	[15771]=15059, -- Pattern: Living Breastplate
	[15772]=15062, -- Pattern: Devilsaur Leggings
	[15773]=15085, -- Pattern: Wicked Leather Armor
	[15774]=15081, -- Pattern: Heavy Scorpid Shoulders
	[15775]=15055, -- Pattern: Volcanic Shoulders
	[15776]=15090, -- Pattern: Runic Leather Armor
	[15777]=15096, -- Pattern: Runic Leather Shoulders
	[15779]=15068, -- Pattern: Frostsaber Tunic
	[15781]=15052, -- Pattern: Black Dragonscale Leggings
	[16041]=15993, -- Schematic: Thorium Grenade
	[16042]=15994, -- Schematic: Thorium Widget
	[16043]=15995, -- Schematic: Thorium Rifle
	[16044]=15996, -- Schematic: Lifelike Mechanical Toad
	[16045]=15999, -- Schematic: Spellpower Goggles Xtreme Plus
	[16046]=16023, -- Schematic: Masterwork Target Dummy
	[16047]=16000, -- Schematic: Thorium Tube
	[16048]=16004, -- Schematic: Dark Iron Rifle
	[16049]=16005, -- Schematic: Dark Iron Bomb
	[16050]=16006, -- Schematic: Delicate Arcanite Converter
	[16052]=16009, -- Schematic: Voice Amplification Modulator
	[16053]=16008, -- Schematic: Master Engineer's Goggles
	[16054]=16022, -- Schematic: Arcanite Dragonling
	[16055]=16040, -- Schematic: Arcane Bomb
	[16056]=16007, -- Schematic: Flawless Arcanite Rifle
	[16110]=12218, -- Recipe: Monster Omelet
	[16111]=12216, -- Recipe: Spiced Chili Crab
	[16767]=16766, -- Recipe: Undermine Clam Chowder
	[17017]=16980, -- Pattern: Flarecore Mantle
	[17018]=16979, -- Pattern: Flarecore Gloves
	[17022]=16982, -- Pattern: Corehound Boots
	[17023]=16983, -- Pattern: Molten Helm
	[17025]=16984, -- Pattern: Black Dragonscale Boots
	[17049]=16989, -- Plans: Fiery Chain Girdle
	[17051]=17014, -- Plans: Dark Iron Bracers
	[17052]=17013, -- Plans: Dark Iron Leggings
	[17053]=16988, -- Plans: Fiery Chain Shoulders
	[17059]=17015, -- Plans: Dark Iron Reaver
	[17060]=17016, -- Plans: Dark Iron Destroyer
	[17062]=8364, -- Recipe: Mithril Head Trout
	[17200]=17197, -- Recipe: Gingerbread Cookie
	[17201]=17198, -- Recipe: Egg Nog
	[17706]=17704, -- Plans: Edge of Winter
	[17709]=17708, -- Recipe: Elixir of Frost Power
	[17720]=17716, -- Schematic: Snowmaster 9000
	[17722]=17721, -- Pattern: Gloves of the Greatfather
	[17724]=17723, -- Pattern: Green Holiday Shirt
	[18046]=18045, -- Recipe: Tender Wolf Steak
	[18160]=7676, -- Recipe: Thistle Tea
	[18239]=18238, -- Pattern: Shadowskin Gloves
	[18252]=18251, -- Pattern: Core Armor Kit
	[18257]=18253, -- Recipe: Major Rejuvenation Potion
	[18264]=18262, -- Plans: Elemental Sharpening Stone
	[18265]=18263, -- Pattern: Flarecore Wraps
	[18267]=18254, -- Recipe: Runn Tum Tuber Surprise
	[18290]=18283, -- Schematic: Biznicks 247x128 Accurascope
	[18291]=18168, -- Schematic: Force Reactive Disk
	[18292]=18282, -- Schematic: Core Marksman Rifle
	[18414]=18405, -- Pattern: Belt of the Archmage
	[18415]=18407, -- Pattern: Felcloth Gloves
	[18416]=18408, -- Pattern: Inferno Gloves
	[18417]=18409, -- Pattern: Mooncloth Gloves
	[18418]=18413, -- Pattern: Cloak of Warding
	[18487]=18486, -- Pattern: Mooncloth Robe
	[18514]=18504, -- Pattern: Girdle of Insight
	[18515]=18506, -- Pattern: Mongoose Boots
	[18516]=18508, -- Pattern: Swift Flight Bracers
	[18517]=18509, -- Pattern: Chromatic Cloak
	[18518]=18510, -- Pattern: Hide of the Wild
	[18519]=18511, -- Pattern: Shifting Cloak
	[18592]=17193, -- Plans: Sulfuron Hammer
	[18647]=9318, -- Schematic: Red Firework
	[18648]=9313, -- Schematic: Green Firework
	[18649]=9312, -- Schematic: Blue Firework
	[18650]=18588, -- Schematic: EZ-Thro Dynamite II
	[18651]=18631, -- Schematic: Truesilver Transformer
	[18652]=18634, -- Schematic: Gyrofreeze Ice Reflector
	[18653]=18587, -- Schematic: Goblin Jumper Cables XL
	[18654]=18645, -- Schematic: Gnomish Alarm-o-Bot
	[18655]=18637, -- Schematic: Major Recombobulator
	[18656]=18594, -- Schematic: Powerful Seaforium Charge
	[18657]=18638, -- Schematic: Hyper-Radiant Flame Reflector
	[18658]=18639, -- Schematic: Ultra-Flash Shadow Reflector
	[18661]=18660, -- Schematic: World Enlarger
	[18731]=18662, -- Pattern: Heavy Leather Ball
	[18949]=18948, -- Pattern: Barbaric Bracers
	[19027]=19026, -- Schematic: Snake Burst Firework
	[19202]=19043, -- Plans: Heavy Timbermaw Belt
	[19203]=19051, -- Plans: Girdle of the Dawn
	[19204]=19048, -- Plans: Heavy Timbermaw Boots
	[19205]=19057, -- Plans: Gloves of the Dawn
	[19206]=19148, -- Plans: Dark Iron Helm
	[19207]=19164, -- Plans: Dark Iron Gauntlets
	[19208]=19166, -- Plans: Black Amnesty
	[19209]=19167, -- Plans: Blackfury
	[19210]=19170, -- Plans: Ebon Hand
	[19211]=19168, -- Plans: Blackguard
	[19212]=19169, -- Plans: Nightfall
	[19215]=19047, -- Pattern: Wisdom of the Timbermaw
	[19216]=19056, -- Pattern: Argent Boots
	[19217]=19059, -- Pattern: Argent Shoulders
	[19218]=19050, -- Pattern: Mantle of the Timbermaw
	[19219]=19156, -- Pattern: Flarecore Robe
	[19220]=19165, -- Pattern: Flarecore Leggings
	[19326]=19044, -- Pattern: Might of the Timbermaw
	[19327]=19049, -- Pattern: Timbermaw Brawlers
	[19328]=19052, -- Pattern: Dawn Treaders
	[19329]=19058, -- Pattern: Golden Mantle of the Dawn
	[19330]=19149, -- Pattern: Lava Belt
	[19331]=19157, -- Pattern: Chromatic Gauntlets
	[19332]=19162, -- Pattern: Corehound Belt
	[19333]=19163, -- Pattern: Molten Belt
	[20013]=20008, -- Recipe: Living Action Potion
	[20040]=20039, -- Plans: Dark Iron Boots
	[20075]=20074, -- Recipe: Heavy Crocolisk Stew
	[20253]=15064, -- Pattern: Warbear Harness
	[20254]=15065, -- Pattern: Warbear Woolies
	[20382]=20380, -- Pattern: Dreamscale Breastplate
	[20506]=20481, -- Pattern: Spitfire Bracers
	[20507]=20480, -- Pattern: Spitfire Gauntlets
	[20508]=20479, -- Pattern: Spitfire Breastplate
	[20509]=20476, -- Pattern: Sandstalker Bracers
	[20510]=20477, -- Pattern: Sandstalker Gauntlets
	[20511]=20478, -- Pattern: Sandstalker Breastplate
	[20546]=20538, -- Pattern: Runed Stygian Leggings
	[20547]=20537, -- Pattern: Runed Stygian Boots
	[20548]=20539, -- Pattern: Runed Stygian Belt
	[20553]=20549, -- Plans: Darkrune Gauntlets
	[20554]=20550, -- Plans: Darkrune Breastplate
	[20555]=20551, -- Plans: Darkrune Helm
	[20576]=20575, -- Pattern: Black Whelp Tunic
	[20854]=20830, -- Design: Amulet of the Moon
	[20855]=20833, -- Design: Wicked Moonstone Ring
	[20856]=20831, -- Design: Heavy Golden Necklace of Battle
	[20970]=20950, -- Design: Pendant of the Agate Shield
	[20971]=20954, -- Design: Heavy Iron Knuckles
	[20973]=20958, -- Design: Blazing Citrine Ring
	[20974]=20966, -- Design: Jade Pendant of Blasting
	[20975]=20959, -- Design: The Jade Eye
	[20976]=20967, -- Design: Citrine Pendant of Golden Healing
	[21025]=21023, -- Recipe: Dirge's Kickin' Chimaerok Chops
	[21099]=21072, -- Recipe: Smoked Sagefish
	[21219]=21217, -- Recipe: Sagefish Delight
	[21358]=21340, -- Pattern: Soul Pouch
	[21371]=21342, -- Pattern: Core Felcloth Bag
	[21547]=21546, -- Recipe: Elixir of Greater Firepower
	[21548]=21278, -- Pattern: Stormshroud Gloves
	[21722]=21154, -- Pattern: Festival Dress
	[21723]=21542, -- Pattern: Festival Suit
	[21724]=21558, -- Schematic: Small Blue Rocket
	[21725]=21559, -- Schematic: Small Green Rocket
	[21726]=21557, -- Schematic: Small Red Rocket
	[21727]=21589, -- Schematic: Large Blue Rocket
	[21728]=21590, -- Schematic: Large Green Rocket
	[21729]=21592, -- Schematic: Large Red Rocket
	[21730]=21571, -- Schematic: Blue Rocket Cluster
	[21731]=21574, -- Schematic: Green Rocket Cluster
	[21732]=21576, -- Schematic: Red Rocket Cluster
	[21733]=21714, -- Schematic: Large Blue Rocket Cluster
	[21734]=21716, -- Schematic: Large Green Rocket Cluster
	[21735]=21718, -- Schematic: Large Red Rocket Cluster
	[21737]=21570, -- Schematic: Cluster Launcher
	[21738]=21569, -- Schematic: Firework Launcher
	[21892]=21842, -- Pattern: Bolt of Imbued Netherweave
	[21893]=21843, -- Pattern: Imbued Netherweave Bag
	[21894]=21844, -- Pattern: Bolt of Soulcloth
	[21895]=21845, -- Pattern: Primal Mooncloth
	[21896]=21854, -- Pattern: Netherweave Robe
	[21897]=21855, -- Pattern: Netherweave Tunic
	[21898]=21859, -- Pattern: Imbued Netherweave Pants
	[21899]=21860, -- Pattern: Imbued Netherweave Boots
	[21900]=21861, -- Pattern: Imbued Netherweave Robe
	[21901]=21862, -- Pattern: Imbued Netherweave Tunic
	[21902]=21863, -- Pattern: Soulcloth Gloves
	[21903]=21864, -- Pattern: Soulcloth Shoulders
	[21904]=21865, -- Pattern: Soulcloth Vest
	[21905]=21866, -- Pattern: Arcanoweave Bracers
	[21906]=21867, -- Pattern: Arcanoweave Boots
	[21907]=21868, -- Pattern: Arcanoweave Robe
	[21908]=21846, -- Pattern: Spellfire Belt
	[21909]=21847, -- Pattern: Spellfire Gloves
	[21910]=21848, -- Pattern: Spellfire Robe
	[21911]=21858, -- Pattern: Spellfire Bag
	[21912]=21869, -- Pattern: Frozen Shadoweave Shoulders
	[21913]=21871, -- Pattern: Frozen Shadoweave Robe
	[21914]=21870, -- Pattern: Frozen Shadoweave Boots
	[21915]=21872, -- Pattern: Ebon Shadowbag
	[21916]=21873, -- Pattern: Primal Mooncloth Belt
	[21917]=21875, -- Pattern: Primal Mooncloth Robe
	[21918]=21874, -- Pattern: Primal Mooncloth Shoulders
	[21919]=21876, -- Pattern: Primal Mooncloth Bag
	[21940]=21756, -- Design: Golden Hare
	[21941]=21758, -- Design: Black Pearl Panther
	[21942]=20969, -- Design: Ruby Crown of Restoration
	[21943]=21760, -- Design: Truesilver Crab
	[21944]=21763, -- Design: Truesilver Boar
	[21945]=21754, -- Design: The Aquamarine Ward
	[21947]=21753, -- Design: Gem Studded Band
	[21948]=21766, -- Design: Opal Necklace of Impact
	[21949]=21769, -- Design: Ruby Serpent
	[21952]=21774, -- Design: Emerald Crown of Destruction
	[21953]=21777, -- Design: Emerald Owl
	[21954]=21778, -- Design: Ring of Bitter Shadows
	[21955]=21784, -- Design: Black Diamond Crab
	[21956]=21789, -- Design: Dark Iron Scorpid
	[21957]=21792, -- Design: Necklace of the Diamond Tower
	[22209]=22197, -- Plans: Heavy Obsidian Belt
	[22214]=22195, -- Plans: Light Obsidian Belt
	[22219]=22198, -- Plans: Jagged Obsidian Shield
	[22220]=22194, -- Plans: Black Grasp of the Destroyer
	[22221]=22191, -- Plans: Obsidian Mail Tunic
	[22222]=22196, -- Plans: Thick Obsidian Breastplate
	[22307]=22246, -- Pattern: Enchanted Mageweave Pouch
	[22308]=22248, -- Pattern: Enchanted Runecloth Bag
	[22309]=22249, -- Pattern: Big Bag of Enchantment
	[22310]=22251, -- Pattern: Cenarion Herb Bag
	[22312]=22252, -- Pattern: Satchel of Cenarius
	[22388]=22385, -- Plans: Titanic Leggings
	[22389]=22383, -- Plans: Sageblade
	[22390]=22384, -- Plans: Persuader
	[22647]=22645, -- Recipe: Crunchy Spider Surprise
	[22683]=22660, -- Pattern: Gaea's Embrace
	[22729]=22728, -- Schematic: Steam Tonk Controller
	[22766]=22762, -- Plans: Ironvine Breastplate
	[22767]=22763, -- Plans: Ironvine Gloves
	[22768]=22764, -- Plans: Ironvine Belt
	[22769]=22761, -- Pattern: Bramblewood Belt
	[22770]=22760, -- Pattern: Bramblewood Boots
	[22771]=22759, -- Pattern: Bramblewood Helm
	[22772]=22758, -- Pattern: Sylvan Shoulders
	[22773]=22757, -- Pattern: Sylvan Crown
	[22774]=22756, -- Pattern: Sylvan Vest
	[22900]=22823, -- Recipe: Elixir of Camouflage
	[22901]=22826, -- Recipe: Sneaking Potion
	[22902]=22827, -- Recipe: Elixir of Major Frost Power
	[22903]=22828, -- Recipe: Insane Strength Potion
	[22904]=22830, -- Recipe: Elixir of the Searching Eye
	[22905]=22831, -- Recipe: Elixir of Major Agility
	[22906]=22871, -- Recipe: Shrouding Potion
	[22907]=22832, -- Recipe: Super Mana Potion
	[22908]=22833, -- Recipe: Elixir of Major Firepower
	[22909]=22834, -- Recipe: Elixir of Major Defense
	[22910]=22835, -- Recipe: Elixir of Major Shadow Power
	[22911]=22836, -- Recipe: Major Dreamless Sleep Potion
	[22912]=22837, -- Recipe: Heroic Potion
	[22913]=22838, -- Recipe: Haste Potion
	[22914]=22839, -- Recipe: Destruction Potion
	[22919]=22840, -- Recipe: Elixir of Major Mageblood
	[22920]=22841, -- Recipe: Major Fire Protection Potion
	[22921]=22842, -- Recipe: Major Frost Protection Potion
	[22922]=22844, -- Recipe: Major Nature Protection Potion
	[22923]=22845, -- Recipe: Major Arcane Protection Potion
	[22924]=22846, -- Recipe: Major Shadow Protection Potion
	[22925]=22847, -- Recipe: Major Holy Protection Potion
	[22926]=22848, -- Recipe: Elixir of Empowerment
	[22927]=22849, -- Recipe: Ironshield Potion
	[23130]=27812, -- Design: Brilliant Blood Garnet
	[23131]=23095, -- Design: Bold Blood Garnet
	[23133]=27812, -- Design: Brilliant Blood Garnet
	[23134]=28595, -- Design: Delicate Blood Garnet
	[23135]=23098, -- Design: Inscribed Flame Spessarite
	[23136]=23099, -- Design: Reckless Flame Spessarite
	[23137]=23100, -- Design: Glinting Shadow Draenite
	[23138]=23101, -- Design: Potent Flame Spessarite
	[23140]=23103, -- Design: Radiant Deep Peridot
	[23141]=27820, -- Design: Jagged Deep Peridot
	[23142]=23105, -- Design: Regal Deep Peridot
	[23143]=23109, -- Design: Purified Shadow Draenite
	[23144]=23108, -- Design: Timeless Shadow Draenite
	[23145]=23109, -- Design: Purified Shadow Draenite
	[23146]=23110, -- Design: Shifting Shadow Draenite
	[23147]=23111, -- Design: Sovereign Shadow Draenite
	[23148]=27812, -- Design: Brilliant Blood Garnet
	[23149]=28290, -- Design: Smooth Golden Draenite
	[23150]=23115, -- Design: Subtle Golden Draenite
	[23151]=23116, -- Design: Rigid Azure Moonstone
	[23152]=23118, -- Design: Solid Azure Moonstone
	[23153]=23121, -- Design: Sparkling Azure Moonstone
	[23154]=23120, -- Design: Stormy Azure Moonstone
	[23155]=23121, -- Design: Sparkling Azure Moonstone
	[23590]=23502, -- Plans: Adamantite Maul
	[23591]=23503, -- Plans: Adamantite Cleaver
	[23592]=23504, -- Plans: Adamantite Dagger
	[23593]=23505, -- Plans: Adamantite Rapier
	[23594]=23506, -- Plans: Adamantite Plate Bracers
	[23595]=23508, -- Plans: Adamantite Plate Gloves
	[23596]=23507, -- Plans: Adamantite Breastplate
	[23597]=23510, -- Plans: Enchanted Adamantite Belt
	[23598]=23511, -- Plans: Enchanted Adamantite Boots
	[23599]=23509, -- Plans: Enchanted Adamantite Breastplate
	[23600]=23512, -- Plans: Enchanted Adamantite Leggings
	[23601]=23515, -- Plans: Flamebane Bracers
	[23602]=23516, -- Plans: Flamebane Helm
	[23603]=23514, -- Plans: Flamebane Gloves
	[23604]=23513, -- Plans: Flamebane Breastplate
	[23605]=23517, -- Plans: Felsteel Gloves
	[23606]=23518, -- Plans: Felsteel Leggings
	[23607]=23519, -- Plans: Felsteel Helm
	[23608]=23524, -- Plans: Khorium Belt
	[23609]=23523, -- Plans: Khorium Pants
	[23610]=23525, -- Plans: Khorium Boots
	[23611]=23520, -- Plans: Ragesteel Gloves
	[23612]=23521, -- Plans: Ragesteel Helm
	[23613]=23522, -- Plans: Ragesteel Breastplate
	[23615]=23526, -- Plans: Swiftsteel Gloves
	[23617]=23527, -- Plans: Earthpeace Breastplate
	[23618]=23529, -- Plans: Adamantite Sharpening Stone
	[23619]=23530, -- Plans: Felsteel Shield Spike
	[23620]=23531, -- Plans: Felfury Gauntlets
	[23621]=23532, -- Plans: Gauntlets of the Iron Tower
	[23622]=23533, -- Plans: Steelgrip Gauntlets
	[23623]=23534, -- Plans: Storm Helm
	[23624]=23535, -- Plans: Helm of the Stalwart Defender
	[23625]=23536, -- Plans: Oathkeeper's Helm
	[23626]=23537, -- Plans: Black Felsteel Bracers
	[23627]=23538, -- Plans: Bracers of the Green Fortress
	[23628]=23539, -- Plans: Blessed Bracers
	[23629]=23540, -- Plans: Felsteel Longblade
	[23630]=23541, -- Plans: Khorium Champion
	[23631]=23542, -- Plans: Fel Edged Battleaxe
	[23632]=23543, -- Plans: Felsteel Reaper
	[23633]=23544, -- Plans: Runic Hammer
	[23634]=23546, -- Plans: Fel Hardened Maul
	[23635]=23554, -- Plans: Eternium Runed Blade
	[23636]=23555, -- Plans: Dirge
	[23637]=23556, -- Plans: Hand of Eternity
	[23638]=23575, -- Plans: Lesser Ward of Shielding
	[23639]=23576, -- Plans: Greater Ward of Shielding
	[23799]=23746, -- Schematic: Adamantite Rifle
	[23800]=23747, -- Schematic: Felsteel Boomstick
	[23802]=23748, -- Schematic: Ornate Khorium Rifle
	[23803]=23758, -- Schematic: Cogspinner Goggles
	[23804]=23761, -- Schematic: Power Amplification Goggles
	[23805]=23762, -- Schematic: Ultra-Spectropic Detection Goggles
	[23806]=23763, -- Schematic: Hyper-Vision Goggles
	[23807]=23764, -- Schematic: Adamantite Scope
	[23808]=23765, -- Schematic: Khorium Scope
	[23809]=23766, -- Schematic: Stabilized Eternium Scope
	[23810]=23767, -- Schematic: Crashin' Thrashin' Robot
	[23811]=23768, -- Schematic: White Smoke Flare
	[23814]=23771, -- Schematic: Green Smoke Flare
	[23816]=23774, -- Schematic: Fel Iron Toolbox
	[23817]=23775, -- Schematic: Titanium Toolbox
	[23874]=23819, -- Schematic: Elemental Seaforium Charge
	[23883]=33092, -- Schematic: Healing Potion Injector
	[23884]=33093, -- Schematic: Mana Potion Injector
	[23885]=23840, -- Schematic: Remote Mail Terminal
	[23887]=23824, -- Schematic: Rocket Boots Xtreme
	[23888]=23821, -- Schematic: Zapthrottle Mote Extractor
	[24001]=22831, -- Recipe: Elixir of Major Agility
	[24002]=23530, -- Plans: Felsteel Shield Spike
	[24158]=24079, -- Design: Khorium Band of Shadows
	[24159]=24080, -- Design: Khorium Band of Frost
	[24160]=24082, -- Design: Khorium Inferno Band
	[24161]=24085, -- Design: Khorium Band of Leaves
	[24162]=24086, -- Design: Arcane Khorium Band
	[24163]=24087, -- Design: Heavy Felsteel Ring
	[24164]=24088, -- Design: Delicate Eternium Ring
	[24165]=24089, -- Design: Blazing Eternium Band
	[24166]=24106, -- Design: Thick Felsteel Necklace
	[24167]=24110, -- Design: Living Ruby Pendant
	[24168]=24114, -- Design: Braided Eternium Chain
	[24169]=24116, -- Design: Eye of the Night
	[24170]=24117, -- Design: Embrace of the Dawn
	[24171]=24121, -- Design: Chain of the Twilight Owl
	[24172]=24122, -- Design: Coronet of Verdant Flame
	[24173]=24123, -- Design: Circlet of Arcane Might
	[24174]=24092, -- Design: Pendant of Frozen Flame
	[24175]=24093, -- Design: Pendant of Thawing
	[24176]=24095, -- Design: Pendant of Withering
	[24177]=24097, -- Design: Pendant of Shadow's End
	[24178]=24098, -- Design: Pendant of the Null Rune
	[24179]=24124, -- Design: Felsteel Boar
	[24180]=24125, -- Design: Dawnstone Crab
	[24181]=24126, -- Design: Living Ruby Serpent
	[24182]=24127, -- Design: Talasite Owl
	[24183]=24128, -- Design: Nightseye Panther
	[24192]=24028, -- Design: Delicate Living Ruby
	[24193]=24027, -- Design: Bold Living Ruby
	[24194]=24028, -- Design: Delicate Living Ruby
	[24195]=24030, -- Design: Brilliant Living Ruby
	[24196]=24030, -- Design: Brilliant Living Ruby
	[24197]=24032, -- Design: Subtle Dawnstone
	[24198]=24036, -- Design: Flashing Living Ruby
	[24199]=24033, -- Design: Solid Star of Elune
	[24200]=24035, -- Design: Sparkling Star of Elune
	[24201]=24035, -- Design: Sparkling Star of Elune
	[24202]=24039, -- Design: Stormy Star of Elune
	[24203]=24030, -- Design: Brilliant Living Ruby
	[24204]=24048, -- Design: Smooth Dawnstone
	[24205]=24051, -- Design: Rigid Star of Elune
	[24206]=24048, -- Design: Smooth Dawnstone
	[24207]=24032, -- Design: Subtle Dawnstone
	[24208]=27679, -- Design: Mystic Dawnstone
	[24209]=24054, -- Design: Sovereign Nightseye
	[24210]=24055, -- Design: Shifting Nightseye
	[24211]=24056, -- Design: Timeless Nightseye
	[24212]=24065, -- Design: Purified Nightseye
	[24213]=24058, -- Design: Inscribed Noble Topaz
	[24214]=24059, -- Design: Potent Noble Topaz
	[24215]=24060, -- Design: Reckless Noble Topaz
	[24216]=24061, -- Design: Glinting Nightseye
	[24217]=35707, -- Design: Regal Talasite
	[24218]=24066, -- Design: Radiant Talasite
	[24219]=24065, -- Design: Purified Nightseye
	[24220]=24067, -- Design: Jagged Talasite
	[24292]=24273, -- Pattern: Mystic Spellthread
	[24293]=24275, -- Pattern: Silver Spellthread
	[24294]=24274, -- Pattern: Runic Spellthread
	[24295]=24276, -- Pattern: Golden Spellthread
	[24296]=24249, -- Pattern: Unyielding Bracers
	[24297]=24250, -- Pattern: Bracers of Havok
	[24298]=24251, -- Pattern: Blackstrike Bracers
	[24299]=24252, -- Pattern: Cloak of the Black Void
	[24300]=24253, -- Pattern: Cloak of Eternity
	[24301]=24254, -- Pattern: White Remedy Cape
	[24302]=24255, -- Pattern: Unyielding Girdle
	[24303]=24256, -- Pattern: Girdle of Ruination
	[24304]=24257, -- Pattern: Black Belt of Knowledge
	[24305]=24258, -- Pattern: Resolute Cape
	[24306]=24259, -- Pattern: Vengeance Wrap
	[24307]=24260, -- Pattern: Manaweave Cloak
	[24308]=24261, -- Pattern: Whitemend Pants
	[24309]=24262, -- Pattern: Spellstrike Pants
	[24310]=24263, -- Pattern: Battlecast Pants
	[24311]=24264, -- Pattern: Whitemend Hood
	[24312]=24266, -- Pattern: Spellstrike Hood
	[24313]=24267, -- Pattern: Battlecast Hood
	[24314]=24270, -- Pattern: Bag of Jewels
	[24315]=1, -- Pattern: Heavy Netherweave Net
	[24316]=24271, -- Pattern: Spellcloth
	[25526]=25521, -- Plans: Greater Rune of Warding
	[25720]=23793, -- Pattern: Heavy Knothide Leather
	[25721]=25651, -- Pattern: Vindicator's Armor Kit
	[25722]=25652, -- Pattern: Magister's Armor Kit
	[25725]=25653, -- Pattern: Riding Crop
	[25726]=25679, -- Pattern: Comfortable Insoles
	[25728]=25680, -- Pattern: Stylin' Purple Hat
	[25729]=25681, -- Pattern: Stylin' Adventure Hat
	[25730]=25682, -- Pattern: Stylin' Jungle Hat
	[25731]=25683, -- Pattern: Stylin' Crimson Hat
	[25732]=25685, -- Pattern: Fel Leather Gloves
	[25733]=25686, -- Pattern: Fel Leather Boots
	[25734]=25687, -- Pattern: Fel Leather Leggings
	[25735]=25689, -- Pattern: Heavy Clefthoof Vest
	[25736]=25690, -- Pattern: Heavy Clefthoof Leggings
	[25737]=25691, -- Pattern: Heavy Clefthoof Boots
	[25738]=25695, -- Pattern: Felstalker Belt
	[25739]=25697, -- Pattern: Felstalker Bracers
	[25740]=25696, -- Pattern: Felstalker Breastplate
	[25741]=25694, -- Pattern: Netherfury Belt
	[25742]=25692, -- Pattern: Netherfury Leggings
	[25743]=25693, -- Pattern: Netherfury Boots
	[25846]=25844, -- Plans: Adamantite Rod
	[25847]=25845, -- Plans: Eternium Rod
	[25887]=25886, -- Schematic: Purple Smoke Flare
	[25902]=25896, -- Design: Powerful Earthstorm Diamond
	[25903]=25897, -- Design: Bracing Earthstorm Diamond
	[25904]=25901, -- Design: Insightful Earthstorm Diamond
	[25905]=25898, -- Design: Tenacious Earthstorm Diamond
	[25906]=25899, -- Design: Brutal Earthstorm Diamond
	[25907]=25890, -- Design: Destructive Skyfire Diamond
	[25908]=25894, -- Design: Swift Skyfire Diamond
	[25909]=25893, -- Design: Mystical Skyfire Diamond
	[25910]=25895, -- Design: Enigmatic Skyfire Diamond
	[27684]=27651, -- Recipe: Buzzard Bites
	[27685]=27635, -- Recipe: Lynx Steak
	[27686]=24105, -- Recipe: Roasted Moongraze Tenderloin
	[27687]=27636, -- Recipe: Bat Bites
	[27688]=27655, -- Recipe: Ravager Dog
	[27690]=27657, -- Recipe: Blackened Basilisk
	[27691]=27658, -- Recipe: Roasted Clefthoof
	[27692]=27659, -- Recipe: Warp Burger
	[27693]=27660, -- Recipe: Talbuk Steak
	[27694]=27661, -- Recipe: Blackened Trout
	[27695]=27662, -- Recipe: Feltail Delight
	[27696]=27663, -- Recipe: Blackened Sporefish
	[27697]=27664, -- Recipe: Grilled Mudfish
	[27698]=27665, -- Recipe: Poached Bluefish
	[27699]=27666, -- Recipe: Golden Fish Sticks
	[27700]=27667, -- Recipe: Spicy Crawdad
	[28291]=28290, -- Design: Smooth Golden Draenite
	[28596]=28595, -- Design: Delicate Blood Garnet
	[28632]=28421, -- Plans: Adamantite Weightstone
	[29213]=25695, -- Pattern: Felstalker Belt
	[29214]=25697, -- Pattern: Felstalker Bracers
	[29215]=25696, -- Pattern: Felstalker Breastplate
	[29217]=25694, -- Pattern: Netherfury Belt
	[29218]=25693, -- Pattern: Netherfury Boots
	[29219]=25692, -- Pattern: Netherfury Leggings
	[29664]=29540, -- Pattern: Reinforced Mining Bag
	[29669]=29483, -- Pattern: Shadow Armor Kit
	[29672]=29485, -- Pattern: Flame Armor Kit
	[29673]=29486, -- Pattern: Frost Armor Kit
	[29674]=29487, -- Pattern: Nature Armor Kit
	[29675]=29488, -- Pattern: Arcane Armor Kit
	[29677]=29489, -- Pattern: Enchanted Felscale Leggings
	[29682]=29490, -- Pattern: Enchanted Felscale Gloves
	[29684]=29491, -- Pattern: Enchanted Felscale Boots
	[29689]=29492, -- Pattern: Flamescale Leggings
	[29691]=29493, -- Pattern: Flamescale Boots
	[29693]=29494, -- Pattern: Flamescale Belt
	[29698]=29495, -- Pattern: Enchanted Clefthoof Leggings
	[29700]=29496, -- Pattern: Enchanted Clefthoof Gloves
	[29701]=29497, -- Pattern: Enchanted Clefthoof Boots
	[29702]=29498, -- Pattern: Blastguard Pants
	[29703]=29499, -- Pattern: Blastguard Boots
	[29704]=29500, -- Pattern: Blastguard Belt
	[29713]=29532, -- Pattern: Drums of Panic
	[29714]=29531, -- Pattern: Drums of Restoration
	[29717]=29529, -- Pattern: Drums of Battle
	[29718]=29530, -- Pattern: Drums of Speed
	[29719]=29533, -- Pattern: Cobrahide Leg Armor
	[29720]=29534, -- Pattern: Clefthide Leg Armor
	[29721]=29536, -- Pattern: Nethercleft Leg Armor
	[29722]=29535, -- Pattern: Nethercobra Leg Armor
	[29723]=29502, -- Pattern: Cobrascale Hood
	[29724]=29503, -- Pattern: Cobrascale Gloves
	[29725]=29504, -- Pattern: Windscale Hood
	[29726]=29505, -- Pattern: Hood of Primal Life
	[29727]=29506, -- Pattern: Gloves of the Living Touch
	[29728]=29507, -- Pattern: Windslayer Wraps
	[29729]=29508, -- Pattern: Living Dragonscale Helm
	[29730]=29512, -- Pattern: Earthen Netherscale Boots
	[29731]=29509, -- Pattern: Windstrike Gloves
	[29732]=29510, -- Pattern: Netherdrake Helm
	[29733]=29511, -- Pattern: Netherdrake Gloves
	[29734]=29514, -- Pattern: Thick Netherscale Breastplate
	[30156]=30155, -- Recipe: Clam Bar
	[30280]=30038, -- Pattern: Belt of Blasting
	[30281]=30036, -- Pattern: Belt of the Long Road
	[30282]=30037, -- Pattern: Boots of Blasting
	[30283]=30035, -- Pattern: Boots of the Long Road
	[30301]=30042, -- Pattern: Belt of Natural Power
	[30302]=30040, -- Pattern: Belt of Deep Shadow
	[30303]=30046, -- Pattern: Belt of the Black Eagle
	[30304]=30044, -- Pattern: Monsoon Belt
	[30305]=30041, -- Pattern: Boots of Natural Grace
	[30306]=30039, -- Pattern: Boots of Utter Darkness
	[30307]=30045, -- Pattern: Boots of the Crimson Hawk
	[30308]=30043, -- Pattern: Hurricane Boots
	[30321]=30034, -- Plans: Belt of the Guardian
	[30322]=30032, -- Plans: Red Belt of Battle
	[30323]=30033, -- Plans: Boots of the Protector
	[30324]=30031, -- Plans: Red Havoc Boots
	[30444]=29540, -- Pattern: Reinforced Mining Bag
	[30483]=24272, -- Pattern: Shadowcloth
	[30826]=30825, -- Design: Ring of Arcane Shielding
	[30833]=30831, -- Pattern: Cloak of Arcane Evasion
	[30842]=30837, -- Pattern: Flameheart Bracers
	[30843]=30838, -- Pattern: Flameheart Gloves
	[30844]=30839, -- Pattern: Flameheart Vest
	[31354]=13510, -- Recipe: Flask of the Titans
	[31355]=13512, -- Recipe: Flask of Supreme Power
	[31356]=13511, -- Recipe: Flask of Distilled Wisdom
	[31357]=13513, -- Recipe: Flask of Chromatic Resistance
	[31358]=24125, -- Design: Dawnstone Crab
	[31359]=23105, -- Design: Regal Deep Peridot
	[31361]=29533, -- Pattern: Cobrahide Leg Armor
	[31362]=29535, -- Pattern: Nethercobra Leg Armor
	[31390]=31364, -- Plans: Wildguard Breastplate
	[31391]=31367, -- Plans: Wildguard Leggings
	[31392]=31368, -- Plans: Wildguard Helm
	[31393]=31369, -- Plans: Iceguard Breastplate
	[31394]=31370, -- Plans: Iceguard Leggings
	[31395]=31371, -- Plans: Iceguard Helm
	[31401]=31398, -- Design: The Frozen Eye
	[31402]=31399, -- Design: The Natural Ward
	[31674]=31673, -- Recipe: Crunchy Serpent
	[31675]=31672, -- Recipe: Mok'Nathal Shortribs
	[31680]=31679, -- Recipe: Fel Strength Elixir
	[31681]=31676, -- Recipe: Fel Regeneration Potion
	[31682]=31677, -- Recipe: Fel Mana Potion
	[31870]=23116, -- Design: Rigid Azure Moonstone
	[31871]=23110, -- Design: Shifting Shadow Draenite
	[31872]=23110, -- Design: Shifting Shadow Draenite
	[31873]=31866, -- Design: Veiled Shadow Draenite
	[31874]=31869, -- Design: Deadly Flame Spessarite
	[31875]=24051, -- Design: Rigid Star of Elune
	[31876]=24055, -- Design: Shifting Nightseye
	[31877]=24061, -- Design: Glinting Nightseye
	[31878]=31867, -- Design: Veiled Nightseye
	[31879]=31868, -- Design: Deadly Noble Topaz
	[32070]=32063, -- Recipe: Earthen Elixir
	[32071]=32068, -- Recipe: Elixir of Ironskin
	[32274]=32193, -- Design: Bold Crimson Spinel
	[32277]=35487, -- Design: Delicate Crimson Spinel
	[32281]=35488, -- Design: Brilliant Crimson Spinel
	[32282]=35488, -- Design: Brilliant Crimson Spinel
	[32283]=35487, -- Design: Delicate Crimson Spinel
	[32284]=32198, -- Design: Subtle Lionseye
	[32285]=32199, -- Design: Flashing Crimson Spinel
	[32286]=32200, -- Design: Solid Empyrean Sapphire
	[32287]=32201, -- Design: Sparkling Empyrean Sapphire
	[32288]=32201, -- Design: Sparkling Empyrean Sapphire
	[32289]=32203, -- Design: Stormy Empyrean Sapphire
	[32290]=35488, -- Design: Brilliant Crimson Spinel
	[32291]=32205, -- Design: Smooth Lionseye
	[32292]=32206, -- Design: Rigid Empyrean Sapphire
	[32293]=32205, -- Design: Smooth Lionseye
	[32294]=32198, -- Design: Subtle Lionseye
	[32295]=32209, -- Design: Mystic Lionseye
	[32296]=32206, -- Design: Rigid Empyrean Sapphire
	[32297]=32211, -- Design: Sovereign Shadowsong Amethyst
	[32298]=32212, -- Design: Shifting Shadowsong Amethyst
	[32299]=32212, -- Design: Shifting Shadowsong Amethyst
	[32300]=32220, -- Design: Glinting Shadowsong Amethyst
	[32301]=32215, -- Design: Timeless Shadowsong Amethyst
	[32302]=32225, -- Design: Purified Shadowsong Amethyst
	[32303]=32217, -- Design: Inscribed Pyrestone
	[32304]=32218, -- Design: Potent Pyrestone
	[32305]=35760, -- Design: Reckless Pyrestone
	[32306]=32220, -- Design: Glinting Shadowsong Amethyst
	[32307]=32221, -- Design: Veiled Shadowsong Amethyst
	[32308]=32222, -- Design: Deadly Pyrestone
	[32309]=32223, -- Design: Regal Seaspray Emerald
	[32310]=32224, -- Design: Radiant Seaspray Emerald
	[32311]=32225, -- Design: Purified Shadowsong Amethyst
	[32312]=32226, -- Design: Jagged Seaspray Emerald
	[32381]=7191, -- Schematic: Fused Wiring
	[32411]=32410, -- Design: Thundering Skyfire Diamond
	[32412]=32409, -- Design: Relentless Earthstorm Diamond
	[32429]=32398, -- Pattern: Boots of Shackled Souls
	[32430]=32399, -- Pattern: Bracers of Shackled Souls
	[32431]=32400, -- Pattern: Greaves of Shackled Souls
	[32432]=32397, -- Pattern: Waistguard of Shackled Souls
	[32433]=32394, -- Pattern: Redeemed Soul Moccasins
	[32434]=32395, -- Pattern: Redeemed Soul Wristguards
	[32435]=32396, -- Pattern: Redeemed Soul Legguards
	[32436]=32393, -- Pattern: Redeemed Soul Cinch
	[32437]=32391, -- Pattern: Soulguard Slippers
	[32438]=32392, -- Pattern: Soulguard Bracers
	[32439]=32389, -- Pattern: Soulguard Leggings
	[32440]=32390, -- Pattern: Soulguard Girdle
	[32441]=32402, -- Plans: Shadesteel Sabots
	[32442]=32403, -- Plans: Shadesteel Bracers
	[32443]=32404, -- Plans: Shadesteel Greaves
	[32444]=32401, -- Plans: Shadesteel Girdle
	[32447]=32420, -- Pattern: Night's End
	[32736]=32568, -- Plans: Swiftsteel Bracers
	[32737]=32570, -- Plans: Swiftsteel Shoulders
	[32738]=32571, -- Plans: Dawnsteel Bracers
	[32739]=32573, -- Plans: Dawnsteel Shoulders
	[32744]=32582, -- Pattern: Bracers of Renewed Life
	[32745]=32583, -- Pattern: Shoulderpads of Renewed Life
	[32746]=32580, -- Pattern: Swiftstrike Bracers
	[32747]=32581, -- Pattern: Swiftstrike Shoulders
	[32748]=32574, -- Pattern: Bindings of Lightning Reflexes
	[32749]=32575, -- Pattern: Shoulders of Lightning Reflexes
	[32750]=32577, -- Pattern: Living Earth Bindings
	[32751]=32579, -- Pattern: Living Earth Shoulders
	[32752]=32584, -- Pattern: Swiftheal Wraps
	[32753]=32585, -- Pattern: Swiftheal Mantle
	[32754]=32586, -- Pattern: Bracers of Nimble Thought
	[32755]=32587, -- Pattern: Mantle of Nimble Thought
	[33124]=33122, -- Pattern: Cloak of Darkness
	[33155]=33134, -- Design: Kailee's Rose
	[33156]=33131, -- Design: Crimson Sun
	[33157]=33135, -- Design: Falling Star
	[33158]=33143, -- Design: Stone of Blades
	[33159]=33140, -- Design: Blood of Amber
	[33160]=33144, -- Design: Facet of Eternity
	[33174]=33173, -- Plans: Ragesteel Shoulders
	[33186]=33185, -- Plans: Adamantite Weapon Chain
	[33205]=33204, -- Pattern: Shadowprowler's Chestguard
	[33209]=33208, -- Recipe: Flask of Chromatic Wonder
	[33305]=33133, -- Design: Don Julio's Heart
	[33622]=32409, -- Design: Relentless Earthstorm Diamond
	[33783]=33782, -- Design: Steady Talasite
	[33792]=33791, -- Plans: Heavy Copper Longsword
	[33869]=33867, -- Recipe: Broiled Bloodfin
	[33870]=33825, -- Recipe: Skullfish Soup
	[33871]=33866, -- Recipe: Stormchops
	[33873]=33872, -- Recipe: Spicy Hot Talbuk
	[33875]=33874, -- Recipe: Kibler's Bits
	[33925]=33924, -- Recipe: Delicious Chocolate Cake
	[33954]=32854, -- Plans: Hammer of Righteous Might
	[34114]=34113, -- Schematic: Field Repair Bot 110G
	[34126]=34125, -- Recipe: Shoveltusk Soup
	[34172]=29530, -- Pattern: Drums of Speed
	[34173]=29530, -- Pattern: Drums of Speed
	[34174]=29531, -- Pattern: Drums of Restoration
	[34175]=29531, -- Pattern: Drums of Restoration
	[34261]=34087, -- Pattern: Green Winter Clothes
	[34262]=34086, -- Pattern: Winter Boots
	[34319]=34085, -- Pattern: Red Winter Clothes
	[34413]=34411, -- Recipe: Hot Apple Cider
	[34491]=34490, -- Pattern: Bag of Many Hides
	[34689]=34220, -- Design: Chaotic Skyfire Diamond
	[34834]=34832, -- Recipe: Captain Rumsey's Lager
	[35186]=34847, -- Schematic: Annihilator Holo-Gogs
	[35187]=35185, -- Schematic: Justicebringer 3000 Specs
	[35189]=35181, -- Schematic: Powerheal 9000 Lens
	[35190]=35182, -- Schematic: Hyper-Magnified Moon Specs
	[35191]=35183, -- Schematic: Wonderheal XT68 Shades
	[35192]=35184, -- Schematic: Primal-Attuned Goggles
	[35193]=34355, -- Schematic: Lightning Etched Specs
	[35194]=34356, -- Schematic: Surestrike Goggles v3.0
	[35195]=34354, -- Schematic: Mayhem Projection Goggles
	[35196]=34357, -- Schematic: Hard Khorium Goggles
	[35197]=34353, -- Schematic: Quad Deathblow X44 Goggles
	[35198]=34362, -- Design: Loop of Forged Power
	[35199]=34363, -- Design: Ring of Flowing Life
	[35200]=34361, -- Design: Hard Khorium Band
	[35201]=34359, -- Design: Pendant of Sunfire
	[35202]=34360, -- Design: Amulet of Flowing Life
	[35203]=34358, -- Design: Hard Khorium Choker
	[35204]=34366, -- Pattern: Sunfire Handwraps
	[35205]=34367, -- Pattern: Hands of Eternal Light
	[35206]=34364, -- Pattern: Sunfire Robe
	[35207]=34365, -- Pattern: Robe of Eternal Light
	[35208]=34380, -- Plans: Sunblessed Gauntlets
	[35209]=34378, -- Plans: Hard Khorium Battlefists
	[35210]=34379, -- Plans: Sunblessed Breastplate
	[35211]=34377, -- Plans: Hard Khorium Battleplate
	[35212]=34372, -- Pattern: Leather Gauntlets of the Sun
	[35213]=34374, -- Pattern: Fletcher's Gloves of the Phoenix
	[35214]=34370, -- Pattern: Gloves of Immortal Dusk
	[35215]=34376, -- Pattern: Sun-Drenched Scale Gloves
	[35216]=34371, -- Pattern: Leather Chestguard of the Sun
	[35217]=34373, -- Pattern: Embrace of the Phoenix
	[35218]=34369, -- Pattern: Carapace of Sun and Shadow
	[35219]=34375, -- Pattern: Sun-Drenched Scale Chestguard
	[35238]=32212, -- Design: Shifting Shadowsong Amethyst
	[35239]=32215, -- Design: Timeless Shadowsong Amethyst
	[35240]=32220, -- Design: Glinting Shadowsong Amethyst
	[35241]=32225, -- Design: Purified Shadowsong Amethyst
	[35242]=32212, -- Design: Shifting Shadowsong Amethyst
	[35243]=32211, -- Design: Sovereign Shadowsong Amethyst
	[35244]=32193, -- Design: Bold Crimson Spinel
	[35245]=35487, -- Design: Delicate Crimson Spinel
	[35246]=35487, -- Design: Delicate Crimson Spinel
	[35247]=32199, -- Design: Flashing Crimson Spinel
	[35248]=35488, -- Design: Brilliant Crimson Spinel
	[35249]=32198, -- Design: Subtle Lionseye
	[35250]=35488, -- Design: Brilliant Crimson Spinel
	[35251]=32225, -- Design: Purified Shadowsong Amethyst
	[35252]=32223, -- Design: Regal Seaspray Emerald
	[35253]=32226, -- Design: Jagged Seaspray Emerald
	[35254]=32224, -- Design: Radiant Seaspray Emerald
	[35255]=35488, -- Design: Brilliant Crimson Spinel
	[35256]=32205, -- Design: Smooth Lionseye
	[35257]=32206, -- Design: Rigid Empyrean Sapphire
	[35258]=32209, -- Design: Mystic Lionseye
	[35259]=32206, -- Design: Rigid Empyrean Sapphire
	[35260]=32205, -- Design: Smooth Lionseye
	[35261]=32198, -- Design: Subtle Lionseye
	[35262]=32201, -- Design: Sparkling Empyrean Sapphire
	[35263]=32200, -- Design: Solid Empyrean Sapphire
	[35264]=32201, -- Design: Sparkling Empyrean Sapphire
	[35265]=32203, -- Design: Stormy Empyrean Sapphire
	[35266]=32220, -- Design: Glinting Shadowsong Amethyst
	[35267]=32217, -- Design: Inscribed Pyrestone
	[35268]=35760, -- Design: Reckless Pyrestone
	[35269]=32218, -- Design: Potent Pyrestone
	[35270]=32221, -- Design: Veiled Shadowsong Amethyst
	[35271]=32222, -- Design: Deadly Pyrestone
	[35294]=22848, -- Recipe: Elixir of Empowerment
	[35295]=22838, -- Recipe: Haste Potion
	[35296]=33185, -- Plans: Adamantite Weapon Chain
	[35300]=29509, -- Pattern: Windstrike Gloves
	[35301]=29511, -- Pattern: Netherdrake Gloves
	[35302]=29503, -- Pattern: Cobrascale Gloves
	[35303]=29506, -- Pattern: Gloves of the Living Touch
	[35304]=24033, -- Design: Solid Star of Elune
	[35305]=24030, -- Design: Brilliant Living Ruby
	[35306]=24028, -- Design: Delicate Living Ruby
	[35307]=24051, -- Design: Rigid Star of Elune
	[35308]=24249, -- Pattern: Unyielding Bracers
	[35309]=24255, -- Pattern: Unyielding Girdle
	[35310]=33092, -- Schematic: Healing Potion Injector
	[35311]=33093, -- Schematic: Mana Potion Injector
	[35322]=35315, -- Design: Quick Dawnstone
	[35323]=24060, -- Design: Reckless Noble Topaz
	[35325]=35318, -- Design: Forceful Talasite
	[35502]=35501, -- Design: Eternal Earthstorm Diamond
	[35505]=35503, -- Design: Ember Skyfire Diamond
	[35564]=35563, -- Recipe: Charred Bear Kabobs
	[35566]=35565, -- Recipe: Juicy Bear Burger
	[35582]=35581, -- Schematic: Rocket Boots Xtreme Lite
	[35695]=35693, -- Design: Figurine - Empyrean Tortoise
	[35696]=35694, -- Design: Figurine - Khorium Boar
	[35697]=35700, -- Design: Figurine - Crimson Serpent
	[35698]=35702, -- Design: Figurine - Shadowsong Panther
	[35699]=35703, -- Design: Figurine - Seaspray Albatross
	[35708]=35707, -- Design: Regal Talasite
	[35752]=35748, -- Recipe: Guardian's Alchemist Stone
	[35753]=35749, -- Recipe: Sorcerer's Alchemist Stone
	[35754]=35750, -- Recipe: Redeemer's Alchemist Stone
	[35755]=35751, -- Recipe: Assassin's Alchemist Stone
	[35762]=35760, -- Design: Reckless Pyrestone
	[35763]=35761, -- Design: Quick Lionseye
	[35764]=35758, -- Design: Steady Seaspray Emerald
	[35765]=35759, -- Design: Forceful Seaspray Emerald
	[35766]=35758, -- Design: Steady Seaspray Emerald
	[35767]=35760, -- Design: Reckless Pyrestone
	[35768]=35761, -- Design: Quick Lionseye
	[35769]=35759, -- Design: Forceful Seaspray Emerald
	[37504]=32225, -- Design: Purified Shadowsong Amethyst
	[37915]=6836, -- Pattern: Dress Shoes
	[38229]=38225, -- Pattern: Mycah's Botanical Bag
	[38327]=38277, -- Pattern: Haliscan Jacket
	[38328]=38278, -- Pattern: Haliscan Pantaloons
	[39644]=39520, -- Recipe: Kungaloosh
	[39692]=39691, -- Recipe: Succulent Orca Stew
	[41120]=40958, -- Plans: Reinforced Cobalt Legplates
	[41122]=40959, -- Plans: Reinforced Cobalt Chestpiece
	[41123]=40957, -- Plans: Reinforced Cobalt Helm
	[41124]=40956, -- Plans: Reinforced Cobalt Shoulders
	[41559]=39917, -- Design: Mystic Sun Crystal
	[41560]=39932, -- Design: Stormy Chalcedony
	[41561]=39959, -- Design: Reckless Huge Citrine
	[41562]=39952, -- Design: Deadly Huge Citrine
	[41563]=39958, -- Design: Willful Huge Citrine
	[41564]=39954, -- Design: Lucent Huge Citrine
	[41565]=39954, -- Design: Lucent Huge Citrine
	[41566]=39950, -- Design: Resplendent Huge Citrine
	[41567]=39975, -- Design: Nimble Dark Jade
	[41568]=39979, -- Design: Purified Shadow Crystal
	[41569]=39992, -- Design: Shattered Dark Jade
	[41570]=39991, -- Design: Radiant Dark Jade
	[41571]=39982, -- Design: Turbid Dark Jade
	[41572]=39977, -- Design: Steady Dark Jade
	[41573]=39982, -- Design: Turbid Dark Jade
	[41574]=39939, -- Design: Defender's Shadow Crystal
	[41575]=39945, -- Design: Mysterious Shadow Crystal
	[41576]=39996, -- Design: Bold Scarlet Ruby
	[41577]=39997, -- Design: Delicate Scarlet Ruby
	[41578]=40001, -- Design: Flashing Scarlet Ruby
	[41579]=40017, -- Design: Quick Autumn's Glow
	[41580]=40014, -- Design: Rigid Sky Sapphire
	[41581]=40010, -- Design: Sparkling Sky Sapphire
	[41582]=40044, -- Design: Glinting Twilight Opal
	[41686]=40048, -- Design: Potent Monarch Topaz
	[41687]=40055, -- Design: Deft Monarch Topaz
	[41688]=40049, -- Design: Veiled Twilight Opal
	[41689]=40051, -- Design: Reckless Monarch Topaz
	[41690]=40051, -- Design: Reckless Monarch Topaz
	[41692]=40105, -- Design: Energized Forest Emerald
	[41693]=40091, -- Design: Forceful Forest Emerald
	[41694]=40105, -- Design: Energized Forest Emerald
	[41696]=40100, -- Design: Lightning Forest Emerald
	[41697]=40089, -- Design: Regal Forest Emerald
	[41698]=40088, -- Design: Nimble Forest Emerald
	[41699]=40026, -- Design: Purified Twilight Opal
	[41701]=40026, -- Design: Purified Twilight Opal
	[41702]=40086, -- Design: Jagged Forest Emerald
	[41703]=40089, -- Design: Regal Forest Emerald
	[41704]=41285, -- Design: Chaotic Skyflare Diamond
	[41705]=41377, -- Design: Shielded Skyflare Diamond
	[41706]=41333, -- Design: Ember Skyflare Diamond
	[41707]=41376, -- Design: Revitalizing Skyflare Diamond
	[41708]=41401, -- Design: Insightful Earthsiege Diamond
	[41709]=41385, -- Design: Invigorating Earthsiege Diamond
	[41710]=41398, -- Design: Relentless Earthsiege Diamond
	[41711]=41382, -- Design: Trenchant Earthsiege Diamond
	[41718]=39998, -- Design: Brilliant Scarlet Ruby
	[41719]=40000, -- Design: Subtle Autumn's Glow
	[41720]=40013, -- Design: Smooth Autumn's Glow
	[41721]=40052, -- Design: Deadly Monarch Topaz
	[41722]=40057, -- Design: Stalwart Monarch Topaz
	[41723]=40086, -- Design: Jagged Forest Emerald
	[41724]=40095, -- Design: Misty Forest Emerald
	[41725]=40025, -- Design: Timeless Twilight Opal
	[41726]=40034, -- Design: Guardian's Twilight Opal
	[41727]=40016, -- Design: Mystic Autumn's Glow
	[41728]=40011, -- Design: Stormy Sky Sapphire
	[41730]=40050, -- Design: Willful Monarch Topaz
	[41732]=40045, -- Design: Lucent Monarch Topaz
	[41733]=40045, -- Design: Lucent Monarch Topaz
	[41734]=40040, -- Design: Resplendent Monarch Topaz
	[41735]=40106, -- Design: Shattered Forest Emerald
	[41736]=40098, -- Design: Radiant Forest Emerald
	[41737]=40102, -- Design: Turbid Forest Emerald
	[41738]=40090, -- Design: Steady Forest Emerald
	[41739]=40102, -- Design: Turbid Forest Emerald
	[41740]=40028, -- Design: Mysterious Twilight Opal
	[41742]=41335, -- Design: Enigmatic Skyflare Diamond
	[41743]=41378, -- Design: Forlorn Skyflare Diamond
	[41744]=41379, -- Design: Impassive Skyflare Diamond
	[41747]=40023, -- Design: Shifting Twilight Opal
	[41777]=40038, -- Design: Etched Twilight Opal
	[41778]=40059, -- Design: Resolute Monarch Topaz
	[41779]=40057, -- Design: Stalwart Monarch Topaz
	[41780]=40039, -- Design: Champion's Monarch Topaz
	[41781]=40095, -- Design: Misty Forest Emerald
	[41782]=40100, -- Design: Lightning Forest Emerald
	[41783]=40026, -- Design: Purified Twilight Opal
	[41784]=40022, -- Design: Sovereign Twilight Opal
	[41785]=40044, -- Design: Glinting Twilight Opal
	[41786]=41307, -- Design: Destructive Skyflare Diamond
	[41787]=41400, -- Design: Thundering Skyflare Diamond
	[41788]=41389, -- Design: Beaming Earthsiege Diamond
	[41789]=40037, -- Design: Inscribed Monarch Topaz
	[41790]=40003, -- Design: Precise Scarlet Ruby
	[41791]=40000, -- Design: Subtle Autumn's Glow
	[41792]=40055, -- Design: Deft Monarch Topaz
	[41793]=40041, -- Design: Fierce Monarch Topaz
	[41794]=40052, -- Design: Deadly Monarch Topaz
	[41795]=40025, -- Design: Timeless Twilight Opal
	[41796]=40044, -- Design: Glinting Twilight Opal
	[41797]=41380, -- Design: Austere Earthsiege Diamond
	[41798]=41395, -- Design: Bracing Earthsiege Diamond
	[41799]=41396, -- Design: Eternal Earthsiege Diamond
	[41817]=40013, -- Design: Smooth Autumn's Glow
	[41818]=40058, -- Design: Accurate Twilight Opal
	[41819]=40098, -- Design: Radiant Forest Emerald
	[41820]=40032, -- Design: Defender's Twilight Opal
	[42138]=40008, -- Design: Solid Sky Sapphire
	[42172]=41248, -- Pattern: Red Lumberjack Shirt
	[42173]=41249, -- Pattern: Blue Lumberjack Shirt
	[42175]=41250, -- Pattern: Green Lumberjack Shirt
	[42176]=41253, -- Pattern: Blue Workman's Shirt
	[42177]=41252, -- Pattern: Red Workman's Shirt
	[42178]=41254, -- Pattern: Rustic Workman's Shirt
	[42183]=41597, -- Pattern: Abyssal Bag
	[42184]=41600, -- Pattern: Glacial Bag
	[42185]=41598, -- Pattern: Mysterious Bag
	[42187]=41602, -- Pattern: Brilliant Spellthread
	[42188]=41604, -- Pattern: Sapphire Spellthread
	[42298]=42142, -- Design: Bold Dragon's Eye
	[42299]=42143, -- Design: Delicate Dragon's Eye
	[42300]=42144, -- Design: Brilliant Dragon's Eye
	[42301]=42143, -- Design: Delicate Dragon's Eye
	[42302]=42152, -- Design: Flashing Dragon's Eye
	[42303]=42149, -- Design: Smooth Dragon's Eye
	[42304]=42145, -- Design: Sparkling Dragon's Eye
	[42305]=42158, -- Design: Mystic Dragon's Eye
	[42306]=42154, -- Design: Precise Dragon's Eye
	[42307]=42150, -- Design: Quick Dragon's Eye
	[42308]=42156, -- Design: Rigid Dragon's Eye
	[42309]=42144, -- Design: Brilliant Dragon's Eye
	[42310]=42149, -- Design: Smooth Dragon's Eye
	[42311]=36767, -- Design: Solid Dragon's Eye
	[42312]=42145, -- Design: Sparkling Dragon's Eye
	[42313]=42155, -- Design: Stormy Dragon's Eye
	[42314]=42151, -- Design: Subtle Dragon's Eye
	[42315]=42151, -- Design: Subtle Dragon's Eye
	[42648]=42642, -- Design: Titanium Impact Band
	[42649]=42643, -- Design: Titanium Earthguard Ring
	[42650]=42644, -- Design: Titanium Spellshock Ring
	[42651]=42645, -- Design: Titanium Impact Choker
	[42652]=42646, -- Design: Titanium Earthguard Chain
	[42653]=42647, -- Design: Titanium Spellshock Necklace
	[43017]=43015, -- Recipe: Fish Feast
	[43018]=34754, -- Recipe: Mega Mammoth Meal
	[43019]=34755, -- Recipe: Tender Shoveltusk Steak
	[43020]=34756, -- Recipe: Spiced Worm Burger
	[43021]=34757, -- Recipe: Very Burnt Worg
	[43022]=34758, -- Recipe: Mighty Rhino Dogs
	[43023]=34766, -- Recipe: Poached Northern Sculpin
	[43024]=34767, -- Recipe: Firecracker Salmon
	[43025]=34768, -- Recipe: Spicy Blue Nettlefish
	[43026]=34769, -- Recipe: Imperial Manta Steak
	[43027]=42993, -- Recipe: Spicy Fried Herring
	[43028]=42994, -- Recipe: Rhinolicious Wormsteak
	[43029]=43004, -- Recipe: Critter Bites
	[43030]=42995, -- Recipe: Hearty Rhino
	[43031]=42996, -- Recipe: Snapper Extreme
	[43032]=42997, -- Recipe: Blackened Worg Steak
	[43033]=42998, -- Recipe: Cuttlesteak
	[43034]=43005, -- Recipe: Spiced Mammoth Treats
	[43035]=42999, -- Recipe: Blackened Dragonfin
	[43036]=43000, -- Recipe: Dragonfin Filet
	[43037]=43001, -- Recipe: Tracker Snacks
	[43317]=43250, -- Design: Ring of Earthen Might
	[43318]=43251, -- Design: Ring of Scarlet Shadows
	[43319]=43252, -- Design: Windfire Band
	[43320]=43253, -- Design: Ring of Northern Tears
	[43485]=43482, -- Design: Savage Titanium Ring
	[43497]=43498, -- Design: Savage Titanium Band
	[43505]=43478, -- Recipe: Gigantic Feast
	[43506]=43480, -- Recipe: Small Feast
	[43507]=43490, -- Recipe: Tasty Cupcake
	[43508]=43488, -- Recipe: Last Week's Mammoth
	[43509]=43491, -- Recipe: Bad Clams
	[43510]=43492, -- Recipe: Haunted Herring
	[43597]=43582, -- Design: Titanium Frostguard Ring
	[44502]=41508, -- Schematic: Mechano-Hog
	[44503]=44413, -- Schematic: Mekgineer's Chopper
	[44509]=38399, -- Pattern: Trapper's Traveling Pack
	[44510]=38347, -- Pattern: Mammoth Mining Bag
	[44513]=43260, -- Pattern: Eviscerator's Facemask
	[44514]=43433, -- Pattern: Eviscerator's Shoulderpads
	[44515]=43434, -- Pattern: Eviscerator's Chestguard
	[44516]=43435, -- Pattern: Eviscerator's Bindings
	[44517]=43436, -- Pattern: Eviscerator's Gauntlets
	[44518]=43437, -- Pattern: Eviscerator's Waistguard
	[44519]=43438, -- Pattern: Eviscerator's Legguards
	[44520]=43439, -- Pattern: Eviscerator's Treads
	[44521]=43261, -- Pattern: Overcast Headguard
	[44522]=43262, -- Pattern: Overcast Spaulders
	[44523]=43263, -- Pattern: Overcast Chestguard
	[44524]=43264, -- Pattern: Overcast Bracers
	[44525]=43265, -- Pattern: Overcast Handwraps
	[44526]=43266, -- Pattern: Overcast Belt
	[44527]=43271, -- Pattern: Overcast Leggings
	[44528]=43273, -- Pattern: Overcast Boots
	[44530]=43447, -- Pattern: Swiftarrow Helm
	[44531]=43449, -- Pattern: Swiftarrow Shoulderguards
	[44532]=43445, -- Pattern: Swiftarrow Hauberk
	[44533]=43444, -- Pattern: Swiftarrow Bracers
	[44534]=43446, -- Pattern: Swiftarrow Gauntlets
	[44535]=43442, -- Pattern: Swiftarrow Belt
	[44536]=43448, -- Pattern: Swiftarrow Leggings
	[44537]=43443, -- Pattern: Swiftarrow Boots
	[44538]=43455, -- Pattern: Stormhide Crown
	[44539]=43457, -- Pattern: Stormhide Shoulders
	[44540]=43453, -- Pattern: Stormhide Hauberk
	[44541]=43452, -- Pattern: Stormhide Wristguards
	[44542]=43454, -- Pattern: Stormhide Grips
	[44543]=43450, -- Pattern: Stormhide Belt
	[44544]=43456, -- Pattern: Stormhide Legguards
	[44545]=43451, -- Pattern: Stormhide Stompers
	[44546]=43458, -- Pattern: Giantmaim Legguards
	[44547]=43459, -- Pattern: Giantmaim Bracers
	[44548]=43461, -- Pattern: Revenant's Breastplate
	[44549]=43469, -- Pattern: Revenant's Treads
	[44550]=43481, -- Pattern: Trollwoven Spaulders
	[44551]=43484, -- Pattern: Trollwoven Girdle
	[44552]=43495, -- Pattern: Earthgiving Legguards
	[44553]=43502, -- Pattern: Earthgiving Boots
	[44564]=40213, -- Recipe: Mighty Arcane Protection Potion
	[44565]=40214, -- Recipe: Mighty Fire Protection Potion
	[44566]=40215, -- Recipe: Mighty Frost Protection Potion
	[44567]=40216, -- Recipe: Mighty Nature Protection Potion
	[44568]=40217, -- Recipe: Mighty Shadow Protection Potion
	[44584]=43590, -- Pattern: Polar Vest
	[44585]=43591, -- Pattern: Polar Cord
	[44586]=43592, -- Pattern: Polar Boots
	[44587]=43593, -- Pattern: Icy Scale Chestguard
	[44588]=43594, -- Pattern: Icy Scale Belt
	[44589]=43595, -- Pattern: Icy Scale Boots
	[44858]=44840, -- Recipe: Cranberry Chutney
	[44859]=44839, -- Recipe: Candied Sweet Potato
	[44860]=44837, -- Recipe: Spice Bread Stuffing
	[44861]=44838, -- Recipe: Slow-Roasted Turkey
	[44862]=44836, -- Recipe: Pumpkin Pie
	[44916]=21154, -- Pattern: Festival Dress
	[44917]=21542, -- Pattern: Festival Suit
	[44918]=21570, -- Schematic: Cluster Launcher
	[44919]=21569, -- Schematic: Firework Launcher
	[44932]=44930, -- Pattern: Windripper Boots
	[44933]=44931, -- Pattern: Windripper Leggings
	[44937]=44936, -- Plans: Titanium Plating
	[44938]=44936, -- Plans: Titanium Plating
	[44954]=44953, -- Recipe: Worg Tartare
	[44977]=5478, -- Recipe: Dig Rat Stew
	[45088]=45550, -- Plans: Belt of the Titans
	[45089]=45559, -- Plans: Battlelord's Plate Boots
	[45090]=45552, -- Plans: Plate Girdle of Righteousness
	[45091]=45561, -- Plans: Treads of Destiny
	[45092]=45551, -- Plans: Indestructible Plate Girdle
	[45093]=45560, -- Plans: Spiked Deathdealers
	[45094]=45553, -- Pattern: Belt of Dragons
	[45095]=45562, -- Pattern: Boots of Living Scale
	[45096]=45554, -- Pattern: Blue Belt of Chaos
	[45097]=45563, -- Pattern: Lightning Grounded Boots
	[45098]=45555, -- Pattern: Death-Warmed Belt
	[45099]=45564, -- Pattern: Footpads of Silence
	[45100]=45556, -- Pattern: Belt of Arctic Life
	[45101]=45565, -- Pattern: Boots of Wintry Endurance
	[45102]=45557, -- Pattern: Sash of Ancient Power
	[45103]=45566, -- Pattern: Spellslinger's Slippers
	[45104]=45558, -- Pattern: Cord of the White Dawn
	[45105]=45567, -- Pattern: Savior's Slippers
	[45774]=45773, -- Pattern: Emerald Bag
	[46710]=46691, -- Recipe: Bread of the Dead
	[46803]=44837, -- Recipe: Spice Bread Stuffing
	[46804]=44836, -- Recipe: Pumpkin Pie
	[46805]=44840, -- Recipe: Cranberry Chutney
	[46806]=44839, -- Recipe: Candied Sweet Potato
	[46807]=44838, -- Recipe: Slow-Roasted Turkey
	[46897]=40167, -- Design: Regal Eye of Zul
	[46898]=40168, -- Design: Steady Eye of Zul
	[46899]=40166, -- Design: Nimble Eye of Zul
	[46900]=40133, -- Design: Purified Dreadstone
	[46901]=40165, -- Design: Jagged Eye of Zul
	[46902]=40164, -- Design: Timeless Dreadstone
	[46903]=40133, -- Design: Purified Dreadstone
	[46904]=40169, -- Design: Forceful Eye of Zul
	[46905]=40171, -- Design: Misty Eye of Zul
	[46906]=40171, -- Design: Misty Eye of Zul
	[46907]=40177, -- Design: Lightning Eye of Zul
	[46908]=40180, -- Design: Radiant Eye of Zul
	[46909]=40177, -- Design: Lightning Eye of Zul
	[46910]=40179, -- Design: Energized Eye of Zul
	[46911]=40180, -- Design: Radiant Eye of Zul
	[46912]=40179, -- Design: Energized Eye of Zul
	[46913]=40182, -- Design: Shattered Eye of Zul
	[46914]=40173, -- Design: Turbid Eye of Zul
	[46915]=40173, -- Design: Turbid Eye of Zul
	[46916]=40113, -- Design: Brilliant Cardinal Ruby
	[46917]=40111, -- Design: Bold Cardinal Ruby
	[46918]=40112, -- Design: Delicate Cardinal Ruby
	[46919]=40112, -- Design: Delicate Cardinal Ruby
	[46920]=40118, -- Design: Precise Cardinal Ruby
	[46921]=40124, -- Design: Smooth King's Amber
	[46922]=40115, -- Design: Subtle King's Amber
	[46923]=40116, -- Design: Flashing Cardinal Ruby
	[46924]=40119, -- Design: Solid Majestic Zircon
	[46925]=40120, -- Design: Sparkling Majestic Zircon
	[46926]=40122, -- Design: Stormy Majestic Zircon
	[46927]=40120, -- Design: Sparkling Majestic Zircon
	[46928]=40125, -- Design: Rigid Majestic Zircon
	[46929]=40124, -- Design: Smooth King's Amber
	[46930]=40113, -- Design: Brilliant Cardinal Ruby
	[46931]=40115, -- Design: Subtle King's Amber
	[46932]=40127, -- Design: Mystic King's Amber
	[46933]=40128, -- Design: Quick King's Amber
	[46934]=40130, -- Design: Shifting Dreadstone
	[46935]=40129, -- Design: Sovereign Dreadstone
	[46936]=40164, -- Design: Timeless Dreadstone
	[46937]=40133, -- Design: Purified Dreadstone
	[46938]=40130, -- Design: Shifting Dreadstone
	[46939]=40133, -- Design: Purified Dreadstone
	[46940]=40167, -- Design: Regal Eye of Zul
	[46941]=40139, -- Design: Defender's Dreadstone
	[46942]=40141, -- Design: Guardian's Dreadstone
	[46943]=40135, -- Design: Mysterious Dreadstone
	[46944]=40165, -- Design: Jagged Eye of Zul
	[46945]=40157, -- Design: Glinting Dreadstone
	[46946]=40157, -- Design: Glinting Dreadstone
	[46947]=40133, -- Design: Purified Dreadstone
	[46948]=40142, -- Design: Inscribed Ametrine
	[46949]=40147, -- Design: Deadly Ametrine
	[46950]=40152, -- Design: Potent Ametrine
	[46951]=40153, -- Design: Veiled Dreadstone
	[46952]=40154, -- Design: Willful Ametrine
	[46953]=40143, -- Design: Etched Dreadstone
	[46956]=40157, -- Design: Glinting Dreadstone
	[47007]=40155, -- Design: Reckless Ametrine
	[47008]=40157, -- Design: Glinting Dreadstone
	[47010]=40162, -- Design: Accurate Dreadstone
	[47011]=40147, -- Design: Deadly Ametrine
	[47012]=40160, -- Design: Stalwart Ametrine
	[47015]=40144, -- Design: Champion's Ametrine
	[47016]=40149, -- Design: Lucent Ametrine
	[47017]=40160, -- Design: Stalwart Ametrine
	[47018]=40145, -- Design: Resplendent Ametrine
	[47019]=40146, -- Design: Fierce Ametrine
	[47020]=40159, -- Design: Deft Ametrine
	[47021]=40149, -- Design: Lucent Ametrine
	[47022]=40163, -- Design: Resolute Ametrine
	[47023]=40159, -- Design: Deft Ametrine
	[47622]=47592, -- Plans: Breastplate of the White Knight
	[47623]=47571, -- Plans: Saronite Swordbreakers
	[47624]=47590, -- Plans: Titanium Razorplate
	[47625]=47573, -- Plans: Titanium Spikeguards
	[47626]=47594, -- Plans: Sunforged Breastplate
	[47627]=47575, -- Plans: Sunforged Bracers
	[47628]=47598, -- Pattern: Ensorcelled Nerubian Breastplate
	[47629]=47580, -- Pattern: Black Chitin Bracers
	[47630]=47596, -- Pattern: Crusader's Dragonscale Breastplate
	[47631]=47577, -- Pattern: Crusader's Dragonscale Bracers
	[47632]=47602, -- Pattern: Lunar Eclipse Robes
	[47633]=47584, -- Pattern: Moonshadow Armguards
	[47634]=47600, -- Pattern: Knightbane Carapace
	[47635]=47582, -- Pattern: Bracers of Swift Death
	[47636]=47606, -- Pattern: Royal Moonshroud Robe
	[47637]=47588, -- Pattern: Royal Moonshroud Bracers
	[47638]=47604, -- Pattern: Merlin's Robe
	[47639]=47586, -- Pattern: Bejeweled Wizard's Bracers
	[47640]=47592, -- Plans: Breastplate of the White Knight
	[47641]=47571, -- Plans: Saronite Swordbreakers
	[47642]=47575, -- Plans: Sunforged Bracers
	[47643]=47594, -- Plans: Sunforged Breastplate
	[47644]=47590, -- Plans: Titanium Razorplate
	[47645]=47573, -- Plans: Titanium Spikeguards
	[47646]=47580, -- Pattern: Black Chitin Bracers
	[47647]=47582, -- Pattern: Bracers of Swift Death
	[47648]=47577, -- Pattern: Crusader's Dragonscale Bracers
	[47649]=47596, -- Pattern: Crusader's Dragonscale Breastplate
	[47650]=47598, -- Pattern: Ensorcelled Nerubian Breastplate
	[47651]=47600, -- Pattern: Knightbane Carapace
	[47652]=47602, -- Pattern: Lunar Eclipse Robes
	[47653]=47584, -- Pattern: Moonshadow Armguards
	[47654]=47586, -- Pattern: Bejeweled Wizard's Bracers
	[47655]=47604, -- Pattern: Merlin's Robe
	[47656]=47588, -- Pattern: Royal Moonshroud Bracers
	[47657]=47606, -- Pattern: Royal Moonshroud Robe
	[49050]=49040, -- Schematic: Jeeves
	[49112]=49110, -- Design: Nightmare Tear
	[49953]=49891, -- Pattern: Leggings of Woven Death
	[49954]=49890, -- Pattern: Deathfrost Boots
	[49955]=49892, -- Pattern: Lightweave Leggings
	[49956]=49893, -- Pattern: Sandals of Consecration
	[49957]=49898, -- Pattern: Legwraps of Unleashed Nature
	[49958]=49894, -- Pattern: Blessed Cenarion Boots
	[49959]=49899, -- Pattern: Bladeborn Leggings
	[49961]=49895, -- Pattern: Footpads of Impending Death
	[49962]=49900, -- Pattern: Lightning-Infused Leggings
	[49963]=49896, -- Pattern: Earthsoul Boots
	[49965]=49901, -- Pattern: Draconic Bonesplinter Legguards
	[49966]=49897, -- Pattern: Rock-Steady Treads
	[49969]=49902, -- Plans: Puresteel Legplates
	[49970]=49905, -- Plans: Protectors of Life
	[49971]=49903, -- Plans: Legplates of Painful Death
	[49972]=49906, -- Plans: Hellfrozen Bonegrinders
	[49973]=49904, -- Plans: Pillars of Might
	[49974]=49907, -- Plans: Boots of Kingly Upheaval
	[52362]=52206, -- Design: Bold Inferno Ruby
	[52363]=52083, -- Design: Flashing Carnelian
	[52364]=52088, -- Design: Stormy Zephyrite
	[52365]=52090, -- Design: Subtle Alicite
	[52366]=52097, -- Design: Defender's Nightstone
	[52367]=52099, -- Design: Guardian's Nightstone
	[52368]=52100, -- Design: Purified Nightstone
	[52369]=52103, -- Design: Retaliating Nightstone
	[52370]=52106, -- Design: Polished Hessonite
	[52371]=52108, -- Design: Inscribed Hessonite
	[52372]=52109, -- Design: Deadly Hessonite
	[52373]=52110, -- Design: Potent Hessonite
	[52374]=52111, -- Design: Fierce Hessonite
	[52375]=52112, -- Design: Deft Hessonite
	[52376]=52116, -- Design: Fine Hessonite
	[52377]=52118, -- Design: Keen Hessonite
	[52378]=52119, -- Design: Regal Jasper
	[52379]=52120, -- Design: Nimble Jasper
	[52380]=52212, -- Design: Delicate Inferno Ruby
	[52381]=52255, -- Design: Bold Chimera's Eye
	[52382]=52122, -- Design: Piercing Jasper
	[52383]=52123, -- Design: Steady Jasper
	[52384]=52216, -- Design: Flashing Inferno Ruby
	[52385]=52124, -- Design: Forceful Jasper
	[52386]=52125, -- Design: Lightning Jasper
	[52387]=52207, -- Design: Brilliant Inferno Ruby
	[52388]=52127, -- Design: Zen Jasper
	[52389]=52230, -- Design: Precise Inferno Ruby
	[52390]=52242, -- Design: Solid Ocean Sapphire
	[52391]=52244, -- Design: Sparkling Ocean Sapphire
	[52392]=52246, -- Design: Stormy Ocean Sapphire
	[52393]=52235, -- Design: Rigid Ocean Sapphire
	[52394]=52247, -- Design: Subtle Amberjewel
	[52395]=52241, -- Design: Smooth Amberjewel
	[52396]=52226, -- Design: Mystic Amberjewel
	[52397]=52232, -- Design: Quick Amberjewel
	[52398]=52219, -- Design: Fractured Amberjewel
	[52399]=52243, -- Design: Sovereign Demonseye
	[52400]=52238, -- Design: Shifting Demonseye
	[52401]=52210, -- Design: Defender's Demonseye
	[52402]=52248, -- Design: Timeless Demonseye
	[52403]=52221, -- Design: Guardian's Demonseye
	[52404]=52236, -- Design: Purified Demonseye
	[52405]=52213, -- Design: Etched Demonseye
	[52406]=52220, -- Design: Glinting Demonseye
	[52407]=52234, -- Design: Retaliating Demonseye
	[52408]=52217, -- Design: Veiled Demonseye
	[52409]=52203, -- Design: Accurate Demonseye
	[52410]=52229, -- Design: Polished Ember Topaz
	[52411]=52249, -- Design: Resolute Ember Topaz
	[52412]=52222, -- Design: Inscribed Ember Topaz
	[52413]=52209, -- Design: Deadly Ember Topaz
	[52414]=52239, -- Design: Potent Ember Topaz
	[52415]=52214, -- Design: Fierce Ember Topaz
	[52416]=52211, -- Design: Deft Ember Topaz
	[52417]=52208, -- Design: Reckless Ember Topaz
	[52418]=52240, -- Design: Skillful Ember Topaz
	[52419]=52204, -- Design: Adept Ember Topaz
	[52420]=52215, -- Design: Fine Ember Topaz
	[52421]=52205, -- Design: Artful Ember Topaz
	[52422]=52224, -- Design: Keen Ember Topaz
	[52423]=52233, -- Design: Regal Dream Emerald
	[52424]=52227, -- Design: Nimble Dream Emerald
	[52425]=52223, -- Design: Jagged Dream Emerald
	[52426]=52228, -- Design: Piercing Dream Emerald
	[52427]=52245, -- Design: Steady Dream Emerald
	[52428]=52218, -- Design: Forceful Dream Emerald
	[52429]=52225, -- Design: Lightning Dream Emerald
	[52430]=52231, -- Design: Puissant Dream Emerald
	[52431]=52250, -- Design: Zen Dream Emerald
	[52432]=52237, -- Design: Sensei's Dream Emerald
	[52433]=52289, -- Design: Fleet Shadowspirit Diamond
	[52434]=52291, -- Design: Chaotic Shadowspirit Diamond
	[52435]=52292, -- Design: Bracing Shadowspirit Diamond
	[52436]=52293, -- Design: Eternal Shadowspirit Diamond
	[52437]=52294, -- Design: Austere Shadowspirit Diamond
	[52438]=52295, -- Design: Effulgent Shadowspirit Diamond
	[52439]=52296, -- Design: Ember Shadowspirit Diamond
	[52440]=52297, -- Design: Revitalizing Shadowspirit Diamond
	[52441]=52298, -- Design: Destructive Shadowspirit Diamond
	[52442]=52299, -- Design: Powerful Shadowspirit Diamond
	[52443]=52300, -- Design: Enigmatic Shadowspirit Diamond
	[52444]=52301, -- Design: Impassive Shadowspirit Diamond
	[52445]=52302, -- Design: Forlorn Shadowspirit Diamond
	[52447]=52258, -- Design: Delicate Chimera's Eye
	[52448]=52259, -- Design: Flashing Chimera's Eye
	[52449]=52257, -- Design: Brilliant Chimera's Eye
	[52450]=52260, -- Design: Precise Chimera's Eye
	[52451]=52261, -- Design: Solid Chimera's Eye
	[52452]=52262, -- Design: Sparkling Chimera's Eye
	[52453]=52263, -- Design: Stormy Chimera's Eye
	[52454]=52264, -- Design: Rigid Chimera's Eye
	[52455]=52265, -- Design: Subtle Chimera's Eye
	[52456]=52266, -- Design: Smooth Chimera's Eye
	[52457]=52267, -- Design: Mystic Chimera's Eye
	[52458]=52268, -- Design: Quick Chimera's Eye
	[52459]=52269, -- Design: Fractured Chimera's Eye
	[52460]=52348, -- Design: Elementium Destroyer's Ring
	[52461]=52318, -- Design: Band of Blades
	[52462]=52319, -- Design: Ring of Warring Elements
	[52463]=52320, -- Design: Elementium Moebius Band
	[52464]=52350, -- Design: Brazen Elementium Medallion
	[52465]=52321, -- Design: Entwined Elementium Choker
	[52466]=52322, -- Design: Eye of Many Deaths
	[52467]=52323, -- Design: Elementium Guardian
	[52494]=52485, -- Design: Jeweler's Ruby Monocle
	[52495]=52488, -- Design: Jeweler's Sapphire Monocle
	[52496]=52487, -- Design: Jeweler's Amber Monocle
	[52497]=52488, -- Design: Jeweler's Sapphire Monocle
	[52499]=65895, -- Design: Figurine - King of Boars
	[52500]=52199, -- Design: Figurine - Demon Panther
	[52501]=65897, -- Design: Figurine - Earthen Guardian
	[52502]=65896, -- Design: Figurine - Jeweled Serpent
	[52503]=65894, -- Design: Figurine - Dream Owl
	[54593]=75073, -- Pattern: Vicious Embersilk Cowl
	[54594]=75072, -- Pattern: Vicious Embersilk Pants
	[54595]=75093, -- Pattern: Vicious Embersilk Robe
	[54596]=75062, -- Pattern: Vicious Fireweave Cowl
	[54597]=75082, -- Pattern: Vicious Fireweave Pants
	[54598]=75088, -- Pattern: Vicious Fireweave Robe
	[54599]=54448, -- Pattern: Powerful Enchanted Spellthread
	[54600]=54450, -- Pattern: Powerful Ghostly Spellthread
	[54601]=54504, -- Pattern: Belt of the Depths
	[54602]=54503, -- Pattern: Dreamless Belt
	[54603]=54505, -- Pattern: Breeches of Mended Nightmares
	[54604]=54506, -- Pattern: Flame-Ascended Pantaloons
	[54605]=54444, -- Pattern: Illusionary Bag
	[54798]=54797, -- Pattern: Frosty Flying Carpet
	[62799]=62289, -- Recipe: Broiled Dragon Feast
	[62800]=62290, -- Recipe: Seafood Magnifique Feast
	[65406]=62656, -- Recipe: Whitecrest Gumbo
	[65407]=62654, -- Recipe: Lavascale Fillet
	[65408]=62673, -- Recipe: Feathered Lure
	[65409]=62663, -- Recipe: Lavascale Minestrone
	[65410]=62653, -- Recipe: Salted Eye
	[65411]=62655, -- Recipe: Broiled Mountain Trout
	[65412]=62651, -- Recipe: Lightly Fried Lurker
	[65413]=62652, -- Recipe: Seasoned Crab
	[65414]=62675, -- Recipe: Starfire Espresso
	[65415]=62674, -- Recipe: Highland Spirits
	[65416]=62657, -- Recipe: Lurker Lunch
	[65417]=62660, -- Recipe: Pickled Guppy
	[65418]=62659, -- Recipe: Hearty Seafood Soup
	[65419]=62658, -- Recipe: Tender Baked Turtle
	[65420]=62667, -- Recipe: Mushroom Sauce Mudfish
	[65421]=62671, -- Recipe: Severed Sagefish Head
	[65422]=62666, -- Recipe: Delicious Sagefish Tail
	[65423]=62677, -- Recipe: Fish Fry
	[65424]=62668, -- Recipe: Blackbelly Sushi
	[65425]=62669, -- Recipe: Skewered Eel
	[65426]=62661, -- Recipe: Baked Rockfish
	[65427]=62665, -- Recipe: Basilisk Liverdog
	[65428]=62662, -- Recipe: Grilled Dragon
	[65429]=62670, -- Recipe: Beer-Basted Crocolisk
	[65430]=62664, -- Recipe: Crocolisk Au Gratin
	[65431]=62680, -- Recipe: Chocolate Cookie
	[65432]=62649, -- Recipe: Fortune Cookie
	[65433]=62672, -- Recipe: South Island Iced Tea
	[65435]=62288, -- Recipe: Cauldron of Battle
	[65498]=65460, -- Recipe: Big Cauldron of Battle
	[66062]=54850, -- Plans: Hardened Obsidium Bracers
	[66063]=54852, -- Plans: Hardened Obsidium Gauntlets
	[66064]=54853, -- Plans: Hardened Obsidium Belt
	[66065]=54854, -- Plans: Hardened Obsidium Boots
	[66066]=54876, -- Plans: Hardened Obsidium Shoulders
	[66068]=55022, -- Plans: Hardened Obsidium Legguards
	[66069]=55023, -- Plans: Hardened Obsidium Helm
	[66071]=55024, -- Plans: Hardened Obsidium Breastplate
	[66072]=55025, -- Plans: Redsteel Bracers
	[66074]=55026, -- Plans: Redsteel Gauntlets
	[66077]=55027, -- Plans: Redsteel Belt
	[66078]=55028, -- Plans: Redsteel Boots
	[66079]=55029, -- Plans: Redsteel Shoulders
	[66081]=55030, -- Plans: Redsteel Legguards
	[66082]=55031, -- Plans: Redsteel Helm
	[66083]=55032, -- Plans: Redsteel Breastplate
	[66084]=55033, -- Plans: Stormforged Bracers
	[66085]=55034, -- Plans: Stormforged Gauntlets
	[66086]=55035, -- Plans: Stormforged Belt
	[66087]=55036, -- Plans: Stormforged Boots
	[66088]=55037, -- Plans: Stormforged Shoulders
	[66089]=55038, -- Plans: Stormforged Legguards
	[66090]=55039, -- Plans: Stormforged Helm
	[66091]=55040, -- Plans: Stormforged Breastplate
	[66092]=55041, -- Plans: Hardened Obsidium Shield
	[66093]=55042, -- Plans: Stormforged Shield
	[66094]=55043, -- Plans: Decapitator's Razor
	[66095]=55044, -- Plans: Cold-Forged Shank
	[66096]=55045, -- Plans: Fire-Etched Dagger
	[66097]=55046, -- Plans: Lifeforce Hammer
	[66098]=55052, -- Plans: Obsidium Executioner
	[66099]=55053, -- Plans: Obsidium Skeleton Key
	[66100]=55054, -- Plans: Ebonsteel Belt Buckle
	[66101]=55056, -- Plans: Pyrium Shield Spike
	[66102]=55055, -- Plans: Elementium Shield Spike
	[66103]=55057, -- Plans: Pyrium Weapon Chain
	[66104]=55058, -- Plans: Hardened Elementium Hauberk
	[66105]=55059, -- Plans: Hardened Elementium Girdle
	[66106]=55060, -- Plans: Elementium Deathplate
	[66107]=55061, -- Plans: Elementium Girdle of Pain
	[66108]=55062, -- Plans: Light Elementium Chestguard
	[66109]=55063, -- Plans: Light Elementium Belt
	[66110]=55064, -- Plans: Elementium Spellblade
	[66111]=55065, -- Plans: Elementium Hammer
	[66112]=55066, -- Plans: Elementium Poleaxe
	[66113]=55067, -- Plans: Elementium Bonesplitter
	[66114]=55068, -- Plans: Elementium Shank
	[66115]=55069, -- Plans: Elementium Earthguard
	[66116]=55070, -- Plans: Elementium Stormshield
	[66117]=75124, -- Plans: Vicious Pyrium Bracers
	[66118]=75122, -- Plans: Vicious Pyrium Gauntlets
	[66119]=75123, -- Plans: Vicious Pyrium Belt
	[66120]=75120, -- Plans: Vicious Pyrium Boots
	[66121]=75119, -- Plans: Vicious Pyrium Shoulders
	[66122]=75136, -- Plans: Vicious Pyrium Legguards
	[66123]=75126, -- Plans: Vicious Pyrium Helm
	[66124]=75135, -- Plans: Vicious Pyrium Breastplate
	[66125]=75125, -- Plans: Vicious Ornate Pyrium Bracers
	[66126]=75121, -- Plans: Vicious Ornate Pyrium Gauntlets
	[66127]=75118, -- Plans: Vicious Ornate Pyrium Belt
	[66128]=75132, -- Plans: Vicious Ornate Pyrium Boots
	[66129]=75134, -- Plans: Vicious Ornate Pyrium Shoulders
	[66130]=75133, -- Plans: Vicious Ornate Pyrium Legguards
	[66131]=75129, -- Plans: Vicious Ornate Pyrium Helm
	[66132]=75128, -- Plans: Vicious Ornate Pyrium Breastplate
	[66133]=55246, -- Plans: Obsidium Bladespear
	[66134]=0, -- Plans: Elementium Rod
	[66995]=56480, -- Pattern: Savage Cloak
	[66996]=56481, -- Pattern: Tsunami Bracers
	[66997]=56482, -- Pattern: Tsunami Belt
	[66999]=56483, -- Pattern: Darkbrand Bracers
	[67000]=56484, -- Pattern: Darkbrand Gloves
	[67001]=56485, -- Pattern: Windbound Bracers
	[67002]=56486, -- Pattern: Windbound Gloves
	[67003]=56487, -- Pattern: Razorshell Bracers
	[67004]=56488, -- Pattern: Razorshell Shoulders
	[67005]=0, -- Pattern: Shellscale Cloak
	[67006]=56490, -- Pattern: Tsunami Gloves
	[67007]=56491, -- Pattern: Darkbrand Boots
	[67008]=56492, -- Pattern: Windbound Boots
	[67009]=56493, -- Pattern: Razorshell Boots
	[67010]=56494, -- Pattern: Tsunami Boots
	[67011]=56495, -- Pattern: Darkbrand Shoulders
	[67012]=56496, -- Pattern: Windbound Belt
	[67013]=56497, -- Pattern: Razorshell Gloves
	[67014]=56498, -- Pattern: Tsunami Shoulders
	[67015]=56499, -- Pattern: Darkbrand Belt
	[67016]=56500, -- Pattern: Windbound Shoulders
	[67017]=56501, -- Pattern: Razorshell Belt
	[67018]=56502, -- Pattern: Scorched Leg Armor
	[67019]=56503, -- Pattern: Twilight Leg Armor
	[67020]=56504, -- Pattern: Tsunami Chestguard
	[67021]=56505, -- Pattern: Darkbrand Helm
	[67022]=56506, -- Pattern: Windbound Leggings
	[67023]=56507, -- Pattern: Razorshell Helm
	[67025]=56508, -- Pattern: Tsunami Leggings
	[67026]=56509, -- Pattern: Darkbrand Chestguard
	[67028]=56510, -- Pattern: Windbound Chest
	[67030]=56511, -- Pattern: Razorshell Leggings
	[67031]=56512, -- Pattern: Tsunami Helm
	[67033]=56513, -- Pattern: Darkbrand Leggings
	[67034]=56514, -- Pattern: Windbound Helm
	[67035]=56515, -- Pattern: Razorshell Chest
	[67036]=56516, -- Pattern: Heavy Savage Leather
	[67038]=56517, -- Pattern: Heavy Savage Armor Kit
	[67039]=56518, -- Pattern: Cloak of Beasts
	[67041]=56519, -- Pattern: Cloak of War
	[67042]=75106, -- Pattern: Vicious Wyrmhide Bracers
	[67044]=75117, -- Pattern: Vicious Wyrmhide Belt
	[67046]=75131, -- Pattern: Vicious Leather Bracers
	[67048]=75104, -- Pattern: Vicious Leather Gloves
	[67049]=75094, -- Pattern: Vicious Charscale Bracers
	[67053]=75085, -- Pattern: Vicious Charscale Gloves
	[67054]=75114, -- Pattern: Vicious Dragonscale Bracers
	[67055]=75116, -- Pattern: Vicious Dragonscale Shoulders
	[67056]=75109, -- Pattern: Vicious Wyrmhide Gloves
	[67058]=75101, -- Pattern: Vicious Wyrmhide Boots
	[67060]=75130, -- Pattern: Vicious Leather Boots
	[67062]=75113, -- Pattern: Vicious Leather Shoulders
	[67063]=75092, -- Pattern: Vicious Charscale Boots
	[67064]=75083, -- Pattern: Vicious Charscale Belt
	[67065]=75110, -- Pattern: Vicious Dragonscale Boots
	[67066]=75081, -- Pattern: Vicious Dragonscale Gloves
	[67068]=56536, -- Pattern: Lightning Lash
	[67070]=56537, -- Pattern: Belt of Nefarious Whispers
	[67072]=56538, -- Pattern: Stormleather Sash
	[67073]=56539, -- Pattern: Corded Viper Belt
	[67074]=75099, -- Pattern: Vicious Wyrmhide Shoulders
	[67075]=75107, -- Pattern: Vicious Wyrmhide Chest
	[67076]=75127, -- Pattern: Vicious Leather Belt
	[67077]=75105, -- Pattern: Vicious Leather Helm
	[67078]=75061, -- Pattern: Vicious Charscale Shoulders
	[67079]=75097, -- Pattern: Vicious Charscale Legs
	[67080]=75100, -- Pattern: Vicious Dragonscale Belt
	[67081]=75102, -- Pattern: Vicious Dragonscale Helm
	[67082]=56548, -- Pattern: Razor-Edged Cloak
	[67083]=56549, -- Pattern: Twilight Dragonscale Cloak
	[67084]=56551, -- Pattern: Charscale Leg Armor
	[67085]=75080, -- Pattern: Vicious Wyrmhide Legs
	[67086]=75111, -- Pattern: Vicious Wyrmhide Helm
	[67087]=75103, -- Pattern: Vicious Leather Chest
	[67089]=75112, -- Pattern: Vicious Leather Legs
	[67090]=75084, -- Pattern: Vicious Charscale Chest
	[67091]=75090, -- Pattern: Vicious Charscale Helm
	[67092]=75108, -- Pattern: Vicious Dragonscale Legs
	[67093]=75115, -- Pattern: Vicious Dragonscale Chest
	[67094]=56561, -- Pattern: Chestguard of Nature's Fury
	[67095]=56562, -- Pattern: Assassin's Chestplate
	[67096]=56563, -- Pattern: Twilight Scale Chestguard
	[67100]=56564, -- Pattern: Dragonkiller Tunic
	[67538]=65891, -- Recipe: Vial of the Sands
	[67541]=54451, -- Pattern: High Society Top Hat
	[67603]=67602, -- Plans: Elementium Gutslicer
	[67606]=67605, -- Plans: Forged Elementium Mindcrusher
	[68193]=56550, -- Pattern: Dragonscale Leg Armor
	[68199]=54441, -- Pattern: Black Embersilk Gown
	[68359]=68356, -- Design: Willful Ember Topaz
	[68360]=68357, -- Design: Lucent Ember Topaz
	[68361]=68358, -- Design: Resplendent Ember Topaz
	[68688]=68687, -- Recipe: Scalding Murglesnout
	[68742]=68741, -- Design: Vivid Dream Emerald
	[68781]=68778, -- Design: Agile Shadowspirit Diamond
	[68782]=68779, -- Design: Reverberating Shadowspirit Diamond
	[68783]=68780, -- Design: Burning Shadowspirit Diamond
	[69820]=52113, -- Design: Reckless Hessonite
	[69853]=69852, -- Design: Punisher's Band
	[69957]=69936, -- Plans: Fists of Fury
	[69958]=69937, -- Plans: Eternal Elementium Handguards
	[69959]=69938, -- Plans: Holy Flame Gauntlets
	[69960]=69939, -- Pattern: Dragonfire Gloves
	[69961]=69941, -- Pattern: Gloves of Unforgiving Flame
	[69962]=69942, -- Pattern: Clutches of Evil
	[69963]=69943, -- Pattern: Heavenly Gloves of the Moon
	[69965]=69944, -- Pattern: Grips of Altered Reality
	[69966]=69945, -- Pattern: Don Tayo's Inferno Mittens
	[69968]=69946, -- Plans: Warboots of Mighty Lords
	[69969]=69947, -- Plans: Mirrored Boots
	[69970]=69948, -- Plans: Emberforged Elementium Boots
	[69971]=69949, -- Pattern: Earthen Scale Sabatons
	[69972]=69950, -- Pattern: Footwraps of Quenched Fire
	[69973]=69951, -- Pattern: Treads of the Craft
	[69974]=69952, -- Pattern: Ethereal Footfalls
	[69975]=69953, -- Pattern: Endless Dream Walkers
	[69976]=69954, -- Pattern: Boots of the Black Flame
	[70166]=70155, -- Plans: Brainsplinter
	[70167]=70156, -- Plans: Masterwork Elementium Spellblade
	[70168]=70157, -- Plans: Lightforged Elementium Hammer
	[70169]=70158, -- Plans: Elementium-Edged Scalper
	[70170]=70162, -- Plans: Pyrium Spellward
	[70171]=70163, -- Plans: Unbreakable Guardian
	[70172]=70164, -- Plans: Masterwork Elementium Deathblade
	[70173]=70165, -- Plans: Witch-Hunter's Harvester
	[70174]=70136, -- Pattern: Royal Scribe's Satchel
	[70175]=70137, -- Pattern: Triple-Reinforced Mining Bag
	[70176]=70138, -- Pattern: Luxurious Silk Gem Bag
	[70177]=70139, -- Schematic: Flintlocke's Woodchucker
	[71078]=71077, -- Schematic: Extreme-Impact Hole Puncher
	[71721]=71720, -- Pattern: Drakehide Leg Armor
	[71821]=71817, -- Design: Rigid Deepholm Iolite
	[71884]=77140, -- Design: Stormy Deepholm Iolite
	[71885]=71819, -- Design: Sparkling Deepholm Iolite
	[71886]=71820, -- Design: Solid Deepholm Iolite
	[71887]=71822, -- Design: Misty Elven Peridot
	[71888]=71823, -- Design: Piercing Elven Peridot
	[71889]=71824, -- Design: Lightning Elven Peridot
	[71890]=71825, -- Design: Sensei's Elven Peridot
	[71891]=77131, -- Design: Infused Elven Peridot
	[71892]=71827, -- Design: Zen Elven Peridot
	[71893]=77130, -- Design: Balanced Elven Peridot
	[71894]=77143, -- Design: Vivid Elven Peridot
	[71895]=77142, -- Design: Turbid Elven Peridot
	[71896]=77154, -- Design: Radiant Elven Peridot
	[71897]=77137, -- Design: Shattered Elven Peridot
	[71898]=71833, -- Design: Energized Elven Peridot
	[71899]=71834, -- Design: Jagged Elven Peridot
	[71900]=71835, -- Design: Regal Elven Peridot
	[71901]=71836, -- Design: Forceful Elven Peridot
	[71902]=71837, -- Design: Nimble Elven Peridot
	[71903]=71838, -- Design: Puissant Elven Peridot
	[71904]=77139, -- Design: Steady Elven Peridot
	[71905]=71840, -- Design: Deadly Lava Coral
	[71906]=71841, -- Design: Crafty Lava Coral
	[71907]=71842, -- Design: Potent Lava Coral
	[71908]=71843, -- Design: Inscribed Lava Coral
	[71909]=71844, -- Design: Polished Lava Coral
	[71910]=71845, -- Design: Resolute Lava Coral
	[71911]=71846, -- Design: Stalwart Lava Coral
	[71912]=71847, -- Design: Champion's Lava Coral
	[71913]=71848, -- Design: Deft Lava Coral
	[71914]=71849, -- Design: Wicked Lava Coral
	[71915]=71850, -- Design: Reckless Lava Coral
	[71916]=71851, -- Design: Fierce Lava Coral
	[71917]=71852, -- Design: Adept Lava Coral
	[71918]=71853, -- Design: Keen Lava Coral
	[71919]=71854, -- Design: Artful Lava Coral
	[71920]=71855, -- Design: Fine Lava Coral
	[71921]=71856, -- Design: Skillful Lava Coral
	[71922]=77132, -- Design: Lucent Lava Coral
	[71923]=77141, -- Design: Tenuous Lava Coral
	[71924]=77144, -- Design: Willful Lava Coral
	[71925]=77138, -- Design: Splendid Lava Coral
	[71926]=77136, -- Design: Resplendent Lava Coral
	[71927]=71862, -- Design: Glinting Shadow Spinel
	[71928]=71863, -- Design: Accurate Shadow Spinel
	[71929]=71864, -- Design: Veiled Shadow Spinel
	[71930]=71865, -- Design: Retaliating Shadow Spinel
	[71931]=71866, -- Design: Etched Shadow Spinel
	[71932]=77133, -- Design: Mysterious Shadow Spinel
	[71933]=71868, -- Design: Purified Shadow Spinel
	[71934]=71869, -- Design: Shifting Shadow Spinel
	[71935]=71870, -- Design: Guardian's Shadow Spinel
	[71936]=71871, -- Design: Timeless Shadow Spinel
	[71937]=71872, -- Design: Defender's Shadow Spinel
	[71938]=71873, -- Design: Sovereign Shadow Spinel
	[71939]=71879, -- Design: Delicate Queen's Garnet
	[71940]=71880, -- Design: Precise Queen's Garnet
	[71941]=71881, -- Design: Brilliant Queen's Garnet
	[71942]=71882, -- Design: Flashing Queen's Garnet
	[71943]=71883, -- Design: Bold Queen's Garnet
	[71944]=71874, -- Design: Smooth Lightstone
	[71945]=71875, -- Design: Subtle Lightstone
	[71946]=71876, -- Design: Quick Lightstone
	[71947]=71877, -- Design: Fractured Lightstone
	[71948]=77134, -- Design: Mystic Lightstone
	[71965]=52489, -- Design: Rhinestone Sunglasses
	[71999]=71986, -- Pattern: Leggings of Nature's Champion
	[72000]=71981, -- Pattern: World Mender's Pants
	[72001]=71982, -- Plans: Pyrium Legplates of Purified Evil
	[72002]=71980, -- Pattern: Lavaquake Legwraps
	[72003]=71990, -- Pattern: Dreamwraps of the Light
	[72004]=71989, -- Pattern: Bracers of Unconquered Power
	[72005]=71988, -- Pattern: Deathscale Leggings
	[72006]=71985, -- Pattern: Bladeshadow Leggings
	[72007]=71987, -- Pattern: Rended Earth Leggings
	[72008]=71995, -- Pattern: Bracers of Flowing Serenity
	[72009]=71997, -- Pattern: Thundering Deathscale Wristguards
	[72010]=71994, -- Pattern: Bladeshadow Wristguards
	[72011]=71996, -- Pattern: Bracers of the Hunter-Killer
	[72012]=71983, -- Plans: Unstoppable Destroyer's Legplates
	[72013]=71984, -- Plans: Foundations of Courage
	[72014]=71991, -- Plans: Soul Redeemer Bracers
	[72015]=71992, -- Plans: Bracers of Destructive Strength
	[72016]=71993, -- Plans: Titanguard Wristplates
	[72025]=8204, -- Pattern: Tough Scorpid Gloves
	[72026]=8205, -- Pattern: Tough Scorpid Bracers
	[72027]=8207, -- Pattern: Tough Scorpid Shoulders
	[72028]=8209, -- Pattern: Tough Scorpid Boots
	[72029]=8203, -- Pattern: Tough Scorpid Breastplate
	[72030]=8206, -- Pattern: Tough Scorpid Leggings
	[72033]=8208, -- Pattern: Tough Scorpid Helm
	[72102]=72101, -- Pattern: Black Silk Vest
	[74274]=7961, -- Plans: Phantom Blade
	[78345]=15046, -- Pattern: Green Dragonscale Leggings
	[78346]=15045, -- Pattern: Green Dragonscale Breastplate
})

-- how many items are crafted at a time (on average) by a recipe
Informant.SetCraftCount({
	[2701]=3, -- Recipe: Seasoned Wolf Kabob
	[3679]=2, -- Recipe: Blood Sausage
	[5484]=2, -- Recipe: Roasted Kodo Meat
	[5485]=2, -- Recipe: Fillet of Frenzy
	[5486]=2, -- Recipe: Strider Stew
	[5487]=2, -- Recipe: Dig Rat Stew
	[5488]=2, -- Recipe: Crispy Lizard Tail
	[5489]=2, -- Recipe: Lean Venison
	[6716]=2, -- Schematic: EZ-Thro Dynamite
	[12231]=2, -- Recipe: Jungle Stew
	[12240]=2, -- Recipe: Heavy Kodo Stew
	[13518]=2, -- Recipe: Potion of Petrification
	[13519]=2, -- Recipe: Flask of the Titans
	[13520]=2, -- Recipe: Flask of Distilled Wisdom
	[13521]=2, -- Recipe: Flask of Supreme Power
	[13522]=2, -- Recipe: Flask of Chromatic Resistance
	[16041]=3, -- Schematic: Thorium Grenade
	[16049]=3, -- Schematic: Dark Iron Bomb
	[16055]=3, -- Schematic: Arcane Bomb
	[16767]=2, -- Recipe: Undermine Clam Chowder
	[18647]=3, -- Schematic: Red Firework
	[18648]=3, -- Schematic: Green Firework
	[18649]=3, -- Schematic: Blue Firework
	[18654]=2, -- Schematic: Gnomish Alarm-o-Bot
	[19027]=4, -- Schematic: Snake Burst Firework
	[21025]=5, -- Recipe: Dirge's Kickin' Chimaerok Chops
	[21724]=3, -- Schematic: Small Blue Rocket
	[21725]=3, -- Schematic: Small Green Rocket
	[21726]=3, -- Schematic: Small Red Rocket
	[21727]=3, -- Schematic: Large Blue Rocket
	[21728]=3, -- Schematic: Large Green Rocket
	[21729]=3, -- Schematic: Large Red Rocket
	[21730]=3, -- Schematic: Blue Rocket Cluster
	[21731]=3, -- Schematic: Green Rocket Cluster
	[21732]=3, -- Schematic: Red Rocket Cluster
	[21733]=3, -- Schematic: Large Blue Rocket Cluster
	[21734]=3, -- Schematic: Large Green Rocket Cluster
	[21735]=3, -- Schematic: Large Red Rocket Cluster
	[21737]=2, -- Schematic: Cluster Launcher
	[22920]=5, -- Recipe: Major Fire Protection Potion
	[22921]=5, -- Recipe: Major Frost Protection Potion
	[22922]=5, -- Recipe: Major Nature Protection Potion
	[22923]=5, -- Recipe: Major Arcane Protection Potion
	[22924]=5, -- Recipe: Major Shadow Protection Potion
	[22925]=5, -- Recipe: Major Holy Protection Potion
	[23811]=3, -- Schematic: White Smoke Flare
	[23814]=3, -- Schematic: Green Smoke Flare
	[23874]=2, -- Schematic: Elemental Seaforium Charge
	[23883]=20, -- Schematic: Healing Potion Injector
	[23884]=20, -- Schematic: Mana Potion Injector
	[25887]=3, -- Schematic: Purple Smoke Flare
	[31354]=2, -- Recipe: Flask of the Titans
	[31355]=2, -- Recipe: Flask of Supreme Power
	[31356]=2, -- Recipe: Flask of Distilled Wisdom
	[31357]=2, -- Recipe: Flask of Chromatic Resistance
	[32381]=5, -- Schematic: Fused Wiring
	[33209]=2, -- Recipe: Flask of Chromatic Wonder
	[34114]=5, -- Schematic: Field Repair Bot 110G
	[34413]=2, -- Recipe: Hot Apple Cider
	[34834]=5, -- Recipe: Captain Rumsey's Lager
	[35310]=20, -- Schematic: Healing Potion Injector
	[35311]=20, -- Schematic: Mana Potion Injector
	[39644]=5, -- Recipe: Kungaloosh
	[43029]=4, -- Recipe: Critter Bites
	[43507]=5, -- Recipe: Tasty Cupcake
	[43508]=5, -- Recipe: Last Week's Mammoth
	[43509]=5, -- Recipe: Bad Clams
	[43510]=5, -- Recipe: Haunted Herring
	[44918]=2, -- Schematic: Cluster Launcher
	[44977]=2, -- Recipe: Dig Rat Stew
	[65433]=5, -- Recipe: South Island Iced Tea
	[66099]=2, -- Plans: Obsidium Skeleton Key
})

-- A list of items with skill or other requirements
Informant.SetRequirements({
	[118]="171:1",
	[724]="185:50",
	[733]="185:50",
	[787]="185:1",
	[858]="171:55",
	[929]="171:110",
	[954]="773:15",
	[955]="773:1",
	[1017]="185:100",
	[1082]="185:100",
	[1180]="773:1",
	[1181]="773:1",
	[1251]="129:1",
	[1477]="773:85",
	[1710]="171:155",
	[1711]="773:75",
	[1712]="773:75",
	[2289]="773:80",
	[2290]="773:75",
	[2300]="165:40",
	[2302]="165:1",
	[2303]="165:15",
	[2304]="165:1",
	[2307]="165:90",
	[2308]="165:85",
	[2309]="165:55",
	[2310]="165:60",
	[2311]="165:60",
	[2312]="165:75",
	[2313]="165:100",
	[2314]="165:120",
	[2315]="165:100",
	[2316]="165:110",
	[2317]="165:100",
	[2318]="165:1",
	[2319]="165:100",
	[2454]="171:1",
	[2455]="171:25",
	[2456]="171:40",
	[2457]="171:50",
	[2458]="171:50",
	[2459]="171:60",
	[2568]="197:10",
	[2569]="197:65",
	[2570]="197:1",
	[2572]="197:40",
	[2575]="197:40",
	[2576]="197:1",
	[2577]="197:40",
	[2578]="197:70",
	[2579]="197:70",
	[2580]="197:60",
	[2581]="129:40",
	[2582]="197:85",
	[2583]="197:95",
	[2584]="197:75",
	[2585]="197:105",
	[2587]="197:100",
	[2679]="185:1",
	[2680]="185:10",
	[2681]="185:1",
	[2682]="185:85",
	[2683]="185:75",
	[2684]="185:50",
	[2685]="185:110",
	[2687]="185:80",
	[2840]="186:1",
	[2841]="186:50",
	[2842]="186:65",
	[2844]="164:15",
	[2845]="164:20",
	[2847]="164:25",
	[2848]="164:110",
	[2849]="164:115",
	[2850]="164:120",
	[2851]="164:35",
	[2852]="164:1",
	[2853]="164:1",
	[2854]="164:90",
	[2857]="164:70",
	[2862]="164:1",
	[2863]="164:65",
	[2864]="164:80",
	[2865]="164:105",
	[2866]="164:105",
	[2868]="164:120",
	[2869]="164:130",
	[2870]="164:145",
	[2871]="164:125",
	[2888]="185:10",
	[2996]="197:1",
	[2997]="197:75",
	[3012]="773:15",
	[3220]="185:60",
	[3239]="164:1",
	[3240]="164:65",
	[3241]="164:125",
	[3382]="171:15",
	[3383]="171:90",
	[3384]="171:110",
	[3385]="171:120",
	[3386]="171:120",
	[3387]="171:250",
	[3388]="171:125",
	[3389]="171:130",
	[3390]="171:140",
	[3391]="171:150",
	[3469]="164:20",
	[3470]="164:25",
	[3471]="164:35",
	[3472]="164:40",
	[3473]="164:45",
	[3474]="164:60",
	[3478]="164:75",
	[3480]="164:110",
	[3481]="164:125",
	[3482]="164:130",
	[3483]="164:135",
	[3484]="164:145",
	[3485]="164:150",
	[3486]="164:125",
	[3487]="164:95",
	[3488]="164:35",
	[3489]="164:70",
	[3490]="164:125",
	[3491]="164:130",
	[3492]="164:145",
	[3530]="129:80",
	[3531]="129:115",
	[3575]="186:100",
	[3576]="186:50",
	[3577]="186:115",
	[3662]="185:80",
	[3663]="185:90",
	[3664]="185:120",
	[3665]="185:130",
	[3666]="185:110",
	[3719]="165:150",
	[3726]="185:1",
	[3727]="185:125",
	[3728]="185:150",
	[3729]="185:175",
	[3823]="171:165",
	[3824]="171:165",
	[3825]="171:175",
	[3826]="171:180",
	[3827]="171:160",
	[3828]="171:195",
	[3829]="171:200",
	[3835]="164:165",
	[3836]="164:170",
	[3837]="164:190",
	[3840]="164:160",
	[3841]="164:175",
	[3842]="164:155",
	[3843]="164:170",
	[3844]="164:180",
	[3845]="164:195",
	[3846]="164:185",
	[3847]="164:200",
	[3848]="164:105",
	[3849]="164:160",
	[3850]="164:175",
	[3851]="164:155",
	[3852]="164:170",
	[3853]="164:180",
	[3854]="164:200",
	[3855]="164:185",
	[3856]="164:200",
	[3859]="186:125",
	[3860]="186:150",
	[3928]="171:215",
	[4231]="165:35",
	[4233]="165:100",
	[4234]="165:150",
	[4236]="165:150",
	[4237]="165:25",
	[4238]="197:45",
	[4239]="165:55",
	[4240]="197:80",
	[4241]="197:95",
	[4242]="165:75",
	[4243]="165:85",
	[4244]="165:100",
	[4245]="197:150",
	[4246]="165:80",
	[4247]="165:145",
	[4248]="165:120",
	[4249]="165:125",
	[4250]="165:120",
	[4251]="165:130",
	[4252]="165:140",
	[4253]="165:135",
	[4254]="165:150",
	[4255]="165:155",
	[4256]="165:175",
	[4257]="165:160",
	[4258]="165:170",
	[4259]="165:180",
	[4260]="165:195",
	[4262]="165:185",
	[4264]="165:200",
	[4265]="165:150",
	[4304]="165:200",
	[4305]="197:125",
	[4307]="197:35",
	[4308]="197:60",
	[4309]="197:70",
	[4310]="197:85",
	[4311]="197:100",
	[4312]="197:80",
	[4313]="197:95",
	[4314]="197:110",
	[4315]="197:120",
	[4316]="197:110",
	[4317]="197:125",
	[4318]="197:130",
	[4319]="197:145",
	[4320]="197:125",
	[4321]="197:140",
	[4322]="197:165",
	[4323]="197:170",
	[4324]="197:150",
	[4325]="197:175",
	[4326]="197:185",
	[4327]="197:200",
	[4328]="197:180",
	[4329]="197:200",
	[4330]="197:110",
	[4331]="197:125",
	[4332]="197:135",
	[4333]="197:155",
	[4334]="197:170",
	[4335]="197:185",
	[4336]="197:200",
	[4339]="197:175",
	[4343]="197:30",
	[4344]="197:1",
	[4357]="202:1",
	[4358]="202:1",
	[4359]="202:30",
	[4360]="202:30",
	[4362]="202:50",
	[4364]="202:75",
	[4365]="202:75",
	[4366]="202:85",
	[4367]="202:100",
	[4368]="202:100",
	[4369]="202:105",
	[4370]="202:105",
	[4371]="202:105",
	[4372]="202:120",
	[4373]="202:120",
	[4374]="202:120",
	[4375]="202:125",
	[4376]="202:125",
	[4377]="202:125",
	[4378]="202:125",
	[4379]="202:130",
	[4380]="202:140",
	[4381]="202:140",
	[4382]="202:145",
	[4383]="202:145",
	[4384]="202:150",
	[4385]="202:150",
	[4386]="202:155",
	[4387]="202:160",
	[4388]="202:160",
	[4389]="202:170",
	[4390]="202:175",
	[4391]="202:175",
	[4392]="202:185",
	[4393]="202:185",
	[4394]="202:190",
	[4395]="202:195",
	[4396]="202:200",
	[4397]="202:200",
	[4398]="202:200",
	[4401]="202:75",
	[4403]="202:165",
	[4404]="202:90",
	[4405]="202:60",
	[4406]="202:110",
	[4407]="202:180",
	[4419]="773:165",
	[4422]="773:155",
	[4424]="773:160",
	[4425]="773:175",
	[4426]="773:170",
	[4455]="165:165",
	[4456]="165:165",
	[4457]="185:175",
	[4592]="185:50",
	[4593]="185:100",
	[4594]="185:175",
	[4596]="171:50",
	[4623]="171:215",
	[4852]="202:185",
	[5081]="165:40",
	[5095]="185:50",
	[5232]="354:0",
	[5472]="185:10",
	[5473]="185:20",
	[5474]="185:35",
	[5476]="185:50",
	[5477]="185:50",
	[5478]="185:1",
	[5479]="185:100",
	[5480]="185:110",
	[5507]="202:135",
	[5525]="185:50",
	[5526]="185:90",
	[5527]="185:125",
	[5540]="164:110",
	[5541]="164:140",
	[5542]="197:90",
	[5631]="171:60",
	[5633]="171:175",
	[5634]="171:150",
	[5739]="165:190",
	[5762]="197:70",
	[5763]="197:115",
	[5764]="197:175",
	[5765]="197:185",
	[5766]="197:135",
	[5770]="197:150",
	[5780]="165:90",
	[5781]="165:95",
	[5782]="165:170",
	[5783]="165:190",
	[5957]="165:1",
	[5958]="165:105",
	[5961]="165:115",
	[5962]="165:160",
	[5963]="165:170",
	[5964]="165:175",
	[5965]="165:185",
	[5966]="165:190",
	[5996]="171:90",
	[5997]="171:1",
	[6037]="186:165",
	[6038]="185:175",
	[6040]="164:185",
	[6041]="164:190",
	[6042]="164:150",
	[6043]="164:165",
	[6048]="171:135",
	[6049]="171:165",
	[6050]="171:190",
	[6051]="171:100",
	[6052]="171:190",
	[6149]="171:205",
	[6214]="164:65",
	[6218]="333:1",
	[6219]="202:50",
	[6238]="197:30",
	[6239]="197:55",
	[6240]="197:55",
	[6241]="197:30",
	[6242]="197:70",
	[6263]="197:100",
	[6264]="197:115",
	[6290]="185:1",
	[6316]="185:50",
	[6338]="164:100",
	[6339]="333:100",
	[6350]="164:95",
	[6370]="171:80",
	[6371]="171:130",
	[6372]="171:100",
	[6373]="171:140",
	[6384]="197:120",
	[6385]="197:120",
	[6450]="129:150",
	[6451]="129:180",
	[6452]="129:80",
	[6453]="129:130",
	[6466]="165:90",
	[6467]="165:105",
	[6468]="165:115",
	[6533]="202:150",
	[6657]="185:85",
	[6662]="171:90",
	[6709]="165:90",
	[6712]="202:100",
	[6714]="202:100",
	[6731]="164:100",
	[6786]="197:40",
	[6787]="197:110",
	[6795]="197:160",
	[6796]="197:175",
	[6836]="197:250",
	[6887]="185:225",
	[6888]="185:1",
	[6890]="185:40",
	[7026]="197:15",
	[7046]="197:140",
	[7047]="197:145",
	[7048]="197:145",
	[7049]="197:150",
	[7050]="197:160",
	[7051]="197:170",
	[7052]="197:175",
	[7053]="197:175",
	[7054]="197:190",
	[7055]="197:175",
	[7056]="197:180",
	[7057]="197:180",
	[7058]="197:185",
	[7059]="197:190",
	[7060]="197:190",
	[7061]="197:195",
	[7062]="197:195",
	[7063]="197:205",
	[7064]="197:210",
	[7065]="197:165",
	[7068]="171:300",
	[7071]="164:150",
	[7076]="171:275",
	[7078]="171:275",
	[7080]="171:275",
	[7082]="171:275",
	[7148]="202:165",
	[7166]="164:30",
	[7189]="202:130",
	[7191]="202:275",
	[7276]="165:1",
	[7277]="165:1",
	[7280]="165:35",
	[7281]="165:70",
	[7282]="165:95",
	[7283]="165:100",
	[7284]="165:120",
	[7285]="165:120",
	[7348]="165:125",
	[7349]="165:135",
	[7352]="165:135",
	[7358]="165:140",
	[7359]="165:145",
	[7373]="165:165",
	[7374]="165:175",
	[7375]="165:175",
	[7377]="165:180",
	[7378]="165:185",
	[7386]="165:190",
	[7387]="165:195",
	[7390]="165:200",
	[7391]="165:200",
	[7506]="202:125",
	[7676]="185:60",
	[7913]="164:160",
	[7914]="164:160",
	[7915]="164:175",
	[7916]="164:180",
	[7917]="164:185",
	[7918]="164:205",
	[7919]="164:205",
	[7920]="164:210",
	[7921]="164:210",
	[7922]="164:215",
	[7924]="164:215",
	[7926]="164:220",
	[7927]="164:220",
	[7928]="164:225",
	[7929]="164:230",
	[7930]="164:230",
	[7931]="164:230",
	[7932]="164:235",
	[7933]="164:235",
	[7934]="164:245",
	[7935]="164:240",
	[7936]="164:245",
	[7937]="164:245",
	[7938]="164:0",
	[7939]="164:0",
	[7941]="164:210",
	[7942]="164:220",
	[7943]="164:225",
	[7944]="164:240",
	[7945]="164:230",
	[7946]="164:245",
	[7947]="164:255",
	[7954]="164:0",
	[7955]="164:30",
	[7956]="164:125",
	[7957]="164:130",
	[7958]="164:135",
	[7959]="164:0",
	[7960]="164:0",
	[7961]="164:270",
	[7963]="164:200",
	[7964]="164:200",
	[7965]="164:200",
	[7966]="164:200",
	[7967]="164:215",
	[7969]="164:235",
	[8170]="165:250",
	[8172]="165:200",
	[8173]="165:200",
	[8174]="165:200",
	[8175]="165:205",
	[8176]="165:205",
	[8185]="165:235",
	[8187]="165:205",
	[8189]="165:210",
	[8191]="165:230",
	[8192]="165:210",
	[8193]="165:230",
	[8197]="165:235",
	[8198]="165:210",
	[8200]="165:215",
	[8201]="165:220",
	[8202]="165:240",
	[8203]="165:220",
	[8204]="165:225",
	[8205]="165:220",
	[8206]="165:245",
	[8207]="165:240",
	[8208]="165:250",
	[8209]="165:235",
	[8210]="165:220",
	[8211]="165:225",
	[8212]="165:250",
	[8213]="165:245",
	[8214]="165:225",
	[8215]="165:250",
	[8216]="165:240",
	[8345]="165:0",
	[8346]="165:230",
	[8347]="165:0",
	[8348]="165:250",
	[8349]="165:250",
	[8364]="185:175",
	[8367]="165:255",
	[8544]="129:210",
	[8545]="129:240",
	[8827]="171:400",
	[8949]="171:185",
	[8951]="171:195",
	[8956]="171:205",
	[9030]="171:210",
	[9036]="171:210",
	[9060]="164:200",
	[9061]="171:210",
	[9088]="171:240",
	[9144]="171:225",
	[9149]="171:225",
	[9154]="171:230",
	[9155]="171:235",
	[9172]="171:235",
	[9179]="171:235",
	[9187]="171:240",
	[9197]="171:240",
	[9206]="171:245",
	[9210]="171:245",
	[9224]="171:250",
	[9233]="171:250",
	[9264]="171:250",
	[9312]="202:150",
	[9313]="202:150",
	[9318]="202:150",
	[9366]="164:205",
	[9998]="197:205",
	[9999]="197:205",
	[10001]="197:210",
	[10002]="197:210",
	[10003]="197:215",
	[10004]="197:215",
	[10007]="197:215",
	[10008]="197:215",
	[10009]="197:215",
	[10018]="197:225",
	[10019]="197:225",
	[10021]="197:225",
	[10023]="197:225",
	[10024]="197:230",
	[10025]="197:245",
	[10026]="197:230",
	[10027]="197:230",
	[10028]="197:235",
	[10029]="197:235",
	[10030]="197:240",
	[10031]="197:240",
	[10033]="197:240",
	[10034]="197:240",
	[10035]="197:245",
	[10036]="197:250",
	[10040]="197:250",
	[10041]="197:250",
	[10042]="197:225",
	[10044]="197:245",
	[10045]="197:1",
	[10046]="197:20",
	[10047]="197:75",
	[10048]="197:120",
	[10050]="197:225",
	[10051]="197:235",
	[10052]="197:220",
	[10053]="197:235",
	[10054]="197:230",
	[10055]="197:235",
	[10056]="197:215",
	[10306]="773:210",
	[10307]="773:205",
	[10308]="773:215",
	[10309]="773:225",
	[10310]="773:220",
	[10421]="164:1",
	[10423]="164:155",
	[10498]="202:175",
	[10499]="202:175",
	[10500]="202:205",
	[10501]="202:220",
	[10502]="202:225",
	[10503]="202:230",
	[10504]="202:245",
	[10505]="202:175",
	[10506]="202:230",
	[10507]="202:175",
	[10508]="202:205",
	[10510]="202:220",
	[10514]="202:215",
	[10518]="202:225",
	[10542]="202:205",
	[10543]="202:205",
	[10545]="202:215",
	[10546]="202:210",
	[10548]="202:240",
	[10558]="202:150",
	[10559]="202:195",
	[10560]="202:200",
	[10561]="202:215",
	[10562]="202:235",
	[10576]="202:250",
	[10577]="202:205",
	[10586]="202:235",
	[10587]="202:230",
	[10588]="202:245",
	[10592]="171:200",
	[10644]="202:205",
	[10645]="202:240",
	[10646]="202:205",
	[10713]="202:205",
	[10716]="202:205",
	[10720]="202:210",
	[10721]="202:215",
	[10724]="202:210",
	[10725]="202:230",
	[10726]="202:235",
	[10727]="202:240",
	[10841]="185:175",
	[11128]="164:150",
	[11130]="333:150",
	[11144]="164:200",
	[11145]="333:200",
	[11287]="333:10",
	[11288]="333:70",
	[11289]="333:155",
	[11290]="333:175",
	[11371]="186:230",
	[11590]="202:200",
	[11604]="164:285",
	[11605]="164:280",
	[11606]="164:270",
	[11607]="164:275",
	[11608]="164:265",
	[11811]="333:265",
	[11825]="202:205",
	[11826]="202:205",
	[12190]="171:230",
	[12209]="185:125",
	[12210]="185:175",
	[12212]="185:175",
	[12213]="185:175",
	[12214]="185:175",
	[12215]="185:200",
	[12216]="185:225",
	[12217]="185:200",
	[12218]="185:225",
	[12224]="185:1",
	[12259]="164:180",
	[12260]="164:190",
	[12359]="186:230",
	[12360]="171:275",
	[12404]="164:250",
	[12405]="164:250",
	[12406]="164:250",
	[12408]="164:255",
	[12409]="164:280",
	[12410]="164:280",
	[12414]="164:300",
	[12415]="164:270",
	[12416]="164:260",
	[12417]="164:295",
	[12418]="164:285",
	[12419]="164:290",
	[12420]="164:300",
	[12422]="164:300",
	[12424]="164:265",
	[12425]="164:270",
	[12426]="164:295",
	[12427]="164:295",
	[12428]="164:265",
	[12429]="164:300",
	[12610]="164:300",
	[12611]="164:300",
	[12612]="164:300",
	[12613]="164:300",
	[12614]="164:300",
	[12618]="164:300",
	[12619]="164:300",
	[12620]="164:300",
	[12624]="164:270",
	[12625]="164:290",
	[12628]="164:285",
	[12631]="164:290",
	[12632]="164:295",
	[12633]="164:300",
	[12636]="164:300",
	[12639]="164:300",
	[12640]="164:300",
	[12641]="164:300",
	[12643]="164:250",
	[12644]="164:250",
	[12645]="164:275",
	[12655]="333:250",
	[12773]="164:275",
	[12774]="164:275",
	[12775]="164:280",
	[12776]="164:280",
	[12777]="164:280",
	[12781]="164:285",
	[12782]="164:290",
	[12783]="164:300",
	[12784]="164:300",
	[12790]="164:300",
	[12792]="164:290",
	[12794]="164:300",
	[12796]="164:300",
	[12797]="164:300",
	[12798]="164:300",
	[12803]="171:275",
	[12808]="171:275",
	[12810]="333:250",
	[13423]="171:250",
	[13442]="171:255",
	[13443]="171:260",
	[13444]="171:295",
	[13445]="171:265",
	[13446]="171:275",
	[13447]="171:270",
	[13452]="171:280",
	[13453]="171:275",
	[13454]="171:285",
	[13455]="171:280",
	[13456]="171:290",
	[13457]="171:290",
	[13458]="171:290",
	[13459]="171:290",
	[13461]="171:290",
	[13462]="171:285",
	[13503]="171:350",
	[13506]="171:300",
	[13510]="171:300",
	[13511]="171:300",
	[13512]="171:300",
	[13513]="171:300",
	[13851]="185:175",
	[13856]="197:255",
	[13857]="197:260",
	[13858]="197:260",
	[13860]="197:265",
	[13863]="197:275",
	[13864]="197:280",
	[13865]="197:285",
	[13866]="197:295",
	[13867]="197:300",
	[13868]="197:255",
	[13869]="197:255",
	[13870]="197:265",
	[13871]="197:280",
	[13927]="185:225",
	[13928]="185:240",
	[13929]="185:240",
	[13930]="185:225",
	[13931]="185:250",
	[13932]="185:250",
	[13933]="185:275",
	[13934]="185:275",
	[13935]="185:275",
	[14042]="197:260",
	[14043]="197:270",
	[14044]="197:275",
	[14045]="197:280",
	[14046]="197:260",
	[14048]="197:250",
	[14100]="197:270",
	[14101]="197:270",
	[14103]="197:275",
	[14104]="197:290",
	[14106]="197:300",
	[14107]="197:275",
	[14108]="197:285",
	[14111]="197:290",
	[14112]="197:300",
	[14128]="197:300",
	[14130]="197:300",
	[14132]="197:275",
	[14134]="197:275",
	[14136]="197:285",
	[14137]="197:290",
	[14138]="197:300",
	[14139]="197:300",
	[14140]="197:300",
	[14141]="197:275",
	[14142]="197:270",
	[14143]="197:265",
	[14144]="197:290",
	[14146]="197:300",
	[14152]="197:300",
	[14153]="197:300",
	[14154]="197:300",
	[14155]="197:300",
	[14156]="197:300",
	[14342]="197:250",
	[14529]="129:260",
	[14530]="129:290",
	[15045]="165:260",
	[15046]="165:270",
	[15047]="165:300",
	[15048]="165:285",
	[15049]="165:295",
	[15050]="165:290",
	[15051]="165:300",
	[15052]="165:300",
	[15053]="165:285",
	[15054]="165:270",
	[15055]="165:300",
	[15056]="165:285",
	[15057]="165:275",
	[15058]="165:295",
	[15059]="165:300",
	[15060]="165:285",
	[15061]="165:270",
	[15062]="165:300",
	[15063]="165:290",
	[15064]="165:275",
	[15065]="165:285",
	[15066]="165:290",
	[15067]="165:270",
	[15068]="165:300",
	[15069]="165:285",
	[15070]="165:295",
	[15071]="165:275",
	[15072]="165:280",
	[15073]="165:275",
	[15074]="165:265",
	[15075]="165:290",
	[15076]="165:265",
	[15077]="165:255",
	[15078]="165:275",
	[15079]="165:285",
	[15080]="165:295",
	[15081]="165:300",
	[15082]="165:280",
	[15083]="165:260",
	[15084]="165:265",
	[15085]="165:300",
	[15086]="165:280",
	[15087]="165:290",
	[15088]="165:300",
	[15090]="165:300",
	[15091]="165:270",
	[15092]="165:275",
	[15093]="165:280",
	[15094]="165:290",
	[15095]="165:300",
	[15096]="165:300",
	[15138]="165:300",
	[15407]="165:250",
	[15564]="165:250",
	[15802]="197:290",
	[15846]="202:250",
	[15869]="164:100",
	[15870]="164:150",
	[15871]="164:200",
	[15872]="164:275",
	[15992]="202:250",
	[15993]="202:260",
	[15994]="202:260",
	[15995]="202:260",
	[15996]="202:265",
	[15999]="202:270",
	[16000]="202:275",
	[16004]="202:275",
	[16005]="202:285",
	[16006]="202:285",
	[16007]="202:300",
	[16008]="202:290",
	[16009]="202:290",
	[16022]="202:300",
	[16023]="202:275",
	[16040]="202:300",
	[16206]="164:275",
	[16207]="333:290",
	[16766]="185:225",
	[16979]="197:300",
	[16980]="197:300",
	[16982]="165:295",
	[16983]="165:300",
	[16984]="165:300",
	[16988]="164:300",
	[16989]="164:295",
	[17013]="164:300",
	[17014]="164:295",
	[17015]="164:300",
	[17016]="164:300",
	[17193]="164:300",
	[17197]="185:1",
	[17198]="185:35",
	[17222]="185:200",
	[17704]="164:190",
	[17708]="171:190",
	[17716]="202:190",
	[17721]="165:190",
	[17723]="197:190",
	[17771]="186:300",
	[18045]="185:225",
	[18168]="202:300",
	[18232]="202:300",
	[18238]="165:200",
	[18251]="165:300",
	[18253]="171:300",
	[18254]="185:275",
	[18258]="197:275",
	[18262]="164:300",
	[18263]="197:300",
	[18282]="202:300",
	[18283]="202:300",
	[18294]="171:215",
	[18405]="197:300",
	[18407]="197:300",
	[18408]="197:300",
	[18409]="197:300",
	[18413]="197:300",
	[18486]="197:300",
	[18504]="165:300",
	[18506]="165:300",
	[18508]="165:300",
	[18509]="165:300",
	[18510]="165:300",
	[18511]="165:300",
	[18587]="202:265",
	[18588]="202:200",
	[18594]="202:275",
	[18631]="202:260",
	[18634]="202:260",
	[18637]="202:275",
	[18638]="202:290",
	[18639]="202:300",
	[18641]="202:250",
	[18645]="202:265",
	[18660]="202:260",
	[18662]="165:150",
	[18948]="165:155",
	[18984]="202:260",
	[18986]="202:260",
	[19026]="202:250",
	[19043]="164:290",
	[19044]="165:290",
	[19047]="197:290",
	[19048]="164:300",
	[19049]="165:300",
	[19050]="197:300",
	[19051]="164:290",
	[19052]="165:290",
	[19056]="197:290",
	[19057]="164:300",
	[19058]="165:300",
	[19059]="197:300",
	[19148]="164:300",
	[19149]="165:300",
	[19156]="197:300",
	[19157]="165:300",
	[19162]="165:300",
	[19163]="165:300",
	[19164]="164:300",
	[19165]="197:300",
	[19166]="164:300",
	[19167]="164:300",
	[19168]="164:300",
	[19169]="164:300",
	[19170]="164:300",
	[19440]="129:300",
	[19682]="197:300",
	[19683]="197:300",
	[19684]="197:300",
	[19685]="165:300",
	[19686]="165:300",
	[19687]="165:300",
	[19688]="165:300",
	[19689]="165:300",
	[19690]="164:300",
	[19691]="164:300",
	[19692]="164:300",
	[19693]="164:300",
	[19694]="164:300",
	[19695]="164:300",
	[19931]="171:300",
	[19998]="202:300",
	[19999]="202:300",
	[20002]="171:275",
	[20004]="171:290",
	[20007]="171:275",
	[20008]="171:285",
	[20039]="164:300",
	[20074]="185:150",
	[20295]="165:300",
	[20296]="165:280",
	[20380]="165:300",
	[20452]="185:285",
	[20475]="202:0",
	[20476]="165:300",
	[20477]="165:300",
	[20478]="165:300",
	[20479]="165:300",
	[20480]="165:300",
	[20481]="165:300",
	[20537]="197:300",
	[20538]="197:300",
	[20539]="197:300",
	[20549]="164:300",
	[20550]="164:300",
	[20551]="164:300",
	[20575]="165:100",
	[20744]="333:45",
	[20745]="333:150",
	[20746]="333:200",
	[20747]="333:250",
	[20748]="333:300",
	[20749]="333:300",
	[20750]="333:275",
	[20816]="755:1",
	[20817]="755:50",
	[20818]="755:50",
	[20820]="755:60",
	[20821]="755:30",
	[20823]="755:70",
	[20826]="755:90",
	[20827]="755:80",
	[20828]="755:100",
	[20830]="755:110",
	[20831]="755:150",
	[20832]="755:120",
	[20833]="755:125",
	[20906]="755:1",
	[20907]="755:50",
	[20909]="755:110",
	[20950]="755:120",
	[20954]="755:125",
	[20955]="755:135",
	[20958]="755:150",
	[20959]="755:170",
	[20960]="755:170",
	[20961]="755:180",
	[20963]="755:150",
	[20964]="755:210",
	[20966]="755:160",
	[20967]="755:190",
	[20969]="755:225",
	[21023]="185:300",
	[21072]="185:80",
	[21154]="197:250",
	[21217]="185:175",
	[21277]="202:250",
	[21278]="165:300",
	[21340]="197:260",
	[21341]="197:280",
	[21342]="197:300",
	[21542]="197:250",
	[21546]="171:250",
	[21557]="202:125",
	[21558]="202:125",
	[21559]="202:125",
	[21569]="202:225",
	[21570]="202:275",
	[21571]="202:225",
	[21574]="202:225",
	[21576]="202:225",
	[21589]="202:175",
	[21590]="202:175",
	[21592]="202:175",
	[21714]="202:275",
	[21716]="202:275",
	[21718]="202:275",
	[21748]="755:200",
	[21752]="755:225",
	[21753]="755:250",
	[21754]="755:245",
	[21755]="755:220",
	[21756]="755:200",
	[21758]="755:215",
	[21760]="755:225",
	[21763]="755:235",
	[21764]="755:235",
	[21765]="755:240",
	[21766]="755:250",
	[21767]="755:260",
	[21768]="755:275",
	[21769]="755:260",
	[21774]="755:275",
	[21775]="755:280",
	[21777]="755:285",
	[21778]="755:285",
	[21779]="755:310",
	[21780]="755:325",
	[21784]="755:300",
	[21789]="755:300",
	[21790]="755:280",
	[21791]="755:290",
	[21792]="755:305",
	[21793]="755:315",
	[21840]="197:300",
	[21841]="197:315",
	[21842]="197:325",
	[21843]="197:340",
	[21844]="197:345",
	[21845]="197:350",
	[21846]="197:355",
	[21847]="197:365",
	[21848]="197:375",
	[21849]="197:310",
	[21850]="197:310",
	[21851]="197:320",
	[21852]="197:325",
	[21853]="197:335",
	[21854]="197:340",
	[21855]="197:345",
	[21858]="197:375",
	[21859]="197:340",
	[21860]="197:350",
	[21861]="197:360",
	[21862]="197:360",
	[21863]="197:355",
	[21864]="197:365",
	[21865]="197:375",
	[21866]="197:350",
	[21867]="197:360",
	[21868]="197:370",
	[21869]="197:355",
	[21870]="197:365",
	[21871]="197:375",
	[21872]="197:375",
	[21873]="197:355",
	[21874]="197:365",
	[21875]="197:375",
	[21876]="197:375",
	[21884]="171:300",
	[21885]="171:300",
	[21886]="171:300",
	[21887]="165:300",
	[21931]="755:1",
	[21932]="755:5",
	[21933]="755:50",
	[21934]="755:30",
	[21990]="129:300",
	[21991]="129:330",
	[22191]="164:300",
	[22194]="164:300",
	[22195]="164:300",
	[22196]="164:300",
	[22197]="164:300",
	[22198]="164:300",
	[22246]="197:225",
	[22248]="197:275",
	[22249]="197:300",
	[22251]="197:275",
	[22252]="197:300",
	[22383]="164:300",
	[22384]="164:300",
	[22385]="164:300",
	[22448]="333:300",
	[22449]="333:335",
	[22451]="171:350",
	[22452]="171:300",
	[22456]="171:300",
	[22457]="171:300",
	[22459]="333:350",
	[22460]="333:325",
	[22461]="333:300",
	[22462]="333:350",
	[22463]="333:375",
	[22521]="333:310",
	[22522]="333:340",
	[22573]="186:300",
	[22574]="186:300",
	[22645]="185:60",
	[22652]="197:300",
	[22654]="197:300",
	[22655]="197:300",
	[22658]="197:300",
	[22660]="197:300",
	[22661]="165:300",
	[22662]="165:300",
	[22663]="165:300",
	[22664]="165:300",
	[22665]="165:300",
	[22666]="165:300",
	[22669]="164:300",
	[22670]="164:300",
	[22671]="164:300",
	[22728]="202:275",
	[22756]="197:300",
	[22757]="197:300",
	[22758]="197:300",
	[22759]="165:300",
	[22760]="165:300",
	[22761]="165:300",
	[22762]="164:300",
	[22763]="164:300",
	[22764]="164:300",
	[22823]="171:305",
	[22824]="171:305",
	[22825]="171:310",
	[22826]="171:315",
	[22827]="171:320",
	[22828]="171:320",
	[22829]="171:325",
	[22830]="171:325",
	[22831]="171:330",
	[22832]="171:340",
	[22833]="171:345",
	[22834]="171:345",
	[22835]="171:350",
	[22836]="171:350",
	[22837]="171:350",
	[22838]="171:350",
	[22839]="171:350",
	[22840]="171:355",
	[22841]="171:360",
	[22842]="171:360",
	[22844]="171:360",
	[22845]="171:360",
	[22846]="171:360",
	[22847]="171:360",
	[22848]="171:365",
	[22849]="171:365",
	[22850]="171:300",
	[22851]="171:300",
	[22853]="171:300",
	[22854]="171:300",
	[22861]="171:300",
	[22866]="171:300",
	[22871]="171:335",
	[23094]="755:300",
	[23095]="755:305",
	[23098]="755:300",
	[23099]="755:305",
	[23100]="755:315",
	[23101]="755:325",
	[23103]="755:300",
	[23104]="755:305",
	[23105]="755:315",
	[23108]="755:300",
	[23109]="755:305",
	[23110]="755:325",
	[23111]="755:325",
	[23114]="755:325",
	[23115]="755:315",
	[23116]="755:325",
	[23118]="755:300",
	[23119]="755:325",
	[23120]="755:315",
	[23445]="186:275",
	[23446]="186:325",
	[23447]="186:350",
	[23448]="186:350",
	[23449]="186:375",
	[23482]="164:300",
	[23484]="164:305",
	[23487]="164:315",
	[23488]="164:315",
	[23489]="164:325",
	[23490]="164:320",
	[23491]="164:310",
	[23493]="164:300",
	[23494]="164:315",
	[23497]="164:310",
	[23498]="164:315",
	[23499]="164:320",
	[23502]="164:325",
	[23503]="164:330",
	[23504]="164:330",
	[23505]="164:335",
	[23506]="164:335",
	[23507]="164:340",
	[23508]="164:335",
	[23509]="164:360",
	[23510]="164:355",
	[23511]="164:355",
	[23512]="164:365",
	[23513]="164:365",
	[23514]="164:360",
	[23515]="164:350",
	[23516]="164:355",
	[23517]="164:360",
	[23518]="164:360",
	[23519]="164:365",
	[23520]="164:365",
	[23521]="164:365",
	[23522]="164:370",
	[23523]="164:360",
	[23524]="164:360",
	[23525]="164:365",
	[23526]="164:370",
	[23527]="164:370",
	[23528]="164:300",
	[23529]="164:350",
	[23530]="164:360",
	[23531]="164:365",
	[23532]="164:365",
	[23533]="164:365",
	[23534]="164:365",
	[23535]="164:365",
	[23536]="164:365",
	[23537]="164:365",
	[23538]="164:365",
	[23539]="164:365",
	[23540]="164:365",
	[23541]="164:365",
	[23542]="164:365",
	[23543]="164:365",
	[23544]="164:365",
	[23546]="164:365",
	[23554]="164:365",
	[23555]="164:365",
	[23556]="164:365",
	[23559]="164:325",
	[23563]="164:0",
	[23564]="164:0",
	[23565]="164:0",
	[23571]="171:350",
	[23573]="186:375",
	[23575]="164:340",
	[23576]="164:375",
	[23736]="202:300",
	[23737]="202:325",
	[23742]="202:320",
	[23746]="202:350",
	[23747]="202:360",
	[23748]="202:375",
	[23758]="202:340",
	[23761]="202:340",
	[23762]="202:350",
	[23763]="202:360",
	[23764]="202:335",
	[23765]="202:360",
	[23766]="202:375",
	[23767]="202:325",
	[23768]="202:335",
	[23771]="202:335",
	[23774]="202:325",
	[23775]="202:405",
	[23781]="202:300",
	[23782]="202:300",
	[23783]="202:300",
	[23784]="202:325",
	[23785]="202:340",
	[23786]="202:340",
	[23787]="202:340",
	[23793]="165:325",
	[23819]="202:350",
	[23821]="202:305",
	[23824]="202:355",
	[23825]="202:350",
	[23826]="202:325",
	[23827]="202:340",
	[23828]="202:375",
	[23829]="202:375",
	[23835]="202:340",
	[23836]="202:350",
	[23838]="202:375",
	[23839]="202:375",
	[23841]="202:325",
	[24027]="755:350",
	[24028]="755:350",
	[24030]="755:350",
	[24032]="755:350",
	[24033]="755:350",
	[24035]="755:350",
	[24036]="755:350",
	[24039]="755:350",
	[24048]="755:350",
	[24051]="755:350",
	[24053]="755:350",
	[24054]="755:350",
	[24055]="755:350",
	[24056]="755:350",
	[24058]="755:350",
	[24059]="755:350",
	[24060]="755:350",
	[24061]="755:350",
	[24065]="755:350",
	[24066]="755:350",
	[24067]="755:350",
	[24074]="755:305",
	[24075]="755:305",
	[24076]="755:320",
	[24077]="755:335",
	[24078]="755:335",
	[24079]="755:350",
	[24080]="755:355",
	[24082]="755:355",
	[24085]="755:360",
	[24086]="755:365",
	[24087]="755:345",
	[24088]="755:355",
	[24089]="755:365",
	[24092]="755:360",
	[24093]="755:360",
	[24095]="755:360",
	[24097]="755:360",
	[24098]="755:360",
	[24105]="185:1",
	[24106]="755:355",
	[24110]="755:355",
	[24114]="755:360",
	[24116]="755:360",
	[24117]="755:365",
	[24121]="755:365",
	[24122]="755:370",
	[24123]="755:370",
	[24124]="755:370",
	[24125]="755:370",
	[24126]="755:370",
	[24127]="755:370",
	[24128]="755:370",
	[24249]="197:350",
	[24250]="197:350",
	[24251]="197:350",
	[24252]="197:350",
	[24253]="197:350",
	[24254]="197:350",
	[24255]="197:365",
	[24256]="197:365",
	[24257]="197:365",
	[24258]="197:365",
	[24259]="197:365",
	[24260]="197:365",
	[24261]="197:375",
	[24262]="197:375",
	[24263]="197:375",
	[24264]="197:375",
	[24266]="197:375",
	[24267]="197:375",
	[24268]="197:300",
	[24270]="197:340",
	[24271]="197:350",
	[24272]="197:350",
	[24273]="197:335",
	[24274]="197:375",
	[24275]="197:335",
	[24276]="197:375",
	[25438]="755:20",
	[25439]="755:20",
	[25498]="755:1",
	[25521]="164:350",
	[25650]="165:300",
	[25651]="165:325",
	[25652]="165:325",
	[25653]="165:350",
	[25654]="165:300",
	[25655]="165:310",
	[25656]="165:320",
	[25657]="165:335",
	[25659]="165:335",
	[25660]="165:325",
	[25661]="165:310",
	[25662]="165:300",
	[25668]="165:320",
	[25669]="165:300",
	[25670]="165:315",
	[25671]="165:330",
	[25673]="165:300",
	[25674]="165:310",
	[25675]="165:320",
	[25676]="165:330",
	[25679]="165:300",
	[25680]="165:350",
	[25681]="165:350",
	[25682]="165:350",
	[25683]="165:350",
	[25685]="165:340",
	[25686]="165:350",
	[25687]="165:350",
	[25689]="165:360",
	[25690]="165:355",
	[25691]="165:355",
	[25692]="165:340",
	[25693]="165:350",
	[25694]="165:340",
	[25695]="165:350",
	[25696]="165:360",
	[25697]="165:360",
	[25843]="164:300",
	[25844]="164:350",
	[25845]="164:360",
	[25867]="171:350",
	[25868]="171:350",
	[25880]="755:50",
	[25881]="755:110",
	[25882]="755:175",
	[25883]="755:225",
	[25886]="202:335",
	[25890]="755:365",
	[25893]="755:365",
	[25894]="755:365",
	[25895]="755:365",
	[25896]="755:365",
	[25897]="755:365",
	[25898]="755:365",
	[25899]="755:365",
	[25901]="755:365",
	[27498]="773:270",
	[27499]="773:260",
	[27501]="773:255",
	[27502]="773:250",
	[27503]="773:265",
	[27635]="185:1",
	[27636]="185:50",
	[27651]="185:300",
	[27655]="185:300",
	[27657]="185:315",
	[27658]="185:325",
	[27659]="185:325",
	[27660]="185:325",
	[27661]="185:300",
	[27662]="185:300",
	[27663]="185:310",
	[27664]="185:320",
	[27665]="185:320",
	[27666]="185:325",
	[27667]="185:350",
	[28100]="171:300",
	[28101]="171:310",
	[28102]="171:300",
	[28103]="171:300",
	[28104]="171:315",
	[28420]="164:300",
	[28421]="164:350",
	[28425]="164:0",
	[28426]="164:0",
	[28427]="164:0",
	[28428]="164:0",
	[28429]="164:0",
	[28430]="164:0",
	[28431]="164:0",
	[28432]="164:0",
	[28433]="164:0",
	[28434]="164:0",
	[28435]="164:0",
	[28436]="164:0",
	[28437]="164:0",
	[28438]="164:0",
	[28439]="164:0",
	[28440]="164:0",
	[28441]="164:0",
	[28442]="164:0",
	[28483]="164:0",
	[28484]="164:0",
	[28485]="164:0",
	[28595]="755:305",
	[29157]="755:180",
	[29158]="755:200",
	[29159]="755:280",
	[29160]="755:290",
	[29201]="164:100",
	[29202]="164:200",
	[29203]="164:300",
	[29204]="164:350",
	[29483]="165:340",
	[29485]="165:340",
	[29486]="165:340",
	[29487]="165:340",
	[29488]="165:340",
	[29489]="165:350",
	[29490]="165:350",
	[29491]="165:350",
	[29492]="165:350",
	[29493]="165:350",
	[29494]="165:350",
	[29495]="165:350",
	[29496]="165:350",
	[29497]="165:350",
	[29498]="165:350",
	[29499]="165:350",
	[29500]="165:350",
	[29502]="165:365",
	[29503]="165:365",
	[29504]="165:365",
	[29505]="165:365",
	[29506]="165:365",
	[29507]="165:365",
	[29508]="165:365",
	[29509]="165:365",
	[29510]="165:365",
	[29511]="165:365",
	[29512]="165:365",
	[29514]="165:365",
	[29515]="165:0",
	[29516]="165:0",
	[29517]="165:0",
	[29519]="165:0",
	[29520]="165:0",
	[29521]="165:0",
	[29522]="165:0",
	[29523]="165:0",
	[29524]="165:0",
	[29525]="165:0",
	[29526]="165:0",
	[29527]="165:0",
	[29528]="165:340",
	[29529]="165:365",
	[29530]="165:345",
	[29531]="165:350",
	[29532]="165:370",
	[29533]="165:335",
	[29534]="165:335",
	[29535]="165:365",
	[29536]="165:365",
	[29540]="165:325",
	[29964]="165:260",
	[29970]="165:260",
	[29971]="165:260",
	[29973]="165:330",
	[29974]="165:330",
	[29975]="165:330",
	[30031]="164:375",
	[30032]="164:375",
	[30033]="164:375",
	[30034]="164:375",
	[30035]="197:375",
	[30036]="197:375",
	[30037]="197:375",
	[30038]="197:375",
	[30039]="165:375",
	[30040]="165:375",
	[30041]="165:375",
	[30042]="165:375",
	[30043]="165:375",
	[30044]="165:375",
	[30045]="165:375",
	[30046]="165:375",
	[30069]="164:0",
	[30070]="164:0",
	[30071]="164:0",
	[30072]="164:0",
	[30073]="164:0",
	[30074]="164:0",
	[30076]="164:0",
	[30077]="164:0",
	[30086]="164:0",
	[30087]="164:0",
	[30088]="164:0",
	[30089]="164:0",
	[30093]="164:0",
	[30155]="185:300",
	[30419]="755:75",
	[30420]="755:105",
	[30421]="755:230",
	[30422]="755:265",
	[30459]="197:355",
	[30460]="197:355",
	[30461]="197:355",
	[30542]="202:350",
	[30544]="202:350",
	[30804]="755:65",
	[30816]="185:1",
	[30825]="755:360",
	[30831]="197:350",
	[30837]="197:350",
	[30838]="197:360",
	[30839]="197:370",
	[31079]="755:325",
	[31080]="171:325",
	[31154]="755:80",
	[31364]="164:375",
	[31367]="164:375",
	[31368]="164:375",
	[31369]="164:375",
	[31370]="164:375",
	[31371]="164:375",
	[31398]="755:375",
	[31399]="755:375",
	[31672]="185:335",
	[31673]="185:335",
	[31676]="171:345",
	[31677]="171:360",
	[31679]="171:335",
	[31866]="755:325",
	[31867]="755:350",
	[31868]="755:350",
	[31869]="755:325",
	[32062]="171:310",
	[32063]="171:320",
	[32067]="171:320",
	[32068]="171:330",
	[32193]="755:375",
	[32194]="755:375",
	[32196]="755:375",
	[32198]="755:375",
	[32199]="755:375",
	[32200]="755:375",
	[32201]="755:375",
	[32203]="755:375",
	[32205]="755:375",
	[32206]="755:375",
	[32209]="755:375",
	[32211]="755:375",
	[32212]="755:375",
	[32215]="755:375",
	[32217]="755:375",
	[32218]="755:375",
	[32220]="755:375",
	[32221]="755:375",
	[32222]="755:375",
	[32223]="755:375",
	[32224]="755:375",
	[32225]="755:375",
	[32226]="755:375",
	[32389]="197:375",
	[32390]="197:375",
	[32391]="197:375",
	[32392]="197:375",
	[32393]="165:375",
	[32394]="165:375",
	[32395]="165:375",
	[32396]="165:375",
	[32397]="165:375",
	[32398]="165:375",
	[32399]="165:375",
	[32400]="165:375",
	[32401]="164:375",
	[32402]="164:375",
	[32403]="164:375",
	[32404]="164:375",
	[32409]="755:365",
	[32410]="755:365",
	[32413]="202:335",
	[32420]="197:375",
	[32423]="202:335",
	[32461]="202:350",
	[32472]="202:350",
	[32473]="202:350",
	[32474]="202:350",
	[32475]="202:350",
	[32476]="202:350",
	[32478]="202:350",
	[32479]="202:350",
	[32480]="202:350",
	[32494]="202:350",
	[32495]="202:350",
	[32508]="755:340",
	[32568]="164:375",
	[32570]="164:375",
	[32571]="164:375",
	[32573]="164:375",
	[32574]="165:375",
	[32575]="165:375",
	[32577]="165:375",
	[32579]="165:375",
	[32580]="165:375",
	[32581]="165:375",
	[32582]="165:375",
	[32583]="165:375",
	[32584]="197:375",
	[32585]="197:375",
	[32586]="197:375",
	[32587]="197:375",
	[32756]="202:375",
	[32772]="755:325",
	[32774]="755:330",
	[32776]="755:365",
	[32833]="755:325",
	[32836]="755:350",
	[32839]="171:300",
	[32849]="171:300",
	[32850]="171:300",
	[32851]="171:300",
	[32852]="171:300",
	[32854]="164:365",
	[33004]="185:0",
	[33048]="185:320",
	[33052]="185:350",
	[33053]="185:350",
	[33092]="202:330",
	[33093]="202:345",
	[33122]="165:360",
	[33131]="755:360",
	[33133]="755:360",
	[33134]="755:360",
	[33135]="755:360",
	[33140]="755:360",
	[33143]="755:360",
	[33144]="755:360",
	[33173]="164:365",
	[33185]="164:335",
	[33204]="165:365",
	[33208]="171:375",
	[33447]="171:405",
	[33448]="171:410",
	[33457]="773:310",
	[33458]="773:300",
	[33460]="773:295",
	[33461]="773:290",
	[33462]="773:305",
	[33568]="165:350",
	[33782]="755:350",
	[33791]="164:35",
	[33825]="185:325",
	[33866]="185:300",
	[33867]="185:300",
	[33872]="185:325",
	[33874]="185:300",
	[33924]="185:1",
	[34060]="202:300",
	[34061]="202:375",
	[34085]="197:250",
	[34086]="165:285",
	[34087]="197:250",
	[34105]="165:0",
	[34113]="202:360",
	[34207]="165:350",
	[34220]="755:365",
	[34330]="165:350",
	[34353]="202:375",
	[34354]="202:375",
	[34355]="202:375",
	[34356]="202:375",
	[34357]="202:375",
	[34358]="755:365",
	[34359]="755:365",
	[34360]="755:365",
	[34361]="755:365",
	[34362]="755:365",
	[34363]="755:365",
	[34364]="197:365",
	[34365]="197:365",
	[34366]="197:365",
	[34367]="197:365",
	[34369]="165:365",
	[34370]="165:365",
	[34371]="165:365",
	[34372]="165:365",
	[34373]="165:365",
	[34374]="165:365",
	[34375]="165:365",
	[34376]="165:365",
	[34377]="164:365",
	[34378]="164:365",
	[34379]="164:365",
	[34380]="164:365",
	[34411]="185:325",
	[34440]="171:325",
	[34482]="165:300",
	[34490]="165:350",
	[34721]="129:350",
	[34722]="129:400",
	[34747]="185:0",
	[34748]="185:350",
	[34749]="185:350",
	[34750]="185:350",
	[34751]="185:350",
	[34752]="185:350",
	[34753]="185:375",
	[34754]="185:400",
	[34755]="185:400",
	[34756]="185:400",
	[34757]="185:400",
	[34758]="185:400",
	[34759]="185:350",
	[34760]="185:350",
	[34761]="185:350",
	[34762]="185:350",
	[34763]="185:350",
	[34764]="185:350",
	[34765]="185:350",
	[34766]="185:400",
	[34767]="185:400",
	[34768]="185:400",
	[34769]="185:400",
	[34832]="185:100",
	[34847]="202:375",
	[35128]="186:375",
	[35181]="202:375",
	[35182]="202:375",
	[35183]="202:375",
	[35184]="202:375",
	[35185]="202:375",
	[35315]="755:350",
	[35318]="755:350",
	[35501]="755:370",
	[35503]="755:370",
	[35563]="185:250",
	[35565]="185:250",
	[35581]="202:355",
	[35622]="171:300",
	[35623]="171:300",
	[35624]="171:300",
	[35625]="171:300",
	[35627]="171:300",
	[35691]="202:0",
	[35693]="755:375",
	[35694]="755:375",
	[35700]="755:375",
	[35702]="755:375",
	[35703]="755:375",
	[35707]="755:350",
	[35748]="171:375",
	[35749]="171:375",
	[35750]="171:375",
	[35751]="171:375",
	[35758]="755:375",
	[35759]="755:375",
	[35760]="755:375",
	[35761]="755:375",
	[35945]="755:350",
	[36767]="755:370",
	[36799]="237:0",
	[36860]="171:300",
	[36913]="186:400",
	[36916]="186:350",
	[36919]="171:300",
	[36922]="171:450",
	[36925]="171:450",
	[36928]="171:450",
	[36931]="171:450",
	[36934]="171:450",
	[37091]="773:360",
	[37092]="773:410",
	[37093]="773:350",
	[37094]="773:400",
	[37097]="773:355",
	[37098]="773:405",
	[37101]="773:1",
	[37118]="773:35",
	[37168]="773:85",
	[37567]="202:410",
	[37663]="186:450",
	[38225]="197:375",
	[38277]="197:250",
	[38278]="197:245",
	[38322]="773:400",
	[38347]="165:415",
	[38371]="165:405",
	[38372]="165:400",
	[38373]="165:425",
	[38374]="165:425",
	[38375]="165:350",
	[38376]="165:395",
	[38399]="165:415",
	[38400]="165:370",
	[38401]="165:375",
	[38402]="165:380",
	[38403]="165:375",
	[38404]="165:370",
	[38405]="165:380",
	[38406]="165:380",
	[38407]="165:375",
	[38408]="165:375",
	[38409]="165:370",
	[38410]="165:370",
	[38411]="165:380",
	[38412]="165:370",
	[38413]="165:380",
	[38414]="165:375",
	[38415]="165:380",
	[38416]="165:370",
	[38417]="165:380",
	[38418]="165:375",
	[38419]="165:380",
	[38420]="165:375",
	[38421]="165:370",
	[38422]="165:370",
	[38424]="165:375",
	[38425]="165:390",
	[38433]="165:385",
	[38434]="165:385",
	[38435]="165:385",
	[38436]="165:385",
	[38437]="165:385",
	[38438]="165:385",
	[38439]="165:385",
	[38440]="165:385",
	[38441]="165:380",
	[38590]="165:390",
	[38591]="165:400",
	[38592]="165:410",
	[38682]="773:35",
	[39083]="164:360",
	[39084]="164:370",
	[39085]="164:375",
	[39086]="164:370",
	[39087]="164:350",
	[39088]="164:350",
	[39469]="773:35",
	[39520]="185:350",
	[39666]="171:395",
	[39671]="171:350",
	[39681]="202:350",
	[39682]="202:375",
	[39683]="202:390",
	[39688]="202:400",
	[39690]="202:350",
	[39774]="773:75",
	[39900]="755:350",
	[39905]="755:350",
	[39907]="755:350",
	[39908]="755:350",
	[39909]="755:350",
	[39910]="755:350",
	[39912]="755:350",
	[39915]="755:350",
	[39917]="755:350",
	[39918]="755:350",
	[39919]="755:350",
	[39927]="755:350",
	[39932]="755:350",
	[39933]="755:350",
	[39934]="755:350",
	[39935]="755:350",
	[39939]="755:350",
	[39940]="755:350",
	[39942]="755:350",
	[39945]="755:350",
	[39947]="755:350",
	[39948]="755:350",
	[39949]="755:350",
	[39950]="755:350",
	[39951]="755:350",
	[39952]="755:350",
	[39954]="755:350",
	[39955]="755:350",
	[39956]="755:350",
	[39957]="755:350",
	[39958]="755:350",
	[39959]="755:350",
	[39965]="755:350",
	[39966]="755:350",
	[39967]="755:350",
	[39968]="755:350",
	[39975]="755:350",
	[39976]="755:350",
	[39977]="755:350",
	[39978]="755:350",
	[39979]="755:350",
	[39980]="755:350",
	[39981]="755:350",
	[39982]="755:350",
	[39983]="755:350",
	[39991]="755:350",
	[39992]="755:350",
	[39996]="755:390",
	[39997]="755:390",
	[39998]="755:450",
	[40000]="755:390",
	[40001]="755:390",
	[40003]="755:390",
	[40008]="755:390",
	[40010]="755:390",
	[40011]="755:390",
	[40013]="755:390",
	[40014]="755:390",
	[40016]="755:390",
	[40017]="755:390",
	[40022]="755:390",
	[40023]="755:390",
	[40025]="755:390",
	[40026]="755:390",
	[40028]="755:390",
	[40032]="755:390",
	[40034]="755:390",
	[40037]="755:390",
	[40038]="755:390",
	[40039]="755:390",
	[40040]="755:390",
	[40041]="755:390",
	[40044]="755:390",
	[40045]="755:450",
	[40048]="755:390",
	[40049]="755:390",
	[40050]="755:390",
	[40051]="755:390",
	[40052]="755:390",
	[40055]="755:390",
	[40057]="755:390",
	[40058]="755:390",
	[40059]="755:390",
	[40067]="171:360",
	[40068]="171:355",
	[40070]="171:365",
	[40072]="171:385",
	[40073]="171:385",
	[40076]="171:375",
	[40077]="171:400",
	[40078]="171:390",
	[40079]="171:375",
	[40081]="171:380",
	[40086]="755:390",
	[40087]="171:400",
	[40088]="755:390",
	[40089]="755:390",
	[40090]="755:390",
	[40091]="755:390",
	[40093]="171:395",
	[40095]="755:390",
	[40097]="171:400",
	[40098]="755:390",
	[40100]="755:390",
	[40102]="755:390",
	[40105]="755:390",
	[40106]="755:390",
	[40109]="171:400",
	[40111]="755:450",
	[40112]="755:450",
	[40113]="755:450",
	[40115]="755:450",
	[40116]="755:450",
	[40118]="755:450",
	[40119]="755:450",
	[40120]="755:450",
	[40122]="755:450",
	[40124]="755:450",
	[40125]="755:450",
	[40127]="755:450",
	[40128]="755:450",
	[40129]="755:450",
	[40130]="755:450",
	[40133]="755:450",
	[40135]="755:450",
	[40139]="755:450",
	[40141]="755:450",
	[40142]="755:450",
	[40143]="755:450",
	[40144]="755:450",
	[40145]="755:450",
	[40146]="755:450",
	[40147]="755:450",
	[40149]="755:450",
	[40150]="755:450",
	[40152]="755:450",
	[40153]="755:450",
	[40154]="755:450",
	[40155]="755:450",
	[40157]="755:450",
	[40159]="755:0",
	[40160]="755:450",
	[40162]="755:450",
	[40163]="755:450",
	[40164]="755:450",
	[40165]="755:450",
	[40166]="755:450",
	[40167]="755:450",
	[40168]="755:450",
	[40169]="755:450",
	[40171]="755:450",
	[40173]="755:450",
	[40177]="755:450",
	[40179]="755:450",
	[40180]="755:450",
	[40182]="755:450",
	[40195]="171:375",
	[40211]="171:400",
	[40212]="171:400",
	[40213]="171:400",
	[40214]="171:400",
	[40215]="171:400",
	[40216]="171:400",
	[40217]="171:400",
	[40536]="202:375",
	[40668]="164:360",
	[40669]="164:395",
	[40670]="164:390",
	[40671]="164:400",
	[40672]="164:400",
	[40673]="164:405",
	[40674]="164:395",
	[40675]="164:405",
	[40727]="202:500",
	[40767]="202:420",
	[40768]="202:425",
	[40769]="202:0",
	[40771]="202:350",
	[40772]="202:435",
	[40865]="202:420",
	[40892]="202:375",
	[40893]="202:375",
	[40895]="202:425",
	[40896]="773:350",
	[40897]="773:90",
	[40899]="773:385",
	[40900]="773:385",
	[40901]="773:260",
	[40902]="773:200",
	[40903]="773:310",
	[40906]="773:385",
	[40908]="773:385",
	[40909]="773:170",
	[40912]="773:385",
	[40913]="773:80",
	[40914]="773:115",
	[40915]="773:385",
	[40916]="773:220",
	[40919]="773:150",
	[40920]="773:385",
	[40921]="773:385",
	[40922]="773:85",
	[40923]="773:130",
	[40924]="773:100",
	[40942]="164:375",
	[40943]="164:395",
	[40949]="164:380",
	[40950]="164:385",
	[40951]="164:385",
	[40952]="164:390",
	[40953]="164:395",
	[40954]="164:400",
	[40955]="164:400",
	[40956]="164:375",
	[40957]="164:375",
	[40958]="164:375",
	[40959]="164:375",
	[41092]="773:120",
	[41094]="773:335",
	[41095]="773:90",
	[41096]="773:80",
	[41097]="773:385",
	[41098]="773:230",
	[41099]="773:205",
	[41100]="773:0",
	[41101]="773:385",
	[41102]="773:375",
	[41103]="773:265",
	[41104]="773:180",
	[41105]="773:300",
	[41106]="773:105",
	[41107]="773:385",
	[41108]="773:135",
	[41109]="773:385",
	[41110]="773:385",
	[41112]="202:420",
	[41113]="164:410",
	[41114]="164:415",
	[41116]="164:410",
	[41117]="164:390",
	[41121]="202:425",
	[41126]="164:395",
	[41127]="164:400",
	[41128]="164:405",
	[41129]="164:415",
	[41146]="202:425",
	[41163]="171:395",
	[41167]="202:430",
	[41168]="202:450",
	[41181]="164:390",
	[41182]="164:395",
	[41183]="164:400",
	[41184]="164:405",
	[41185]="164:410",
	[41186]="164:0",
	[41187]="164:0",
	[41188]="164:415",
	[41189]="164:0",
	[41190]="164:0",
	[41238]="165:395",
	[41239]="164:380",
	[41240]="164:380",
	[41241]="164:385",
	[41242]="164:385",
	[41243]="164:390",
	[41245]="164:405",
	[41248]="197:400",
	[41249]="197:400",
	[41250]="197:400",
	[41251]="197:400",
	[41252]="197:400",
	[41253]="197:400",
	[41254]="197:400",
	[41255]="197:400",
	[41257]="164:440",
	[41266]="171:430",
	[41285]="755:420",
	[41307]="755:420",
	[41333]="755:420",
	[41334]="171:425",
	[41335]="755:420",
	[41339]="755:440",
	[41344]="164:425",
	[41345]="164:425",
	[41346]="164:425",
	[41347]="164:425",
	[41348]="164:420",
	[41349]="164:420",
	[41350]="164:425",
	[41351]="164:420",
	[41352]="164:420",
	[41353]="164:425",
	[41354]="164:420",
	[41355]="164:420",
	[41356]="164:420",
	[41357]="164:420",
	[41367]="755:350",
	[41375]="755:440",
	[41376]="755:420",
	[41377]="755:420",
	[41378]="755:420",
	[41379]="755:420",
	[41380]="755:420",
	[41381]="755:440",
	[41382]="755:420",
	[41383]="164:440",
	[41384]="164:440",
	[41385]="755:420",
	[41386]="164:440",
	[41387]="164:440",
	[41388]="164:440",
	[41389]="755:420",
	[41391]="164:440",
	[41392]="164:440",
	[41394]="164:440",
	[41395]="755:420",
	[41396]="755:420",
	[41397]="755:440",
	[41398]="755:420",
	[41400]="755:420",
	[41401]="755:420",
	[41508]="202:450",
	[41509]="197:360",
	[41510]="197:350",
	[41511]="197:400",
	[41512]="197:350",
	[41513]="197:350",
	[41515]="197:360",
	[41516]="197:420",
	[41517]="773:385",
	[41518]="773:385",
	[41519]="197:380",
	[41520]="197:375",
	[41521]="197:380",
	[41522]="197:370",
	[41523]="197:385",
	[41524]="773:385",
	[41525]="197:390",
	[41526]="773:385",
	[41527]="773:300",
	[41528]="197:385",
	[41529]="773:385",
	[41530]="773:110",
	[41531]="773:85",
	[41532]="773:125",
	[41533]="773:215",
	[41534]="773:385",
	[41535]="773:235",
	[41536]="773:140",
	[41537]="773:95",
	[41538]="773:385",
	[41539]="773:375",
	[41540]="773:165",
	[41541]="773:275",
	[41542]="773:330",
	[41543]="197:395",
	[41544]="197:410",
	[41545]="197:405",
	[41546]="197:395",
	[41547]="773:185",
	[41548]="197:395",
	[41549]="197:405",
	[41550]="197:410",
	[41551]="197:400",
	[41552]="773:385",
	[41553]="197:415",
	[41554]="197:420",
	[41555]="197:415",
	[41593]="197:415",
	[41594]="197:415",
	[41595]="197:415",
	[41597]="197:435",
	[41598]="197:440",
	[41599]="197:410",
	[41600]="197:445",
	[41601]="197:400",
	[41602]="197:430",
	[41603]="197:400",
	[41604]="197:430",
	[41607]="197:390",
	[41608]="197:395",
	[41609]="197:415",
	[41610]="197:420",
	[41611]="164:415",
	[41745]="164:420",
	[41974]="164:360",
	[41975]="164:370",
	[41976]="164:420",
	[41984]="197:425",
	[41985]="197:420",
	[41986]="197:420",
	[42093]="197:425",
	[42095]="197:420",
	[42096]="197:420",
	[42100]="197:450",
	[42101]="197:450",
	[42102]="197:450",
	[42103]="197:440",
	[42111]="197:440",
	[42113]="197:440",
	[42142]="755:370",
	[42143]="755:370",
	[42144]="755:370",
	[42145]="755:370",
	[42149]="755:370",
	[42150]="755:370",
	[42151]="755:370",
	[42152]="755:370",
	[42154]="755:370",
	[42155]="755:370",
	[42156]="755:370",
	[42158]="755:370",
	[42336]="755:350",
	[42337]="755:350",
	[42338]="755:380",
	[42339]="755:380",
	[42340]="755:420",
	[42341]="755:400",
	[42395]="755:400",
	[42396]="773:385",
	[42397]="773:230",
	[42398]="773:105",
	[42399]="773:270",
	[42400]="773:120",
	[42401]="773:315",
	[42402]="773:135",
	[42403]="773:385",
	[42404]="773:385",
	[42405]="773:385",
	[42406]="773:350",
	[42407]="773:385",
	[42408]="773:80",
	[42409]="773:385",
	[42410]="773:95",
	[42411]="773:160",
	[42412]="773:375",
	[42413]="755:400",
	[42414]="773:385",
	[42415]="773:180",
	[42416]="773:210",
	[42417]="773:385",
	[42418]="755:400",
	[42420]="755:350",
	[42421]="755:350",
	[42435]="164:440",
	[42443]="164:410",
	[42453]="773:350",
	[42454]="773:385",
	[42455]="773:85",
	[42456]="773:385",
	[42457]="773:385",
	[42458]="773:125",
	[42459]="773:385",
	[42460]="773:385",
	[42461]="773:110",
	[42462]="773:95",
	[42463]="773:385",
	[42464]="773:385",
	[42465]="773:140",
	[42466]="773:215",
	[42467]="773:165",
	[42468]="773:275",
	[42470]="773:240",
	[42471]="773:325",
	[42472]="773:385",
	[42473]="773:190",
	[42500]="164:420",
	[42508]="164:440",
	[42546]="202:415",
	[42549]="202:440",
	[42550]="202:440",
	[42551]="202:440",
	[42552]="202:440",
	[42553]="202:440",
	[42554]="202:440",
	[42555]="202:440",
	[42641]="202:425",
	[42642]="755:430",
	[42643]="755:430",
	[42644]="755:430",
	[42645]="755:440",
	[42646]="755:440",
	[42647]="755:440",
	[42701]="755:350",
	[42702]="755:390",
	[42723]="164:420",
	[42724]="164:420",
	[42725]="164:425",
	[42726]="164:425",
	[42727]="164:420",
	[42728]="164:425",
	[42729]="164:420",
	[42730]="164:420",
	[42731]="165:425",
	[42735]="773:115",
	[42736]="773:335",
	[42737]="773:130",
	[42738]="773:155",
	[42739]="773:385",
	[42741]="773:80",
	[42742]="773:385",
	[42743]="773:90",
	[42744]="773:225",
	[42745]="773:375",
	[42746]="773:175",
	[42748]="773:385",
	[42749]="773:325",
	[42751]="773:385",
	[42752]="773:400",
	[42753]="773:385",
	[42754]="773:385",
	[42897]="773:175",
	[42898]="773:100",
	[42899]="773:385",
	[42900]="773:115",
	[42901]="773:385",
	[42902]="773:385",
	[42903]="773:200",
	[42904]="773:225",
	[42905]="773:260",
	[42906]="773:350",
	[42907]="773:80",
	[42908]="773:130",
	[42909]="773:375",
	[42910]="773:150",
	[42911]="773:315",
	[42912]="773:90",
	[42913]="773:385",
	[42914]="773:385",
	[42915]="773:385",
	[42917]="773:385",
	[42942]="185:350",
	[42954]="773:385",
	[42955]="773:340",
	[42956]="773:80",
	[42957]="773:385",
	[42958]="773:385",
	[42959]="773:385",
	[42960]="773:95",
	[42961]="773:105",
	[42962]="773:120",
	[42963]="773:305",
	[42964]="773:135",
	[42965]="773:385",
	[42966]="773:160",
	[42967]="773:385",
	[42968]="773:385",
	[42969]="773:385",
	[42970]="773:185",
	[42971]="773:385",
	[42972]="773:210",
	[42973]="773:235",
	[42974]="773:285",
	[42993]="185:400",
	[42994]="185:400",
	[42995]="185:400",
	[42996]="185:400",
	[42997]="185:400",
	[42998]="185:400",
	[42999]="185:400",
	[43000]="185:400",
	[43001]="185:400",
	[43004]="185:400",
	[43005]="185:400",
	[43015]="185:450",
	[43115]="773:85",
	[43116]="773:100",
	[43117]="773:125",
	[43118]="773:150",
	[43119]="773:175",
	[43120]="773:200",
	[43121]="773:225",
	[43122]="773:250",
	[43123]="773:275",
	[43124]="773:290",
	[43125]="773:325",
	[43126]="773:350",
	[43127]="773:375",
	[43129]="165:425",
	[43130]="165:420",
	[43131]="165:420",
	[43132]="165:425",
	[43133]="165:420",
	[43244]="755:350",
	[43245]="755:350",
	[43246]="755:350",
	[43247]="755:350",
	[43248]="755:390",
	[43249]="755:390",
	[43250]="755:420",
	[43251]="755:420",
	[43252]="755:420",
	[43253]="755:420",
	[43255]="165:420",
	[43256]="165:420",
	[43257]="165:425",
	[43258]="165:420",
	[43260]="165:420",
	[43261]="165:420",
	[43262]="165:420",
	[43263]="165:420",
	[43264]="165:420",
	[43265]="165:425",
	[43266]="165:425",
	[43268]="185:350",
	[43271]="165:425",
	[43273]="165:425",
	[43316]="773:75",
	[43331]="773:75",
	[43332]="773:75",
	[43334]="773:75",
	[43335]="773:75",
	[43338]="773:75",
	[43339]="773:75",
	[43340]="773:75",
	[43342]="773:75",
	[43343]="773:75",
	[43344]="773:75",
	[43350]="773:75",
	[43351]="773:75",
	[43355]="773:75",
	[43356]="773:75",
	[43359]="773:75",
	[43360]="773:75",
	[43361]="773:75",
	[43364]="773:75",
	[43365]="773:75",
	[43366]="773:75",
	[43367]="773:75",
	[43368]="773:75",
	[43369]="773:75",
	[43370]="773:75",
	[43371]="773:75",
	[43372]="773:75",
	[43373]="773:75",
	[43374]="773:75",
	[43376]="773:75",
	[43377]="773:75",
	[43378]="773:75",
	[43379]="773:75",
	[43380]="773:75",
	[43381]="773:75",
	[43385]="773:75",
	[43386]="773:75",
	[43388]="773:75",
	[43389]="773:75",
	[43390]="773:75",
	[43391]="773:75",
	[43392]="773:75",
	[43393]="773:75",
	[43394]="773:75",
	[43395]="773:75",
	[43396]="773:75",
	[43397]="773:75",
	[43398]="773:75",
	[43399]="773:75",
	[43400]="773:75",
	[43412]="773:385",
	[43413]="773:85",
	[43414]="773:240",
	[43415]="773:385",
	[43416]="773:285",
	[43417]="773:125",
	[43418]="773:95",
	[43419]="773:385",
	[43421]="773:385",
	[43422]="773:170",
	[43423]="773:110",
	[43424]="773:190",
	[43425]="773:385",
	[43427]="773:140",
	[43428]="773:320",
	[43430]="773:385",
	[43431]="773:385",
	[43432]="773:345",
	[43433]="165:420",
	[43434]="165:420",
	[43435]="165:420",
	[43436]="165:425",
	[43437]="165:425",
	[43438]="165:425",
	[43439]="165:425",
	[43442]="165:425",
	[43443]="165:425",
	[43444]="165:420",
	[43445]="165:420",
	[43446]="165:425",
	[43447]="165:420",
	[43448]="165:425",
	[43449]="165:420",
	[43450]="165:425",
	[43451]="165:425",
	[43452]="165:420",
	[43453]="165:420",
	[43454]="165:425",
	[43455]="165:420",
	[43456]="165:425",
	[43457]="165:420",
	[43458]="165:440",
	[43459]="165:440",
	[43461]="165:440",
	[43463]="773:370",
	[43464]="773:420",
	[43465]="773:365",
	[43466]="773:415",
	[43469]="165:440",
	[43478]="185:425",
	[43480]="185:425",
	[43481]="165:440",
	[43482]="755:420",
	[43484]="165:440",
	[43488]="185:350",
	[43490]="185:350",
	[43491]="185:350",
	[43492]="185:350",
	[43495]="165:440",
	[43498]="755:420",
	[43502]="165:440",
	[43515]="773:85",
	[43533]="773:385",
	[43534]="773:385",
	[43535]="773:75",
	[43536]="773:265",
	[43537]="773:385",
	[43539]="773:75",
	[43541]="773:285",
	[43542]="773:385",
	[43543]="773:270",
	[43544]="773:75",
	[43546]="773:280",
	[43547]="773:385",
	[43548]="773:300",
	[43549]="773:350",
	[43550]="773:385",
	[43551]="773:330",
	[43552]="773:375",
	[43553]="773:305",
	[43554]="773:345",
	[43565]="165:440",
	[43566]="165:440",
	[43569]="171:410",
	[43570]="171:410",
	[43582]="755:420",
	[43583]="197:425",
	[43584]="197:420",
	[43585]="197:420",
	[43586]="164:425",
	[43587]="164:420",
	[43588]="164:420",
	[43590]="165:425",
	[43591]="165:420",
	[43592]="165:420",
	[43593]="165:425",
	[43594]="165:420",
	[43595]="165:420",
	[43654]="773:125",
	[43655]="773:125",
	[43656]="773:175",
	[43657]="773:175",
	[43660]="773:225",
	[43661]="773:225",
	[43663]="773:275",
	[43664]="773:275",
	[43666]="773:325",
	[43667]="773:325",
	[43671]="773:75",
	[43672]="773:75",
	[43673]="773:75",
	[43674]="773:75",
	[43725]="773:75",
	[43825]="773:310",
	[43826]="773:320",
	[43827]="773:340",
	[43850]="773:200",
	[43853]="164:430",
	[43854]="164:350",
	[43860]="164:395",
	[43864]="164:400",
	[43865]="164:405",
	[43867]="773:385",
	[43868]="773:385",
	[43869]="773:385",
	[43870]="164:415",
	[43871]="164:410",
	[43969]="197:415",
	[43970]="197:420",
	[43971]="197:420",
	[43972]="197:420",
	[43973]="197:420",
	[43974]="197:415",
	[43975]="197:420",
	[44063]="755:400",
	[44142]="773:125",
	[44161]="773:175",
	[44163]="773:225",
	[44210]="773:400",
	[44211]="197:360",
	[44314]="773:200",
	[44315]="773:350",
	[44316]="773:275",
	[44317]="773:325",
	[44318]="773:400",
	[44322]="171:400",
	[44323]="171:400",
	[44324]="171:400",
	[44325]="171:400",
	[44327]="171:400",
	[44328]="171:400",
	[44329]="171:400",
	[44330]="171:400",
	[44331]="171:400",
	[44332]="171:395",
	[44413]="202:450",
	[44436]="165:395",
	[44437]="165:395",
	[44438]="165:400",
	[44440]="165:395",
	[44441]="165:395",
	[44442]="165:400",
	[44443]="165:395",
	[44444]="165:395",
	[44445]="165:400",
	[44446]="165:415",
	[44452]="333:425",
	[44504]="202:450",
	[44554]="197:300",
	[44558]="197:425",
	[44684]="773:385",
	[44739]="202:390",
	[44740]="202:420",
	[44741]="202:420",
	[44742]="202:420",
	[44836]="185:100",
	[44837]="185:1",
	[44838]="185:280",
	[44839]="185:220",
	[44840]="185:160",
	[44920]="773:75",
	[44922]="773:75",
	[44923]="773:75",
	[44928]="773:375",
	[44930]="165:440",
	[44931]="165:440",
	[44936]="164:450",
	[44939]="171:385",
	[44943]="755:425",
	[44949]="202:440",
	[44951]="202:405",
	[44953]="185:400",
	[44955]="773:315",
	[44958]="171:375",
	[44963]="165:425",
	[45054]="755:300",
	[45085]="164:440",
	[45550]="164:450",
	[45551]="164:450",
	[45552]="164:450",
	[45553]="165:450",
	[45554]="165:450",
	[45555]="165:450",
	[45556]="165:450",
	[45557]="197:450",
	[45558]="197:450",
	[45559]="164:450",
	[45560]="164:450",
	[45561]="164:450",
	[45562]="165:450",
	[45563]="165:450",
	[45564]="165:450",
	[45565]="165:450",
	[45566]="197:450",
	[45567]="197:450",
	[45601]="773:425",
	[45602]="773:0",
	[45603]="773:0",
	[45604]="773:0",
	[45621]="171:135",
	[45622]="773:250",
	[45623]="773:425",
	[45625]="773:0",
	[45626]="197:125",
	[45627]="755:200",
	[45631]="202:250",
	[45731]="773:0",
	[45732]="773:0",
	[45733]="773:0",
	[45734]="773:0",
	[45735]="773:0",
	[45736]="773:0",
	[45737]="773:0",
	[45738]="773:0",
	[45739]="773:0",
	[45740]="773:0",
	[45741]="773:0",
	[45742]="773:0",
	[45743]="773:0",
	[45744]="773:0",
	[45745]="773:0",
	[45746]="773:0",
	[45747]="773:0",
	[45753]="773:0",
	[45755]="773:0",
	[45756]="773:0",
	[45757]="773:0",
	[45758]="773:0",
	[45760]="773:255",
	[45761]="773:0",
	[45762]="773:0",
	[45764]="773:0",
	[45766]="773:0",
	[45767]="773:0",
	[45768]="773:255",
	[45769]="773:0",
	[45770]="773:0",
	[45771]="773:0",
	[45772]="773:0",
	[45773]="197:435",
	[45775]="773:250",
	[45776]="773:255",
	[45777]="773:0",
	[45778]="773:0",
	[45779]="773:0",
	[45780]="773:0",
	[45781]="773:0",
	[45782]="773:0",
	[45783]="773:0",
	[45785]="773:0",
	[45789]="773:0",
	[45790]="773:0",
	[45792]="773:0",
	[45793]="773:0",
	[45794]="773:0",
	[45795]="773:0",
	[45797]="773:0",
	[45799]="773:0",
	[45800]="773:0",
	[45804]="773:275",
	[45806]="773:0",
	[45808]="755:420",
	[45809]="755:420",
	[45810]="197:405",
	[45811]="197:400",
	[45812]="755:420",
	[45813]="755:420",
	[45849]="773:350",
	[45854]="773:350",
	[45932]="185:400",
	[46376]="171:435",
	[46377]="171:435",
	[46378]="171:435",
	[46379]="171:435",
	[46691]="185:1",
	[47499]="171:425",
	[47570]="164:450",
	[47571]="164:450",
	[47572]="164:450",
	[47573]="164:450",
	[47574]="164:450",
	[47575]="164:450",
	[47576]="165:450",
	[47577]="165:450",
	[47579]="165:450",
	[47580]="165:450",
	[47581]="165:450",
	[47582]="165:450",
	[47583]="165:450",
	[47584]="165:450",
	[47585]="197:450",
	[47586]="197:450",
	[47587]="197:450",
	[47588]="197:450",
	[47589]="164:450",
	[47590]="164:450",
	[47591]="164:450",
	[47592]="164:450",
	[47593]="164:450",
	[47594]="164:450",
	[47595]="165:450",
	[47596]="165:450",
	[47597]="165:450",
	[47598]="165:450",
	[47599]="165:450",
	[47600]="165:450",
	[47601]="165:450",
	[47602]="165:450",
	[47603]="197:450",
	[47604]="197:450",
	[47605]="197:450",
	[47606]="197:450",
	[47828]="202:410",
	[48720]="773:100",
	[48933]="202:435",
	[49040]="202:450",
	[49084]="773:75",
	[49110]="755:450",
	[49632]="773:440",
	[49633]="165:450",
	[49634]="165:450",
	[49890]="197:450",
	[49891]="197:450",
	[49892]="197:450",
	[49893]="197:450",
	[49894]="165:450",
	[49895]="165:450",
	[49896]="165:450",
	[49897]="165:450",
	[49898]="165:450",
	[49899]="165:450",
	[49900]="165:450",
	[49901]="165:450",
	[49902]="164:450",
	[49903]="164:450",
	[49904]="164:450",
	[49905]="164:450",
	[49906]="164:450",
	[49907]="164:450",
	[50045]="773:250",
	[50077]="773:375",
	[51950]="171:520",
	[52081]="755:425",
	[52082]="755:425",
	[52083]="755:425",
	[52084]="755:425",
	[52085]="755:425",
	[52086]="755:425",
	[52087]="755:425",
	[52088]="755:425",
	[52089]="755:425",
	[52090]="755:425",
	[52091]="755:425",
	[52092]="755:0",
	[52093]="755:425",
	[52094]="755:425",
	[52095]="755:425",
	[52096]="755:425",
	[52097]="755:425",
	[52098]="755:425",
	[52099]="755:425",
	[52100]="755:425",
	[52101]="755:425",
	[52102]="755:425",
	[52103]="755:425",
	[52104]="755:425",
	[52105]="755:425",
	[52106]="755:425",
	[52107]="755:0",
	[52108]="755:425",
	[52109]="755:425",
	[52110]="755:425",
	[52111]="755:425",
	[52112]="755:425",
	[52113]="755:425",
	[52114]="755:425",
	[52115]="755:425",
	[52116]="755:425",
	[52117]="755:425",
	[52118]="755:425",
	[52119]="755:425",
	[52120]="755:425",
	[52121]="755:425",
	[52122]="755:425",
	[52123]="755:425",
	[52124]="755:425",
	[52125]="755:425",
	[52126]="755:425",
	[52127]="755:425",
	[52128]="755:425",
	[52186]="186:475",
	[52190]="171:525",
	[52191]="171:515",
	[52192]="171:505",
	[52193]="171:510",
	[52194]="171:515",
	[52195]="171:520",
	[52203]="755:465",
	[52204]="755:465",
	[52205]="755:465",
	[52206]="755:465",
	[52207]="755:465",
	[52208]="755:465",
	[52209]="755:465",
	[52210]="755:465",
	[52211]="755:465",
	[52212]="755:465",
	[52213]="755:465",
	[52214]="755:465",
	[52215]="755:465",
	[52216]="755:465",
	[52217]="755:465",
	[52218]="755:465",
	[52219]="755:465",
	[52220]="755:465",
	[52221]="755:465",
	[52222]="755:465",
	[52223]="755:465",
	[52224]="755:465",
	[52225]="755:465",
	[52226]="755:465",
	[52227]="755:465",
	[52228]="755:465",
	[52229]="755:465",
	[52230]="755:465",
	[52231]="755:465",
	[52232]="755:465",
	[52233]="755:465",
	[52234]="755:465",
	[52235]="755:465",
	[52236]="755:465",
	[52237]="755:465",
	[52238]="755:465",
	[52239]="755:465",
	[52240]="755:465",
	[52241]="755:465",
	[52242]="755:465",
	[52243]="755:465",
	[52244]="755:465",
	[52245]="755:465",
	[52246]="755:465",
	[52247]="755:465",
	[52248]="755:465",
	[52249]="755:465",
	[52250]="755:465",
	[52255]="755:500",
	[52257]="755:500",
	[52258]="755:500",
	[52259]="755:500",
	[52260]="755:500",
	[52261]="755:500",
	[52262]="755:500",
	[52263]="755:500",
	[52264]="755:500",
	[52265]="755:500",
	[52266]="755:500",
	[52267]="755:500",
	[52268]="755:500",
	[52269]="755:500",
	[52289]="755:490",
	[52291]="755:490",
	[52292]="755:490",
	[52293]="755:490",
	[52294]="755:490",
	[52295]="755:490",
	[52296]="755:490",
	[52297]="755:490",
	[52298]="755:490",
	[52299]="755:490",
	[52300]="755:490",
	[52301]="755:490",
	[52302]="755:490",
	[52303]="171:525",
	[52304]="755:500",
	[52306]="755:425",
	[52307]="755:435",
	[52308]="755:450",
	[52309]="755:460",
	[52318]="755:525",
	[52319]="755:525",
	[52320]="755:525",
	[52321]="755:525",
	[52322]="755:525",
	[52323]="755:525",
	[52348]="755:525",
	[52350]="755:525",
	[52485]="755:450",
	[52486]="755:455",
	[52487]="755:460",
	[52489]="755:525",
	[52490]="755:435",
	[52492]="755:460",
	[52493]="755:490",
	[52721]="333:515",
	[52723]="333:515",
	[52976]="165:425",
	[53039]="186:500",
	[53049]="129:425",
	[53050]="129:475",
	[53051]="129:525",
	[53643]="197:425",
	[54440]="197:500",
	[54441]="197:500",
	[54442]="197:425",
	[54443]="197:480",
	[54444]="197:525",
	[54445]="197:480",
	[54446]="197:490",
	[54447]="197:450",
	[54448]="197:525",
	[54449]="197:460",
	[54450]="197:525",
	[54451]="197:500",
	[54464]="171:485",
	[54471]="197:445",
	[54472]="197:460",
	[54473]="197:445",
	[54474]="197:455",
	[54475]="197:465",
	[54476]="197:465",
	[54477]="197:455",
	[54478]="197:460",
	[54479]="197:475",
	[54480]="197:470",
	[54481]="197:470",
	[54482]="197:475",
	[54483]="197:480",
	[54484]="197:480",
	[54485]="197:485",
	[54486]="197:485",
	[54503]="197:525",
	[54504]="197:525",
	[54505]="197:525",
	[54506]="197:525",
	[54797]="197:425",
	[54849]="186:425",
	[54850]="164:440",
	[54852]="164:425",
	[54853]="164:425",
	[54854]="164:425",
	[54876]="164:425",
	[55022]="164:425",
	[55023]="164:425",
	[55024]="164:425",
	[55025]="164:425",
	[55026]="164:425",
	[55027]="164:425",
	[55028]="164:425",
	[55029]="164:425",
	[55030]="164:425",
	[55031]="164:425",
	[55032]="164:425",
	[55033]="164:425",
	[55034]="164:425",
	[55035]="164:425",
	[55036]="164:425",
	[55037]="164:425",
	[55038]="164:425",
	[55039]="164:425",
	[55040]="164:425",
	[55041]="164:425",
	[55042]="164:425",
	[55043]="164:425",
	[55044]="164:425",
	[55045]="164:425",
	[55046]="164:425",
	[55052]="164:425",
	[55053]="164:425",
	[55054]="164:525",
	[55055]="164:425",
	[55056]="164:525",
	[55057]="164:500",
	[55058]="164:515",
	[55059]="164:510",
	[55060]="164:515",
	[55061]="164:510",
	[55062]="164:515",
	[55063]="164:510",
	[55064]="164:520",
	[55065]="164:515",
	[55066]="164:520",
	[55067]="164:515",
	[55068]="164:520",
	[55069]="164:520",
	[55070]="164:520",
	[55246]="164:425",
	[56477]="165:425",
	[56480]="165:425",
	[56481]="165:425",
	[56482]="165:425",
	[56483]="165:425",
	[56484]="165:425",
	[56489]="165:425",
	[56490]="165:425",
	[56491]="165:425",
	[56494]="165:425",
	[56495]="165:425",
	[56498]="165:425",
	[56499]="165:425",
	[56502]="165:425",
	[56503]="165:425",
	[56504]="165:425",
	[56505]="165:425",
	[56508]="165:425",
	[56509]="165:425",
	[56512]="165:425",
	[56513]="165:425",
	[56516]="165:425",
	[56517]="165:425",
	[56518]="165:425",
	[56519]="165:425",
	[56536]="165:525",
	[56537]="165:525",
	[56538]="165:525",
	[56539]="165:525",
	[56548]="165:525",
	[56549]="165:525",
	[56550]="165:525",
	[56551]="165:525",
	[56561]="165:525",
	[56562]="165:525",
	[56563]="165:525",
	[56564]="165:525",
	[56850]="171:470",
	[57099]="171:470",
	[57191]="171:495",
	[57192]="171:485",
	[57193]="171:475",
	[57194]="171:465",
	[58084]="171:450",
	[58085]="171:500",
	[58086]="171:505",
	[58087]="171:510",
	[58088]="171:510",
	[58089]="171:455",
	[58090]="171:450",
	[58091]="171:460",
	[58092]="171:465",
	[58093]="171:475",
	[58094]="171:480",
	[58142]="171:455",
	[58143]="171:480",
	[58144]="171:490",
	[58145]="171:485",
	[58146]="171:490",
	[58148]="171:495",
	[58149]="171:500",
	[58480]="171:525",
	[58483]="171:500",
	[58487]="171:525",
	[58488]="171:525",
	[58489]="171:460",
	[59359]="202:525",
	[59364]="202:525",
	[59367]="202:525",
	[59448]="202:525",
	[59449]="202:525",
	[59453]="202:525",
	[59455]="202:525",
	[59456]="202:525",
	[59458]="202:525",
	[59594]="202:515",
	[59595]="202:450",
	[59596]="202:450",
	[59597]="202:475",
	[59598]="202:490",
	[59599]="202:495",
	[60216]="202:475",
	[60217]="202:475",
	[60218]="202:475",
	[60222]="202:440",
	[60223]="202:465",
	[60224]="202:425",
	[60403]="202:475",
	[60838]="773:450",
	[60847]="794:0",
	[60853]="202:455",
	[60854]="202:490",
	[60858]="202:505",
	[60954]="794:0",
	[60955]="794:0",
	[61978]="773:425",
	[61981]="773:475",
	[61987]="773:525",
	[62056]="773:500",
	[62231]="773:475",
	[62233]="773:475",
	[62234]="773:510",
	[62235]="773:510",
	[62236]="773:510",
	[62237]="773:460",
	[62238]="773:490",
	[62239]="773:480",
	[62240]="773:480",
	[62241]="773:480",
	[62242]="773:505",
	[62243]="773:515",
	[62244]="773:515",
	[62245]="773:515",
	[62251]="773:500",
	[62288]="171:525",
	[62289]="185:500",
	[62290]="185:525",
	[62649]="185:525",
	[62651]="185:450",
	[62652]="185:450",
	[62653]="185:450",
	[62654]="185:450",
	[62655]="185:450",
	[62656]="185:450",
	[62657]="185:450",
	[62658]="185:475",
	[62659]="185:475",
	[62660]="185:475",
	[62661]="185:500",
	[62662]="185:500",
	[62663]="185:500",
	[62664]="185:500",
	[62665]="185:500",
	[62666]="185:500",
	[62667]="185:500",
	[62668]="185:500",
	[62669]="185:500",
	[62670]="185:500",
	[62671]="185:500",
	[62672]="185:525",
	[62673]="185:450",
	[62674]="185:450",
	[62675]="185:450",
	[62676]="185:425",
	[62677]="185:475",
	[62680]="185:505",
	[62790]="185:415",
	[63109]="794:0",
	[63110]="794:0",
	[63111]="794:0",
	[63112]="794:0",
	[63113]="794:0",
	[63115]="794:0",
	[63118]="794:0",
	[63120]="794:0",
	[63121]="794:0",
	[63129]="794:0",
	[63130]="794:0",
	[63131]="794:0",
	[63246]="773:500",
	[63276]="773:500",
	[63303]="773:470",
	[63304]="773:465",
	[63305]="773:445",
	[63306]="773:460",
	[63307]="773:455",
	[63308]="773:450",
	[63388]="773:475",
	[63396]="202:500",
	[63407]="794:0",
	[63408]="794:0",
	[63409]="794:0",
	[63410]="794:0",
	[63411]="794:0",
	[63412]="794:0",
	[63413]="794:0",
	[63414]="794:0",
	[63416]="773:0",
	[63420]="773:0",
	[63481]="773:465",
	[63523]="794:0",
	[63524]="794:0",
	[63525]="794:0",
	[63526]="794:0",
	[63527]="794:0",
	[63528]="794:0",
	[63539]="773:0",
	[64337]="794:0",
	[64339]="794:0",
	[64340]="794:0",
	[64342]="794:0",
	[64343]="794:0",
	[64344]="794:0",
	[64345]="794:0",
	[64346]="794:0",
	[64347]="794:0",
	[64348]="794:0",
	[64349]="794:0",
	[64350]="794:0",
	[64354]="794:0",
	[64355]="794:0",
	[64356]="794:0",
	[64357]="794:0",
	[64358]="794:0",
	[64361]="794:0",
	[64362]="794:0",
	[64366]="794:0",
	[64367]="794:0",
	[64368]="794:0",
	[64371]="794:0",
	[64372]="794:0",
	[64373]="794:0",
	[64374]="794:0",
	[64375]="794:0",
	[64377]="794:0",
	[64378]="794:0",
	[64379]="794:0",
	[64381]="794:0",
	[64382]="794:0",
	[64383]="794:0",
	[64385]="794:0",
	[64387]="794:0",
	[64389]="794:0",
	[64417]="794:0",
	[64418]="794:0",
	[64419]="794:0",
	[64420]="794:0",
	[64421]="794:0",
	[64436]="794:0",
	[64437]="794:0",
	[64438]="794:0",
	[64440]="794:0",
	[64442]="794:0",
	[64443]="794:0",
	[64444]="794:0",
	[64453]="794:0",
	[64454]="794:0",
	[64455]="794:0",
	[64456]="794:0",
	[64457]="794:0",
	[64458]="794:0",
	[64459]="794:0",
	[64460]="794:0",
	[64461]="794:0",
	[64462]="794:0",
	[64464]="794:0",
	[64467]="794:0",
	[64468]="794:0",
	[64473]="794:0",
	[64474]="794:0",
	[64475]="794:0",
	[64476]="794:0",
	[64477]="794:0",
	[64478]="794:0",
	[64479]="794:0",
	[64480]="794:0",
	[64481]="794:0",
	[64482]="794:0",
	[64483]="794:0",
	[64484]="794:0",
	[64485]="794:0",
	[64486]="794:0",
	[64487]="794:0",
	[64488]="794:0",
	[64489]="794:0",
	[64493]="773:180",
	[64643]="794:0",
	[64644]="794:0",
	[64645]="794:0",
	[64646]="794:0",
	[64647]="794:0",
	[64648]="794:0",
	[64650]="794:0",
	[64651]="794:0",
	[64652]="794:0",
	[64653]="794:0",
	[64654]="794:0",
	[64655]="794:0",
	[64656]="794:0",
	[64657]="794:0",
	[64658]="794:0",
	[64659]="794:0",
	[64670]="773:75",
	[64880]="794:0",
	[64881]="794:0",
	[64883]="794:0",
	[64885]="794:0",
	[64904]="794:0",
	[65358]="164:475",
	[65365]="164:425",
	[65460]="171:525",
	[65891]="171:525",
	[66054]="794:0",
	[66055]="794:0",
	[66056]="794:0",
	[66057]="794:0",
	[66058]="794:0",
	[66918]="773:0",
	[67230]="185:40",
	[67274]="333:525",
	[67275]="333:525",
	[67415]="171:425",
	[67438]="171:500",
	[67482]="773:250",
	[67483]="773:150",
	[67484]="773:330",
	[67485]="773:120",
	[67486]="773:150",
	[67487]="773:120",
	[67494]="202:440",
	[67602]="164:515",
	[67605]="164:520",
	[67749]="202:445",
	[68039]="773:0",
	[68049]="202:510",
	[68356]="755:465",
	[68357]="755:465",
	[68358]="755:465",
	[68687]="185:500",
	[68741]="755:465",
	[68775]="171:500",
	[68776]="171:500",
	[68777]="171:500",
	[68778]="755:490",
	[68779]="755:490",
	[68780]="755:490",
	[68793]="773:275",
	[69764]="794:0",
	[69773]="773:0",
	[69775]="794:0",
	[69776]="794:0",
	[69777]="794:0",
	[69821]="794:0",
	[69824]="794:0",
	[69852]="755:525",
	[69936]="164:525",
	[69937]="164:525",
	[69938]="164:525",
	[69939]="165:525",
	[69941]="165:525",
	[69942]="165:525",
	[69943]="165:525",
	[69944]="197:525",
	[69945]="197:525",
	[69946]="164:525",
	[69947]="164:525",
	[69948]="164:525",
	[69949]="165:525",
	[69950]="165:525",
	[69951]="165:525",
	[69952]="165:525",
	[69953]="197:525",
	[69954]="197:525",
	[70136]="165:510",
	[70137]="165:500",
	[70138]="197:515",
	[70139]="202:515",
	[70155]="164:525",
	[70156]="164:525",
	[70157]="164:525",
	[70158]="164:525",
	[70162]="164:525",
	[70163]="164:525",
	[70164]="164:525",
	[70165]="164:525",
	[71077]="202:525",
	[71155]="773:0",
	[71720]="165:525",
	[71817]="755:525",
	[71818]="755:525",
	[71819]="755:525",
	[71820]="755:525",
	[71822]="755:525",
	[71823]="755:525",
	[71824]="755:525",
	[71825]="755:525",
	[71826]="755:525",
	[71827]="755:525",
	[71828]="755:525",
	[71829]="755:525",
	[71830]="755:525",
	[71831]="755:525",
	[71832]="755:525",
	[71833]="755:525",
	[71834]="755:525",
	[71835]="755:525",
	[71836]="755:525",
	[71837]="755:525",
	[71838]="755:525",
	[71839]="755:525",
	[71840]="755:525",
	[71841]="755:525",
	[71842]="755:525",
	[71843]="755:525",
	[71844]="755:525",
	[71845]="755:525",
	[71846]="755:525",
	[71847]="755:525",
	[71848]="755:525",
	[71849]="755:525",
	[71850]="755:525",
	[71851]="755:525",
	[71852]="755:525",
	[71853]="755:525",
	[71854]="755:525",
	[71855]="755:525",
	[71856]="755:525",
	[71857]="755:525",
	[71858]="755:525",
	[71859]="755:525",
	[71860]="755:525",
	[71861]="755:525",
	[71862]="755:525",
	[71863]="755:525",
	[71864]="755:525",
	[71865]="755:525",
	[71866]="755:525",
	[71867]="755:525",
	[71868]="755:525",
	[71869]="755:525",
	[71870]="755:525",
	[71871]="755:525",
	[71872]="755:525",
	[71873]="755:525",
	[71874]="755:525",
	[71875]="755:525",
	[71876]="755:525",
	[71877]="755:525",
	[71878]="755:525",
	[71879]="755:525",
	[71880]="755:525",
	[71881]="755:525",
	[71882]="755:525",
	[71883]="755:525",
	[71980]="197:525",
	[71981]="197:525",
	[71982]="164:525",
	[71983]="164:525",
	[71984]="164:525",
	[71985]="165:525",
	[71986]="165:525",
	[71987]="165:525",
	[71988]="165:525",
	[71989]="197:525",
	[71990]="197:525",
	[71991]="164:525",
	[71992]="164:525",
	[71993]="164:525",
	[71994]="165:525",
	[71995]="165:525",
	[71996]="165:525",
	[71997]="165:525",
	[72101]="197:150",
	[75061]="165:520",
	[75062]="197:525",
	[75063]="197:520",
	[75064]="197:505",
	[75065]="197:490",
	[75066]="773:510",
	[75067]="755:510",
	[75068]="755:510",
	[75069]="773:510",
	[75070]="197:515",
	[75071]="755:510",
	[75072]="197:525",
	[75073]="197:525",
	[75074]="755:520",
	[75075]="755:520",
	[75076]="165:500",
	[75077]="165:500",
	[75078]="755:520",
	[75079]="773:510",
	[75080]="165:525",
	[75081]="165:515",
	[75082]="197:525",
	[75083]="165:515",
	[75084]="165:525",
	[75085]="165:510",
	[75086]="197:510",
	[75087]="197:515",
	[75088]="197:525",
	[75089]="197:500",
	[75090]="165:525",
	[75091]="197:510",
	[75092]="165:515",
	[75093]="197:525",
	[75094]="165:510",
	[75095]="197:520",
	[75096]="197:510",
	[75097]="165:520",
	[75098]="197:500",
	[75099]="165:520",
	[75100]="165:520",
	[75101]="165:515",
	[75102]="165:520",
	[75103]="165:525",
	[75104]="165:510",
	[75105]="165:520",
	[75106]="165:510",
	[75107]="165:520",
	[75108]="165:525",
	[75109]="165:515",
	[75110]="165:515",
	[75111]="165:525",
	[75112]="165:525",
	[75113]="165:515",
	[75114]="165:510",
	[75115]="165:525",
	[75116]="165:510",
	[75117]="165:510",
	[75118]="164:510",
	[75119]="164:520",
	[75120]="164:515",
	[75121]="164:505",
	[75122]="164:505",
	[75123]="164:510",
	[75124]="164:500",
	[75125]="164:500",
	[75126]="164:525",
	[75127]="165:520",
	[75128]="164:525",
	[75129]="164:525",
	[75130]="165:515",
	[75131]="165:510",
	[75132]="164:515",
	[75133]="164:525",
	[75134]="164:520",
	[75135]="164:525",
	[75136]="164:525",
	[77101]="773:0",
})

-- The base item data
Informant.SetDatabase({
	[17]="0:4:0:1:Shirt::1:0::3:0", -- Martin Fury
	[25]="0:2:1:1:OneHandSword::1:0::0:0", -- Worn Shortsword
	[35]="0:2:1:1:Stave::1:0::0:0", -- Bent Staff
	[36]="0:2:1:1:OneHandMace::1:0::0:0", -- Worn Mace
	[37]="0:2:1:1:OneHandAxe::1:0::0:0", -- Worn Axe
	[38]="1:4:1:1:Shirt::1:0:18672:0:0", -- Recruit's Shirt
	[39]="7:4:1:1:Cloth::1:0:18672:0:0", -- Recruit's Pants
	[40]="5:4:1:1:Cloth::1:0:18672:0:0", -- Recruit's Boots
	[43]="5:4:1:1:Cloth::1:0:18672:0:0", -- Squire's Boots
	[44]="7:4:1:1:Cloth::1:0:18672:0:0", -- Squire's Pants
	[45]="1:4:1:1:Shirt::1:0:18672:0:0", -- Squire's Shirt
	[47]="0:4:1:1:Cloth::1:0::0:0", -- Footpad's Shoes
	[48]="0:4:1:1:Cloth::1:0::0:0", -- Footpad's Pants
	[49]="0:4:1:1:Shirt::1:0::0:0", -- Footpad's Shirt
	[51]="5:4:1:1:Cloth::1:0:18672:0:0", -- Neophyte's Boots
	[52]="7:4:1:1:Cloth::1:0:18672:0:0", -- Neophyte's Pants
	[53]="1:4:1:1:Shirt::1:0:18672:0:0", -- Neophyte's Shirt
	[55]="5:4:1:1:Cloth::1:0:18672:0:0", -- Apprentice's Boots
	[56]="7:4:1:1:Cloth::1:0:18672:0:0", -- Apprentice's Robe
	[57]="7:4:1:1:Cloth::1:0:18672:0:0", -- Acolyte's Robe
	[59]="5:4:1:1:Cloth::1:0:18672:0:0", -- Acolyte's Shoes
	[60]="0:4:1:1:Leather::1:0::3:0", -- Layered Tunic
	[61]="0:4:1:1:Leather::1:0::3:0", -- Dwarven Leather Pants
	[79]="0:4:1:1:Cloth::1:0::3:0", -- Dwarven Cloth Britches
	[80]="0:4:1:1:Cloth::1:0::3:0", -- Soft Fur-Lined Shoes
	[85]="63:4:1:1:Leather::1:0:2113,3074,3160,4558,39033:0:0", -- Dirty Leather Vest
	[117]="25:0:1:20:FoodDrink::5:0:982,1156,1464,2388,2814,3025,3089,3312,3368,3411,3489,3705,3881,3882,3933,3935,4169,4782,4879,4891,4894,4954,5111,5124,5611,5620,5688,5870,6739,6741,6928,6929,7485,7731,7733,9356,11118,11187,12196,12959,14624,15174,15397,16443,16618,16739,17553,17630,17656,19182,23263,23481,23605,24208,24343,36378,39031,40589,40898,41286,41491,41674,41892,42953,43606,43624,43633,43739,43771,43899,43956,44177,44276,44312,44343,45563,47165,47288,47668,47854,48555,48735,50092,51142:0:0", -- Tough Jerky
	[118]="0:0:1:20:Potion:171:1:0::0:0", -- Minor Healing Potion
	[120]="0:4:1:1:Cloth::1:0::0:0", -- Thug Pants
	[121]="0:4:1:1:Cloth::1:0::0:0", -- Thug Boots
	[127]="0:4:1:1:Shirt::1:0::0:0", -- Trapper's Shirt
	[129]="0:4:1:1:Cloth::1:0::0:0", -- Rugged Trapper's Boots
	[139]="0:4:1:1:Cloth::1:0::0:0", -- Brawler's Pants
	[140]="0:4:1:1:Cloth::1:0::0:0", -- Brawler's Boots
	[147]="0:4:1:1:Cloth::1:0::0:0", -- Rugged Trapper's Pants
	[148]="0:4:1:1:Shirt::1:0::0:0", -- Rugged Trapper's Shirt
	[153]="0:4:1:1:Leather::1:0::0:0", -- Primitive Kilt
	[154]="0:4:1:1:Shirt::1:0::0:0", -- Primitive Mantle
	[159]="25:0:1:20:FoodDrink:185,202:5:0:151,152,227,258,274,295,465,491,791,829,955,982,1149,1156,1237,1247,1250,1285,1327,1328,1448,1452,1464,1682,1685,1691,1697,2084,2115,2134,2140,2303,2388,2397,2401,2664,2803,2808,2820,2832,2908,3027,3072,3076,3085,3086,3158,3164,3186,3298,3313,3350,3400,3411,3481,3498,3546,3587,3608,3625,3708,3881,3882,3883,3884,3934,3937,3959,3961,3962,4082,4167,4169,4170,4181,4190,4223,4241,4265,4266,4553,4554,4555,4571,4782,4879,4893,4894,4896,4981,5081,5101,5111,5112,5134,5140,5160,5483,5611,5620,5688,5814,5871,6091,6272,6727,6734,6735,6736,6738,6739,6740,6741,6746,6747,6790,6791,6807,6928,6929,6930,7485,7731,7733,7737,7744,7941,7942,7943,8143,8150,8152,8307,8362,8416,8931,9356,9501,11038,11103,11106,11118,11187,11287,11555,12019,12021,12026,12027,12033,12036,12196,12246,12959,12960,14371,14624,14731,14738,15174,15287,15397,15433,16187,16191,16253,16256,16259,16260,16443,16444,16542,16553,16618,16677,16718,16732,16739,16826,16920,17246,17421,17446,17489,17553,17630,17656,18011,18810,18811,18907,18959,18987,18993,19020,19021,19053,19182,19195,19197,19243,19314,19315,19343,19371,19374,19436,19452,19474,19498,19534,19560,19574,19617,19625,19649,19679,20028,20080,20092,20096,20097,20194,20231,20249,20892,21082,21111,21145,21172,21183,22099,22270,23143,23573,23802,23995,24053,24141,24188,24208,24348,24834,24934,25012,25035,25052,25089,26388,26718,26868,26934,26936,26938,27011,27022,27025,27041,27051,27058,27071,27145,27182,27193,27940,28691,28792,28807,28811,28830,28867,29035,29207,29291,29908,29925,29944,29962,29970,30011,30070,30256,30257,30310,31022,31031,31032,32477,32638,32642,33209,33595,33872,34645,34681,34682,34683,34684,34685,35337,35338,35340,36378,36695,36779,38783,38847,38853,39031,39032,40467,40474,40589,40815,40826,40898,40914,40968,41053,41128,41275,41286,41490,41491,41674,41676,41891,41892,42709,42853,43034,43384,43419,43424,43425,43558,43606,43624,43633,43637,43699,43748,43771,43899,43945,43946,43953,43972,44001,44006,44019,44034,44114,44177,44183,44190,44196,44219,44235,44236,44237,44267,44268,44270,44276,44294,44296,44297,44300,44302,44303,44304,44312,44334,44340,44343,44344,44376,44379,44391,44398,44417,44779,44785,45008,45086,45094,45286,45289,45290,45361,45484,45491,45496,45497,45551,45553,45563,45565,45566,46269,46271,46642,46659,46708,46966,46994,46995,47105,47139,47142,47148,47165,47167,47288,47334,47363,47367,47547,47668,47717,47756,47757,47854,47858,47938,47942,48054,48060,48067,48093,48122,48125,48215,48236,48555,48580,48599,48607,48735,48884,49394,49397,49406,49430,49435,49525,49547,49603,49775,49787,49789,49885,49917,49919,50092,50126,51709,53528,54232:0:0", -- Refreshing Spring Water
	[182]="0:12:1:1:::1:0::4:0", -- Garrick's Head
	[192]="0:2:0:1:Miscellaneous::1:0::3:0", -- Martin's Broken Staff
	[193]="49:4:1:1:Cloth::1:0:2113,3160,4558,39033:0:0", -- Tattered Cloth Vest
	[194]="49:4:1:1:Cloth::1:0:2113,3160,4558,39033:0:0", -- Tattered Cloth Pants
	[195]="37:4:1:1:Cloth::1:0:2113,3160,4558,39033:0:0", -- Tattered Cloth Boots
	[200]="2270:4:1:1:Cloth::1:0:1291,2849,3092,3317,3492,3952,4175,5155,5821,8358,16623,16716,33381,44285:0:0", -- Thick Cloth Vest
	[201]="2278:4:1:1:Cloth::1:0:1291,2849,3092,3317,3492,3952,4175,5155,5821,8358,16623,16716,33381,44285:0:0", -- Thick Cloth Pants
	[202]="1715:4:1:1:Cloth::1:0:1291,2849,3092,3317,3492,3952,4175,5155,5821,8358,16623,16716,33381,44285:0:0", -- Thick Cloth Shoes
	[203]="1147:4:1:1:Cloth::1:0:1291,2849,3092,3317,3492,3952,4175,5155,5821,8358,16623,16716,33381,44285:0:0", -- Thick Cloth Gloves
	[209]="61:4:1:1:Leather::1:0:2113,3074,3160,4558,39033:0:0", -- Dirty Leather Pants
	[210]="45:4:1:1:Leather::1:0:2113,3074,3160,4558,39033:0:0", -- Dirty Leather Boots
	[236]="2795:4:1:1:Leather::1:0:1295,3093,3321,3492,3536,3953,4236,5820,8359,16691,16747,33381,43568,44286:0:0", -- Cured Leather Armor
	[237]="2806:4:1:1:Leather::1:0:1295,3093,3321,3492,3536,3953,4236,5820,8359,16691,16747,33381,43568,44286:0:0", -- Cured Leather Pants
	[238]="2112:4:1:1:Leather::1:0:1295,3093,3321,3492,3536,3953,4236,5820,8359,16691,16747,33381,43568,44286:0:0", -- Cured Leather Boots
	[239]="1413:4:1:1:Leather::1:0:1295,3093,3321,3492,3536,3953,4236,5820,8359,16691,16747,33381,43568,44286:0:0", -- Cured Leather Gloves
	[285]="3555:4:1:1:Mail::1:0:956,1294,1341,3319,3493,3682,4177,5125,5812,5819,8360,16625,16750,33381:0:0", -- Scalemail Vest
	[286]="3229:4:1:1:Mail::1:0:956,1294,1341,3319,3493,3682,4177,5125,5812,5819,8360,16625,16750,33381:0:0", -- Scalemail Pants
	[287]="2442:4:1:1:Mail::1:0:956,1294,1341,3319,3493,3682,4177,5125,5812,5819,8360,16625,16750,33381:0:0", -- Scalemail Boots
	[414]="125:0:1:20:FoodDrink::5:0:295,465,483,1237,3298,3546,4782,4891,4894,4981,5620,6746,6790,6930,9501,11106,16553,17630,18929,23521,23604,24934,29714,38714,40815,43972,44268,44417,44785,46269,46995,48125,49917:0:0", -- Dalaran Sharp
	[422]="500:0:1:20:FoodDrink::5:0:295,465,483,1237,3298,3546,4782,4891,4894,4981,5620,6746,6790,6930,9501,11106,16553,17630,18929,23521,23604,24934,38714,40815,43972,44268,44417,44785,46269,46995,48125,49917:0:0", -- Dwarven Mild
	[537]="0:15:0:20:Junk::1:0::0:0", -- Dull Frenzy Scale
	[555]="0:15:0:20:Junk::1:0::0:0", -- Rough Vulture Feathers
	[556]="0:15:0:20:Junk::1:0::0:0", -- Buzzard Beak
	[647]="0:2:4:1:TwoHandSword::1:0::2:0", -- Destiny
	[710]="0:4:1:1:Cloth::1:0::3:0", -- Bracers of the People's Militia
	[711]="26:4:1:1:Cloth::1:0:2113,3160,4558,39033:0:0", -- Tattered Cloth Gloves
	[714]="32:4:1:1:Leather::1:0:2113,3074,3160,4558,39033:0:0", -- Dirty Leather Gloves
	[718]="1614:4:1:1:Mail::1:0:956,1294,1341,3319,3493,3682,4177,5125,5812,5819,8360,16625,16750,33381:0:0", -- Scalemail Gloves
	[719]="0:4:1:1:Cloth::1:0::3:0", -- Rabbit Handler Gloves
	[720]="0:4:3:1:Leather::1:0::2:0", -- Brawler Gloves
	[723]="0:7:1:20:Meat:185:1:0::0:0", -- Goretusk Liver
	[724]="0:0:1:20:FoodDrink::1:0::0:0", -- Goretusk Liver Pie
	[725]="0:12:1:20:::1:0::4:0", -- Gnoll Paw
	[727]="0:2:2:1:OneHandSword::1:0::2:0", -- Notched Shortsword
	[728]="200:9:1:1:Cooking::1:0:340:3:0", -- Recipe: Westfall Stew
	[729]="0:7:0:20:Meat::1:0::0:0", -- Stringy Vulture Meat
	[730]="0:7:0:20:Meat::1:0::0:0", -- Murloc Eye
	[731]="0:7:0:20:Meat::1:0::0:0", -- Goretusk Snout
	[732]="0:7:0:20:::1:0::0:0", -- Ripe Okra
	[733]="0:0:1:20:FoodDrink::1:0::0:0", -- Westfall Stew
	[735]="0:12:1:1:::1:0::4:0", -- Rolf and Malakai's Medallions
	[737]="0:12:1:1:::1:0::3:0", -- Holy Spring Water
	[738]="0:12:1:20:::1:0::4:0", -- Sack of Barley
	[739]="0:12:1:20:::1:0::4:0", -- Sack of Corn
	[740]="0:12:1:20:::1:0::4:0", -- Sack of Rye
	[743]="0:12:1:1:::1:0::4:0", -- Bundle of Charred Oak
	[744]="0:4:2:1:Trinket::1:0::3:0", -- Thunderbrew's Boot Flask
	[745]="0:12:1:1:::1:0::4:0", -- Marshal McBride's Documents
	[748]="0:12:1:1:::1:0::4:0", -- Stormwind Armor Marker
	[750]="0:12:1:20:::1:0::4:0", -- Tough Wolf Meat
	[752]="0:12:1:20:::1:0::4:0", -- Red Burlap Bandana
	[753]="0:2:2:1:OneHandSword::1:0::2:0", -- Dragonmaw Shortsword
	[754]="0:2:3:1:OneHandSword::1:0::2:0", -- Shortsword of Vengeance
	[755]="0:15:0:20:Junk::1:0::0:0", -- Melted Candle
	[756]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Tunnel Pick
	[763]="0:4:1:1:Leather::1:0::0:0", -- Ice-Covered Bracers
	[765]="40:7:1:20:Herb:171:1:1:1313,3490,3548,16224,16641,16705:0:0", -- Silverleaf
	[766]="0:2:1:1:OneHandMace::1:0::0:0", -- Flanged Mace
	[767]="0:2:1:1:Stave::1:0::0:0", -- Long Bo Staff
	[768]="0:2:1:1:OneHandAxe::1:0::0:0", -- Lumberjack Axe
	[769]="0:7:1:20:Meat:185:1:0::0:0", -- Chunk of Boar Meat
	[770]="0:15:0:20:Junk::1:0::0:0", -- Pointy Crocolisk Tooth
	[771]="0:15:0:20:Junk::1:0::0:0", -- Chipped Boar Tusk
	[772]="0:12:1:20:::1:0::4:0", -- Large Candle
	[773]="0:12:1:20:::1:0::4:0", -- Gold Dust
	[774]="0:3:2:20:GemSimple:164,202,755:1:0::0:0", -- Malachite
	[776]="0:2:3:1:Dagger::1:0::2:0", -- Vendetta
	[777]="0:15:0:20:Junk::1:0::0:0", -- Prowler Teeth
	[778]="0:2:1:1:OneHandAxe::1:0::0:0", -- Kobold Excavation Pick
	[779]="0:15:0:20:Junk::1:0::0:0", -- Shiny Seashell
	[780]="0:12:1:20:::1:0::4:0", -- Torn Murloc Fin
	[781]="0:2:1:1:OneHandMace::1:0::0:0", -- Stone Gnoll Hammer
	[782]="0:12:1:20:::1:0::4:0", -- Painted Gnoll Armband
	[783]="0:7:1:10:Leather:165:1:0::0:0", -- Light Hide
	[785]="80:7:1:20:Herb:171,185:1:1:844,1302,1313,3490,3548,4083,8305,14846,16224,16641,16705:0:0", -- Mageroyal
	[787]="25:0:1:20:FoodDrink::5:0:1678,1684,2842,3029,3086,3178,3497,4221,4305,5814,6727,6738,6791,6807,7943,8931,11187,12962,14731,16618,16739,17553,17656,19045,23896,24834,25012,25052,25089,29291,43899,43945,43946,44334,45008,45086,46182,46642,47334,56069:0:0", -- Slitherskin Mackerel
	[789]="0:2:2:1:OneHandMace::1:0::2:0", -- Stout Battlehammer
	[790]="0:2:2:1:OneHandAxe::1:0::2:0", -- Forester's Axe
	[791]="0:2:3:1:Stave::1:0::2:0", -- Gnarled Ash Staff
	[792]="208:4:1:1:Cloth::1:0:74,959,1238,1291,3092,3611,3952,4164,4175,5821,16716,17929:0:0", -- Knitted Sandals
	[793]="139:4:1:1:Cloth::1:0:74,959,1238,1291,3092,3611,3952,4164,4175,5821,16716,17929:0:0", -- Knitted Gloves
	[794]="280:4:1:1:Cloth::1:0:74,959,1238,1291,3092,3611,3952,4164,4175,5821,16716,17929:0:0", -- Knitted Pants
	[795]="281:4:1:1:Cloth::1:0:74,959,1238,1291,3092,3611,3952,4164,4175,5821,16716,17929:0:0", -- Knitted Tunic
	[796]="264:4:1:1:Leather::1:0:74,896,1238,1295,3162,3612,3953,4164,4236,5820,16747,17929:0:0", -- Rough Leather Boots
	[797]="177:4:1:1:Leather::1:0:74,896,1238,1295,3162,3612,3953,4164,4236,5820,16747,17929:0:0", -- Rough Leather Gloves
	[798]="355:4:1:1:Leather::1:0:74,896,1238,1295,3162,3612,3953,4164,4236,5820,16747,17929:0:0", -- Rough Leather Pants
	[799]="356:4:1:1:Leather::1:0:74,896,1238,1295,3162,3612,3953,4164,4236,5820,16747,17929:0:0", -- Rough Leather Vest
	[804]="0:1:1:1:Bag::1:0::0:0", -- Large Blue Sack
	[805]="0:1:1:1:Bag::1:0::0:0", -- Small Red Pouch
	[809]="0:2:4:1:OneHandSword::1:0::2:0", -- Bloodrazor
	[810]="0:2:4:1:OneHandMace::1:0::2:0", -- Hammer of the Northern Wind
	[811]="0:2:4:1:OneHandAxe::1:0::2:0", -- Axe of the Deep Woods
	[812]="0:2:4:1:Stave::1:0::2:0", -- Glowing Brightwood Staff
	[814]="0:7:1:20:Part:202:1:0::0:0", -- Flask of Oil
	[816]="0:2:2:1:Dagger::1:0::2:0", -- Small Hand Blade
	[818]="0:3:2:20:GemSimple:164,202,755:1:0::0:0", -- Tigerseye
	[820]="0:2:2:1:Dagger::1:0::2:0", -- Slicer Blade
	[821]="0:4:2:1:Leather::1:0::2:0", -- Riverpaw Leather Vest
	[826]="0:2:2:1:OneHandAxe::1:0::2:0", -- Brutish Riverpaw Axe
	[827]="0:2:2:1:OneHandMace::1:0::2:0", -- Wicked Blackjack
	[828]="0:1:1:1:Bag::1:0::0:0", -- Small Blue Pouch
	[829]="0:12:1:20:::1:0::4:0", -- Red Leather Bandana
	[832]="0:4:2:1:Mail::1:0::2:0", -- Silver Defias Belt
	[833]="0:4:4:1:Trinket::1:0::2:0", -- Lifestone
	[835]="0:0:1:1:Consumable::1:0::3:0", -- Large Rope Net
	[837]="1125:4:1:1:Cloth::1:0:1214,1291,3092,3317,3486,3554,3952,4164,4175,4558,5108,5821,8358,16623,16631,16716,43436:0:0", -- Heavy Weave Armor
	[838]="1129:4:1:1:Cloth::1:0:1214,1291,3092,3317,3486,3554,3952,4164,4175,4558,5108,5821,8358,16623,16631,16716,43436:0:0", -- Heavy Weave Pants
	[839]="566:4:1:1:Cloth::1:0:1214,1291,3092,3317,3486,3554,3952,4164,4175,4558,5108,5821,8358,16623,16631,16716,43436:0:0", -- Heavy Weave Gloves
	[840]="853:4:1:1:Cloth::1:0:1214,1291,3092,3317,3486,3554,3952,4164,4175,4558,5108,5821,8358,16623,16631,16716,43436:0:0", -- Heavy Weave Shoes
	[841]="0:12:1:1:::1:0::4:0", -- Furlbrow's Pocket Watch
	[843]="1077:4:1:1:Leather::1:0:896,954,1295,3093,3321,3483,3552,3953,4164,4236,4558,5108,5820,8359,10380,16691,16747,43439,43951:0:0", -- Tanned Leather Boots
	[844]="721:4:1:1:Leather::1:0:896,954,1295,3093,3321,3483,3552,3953,4164,4236,4558,5108,5820,8359,10380,16691,16747,43439,43951:0:0", -- Tanned Leather Gloves
	[845]="1447:4:1:1:Leather::1:0:896,954,1295,3093,3321,3483,3552,3953,4164,4236,4558,5108,5820,8359,10380,16691,16747,43439,43951:0:0", -- Tanned Leather Pants
	[846]="1452:4:1:1:Leather::1:0:896,954,1295,3093,3321,3483,3552,3953,4164,4236,4558,5108,5820,8359,10380,16691,16747,43439,43951:0:0", -- Tanned Leather Jerkin
	[847]="1749:4:1:1:Mail::1:0:167,1294,1362,3319,3483,3553,4164,4177,4187,4560,5107,5812,5819,8360,16625,16750,43955,43957:0:0", -- Chainmail Armor
	[848]="1755:4:1:1:Mail::1:0:167,1294,1362,3319,3483,3553,4164,4177,4187,4560,5107,5812,5819,8360,16625,16750,43955,43957:0:0", -- Chainmail Pants
	[849]="1327:4:1:1:Mail::1:0:167,1294,1362,3319,3483,3553,4164,4177,4187,4560,5107,5812,5819,8360,16625,16750,43955,43957:0:0", -- Chainmail Boots
	[850]="883:4:1:1:Mail::1:0:167,1294,1362,3319,3483,3553,4164,4177,4187,4560,5107,5812,5819,8360,16625,16750,43955,43957:0:0", -- Chainmail Gloves
	[851]="2023:2:1:1:OneHandSword::1:0:1287,1289,2997,3021,3314,3331,3361,3479,3534,3658,4171,4203,4231,4557,4569,5103,5120,6030,16714,43645,43948:0:0", -- Cutlass
	[852]="1739:2:1:1:OneHandMace::1:0:222,1287,1289,1348,2840,2997,3020,3314,3360,3479,3534,3658,4203,4231,4233,4557,4602,5103,5121,6030,16765,17412,43645,46996:0:0", -- Mace
	[853]="2409:2:1:1:OneHandAxe::1:0:1287,1289,2997,3019,3314,3409,3479,3534,3658,4203,4231,4232,4557,4601,5103,5119,6030,16714,43645,46996,47149,47166:0:0", -- Hatchet
	[854]="3023:2:1:1:Stave::1:0:1287,1289,1348,2997,3020,3314,3360,3409,3479,3534,3658,4203,4231,4233,4557,4602,5103,5121,6030,16765,17412,19238,43645,46996:0:0", -- Quarter Staff
	[856]="0:1:1:1:Bag::1:0::0:0", -- Blue Leather Bag
	[857]="0:1:1:1:Bag::1:0::0:0", -- Large Red Sack
	[858]="100:0:1:20:Potion::1:1:844,958,1257,2140,3548,3658,14847:0:0", -- Lesser Healing Potion
	[859]="0:4:1:1:Shirt::1:0::3:0", -- Fine Cloth Shirt
	[860]="0:4:1:1:Cloth::1:0::3:0", -- Cavalier's Boots
	[862]="0:4:3:1:Ring::1:0::2:0", -- Runed Ring
	[863]="0:2:2:1:OneHandAxe::1:0::2:0", -- Gloom Reaper
	[864]="0:2:2:1:OneHandSword::1:0::2:0", -- Knightly Longsword
	[865]="0:2:2:1:OneHandMace::1:0::2:0", -- Leaden Mace
	[866]="0:2:2:1:Stave::1:0::2:0", -- Monk's Staff
	[867]="0:4:4:1:Leather::1:0::2:0", -- Gloves of Holy Might
	[868]="0:2:4:1:OneHandMace::1:0::2:0", -- Ardent Custodian
	[869]="0:2:4:1:OneHandSword::1:0::2:0", -- Dazzling Longsword
	[870]="0:2:4:1:TwoHandAxe::1:0::2:0", -- Fiery War Axe
	[871]="0:2:4:1:OneHandAxe::1:0::2:0", -- Flurry Axe
	[872]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Rockslicer
	[873]="0:2:4:1:Stave::1:0::2:0", -- Staff of Jordan
	[878]="0:7:0:20:Other::1:0::0:0", -- Fist-Sized Spinneret
	[880]="0:2:2:1:Stave::1:0::2:0", -- Staff of Horrors
	[884]="0:12:1:20:::1:0::4:0", -- Ghoul Rib
	[885]="0:2:2:1:OneHandAxe::1:0::2:0", -- Black Metal Axe
	[886]="0:2:2:1:OneHandSword::1:0::2:0", -- Black Metal Shortsword
	[887]="0:15:0:20:Junk::1:0::0:0", -- Pound of Flesh
	[888]="0:4:3:1:Leather::1:0::3:0", -- Naga Battle Gloves
	[889]="0:12:1:1:::1:0::4:0", -- A Dusty Unsent Letter
	[890]="0:2:3:1:Stave::1:0::2:0", -- Twisted Chanter's Staff
	[892]="0:4:2:1:Cloth::1:0::2:0", -- Gnoll Casting Gloves
	[893]="0:15:0:20:Junk::1:0::0:0", -- Dire Wolf Fang
	[897]="0:4:2:1:Leather::1:0::2:0", -- Madwolf Bracers
	[899]="0:2:2:1:Dagger::1:0::2:0", -- Venom Web Fang
	[910]="0:12:1:1:::1:0::4:0", -- An Undelivered Letter
	[911]="0:2:2:1:TwoHandMace::1:0::2:0", -- Ironwood Treebranch
	[914]="0:4:2:1:Mail::1:0::2:0", -- Large Ogre Chain Armor
	[915]="0:12:1:20:::1:0::4:0", -- Red Silk Bandana
	[916]="0:12:1:1:::1:0::4:0", -- A Torn Journal Page
	[918]="0:1:1:1:Bag::1:0::3:0", -- Deviate Hide Pack
	[920]="0:2:2:1:OneHandMace::1:0::2:0", -- Wicked Spiked Mace
	[921]="0:12:1:1:::1:0::4:0", -- A Faded Journal Page
	[922]="12039:2:1:1:TwoHandSword::1:0:225,1287,1289,1441,3021,3331,3361,3539,4171,4203,4569,5120,11137,16714,33265,41622,43948:0:0", -- Dacian Falx
	[923]="8744:2:1:1:OneHandSword::1:0:225,1287,1289,1441,3021,3331,3361,3539,4171,4203,4569,5120,11137,16714,33265,41622,43948:0:0", -- Longsword
	[924]="10973:2:1:1:TwoHandMace::1:0:225,1287,1289,1348,1441,3020,3360,3539,4203,4233,4602,5121,11137,16765,17412,33265,41622,46996:0:0", -- Maul
	[925]="7797:2:1:1:OneHandMace::1:0:225,1287,1289,1348,1441,3020,3360,3539,4203,4233,4602,5121,11137,16765,17412,33265,41622,46996:0:0", -- Flail
	[926]="9785:2:1:1:TwoHandAxe::1:0:225,1287,1289,1441,3019,3409,3539,4203,4232,4601,5119,11137,16714,33265,41622,46996,47149,47166:0:0", -- Battle Axe
	[927]="6954:2:1:1:OneHandAxe::1:0:225,1287,1289,1441,3019,3409,3539,4203,4232,4601,5119,11137,16714,33265,41622,46996,47149,47166:0:0", -- Double Axe
	[928]="9860:2:1:1:Stave::1:0:225,1287,1289,1348,1441,3020,3360,3409,3539,4203,4233,4602,5121,11137,16765,17412,19238,33265,41622,46996:0:0", -- Long Staff
	[929]="300:0:1:20:Potion:197:1:1:1307,1453,1457,2805,3134,3534,4083,8305,18810:0:0", -- Healing Potion
	[932]="0:1:1:1:Bag::1:0::0:0", -- Fel Steed Saddlebags
	[933]="0:1:1:1:Bag::1:0::0:0", -- Large Rucksack
	[934]="0:2:3:1:OneHandAxe::1:0::2:0", -- Stalvan's Reaper
	[935]="0:2:3:1:OneHandSword::1:0::2:0", -- Night Watch Shortsword
	[936]="0:2:3:1:OneHandMace::1:0::2:0", -- Midnight Mace
	[937]="0:2:3:1:Stave::1:0::2:0", -- Black Duskwood Staff
	[938]="0:12:1:1:::1:0::4:0", -- Muddy Journal Pages
	[939]="0:12:1:1:::1:0::4:0", -- A Bloodstained Journal Page
	[940]="0:4:4:1:Cloth::1:0::2:0", -- Robes of Insight
	[942]="0:4:4:1:Ring::1:0::2:0", -- Freezing Band
	[943]="0:2:4:1:Stave::1:0::2:0", -- Warden Staff
	[944]="0:2:4:1:Stave::1:0::2:0", -- Elemental Mage Staff
	[954]="200:0:1:20:Scroll::1:1:958,1316,2805,4581,14847,16224:0:0", -- Scroll of Strength
	[955]="150:0:1:20:Scroll::1:1:958,1316,4581,14847,16224:0:0", -- Scroll of Intellect
	[957]="0:12:1:1:::1:0::4:0", -- William's Shipment
	[961]="0:0:1:10:FoodDrink::1:0::0:0", -- Healing Herb
	[962]="0:12:1:1:::1:0::4:0", -- Pork Belly Pie
	[981]="0:12:1:1:::1:0::4:0", -- Bernice's Necklace
	[983]="0:4:2:1:Cloth::1:0::3:0", -- Red Linen Sash
	[997]="0:2:1:1:OneHandSword::1:0::0:0", -- Fire Sword of Crippling
	[1006]="0:12:1:1:::1:0::4:0", -- Brass Collar
	[1008]="0:2:1:1:OneHandSword::1:0::3:0", -- Well-Used Sword
	[1009]="0:2:2:1:OneHandMace::1:0::3:0", -- Compact Hammer
	[1010]="0:2:1:1:Stave::1:0::3:0", -- Gnarled Short Staff
	[1011]="0:2:1:1:OneHandAxe::1:0::3:0", -- Sharp Axe
	[1013]="0:12:1:20:::1:0::4:0", -- Iron Rivet
	[1015]="0:7:1:20:Meat:185:1:0::0:0", -- Lean Wolf Flank
	[1017]="0:0:1:20:FoodDrink::1:0::0:0", -- Seasoned Wolf Kabob
	[1019]="0:12:1:20:::1:0::4:0", -- Linen Scrap
	[1074]="0:15:0:20:Junk::1:0::0:0", -- Hard Spider Leg Tip
	[1075]="0:12:1:20:::1:0::4:0", -- Shadowhide Pendant
	[1076]="0:4:2:1:Ring::1:0::2:0", -- Defias Renegade Ring
	[1077]="0:4:2:1:Ring::1:0::2:0", -- Defias Mage Ring
	[1080]="0:7:1:20:Meat:185:1:0::0:0", -- Tough Condor Meat
	[1081]="0:7:0:20:Meat::1:0::0:0", -- Crisp Spider Meat
	[1082]="0:0:1:20:FoodDrink::1:0::0:0", -- Redridge Goulash
	[1083]="0:12:1:20:::1:0::4:0", -- Glyph of Azora
	[1113]="0:0:1:20:FoodDrink::1:0::0:0", -- Conjured Bread
	[1114]="0:0:1:20:FoodDrink::1:0::0:0", -- Conjured Rye
	[1116]="0:4:2:1:Ring::1:0::3:0", -- Ring of Pure Silver
	[1121]="0:4:3:1:Leather::1:0::2:0", -- Feet of the Lynx
	[1127]="0:0:1:10:Consumable::1:0::3:0", -- Flash Bundle
	[1129]="0:12:1:20:::1:0::4:0", -- Ghoul Fang
	[1130]="0:12:1:20:::1:0::4:0", -- Vial of Spider Venom
	[1131]="0:4:2:1:OffHandFrill::1:0::3:0", -- Totem of Infliction
	[1132]="10000:15:3:1:Mount::1:0:3362:3:0", -- Horn of the Timber Wolf
	[1154]="0:4:1:1:Mail::1:0::3:0", -- Belt of the People's Militia
	[1155]="0:2:3:1:Stave::1:0::3:0", -- Rod of the Sleepwalker
	[1156]="0:4:3:1:Ring::1:0::3:0", -- Lavishly Jeweled Ring
	[1158]="0:2:2:1:OneHandMace::1:0::3:0", -- Solid Metal Club
	[1159]="0:2:1:1:Stave::1:0::3:0", -- Militia Quarterstaff
	[1161]="0:2:1:1:OneHandSword::1:0::3:0", -- Militia Shortsword
	[1168]="0:4:4:1:Shield::1:0::2:0", -- Skullflame Shield
	[1169]="0:4:4:1:Shield::1:0::2:0", -- Blackskull Shield
	[1171]="0:4:2:1:Cloth::1:0::3:0", -- Well-Stitched Robe
	[1172]="0:4:2:1:OffHandFrill::1:0::3:0", -- Grayson's Torch
	[1173]="0:4:1:1:Leather::1:0::3:0", -- Weather-Worn Boots
	[1175]="0:15:0:20:Junk::1:0::0:0", -- A Gold Tooth
	[1177]="0:0:1:10:Other::1:0::0:0", -- Oil of Olaf
	[1178]="0:0:1:20:Other::1:0::0:0", -- Explosive Rocket
	[1179]="125:0:1:20:FoodDrink:185:5:0:227,258,274,295,465,491,791,955,982,1156,1237,1247,1327,1328,1448,1452,1464,1682,1685,1697,2140,2303,2388,2401,2803,2832,3086,3298,3313,3411,3481,3498,3546,3708,3881,3882,3883,3884,3934,3937,3959,3961,3962,4082,4167,4169,4181,4190,4266,4554,4555,4571,4782,4879,4893,4981,5111,5112,5140,5611,5620,5688,5814,5871,6091,6272,6727,6734,6735,6736,6738,6739,6740,6741,6746,6747,6790,6791,6807,6928,6929,6930,7485,7731,7733,7737,7744,7941,7942,7943,8143,8150,8152,8362,8931,9356,9501,11038,11103,11106,11118,11187,11287,12019,12021,12026,12027,12036,12196,12959,12960,14371,14624,14731,15174,15397,15433,16187,16191,16256,16443,16444,16542,16553,16618,16732,16739,17421,17489,17553,17630,17656,18810,18811,19182,19617,21145,23573,23995,24208,24834,24934,25012,25052,25089,29291,33209,36378,39031,40467,40589,40815,40898,40968,41128,41286,41491,41674,41892,42709,43034,43384,43419,43424,43425,43606,43624,43633,43637,43699,43771,43899,43945,43946,43953,43972,44001,44006,44114,44177,44183,44190,44196,44219,44235,44236,44237,44267,44268,44270,44276,44294,44296,44297,44300,44303,44304,44312,44334,44340,44343,44344,44379,44391,44417,44785,45008,45086,45417,45484,45491,45496,45497,45563,45565,45566,46269,46271,46642,46659,46994,46995,47142,47165,47288,47334,47363,47367,47547,47668,47717,47756,47854,47858,47942,48054,48067,48093,48125,48215,48555,48599,48607,48735,49394,49397,49430,49435,49917,50092,50126,51709,53528:0:0", -- Ice Cold Milk
	[1180]="150:0:1:20:Scroll::1:1:958,1316,4581,14847,16224:0:0", -- Scroll of Stamina
	[1181]="100:0:1:20:Scroll::1:1:958,1316,4581,14847,16224:0:0", -- Scroll of Spirit
	[1182]="0:4:1:1:Mail::1:0::3:0", -- Brass-Studded Bracers
	[1183]="0:4:2:1:Cloth::1:0::3:0", -- Elastic Wristguards
	[1187]="0:0:2:1:Consumable::1:0::3:0", -- Spiked Collar
	[1189]="0:4:2:1:Ring::1:0::2:0", -- Overseer's Ring
	[1190]="0:4:2:1:Cloak::1:0::2:0", -- Overseer's Cloak
	[1191]="0:0:1:1:Consumable::1:0::3:0", -- Bag of Marbles
	[1194]="104:2:1:1:TwoHandSword::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919,42335,43645:0:0", -- Bastard Sword
	[1195]="0:2:1:1:TwoHandMace::1:0::0:0", -- Kobold Mining Shovel
	[1196]="2214:2:1:1:TwoHandAxe::1:0:1287,1289,2997,3019,3314,3409,3479,3534,3658,4203,4231,4232,4557,4601,5103,5119,6030,16714,43645,46996,47149,47166:0:0", -- Tabar
	[1197]="2667:2:1:1:TwoHandMace::1:0:222,1287,1289,1348,2840,2997,3020,3314,3360,3479,3534,3658,4203,4231,4233,4557,4602,5103,5121,6030,16765,17412,43645,46996:0:0", -- Giant Mace
	[1198]="2677:2:1:1:TwoHandSword::1:0:1287,1289,2997,3021,3314,3331,3361,3479,3534,3658,4171,4203,4231,4557,4569,5103,5120,6030,16714,43645,43948:0:0", -- Claymore
	[1200]="82:4:1:1:Shield::1:0:2116,3075,3161,4559,16693:0:0", -- Large Wooden Shield
	[1201]="473:4:1:1:Shield::1:0:1249,2046,3613,4240,5106,16762,17930:0:0", -- Dull Heater Shield
	[1202]="1839:4:1:1:Shield::1:0:3319,4187,4559,4560,5107,8360,16693,16762,43955,43957:0:0", -- Wall Shield
	[1203]="0:4:3:1:Shield::1:0::2:0", -- Aegis of Stormwind
	[1204]="0:4:4:1:Shield::1:0::2:0", -- The Green Tower
	[1205]="500:0:1:20:FoodDrink::5:0:227,258,274,295,465,491,791,955,982,1149,1156,1237,1247,1285,1327,1328,1448,1452,1464,1697,2084,2303,2388,2401,2803,2808,2820,2832,2908,3086,3298,3313,3350,3411,3498,3546,3625,3708,3881,3882,3883,3884,3934,3937,3959,3961,3962,4082,4167,4169,4170,4181,4190,4241,4266,4554,4555,4571,4782,4879,4893,4896,4981,5101,5111,5112,5134,5140,5611,5620,5688,5814,5871,6091,6272,6727,6734,6735,6736,6738,6739,6740,6741,6746,6747,6790,6791,6807,6928,6929,6930,7485,7731,7733,7737,7744,7941,7942,7943,8143,8150,8152,8362,8931,9356,9501,11038,11103,11106,11118,11187,11287,11555,12019,12021,12026,12027,12036,12196,12246,12959,12960,14371,14624,14731,14963,14964,15124,15125,15174,15397,15433,16191,16256,16443,16542,16553,16618,16732,16739,17489,17553,17630,17656,18811,19182,19617,21145,23573,23995,24208,24834,24934,25012,25052,25089,29291,33209,36378,38847,39031,40467,40589,40815,40826,40898,40914,40968,41053,41128,41275,41286,41490,41491,41674,41676,41891,41892,42709,43034,43384,43424,43606,43624,43633,43637,43699,43748,43771,43899,43945,43946,43953,43972,44001,44006,44019,44114,44177,44183,44190,44196,44219,44235,44236,44237,44267,44268,44270,44276,44294,44296,44297,44300,44302,44303,44304,44312,44334,44340,44343,44344,44376,44379,44391,44398,44417,44779,44785,45008,45086,45094,45484,45496,45553,45563,45565,45566,46269,46271,46642,46659,46995,47105,47139,47142,47148,47165,47167,47288,47334,47363,47367,47547,47668,47717,47756,47757,47854,47858,47938,47942,48054,48067,48093,48122,48125,48215,48236,48555,48599,48607,48735,49394,49397,49430,49435,49917,49919,50092,50126,51709,53528:0:0", -- Melon Juice
	[1206]="0:3:2:20:GemSimple:164,202,755,165:1:0::0:0", -- Moss Agate
	[1207]="0:2:2:1:OneHandMace::1:0::2:0", -- Murphstar
	[1208]="0:12:1:1:::1:0::4:0", -- Maybell's Love Letter
	[1210]="0:3:2:20:GemSimple:164,202,755:1:0::0:0", -- Shadowgem
	[1211]="0:4:2:1:Leather::1:0::2:0", -- Gnoll War Harness
	[1212]="0:15:0:20:Junk::1:0::0:0", -- Gnoll Spittle
	[1213]="0:4:1:1:Leather::1:0::0:0", -- Gnoll Kindred Bracers
	[1214]="0:2:2:1:OneHandMace::1:0::2:0", -- Gnoll Punisher
	[1215]="0:4:2:1:Leather::1:0::2:0", -- Support Girdle
	[1217]="0:12:1:1:::1:0::0:0", -- Unknown Reward
	[1218]="0:2:2:1:TwoHandMace::1:0::2:0", -- Heavy Gnoll War Club
	[1219]="0:2:2:1:OneHandSword::1:0::2:0", -- Redridge Machete
	[1220]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Lupine Axe
	[1221]="0:12:1:20:::1:0::4:0", -- Underbelly Whelp Scale
	[1251]="0:0:1:20:Bandage::1:0::0:0", -- Linen Bandage
	[1252]="0:12:1:1:::1:0::4:0", -- Gramma Stonefield's Note
	[1256]="0:12:1:20:::1:0::4:0", -- Crystal Kelp Frond
	[1257]="0:12:1:1:::1:0::4:0", -- Invisibility Liquor
	[1260]="0:12:1:1:::1:0::4:0", -- Tharil'zun's Head
	[1261]="0:12:1:20:::1:0::4:0", -- Midnight Orb
	[1262]="0:0:1:1:Consumable::1:0::3:0", -- Keg of Thunderbrew Lager
	[1263]="0:2:4:1:TwoHandAxe::1:0::2:0", -- Brain Hacker
	[1264]="0:2:2:1:TwoHandMace::1:0::3:0", -- Headbasher
	[1265]="0:2:3:1:OneHandSword::1:0::2:0", -- Scorpion Sting
	[1270]="0:4:2:1:Cloak::1:0::3:0", -- Finely Woven Cloak
	[1273]="0:4:2:1:Mail::1:0::3:0", -- Forest Chain
	[1274]="0:12:0:20:::1:0::0:0", -- Hops
	[1275]="0:4:2:1:Mail::1:0::3:0", -- Deputy Chain Coat
	[1276]="0:4:2:1:Shield::1:0::3:0", -- Fire Hardened Buckler
	[1280]="0:4:2:1:Leather::1:0::2:0", -- Cloaked Hood
	[1282]="0:4:2:1:Mail::1:0::3:0", -- Sparkmetal Coif
	[1283]="0:12:1:1:::1:0::4:0", -- Verner's Note
	[1284]="0:12:1:1:::1:0::4:0", -- Crate of Horseshoes
	[1287]="0:2:2:1:Dagger::1:0::2:0", -- Giant Tarantula Fang
	[1288]="0:7:1:5:Other:171,129:1:0::0:0", -- Large Venom Sac
	[1292]="0:2:3:1:OneHandAxe::1:0::3:0", -- Butcher's Cleaver
	[1293]="0:12:1:1:::1:0::4:0", -- The State of Lakeshire
	[1294]="0:12:1:1:::1:0::4:0", -- The General's Response
	[1296]="0:2:2:1:OneHandMace::1:0::2:0", -- Blackrock Mace
	[1297]="0:4:2:1:Cloth::1:0::2:0", -- Robes of the Shadowcaster
	[1299]="0:4:2:1:Cloth::1:0::2:0", -- Lesser Belt of the Spire
	[1300]="0:2:2:1:Stave::1:0::2:0", -- Lesser Staff of the Spire
	[1302]="0:4:2:1:Leather::1:0::3:0", -- Black Whelp Gloves
	[1303]="0:4:2:1:Mail::1:0::3:0", -- Bridgeworker's Gloves
	[1304]="0:4:2:1:Cloth::1:0::3:0", -- Riding Gloves
	[1306]="0:4:2:1:Leather::1:0::3:0", -- Wolfmane Wristguards
	[1307]="0:12:1:1:::1:0::3:0", -- Gold Pickup Schedule
	[1309]="0:12:1:1:::1:0::4:0", -- Oslow's Toolbox
	[1310]="0:4:2:1:Leather::1:0::3:0", -- Smith's Trousers
	[1314]="0:4:2:1:Leather::1:0::2:0", -- Ghoul Fingers
	[1315]="0:4:4:1:Amulet::1:0::2:0", -- Lei of Lilies
	[1317]="0:2:2:1:Stave::1:0::3:0", -- Hardened Root Staff
	[1318]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Night Reaver
	[1319]="0:4:2:1:Ring::1:0::3:0", -- Ring of Iron Will
	[1322]="0:0:1:10:Consumable::1:0::3:0", -- Fishliver Oil
	[1325]="0:12:1:1:::1:0::4:0", -- Daffodil Bouquet
	[1326]="0:0:1:20:FoodDrink::1:0::0:0", -- Sauteed Sunfish
	[1327]="0:12:1:1:::1:0::4:0", -- Wiley's Note
	[1349]="0:12:1:1:::1:0::4:0", -- Abercrombie's Crate
	[1351]="0:4:2:1:Cloth::1:0::2:0", -- Fingerbone Bracers
	[1353]="0:12:1:1:::1:0::4:0", -- Shaw's Report
	[1355]="0:4:2:1:Cloak::1:0::2:0", -- Buckskin Cape
	[1357]="0:12:1:1:::1:0::0:0", -- Captain Sanders' Treasure Map
	[1358]="0:12:1:1:::1:0::4:0", -- A Clue to Sanders' Treasure
	[1359]="0:4:1:1:Leather::1:0::3:0", -- Lion-Stamped Gloves
	[1360]="0:4:2:1:Mail::1:0::3:0", -- Stormwind Chain Gloves
	[1361]="0:12:1:1:::1:0::4:0", -- Another Clue to Sanders' Treasure
	[1362]="0:12:1:1:::1:0::4:0", -- Final Clue to Sanders' Treasure
	[1364]="0:4:0:1:Leather::1:0::0:0", -- Ragged Leather Vest
	[1366]="0:4:0:1:Leather::1:0::0:0", -- Ragged Leather Pants
	[1367]="0:4:0:1:Leather::1:0::0:0", -- Ragged Leather Boots
	[1368]="0:4:0:1:Leather::1:0::0:0", -- Ragged Leather Gloves
	[1369]="0:4:0:1:Leather::1:0::0:0", -- Ragged Leather Belt
	[1370]="0:4:0:1:Leather::1:0::0:0", -- Ragged Leather Bracers
	[1372]="0:4:0:1:Cloak::1:0::0:0", -- Ragged Cloak
	[1374]="0:4:0:1:Cloth::1:0::0:0", -- Frayed Shoes
	[1376]="0:4:0:1:Cloak::1:0::0:0", -- Frayed Cloak
	[1377]="0:4:0:1:Cloth::1:0::0:0", -- Frayed Gloves
	[1378]="0:4:0:1:Cloth::1:0::0:0", -- Frayed Pants
	[1380]="0:4:0:1:Cloth::1:0::0:0", -- Frayed Robe
	[1381]="0:12:1:1:::1:0::4:0", -- A Mysterious Message
	[1382]="0:2:1:1:OneHandMace::1:0::3:0", -- Rock Mace
	[1383]="0:2:1:1:OneHandAxe::1:0::3:0", -- Stone Tomahawk
	[1384]="0:2:1:1:OneHandSword::1:0::0:0", -- Dull Blade
	[1386]="0:2:1:1:TwoHandAxe::1:0::3:0", -- Thistlewood Axe
	[1387]="0:2:2:1:TwoHandSword::1:0::2:0", -- Ghoulfang
	[1388]="0:2:1:1:Stave::1:0::0:0", -- Crooked Staff
	[1389]="0:2:1:1:OneHandMace::1:0::0:0", -- Kobold Mining Mallet
	[1391]="0:2:2:1:Stave::1:0::2:0", -- Riverpaw Mystic Staff
	[1394]="0:2:2:1:OneHandMace::1:0::2:0", -- Driftwood Club
	[1395]="7:4:1:1:Cloth::1:0:18672:0:0", -- Apprentice's Pants
	[1396]="7:4:1:1:Cloth::1:0:18672:0:0", -- Acolyte's Pants
	[1399]="0:0:1:20:Other::1:0::0:0", -- Magic Candle
	[1401]="0:0:1:20:FoodDrink::1:0::0:0", -- Green Tea Leaf
	[1404]="0:4:2:1:Trinket::1:0::3:0", -- Tidal Charm
	[1405]="0:2:2:1:Stave::1:0::2:0", -- Foamspittle Staff
	[1406]="0:2:2:1:Polearm::1:0::2:0", -- Pearl-Encrusted Spear
	[1407]="0:12:1:1:::1:0::4:0", -- Solomon's Plea to Westfall
	[1408]="0:12:1:1:::1:0::4:0", -- Stoutmantle's Response to Solomon
	[1409]="0:12:1:1:::1:0::4:0", -- Solomon's Plea to Darkshire
	[1410]="0:12:1:1:::1:0::4:0", -- Ebonlocke's Response to Solomon
	[1411]="0:2:0:1:Stave::1:0::0:0", -- Withered Staff
	[1412]="0:2:0:1:TwoHandSword::1:0::0:0", -- Crude Bastard Sword
	[1413]="0:2:0:1:OneHandSword::1:0::0:0", -- Feeble Sword
	[1414]="0:2:0:1:TwoHandMace::1:0::0:0", -- Cracked Sledge
	[1415]="0:2:0:1:OneHandMace::1:0::0:0", -- Carpenter's Mallet
	[1416]="0:2:0:1:OneHandAxe::1:0::0:0", -- Rusty Hatchet
	[1417]="0:2:0:1:TwoHandAxe::1:0::0:0", -- Beaten Battle Axe
	[1418]="0:4:0:1:Leather::1:0::0:0", -- Worn Leather Belt
	[1419]="0:4:0:1:Leather::1:0::0:0", -- Worn Leather Boots
	[1420]="0:4:0:1:Leather::1:0::0:0", -- Worn Leather Bracers
	[1421]="0:4:0:1:Cloak::1:0::0:0", -- Worn Hide Cloak
	[1422]="0:4:0:1:Leather::1:0::0:0", -- Worn Leather Gloves
	[1423]="0:4:0:1:Leather::1:0::0:0", -- Worn Leather Pants
	[1425]="0:4:0:1:Leather::1:0::0:0", -- Worn Leather Vest
	[1427]="0:4:0:1:Cloth::1:0::0:0", -- Patchwork Shoes
	[1429]="0:4:0:1:Cloak::1:0::0:0", -- Patchwork Cloak
	[1430]="0:4:0:1:Cloth::1:0::0:0", -- Patchwork Gloves
	[1431]="0:4:0:1:Cloth::1:0::0:0", -- Patchwork Pants
	[1433]="0:4:0:1:Cloth::1:0::0:0", -- Patchwork Armor
	[1434]="0:0:1:20:Consumable::1:0::3:0", -- Glowing Wax Stick
	[1436]="0:4:2:1:Leather::1:0::3:0", -- Frontier Britches
	[1438]="0:4:1:1:Shield::1:0::0:0", -- Warrior's Shield
	[1440]="0:2:2:1:OneHandMace::1:0::2:0", -- Gnoll Skull Basher
	[1443]="0:4:4:1:Amulet::1:0::2:0", -- Jeweled Amulet of Cainwyn
	[1445]="0:4:1:1:Mail::1:0::0:0", -- Blackrock Pauldrons
	[1446]="0:4:2:1:Mail::1:0::2:0", -- Blackrock Boots
	[1447]="0:4:4:1:Ring::1:0::2:0", -- Ring of Saviors
	[1448]="0:4:2:1:Mail::1:0::2:0", -- Blackrock Gauntlets
	[1449]="0:4:2:1:Ring::1:0::3:0", -- Minor Channeling Ring
	[1451]="0:12:1:1:::1:0::4:0", -- Bottle of Zombie Juice
	[1453]="0:12:1:1:::1:0::4:0", -- Spectral Comb
	[1454]="0:2:3:1:OneHandAxe::1:0::2:0", -- Axe of the Enforcer
	[1455]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Blackrock Champion's Axe
	[1457]="0:2:2:1:OneHandMace::1:0::2:0", -- Shadowhide Mace
	[1458]="0:2:2:1:TwoHandMace::1:0::2:0", -- Shadowhide Maul
	[1459]="0:2:2:1:OneHandAxe::1:0::2:0", -- Shadowhide Scalper
	[1460]="0:2:2:1:TwoHandSword::1:0::2:0", -- Shadowhide Two-Handed Sword
	[1461]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Slayer's Battle Axe
	[1462]="0:4:2:1:Ring::1:0::2:0", -- Ring of the Shadow
	[1464]="0:15:0:20:Junk::1:0::0:0", -- Buzzard Talon
	[1465]="0:2:2:1:Dagger::1:0::2:0", -- Tigerbane
	[1467]="0:12:1:20:::1:0::4:0", -- Spotted Sunfish
	[1468]="0:7:1:20:Meat:185:1:0::0:0", -- Murloc Fin
	[1469]="0:2:2:1:OneHandSword::1:0::2:0", -- Scimitar of Atun
	[1470]="0:1:1:1:Bag::1:0::0:0", -- Murloc Skin Bag
	[1473]="0:2:2:1:Stave::1:0::2:0", -- Riverside Staff
	[1475]="0:7:1:5:Other:129:1:0::0:0", -- Small Venom Sac
	[1476]="0:15:0:20:Junk::1:0::0:0", -- Snapped Spider Limb
	[1477]="350:0:1:20:Scroll::1:1:4581,12246,14847:0:0", -- Scroll of Agility II
	[1478]="250:0:1:20:Scroll::1:1:1316,2805,4581:0:0", -- Scroll of Protection II
	[1479]="0:4:1:1:Cloth::1:0::3:0", -- Salma's Oven Mitts
	[1480]="0:2:2:1:OneHandMace::1:0::3:0", -- Fist of the People's Militia
	[1481]="0:2:3:1:OneHandAxe::1:0::2:0", -- Grimclaw
	[1482]="0:2:3:1:OneHandSword::1:0::2:0", -- Shadowfang
	[1483]="0:2:3:1:OneHandMace::1:0::2:0", -- Face Smasher
	[1484]="0:2:3:1:Stave::1:0::2:0", -- Witching Stave
	[1485]="0:2:0:1:Polearm::1:0::0:0", -- Pitchfork
	[1486]="0:4:3:1:Cloth::1:0::2:0", -- Tree Bark Jacket
	[1487]="0:0:1:20:FoodDrink::1:0::0:0", -- Conjured Pumpernickel
	[1488]="0:4:3:1:Mail::1:0::2:0", -- Avenger's Armor
	[1489]="0:4:3:1:Leather::1:0::2:0", -- Gloomshroud Armor
	[1490]="0:4:2:1:Trinket::1:0::3:0", -- Guardian Talisman
	[1491]="0:4:3:1:Ring::1:0::2:0", -- Ring of Precision
	[1493]="0:2:3:1:OneHandSword::1:0::2:0", -- Heavy Marauder Scimitar
	[1495]="0:4:0:1:Cloth::1:0::0:0", -- Calico Shoes
	[1497]="0:4:0:1:Cloak::1:0::0:0", -- Calico Cloak
	[1498]="0:4:0:1:Cloth::1:0::0:0", -- Calico Gloves
	[1499]="0:4:0:1:Cloth::1:0::0:0", -- Calico Pants
	[1501]="0:4:0:1:Cloth::1:0::0:0", -- Calico Tunic
	[1502]="0:4:0:1:Leather::1:0::0:0", -- Warped Leather Belt
	[1503]="0:4:0:1:Leather::1:0::0:0", -- Warped Leather Boots
	[1504]="0:4:0:1:Leather::1:0::0:0", -- Warped Leather Bracers
	[1505]="0:4:0:1:Cloak::1:0::0:0", -- Warped Cloak
	[1506]="0:4:0:1:Leather::1:0::0:0", -- Warped Leather Gloves
	[1507]="0:4:0:1:Leather::1:0::0:0", -- Warped Leather Pants
	[1509]="0:4:0:1:Leather::1:0::0:0", -- Warped Leather Vest
	[1510]="0:2:0:1:OneHandMace::1:0::0:0", -- Heavy Hammer
	[1511]="0:2:0:1:OneHandSword::1:0::0:0", -- Commoner's Sword
	[1512]="0:2:0:1:TwoHandAxe::1:0::0:0", -- Crude Battle Axe
	[1513]="0:2:0:1:TwoHandSword::1:0::0:0", -- Old Greatsword
	[1514]="0:2:0:1:TwoHandMace::1:0::0:0", -- Rusty Warhammer
	[1515]="0:2:0:1:Stave::1:0::0:0", -- Rough Wooden Staff
	[1516]="0:2:0:1:OneHandAxe::1:0::0:0", -- Worn Hatchet
	[1518]="0:12:1:1:::1:0::4:0", -- Ghost Hair Comb
	[1519]="0:12:1:20:::1:0::4:0", -- Bloodscalp Ear
	[1520]="0:15:0:20:Junk::1:0::0:0", -- Troll Sweat
	[1521]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Lumbering Ogre Axe
	[1522]="0:2:2:1:Polearm::1:0::2:0", -- Headhunting Spear
	[1523]="0:2:2:1:TwoHandMace::1:0::2:0", -- Huge Stone Club
	[1524]="0:12:1:20:::1:0::4:0", -- Skullsplitter Tusk
	[1528]="0:12:1:20:::1:0::4:0", -- Handful of Oats
	[1529]="0:3:2:20:GemSimple:164,202,755,165,197:1:0::0:0", -- Jade
	[1532]="0:12:1:30:::1:0::4:0", -- Shrunken Head
	[1537]="0:1:1:1:Bag::1:0::3:0", -- Old Blanchy's Feed Pouch
	[1539]="0:2:2:1:Stave::1:0::2:0", -- Gnarled Hermit's Staff
	[1547]="0:4:2:1:Shield::1:0::3:0", -- Shield of the Faith
	[1557]="0:4:2:1:Shield::1:0::3:0", -- Buckler of the Seas
	[1560]="0:4:2:1:Cloth::1:0::2:0", -- Bluegill Sandals
	[1561]="0:4:2:1:Cloth::1:0::3:0", -- Harvester's Robe
	[1566]="0:2:2:1:TwoHandSword::1:0::3:0", -- Edge of the People's Militia
	[1596]="0:12:1:1:::1:0::4:0", -- Ghost Hair Thread
	[1598]="0:12:1:20:::1:0::4:0", -- Rot Blossom
	[1602]="0:2:3:1:OneHandAxe::1:0::2:0", -- Sickle Axe
	[1604]="0:2:2:1:TwoHandSword::1:0::2:0", -- Chromatic Sword
	[1607]="0:2:3:1:Stave::1:0::2:0", -- Soulkeeper
	[1608]="0:2:2:1:OneHandMace::1:0::2:0", -- Skullcrusher Mace
	[1613]="0:2:2:1:Stave::1:0::2:0", -- Spiritchaser Staff
	[1624]="0:4:2:1:Mail::1:0::2:0", -- Skullsplitter Helm
	[1625]="0:2:2:1:TwoHandSword::1:0::2:0", -- Exquisite Flamberge
	[1630]="0:15:0:20:Junk::1:0::0:0", -- Broken Electro-Lantern
	[1637]="0:12:1:1:::1:0::4:0", -- Letter to Ello
	[1639]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Grinning Axe
	[1640]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Monstrous War Axe
	[1645]="2000:0:1:20:FoodDrink::5:0:258,274,295,465,955,982,1149,1156,1237,1247,1285,1327,1328,1464,1697,2084,2303,2388,2401,2803,2808,2820,2832,2908,3086,3298,3313,3350,3411,3546,3625,3708,3881,3882,3883,3884,3934,3937,3959,3961,4167,4169,4170,4181,4190,4241,4266,4554,4555,4571,4782,4879,4893,4896,4981,5101,5111,5112,5134,5140,5611,5620,5688,5814,5871,6091,6272,6727,6734,6735,6736,6738,6739,6740,6741,6746,6747,6790,6791,6807,6928,6929,6930,7485,7731,7733,7737,7744,7941,7942,7943,8143,8150,8152,8362,8931,9356,9501,11038,11103,11106,11118,11187,11287,11555,12019,12021,12026,12027,12036,12196,12246,12959,12960,14371,14624,14731,14963,14964,15124,15125,15174,15397,15433,16191,16256,16443,16542,16553,16618,16732,16739,17553,17630,17656,19182,19617,21145,23573,23995,24208,24834,24934,25012,25052,25089,29291,33209,36378,38847,39031,40467,40589,40815,40826,40898,40914,40968,41053,41275,41286,41490,41491,41674,41676,41891,41892,42709,43034,43384,43606,43624,43633,43637,43699,43748,43771,43899,43945,43946,43953,43972,44006,44019,44177,44183,44190,44196,44219,44235,44236,44237,44267,44268,44270,44276,44302,44312,44334,44340,44343,44344,44376,44379,44391,44398,44417,44779,44785,45008,45086,45094,45417,45553,45563,45565,45566,46269,46271,46642,46659,46995,47105,47139,47142,47148,47165,47167,47288,47334,47363,47367,47547,47668,47717,47756,47757,47854,47858,47938,47942,48054,48067,48093,48122,48125,48215,48236,48555,48599,48607,48735,49394,49430,49917,49919,50092,50126,53528:0:0", -- Moonberry Juice
	[1652]="0:1:1:1:Bag::1:0::0:0", -- Sturdy Lunchbox
	[1656]="0:12:1:1:::1:0::4:0", -- Translated Letter
	[1659]="0:4:2:1:Cloth::1:0::2:0", -- Engineering Gloves
	[1664]="0:2:2:1:Stave::1:0::2:0", -- Spellforce Rod
	[1677]="0:4:2:1:Mail::1:0::2:0", -- Drake-Scale Vest
	[1678]="0:4:3:1:Mail::1:0::2:0", -- Black Ogre Kickers
	[1679]="0:2:2:1:TwoHandMace::1:0::2:0", -- Korg Bat
	[1680]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Headchopper
	[1685]="0:1:1:1:Bag::1:0::0:0", -- Troll-Hide Bag
	[1686]="0:15:0:20:Junk::1:0::0:0", -- Bristly Whisker
	[1687]="0:15:0:20:Junk::1:0::0:0", -- Retractable Claw
	[1688]="0:15:0:20:Junk::1:0::0:0", -- Long Soft Tail
	[1696]="0:15:0:20:Junk::1:0::0:0", -- Curved Raptor Talon
	[1697]="0:15:0:20:Junk::1:0::0:0", -- Keen Raptor Tooth
	[1701]="0:15:0:20:Junk::1:0::0:0", -- Curved Basilisk Claw
	[1702]="0:15:0:20:Junk::1:0::0:0", -- Intact Basilisk Spine
	[1703]="0:0:1:10:Other::1:0::0:0", -- Crystal Basilisk Spine
	[1705]="0:3:2:20:GemSimple:164,202,755:1:0::0:0", -- Lesser Moonstone
	[1706]="0:15:0:20:Junk::1:0::0:0", -- Azuredeep Shards
	[1707]="1000:0:1:20:FoodDrink::5:0:295,465,483,1237,3298,3546,4782,4891,4894,4981,5620,6746,6790,6930,9501,11106,16553,17630,18929,23521,23604,24934,38714,40815,43972,44268,44417,44785,46269,46995,48125,49917:0:0", -- Stormwind Brie
	[1708]="1000:0:1:20:FoodDrink::5:0:258,274,295,465,955,982,1149,1156,1237,1247,1285,1327,1328,1464,1697,2084,2303,2388,2401,2803,2808,2820,2832,2908,3086,3298,3313,3350,3411,3546,3625,3708,3881,3882,3883,3884,3934,3937,3959,3961,4167,4169,4170,4181,4190,4241,4266,4554,4555,4571,4782,4879,4893,4896,4981,5101,5111,5112,5134,5140,5611,5620,5688,5814,5871,6091,6272,6727,6734,6735,6736,6738,6739,6740,6741,6746,6747,6790,6791,6807,6928,6929,6930,7485,7731,7733,7737,7744,7941,7942,7943,8143,8150,8152,8362,8931,9356,9501,11038,11103,11106,11118,11187,11287,11555,12019,12021,12026,12027,12036,12196,12246,12959,12960,14371,14624,14731,14963,14964,15124,15125,15174,15397,15433,16191,16256,16443,16542,16553,16618,16732,16739,17553,17630,17656,19182,19617,21145,23573,23995,24208,24834,24934,25012,25052,25089,29291,33209,36378,38847,39031,40467,40589,40815,40826,40898,40914,40968,41053,41275,41286,41490,41491,41674,41676,41891,41892,42709,43034,43384,43606,43624,43633,43637,43699,43748,43771,43899,43945,43946,43953,43972,44006,44019,44177,44183,44190,44196,44219,44235,44236,44237,44267,44268,44270,44276,44302,44312,44334,44340,44343,44344,44376,44379,44391,44398,44417,44779,44785,45008,45086,45094,45417,45553,45563,45565,45566,46269,46271,46642,46659,46995,47105,47139,47142,47148,47165,47167,47288,47334,47363,47367,47547,47668,47717,47756,47757,47854,47858,47938,47942,48054,48067,48093,48122,48125,48215,48236,48555,48599,48607,48735,49394,49430,49917,49919,50092,50126,53528:0:0", -- Sweet Nectar
	[1710]="500:0:1:20:Potion::1:1:2480,2812,2848,4899,12245:0:0", -- Greater Healing Potion
	[1711]="300:0:1:20:Scroll::1:1:1316,2805,4581,12246,14847:0:0", -- Scroll of Stamina II
	[1712]="250:0:1:20:Scroll::1:1:1316,2805,4581:0:0", -- Scroll of Spirit II
	[1713]="0:4:3:1:Trinket::1:0::2:0", -- Ankh of Life
	[1714]="0:4:3:1:Amulet::1:0::2:0", -- Necklace of Calisea
	[1715]="0:4:3:1:Mail::1:0::2:0", -- Polished Jazeraint Armor
	[1716]="0:4:3:1:Cloth::1:0::2:0", -- Robe of the Magi
	[1717]="0:4:3:1:Mail::1:0::2:0", -- Double Link Tunic
	[1718]="0:4:3:1:Leather::1:0::2:0", -- Basilisk Hide Pants
	[1720]="0:2:3:1:Stave::1:0::2:0", -- Tanglewood Staff
	[1721]="0:2:3:1:OneHandMace::1:0::2:0", -- Viking Warhammer
	[1722]="0:2:3:1:TwoHandMace::1:0::2:0", -- Thornstone Sledgehammer
	[1725]="0:1:1:1:Bag::1:0::0:0", -- Large Knapsack
	[1726]="0:2:3:1:Polearm::1:0::2:0", -- Poison-Tipped Bone Spear
	[1727]="0:2:3:1:OneHandSword::1:0::2:0", -- Sword of Decay
	[1728]="0:2:4:1:OneHandSword::1:0::2:0", -- Teebu's Blazing Longsword
	[1729]="0:1:1:1:Bag::1:0::3:0", -- Gunnysack of the Night Watch
	[1730]="0:4:0:1:Mail::1:0::0:0", -- Worn Mail Belt
	[1731]="0:4:0:1:Mail::1:0::0:0", -- Worn Mail Boots
	[1732]="0:4:0:1:Mail::1:0::0:0", -- Worn Mail Bracers
	[1733]="0:4:0:1:Cloak::1:0::0:0", -- Worn Cloak
	[1734]="0:4:0:1:Mail::1:0::0:0", -- Worn Mail Gloves
	[1735]="0:4:0:1:Mail::1:0::0:0", -- Worn Mail Pants
	[1737]="0:4:0:1:Mail::1:0::0:0", -- Worn Mail Vest
	[1738]="0:4:0:1:Mail::1:0::0:0", -- Laced Mail Belt
	[1739]="0:4:0:1:Mail::1:0::0:0", -- Laced Mail Boots
	[1740]="0:4:0:1:Mail::1:0::0:0", -- Laced Mail Bracers
	[1741]="0:4:0:1:Cloak::1:0::0:0", -- Laced Cloak
	[1742]="0:4:0:1:Mail::1:0::0:0", -- Laced Mail Gloves
	[1743]="0:4:0:1:Mail::1:0::0:0", -- Laced Mail Pants
	[1744]="0:4:0:1:Mail::1:0::0:0", -- Laced Mail Shoulderpads
	[1745]="0:4:0:1:Mail::1:0::0:0", -- Laced Mail Vest
	[1746]="0:4:0:1:Mail::1:0::0:0", -- Linked Chain Belt
	[1747]="0:4:0:1:Mail::1:0::0:0", -- Linked Chain Boots
	[1748]="0:4:0:1:Mail::1:0::0:0", -- Linked Chain Bracers
	[1749]="0:4:0:1:Cloak::1:0::0:0", -- Linked Chain Cloak
	[1750]="0:4:0:1:Mail::1:0::0:0", -- Linked Chain Gloves
	[1751]="0:4:0:1:Mail::1:0::0:0", -- Linked Chain Pants
	[1752]="0:4:0:1:Mail::1:0::0:0", -- Linked Chain Shoulderpads
	[1753]="0:4:0:1:Mail::1:0::0:0", -- Linked Chain Vest
	[1754]="0:4:0:1:Mail::1:0::0:0", -- Reinforced Chain Belt
	[1755]="0:4:0:1:Mail::1:0::0:0", -- Reinforced Chain Boots
	[1756]="0:4:0:1:Mail::1:0::0:0", -- Reinforced Chain Bracers
	[1757]="0:4:0:1:Cloak::1:0::0:0", -- Reinforced Chain Cloak
	[1758]="0:4:0:1:Mail::1:0::0:0", -- Reinforced Chain Gloves
	[1759]="0:4:0:1:Mail::1:0::0:0", -- Reinforced Chain Pants
	[1760]="0:4:0:1:Mail::1:0::0:0", -- Reinforced Chain Shoulderpads
	[1761]="0:4:0:1:Mail::1:0::0:0", -- Reinforced Chain Vest
	[1764]="0:4:0:1:Cloth::1:0::0:0", -- Canvas Shoes
	[1766]="0:4:0:1:Cloak::1:0::0:0", -- Canvas Cloak
	[1767]="0:4:0:1:Cloth::1:0::0:0", -- Canvas Gloves
	[1768]="0:4:0:1:Cloth::1:0::0:0", -- Canvas Pants
	[1769]="0:4:0:1:Cloth::1:0::0:0", -- Canvas Shoulderpads
	[1770]="0:4:0:1:Cloth::1:0::0:0", -- Canvas Vest
	[1772]="0:4:0:1:Cloth::1:0::0:0", -- Brocade Shoes
	[1774]="0:4:0:1:Cloak::1:0::0:0", -- Brocade Cloak
	[1775]="0:4:0:1:Cloth::1:0::0:0", -- Brocade Gloves
	[1776]="0:4:0:1:Cloth::1:0::0:0", -- Brocade Pants
	[1777]="0:4:0:1:Cloth::1:0::0:0", -- Brocade Shoulderpads
	[1778]="0:4:0:1:Cloth::1:0::0:0", -- Brocade Vest
	[1780]="0:4:0:1:Cloth::1:0::0:0", -- Cross-Stitched Sandals
	[1782]="0:4:0:1:Cloak::1:0::0:0", -- Cross-Stitched Cloak
	[1783]="0:4:0:1:Cloth::1:0::0:0", -- Cross-Stitched Gloves
	[1784]="0:4:0:1:Cloth::1:0::0:0", -- Cross-Stitched Pants
	[1785]="0:4:0:1:Cloth::1:0::0:0", -- Cross-Stitched Shoulderpads
	[1786]="0:4:0:1:Cloth::1:0::0:0", -- Cross-Stitched Vest
	[1787]="0:4:0:1:Leather::1:0::0:0", -- Patched Leather Belt
	[1788]="0:4:0:1:Leather::1:0::0:0", -- Patched Leather Boots
	[1789]="0:4:0:1:Leather::1:0::0:0", -- Patched Leather Bracers
	[1790]="0:4:0:1:Cloak::1:0::0:0", -- Patched Cloak
	[1791]="0:4:0:1:Leather::1:0::0:0", -- Patched Leather Gloves
	[1792]="0:4:0:1:Leather::1:0::0:0", -- Patched Leather Pants
	[1793]="0:4:0:1:Leather::1:0::0:0", -- Patched Leather Shoulderpads
	[1794]="0:4:0:1:Leather::1:0::0:0", -- Patched Leather Jerkin
	[1795]="0:4:0:1:Leather::1:0::0:0", -- Rawhide Belt
	[1796]="0:4:0:1:Leather::1:0::0:0", -- Rawhide Boots
	[1797]="0:4:0:1:Leather::1:0::0:0", -- Rawhide Bracers
	[1798]="0:4:0:1:Cloak::1:0::0:0", -- Rawhide Cloak
	[1799]="0:4:0:1:Leather::1:0::0:0", -- Rawhide Gloves
	[1800]="0:4:0:1:Leather::1:0::0:0", -- Rawhide Pants
	[1801]="0:4:0:1:Leather::1:0::0:0", -- Rawhide Shoulderpads
	[1802]="0:4:0:1:Leather::1:0::0:0", -- Rawhide Tunic
	[1803]="0:4:0:1:Leather::1:0::0:0", -- Tough Leather Belt
	[1804]="0:4:0:1:Leather::1:0::0:0", -- Tough Leather Boots
	[1805]="0:4:0:1:Leather::1:0::0:0", -- Tough Leather Bracers
	[1806]="0:4:0:1:Cloak::1:0::0:0", -- Tough Cloak
	[1807]="0:4:0:1:Leather::1:0::0:0", -- Tough Leather Gloves
	[1808]="0:4:0:1:Leather::1:0::0:0", -- Tough Leather Pants
	[1809]="0:4:0:1:Leather::1:0::0:0", -- Tough Leather Shoulderpads
	[1810]="0:4:0:1:Leather::1:0::0:0", -- Tough Leather Armor
	[1811]="0:2:0:1:TwoHandSword::1:0::0:0", -- Blunt Claymore
	[1812]="0:2:0:1:TwoHandAxe::1:0::0:0", -- Short-Handled Battle Axe
	[1813]="0:2:0:1:Stave::1:0::0:0", -- Chipped Quarterstaff
	[1814]="0:2:0:1:TwoHandMace::1:0::0:0", -- Battered Mallet
	[1815]="0:2:0:1:OneHandMace::1:0::0:0", -- Ornamental Mace
	[1816]="0:2:0:1:OneHandAxe::1:0::0:0", -- Unbalanced Axe
	[1817]="0:2:0:1:OneHandSword::1:0::0:0", -- Stock Shortsword
	[1818]="0:2:0:1:TwoHandSword::1:0::0:0", -- Standard Claymore
	[1819]="0:2:0:1:OneHandAxe::1:0::0:0", -- Gouging Pick
	[1820]="0:2:0:1:TwoHandMace::1:0::0:0", -- Wooden Maul
	[1821]="0:2:0:1:OneHandSword::1:0::0:0", -- Warped Blade
	[1822]="0:2:0:1:Stave::1:0::0:0", -- Cedar Walking Stick
	[1823]="0:2:0:1:OneHandMace::1:0::0:0", -- Bludgeoning Cudgel
	[1824]="0:2:0:1:TwoHandAxe::1:0::0:0", -- Shiny War Axe
	[1825]="0:2:0:1:OneHandMace::1:0::0:0", -- Bulky Bludgeon
	[1826]="0:2:0:1:TwoHandMace::1:0::0:0", -- Rock Maul
	[1827]="0:2:0:1:OneHandAxe::1:0::0:0", -- Meat Cleaver
	[1828]="0:2:0:1:TwoHandAxe::1:0::0:0", -- Stone War Axe
	[1829]="0:2:0:1:OneHandSword::1:0::0:0", -- Short Cutlass
	[1830]="0:2:0:1:TwoHandSword::1:0::0:0", -- Long Bastard Sword
	[1831]="0:2:0:1:Stave::1:0::0:0", -- Oaken War Staff
	[1832]="0:4:2:1:Cloth::1:0::3:0", -- Lucky Trousers
	[1835]="31:4:1:1:Leather::1:0:2113,3074,3160,4558,39033:0:0", -- Dirty Leather Belt
	[1836]="31:4:1:1:Leather::1:0:2113,3074,3160,4558,39033:0:0", -- Dirty Leather Bracers
	[1839]="185:4:1:1:Leather::1:0:74,896,1238,1295,3162,3612,3953,4164,4236,5820,16747,17929:0:0", -- Rough Leather Belt
	[1840]="185:4:1:1:Leather::1:0:74,896,1238,1295,3162,3612,3953,4164,4236,5820,16747,17929:0:0", -- Rough Leather Bracers
	[1843]="726:4:1:1:Leather::1:0:896,954,1295,3093,3321,3483,3552,3953,4164,4236,4558,5108,5820,8359,10380,16691,16747,43439,43951:0:0", -- Tanned Leather Belt
	[1844]="728:4:1:1:Leather::1:0:896,954,1295,3093,3321,3483,3552,3953,4164,4236,4558,5108,5820,8359,10380,16691,16747,43439,43951,45417:0:0", -- Tanned Leather Bracers
	[1845]="877:4:1:1:Mail::1:0:167,1294,1362,3319,3483,3553,4164,4177,4187,4560,5107,5812,5819,8360,16625,16750,43955,43957:0:0", -- Chainmail Belt
	[1846]="881:4:1:1:Mail::1:0:167,1294,1362,3319,3483,3553,4164,4177,4187,4560,5107,5812,5819,8360,16625,16750,43955,43957:0:0", -- Chainmail Bracers
	[1849]="1388:4:1:1:Leather::1:0:1295,3093,3321,3492,3536,3953,4236,5820,8359,16691,16747,33381,43568,44286:0:0", -- Cured Leather Belt
	[1850]="1393:4:1:1:Leather::1:0:1295,3093,3321,3492,3536,3953,4236,5820,8359,16691,16747,33381,43568,44286:0:0", -- Cured Leather Bracers
	[1852]="1684:4:1:1:Mail::1:0:956,1294,1341,3319,3493,3682,4177,5125,5812,5819,8360,16625,16750,33381:0:0", -- Scalemail Bracers
	[1853]="1690:4:1:1:Mail::1:0:956,1294,1341,3319,3493,3682,4177,5125,5812,5819,8360,16625,16750,33381:0:0", -- Scalemail Belt
	[1875]="0:12:1:1:::1:0::4:0", -- Thistlenettle's Badge
	[1893]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Miner's Revenge
	[1894]="0:12:1:20:::1:0::4:0", -- Miners' Union Card
	[1913]="0:2:1:1:OneHandMace::1:0::0:0", -- Studded Blackjack
	[1917]="0:2:2:1:Dagger::1:0::2:0", -- Jeweled Dagger
	[1922]="0:12:1:1:::1:0::4:0", -- Supplies for Sven
	[1925]="0:2:3:1:OneHandSword::1:0::2:0", -- Defias Rapier
	[1926]="0:2:3:1:OneHandMace::1:0::2:0", -- Weighted Sap
	[1927]="0:2:3:1:OneHandAxe::1:0::2:0", -- Deadmines Cleaver
	[1928]="0:2:3:1:Stave::1:0::2:0", -- Defias Mage Staff
	[1929]="0:4:3:1:Cloth::1:0::3:0", -- Silk-Threaded Trousers
	[1930]="0:4:3:1:Cloak::1:0::2:0", -- Stonemason Cloak
	[1931]="0:12:1:1:::1:0::4:0", -- Huge Gnoll Claw
	[1933]="0:2:3:1:Stave::1:0::2:0", -- Staff of Conjuring
	[1934]="0:4:3:1:Leather::1:0::3:0", -- Hogger's Trousers
	[1935]="0:2:3:1:Dagger::1:0::2:0", -- Assassin's Blade
	[1936]="0:2:3:1:Dagger::1:0::2:0", -- Goblin Screwdriver
	[1937]="0:2:3:1:OneHandSword::1:0::3:0", -- Buzz Saw
	[1938]="0:2:2:1:OneHandMace::1:0::2:0", -- Block Mallet
	[1939]="675:12:1:1:::1:0:465:4:0", -- Skin of Sweet Rum
	[1941]="815:12:1:1:::1:0:277:4:0", -- Cask of Merlot
	[1942]="1265:12:1:1:::1:0:274:4:0", -- Bottle of Moonshine
	[1943]="0:4:3:1:Mail::1:0::2:0", -- Goblin Mail Leggings
	[1944]="0:4:3:1:Leather::1:0::2:0", -- Metalworking Gloves
	[1945]="0:4:3:1:Leather::1:0::2:0", -- Woodworking Gloves
	[1946]="0:12:1:1:::1:0::4:0", -- Mary's Looking Glass
	[1951]="0:2:3:1:OneHandSword::1:0::2:0", -- Blackwater Cutlass
	[1955]="0:4:2:1:Mail::1:0::2:0", -- Dragonmaw Chain Boots
	[1956]="0:12:1:1:::1:0::4:0", -- Faded Shadowhide Pendant
	[1958]="0:2:3:1:OneHandMace::1:0::2:0", -- Petrified Shinbone
	[1959]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Cold Iron Pick
	[1962]="0:12:1:1:::1:0::3:0", -- Glowing Shadowhide Pendant
	[1965]="0:4:1:1:Leather::1:0::0:0", -- White Wolf Gloves
	[1968]="0:12:1:1:::1:0::4:0", -- Ogre's Monocle
	[1970]="0:0:1:10:Consumable::1:0::3:0", -- Restoring Balm
	[1971]="0:12:1:1:::1:0::4:0", -- Furlbrow's Deed
	[1972]="0:12:1:1:::1:0::3:0", -- Westfall Deed
	[1973]="0:4:3:1:Trinket::1:0::2:0", -- Orb of Deception
	[1974]="0:4:3:1:Cloth::1:0::2:0", -- Mindthrust Bracers
	[1975]="0:2:3:1:TwoHandSword::1:0::2:0", -- Pysan's Old Greatsword
	[1976]="0:2:3:1:TwoHandMace::1:0::2:0", -- Slaghammer
	[1978]="0:4:3:1:Leather::1:0::2:0", -- Wolfclaw Gloves
	[1979]="0:4:4:1:Shield::1:0::2:0", -- Wall of the Dead
	[1980]="0:4:4:1:Ring::1:0::2:0", -- Underworld Band
	[1981]="0:4:4:1:Mail::1:0::2:0", -- Icemail Jerkin
	[1982]="0:2:4:1:TwoHandSword::1:0::2:0", -- Nightblade
	[1986]="0:2:2:1:TwoHandSword::1:0::2:0", -- Gutrender
	[1987]="0:12:1:1:::1:0::4:0", -- Krazek's Fixed Pot
	[1988]="0:4:2:1:Mail::1:0::2:0", -- Chief Brigadier Gauntlets
	[1990]="0:2:2:1:TwoHandMace::1:0::2:0", -- Ballast Maul
	[1991]="0:2:2:1:TwoHandMace::1:0::2:0", -- Goblin Power Shovel
	[1992]="0:4:3:1:OffHandFrill::1:0::2:0", -- Swampchill Fetish
	[1993]="0:4:2:1:Ring::1:0::2:0", -- Ogremind Ring
	[1994]="0:2:2:1:OneHandAxe::1:0::2:0", -- Ebonclaw Reaver
	[1996]="0:4:2:1:Ring::1:0::2:0", -- Voodoo Band
	[1997]="0:4:2:1:Cloth::1:0::2:0", -- Pressed Felt Robe
	[1998]="0:2:2:1:Stave::1:0::2:0", -- Bloodscalp Channeling Staff
	[2000]="0:2:2:1:TwoHandSword::1:0::3:0", -- Archeus
	[2004]="0:12:1:1:::1:0::4:0", -- Grelin Whitebeard's Journal
	[2005]="0:12:1:1:::1:0::4:0", -- The First Troll Legend
	[2006]="0:12:1:1:::1:0::4:0", -- The Second Troll Legend
	[2007]="0:12:1:1:::1:0::4:0", -- The Third Troll Legend
	[2008]="0:12:1:1:::1:0::4:0", -- The Fourth Troll Legend
	[2011]="0:2:3:1:OneHandSword::1:0::2:0", -- Twisted Sabre
	[2013]="0:2:2:1:Stave::1:0::2:0", -- Cryptbone Staff
	[2014]="0:2:2:1:TwoHandSword::1:0::2:0", -- Black Metal Greatsword
	[2015]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Black Metal War Axe
	[2017]="0:4:2:1:Leather::1:0::2:0", -- Glowing Leather Bracers
	[2018]="0:2:2:1:OneHandSword::1:0::2:0", -- Skeletal Longsword
	[2020]="0:2:2:1:Dagger::1:0::2:0", -- Hollowfang Blade
	[2021]="0:4:2:1:Shield::1:0::2:0", -- Green Carapace Shield
	[2024]="6079:2:1:1:TwoHandSword::1:0:225,1287,1289,2997,3021,3331,3361,3491,4171,4203,4231,4557,4569,5103,5120,16714,41622,43948:0:0", -- Espadon
	[2025]="5305:2:1:1:TwoHandAxe::1:0:225,1287,1289,2997,3019,3409,3491,4203,4231,4232,4557,4601,5103,5119,16714,41622,46996,47149,47166:0:0", -- Bearded Axe
	[2026]="6286:2:1:1:TwoHandMace::1:0:225,1287,1289,1348,2997,3020,3360,3491,4203,4231,4233,4557,4602,5103,5121,16765,17412,41622,46996:0:0", -- Rock Hammer
	[2027]="3816:2:1:1:OneHandSword::1:0:225,1287,1289,2997,3021,3331,3361,3491,4171,4203,4231,4557,4569,5103,5120,16714,41622,43948:0:0", -- Scimitar
	[2028]="5065:2:1:1:OneHandMace::1:0:225,1287,1289,1348,2997,3020,3360,3491,4203,4231,4233,4557,4602,5103,5121,16765,17412,41622,46996:0:0", -- Hammer
	[2029]="4420:2:1:1:OneHandAxe::1:0:225,1287,1289,2997,3019,3409,3491,4203,4231,4232,4557,4601,5103,5119,16714,41622,46996,47149,47166:0:0", -- Cleaver
	[2030]="5545:2:1:1:Stave::1:0:225,1287,1289,1348,2997,3020,3360,3409,3491,4203,4231,4233,4557,4602,5103,5121,16765,17412,19238,41622,46996:0:0", -- Gnarled Staff
	[2032]="0:4:2:1:Cloth::1:0::3:0", -- Gallan Cuffs
	[2033]="0:4:2:1:Leather::1:0::3:0", -- Ambassador's Boots
	[2034]="0:4:2:1:Cloth::1:0::2:0", -- Scholarly Robes
	[2035]="0:2:2:1:OneHandSword::1:0::2:0", -- Sword of the Night Sky
	[2036]="0:4:3:1:Leather::1:0::3:0", -- Dusty Mining Gloves
	[2037]="0:4:3:1:Mail::1:0::3:0", -- Tunneler's Boots
	[2039]="0:4:3:1:Ring::1:0::2:0", -- Plains Ring
	[2040]="0:4:3:1:Shield::1:0::2:0", -- Troll Protector
	[2041]="0:4:3:1:Leather::1:0::3:0", -- Tunic of Westfall
	[2042]="0:2:3:1:Stave::1:0::3:0", -- Staff of Westfall
	[2043]="0:4:3:1:Ring::1:0::3:0", -- Ring of Forlorn Spirits
	[2044]="0:2:3:1:OneHandAxe::1:0::3:0", -- Crescent of Forlorn Spirits
	[2046]="0:2:2:1:OneHandSword::1:0::2:0", -- Bluegill Kukri
	[2047]="0:2:1:1:OneHandAxe::1:0::3:0", -- Anvilmar Hand Axe
	[2048]="0:2:1:1:OneHandMace::1:0::3:0", -- Anvilmar Hammer
	[2054]="0:2:1:1:OneHandAxe::1:0::0:0", -- Trogg Hand Axe
	[2055]="0:2:1:1:OneHandMace::1:0::0:0", -- Small Wooden Hammer
	[2057]="0:2:1:1:OneHandSword::1:0::0:0", -- Pitted Defias Shortsword
	[2058]="0:2:2:1:TwoHandMace::1:0::2:0", -- Kazon's Maul
	[2059]="0:4:3:1:Cloak::1:0::2:0", -- Sentry Cloak
	[2064]="0:2:1:1:OneHandMace::1:0::0:0", -- Trogg Club
	[2065]="0:2:1:1:OneHandSword::1:0::0:0", -- Rockjaw Blade
	[2066]="0:2:1:1:OneHandAxe::1:0::0:0", -- Skull Hatchet
	[2067]="0:2:1:1:Stave::1:0::0:0", -- Frostbit Staff
	[2069]="0:4:1:1:Leather::1:0::0:0", -- Black Bear Hide Vest
	[2070]="25:0:1:20:FoodDrink::5:0:295,465,483,1237,3298,3546,4782,4891,4894,4981,5620,6746,6790,6930,9501,11106,16553,17630,18929,23521,23604,24934,38714,40815,43972,44268,44417,44785,46269,46995,48125,49917:0:0", -- Darnassian Bleu
	[2072]="0:2:2:1:Stave::1:0::2:0", -- Dwarven Magestaff
	[2073]="0:2:2:1:OneHandAxe::1:0::2:0", -- Dwarven Hatchet
	[2074]="0:2:2:1:OneHandSword::1:0::3:0", -- Solid Shortblade
	[2075]="0:2:2:1:OneHandMace::1:0::2:0", -- Heavy Mace
	[2077]="0:2:2:1:Stave::1:0::2:0", -- Magician Staff
	[2078]="0:2:2:1:OneHandSword::1:0::2:0", -- Northern Shortsword
	[2079]="0:2:2:1:OneHandMace::1:0::2:0", -- Sergeant's Warhammer
	[2080]="0:2:2:1:OneHandAxe::1:0::2:0", -- Hillborne Axe
	[2082]="0:1:1:1:Bag::1:0::3:0", -- Wizbang's Gunnysack
	[2084]="0:2:2:1:TwoHandSword::1:0::2:0", -- Darksteel Bastard Sword
	[2085]="0:15:0:20:Junk::1:0::0:0", -- Chunk of Flesh
	[2087]="0:4:2:1:Leather::1:0::2:0", -- Hard Crawler Carapace
	[2088]="0:2:2:1:Dagger::1:0::2:0", -- Long Crawler Limb
	[2089]="0:2:2:1:Dagger::1:0::3:0", -- Scrimshaw Dagger
	[2091]="0:0:1:10:Other::1:0::0:0", -- Magic Dust
	[2092]="0:2:1:1:Dagger::1:0::0:0", -- Worn Dagger
	[2098]="0:2:3:1:Gun::1:0::2:0", -- Double-Barreled Shotgun
	[2099]="0:2:4:1:Gun::1:0::2:0", -- Dwarven Hand Cannon
	[2100]="0:2:4:1:Gun::1:0::2:0", -- Precisely Calibrated Boomstick
	[2101]="0:1:1:1:Bag::1:0::0:0", -- Light Quiver
	[2102]="0:1:1:1:Bag::1:0::0:0", -- Small Ammo Pouch
	[2105]="0:4:1:1:Shirt::1:0::0:0", -- Thug Shirt
	[2108]="0:4:1:1:Leather::1:0::0:0", -- Frostmane Leather Vest
	[2109]="0:4:1:1:Mail::1:0::0:0", -- Frostmane Chain Vest
	[2110]="0:4:1:1:Cloth::1:0::0:0", -- Light Magesmith Robe
	[2112]="0:4:1:1:Leather::1:0::0:0", -- Lumberjack Jerkin
	[2113]="0:12:1:1:::1:0::4:0", -- Calor's Note
	[2114]="0:4:1:1:Cloth::1:0::0:0", -- Snowy Robe
	[2117]="37:4:1:1:Cloth::1:0:190,836,1238,3590,4175,16918,42332:0:0", -- Thin Cloth Shoes
	[2119]="25:4:1:1:Cloth::1:0:190,836,1238,3590,4175,16918,42332:0:0", -- Thin Cloth Gloves
	[2120]="50:4:1:1:Cloth::1:0:190,836,1238,3590,4175,16918,42332:0:0", -- Thin Cloth Pants
	[2121]="50:4:1:1:Cloth::1:0:190,836,1238,3590,4175,16918,42332:0:0", -- Thin Cloth Armor
	[2122]="32:4:1:1:Leather::1:0:190,836,1238,3591,4236,16918,42332:0:0", -- Cracked Leather Belt
	[2123]="49:4:1:1:Leather::1:0:190,836,1238,3591,4236,16918,42332:0:0", -- Cracked Leather Boots
	[2124]="33:4:1:1:Leather::1:0:190,836,1238,3591,4236,16918,42332:0:0", -- Cracked Leather Bracers
	[2125]="33:4:1:1:Leather::1:0:190,836,1238,3591,4236,16918,42332:0:0", -- Cracked Leather Gloves
	[2126]="60:4:1:1:Leather::1:0:190,836,1238,3591,4236,16918,42332:0:0", -- Cracked Leather Pants
	[2127]="60:4:1:1:Leather::1:0:190,836,1238,3591,4236,16918,42332:0:0", -- Cracked Leather Vest
	[2129]="77:4:1:1:Shield::1:0:1104,1213,3592,4240,16762,16917:0:0", -- Large Round Shield
	[2130]="54:2:1:1:OneHandMace::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919,42335,43645:0:0", -- Club
	[2131]="54:2:1:1:OneHandSword::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919,42335,43645:0:0", -- Shortsword
	[2132]="102:2:1:1:Stave::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919,42335,43645:0:0", -- Short Staff
	[2134]="82:2:1:1:OneHandAxe::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919,42335,43645:0:0", -- Hand Axe
	[2136]="0:0:1:20:FoodDrink::1:0::0:0", -- Conjured Purified Water
	[2137]="0:2:1:1:Dagger::1:0::3:0", -- Whittling Knife
	[2138]="0:2:0:1:Dagger::1:0::0:0", -- Sharpened Letter Opener
	[2139]="57:2:1:1:Dagger::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919,42335,43645:0:0", -- Dirk
	[2140]="0:2:2:1:Dagger::1:0::2:0", -- Carving Knife
	[2141]="5224:4:1:1:Leather::1:0:1314,3315,3316,3953,4236,5820:0:0", -- Cuirboulli Vest
	[2142]="2621:4:1:1:Leather::1:0:1314,3315,3316,3953,4236,5820:0:0", -- Cuirboulli Belt
	[2143]="3945:4:1:1:Leather::1:0:1314,3315,3316,3953,4236,5820:0:0", -- Cuirboulli Boots
	[2144]="2639:4:1:1:Leather::1:0:1314,3315,3316,3953,4236,5820:0:0", -- Cuirboulli Bracers
	[2145]="2649:4:1:1:Leather::1:0:1314,3315,3316,3953,4236,5820:0:0", -- Cuirboulli Gloves
	[2146]="4809:4:1:1:Leather::1:0:1314,3315,3316,3953,4236,5820:0:0", -- Cuirboulli Pants
	[2148]="2908:4:1:1:Mail::1:0:226,1323,1341,1349,1450,3095,4177,4883,4886,5125,5812,5819,6028,34624,53641:0:0", -- Polished Scale Belt
	[2149]="4398:4:1:1:Mail::1:0:226,1323,1341,1349,1450,3095,4177,4883,4886,5125,5812,5819,6028,34624,53641:0:0", -- Polished Scale Boots
	[2150]="2930:4:1:1:Mail::1:0:226,1323,1341,1349,1450,3095,4177,4883,4886,5125,5812,5819,6028,34624,53641:0:0", -- Polished Scale Bracers
	[2151]="2941:4:1:1:Mail::1:0:226,1323,1341,1349,1450,3095,4177,4883,4886,5125,5812,5819,6028,34624,53641:0:0", -- Polished Scale Gloves
	[2152]="5906:4:1:1:Mail::1:0:226,1323,1341,1349,1450,3095,4177,4883,4886,5125,5812,5819,6028,34624,53641:0:0", -- Polished Scale Leggings
	[2153]="5928:4:1:1:Mail::1:0:226,1323,1341,1349,1450,3095,4177,4883,4886,5125,5812,5819,6028,34624,53641:0:0", -- Polished Scale Vest
	[2154]="0:15:0:1:Junk::1:0::3:0", -- The Story of Morgan Ladimore
	[2156]="3078:4:1:1:Cloth::1:0:1314,2849,3092,3315,3316,3952,4175,5821:0:0", -- Padded Boots
	[2158]="2066:4:1:1:Cloth::1:0:1314,2849,3092,3315,3316,3952,4175,5821:0:0", -- Padded Gloves
	[2159]="4148:4:1:1:Cloth::1:0:1314,2849,3092,3315,3316,3952,4175,5821:0:0", -- Padded Pants
	[2160]="4163:4:1:1:Cloth::1:0:1314,2849,3092,3315,3316,3952,4175,5821:0:0", -- Padded Armor
	[2161]="0:12:1:1:::1:0::4:0", -- Book from Sven's Farm
	[2162]="0:12:1:1:::1:0::4:0", -- Sarah's Ring
	[2163]="0:2:4:1:Dagger::1:0::2:0", -- Shadowblade
	[2164]="0:2:4:1:Dagger::1:0::2:0", -- Gut Ripper
	[2165]="0:4:1:1:Cloak::1:0::3:0", -- Old Blanchy's Blanket
	[2166]="0:4:3:1:Mail::1:0::2:0", -- Foreman's Leggings
	[2167]="0:4:3:1:Leather::1:0::2:0", -- Foreman's Gloves
	[2168]="0:4:3:1:Cloth::1:0::3:0", -- Corpse Rompers
	[2169]="0:2:3:1:Dagger::1:0::3:0", -- Buzzer Blade
	[2172]="0:4:1:1:Mail::1:0::3:0", -- Rustic Belt
	[2173]="0:4:1:1:Leather::1:0::3:0", -- Old Leather Belt
	[2175]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Shadowhide Battle Axe
	[2186]="0:4:1:1:Leather::1:0::3:0", -- Outfitter Belt
	[2187]="0:12:1:1:::1:0::4:0", -- A Stack of Letters
	[2188]="0:12:1:1:::1:0::4:0", -- A Letter to Grelin Whitebeard
	[2194]="0:2:3:1:OneHandMace::1:0::2:0", -- Diamond Hammer
	[2195]="0:2:1:1:Dagger::1:0::3:0", -- Anvilmar Knife
	[2203]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Brashclaw's Chopper
	[2204]="0:2:2:1:TwoHandSword::1:0::2:0", -- Brashclaw's Skewer
	[2205]="0:2:3:1:TwoHandSword::1:0::2:0", -- Duskbringer
	[2207]="2391:2:1:1:Dagger::1:0:1287,1289,2997,3021,3314,3331,3361,3479,3534,3658,4171,4203,4231,4557,4569,5103,5120,6030,16714,43645,43948:0:0", -- Jambiya
	[2208]="3651:2:1:1:Dagger::1:0:225,1287,1289,2997,3021,3331,3361,3491,4171,4203,4231,4557,4569,5103,5120,16714,41622,43948:0:0", -- Poniard
	[2209]="7116:2:1:1:Dagger::1:0:225,1287,1289,1441,3021,3331,3361,3539,4171,4203,4569,5120,11137,16714,33265,41622,43948:0:0", -- Kris
	[2210]="0:4:0:1:Shield::1:0::0:0", -- Battered Buckler
	[2211]="0:4:0:1:Shield::1:0::0:0", -- Bent Large Shield
	[2212]="0:4:0:1:Shield::1:0::0:0", -- Cracked Buckler
	[2213]="0:4:0:1:Shield::1:0::0:0", -- Worn Large Shield
	[2214]="0:4:0:1:Shield::1:0::0:0", -- Wooden Buckler
	[2215]="0:4:0:1:Shield::1:0::0:0", -- Wooden Shield
	[2216]="0:4:0:1:Shield::1:0::0:0", -- Simple Buckler
	[2217]="0:4:0:1:Shield::1:0::0:0", -- Rectangular Shield
	[2218]="0:2:2:1:Dagger::1:0::3:0", -- Craftsman's Dagger
	[2219]="0:4:0:1:Shield::1:0::0:0", -- Small Round Shield
	[2220]="0:4:0:1:Shield::1:0::0:0", -- Box Shield
	[2221]="0:4:0:1:Shield::1:0::0:0", -- Targe Shield
	[2222]="0:4:0:1:Shield::1:0::0:0", -- Tower Shield
	[2223]="0:12:1:1:::1:0::4:0", -- The Collector's Schedule
	[2224]="0:2:1:1:Dagger::1:0::3:0", -- Militia Dagger
	[2225]="0:2:1:1:Dagger::1:0::3:0", -- Sharp Kitchen Knife
	[2226]="0:2:2:1:Stave::1:0::2:0", -- Ogremage Staff
	[2227]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Heavy Ogre War Axe
	[2230]="0:4:2:1:Mail::1:0::3:0", -- Gloves of Brawn
	[2231]="0:4:2:1:Cloth::1:0::3:0", -- Inferno Robe
	[2232]="0:4:2:1:Cloth::1:0::2:0", -- Dark Runner Boots
	[2233]="0:4:2:1:Leather::1:0::2:0", -- Shadow Weaver Leggings
	[2234]="0:4:2:1:Cloth::1:0::2:0", -- Nightwalker Armor
	[2235]="0:2:2:1:Dagger::1:0::2:0", -- Brackclaw
	[2236]="0:2:3:1:Dagger::1:0::2:0", -- Blackfang
	[2237]="0:4:2:1:Leather::1:0::3:0", -- Patched Pants
	[2238]="0:4:2:1:Cloth::1:0::3:0", -- Urchin's Pants
	[2239]="0:12:1:1:::1:0::4:0", -- The Collector's Ring
	[2240]="0:4:1:1:Cloak::1:0::3:0", -- Rugged Cape
	[2241]="0:4:2:1:Cloak::1:0::2:0", -- Desperado Cape
	[2243]="0:2:4:1:OneHandMace::1:0::2:0", -- Hand of Edward the Odd
	[2244]="0:2:4:1:OneHandSword::1:0::2:0", -- Krol Blade
	[2245]="0:4:4:1:Mail::1:0::2:0", -- Helm of Narv
	[2246]="0:4:4:1:Ring::1:0::2:0", -- Myrmidon's Signet
	[2249]="0:4:2:1:Shield::1:0::3:0", -- Militia Buckler
	[2250]="0:12:1:1:::1:0::4:0", -- Dusky Crab Cakes
	[2251]="0:7:1:20:Meat:185:1:0::0:0", -- Gooey Spider Leg
	[2252]="0:12:1:1:::1:0::4:0", -- Miscellaneous Goblin Supplies
	[2254]="0:2:2:1:TwoHandMace::1:0::2:0", -- Icepane Warhammer
	[2256]="0:2:3:1:OneHandMace::1:0::2:0", -- Skeletal Club
	[2257]="0:2:1:1:Stave::1:0::0:0", -- Frostmane Staff
	[2258]="0:2:1:1:OneHandSword::1:0::0:0", -- Frostmane Shortsword
	[2259]="0:2:1:1:OneHandMace::1:0::0:0", -- Frostmane Club
	[2260]="0:2:1:1:OneHandAxe::1:0::0:0", -- Frostmane Hand Axe
	[2262]="0:4:3:1:Ring::1:0::2:0", -- Mark of Kern
	[2264]="0:4:3:1:Leather::1:0::2:0", -- Mantle of Thieves
	[2265]="0:2:2:1:OneHandAxe::1:0::2:0", -- Stonesplinter Axe
	[2266]="0:2:2:1:Dagger::1:0::2:0", -- Stonesplinter Dagger
	[2267]="0:2:2:1:OneHandMace::1:0::2:0", -- Stonesplinter Mace
	[2268]="0:2:1:1:OneHandSword::1:0::0:0", -- Stonesplinter Blade
	[2271]="0:2:3:1:Stave::1:0::2:0", -- Staff of the Blessed Seer
	[2274]="0:4:2:1:Mail::1:0::2:0", -- Sapper's Gloves
	[2276]="0:4:3:1:Leather::1:0::2:0", -- Swampwalker Boots
	[2277]="0:4:3:1:Cloth::1:0::2:0", -- Necromancer Leggings
	[2278]="0:4:3:1:Leather::1:0::2:0", -- Forest Tracker Epaulets
	[2280]="0:2:3:1:Stave::1:0::3:0", -- Kam's Walking Stick
	[2281]="0:2:2:1:OneHandAxe::1:0::2:0", -- Rodentia Flint Axe
	[2282]="0:2:1:1:OneHandSword::1:0::0:0", -- Rodentia Shortsword
	[2283]="0:4:2:1:Cloth::1:0::2:0", -- Rat Cloth Belt
	[2284]="0:4:2:1:Cloak::1:0::2:0", -- Rat Cloth Cloak
	[2287]="125:0:1:20:FoodDrink::5:0:982,1156,1464,2388,2814,3025,3089,3312,3368,3411,3489,3705,3881,3882,3933,3935,4169,4782,4879,4891,4894,4954,5111,5124,5611,5620,5688,5870,6739,6741,6928,6929,7485,7731,7733,9356,11118,11187,12196,12959,14624,15174,15397,16443,16618,16739,17553,17630,17656,19182,23263,23481,23605,24208,24291,24343,36378,39031,40589,40898,41286,41491,41674,41892,42953,43606,43624,43633,43739,43771,43899,43956,44177,44276,44312,44343,45563,47165,47288,47668,47854,48555,48735,50092,51142:0:0", -- Haunch of Meat
	[2288]="0:0:1:20:FoodDrink::1:0::0:0", -- Conjured Fresh Water
	[2289]="350:0:1:20:Scroll::1:1:4581,12246,14847:0:0", -- Scroll of Strength II
	[2290]="300:0:1:20:Scroll::1:1:1316,2805,4581,12246,14847:0:0", -- Scroll of Intellect II
	[2291]="0:2:4:1:TwoHandAxe::1:0::2:0", -- Kang the Decapitator
	[2292]="0:4:3:1:Cloth::1:0::2:0", -- Necrology Robes
	[2295]="0:15:0:20:Junk::1:0::0:0", -- Large Boar Tusk
	[2296]="0:7:0:20:Meat::1:0::0:0", -- Great Goretusk Snout
	[2299]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Burning War Axe
	[2300]="0:4:2:1:Leather::1:0::2:0", -- Embossed Leather Vest
	[2302]="0:4:1:1:Leather::1:0::0:0", -- Handstitched Leather Boots
	[2303]="0:4:1:1:Leather::1:0::0:0", -- Handstitched Leather Pants
	[2304]="0:0:1:10:EnhPerm::1:0::0:0", -- Light Armor Kit
	[2307]="0:4:2:1:Leather::1:0::2:0", -- Fine Leather Boots
	[2308]="0:4:2:1:Cloak::1:0::2:0", -- Fine Leather Cloak
	[2309]="0:4:2:1:Leather::1:0::2:0", -- Embossed Leather Boots
	[2310]="0:4:2:1:Cloak::1:0::2:0", -- Embossed Leather Cloak
	[2311]="0:4:2:1:Leather::1:0::2:0", -- White Leather Jerkin
	[2312]="0:4:2:1:Leather::1:0::2:0", -- Fine Leather Gloves
	[2313]="0:0:1:10:EnhPerm::1:0::0:0", -- Medium Armor Kit
	[2314]="0:4:3:1:Leather::1:0::2:0", -- Toughened Leather Armor
	[2315]="0:4:2:1:Leather::1:0::2:0", -- Dark Leather Boots
	[2316]="0:4:2:1:Cloak::1:0::2:0", -- Dark Leather Cloak
	[2317]="0:4:2:1:Leather::1:0::2:0", -- Dark Leather Tunic
	[2318]="0:7:1:20:Leather:164,202,165,197:1:0::0:0", -- Light Leather
	[2319]="200:7:1:20:Leather:164,202,165,197:1:1:14846,44286:0:0", -- Medium Leather
	[2320]="10:7:1:20:Cloth:165,197:1:0:66,777,843,960,989,1148,1250,1286,1347,1454,1456,1465,1474,1672,1692,2118,2225,2393,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3008,3081,3091,3168,3187,3364,3366,3367,3482,3485,3499,3556,3614,3779,3954,3958,4168,4194,4225,4229,4561,4577,4589,4775,4897,5100,5128,5135,5154,5163,5565,5817,6567,6568,6574,7854,7940,7947,8145,8160,8363,8681,8934,9636,11189,11557,11874,12022,12028,12043,12245,12941,12942,12943,12956,12958,15179,16224,16261,16262,16366,16613,16638,16689,16748,16767,16768,17486,17490,18009,18277,18426,18427,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,25010,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,32979,33596,33601,33635,33636,33681,33684,34601,36695,36779,38783,38853,38873,40226,40474,40572,41053,41275,41490,41676,41891,42853,43380,43495,43550,43554,43558,43568,43880,43980,44027,44034,44186,44301,44341,44383,44386,44780,45093,45286,45490,45497,45552,45558,46184,47104,47153,47164,47347,47721,47856,47863,47939,48058,48098,48123,48235,48551,48574,48587,48608,48857,48860,48868,49404,49705,49714,49885,49888,50071,50094,50456,50457,53075,53436,53782:0:0", -- Coarse Thread
	[2321]="100:7:1:20:Cloth:164,165,197:1:0:777,843,960,989,1148,1286,1347,1454,1456,1465,1474,1672,2225,2393,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3008,3091,3364,3366,3367,3482,3485,3499,3556,3779,3954,3958,4168,4194,4225,4229,4561,4577,4589,4775,4897,5100,5128,5135,5154,5163,5565,5817,6567,6568,6574,7854,7940,7947,8145,8160,8363,8681,8934,9636,11189,11557,11874,12022,12028,12043,12245,12941,12942,12943,12956,12958,15179,16224,16366,16613,16638,16689,16748,16767,16768,17486,17490,18009,18277,18426,18427,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,25010,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,32979,33596,33601,33635,33636,33681,33684,34601,38873,40226,40474,40572,41053,41275,41490,41676,41891,43380,43495,43550,43554,43568,43880,43980,44027,44186,44301,44341,44383,44386,44780,45093,45286,45417,45490,45497,45552,45558,46184,47104,47153,47164,47347,47721,47856,47863,47939,48058,48098,48123,48235,48551,48574,48587,48608,48857,48860,48868,49404,49705,49714,49885,49888,50071,50094,50456,50457,53075,53436,53782:0:0", -- Fine Thread
	[2324]="25:7:1:10:Other:165,197:1:0:66,777,843,960,1250,1347,1454,1456,1465,1474,1672,1692,2118,2225,2393,2394,2668,2669,2670,2672,3005,3081,3091,3168,3187,3364,3482,3485,3499,3556,3614,4168,4194,4577,5100,5135,5154,5817,6567,6568,6574,7940,7947,8145,8363,8681,8934,9636,11557,12022,12028,12043,16224,16261,16262,16366,16638,16767,17490,18426,18427,18749,18772,19213,19521,19722,24843,24935,25010,25051,25082,28726,28810,29288,32979,33596,33636,33684,36695,36779,38783,38853,40474,40572,41053,41275,41490,41676,41891,42853,43558,43980,44034,44186,44301,44341,44383,45286,45490,45497,45552,45558,47104,47153,47164,47347,47721,47856,47863,47939,48058,48098,48123,48235,48551,48574,48587,48857,48860,49705,49885,49888,50456:0:0", -- Bleach
	[2325]="1000:7:1:10:Other:165,197:1:0:989,1148,1286,1347,1454,1474,1672,2225,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3008,3091,3364,3366,3367,3485,3779,3954,3958,4168,4225,4229,4561,4577,4589,4775,4897,5128,5135,5154,5163,5565,5817,6567,6568,6574,7854,7940,7947,8145,8160,8363,8681,8934,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12958,15179,16366,16613,16638,16689,16748,16767,16768,17486,18009,18277,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,25010,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,32979,33596,33601,33635,33636,33681,33684,34601,38873,40226,40474,40572,41053,41275,41490,41676,41891,43380,43495,43550,43554,43568,43880,43980,44027,44186,44341,44383,44386,44780,45093,45552,45558,46184,47153,47164,47347,47856,48098,48551,48574,48587,48608,48857,48860,48868,49404,49705,49714,49888,50071,50094,50456,50457,53075,53436,53782:0:0", -- Black Dye
	[2326]="0:4:1:1:Cloth::1:0::3:0", -- Ivy-Weave Bracers
	[2327]="0:4:1:1:Leather::1:0::0:0", -- Sturdy Leather Bracers
	[2361]="0:2:1:1:TwoHandMace::1:0::0:0", -- Battleworn Hammer
	[2362]="0:4:1:1:Shield::1:0::0:0", -- Worn Wooden Shield
	[2364]="296:4:1:1:Cloth::1:0:3166,3317,3522,4558,16186,16623,43949:0:0", -- Woven Vest
	[2366]="298:4:1:1:Cloth::1:0:3166,3317,3522,4558,16186,16623,43949:0:0", -- Woven Pants
	[2367]="224:4:1:1:Cloth::1:0:3166,3317,3522,4558,16186,16623,43949:0:0", -- Woven Boots
	[2369]="150:4:1:1:Cloth::1:0:3166,3317,3522,4558,16186,16623,43949:0:0", -- Woven Gloves
	[2370]="378:4:1:1:Leather::1:0:2137,3079,3093,3166,3321,4558,16186,16691,43949,43951:0:0", -- Battered Leather Harness
	[2371]="189:4:1:1:Leather::1:0:2137,3079,3093,3166,3321,4558,16186,16691,43949,43951:0:0", -- Battered Leather Belt
	[2372]="344:4:1:1:Leather::1:0:2137,3079,3093,3166,3321,4558,16186,16691,43949,43951:0:0", -- Battered Leather Pants
	[2373]="259:4:1:1:Leather::1:0:2137,3079,3093,3166,3321,4558,16186,16691,43949,43951:0:0", -- Battered Leather Boots
	[2374]="173:4:1:1:Leather::1:0:2137,3079,3093,3166,3321,4558,16186,16691,43949,43951:0:0", -- Battered Leather Bracers
	[2375]="174:4:1:1:Leather::1:0:2137,3079,3093,3166,3321,4558,16186,16691,43949,43951:0:0", -- Battered Leather Gloves
	[2376]="448:4:1:1:Shield::1:0:2135,3080,3167,3319,4559,16258,16693,43955,43957,44339:0:0", -- Worn Heater Shield
	[2378]="0:12:1:20:::1:0::4:0", -- Skeleton Finger
	[2379]="76:4:1:1:Mail::1:0:1104,1213,3592,4177,16917:0:0", -- Tarnished Chain Vest
	[2380]="38:4:1:1:Mail::1:0:1104,1213,3592,4177,16917:0:0", -- Tarnished Chain Belt
	[2381]="76:4:1:1:Mail::1:0:1104,1213,3592,4177,16917:0:0", -- Tarnished Chain Leggings
	[2383]="58:4:1:1:Mail::1:0:1104,1213,3592,4177,16917:0:0", -- Tarnished Chain Boots
	[2384]="38:4:1:1:Mail::1:0:1104,1213,3592,4177,16917:0:0", -- Tarnished Chain Bracers
	[2385]="38:4:1:1:Mail::1:0:1104,1213,3592,4177,16917:0:0", -- Tarnished Chain Gloves
	[2386]="78:4:1:1:Mail::1:0:2116,3075,3161,4559:0:0", -- Rusted Chain Vest
	[2387]="39:4:1:1:Mail::1:0:2116,3075,3161,4559:0:0", -- Rusted Chain Belt
	[2388]="78:4:1:1:Mail::1:0:2116,3075,3161,4559:0:0", -- Rusted Chain Leggings
	[2389]="59:4:1:1:Mail::1:0:2116,3075,3161,4559:0:0", -- Rusted Chain Boots
	[2390]="39:4:1:1:Mail::1:0:2116,3075,3161,4559:0:0", -- Rusted Chain Bracers
	[2391]="39:4:1:1:Mail::1:0:2116,3075,3161,4559:0:0", -- Rusted Chain Gloves
	[2392]="413:4:1:1:Mail::1:0:1240,1249,1294,2046,3613,4164,4177,5106,5812,5819,16750,17930,42626:0:0", -- Light Mail Armor
	[2393]="207:4:1:1:Mail::1:0:1240,1249,1294,2046,3613,4164,4177,5106,5812,5819,16750,17930,42626:0:0", -- Light Mail Belt
	[2394]="416:4:1:1:Mail::1:0:1240,1249,1294,2046,3613,4164,4177,5106,5812,5819,16750,17930,42626:0:0", -- Light Mail Leggings
	[2395]="323:4:1:1:Mail::1:0:1240,1249,1294,2046,3613,4164,4177,5106,5812,5819,16750,17930,42626:0:0", -- Light Mail Boots
	[2396]="215:4:1:1:Mail::1:0:1240,1249,1294,2046,3613,4164,4177,5106,5812,5819,16750,17930,42626:0:0", -- Light Mail Bracers
	[2397]="216:4:1:1:Mail::1:0:1240,1249,1294,2046,3613,4164,4177,5106,5812,5819,16750,17930,42626:0:0", -- Light Mail Gloves
	[2398]="434:4:1:1:Mail::1:0:2135,3080,3167,3319,4559,16258,16625,16693,43955,43957,44339:0:0", -- Light Chain Armor
	[2399]="218:4:1:1:Mail::1:0:2135,3080,3167,3319,4559,16258,16625,16693,43955,43957,44339:0:0", -- Light Chain Belt
	[2400]="437:4:1:1:Mail::1:0:2135,3080,3167,3319,4559,16258,16625,16693,43955,43957,44339:0:0", -- Light Chain Leggings
	[2401]="331:4:1:1:Mail::1:0:2135,3080,3167,3319,4559,16258,16625,16693,43955,43957,44339:0:0", -- Light Chain Boots
	[2402]="220:4:1:1:Mail::1:0:2135,3080,3167,3319,4559,16258,16625,16693,43955,43957,44339:0:0", -- Light Chain Bracers
	[2403]="221:4:1:1:Mail::1:0:2135,3080,3167,3319,4559,16258,16625,16693,43955,43957,44339:0:0", -- Light Chain Gloves
	[2406]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Fine Leather Boots
	[2407]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: White Leather Jerkin
	[2408]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Fine Leather Gloves
	[2409]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Dark Leather Tunic
	[2411]="10000:15:3:1:Mount::1:0:1460,43694:3:0", -- Black Stallion Bridle
	[2414]="10000:15:3:1:Mount::1:0:384,1460,4885,43694:3:0", -- Pinto Bridle
	[2417]="15673:4:1:1:Mail::1:0:1322,1323,1349,1381,2845,3095,4177,5125,5812,5819,8129,43750,53641:0:0", -- Augmented Chain Vest
	[2418]="15732:4:1:1:Mail::1:0:1322,1323,1349,1381,2845,3095,4177,5125,5812,5819,8129,43750,53641:0:0", -- Augmented Chain Leggings
	[2419]="7895:4:1:1:Mail::1:0:1322,1323,1349,1381,2845,3095,4177,5125,5812,5819,8129,43750,53641:0:0", -- Augmented Chain Belt
	[2420]="11938:4:1:1:Mail::1:0:1322,1323,1339,1349,1381,2845,3095,4177,4890,5125,5812,5819,8129,23571,43750,53641:0:0", -- Augmented Chain Boots
	[2421]="7952:4:1:1:Mail::1:0:1322,1323,1349,1381,2845,3095,4177,5125,5812,5819,8129,43750,53641:0:0", -- Augmented Chain Bracers
	[2422]="7981:4:1:1:Mail::1:0:1322,1323,1349,1381,2845,3095,4177,5125,5812,5819,8129,43750,53641:0:0", -- Augmented Chain Gloves
	[2423]="42770:4:1:1:Mail::1:0:980,1323,1349,4177,5126,5508,5819,8129,11182,12040,16626,16753,25274,27067,45500,53641:0:0", -- Brigandine Vest
	[2424]="21461:4:1:1:Mail::1:0:980,1323,1349,4177,5126,5508,5819,8129,11182,12040,16626,16753,25274,27067,45500,53641:0:0", -- Brigandine Belt
	[2425]="43077:4:1:1:Mail::1:0:980,1323,1349,4177,5126,5508,5819,8129,11182,12040,16626,16753,25274,27067,45500,53641:0:0", -- Brigandine Leggings
	[2426]="32569:4:1:1:Mail::1:0:980,1323,1339,1349,4177,4890,5126,5508,5819,8129,11182,12040,16626,16753,23571,25274,27067,45500,53641:0:0", -- Brigandine Boots
	[2427]="20146:4:1:1:Mail::1:0:980,1323,1349,4177,5126,5508,5819,8129,11182,12040,16626,16753,25274,27067,45500,53641:0:0", -- Brigandine Bracers
	[2428]="20222:4:1:1:Mail::1:0:980,1323,1349,4177,5126,5508,5819,8129,11182,12040,16626,16753,25274,27067,45500,53641:0:0", -- Brigandine Gloves
	[2429]="10139:4:1:1:Cloth::1:0:1147,1314,1407,2849,3092,3315,3316,4175,5155,5821,8159,10293,38561,45149:0:0", -- Russet Vest
	[2431]="10215:4:1:1:Cloth::1:0:1147,1314,1407,2849,3092,3315,3316,4175,5155,5821,8159,10293,38561,45149:0:0", -- Russet Pants
	[2432]="7691:4:1:1:Cloth::1:0:1147,1314,1339,1407,2849,3092,3315,3316,4175,4890,5155,5821,8159,10293,23571,38561,45149:0:0", -- Russet Boots
	[2434]="5166:4:1:1:Cloth::1:0:1147,1314,1407,2849,3092,3315,3316,4175,5155,5821,8159,10293,38561,45149:0:0", -- Russet Gloves
	[2435]="27683:4:1:1:Cloth::1:0:984,1314,2849,3092,3315,3316,4175,5129,5155,5821,10293,11183,12023,26707,45149:0:0", -- Embroidered Armor
	[2437]="27891:4:1:1:Cloth::1:0:984,1314,2849,3092,3315,3316,4175,5129,5155,5821,10293,11183,12023,26707,45149:0:0", -- Embroidered Pants
	[2438]="20996:4:1:1:Cloth::1:0:984,1314,1339,2849,3092,3315,3316,4175,4890,5129,5155,5821,10293,11183,12023,23571,26707,45149:0:0", -- Embroidered Boots
	[2440]="14099:4:1:1:Cloth::1:0:984,1314,2849,3092,3315,3316,4175,5129,5155,5821,10293,11183,12023,26707,45149:0:0", -- Embroidered Gloves
	[2445]="3433:4:1:1:Shield::1:0:793,1319,3319,3493,4240,5126,8360,16693,16762,33381,47106,47144:0:0", -- Large Metal Shield
	[2446]="6182:4:1:1:Shield::1:0:226,1319,1323,1349,1450,3095,4240,4886,5126,5812,5819,6028,16693,16762,31027,34624,47106,47144,53641:0:0", -- Kite Shield
	[2447]="40:7:1:20:Herb:171:1:1:1313,3490,3548,16224,16641,16705:0:0", -- Peacebloom
	[2448]="16159:4:1:1:Shield::1:0:1319,1322,1323,1349,1381,2845,3095,4177,4240,5125,5126,5812,5819,8129,43750,47106,47144,53641:0:0", -- Heavy Pavise
	[2449]="80:7:1:20:Herb:171:1:1:844,1302,1313,3490,3548,4083,8305,14846,16224,16641,16705:0:0", -- Earthroot
	[2450]="0:7:1:20:Herb:171:1:0::0:0", -- Briarthorn
	[2451]="43629:4:1:1:Shield::1:0:980,1319,1323,1349,3095,4177,4240,5126,5508,5812,5819,8129,11182,12040,16626,16753,25274,27067,45500,46512,47106,47144,49549,53641:0:0", -- Crested Heater Shield
	[2452]="0:7:1:20:Herb:171,185:1:0::0:0", -- Swiftthistle
	[2453]="100:7:1:20:Herb:171:1:1:844,1302,1313,3490,3548,4083,8305,16224,16641,16705:0:0", -- Bruiseweed
	[2454]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Lion's Strength
	[2455]="40:0:1:20:Potion::1:1:958,3658,16612,16706:0:0", -- Minor Mana Potion
	[2456]="0:0:1:20:Potion::1:0::0:0", -- Minor Rejuvenation Potion
	[2457]="0:0:1:20:Elixir:165:1:0::0:0", -- Elixir of Minor Agility
	[2458]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Minor Fortitude
	[2459]="0:0:1:20:Potion:164,165:1:0::0:0", -- Swiftness Potion
	[2463]="13695:4:1:1:Leather::1:0:1147,1314,1320,1407,3315,3316,4236,5129,5820,8159,38561,44083:0:0", -- Studded Doublet
	[2464]="6872:4:1:1:Leather::1:0:1147,1314,1320,1407,3315,3316,4236,5129,5820,8159,38561,44083:0:0", -- Studded Belt
	[2465]="12477:4:1:1:Leather::1:0:1147,1314,1320,1407,3315,3316,4236,5129,5820,8159,38561,44083:0:0", -- Studded Pants
	[2466]="0:12:1:20:::1:0::4:0", -- Skullsplitter Fetish
	[2467]="9430:4:1:1:Leather::1:0:1147,1314,1320,1339,1407,3315,3316,4236,4890,5129,5820,8159,23571,38561,44083:0:0", -- Studded Boots
	[2468]="6311:4:1:1:Leather::1:0:1147,1314,1320,1407,3315,3316,4236,5129,5820,8159,38561,44083:0:0", -- Studded Bracers
	[2469]="6335:4:1:1:Leather::1:0:1147,1314,1320,1407,3315,3316,4236,5129,5820,8159,38561,44083:0:0", -- Studded Gloves
	[2470]="33952:4:1:1:Leather::1:0:984,1314,1320,3315,3316,4236,5129,5820,11183,12023,26707,27037,44083:0:0", -- Reinforced Leather Vest
	[2471]="17041:4:1:1:Leather::1:0:984,1314,1320,3315,3316,4236,5129,5820,11183,12023,26707,27037,44083:0:0", -- Reinforced Leather Belt
	[2472]="34212:4:1:1:Leather::1:0:984,1314,1320,3315,3316,4236,5129,5820,11183,12023,26707,27037,44083:0:0", -- Reinforced Leather Pants
	[2473]="25753:4:1:1:Leather::1:0:984,1314,1320,1339,3315,3316,4236,4890,5129,5820,11183,12023,23571,26707,27037,44083:0:0", -- Reinforced Leather Boots
	[2474]="17233:4:1:1:Leather::1:0:984,1314,1320,3315,3316,4236,5129,5820,11183,12023,26707,27037,44083:0:0", -- Reinforced Leather Bracers
	[2475]="17298:4:1:1:Leather::1:0:984,1314,1320,3315,3316,4236,5129,5820,11183,12023,26707,27037,44083:0:0", -- Reinforced Leather Gloves
	[2476]="0:12:1:20:::1:0::4:0", -- Chilled Basilisk Haunch
	[2479]="108:2:1:1:TwoHandAxe::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919,42335,43645:0:0", -- Broad Axe
	[2480]="72:2:1:1:TwoHandMace::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919,42335,43645:0:0", -- Large Club
	[2488]="536:2:1:1:OneHandSword::1:0:54,1273,1698,2136,2997,3052,3077,3163,3314,3609,4231,4556,5102,10369,16257,17930,18926,36717,43645:0:0", -- Gladius
	[2489]="343:2:1:1:TwoHandSword::1:0:54,1273,1698,2136,2997,3052,3077,3163,3314,3609,4231,4556,5102,10369,16257,17930,18926,36717,43645:0:0", -- Two-Handed Sword
	[2490]="540:2:1:1:OneHandAxe::1:0:54,1273,1698,2136,2997,3052,3077,3163,3177,3314,3609,4231,4556,5102,10369,16257,17930,18926,36717,43645:0:0", -- Tomahawk
	[2491]="484:2:1:1:TwoHandAxe::1:0:54,1273,1698,2136,2997,3052,3077,3163,3177,3314,3609,4231,4556,5102,10369,16257,17930,18926,36717,43645:0:0", -- Large Axe
	[2492]="285:2:1:1:OneHandMace::1:0:54,222,1273,1348,1698,2136,2997,3052,3077,3163,3177,3314,3609,4231,4556,5102,10369,16257,17930,18926,36717,43645:0:0", -- Cudgel
	[2493]="701:2:1:1:TwoHandMace::1:0:54,222,1273,1348,1698,2136,2997,3052,3077,3163,3177,3314,3609,4231,4556,5102,10369,16257,17930,18926,36717,43645:0:0", -- Wooden Mallet
	[2494]="402:2:1:1:Dagger::1:0:54,1273,1698,2136,2997,3052,3077,3163,3314,3609,4231,4556,5102,10369,16257,17930,18926,36717,43645:0:0", -- Stiletto
	[2495]="505:2:1:1:Stave::1:0:54,1273,1698,2136,2997,3052,3077,3163,3314,3409,3609,4231,4556,5102,10369,16257,17930,18926,19238,36717,43645:0:0", -- Walking Stick
	[2504]="29:2:1:1:Bow::1:0:1297,12029,16263,16274,16619,16715,17667,24028,44040:0:0", -- Worn Shortbow
	[2505]="60:2:1:1:Bow::1:0:1297,12029,16263,16274,16619,16715,17667,24028,44040:0:0", -- Polished Shortbow
	[2506]="285:2:1:1:Bow::1:0:1198,1297,3165,3589,3610,10369,12029,16263,16274,16619,16715,17667,24028,44040:0:0", -- Hornwood Recurve Bow
	[2507]="1752:2:1:1:Bow::1:0:789,1198,1297,1459,1668,1687,3165,3409,3488,3589,3610,3951,4203,9549,9553,10369,12029,16263,16274,16619,16715,17667,24028,44040:0:0", -- Laminated Recurve Bow
	[2508]="27:2:1:1:Gun::1:0:5510:0:0", -- Old Blunderbuss
	[2509]="414:2:1:1:Gun::1:0:1243,1297,1469,2997,3018,3078,3322,3488,4603,5123,5510,7976,16274,16620,16735,41452,44040:0:0", -- Ornate Blunderbuss
	[2510]="41:2:1:1:Gun::1:0:1243,3018,3078,4603,5123,5510:0:0", -- Solid Blunderbuss
	[2511]="1324:2:1:1:Gun::1:0:1297,1469,1686,2997,3018,3088,3322,3488,7976,16274,16620,16735,41452,44040,49729:0:0", -- Hunter's Boomstick
	[2512]="0:15:0:1000:Junk::1:0::0:0", -- Rough Arrow
	[2515]="0:15:0:1000:Junk::1:0::0:0", -- Sharp Arrow
	[2516]="0:15:0:1000:Junk::1:0::0:0", -- Light Shot
	[2519]="0:15:0:1000:Junk::1:0::0:0", -- Heavy Shot
	[2520]="24629:2:1:1:OneHandSword::1:0:1146,1324,1645,2482,2843,3000,3021,3331,3361,4171,4600,4884,4886,5120,5170,11137,15315,16678,16714,19047,19240,21086,21474,28871,43154,44182,44277,44287,44339,47144,47758,48096,48123,48577:0:0", -- Broadsword
	[2521]="30896:2:1:1:TwoHandSword::1:0:1146,1333,1645,2482,2843,3000,4043,4180,4600,4884,4886,5120,5170,8398,11137,15315,16678,19047,19240,21086,21474,28871,43154,44182,44287,44339,47758,48123,48577:0:0", -- Flamberge
	[2522]="22548:2:1:1:OneHandAxe::1:0:1146,1645,2482,2483,3000,3019,4232,4884,4886,5119,5509,11137,12045,15315,16666,19479,21086,23571,43154,44287,47758,48577:0:0", -- Crescent Axe
	[2523]="28286:2:1:1:TwoHandAxe::1:0:1146,1333,1645,2482,2483,3000,3019,4043,4180,4232,4600,4884,4886,5119,5509,8398,11137,12045,15315,16666,19479,21086,23571,43154,44287,47758,48577:0:0", -- Bullova
	[2524]="19192:2:1:1:OneHandMace::1:0:1146,1471,1645,2482,3000,4884,4886,5121,5152,8878,11137,16637,16765,19370,21086,25314,28855,31027,44277,47149,48096:0:0", -- Truncheon
	[2525]="26490:2:1:1:TwoHandMace::1:0:1146,1333,1471,1645,2482,3000,4043,4180,4600,4884,4886,5121,5152,8398,8878,11137,16637,16765,19370,21086,25314,28855,31027,44277,47149,48096:0:0", -- War Hammer
	[2526]="19336:2:1:1:Dagger::1:0:1146,1324,1645,2482,2843,3000,3021,3331,3361,4171,4600,4884,4886,5120,5170,11137,15315,16678,16714,19047,19239,19240,21086,21474,28871,43154,44182,44277,44287,44339,47144,47758,48096,48123,48577:0:0", -- Main Gauche
	[2527]="29356:2:1:1:Stave::1:0:1146,1315,1471,1645,2482,3000,3022,3330,4234,4570,4884,4886,5121,5152,8878,11137,16637,16765,19043,19238,19370,21086,25314,28855,31027,44277,47149,48096:0:0", -- Battle Staff
	[2528]="51836:2:1:1:OneHandSword::1:0:981,1296,1324,1407,2843,3000,3021,3331,3361,4171,4600,5120,5170,11184,12024,15315,16388,16678,16714,19047,19240,21474,23897,28871,43154,44182,44277,44287,44339,44385,47144,47758,48096,48123,48577,49723:0:0", -- Falchion
	[2529]="65032:2:1:1:TwoHandSword::1:0:981,1296,1333,1407,2843,3000,4043,4180,4600,5120,5170,8398,11184,12024,15315,16388,16678,19047,19240,21474,23897,28871,43154,44182,44287,44339,44385,47758,48123,48577,49723:0:0", -- Zweihander
	[2530]="52220:2:1:1:OneHandAxe::1:0:981,1296,1407,2483,3000,3019,4232,5119,5509,11184,12024,12045,15315,16388,16666,19479,23571,23897,43154,44287,44385,47758,48577,49723:0:0", -- Francisca
	[2531]="56170:2:1:1:TwoHandAxe::1:0:981,1296,1333,1407,2483,3000,3019,4043,4180,4232,4600,5119,5509,8398,11184,12024,12045,15315,16388,16666,19479,23571,23897,43154,44287,44385,47758,48577,49723:0:0", -- Great Axe
	[2532]="52608:2:1:1:OneHandMace::1:0:981,1296,1407,1471,3000,5121,5152,8878,11184,12024,16388,16637,16765,19370,21086,23897,25314,28855,31027,44277,44385,47149,48096,49723:0:0", -- Morning Star
	[2533]="61108:2:1:1:TwoHandMace::1:0:981,1296,1333,1407,1471,3000,4043,4180,4600,5121,5152,8398,8878,11184,12024,16388,16637,16765,19370,21086,23897,25314,28855,31027,44277,44385,47149,48096,49723:0:0", -- War Maul
	[2534]="45431:2:1:1:Dagger::1:0:981,1296,1324,1407,2843,3000,3021,3331,3361,4171,4600,5120,5170,11184,12024,15315,16388,16678,16714,19047,19239,19240,21474,23897,28871,43154,44182,44277,44287,44339,44385,47144,47758,48096,48123,48577,49723:0:0", -- Rondel
	[2535]="61557:2:1:1:Stave::1:0:981,1296,1315,1407,1471,3000,3022,3330,4234,4570,5121,5152,8878,11184,12024,16388,16637,16765,19043,19238,19370,21086,23897,25314,28855,31027,44277,44385,47149,48096,49723:0:0", -- War Staff
	[2536]="0:12:1:20:::1:0::4:0", -- Trogg Stone Tooth
	[2545]="0:4:2:1:Mail::1:0::3:0", -- Malleable Chain Leggings
	[2546]="0:4:1:1:Mail::1:0::0:0", -- Royal Frostmane Girdle
	[2547]="0:4:1:1:Mail::1:0::3:0", -- Boar Handler Gloves
	[2548]="0:12:1:1:::1:0::4:0", -- Barrel of Barleybrew Scalder
	[2549]="0:2:3:1:Stave::1:0::2:0", -- Staff of the Shade
	[2553]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Elixir of Minor Agility
	[2555]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Swiftness Potion
	[2560]="0:12:1:1:::1:0::4:0", -- Jitters' Completed Journal
	[2561]="0:12:1:1:::1:0::4:0", -- Chok'sul's Head
	[2562]="0:4:1:1:OffHandFrill::1:0::3:0", -- Bouquet of Scarlet Begonias
	[2563]="0:12:1:1:::1:0::4:0", -- Strange Smelling Powder
	[2564]="0:4:3:1:Leather::1:0::2:0", -- Elven Spirit Claws
	[2565]="0:4:3:1:OffHandFrill::1:0::2:0", -- Rod of Molten Fire
	[2566]="0:4:2:1:Cloth::1:0::2:0", -- Sacrificial Robes
	[2567]="0:2:3:1:Dagger::1:0::2:0", -- Evocator's Blade
	[2568]="0:4:1:1:Cloth::1:0::0:0", -- Brown Linen Vest
	[2569]="0:4:2:1:Cloth::1:0::2:0", -- Linen Boots
	[2570]="0:4:1:1:Cloak::1:0::0:0", -- Linen Cloak
	[2571]="0:4:1:1:Cloth::1:0::3:0", -- Viny Wrappings
	[2572]="0:4:2:1:Cloth::1:0::2:0", -- Red Linen Robe
	[2575]="0:4:1:1:Shirt::1:0::0:0", -- Red Linen Shirt
	[2576]="0:4:1:1:Shirt::1:0::0:0", -- White Linen Shirt
	[2577]="0:4:1:1:Shirt::1:0::0:0", -- Blue Linen Shirt
	[2578]="0:4:2:1:Cloth::1:0::2:0", -- Barbaric Linen Vest
	[2579]="0:4:1:1:Shirt::1:0::0:0", -- Green Linen Shirt
	[2580]="0:4:2:1:Cloak::1:0::2:0", -- Reinforced Linen Cape
	[2581]="0:0:1:20:Bandage::1:0::0:0", -- Heavy Linen Bandage
	[2582]="0:4:2:1:Cloth::1:0::2:0", -- Green Woolen Vest
	[2583]="0:4:2:1:Cloth::1:0::2:0", -- Woolen Boots
	[2584]="0:4:1:1:Cloak::1:0::0:0", -- Woolen Cape
	[2585]="0:4:2:1:Cloth::1:0::2:0", -- Gray Woolen Robe
	[2586]="0:4:1:1:Cloth::1:0::3:0", -- Gamemaster's Robe
	[2587]="0:4:1:1:Shirt::1:0::0:0", -- Gray Woolen Shirt
	[2589]="55:7:1:20:Cloth:164,202,129,197:1:1:16631:0:0", -- Linen Cloth
	[2590]="0:15:0:20:Junk::1:0::0:0", -- Forest Spider Webbing
	[2591]="0:15:0:20:Junk::1:0::0:0", -- Dirty Trogg Cloth
	[2592]="135:7:1:20:Cloth:164,202,129,197:1:1:16631:0:0", -- Wool Cloth
	[2593]="150:0:1:20:FoodDrink:185:1:0:258,277,465,955,1301,1305,1311,1327,1328,1697,2832,5111,5112,5140,5570,5848,16442,17553,18542,18954,19186,19245,19617,23525,23606,24333,31017,33026,40832,43034,43997,44236,44299,44324,46995,47338,47363,47942,48064,48555,49729,53991:0:0", -- Flask of Port
	[2594]="1500:0:1:20:FoodDrink:185:1:0:258,277,465,955,1301,1305,1311,1327,1328,1464,1697,2832,5111,5112,5140,5570,5848,16442,17553,18542,18954,19186,19245,19617,20377,23525,23606,24333,31017,33026,40832,43034,43997,44236,44299,44324,46995,47338,47363,47942,48064,48555,49729,53991:0:0", -- Flagon of Mead
	[2595]="2000:0:1:20:FoodDrink:185:1:0:258,277,465,955,1301,1305,1311,1327,1328,1697,2832,5111,5112,5140,5570,5848,16442,17553,18542,18954,19186,19245,19617,23525,23606,24333,31017,33026,40832,43034,43997,44236,44299,44324,46995,47338,47363,47942,48064,48555,49729,53991:0:0", -- Jug of Bourbon
	[2596]="120:0:1:20:FoodDrink:185:1:0:258,277,465,955,1301,1305,1311,1327,1328,1697,2832,5111,5112,5140,5570,5848,16442,17553,18542,18954,19186,19245,19617,23525,23606,24333,31017,33026,40832,43034,43997,44236,44299,44324,46995,47338,47363,47942,48064,48555,49729,53991:0:0", -- Skin of Dwarven Stout
	[2598]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Red Linen Robe
	[2601]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Gray Woolen Robe
	[2604]="50:7:1:10:Other:165,197:1:0:66,843,989,1148,1250,1286,1347,1454,1465,1474,1672,1692,2118,2225,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3008,3081,3091,3168,3187,3364,3366,3367,3482,3485,3614,3779,3954,3958,4168,4194,4225,4229,4561,4577,4589,4775,4897,5128,5135,5154,5163,5565,5817,6567,6568,6574,7854,7940,7947,8145,8160,8363,8681,8934,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12958,15179,16224,16261,16262,16366,16613,16638,16689,16748,16767,16768,17486,17490,18009,18277,18426,18427,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,25010,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,32979,33596,33601,33635,33636,33681,33684,34601,36695,36779,38783,38853,38873,40226,40474,40572,41053,41275,41490,41676,41891,42853,43380,43495,43550,43554,43558,43568,43880,43980,44027,44034,44186,44341,44383,44386,44780,45093,45286,45490,45497,45552,45558,46184,47153,47164,47347,47856,48098,48551,48574,48587,48608,48857,48860,48868,49404,49705,49714,49885,49888,50071,50094,50456,50457,53075,53436,53782:0:0", -- Red Dye
	[2605]="100:7:1:10:Other:164,202,165,197:1:0:843,1347,1454,1465,1474,1672,2225,2394,2668,2669,2670,2672,2697,2698,2699,2816,2819,2846,3005,3008,3091,3364,3366,3482,3485,3958,4168,4194,4225,4577,4589,5128,5135,5154,5565,5817,6567,6568,6574,7854,7940,8160,8681,8934,11557,11874,12942,12943,12956,16224,16366,16638,16689,16748,16767,17490,18277,18426,18427,18749,18754,18771,18772,19196,19213,19521,19532,19722,21085,28718,28726,28798,28810,32979,33596,33601,33635,33636,33681,33684,34601,38873,40226,40572,43380,43495,43550,43554,43568,43880,44027,44386,45286,45490,45497,45552,45558,46184,47856,48098,48587,48608,48857,48860,49404,49705,49714,49885,49888,50071,50094,50456,50457,53075,53436,53782:0:0", -- Green Dye
	[2606]="0:12:1:1:::1:0::4:0", -- Lurker Venom
	[2607]="0:12:1:1:::1:0::4:0", -- Mo'grosh Crystal
	[2608]="0:15:0:20:Junk::1:0::0:0", -- Threshadon Ambergris
	[2609]="0:12:1:1:::1:0::4:0", -- Disarming Colloid
	[2610]="0:12:1:1:::1:0::4:0", -- Disarming Mixture
	[2611]="0:12:1:20:::1:0::4:0", -- Crude Flint
	[2612]="163:4:1:1:Cloth::1:0:1309,1350,3092,3315,4172,4580,5156:0:0", -- Plain Robe
	[2613]="608:4:1:1:Cloth::1:0:1309,1350,3092,3315,4172,4580,5156:0:0", -- Double-Stitched Robes
	[2614]="1162:4:1:1:Cloth::1:0:1309,1350,3092,3315,4172,4580,5156:0:0", -- Robe of Apprenticeship
	[2615]="5092:4:1:1:Cloth::1:0:1309,1350,3092,3315,4172,4580,5156:0:0", -- Chromatic Robe
	[2616]="2660:4:1:1:Cloth::1:0:1309,1350,3092,3315,4172,4580,5156:0:0", -- Shimmering Silk Robes
	[2617]="10992:4:1:1:Cloth::1:0:1309,1350,3092,3315,4172,4580,5156:0:0", -- Burning Robes
	[2618]="26640:4:1:1:Cloth::1:0:1309,1350,3092,3315,4172,4580,5156:0:0", -- Silver Dress Robes
	[2619]="0:12:1:1:::1:0::4:0", -- Grelin's Report
	[2620]="0:4:2:1:Cloth::1:0::2:0", -- Augural Shroud
	[2621]="0:4:2:1:Cloth::1:0::2:0", -- Cowl of Necromancy
	[2622]="0:4:2:1:Cloth::1:0::2:0", -- Nimar's Tribal Headdress
	[2623]="0:4:2:1:Cloth::1:0::2:0", -- Holy Diadem
	[2624]="0:4:2:1:Cloth::1:0::2:0", -- Thinking Cap
	[2625]="0:12:1:1:::1:0::4:0", -- Menethil Statuette
	[2628]="0:12:1:1:::1:0::4:0", -- Senir's Report
	[2629]="0:13:1:1:::1:0::4:0", -- Intrepid Strongbox Key
	[2632]="0:2:2:1:Dagger::1:0::2:0", -- Curved Dagger
	[2633]="0:12:1:20:::1:0::4:0", -- Jungle Remedy
	[2634]="0:12:1:1:::1:0::4:0", -- Venom Fern Extract
	[2635]="0:4:0:1:Mail::1:0::0:0", -- Loose Chain Belt
	[2636]="0:12:1:20:::1:0::4:0", -- Carved Stone Idol
	[2637]="0:12:1:1:::1:0::4:0", -- Ironband's Progress Report
	[2639]="0:12:1:1:::1:0::4:0", -- Merrin's Letter
	[2640]="0:12:1:20:::1:0::4:0", -- Miners' Gear
	[2642]="0:4:0:1:Mail::1:0::0:0", -- Loose Chain Boots
	[2643]="0:4:0:1:Mail::1:0::0:0", -- Loose Chain Bracers
	[2644]="0:4:0:1:Cloak::1:0::0:0", -- Loose Chain Cloak
	[2645]="0:4:0:1:Mail::1:0::0:0", -- Loose Chain Gloves
	[2646]="0:4:0:1:Mail::1:0::0:0", -- Loose Chain Pants
	[2648]="0:4:0:1:Mail::1:0::0:0", -- Loose Chain Vest
	[2649]="0:4:0:1:Mail::1:0::0:0", -- Flimsy Chain Belt
	[2650]="0:4:0:1:Mail::1:0::0:0", -- Flimsy Chain Boots
	[2651]="0:4:0:1:Mail::1:0::0:0", -- Flimsy Chain Bracers
	[2652]="0:4:0:1:Cloak::1:0::0:0", -- Flimsy Chain Cloak
	[2653]="0:4:0:1:Mail::1:0::0:0", -- Flimsy Chain Gloves
	[2654]="0:4:0:1:Mail::1:0::0:0", -- Flimsy Chain Pants
	[2656]="0:4:0:1:Mail::1:0::0:0", -- Flimsy Chain Vest
	[2657]="0:1:1:1:Bag::1:0::0:0", -- Red Leather Bag
	[2658]="0:12:1:1:::1:0::4:0", -- Ados Fragment
	[2659]="0:12:1:1:::1:0::4:0", -- Modr Fragment
	[2660]="0:12:1:1:::1:0::4:0", -- Golm Fragment
	[2661]="0:12:1:1:::1:0::4:0", -- Neru Fragment
	[2662]="0:1:2:1:Bag::1:0::3:0", -- Ribbly's Quiver
	[2663]="0:1:2:1:Bag::1:0::3:0", -- Ribbly's Bandolier
	[2665]="20:7:1:20:Meat::1:0:1303:0:0", -- Stormwind Seasoning Herbs
	[2666]="0:12:1:1:::1:0::4:0", -- Barrel of Thunder Ale
	[2667]="0:12:1:1:::1:0::4:0", -- MacGrann's Dried Meats
	[2671]="0:12:1:20:::1:0::4:0", -- Wendigo Mane
	[2672]="0:7:1:20:Meat:185:1:0::0:0", -- Stringy Wolf Meat
	[2673]="0:7:1:20:Meat:185:1:0::0:0", -- Coyote Meat
	[2674]="0:7:1:20:Meat:185:1:0::0:0", -- Crawler Meat
	[2675]="0:7:1:20:Meat:185:1:0::0:0", -- Crawler Claw
	[2676]="0:12:1:20:::1:0::4:0", -- Shimmerweed
	[2677]="0:7:1:20:Meat:185:1:0::0:0", -- Boar Ribs
	[2678]="10:7:1:20:Other:185:5:0:66,777,843,960,989,1148,1250,1286,1456,1465,1692,2118,2225,2393,2397,2664,2810,2821,3027,3081,3085,3168,3187,3367,3400,3482,3499,3556,3614,3779,3954,4194,4223,4229,4265,4553,4561,4775,4894,4897,5081,5100,5135,5160,5163,5483,5817,7947,8145,8307,8363,8934,9636,11189,12022,12028,12033,12043,12245,12941,12958,14738,15179,16224,16253,16261,16262,16613,16677,16718,16768,17246,17486,17490,18009,18426,18427,18987,18993,19195,19244,19371,19372,19450,20028,20096,20097,24834,24843,24935,25010,25012,25051,25052,25082,25089,26868,27021,27026,27043,27057,28692,28811,28831,28872,29288,29291,30311,31031,31032,32979,33595,34645,34681,34682,34683,34684,34685,35337,35338,35340,36695,36779,38783,38853,40474,41053,41275,41490,41676,41891,42853,43558,43980,44034,44186,44301,44341,44383,44780,45093,45286,45490,45497,45551,45552,46708,47104,47153,47164,47347,47721,47863,47939,48058,48060,48098,48123,48235,48551,48574,48580,48868,49787,49789,49885,54232:0:0", -- Mild Spices
	[2679]="0:0:1:20:FoodDrink::1:0::0:0", -- Charred Wolf Meat
	[2680]="0:0:1:20:FoodDrink::1:0::0:0", -- Spiced Wolf Meat
	[2681]="0:0:1:20:FoodDrink::1:0::0:0", -- Roasted Boar Meat
	[2682]="0:0:1:20:FoodDrink::1:0::0:0", -- Cooked Crab Claw
	[2683]="0:0:1:20:FoodDrink::1:0::0:0", -- Crab Cake
	[2684]="0:0:1:20:FoodDrink::1:0::0:0", -- Coyote Steak
	[2685]="0:0:1:20:FoodDrink::1:0::0:0", -- Succulent Pork Ribs
	[2686]="50:0:1:10:FoodDrink::1:0:1247,1682,7744,44006:0:0", -- Thunder Ale
	[2687]="0:0:1:20:FoodDrink::1:0::0:0", -- Dry Pork Ribs
	[2690]="0:4:1:1:Mail::1:0::3:0", -- Latched Belt
	[2691]="0:4:1:1:Mail::1:0::3:0", -- Outfitter Boots
	[2692]="0:15:0:20:Junk::1:0::0:0", -- Hot Spices
	[2694]="0:4:2:1:Mail::1:0::3:0", -- Settler's Leggings
	[2696]="0:12:1:1:::1:0::4:0", -- Cask of Evershine
	[2697]="400:9:1:1:Cooking::1:0:340:0:0", -- Recipe: Goretusk Liver Pie
	[2698]="400:9:1:1:Cooking::1:0:340:3:0", -- Recipe: Cooked Crab Claw
	[2699]="800:9:1:1:Cooking::1:0:340:0:0", -- Recipe: Redridge Goulash
	[2700]="400:9:1:1:Cooking::1:0:340:0:0", -- Recipe: Succulent Pork Ribs
	[2701]="1600:9:1:1:Cooking::1:0:340:0:0", -- Recipe: Seasoned Wolf Kabob
	[2702]="0:12:1:20:::1:0::4:0", -- Lightforge Ingot
	[2712]="0:12:1:1:::1:0::4:0", -- Crate of Lightforge Ingots
	[2713]="0:12:1:1:::1:0::4:0", -- Ol' Sooty's Head
	[2720]="0:12:1:1:::1:0::4:0", -- Muddy Note
	[2721]="0:4:3:1:Cloth::1:0::2:0", -- Holy Shroud
	[2722]="0:12:1:1:::1:0::4:0", -- Wine Ticket
	[2723]="50:0:1:20:FoodDrink::1:0:258,277,465,955,1301,1305,1311,1327,1328,1697,2832,5111,5112,5140,5570,5848,16442,17553,18542,18954,19186,19245,19617,23525,23606,24333,31017,33026,40832,43034,43997,44236,44299,44324,46995,47338,47363,47942,48064,48555,49729,53991:0:0", -- Bottle of Pinot Noir
	[2724]="0:12:1:1:::1:0::4:0", -- Cloth Request
	[2725]="0:12:1:10:::1:0::0:0", -- Green Hills of Stranglethorn - Page 1
	[2728]="0:12:1:10:::1:0::0:0", -- Green Hills of Stranglethorn - Page 4
	[2730]="0:12:1:10:::1:0::0:0", -- Green Hills of Stranglethorn - Page 6
	[2732]="0:12:1:10:::1:0::0:0", -- Green Hills of Stranglethorn - Page 8
	[2734]="0:12:1:10:::1:0::0:0", -- Green Hills of Stranglethorn - Page 10
	[2735]="0:12:1:10:::1:0::0:0", -- Green Hills of Stranglethorn - Page 11
	[2738]="0:12:1:10:::1:0::0:0", -- Green Hills of Stranglethorn - Page 14
	[2740]="0:12:1:10:::1:0::0:0", -- Green Hills of Stranglethorn - Page 16
	[2742]="0:12:1:10:::1:0::0:0", -- Green Hills of Stranglethorn - Page 18
	[2744]="0:12:1:10:::1:0::0:0", -- Green Hills of Stranglethorn - Page 20
	[2745]="0:12:1:10:::1:0::0:0", -- Green Hills of Stranglethorn - Page 21
	[2748]="0:12:1:10:::1:0::0:0", -- Green Hills of Stranglethorn - Page 24
	[2749]="0:12:1:10:::1:0::0:0", -- Green Hills of Stranglethorn - Page 25
	[2750]="0:12:1:10:::1:0::0:0", -- Green Hills of Stranglethorn - Page 26
	[2751]="0:12:1:10:::1:0::0:0", -- Green Hills of Stranglethorn - Page 27
	[2754]="0:2:1:1:TwoHandSword::1:0::0:0", -- Tarnished Bastard Sword
	[2756]="0:12:1:1:::1:0::4:0", -- Green Hills of Stranglethorn - Chapter I
	[2757]="0:12:1:1:::1:0::4:0", -- Green Hills of Stranglethorn - Chapter II
	[2758]="0:12:1:1:::1:0::4:0", -- Green Hills of Stranglethorn - Chapter III
	[2759]="0:12:1:1:::1:0::4:0", -- Green Hills of Stranglethorn - Chapter IV
	[2760]="0:12:1:1:::1:0::4:0", -- Thurman's Sewing Kit
	[2763]="0:2:0:1:Dagger::1:0::0:0", -- Fisherman Knife
	[2764]="0:2:0:1:Dagger::1:0::0:0", -- Small Dagger
	[2765]="0:2:0:1:Dagger::1:0::0:0", -- Hunting Knife
	[2766]="0:2:0:1:Dagger::1:0::0:0", -- Deft Stiletto
	[2770]="20:7:1:20:MetalStone:186:1:1:16224:0:0", -- Copper Ore
	[2771]="100:7:1:20:MetalStone:186:1:1:16224:0:0", -- Tin Ore
	[2772]="0:7:1:20:MetalStone:333,186:1:0::0:0", -- Iron Ore
	[2773]="0:2:0:1:Bow::1:0::0:0", -- Cracked Shortbow
	[2774]="0:2:0:1:Gun::1:0::0:0", -- Rust-Covered Blunderbuss
	[2775]="300:7:2:20:MetalStone:186:1:1:16224:0:0", -- Silver Ore
	[2776]="0:7:2:20:MetalStone:186:1:0::0:0", -- Gold Ore
	[2777]="0:2:0:1:Bow::1:0::0:0", -- Feeble Shortbow
	[2778]="0:2:0:1:Gun::1:0::0:0", -- Cheap Blunderbuss
	[2779]="0:12:1:1:::1:0::4:0", -- Tear of Tilloa
	[2780]="0:2:0:1:Bow::1:0::0:0", -- Light Hunting Bow
	[2781]="0:2:0:1:Gun::1:0::0:0", -- Dirty Blunderbuss
	[2782]="0:2:0:1:Bow::1:0::0:0", -- Mishandled Recurve Bow
	[2783]="0:2:0:1:Gun::1:0::0:0", -- Shoddy Blunderbuss
	[2784]="0:12:1:1:::1:0::4:0", -- Musquash Root
	[2785]="0:2:0:1:Bow::1:0::0:0", -- Stiff Recurve Bow
	[2786]="0:2:0:1:Gun::1:0::0:0", -- Oiled Blunderbuss
	[2787]="0:2:1:1:Dagger::1:0::0:0", -- Trogg Dagger
	[2788]="0:12:1:1:::1:0::4:0", -- Black Claw Stout
	[2794]="0:12:1:1:::1:0::3:0", -- An Old History Book
	[2795]="0:12:1:1:::1:0::4:0", -- Book: Stresses of Iron
	[2797]="0:12:1:1:::1:0::4:0", -- Heart of Mokk
	[2798]="0:12:1:20:::1:0::0:0", -- Rethban Ore
	[2799]="0:12:1:20:::1:0::0:0", -- Gorilla Fang
	[2800]="0:4:3:1:Cloth::1:0::2:0", -- Black Velvet Robes
	[2801]="0:2:4:1:TwoHandSword::1:0::2:0", -- Blade of Hanna
	[2802]="0:4:3:1:Trinket::1:0::2:0", -- Blazing Emblem
	[2805]="0:4:2:1:Cloak::1:0::3:0", -- Yeti Fur Cloak
	[2806]="0:12:1:1:::1:0::4:0", -- Package for Stormpike
	[2807]="0:2:3:1:OneHandAxe::1:0::2:0", -- Guillotine Axe
	[2815]="0:2:3:1:OneHandAxe::1:0::2:0", -- Curve-Bladed Ripper
	[2816]="0:2:3:1:OneHandMace::1:0::3:0", -- Death Speaker Scepter
	[2817]="0:4:1:1:Leather::1:0::3:0", -- Hard Leather Tunic
	[2818]="0:4:2:1:Leather::1:0::3:0", -- Stretched Leather Trousers
	[2819]="0:2:2:1:Dagger::1:0::2:0", -- Cross Dagger
	[2820]="0:4:2:1:Trinket::1:0::3:0", -- Nifty Stopwatch
	[2821]="0:2:2:1:OneHandMace::1:0::2:0", -- Mo'grosh Masher
	[2822]="0:2:2:1:TwoHandSword::1:0::2:0", -- Mo'grosh Toothpick
	[2823]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Mo'grosh Can Opener
	[2824]="0:2:4:1:Bow::1:0::2:0", -- Hurricane
	[2825]="0:2:4:1:Bow::1:0::2:0", -- Bow of Searing Arrows
	[2828]="0:12:1:1:::1:0::4:0", -- Nissa's Remains
	[2829]="0:12:1:1:::1:0::4:0", -- Gregor's Remains
	[2830]="0:12:1:1:::1:0::4:0", -- Thurman's Remains
	[2831]="0:12:1:1:::1:0::4:0", -- Devlin's Remains
	[2832]="0:12:1:1:::1:0::4:0", -- Verna's Westfall Stew Recipe
	[2833]="0:12:1:1:::1:0::4:0", -- The Lich's Spellbook
	[2834]="0:12:1:20:::1:0::4:0", -- Embalming Ichor
	[2835]="0:7:1:20:MetalStone:164,202,755:1:0::0:0", -- Rough Stone
	[2836]="0:7:1:20:MetalStone:164,202,755:1:0::0:0", -- Coarse Stone
	[2837]="0:12:1:1:::1:0::4:0", -- Thurman's Letter
	[2838]="0:7:1:20:MetalStone:164,202,755:1:0::0:0", -- Heavy Stone
	[2839]="0:12:1:1:::1:0::3:0", -- A Letter to Yvette
	[2840]="0:7:1:20:MetalStone:164,202,755,165,186:1:0::0:0", -- Copper Bar
	[2841]="0:7:1:20:MetalStone:164,202,755:1:0::0:0", -- Bronze Bar
	[2842]="0:7:2:20:MetalStone:164,202,755:1:0::0:0", -- Silver Bar
	[2843]="0:12:1:20:::1:0::4:0", -- Dirty Knucklebones
	[2844]="0:2:1:1:OneHandMace::1:0::0:0", -- Copper Mace
	[2845]="0:2:1:1:OneHandAxe::1:0::0:0", -- Copper Axe
	[2846]="0:12:1:20:::1:0::4:0", -- Tirisfal Pumpkin
	[2847]="0:2:1:1:OneHandSword::1:0::0:0", -- Copper Shortsword
	[2848]="0:2:2:1:OneHandMace::1:0::2:0", -- Bronze Mace
	[2849]="0:2:2:1:OneHandAxe::1:0::2:0", -- Bronze Axe
	[2850]="0:2:2:1:OneHandSword::1:0::2:0", -- Bronze Shortsword
	[2851]="0:4:1:1:Mail::1:0::0:0", -- Copper Chain Belt
	[2852]="0:4:1:1:Mail::1:0::0:0", -- Copper Chain Pants
	[2853]="0:4:1:1:Mail::1:0::0:0", -- Copper Bracers
	[2854]="0:4:2:1:Mail::1:0::2:0", -- Runed Copper Bracers
	[2855]="0:12:1:20:::1:0::4:0", -- Putrid Claw
	[2856]="0:12:1:20:::1:0::4:0", -- Iron Pike
	[2857]="0:4:2:1:Mail::1:0::2:0", -- Runed Copper Belt
	[2858]="0:12:1:20:::1:0::4:0", -- Darkhound Blood
	[2859]="0:12:1:20:::1:0::4:0", -- Vile Fin Scale
	[2862]="0:0:1:20:EnhTemp::1:0::0:0", -- Rough Sharpening Stone
	[2863]="0:0:1:20:EnhTemp::1:0::0:0", -- Coarse Sharpening Stone
	[2864]="0:4:2:1:Mail::1:0::2:0", -- Runed Copper Breastplate
	[2865]="0:4:2:1:Mail::1:0::2:0", -- Rough Bronze Leggings
	[2866]="0:4:2:1:Mail::1:0::2:0", -- Rough Bronze Cuirass
	[2867]="0:4:2:1:Mail::1:0::2:0", -- Rough Bronze Bracers
	[2868]="0:4:2:1:Mail::1:0::2:0", -- Patterned Bronze Bracers
	[2869]="0:4:2:1:Mail::1:0::2:0", -- Silvered Bronze Breastplate
	[2870]="0:4:3:1:Mail::1:0::2:0", -- Shining Silver Breastplate
	[2871]="0:0:1:20:EnhTemp::1:0::0:0", -- Heavy Sharpening Stone
	[2872]="0:12:1:20:::1:0::4:0", -- Vicious Night Web Spider Venom
	[2875]="0:12:1:20:::1:0::4:0", -- Scarlet Insignia Ring
	[2876]="0:12:1:20:::1:0::4:0", -- Duskbat Pelt
	[2877]="0:2:3:1:TwoHandSword::1:0::2:0", -- Combatant Claymore
	[2878]="0:2:3:1:OneHandAxe::1:0::2:0", -- Bearded Boneaxe
	[2879]="0:4:3:1:OffHandFrill::1:0::2:0", -- Antipodean Rod
	[2880]="100:7:1:20:Other:164:1:0:66,372,777,790,843,960,989,1148,1250,1286,1448,1456,1465,1690,1692,1694,2118,2225,2393,2685,2687,2688,2810,2821,2844,2847,2999,3002,3081,3133,3167,3168,3187,3343,3356,3358,3367,3413,3477,3482,3495,3499,3556,3614,3779,3954,4194,4229,4256,4257,4259,4561,4587,4597,4599,4775,4888,4897,4941,5100,5135,5163,5175,5411,5512,5514,5519,5817,6777,7947,8145,8161,8176,8363,8679,8934,9636,9676,11185,11186,11189,12022,12028,12043,12245,12941,12958,14337,14624,14637,14737,15176,15179,15400,16224,16261,16262,16376,16583,16613,16657,16664,16670,16713,16751,16768,16782,16823,17222,17245,17421,17486,17490,17655,18009,18278,18426,18427,18484,18752,18775,19011,19012,19056,19244,19342,19372,19383,19450,19520,19530,19662,19879,20082,20463,20890,20981,22264,22476,23144,23908,24052,24843,24935,25010,25051,25082,26081,26599,26600,26898,26934,27019,27021,27026,27043,27045,27057,27062,27134,27267,27711,28344,28692,28716,28722,28728,28796,28797,28831,28872,29252,29253,29288,29688,29907,29923,29964,29969,30241,30253,30311,30336,30345,30434,30436,30825,31024,31776,31781,32594,32979,33231,33594,33599,33631,33634,33640,33669,33675,33677,33682,36695,36779,37904,37935,38783,38853,40474,41053,41054,41274,41275,41435,41490,41493,41675,41676,41890,41891,42488,42676,42853,42876,42909,42972,43410,43548,43558,43564,43615,43625,43705,43708,43709,43710,43711,43772,43882,43980,43998,44005,44022,44034,44181,44186,44194,44195,44279,44280,44301,44305,44311,44337,44341,44377,44383,44780,45093,45148,45286,45293,45294,45451,45490,45497,45546,45549,45552,45843,46358,46359,46702,47059,47104,47153,47164,47267,47286,47340,47347,47530,47532,47721,47863,47864,47937,47939,48056,48057,48058,48090,48098,48123,48228,48235,48238,48251,48258,48356,48551,48573,48574,48868,49409,49433,49549,49575,49592,49605,49695,49702,49726,49756,49768,49788,49800,49885,49918,50129,50460,52637,52641,52643,52655,53409,53421:0:0", -- Weak Flux
	[2881]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Runed Copper Breastplate
	[2882]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Silvered Bronze Shoulders
	[2883]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Deadly Bronze Poniard
	[2885]="0:12:1:1:::1:0::4:0", -- Scarlet Crusade Documents
	[2886]="0:7:1:20:Meat:185:1:0::0:0", -- Crag Boar Rib
	[2888]="0:0:1:20:FoodDrink::1:0::0:0", -- Beer Basted Boar Ribs
	[2889]="240:9:1:1:Cooking::1:0:340:0:0", -- Recipe: Beer Basted Boar Ribs
	[2892]="100:0:1:20:EnhTemp::1:0:1325,1326,2622,3090,3135,3334,3405,3490,3551,3561,3969,4585,5139,5169,6779,10364,12096,15175,16268,16588,16683,16829,18006,18019,18802,19013,19014,19049,19239,19679,20081,20121,20194,20915,20986,22479,23145,23373,23732,24148,24313,24357,24780,25043,25736,26382,26568,26598,26900,26945,27031,27038,27053,27089,27133,27149,27176,27186,28347,28832,28869,29015,29037,29535,29561,29909,29922,29947,29961,30010,30244,30306,30438,31115,32639,32641,33630,33674,35642,39144,39878,41275,41490,41508,41676,41891,42622,42878,42910,42967,43155,43381,43411,43493,43547,43551,43555,43563,43646,43774,44047,44187,44313,44333,44970,45289,45290,45361,47860,53040,53076:0:0", -- Deadly Poison
	[2893]="0:0:1:20:EnhTemp::1:0::0:0", -- Deadly Poison
	[2894]="50:0:1:10:FoodDrink::1:0:1247,1682,7744,44006:0:0", -- Rhapsody Malt
	[2898]="0:4:1:1:Mail::1:0::0:0", -- Mountaineer Chestpiece
	[2899]="0:4:2:1:Leather::1:0::2:0", -- Wendigo Collar
	[2900]="0:4:1:1:Shield::1:0::3:0", -- Stone Buckler
	[2901]="81:2:1:1:Miscellaneous:202:1:0:66,372,777,790,843,960,989,1148,1250,1286,1448,1456,1465,1690,1692,1694,2118,2225,2393,2685,2687,2688,2810,2821,2844,2847,2999,3002,3081,3133,3167,3168,3187,3343,3356,3358,3367,3413,3477,3482,3495,3499,3556,3614,3779,3954,4194,4229,4256,4257,4259,4561,4587,4597,4599,4775,4888,4897,4941,5100,5135,5163,5175,5411,5512,5514,5519,5817,6777,7947,8145,8161,8176,8363,8679,8934,9636,9676,11185,11186,11189,12022,12028,12043,12245,12941,12958,14337,14624,14637,14737,15176,15179,15400,16224,16261,16262,16376,16583,16613,16657,16664,16670,16713,16751,16768,16782,16823,17222,17245,17421,17486,17490,17655,18009,18278,18426,18427,18484,18752,18775,19011,19012,19056,19244,19342,19372,19383,19450,19520,19530,19575,19661,19662,19879,20082,20463,20890,20981,21112,22264,22476,23144,23908,24052,24843,24935,25010,25051,25082,26081,26599,26600,26898,26934,27019,27021,27026,27043,27045,27057,27062,27134,27267,27711,28344,28692,28716,28722,28728,28796,28797,28831,28872,29252,29253,29288,29688,29907,29923,29964,29969,30241,30253,30311,30336,30345,30434,30436,30825,31024,31776,31781,32594,32979,33231,33594,33599,33631,33634,33640,33669,33675,33677,33682,36695,36779,37904,37935,38783,38853,40474,41053,41054,41274,41275,41435,41490,41493,41675,41676,41890,41891,42488,42676,42853,42876,42909,42972,43410,43548,43558,43564,43615,43625,43705,43708,43709,43710,43711,43772,43882,43980,43998,44005,44022,44034,44181,44186,44194,44195,44279,44280,44301,44305,44311,44337,44341,44377,44383,44780,45093,45148,45286,45293,45294,45451,45490,45497,45546,45549,45552,45843,46358,46359,46702,47059,47104,47153,47164,47267,47286,47340,47347,47530,47532,47721,47863,47864,47937,47939,48056,48057,48058,48090,48098,48123,48228,48235,48238,48251,48258,48356,48551,48573,48574,48868,49409,49433,49549,49575,49592,49605,49695,49702,49726,49756,49768,49788,49800,49885,49918,50129,50460,52637,52641,52643,52655,53409,53421:0:0", -- Mining Pick
	[2902]="0:4:2:1:Cloak::1:0::3:0", -- Cloak of the Faith
	[2903]="0:2:2:1:Bow::1:0::3:0", -- Daryl's Hunting Bow
	[2904]="0:2:2:1:Gun::1:0::3:0", -- Daryl's Hunting Rifle
	[2905]="0:4:1:1:Cloak::1:0::3:0", -- Goat Fur Cloak
	[2906]="0:4:2:1:Mail::1:0::3:0", -- Darkshire Mail Leggings
	[2907]="0:2:2:1:TwoHandAxe::1:0::3:0", -- Dwarven Tree Chopper
	[2908]="0:2:2:1:Dagger::1:0::3:0", -- Thornblade
	[2909]="0:12:1:20:::1:0::4:0", -- Red Wool Bandana
	[2910]="0:4:2:1:Mail::1:0::3:0", -- Gold Militia Boots
	[2911]="0:4:3:1:Cloth::1:0::2:0", -- Keller's Girdle
	[2912]="0:2:3:1:Dagger::1:0::2:0", -- Claw of the Shadowmancer
	[2913]="0:4:2:1:Cloth::1:0::3:0", -- Silk Mantle of Gamn
	[2915]="0:2:4:1:TwoHandMace::1:0::2:0", -- Taran Icebreaker
	[2916]="0:4:2:1:Shield::1:0::3:0", -- Gold Lion Shield
	[2917]="0:4:2:1:Ring::1:0::3:0", -- Tranquil Ring
	[2924]="0:7:1:20:Meat:185:1:0::0:0", -- Crocolisk Meat
	[2925]="0:12:1:20:::1:0::4:0", -- Crocolisk Skin
	[2926]="0:12:1:1:::1:0::4:0", -- Head of Bazil Thredd
	[2928]="0:15:0:20:Junk::1:0::0:0", -- Dust of Decay
	[2929]="0:7:1:10:Other::1:0::0:0", -- Tomb Rot
	[2930]="0:15:0:20:Junk::1:0::0:0", -- Essence of Pain
	[2931]="0:15:0:20:Junk::1:0::0:0", -- Maiden's Anguish
	[2933]="0:4:3:1:Ring::1:0::3:0", -- Seal of Wrynn
	[2934]="0:7:1:20:Leather:165:1:0::0:0", -- Ruined Leather Scraps
	[2939]="0:12:1:1:::1:0::4:0", -- Frenzy Blood
	[2940]="0:15:0:20:Junk::1:0::0:0", -- Bloody Bear Paw
	[2941]="0:2:3:1:Dagger::1:0::3:0", -- Prison Shank
	[2942]="0:2:3:1:FistWeapon::1:0::3:0", -- Iron Knuckles
	[2943]="0:4:2:1:OffHandFrill::1:0::3:0", -- Eye of Paleth
	[2944]="0:4:2:1:OffHandFrill::1:0::3:0", -- Cursed Eye of Paleth
	[2946]="0:15:1:200:Junk::1:0::0:0", -- Broken Balanced Throwing Dagger
	[2947]="0:15:1:200:Junk::1:0::0:0", -- Broken Small Throwing Knife
	[2949]="0:4:2:1:Leather::1:0::3:0", -- Mariner Boots
	[2950]="0:2:2:1:Stave::1:0::3:0", -- Icicle Rod
	[2951]="0:4:3:1:Ring::1:0::2:0", -- Ring of the Underwood
	[2953]="0:4:2:1:Cloak::1:0::3:0", -- Watch Master's Cloak
	[2954]="0:4:2:1:Cloth::1:0::3:0", -- Night Watch Pantaloons
	[2955]="0:4:2:1:Cloth::1:0::2:0", -- First Mate Hat
	[2956]="0:12:1:1:::1:0::4:0", -- Report on the Defias Brotherhood
	[2957]="0:4:2:1:Cloth::1:0::2:0", -- Journeyman's Vest
	[2958]="0:4:2:1:Cloth::1:0::2:0", -- Journeyman's Pants
	[2959]="0:4:1:1:Cloth::1:0::0:0", -- Journeyman's Boots
	[2960]="0:4:1:1:Cloth::1:0::0:0", -- Journeyman's Gloves
	[2961]="0:4:2:1:Leather::1:0::2:0", -- Burnt Leather Vest
	[2962]="0:4:2:1:Leather::1:0::2:0", -- Burnt Leather Breeches
	[2963]="0:4:1:1:Leather::1:0::0:0", -- Burnt Leather Boots
	[2964]="0:4:1:1:Leather::1:0::0:0", -- Burnt Leather Gloves
	[2965]="0:4:2:1:Mail::1:0::2:0", -- Warrior's Tunic
	[2966]="0:4:2:1:Mail::1:0::2:0", -- Warrior's Pants
	[2967]="0:4:1:1:Mail::1:0::0:0", -- Warrior's Boots
	[2968]="0:4:1:1:Mail::1:0::0:0", -- Warrior's Gloves
	[2969]="0:4:2:1:Cloth::1:0::2:0", -- Spellbinder Vest
	[2970]="0:4:2:1:Cloth::1:0::2:0", -- Spellbinder Pants
	[2971]="0:4:1:1:Cloth::1:0::0:0", -- Spellbinder Boots
	[2972]="0:4:1:1:Cloth::1:0::0:0", -- Spellbinder Gloves
	[2973]="0:4:2:1:Leather::1:0::2:0", -- Hunting Tunic
	[2974]="0:4:2:1:Leather::1:0::2:0", -- Hunting Pants
	[2975]="0:4:1:1:Leather::1:0::0:0", -- Hunting Boots
	[2976]="0:4:2:1:Leather::1:0::2:0", -- Hunting Gloves
	[2977]="0:4:2:1:Mail::1:0::2:0", -- Veteran Armor
	[2978]="0:4:2:1:Mail::1:0::2:0", -- Veteran Leggings
	[2979]="0:4:1:1:Mail::1:0::0:0", -- Veteran Boots
	[2980]="0:4:2:1:Mail::1:0::2:0", -- Veteran Gloves
	[2981]="0:4:2:1:Cloth::1:0::2:0", -- Seer's Robe
	[2982]="0:4:2:1:Cloth::1:0::2:0", -- Seer's Pants
	[2983]="0:4:2:1:Cloth::1:0::2:0", -- Seer's Boots
	[2984]="0:4:2:1:Cloth::1:0::2:0", -- Seer's Gloves
	[2985]="0:4:2:1:Leather::1:0::2:0", -- Inscribed Leather Breastplate
	[2986]="0:4:2:1:Leather::1:0::2:0", -- Inscribed Leather Pants
	[2987]="0:4:2:1:Leather::1:0::2:0", -- Inscribed Leather Boots
	[2988]="0:4:2:1:Leather::1:0::2:0", -- Inscribed Leather Gloves
	[2989]="0:4:2:1:Mail::1:0::2:0", -- Burnished Tunic
	[2990]="0:4:2:1:Mail::1:0::2:0", -- Burnished Leggings
	[2991]="0:4:2:1:Mail::1:0::2:0", -- Burnished Boots
	[2992]="0:4:2:1:Mail::1:0::2:0", -- Burnished Gloves
	[2996]="160:7:1:20:Cloth:197:1:1:16631:0:0", -- Bolt of Linen Cloth
	[2997]="400:7:1:20:Cloth:165,197:1:1:16631:0:0", -- Bolt of Woolen Cloth
	[2998]="0:12:1:1:::1:0::4:0", -- A Simple Compass
	[2999]="0:12:1:1:::1:0::4:0", -- Steelgrill's Tools
	[3000]="0:4:2:1:Leather::1:0::2:0", -- Brood Mother Carapace
	[3008]="0:4:1:1:Cloak::1:0::0:0", -- Wendigo Fur Cloak
	[3010]="0:15:0:20:Junk::1:0::0:0", -- Fine Sand
	[3011]="0:4:2:1:Leather::1:0::2:0", -- Feathered Headdress
	[3012]="200:0:1:20:Scroll::1:1:958,1316,2805,4581,14847,16224:0:0", -- Scroll of Agility
	[3013]="100:0:1:20:Scroll::1:1:958,1316,4581,14847,16224:0:0", -- Scroll of Protection
	[3014]="0:12:1:20:::1:0::4:0", -- Battleworn Axe
	[3016]="0:12:1:1:::1:0::4:0", -- Gunther's Spellbook
	[3017]="0:12:1:1:::1:0::4:0", -- Sevren's Orders
	[3018]="0:4:2:1:Cloak::1:0::2:0", -- Hide of Lupos
	[3019]="0:4:3:1:Cloth::1:0::2:0", -- Noble's Robe
	[3020]="0:4:3:1:Leather::1:0::2:0", -- Enduring Cap
	[3021]="0:2:3:1:Bow::1:0::2:0", -- Ranger Bow
	[3023]="3772:2:1:1:Gun::1:0:1297,1461,1686,3018,3088,3322,4603,4889,5123,8131,9548,11184,16274,16620,16735,41452,44040,44178,47166,49729,49920:0:0", -- Large Bore Blunderbuss
	[3024]="7098:2:1:1:Gun::1:0:1297,1461,3018,3322,4603,4889,5123,8131,9548,11184,16620,16735,41452,44040,44178,47166,49729,49920:0:0", -- BKP 2700 "Enforcer"
	[3025]="18479:2:1:1:Gun::1:0:3322,8131,9548,11184,19836,22491,29945,44040,44178,47166,49729,49920:0:0", -- BKP 42 "Ultra"
	[3026]="3812:2:1:1:Bow::1:0:228,789,1297,1298,1459,1462,1668,1687,2839,3015,3322,3409,3488,3951,4173,4203,4604,4892,5122,9548,9549,9552,9553,9555,12029,16263,16274,16619,16715,17667,19020,19561,24028,27055,40967,41452,44040,49605:0:0", -- Reinforced Bow
	[3027]="6349:2:1:1:Bow::1:0:228,1297,1298,1462,2839,3015,3322,4173,4604,4892,5122,9548,9552,9555,12029,16263,16274,16619,16715,17667,19020,19561,24028,27055,40967,41452,44040,49605:0:0", -- Heavy Recurve Bow
	[3030]="0:15:0:1000:Junk::1:0::0:0", -- Razor Arrow
	[3033]="0:15:0:1000:Junk::1:0::0:0", -- Solid Shot
	[3035]="0:12:1:1:::1:0::4:0", -- Laced Pumpkin
	[3036]="0:2:2:1:Bow::1:0::2:0", -- Heavy Shortbow
	[3037]="0:2:2:1:Bow::1:0::2:0", -- Whipwood Recurve Bow
	[3039]="0:2:2:1:Bow::1:0::2:0", -- Short Ash Bow
	[3040]="0:2:2:1:Gun::1:0::2:0", -- Hunter's Muzzle Loader
	[3041]="0:2:2:1:Gun::1:0::2:0", -- "Mage-Eye" Blunderbuss
	[3042]="0:2:2:1:Gun::1:0::2:0", -- BKP "Sparrow" Smallbore
	[3045]="0:4:2:1:Mail::1:0::2:0", -- Lambent Scale Boots
	[3047]="0:4:2:1:Mail::1:0::2:0", -- Lambent Scale Gloves
	[3048]="0:4:2:1:Mail::1:0::2:0", -- Lambent Scale Legguards
	[3049]="0:4:2:1:Mail::1:0::2:0", -- Lambent Scale Breastplate
	[3053]="0:4:2:1:Mail::1:0::2:0", -- Humbert's Chestpiece
	[3055]="0:4:2:1:Leather::1:0::2:0", -- Forest Leather Chestpiece
	[3056]="0:4:2:1:Leather::1:0::2:0", -- Forest Leather Pants
	[3057]="0:4:2:1:Leather::1:0::2:0", -- Forest Leather Boots
	[3058]="0:4:2:1:Leather::1:0::2:0", -- Forest Leather Gloves
	[3065]="0:4:2:1:Cloth::1:0::2:0", -- Bright Boots
	[3066]="0:4:2:1:Cloth::1:0::2:0", -- Bright Gloves
	[3067]="0:4:2:1:Cloth::1:0::2:0", -- Bright Pants
	[3069]="0:4:2:1:Cloth::1:0::2:0", -- Bright Robe
	[3070]="0:4:1:1:Cloak::1:0::3:0", -- Ensign Cloak
	[3071]="0:2:1:1:OneHandAxe::1:0::3:0", -- Striking Hatchet
	[3072]="0:4:2:1:Cloth::1:0::2:0", -- Smoldering Robe
	[3073]="0:4:2:1:Cloth::1:0::2:0", -- Smoldering Pants
	[3074]="0:4:2:1:Cloth::1:0::2:0", -- Smoldering Gloves
	[3075]="0:4:4:1:Cloth::1:0::2:0", -- Eye of Flame
	[3076]="0:4:2:1:Cloth::1:0::2:0", -- Smoldering Boots
	[3078]="0:2:3:1:Bow::1:0::3:0", -- Naga Heartpiercer
	[3079]="0:2:2:1:Gun::1:0::3:0", -- Skorn's Rifle
	[3080]="0:12:1:1:::1:0::4:0", -- Candle of Beckoning
	[3081]="0:12:1:1:::1:0::4:0", -- Nether Gem
	[3082]="0:12:1:1:::1:0::3:0", -- Dargol's Skull
	[3083]="0:12:1:20:::1:0::4:0", -- Restabilization Cog
	[3084]="0:12:1:20:::1:0::4:0", -- Gyromechanic Gear
	[3085]="0:12:1:1:::1:0::4:0", -- Barrel of Shimmer Stout
	[3086]="0:12:1:1:::1:0::4:0", -- Cask of Shimmer Stout
	[3087]="0:0:1:20:Potion::1:0::0:0", -- Mug of Shimmer Stout
	[3103]="0:2:2:1:TwoHandMace::1:0::3:0", -- Coldridge Hammer
	[3107]="0:15:1:200:Junk::1:0::0:0", -- Broken Keen Throwing Knife
	[3108]="0:15:1:200:Junk::1:0::0:0", -- Broken Heavy Throwing Dagger
	[3110]="0:12:1:20:::1:0::4:0", -- Tunnel Rat Ear
	[3111]="0:15:1:200:Junk::1:0::0:0", -- Broken Crude Throwing Axe
	[3117]="0:12:1:1:::1:0::4:0", -- Hildelve's Journal
	[3131]="0:15:1:200:Junk::1:0::0:0", -- Broken Weighted Throwing Axe
	[3135]="0:15:1:200:Junk::1:0::0:0", -- Broken Sharp Throwing Axe
	[3137]="0:15:1:200:Junk::1:0::0:0", -- Broken Deadly Throwing Axe
	[3151]="0:4:1:1:Mail::1:0::3:0", -- Siege Brigade Vest
	[3152]="0:4:1:1:Leather::1:0::3:0", -- Driving Gloves
	[3153]="0:4:1:1:Cloak::1:0::3:0", -- Oil-Stained Cloak
	[3154]="0:2:2:1:OneHandAxe::1:0::3:0", -- Thelsamar Axe
	[3155]="0:12:1:1:::1:0::4:0", -- Remedy of Arugal
	[3156]="0:12:1:20:::1:0::4:0", -- Glutton Shackle
	[3157]="0:12:1:20:::1:0::4:0", -- Darksoul Shackle
	[3158]="0:4:1:1:Leather::1:0::3:0", -- Burnt Hide Bracers
	[3160]="0:4:2:1:Shield::1:0::3:0", -- Ironplate Buckler
	[3161]="0:4:2:1:Cloth::1:0::3:0", -- Robe of the Keeper
	[3162]="0:12:1:20:::1:0::4:0", -- Notched Rib
	[3163]="0:12:1:20:::1:0::4:0", -- Blackened Skull
	[3164]="0:7:1:10:Other:171:1:0::0:0", -- Discolored Worg Heart
	[3165]="0:12:1:1:::1:0::4:0", -- Quinn's Potion
	[3166]="0:4:2:1:Mail::1:0::3:0", -- Ironheart Chain
	[3167]="0:15:0:20:Junk::1:0::0:0", -- Thick Spider Hair
	[3169]="0:15:0:20:Junk::1:0::0:0", -- Chipped Bear Tooth
	[3170]="0:15:0:20:Junk::1:0::0:0", -- Large Bear Tooth
	[3171]="0:15:0:20:Junk::1:0::0:0", -- Broken Boar Tusk
	[3172]="0:7:0:20:Meat::1:0::0:0", -- Boar Intestines
	[3173]="0:7:1:20:Meat:185:1:0::0:0", -- Bear Meat
	[3174]="0:7:0:20:Meat::1:0::0:0", -- Spider Ichor
	[3175]="0:15:0:20:Junk::1:0::0:0", -- Ruined Dragonhide
	[3176]="0:15:0:20:Junk::1:0::0:0", -- Small Claw
	[3177]="0:15:0:20:Junk::1:0::0:0", -- Tiny Fang
	[3179]="0:15:0:20:Junk::1:0::0:0", -- Cracked Dragon Molting
	[3180]="0:15:0:20:Junk::1:0::0:0", -- Flecked Raptor Scale
	[3181]="0:15:0:20:Junk::1:0::0:0", -- Partially Digested Meat
	[3182]="0:7:1:10:Cloth:165,197:1:0::0:0", -- Spider's Silk
	[3183]="0:12:1:1:::1:0::4:0", -- Mangy Claw
	[3184]="0:2:2:1:Dagger::1:0::2:0", -- Hook Dagger
	[3185]="0:2:2:1:Stave::1:0::2:0", -- Acrobatic Staff
	[3186]="0:2:2:1:OneHandSword::1:0::2:0", -- Viking Sword
	[3187]="0:2:2:1:Dagger::1:0::2:0", -- Sacrificial Kris
	[3188]="0:2:2:1:TwoHandSword::1:0::2:0", -- Coral Claymore
	[3189]="0:2:1:1:TwoHandAxe::1:0::0:0", -- Wood Chopper
	[3190]="0:2:1:1:TwoHandMace::1:0::0:0", -- Beatstick
	[3191]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Arced War Axe
	[3192]="0:2:2:1:TwoHandSword::1:0::2:0", -- Short Bastard Sword
	[3193]="0:2:2:1:TwoHandMace::1:0::2:0", -- Oak Mallet
	[3194]="0:2:3:1:TwoHandMace::1:0::2:0", -- Black Malice
	[3195]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Barbaric Battle Axe
	[3196]="0:2:2:1:TwoHandSword::1:0::2:0", -- Edged Bastard Sword
	[3197]="0:2:2:1:TwoHandSword::1:0::2:0", -- Stonecutter Claymore
	[3198]="0:2:2:1:TwoHandMace::1:0::2:0", -- Battering Hammer
	[3199]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Battle Slayer
	[3200]="0:4:1:1:Leather::1:0::0:0", -- Burnt Leather Bracers
	[3201]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Barbarian War Axe
	[3202]="0:4:2:1:Leather::1:0::2:0", -- Forest Leather Bracers
	[3203]="0:2:3:1:TwoHandMace::1:0::2:0", -- Dense Triangle Mace
	[3204]="0:4:2:1:Leather::1:0::2:0", -- Deepwood Bracers
	[3205]="0:4:2:1:Leather::1:0::2:0", -- Inscribed Leather Bracers
	[3206]="0:2:2:1:TwoHandSword::1:0::2:0", -- Cavalier Two-Hander
	[3207]="0:4:1:1:Leather::1:0::0:0", -- Hunting Bracers
	[3208]="0:2:2:1:TwoHandMace::1:0::2:0", -- Conk Hammer
	[3209]="0:2:2:1:TwoHandSword::1:0::3:0", -- Ancient War Sword
	[3210]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Brutal War Axe
	[3211]="0:4:2:1:Mail::1:0::2:0", -- Burnished Bracers
	[3212]="0:4:2:1:Mail::1:0::2:0", -- Lambent Scale Bracers
	[3213]="0:4:1:1:Mail::1:0::0:0", -- Veteran Bracers
	[3214]="0:4:1:1:Mail::1:0::0:0", -- Warrior's Bracers
	[3216]="0:4:1:1:Cloth::1:0::3:0", -- Warm Winter Robe
	[3217]="0:4:2:1:Cloth::1:0::3:0", -- Foreman Belt
	[3218]="0:12:1:20:::1:0::4:0", -- Pyrewood Shackle
	[3220]="0:0:1:20:FoodDrink::1:0::0:0", -- Blood Sausage
	[3223]="0:2:2:1:OneHandMace::1:0::2:0", -- Frostmane Scepter
	[3224]="0:4:1:1:Cloth::1:0::0:0", -- Silver-Lined Bracers
	[3225]="0:2:1:1:Dagger::1:0::0:0", -- Bloodstained Knife
	[3227]="0:2:2:1:Stave::1:0::2:0", -- Nightbane Staff
	[3228]="0:4:3:1:Mail::1:0::3:0", -- Jimmied Handcuffs
	[3229]="0:4:2:1:Cloth::1:0::2:0", -- Tarantula Silk Sash
	[3230]="0:4:3:1:Leather::1:0::3:0", -- Black Wolf Bracers
	[3231]="0:4:2:1:Mail::1:0::2:0", -- Cutthroat Pauldrons
	[3233]="0:1:1:1:Bag::1:0::0:0", -- Gnoll Hide Sack
	[3234]="0:12:1:1:::1:0::4:0", -- Deliah's Ring
	[3235]="0:4:2:1:Ring::1:0::3:0", -- Ring of Scorn
	[3236]="0:12:1:20:::1:0::4:0", -- Rot Hide Ichor
	[3237]="0:12:1:1:::1:0::4:0", -- Sample Ichor
	[3238]="0:12:1:1:::1:0::4:0", -- Holland's Findings
	[3239]="0:0:1:20:EnhTemp::1:0::0:0", -- Rough Weightstone
	[3240]="0:0:1:20:EnhTemp::1:0::0:0", -- Coarse Weightstone
	[3241]="0:0:1:20:EnhTemp::1:0::0:0", -- Heavy Weightstone
	[3248]="0:12:1:1:::1:0::4:0", -- Translated Letter from The Embalmer
	[3250]="0:12:1:1:::1:0::4:0", -- Bethor's Scroll
	[3251]="0:12:1:1:::1:0::3:0", -- Bethor's Potion
	[3252]="0:12:1:1:::1:0::4:0", -- Deathstalker Report
	[3253]="0:12:1:20:::1:0::4:0", -- Grizzled Bear Heart
	[3254]="0:12:1:20:::1:0::4:0", -- Skittering Blood
	[3255]="0:12:1:1:::1:0::4:0", -- Berard's Journal
	[3256]="0:12:1:20:::1:0::4:0", -- Lake Skulker Moss
	[3257]="0:12:1:20:::1:0::4:0", -- Lake Creeper Moss
	[3258]="0:12:1:1:::1:0::4:0", -- Hardened Tumor
	[3260]="0:4:1:1:Cloth::1:0::0:0", -- Scarlet Initiate Robes
	[3261]="0:4:1:1:Cloak::1:0::0:0", -- Webbed Cloak
	[3262]="0:2:1:1:OneHandMace::1:0::0:0", -- Putrid Wooden Hammer
	[3263]="0:4:1:1:Cloth::1:0::0:0", -- Webbed Pants
	[3264]="0:12:1:20:::1:0::4:0", -- Duskbat Wing
	[3265]="0:12:1:20:::1:0::4:0", -- Scavenger Paw
	[3266]="0:12:1:20:::1:0::4:0", -- Scarlet Armband
	[3267]="0:2:1:1:OneHandSword::1:0::3:0", -- Forsaken Shortsword
	[3268]="0:2:1:1:Dagger::1:0::3:0", -- Forsaken Dagger
	[3269]="0:2:1:1:OneHandMace::1:0::3:0", -- Forsaken Maul
	[3270]="0:4:1:1:Cloth::1:0::3:0", -- Flax Vest
	[3272]="0:4:1:1:Leather::1:0::3:0", -- Zombie Skin Leggings
	[3273]="0:4:1:1:Mail::1:0::3:0", -- Rugged Mail Vest
	[3274]="0:4:1:1:Cloth::1:0::3:0", -- Flax Boots
	[3275]="0:4:1:1:Cloth::1:0::3:0", -- Flax Gloves
	[3276]="0:4:1:1:Shield::1:0::3:0", -- Deathguard Buckler
	[3277]="0:2:1:1:Stave::1:0::3:0", -- Executor Staff
	[3279]="0:4:1:1:Mail::1:0::0:0", -- Battle Chain Boots
	[3280]="0:4:1:1:Mail::1:0::0:0", -- Battle Chain Bracers
	[3281]="0:4:1:1:Mail::1:0::0:0", -- Battle Chain Gloves
	[3282]="0:4:2:1:Mail::1:0::2:0", -- Battle Chain Pants
	[3283]="0:4:2:1:Mail::1:0::2:0", -- Battle Chain Tunic
	[3284]="0:4:1:1:Leather::1:0::0:0", -- Tribal Boots
	[3285]="0:4:1:1:Leather::1:0::0:0", -- Tribal Bracers
	[3286]="0:4:1:1:Leather::1:0::0:0", -- Tribal Gloves
	[3287]="0:4:2:1:Leather::1:0::2:0", -- Tribal Pants
	[3288]="0:4:2:1:Leather::1:0::2:0", -- Tribal Vest
	[3289]="0:4:1:1:Cloth::1:0::0:0", -- Ancestral Boots
	[3290]="0:4:1:1:Cloth::1:0::0:0", -- Ancestral Gloves
	[3291]="0:4:2:1:Cloth::1:0::2:0", -- Ancestral Woollies
	[3292]="0:4:2:1:Cloth::1:0::2:0", -- Ancestral Tunic
	[3293]="0:2:1:1:OneHandAxe::1:0::0:0", -- Deadman Cleaver
	[3294]="0:2:1:1:OneHandMace::1:0::0:0", -- Deadman Club
	[3295]="0:2:1:1:OneHandSword::1:0::0:0", -- Deadman Blade
	[3296]="0:2:1:1:Dagger::1:0::0:0", -- Deadman Dagger
	[3297]="0:12:1:20:::1:0::4:0", -- Fel Moss
	[3299]="0:15:0:20:Junk::1:0::0:0", -- Fractured Canine
	[3300]="0:15:0:20:Junk::1:0::0:0", -- Rabbit's Foot
	[3301]="0:15:0:20:Junk::1:0::0:0", -- Sharp Canine
	[3302]="0:4:2:1:Mail::1:0::2:0", -- Brackwater Boots
	[3303]="0:4:1:1:Mail::1:0::0:0", -- Brackwater Bracers
	[3304]="0:4:1:1:Mail::1:0::0:0", -- Brackwater Gauntlets
	[3305]="0:4:2:1:Mail::1:0::2:0", -- Brackwater Leggings
	[3306]="0:4:2:1:Mail::1:0::2:0", -- Brackwater Vest
	[3307]="0:4:2:1:Cloth::1:0::2:0", -- Barbaric Cloth Boots
	[3308]="0:4:2:1:Cloth::1:0::2:0", -- Barbaric Cloth Gloves
	[3309]="0:4:2:1:Cloth::1:0::2:0", -- Barbaric Loincloth
	[3310]="0:4:2:1:Cloth::1:0::2:0", -- Barbaric Cloth Vest
	[3311]="0:4:1:1:Leather::1:0::0:0", -- Ceremonial Leather Ankleguards
	[3312]="0:4:1:1:Leather::1:0::0:0", -- Ceremonial Leather Bracers
	[3313]="0:4:2:1:Leather::1:0::2:0", -- Ceremonial Leather Harness
	[3314]="0:4:2:1:Leather::1:0::2:0", -- Ceremonial Leather Gloves
	[3315]="0:4:2:1:Leather::1:0::2:0", -- Ceremonial Leather Loincloth
	[3317]="0:12:1:1:::1:0::3:0", -- A Talking Head
	[3318]="0:12:1:1:::1:0::4:0", -- Alaric's Remains
	[3319]="0:2:1:1:OneHandSword::1:0::0:0", -- Short Sabre
	[3321]="0:4:1:1:Leather::1:0::0:0", -- Gray Fur Booties
	[3322]="0:4:1:1:Cloak::1:0::0:0", -- Wispy Cloak
	[3323]="0:4:1:1:Cloth::1:0::0:0", -- Ghostly Bracers
	[3324]="0:4:2:1:Cloth::1:0::3:0", -- Ghostly Mantle
	[3325]="0:2:1:1:TwoHandAxe::1:0::0:0", -- Vile Fin Battle Axe
	[3327]="0:2:1:1:Stave::1:0::0:0", -- Vile Fin Oracle Staff
	[3328]="0:4:1:1:Cloth::1:0::0:0", -- Spider Web Robe
	[3329]="0:2:1:1:OneHandMace::1:0::0:0", -- Spiked Wooden Plank
	[3330]="0:4:2:1:Mail::1:0::2:0", -- Dargol's Hauberk
	[3331]="0:4:1:1:Cloak::1:0::0:0", -- Melrache's Cape
	[3332]="0:4:1:1:Mail::1:0::0:0", -- Perrine's Boots
	[3334]="0:2:1:1:TwoHandMace::1:0::0:0", -- Farmer's Shovel
	[3335]="0:2:1:1:Stave::1:0::0:0", -- Farmer's Broom
	[3336]="0:2:2:1:Dagger::1:0::2:0", -- Flesh Piercer
	[3337]="0:12:1:20:::1:0::4:0", -- Dragonmaw War Banner
	[3339]="0:12:1:1:::1:0::4:0", -- Dwarven Tinder
	[3340]="0:12:1:10:::1:0::0:0", -- Incendicite Ore
	[3341]="0:4:2:1:Mail::1:0::2:0", -- Gauntlets of Ogre Strength
	[3342]="0:4:1:1:Shirt::1:0::3:0", -- Captain Sanders' Shirt
	[3343]="0:1:1:1:Bag::1:0::3:0", -- Captain Sanders' Booty Bag
	[3344]="0:4:2:1:Cloth::1:0::3:0", -- Captain Sanders' Sash
	[3345]="0:4:2:1:Cloth::1:0::2:0", -- Silk Wizard Hat
	[3347]="0:12:1:1:::1:0::4:0", -- Bundle of Crocolisk Skins
	[3348]="0:12:1:20:::1:0::4:0", -- Giant Crocolisk Skin
	[3349]="0:12:1:1:::1:0::4:0", -- Sida's Bag
	[3352]="0:1:1:1:Bag::1:0::3:0", -- Ooze-Covered Bag
	[3353]="0:12:1:1:::1:0::4:0", -- Rune-Inscribed Pendant
	[3354]="0:12:1:20:::1:0::4:0", -- Dalaran Pendant
	[3355]="200:7:1:20:Herb:171:1:1:844,1302,1313,4083,8305,16641,16705:0:0", -- Wild Steelbloom
	[3356]="120:7:1:20:Herb:171,333,165:1:1:844,1302,1313,4083,8305,16641,16705:0:0", -- Kingsblood
	[3357]="300:7:1:20:Herb:171:1:1:844,1302,1313,4083,8305,14846,16641,16705:0:0", -- Liferoot
	[3358]="700:7:1:20:Herb:171:1:1:14846:0:0", -- Khadgar's Whisker
	[3360]="0:4:1:1:OffHandFrill::1:0::3:0", -- Stitches' Femur
	[3363]="0:4:0:1:Cloth::1:0::0:0", -- Frayed Belt
	[3365]="0:4:0:1:Cloth::1:0::0:0", -- Frayed Bracers
	[3369]="0:7:1:20:Herb:171:1:0::0:0", -- Grave Moss
	[3370]="0:4:0:1:Cloth::1:0::0:0", -- Patchwork Belt
	[3371]="100:7:1:20:Other:171,333:5:0:66,777,843,844,958,960,983,989,1148,1250,1257,1286,1313,1453,1456,1465,1692,2118,2225,2393,2480,2810,2812,2821,2848,3010,3014,3081,3168,3187,3348,3367,3482,3499,3548,3556,3614,3779,3954,4194,4216,4226,4229,4561,4610,4615,4775,4897,4899,5100,5135,5138,5163,5178,5503,5594,5817,7947,8145,8157,8158,8177,8178,8305,8363,8934,9636,11188,11189,12022,12028,12043,12245,12941,12958,15179,16224,16261,16262,16367,16588,16602,16612,16613,16641,16705,16706,16768,16826,16829,17486,17490,18005,18009,18015,18426,18427,18802,18907,18960,19015,19017,19042,19074,19194,19197,19244,19345,19372,19450,19497,19533,19562,19573,19837,20081,20092,20194,20250,20891,20989,21083,21113,22099,22271,23802,24054,24147,24188,24341,24356,24780,24843,24935,24975,25010,25034,25051,25082,26374,26474,26568,26720,26939,26941,27012,27021,27026,27031,27038,27043,27053,27057,27063,27070,27132,27140,27141,27146,27184,27195,27938,28692,28725,28727,28794,28806,28828,28829,28831,28866,28868,28872,29208,29270,29277,29288,29535,29909,30311,30345,30438,30825,31115,32477,32639,32641,32979,33600,33630,33639,33669,33674,33678,36695,36779,37904,37935,38783,38853,38978,40474,41053,41275,41490,41676,41891,42853,43149,43485,43558,43980,44034,44186,44193,44301,44307,44341,44383,44780,45093,45286,45489,45490,45497,45552,46742,47104,47153,47164,47345,47347,47545,47719,47721,47863,47939,48058,48098,48123,48235,48551,48574,48868,49403,49409,49434,49579,49595,49703,49752,49765,49805,49885,50248:0:0", -- Crystal Vial
	[3372]="0:7:0:20:Other::1:0::0:0", -- Cracked Vial
	[3373]="0:4:0:1:Cloth::1:0::0:0", -- Patchwork Bracers
	[3374]="0:4:0:1:Cloth::1:0::0:0", -- Calico Belt
	[3375]="0:4:0:1:Cloth::1:0::0:0", -- Calico Bracers
	[3376]="0:4:0:1:Cloth::1:0::0:0", -- Canvas Belt
	[3377]="0:4:0:1:Cloth::1:0::0:0", -- Canvas Bracers
	[3378]="0:4:0:1:Cloth::1:0::0:0", -- Brocade Belt
	[3379]="0:4:0:1:Cloth::1:0::0:0", -- Brocade Bracers
	[3380]="0:4:0:1:Cloth::1:0::0:0", -- Cross-Stitched Belt
	[3381]="0:4:0:1:Cloth::1:0::0:0", -- Cross-Stitched Bracers
	[3382]="0:0:1:20:Elixir::1:0::0:0", -- Weak Troll's Blood Elixir
	[3383]="0:0:1:20:Elixir:165,197:1:0::0:0", -- Elixir of Wisdom
	[3384]="0:0:1:20:Potion::1:0::0:0", -- Minor Magic Resistance Potion
	[3385]="120:0:1:20:Potion::1:1:1307,2805,3134,4083,14847:0:0", -- Lesser Mana Potion
	[3386]="0:0:1:20:Potion::1:0::0:0", -- Potion of Curing
	[3387]="0:0:1:20:Potion::1:0::0:0", -- Limited Invulnerability Potion
	[3388]="0:0:1:20:Elixir::1:0::0:0", -- Strong Troll's Blood Elixir
	[3389]="0:0:1:20:Elixir:165:1:0::0:0", -- Elixir of Defense
	[3390]="0:0:1:20:Elixir:165:1:0::0:0", -- Elixir of Lesser Agility
	[3391]="0:0:1:20:Elixir:164,755:1:0::0:0", -- Elixir of Ogre's Strength
	[3392]="0:4:2:1:Leather::1:0::2:0", -- Ringed Helm
	[3393]="0:9:1:1:Alchemy::1:0::0:0", -- Recipe: Minor Magic Resistance Potion
	[3394]="0:9:1:1:Alchemy::1:0::0:0", -- Recipe: Potion of Curing
	[3395]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Limited Invulnerability Potion
	[3396]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Elixir of Lesser Agility
	[3397]="0:12:1:20:::1:0::4:0", -- Young Crocolisk Skin
	[3399]="0:15:0:20:Junk::1:0::0:0", -- Vulture Talon
	[3400]="0:2:2:1:OneHandSword::1:0::3:0", -- Lucine Longsword
	[3401]="0:15:0:20:Junk::1:0::0:0", -- Rough Crocolisk Scale
	[3402]="0:15:0:20:Junk::1:0::0:0", -- Soft Patch of Fur
	[3403]="0:15:0:20:Junk::1:0::0:0", -- Ivory Boar Tusk
	[3404]="0:7:1:20:Meat:185:1:0::0:0", -- Buzzard Wing
	[3405]="0:12:1:1:::1:0::4:0", -- Raven Claw Talisman
	[3406]="0:12:1:1:::1:0::4:0", -- Black Feather Quill
	[3407]="0:12:1:1:::1:0::4:0", -- Sapphire of Sky
	[3408]="0:12:1:1:::1:0::4:0", -- Rune of Nesting
	[3409]="0:12:1:20:::1:0::4:0", -- Nightsaber Fang
	[3411]="0:12:1:20:::1:0::4:0", -- Strigid Owl Feather
	[3412]="0:12:1:20:::1:0::4:0", -- Webwood Spider Silk
	[3413]="0:2:3:1:Dagger::1:0::2:0", -- Doomspike
	[3414]="0:2:3:1:OneHandMace::1:0::2:0", -- Crested Scepter
	[3415]="0:2:3:1:Stave::1:0::2:0", -- Staff of the Friar
	[3416]="0:4:3:1:Mail::1:0::2:0", -- Martyr's Chain
	[3417]="0:2:3:1:TwoHandSword::1:0::2:0", -- Onyx Claymore
	[3418]="0:12:1:20:::1:0::4:0", -- Fel Cone
	[3419]="500:4:1:1:OffHandFrill::1:0:1302,1303,3014,23731,28993,31021,37936,46742:0:0", -- Red Rose
	[3420]="5000:4:1:1:OffHandFrill::1:0:1302,1303,3014,23731,28993,31021,37936,46742:0:0", -- Black Rose
	[3421]="200:4:1:1:OffHandFrill::1:0:1302,1303,3014,23731,28993,31021,37936,46742:0:0", -- Simple Wildflowers
	[3422]="2000:4:1:1:OffHandFrill::1:0:1302,1303,3014,23731,28993,31021,37936,46742:0:0", -- Beautiful Wildflowers
	[3423]="20000:4:1:1:OffHandFrill::1:0:1302,1303,3014,23731,28993,31021,37936,46742:0:0", -- Bouquet of White Roses
	[3424]="500000:4:1:1:OffHandFrill::1:0:1302,1303,3014,23731,28993,31021,37936,46742:0:0", -- Bouquet of Black Roses
	[3425]="0:12:1:1:::1:0::4:0", -- Woven Wand
	[3426]="4000:4:1:1:Shirt::1:0:1299:0:0", -- Bold Yellow Shirt
	[3427]="6000:4:1:1:Shirt::1:0:1299:0:0", -- Stylish Black Shirt
	[3428]="400:4:1:1:Shirt::1:0:1214,1291,1299,3317,3486,3554,4558,5108,8358,16623,16631,16716,43436:0:0", -- Common Gray Shirt
	[3429]="0:4:2:1:Leather::1:0::2:0", -- Guardsman Belt
	[3430]="0:2:2:1:Gun::1:0::2:0", -- Sniper Rifle
	[3431]="0:4:2:1:Leather::1:0::3:0", -- Bone-Studded Leather
	[3434]="0:0:1:10:Consumable::1:0::3:0", -- Slumber Sand
	[3435]="0:4:1:1:Leather::1:0::3:0", -- Zombie Skin Bracers
	[3437]="0:4:1:1:Mail::1:0::3:0", -- Clasped Belt
	[3439]="0:4:1:1:Leather::1:0::3:0", -- Zombie Skin Boots
	[3440]="0:2:2:1:TwoHandMace::1:0::3:0", -- Bonecracker
	[3442]="0:4:1:1:Cloth::1:0::3:0", -- Apprentice Sash
	[3443]="0:2:1:1:OneHandAxe::1:0::3:0", -- Ceremonial Tomahawk
	[3444]="0:4:1:1:Leather::1:0::3:0", -- Tiller's Vest
	[3445]="0:2:1:1:Dagger::1:0::3:0", -- Ceremonial Knife
	[3446]="0:2:2:1:Stave::1:0::3:0", -- Darkwood Staff
	[3447]="0:4:1:1:Mail::1:0::3:0", -- Cryptwalker Boots
	[3448]="0:0:1:20:FoodDrink::1:0::0:0", -- Senggin Root
	[3449]="0:4:2:1:Cloak::1:0::3:0", -- Mystic Shawl
	[3450]="0:4:2:1:Shield::1:0::3:0", -- Faerleia's Shield
	[3451]="0:4:2:1:OffHandFrill::1:0::3:0", -- Nightglow Concoction
	[3452]="0:2:2:1:Stave::1:0::3:0", -- Ceranium Rod
	[3453]="0:4:1:1:Cloth::1:0::3:0", -- Quilted Bracers
	[3454]="0:4:1:1:Cloth::1:0::3:0", -- Reconnaissance Boots
	[3455]="0:2:1:1:OneHandSword::1:0::3:0", -- Deathstalker Shortsword
	[3456]="0:4:3:1:Trinket::1:0::3:0", -- Dog Whistle
	[3457]="0:4:2:1:Cloth::1:0::3:0", -- Stamped Trousers
	[3458]="0:4:2:1:Mail::1:0::3:0", -- Rugged Mail Gloves
	[3460]="0:12:1:1:::1:0::4:0", -- Holland's Special Drink
	[3461]="0:4:2:1:Cloth::1:0::3:0", -- High Robe of the Adjudicator
	[3462]="0:2:2:1:OneHandSword::1:0::3:0", -- Talonstrike
	[3463]="0:15:2:200:Junk::1:0::3:0", -- Broken Silver Star
	[3464]="0:15:0:1000:Junk::1:0::0:0", -- Feathered Arrow
	[3465]="0:15:0:1000:Junk::1:0::0:0", -- Exploding Shot
	[3466]="2000:7:1:20:Other:164:1:0:372,790,960,989,1148,1286,1448,1456,1690,1694,2225,2393,2685,2687,2688,2810,2821,2844,2847,2999,3002,3133,3167,3343,3356,3358,3367,3413,3477,3495,3779,3954,4229,4256,4257,4259,4561,4587,4597,4599,4775,4888,4897,4941,5100,5135,5163,5175,5411,5512,5514,5519,5817,6777,7947,8145,8161,8176,8363,8679,8934,9636,9676,11185,11186,11189,12022,12028,12245,12941,12958,14337,14624,14637,14737,15176,15179,15400,16376,16583,16613,16657,16664,16670,16713,16751,16768,16782,16823,17222,17245,17421,17486,17655,18009,18278,18484,18752,18775,19011,19012,19056,19244,19342,19372,19383,19450,19520,19530,19662,19879,20082,20463,20890,20981,22264,22476,23144,23908,24052,24843,24935,25010,25051,25082,26081,26599,26600,26898,26934,27019,27021,27026,27043,27045,27057,27062,27134,27267,27711,28344,28692,28716,28722,28728,28796,28797,28831,28872,29252,29253,29288,29688,29907,29923,29964,29969,30241,30253,30311,30336,30345,30434,30436,30825,31024,31776,31781,32594,32979,33231,33594,33599,33631,33634,33640,33669,33675,33677,33682,37904,37935,40474,41053,41054,41274,41275,41435,41490,41493,41675,41676,41890,41891,42488,42676,42876,42909,42972,43410,43548,43564,43615,43625,43705,43708,43709,43710,43711,43772,43882,43980,43998,44005,44022,44181,44186,44194,44195,44279,44280,44301,44305,44311,44337,44341,44377,44383,44780,45093,45148,45286,45293,45294,45417,45451,45546,45549,45552,45843,46358,46359,46702,47059,47104,47153,47164,47267,47286,47340,47347,47530,47532,47721,47863,47864,47937,47939,48056,48057,48058,48090,48098,48123,48228,48235,48238,48251,48258,48356,48551,48573,48574,48868,49409,49433,49549,49575,49592,49605,49695,49702,49726,49756,49768,49788,49800,49885,49918,50129,50460,52637,52641,52643,52655,53409,53421:0:0", -- Strong Flux
	[3468]="0:12:1:1:::1:0::4:0", -- Renferrel's Findings
	[3469]="0:4:1:1:Mail::1:0::0:0", -- Copper Chain Boots
	[3470]="0:7:1:20:MetalStone:164:1:0::0:0", -- Rough Grinding Stone
	[3471]="0:4:2:1:Mail::1:0::2:0", -- Copper Chain Vest
	[3472]="0:4:2:1:Mail::1:0::2:0", -- Runed Copper Gauntlets
	[3473]="0:4:2:1:Mail::1:0::2:0", -- Runed Copper Pants
	[3474]="0:4:2:1:Mail::1:0::2:0", -- Gemmed Copper Gauntlets
	[3475]="0:4:4:1:Cloak::1:0::2:0", -- Cloak of Flames
	[3476]="0:12:1:20:::1:0::4:0", -- Gray Bear Tongue
	[3477]="0:12:1:1:::1:0::4:0", -- Creeper Ichor
	[3478]="0:7:1:20:MetalStone:164:1:0::0:0", -- Coarse Grinding Stone
	[3480]="0:4:2:1:Mail::1:0::2:0", -- Rough Bronze Shoulders
	[3481]="0:4:2:1:Mail::1:0::2:0", -- Silvered Bronze Shoulders
	[3482]="0:4:2:1:Mail::1:0::2:0", -- Silvered Bronze Boots
	[3483]="0:4:2:1:Mail::1:0::2:0", -- Silvered Bronze Gauntlets
	[3484]="0:4:2:1:Mail::1:0::2:0", -- Green Iron Boots
	[3485]="0:4:2:1:Mail::1:0::2:0", -- Green Iron Gauntlets
	[3486]="0:7:1:20:MetalStone:164:1:0::0:0", -- Heavy Grinding Stone
	[3487]="0:2:2:1:TwoHandSword::1:0::2:0", -- Heavy Copper Broadsword
	[3488]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Copper Battle Axe
	[3489]="0:2:2:1:OneHandAxe::1:0::2:0", -- Thick War Axe
	[3490]="0:2:2:1:Dagger::1:0::2:0", -- Deadly Bronze Poniard
	[3491]="0:2:2:1:OneHandMace::1:0::2:0", -- Heavy Bronze Mace
	[3492]="0:2:2:1:OneHandMace::1:0::2:0", -- Mighty Iron Hammer
	[3493]="0:2:2:1:Bow::1:0::3:0", -- Raptor's End
	[3495]="0:12:1:1:::1:0::4:0", -- Elixir of Suffering
	[3496]="0:12:1:20:::1:0::4:0", -- Mountain Lion Blood
	[3497]="0:12:1:1:::1:0::4:0", -- Elixir of Pain
	[3498]="0:12:1:1:::1:0::4:0", -- Taretha's Necklace
	[3502]="0:12:1:20:::1:0::4:0", -- Mudsnout Blossom
	[3505]="0:12:1:20:::1:0::4:0", -- Alterac Signet Ring
	[3506]="0:12:1:1:::1:0::4:0", -- Mudsnout Composite
	[3508]="0:12:1:1:::1:0::4:0", -- Mudsnout Mixture
	[3509]="0:12:1:20:::1:0::4:0", -- Daggerspine Scale
	[3510]="0:12:1:20:::1:0::4:0", -- Torn Fin Eye
	[3511]="0:4:2:1:Cloak::1:0::3:0", -- Cloak of the People's Militia
	[3514]="0:12:1:1:::1:0::4:0", -- Mor'Ladim's Skull
	[3515]="0:12:1:1:::1:0::4:0", -- Ataeric's Staff
	[3516]="0:12:1:1:::1:0::4:0", -- Lescovar's Head
	[3517]="0:12:1:1:::1:0::4:0", -- Keg of Shindigger Stout
	[3518]="0:12:1:1:::1:0::4:0", -- Decrypted Letter
	[3520]="0:12:1:1:::1:0::4:0", -- Tainted Keg
	[3521]="0:12:1:1:::1:0::4:0", -- Cleverly Encrypted Letter
	[3530]="0:0:1:20:Bandage::1:0::0:0", -- Wool Bandage
	[3531]="0:0:1:20:Bandage::1:0::0:0", -- Heavy Wool Bandage
	[3550]="0:12:1:1:::1:0::4:0", -- Targ's Head
	[3551]="0:12:1:1:::1:0::4:0", -- Muckrake's Head
	[3552]="0:12:1:1:::1:0::4:0", -- Glommus' Head
	[3553]="0:12:1:1:::1:0::4:0", -- Mug'thol's Head
	[3554]="0:12:1:1:::1:0::4:0", -- Crown of Will
	[3555]="0:4:2:1:Cloth::1:0::3:0", -- Robe of Solomon
	[3556]="0:4:2:1:Cloth::1:0::3:0", -- Dread Mage Hat
	[3558]="0:4:2:1:Cloth::1:0::3:0", -- Fen Keeper Robe
	[3559]="0:4:2:1:Mail::1:0::3:0", -- Night Watch Gauntlets
	[3560]="0:4:2:1:Cloth::1:0::3:0", -- Mantle of Honor
	[3561]="0:4:2:1:Cloak::1:0::3:0", -- Resilient Poncho
	[3562]="0:4:2:1:Leather::1:0::3:0", -- Belt of Vindication
	[3563]="0:4:2:1:Cloth::1:0::2:0", -- Seafarer's Pantaloons
	[3564]="0:12:1:1:::1:0::4:0", -- Shipment of Iron
	[3565]="0:4:2:1:Cloth::1:0::3:0", -- Beerstained Gloves
	[3566]="0:4:2:1:Leather::1:0::3:0", -- Raptorbane Armor
	[3567]="0:2:2:1:Gun::1:0::3:0", -- Dwarven Fishing Pole
	[3569]="0:4:3:1:Cloth::1:0::2:0", -- Vicar's Robe
	[3570]="0:2:2:1:OneHandMace::1:0::3:0", -- Bonegrinding Pestle
	[3571]="0:2:2:1:TwoHandMace::1:0::2:0", -- Trogg Beater
	[3572]="0:2:2:1:OneHandSword::1:0::3:0", -- Daryl's Shortsword
	[3573]="0:1:1:1:Bag::1:0::3:0", -- Hunting Quiver
	[3574]="0:1:1:1:Bag::1:0::3:0", -- Hunting Ammo Sack
	[3575]="0:7:1:20:MetalStone:171,164,202,755,186:1:0::0:0", -- Iron Bar
	[3576]="0:7:1:20:MetalStone:186:1:0::0:0", -- Tin Bar
	[3577]="0:7:2:20:MetalStone:164,202,755,197:1:0::0:0", -- Gold Bar
	[3578]="0:4:2:1:Leather::1:0::3:0", -- Harvester's Pants
	[3581]="0:2:2:1:Dagger::1:0::3:0", -- Serrated Knife
	[3582]="0:4:2:1:Cloak::1:0::3:0", -- Acidproof Cloak
	[3583]="0:4:1:1:Leather::1:0::3:0", -- Weathered Belt
	[3585]="0:4:2:1:Leather::1:0::3:0", -- Camouflaged Tunic
	[3586]="0:2:2:1:TwoHandAxe::1:0::3:0", -- Logsplitter
	[3587]="14314:4:1:1:Cloth::1:0:984,1314,2849,3092,3315,3316,4175,5129,5155,5821,10293,11183,12023,26707,45149:0:0", -- Embroidered Belt
	[3588]="14366:4:1:1:Cloth::1:0:984,1314,2849,3092,3315,3316,4175,5129,5155,5821,10293,11183,12023,26707,45149:0:0", -- Embroidered Bracers
	[3589]="577:4:1:1:Cloth::1:0:1214,1291,3092,3317,3486,3554,3952,4164,4175,4558,5108,5821,8358,16623,16631,16716,43436:0:0", -- Heavy Weave Belt
	[3590]="579:4:1:1:Cloth::1:0:1214,1291,3092,3317,3486,3554,3952,4164,4175,4558,5108,5821,8358,16623,16631,16716,43436:0:0", -- Heavy Weave Bracers
	[3591]="2097:4:1:1:Cloth::1:0:1314,2849,3092,3315,3316,3952,4175,5821:0:0", -- Padded Belt
	[3592]="2104:4:1:1:Cloth::1:0:1314,2849,3092,3315,3316,3952,4175,5821:0:0", -- Padded Bracers
	[3593]="5478:4:1:1:Cloth::1:0:1147,1314,1407,2849,3092,3315,3316,4175,5155,5821,8159,10293,38561,45149:0:0", -- Russet Belt
	[3594]="5497:4:1:1:Cloth::1:0:1147,1314,1407,2849,3092,3315,3316,4175,5155,5821,8159,10293,38561,45149:0:0", -- Russet Bracers
	[3595]="24:4:1:1:Cloth::1:0:2113,3160,4558,39033:0:0", -- Tattered Cloth Belt
	[3596]="24:4:1:1:Cloth::1:0:2113,3160,4558,39033:0:0", -- Tattered Cloth Bracers
	[3597]="1081:4:1:1:Cloth::1:0:1291,2849,3092,3317,3492,3952,4175,5155,5821,8358,16623,16716,33381,44285:0:0", -- Thick Cloth Belt
	[3598]="1085:4:1:1:Cloth::1:0:1291,2849,3092,3317,3492,3952,4175,5155,5821,8358,16623,16716,33381,44285:0:0", -- Thick Cloth Bracers
	[3599]="24:4:1:1:Cloth::1:0:190,836,1238,3590,4175,16918,42332:0:0", -- Thin Cloth Belt
	[3600]="24:4:1:1:Cloth::1:0:190,836,1238,3590,4175,16918,42332:0:0", -- Thin Cloth Bracers
	[3601]="0:12:1:1:::1:0::4:0", -- Syndicate Missive
	[3602]="145:4:1:1:Cloth::1:0:74,959,1238,1291,3092,3611,3952,4164,4175,5821,16716,17929:0:0", -- Knitted Belt
	[3603]="146:4:1:1:Cloth::1:0:74,959,1238,1291,3092,3611,3952,4164,4175,5821,16716,17929:0:0", -- Knitted Bracers
	[3604]="0:1:2:1:Bag::1:0::3:0", -- Bandolier of the Night Watch
	[3605]="0:1:2:1:Bag::1:0::3:0", -- Quiver of the Night Watch
	[3606]="147:4:1:1:Cloth::1:0:3166,3317,3522,4558,16186,16623,43949:0:0", -- Woven Belt
	[3607]="148:4:1:1:Cloth::1:0:3166,3317,3522,4558,16186,16623,43949:0:0", -- Woven Bracers
	[3608]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Mighty Iron Hammer
	[3609]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Copper Chain Vest
	[3610]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Gemmed Copper Gauntlets
	[3611]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Green Iron Boots
	[3612]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Green Iron Gauntlets
	[3613]="0:12:1:1:::1:0::4:0", -- Valdred's Hands
	[3614]="0:12:1:1:::1:0::4:0", -- Yowler's Paw
	[3615]="0:12:1:1:::1:0::4:0", -- Kurzen's Head
	[3616]="0:12:1:1:::1:0::4:0", -- Mind's Eye
	[3617]="0:12:1:1:::1:0::4:0", -- Pendant of Shadow
	[3618]="0:12:1:1:::1:0::4:0", -- Gobbler's Head
	[3619]="0:12:1:1:::1:0::4:0", -- Snellig's Snuffbox
	[3621]="0:12:1:1:::1:0::4:0", -- Ivar's Head
	[3622]="0:12:1:1:::1:0::4:0", -- Essence of Nightlash
	[3623]="0:12:1:1:::1:0::4:0", -- Thule's Head
	[3625]="0:12:1:1:::1:0::4:0", -- Nek'rosh's Head
	[3626]="0:12:1:1:::1:0::4:0", -- Head of Baron Vardus
	[3627]="0:12:1:1:::1:0::4:0", -- Fang of Vagash
	[3628]="0:12:1:1:::1:0::4:0", -- Hand of Dextren Ward
	[3629]="0:12:1:1:::1:0::4:0", -- Mistmantle Family Ring
	[3630]="0:12:1:1:::1:0::4:0", -- Head of Targorr
	[3631]="0:12:1:1:::1:0::4:0", -- Bellygrub's Tusk
	[3632]="0:12:1:1:::1:0::4:0", -- Fangore's Paw
	[3633]="0:12:1:1:::1:0::4:0", -- Head of Gath'Ilzogg
	[3634]="0:12:1:1:::1:0::4:0", -- Head of Grimson
	[3635]="0:12:1:1:::1:0::4:0", -- Maggot Eye's Paw
	[3636]="0:12:1:1:::1:0::4:0", -- Scale of Old Murk-Eye
	[3637]="0:12:1:1:::1:0::4:0", -- Head of VanCleef
	[3639]="0:12:1:1:::1:0::4:0", -- Ear of Balgaras
	[3640]="0:12:1:1:::1:0::4:0", -- Head of Deepfury
	[3641]="0:4:1:1:Cloth::1:0::0:0", -- Journeyman's Bracers
	[3642]="0:4:1:1:Cloth::1:0::0:0", -- Ancestral Bracers
	[3643]="0:4:1:1:Cloth::1:0::0:0", -- Spellbinder Bracers
	[3644]="0:4:1:1:Cloth::1:0::0:0", -- Barbaric Cloth Bracers
	[3645]="0:4:2:1:Cloth::1:0::2:0", -- Seer's Cuffs
	[3647]="0:4:2:1:Cloth::1:0::2:0", -- Bright Bracers
	[3649]="0:4:1:1:Shield::1:0::0:0", -- Tribal Buckler
	[3650]="0:4:1:1:Shield::1:0::0:0", -- Battle Shield
	[3651]="0:4:2:1:Shield::1:0::2:0", -- Veteran Shield
	[3652]="0:4:2:1:Shield::1:0::2:0", -- Hunting Buckler
	[3653]="0:4:2:1:Shield::1:0::2:0", -- Ceremonial Buckler
	[3654]="0:4:2:1:Shield::1:0::2:0", -- Brackwater Shield
	[3655]="0:4:2:1:Shield::1:0::2:0", -- Burnished Shield
	[3656]="0:4:2:1:Shield::1:0::2:0", -- Lambent Scale Shield
	[3657]="0:12:1:1:::1:0::4:0", -- Hillsbrad Town Registry
	[3658]="0:12:1:10:::1:0::4:0", -- Recovered Tome
	[3659]="0:12:1:1:::1:0::4:0", -- Worn Leather Book
	[3660]="0:12:1:1:::1:0::4:0", -- Tomes of Alterac
	[3661]="0:2:1:1:Stave::1:0::0:0", -- Handcrafted Staff
	[3662]="0:0:1:20:FoodDrink::1:0::0:0", -- Crocolisk Steak
	[3663]="0:0:1:20:FoodDrink::1:0::0:0", -- Murloc Fin Soup
	[3664]="0:0:1:20:FoodDrink::1:0::0:0", -- Crocolisk Gumbo
	[3665]="0:0:1:20:FoodDrink::1:0::0:0", -- Curiously Tasty Omelet
	[3666]="0:0:1:20:FoodDrink::1:0::0:0", -- Gooey Spider Cake
	[3667]="0:7:1:20:Meat:185:1:0::0:0", -- Tender Crocolisk Meat
	[3668]="0:12:1:1:::1:0::3:0", -- Assassin's Contract
	[3669]="0:15:0:20:Junk::1:0::0:0", -- Gelatinous Goo
	[3670]="0:15:0:20:Junk::1:0::0:0", -- Large Slimy Bone
	[3671]="0:15:0:20:Junk::1:0::0:0", -- Lifeless Skull
	[3672]="0:12:1:1:::1:0::4:0", -- Head of Nagaz
	[3673]="0:15:0:100:Junk::1:0::0:0", -- Broken Arrow
	[3674]="0:15:0:20:Junk::1:0::0:0", -- Decomposed Boot
	[3676]="0:15:0:20:Junk::1:0::0:0", -- Slimy Ichor
	[3678]="400:9:1:1:Cooking::1:0:340:0:0", -- Recipe: Crocolisk Steak
	[3679]="400:9:1:1:Cooking::1:0:340:0:0", -- Recipe: Blood Sausage
	[3680]="1600:9:1:1:Cooking::1:0:340:0:0", -- Recipe: Murloc Fin Soup
	[3681]="1600:9:1:1:Cooking::1:0:340:0:0", -- Recipe: Crocolisk Gumbo
	[3682]="1600:9:1:1:Cooking::1:0:340,1148,2821:0:0", -- Recipe: Curiously Tasty Omelet
	[3683]="1600:9:1:1:Cooking::1:0:340:0:0", -- Recipe: Gooey Spider Cake
	[3684]="0:12:1:1:::1:0::4:0", -- Perenolde Tiara
	[3685]="0:7:1:20:Meat:185:1:0::0:0", -- Raptor Egg
	[3688]="0:12:1:1:::1:0::4:0", -- Bloodstone Oval
	[3689]="0:12:1:1:::1:0::4:0", -- Bloodstone Marble
	[3690]="0:12:1:1:::1:0::4:0", -- Bloodstone Shard
	[3691]="0:12:1:1:::1:0::4:0", -- Bloodstone Wedge
	[3692]="0:12:1:30:::1:0::4:0", -- Hillsbrad Human Skull
	[3693]="0:12:1:1:::1:0::4:0", -- Humbert's Sword
	[3701]="0:12:1:1:::1:0::4:0", -- Darthalia's Sealed Commendation
	[3702]="0:15:0:20:Junk::1:0::0:0", -- Bear Gall Bladder
	[3703]="145:0:1:10:FoodDrink::1:0:2388,20377:0:0", -- Southshore Stout
	[3704]="0:13:1:1:::1:0::4:0", -- Rusted Iron Key
	[3706]="0:12:1:1:::1:0::3:0", -- Ensorcelled Parchment
	[3708]="0:12:1:1:::1:0::4:0", -- Helcular's Rod
	[3710]="0:12:1:1:::1:0::4:0", -- Rod of Helcular
	[3711]="0:15:0:1:Junk::1:0::0:0", -- Belamoore's Research Journal
	[3712]="0:7:1:20:Meat:185:1:0::0:0", -- Turtle Meat
	[3713]="0:15:0:20:Junk::1:0::0:0", -- Soothing Spices
	[3714]="0:12:1:20:::1:0::4:0", -- Worn Stone Token
	[3715]="0:12:1:20:::1:0::4:0", -- Bracers of Earth Binding
	[3716]="0:12:1:20:::1:0::4:0", -- Murloc Head
	[3717]="0:12:1:1:::1:0::4:0", -- Sack of Murloc Heads
	[3718]="0:12:1:1:::1:0::4:0", -- Foreboding Plans
	[3719]="0:4:2:1:Cloak::1:0::2:0", -- Hillman's Cloak
	[3720]="0:12:1:20:::1:0::4:0", -- Yeti Fur
	[3721]="0:12:1:1:::1:0::4:0", -- Farren's Report
	[3722]="0:15:0:20:Junk::1:0::0:0", -- Familiar Hide
	[3723]="0:15:0:20:Junk::1:0::0:0", -- Familiar Fang
	[3724]="0:15:0:20:Junk::1:0::0:0", -- Familiar Claw
	[3725]="0:15:0:20:Junk::1:0::0:0", -- Familiar Horn
	[3726]="0:0:1:20:FoodDrink::1:0::0:0", -- Big Bear Steak
	[3727]="0:0:1:20:FoodDrink::1:0::0:0", -- Hot Lion Chops
	[3728]="0:0:1:20:FoodDrink::1:0::0:0", -- Tasty Lion Steak
	[3729]="0:0:1:20:FoodDrink::1:0::0:0", -- Soothing Turtle Bisque
	[3730]="0:7:1:20:Meat:185:1:0::0:0", -- Big Bear Meat
	[3731]="0:7:1:20:Meat:185:1:0::0:0", -- Lion Meat
	[3732]="0:4:1:1:Cloth::1:0::3:0", -- Hooded Cowl
	[3733]="0:4:2:1:Mail::1:0::3:0", -- Orcish War Chain
	[3734]="1600:9:1:1:Cooking::1:1:12246:0:0", -- Recipe: Big Bear Steak
	[3735]="1800:9:1:1:Cooking::1:0:3489,12245:0:0", -- Recipe: Hot Lion Chops
	[3736]="0:9:1:1:Cooking::1:0::0:0", -- Recipe: Tasty Lion Steak
	[3737]="0:9:1:1:Cooking::1:0::0:0", -- Recipe: Soothing Turtle Bisque
	[3739]="0:4:2:1:Ring::1:0::3:0", -- Skull Ring
	[3740]="0:2:2:1:OneHandSword::1:0::2:0", -- Decapitating Sword
	[3741]="0:4:2:1:Leather::1:0::3:0", -- Stomping Boots
	[3742]="0:2:2:1:Bow::1:0::3:0", -- Bow of Plunder
	[3743]="0:4:2:1:Shield::1:0::3:0", -- Sentry Buckler
	[3745]="0:12:1:20:::1:0::0:0", -- Rune of Opening
	[3747]="0:4:2:1:Leather::1:0::3:0", -- Meditative Sash
	[3748]="0:4:3:1:Cloth::1:0::3:0", -- Feline Mantle
	[3749]="0:4:2:1:Cloak::1:0::3:0", -- High Apothecary Cloak
	[3750]="0:4:2:1:Leather::1:0::3:0", -- Ribbed Breastplate
	[3751]="0:4:2:1:Mail::1:0::3:0", -- Mercenary Leggings
	[3752]="0:4:2:1:Cloth::1:0::3:0", -- Grunt Vest
	[3753]="0:4:2:1:Leather::1:0::3:0", -- Shepherd's Girdle
	[3754]="0:4:2:1:Leather::1:0::3:0", -- Shepherd's Gloves
	[3755]="0:2:2:1:OneHandAxe::1:0::3:0", -- Fish Gutter
	[3758]="0:4:2:1:Mail::1:0::3:0", -- Crusader Belt
	[3759]="0:4:2:1:Cloth::1:0::3:0", -- Insulated Sage Gloves
	[3760]="0:4:2:1:Ring::1:0::3:0", -- Band of the Undercity
	[3761]="0:4:2:1:Shield::1:0::3:0", -- Deadskull Shield
	[3763]="0:4:2:1:Shield::1:0::3:0", -- Lunar Buckler
	[3764]="0:4:2:1:Cloth::1:0::3:0", -- Mantis Boots
	[3765]="0:4:2:1:Mail::1:0::3:0", -- Brigand's Pauldrons
	[3766]="0:15:0:20:Junk::1:0::0:0", -- Gryphon Feather Quill
	[3767]="0:15:0:20:Junk::1:0::0:0", -- Fine Parchment
	[3769]="0:15:0:20:Junk::1:0::0:0", -- Broken Wand
	[3770]="500:0:1:20:FoodDrink::5:0:982,1156,1464,2388,2814,3025,3089,3312,3368,3411,3489,3705,3881,3882,3933,3935,4169,4782,4879,4891,4894,4954,5111,5124,5611,5620,5688,5870,6739,6741,6928,6929,7485,7731,7733,9356,11118,11187,12196,12959,14624,14963,14964,15124,15125,15174,15397,16443,16618,16739,17553,17630,17656,19182,23263,23481,23605,24208,24343,36378,39031,40589,40898,41286,41491,41674,41892,42953,43606,43624,43633,43739,43771,43899,43956,44177,44276,44312,44343,45563,47165,47288,47668,47854,48555,48735,50092,51142:0:0", -- Mutton Chop
	[3771]="1000:0:1:20:FoodDrink::5:0:982,1156,1464,2388,2814,3025,3089,3312,3368,3411,3489,3705,3881,3882,3933,3935,4169,4782,4879,4891,4894,4954,5111,5124,5611,5620,5688,5870,6739,6741,6928,6929,7485,7731,7733,9356,11118,11187,12196,12959,14624,14963,14964,15124,15125,15174,15397,16443,16618,16739,17553,17630,17656,19182,23263,23481,23605,24208,24343,36378,39031,40589,40898,41286,41491,41674,41892,42953,43606,43624,43633,43739,43771,43899,43956,44177,44276,44312,44343,45563,47165,47288,47668,47854,48555,48735,50092,51142:0:0", -- Wild Hog Shank
	[3772]="0:0:1:20:FoodDrink::1:0::0:0", -- Conjured Spring Water
	[3775]="70:0:1:20:EnhTemp::1:0:1325,1326,2622,3090,3135,3334,3405,3490,3551,3561,3969,4585,5139,5169,6779,12096,15175,16268,16588,16683,16829,18006,18019,18802,19013,19014,19049,19239,19679,20081,20194,20915,20986,22479,23145,23373,23732,24148,24313,24357,24780,25043,25736,26382,26568,26598,26900,26945,27031,27038,27053,27089,27133,27149,27176,27186,28347,28832,28869,29015,29037,29535,29561,29909,29922,29947,29961,30010,30306,30438,31115,32639,32641,33630,33674,35642,39144,39878,41275,41490,41508,41676,41891,42622,42878,42910,42967,43155,43381,43411,43493,43547,43551,43555,43563,43646,43774,44047,44187,44313,44333,44970,45289,45290,45361,47860,53040,53076:0:0", -- Crippling Poison
	[3776]="0:0:0:20:EnhTemp::1:0::0:0", -- Crippling Poison
	[3777]="0:15:0:20:Junk::1:0::0:0", -- Lethargy Root
	[3778]="0:2:0:1:Bow::1:0::0:0", -- Taut Compound Bow
	[3779]="0:2:0:1:TwoHandAxe::1:0::0:0", -- Hefty War Axe
	[3780]="0:2:0:1:Gun::1:0::0:0", -- Long-Barreled Musket
	[3781]="0:2:0:1:TwoHandSword::1:0::0:0", -- Broad Claymore
	[3782]="0:2:0:1:TwoHandMace::1:0::0:0", -- Large War Club
	[3783]="0:2:0:1:OneHandSword::1:0::0:0", -- Light Scimitar
	[3784]="0:2:0:1:Stave::1:0::0:0", -- Metal Stave
	[3785]="0:2:0:1:OneHandAxe::1:0::0:0", -- Keen Axe
	[3786]="0:2:0:1:Dagger::1:0::0:0", -- Shiny Dirk
	[3787]="0:2:0:1:OneHandMace::1:0::0:0", -- Stone Club
	[3792]="0:4:0:1:Cloth::1:0::0:0", -- Interlaced Belt
	[3793]="0:4:0:1:Cloth::1:0::0:0", -- Interlaced Boots
	[3794]="0:4:0:1:Cloth::1:0::0:0", -- Interlaced Bracers
	[3795]="0:4:0:1:Cloak::1:0::0:0", -- Interlaced Cloak
	[3796]="0:4:0:1:Cloth::1:0::0:0", -- Interlaced Gloves
	[3797]="0:4:0:1:Cloth::1:0::0:0", -- Interlaced Pants
	[3798]="0:4:0:1:Cloth::1:0::0:0", -- Interlaced Shoulderpads
	[3799]="0:4:0:1:Cloth::1:0::0:0", -- Interlaced Vest
	[3800]="0:4:0:1:Leather::1:0::0:0", -- Hardened Leather Belt
	[3801]="0:4:0:1:Leather::1:0::0:0", -- Hardened Leather Boots
	[3802]="0:4:0:1:Leather::1:0::0:0", -- Hardened Leather Bracers
	[3803]="0:4:0:1:Cloak::1:0::0:0", -- Hardened Cloak
	[3804]="0:4:0:1:Leather::1:0::0:0", -- Hardened Leather Gloves
	[3805]="0:4:0:1:Leather::1:0::0:0", -- Hardened Leather Pants
	[3806]="0:4:0:1:Leather::1:0::0:0", -- Hardened Leather Shoulderpads
	[3807]="0:4:0:1:Leather::1:0::0:0", -- Hardened Leather Tunic
	[3808]="0:4:0:1:Mail::1:0::0:0", -- Double Mail Belt
	[3809]="0:4:0:1:Mail::1:0::0:0", -- Double Mail Boots
	[3810]="0:4:0:1:Mail::1:0::0:0", -- Double Mail Bracers
	[3811]="0:4:0:1:Cloak::1:0::0:0", -- Double-Stitched Cloak
	[3812]="0:4:0:1:Mail::1:0::0:0", -- Double Mail Gloves
	[3813]="0:4:0:1:Mail::1:0::0:0", -- Double Mail Pants
	[3814]="0:4:0:1:Mail::1:0::0:0", -- Double Mail Shoulderpads
	[3815]="0:4:0:1:Mail::1:0::0:0", -- Double Mail Vest
	[3816]="0:4:0:1:Shield::1:0::0:0", -- Reflective Heater
	[3817]="0:4:0:1:Shield::1:0::0:0", -- Reinforced Buckler
	[3818]="0:7:1:20:Herb:171:1:0::0:0", -- Fadeleaf
	[3819]="0:7:1:20:Herb:171,333:1:0::0:0", -- Dragon's Teeth
	[3820]="0:7:1:20:Herb:171:1:0::0:0", -- Stranglekelp
	[3821]="0:7:1:20:Herb:171,185:1:0::0:0", -- Goldthorn
	[3822]="0:2:2:1:TwoHandSword::1:0::3:0", -- Runic Darkblade
	[3823]="0:0:1:20:Potion:164:1:0::0:0", -- Lesser Invisibility Potion
	[3824]="0:0:1:5:EnhTemp:171,164,755,165,197:1:0::0:0", -- Shadow Oil
	[3825]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Fortitude
	[3826]="0:0:1:20:Elixir::1:0::0:0", -- Major Troll's Blood Elixir
	[3827]="480:0:1:20:Potion:755,197:1:1:2480,2812,2848,4899,12245:0:0", -- Mana Potion
	[3828]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Detect Lesser Invisibility
	[3829]="0:0:1:5:EnhTemp:164,333,202,197:1:0::0:0", -- Frost Oil
	[3830]="0:9:1:1:Alchemy::1:0::0:0", -- Recipe: Elixir of Fortitude
	[3831]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Major Troll's Blood Elixir
	[3832]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Elixir of Detect Lesser Invisibility
	[3833]="0:4:1:1:Cloak::1:0::3:0", -- Adept's Cloak
	[3834]="0:4:1:1:Cloth::1:0::3:0", -- Sturdy Cloth Trousers
	[3835]="0:4:2:1:Mail::1:0::2:0", -- Green Iron Bracers
	[3836]="0:4:2:1:Mail::1:0::2:0", -- Green Iron Helm
	[3837]="0:4:2:1:Mail::1:0::2:0", -- Golden Scale Coif
	[3838]="0:12:1:20:::1:0::4:0", -- Shadowmaw Claw
	[3839]="0:12:1:1:::1:0::4:0", -- Pristine Tigress Fang
	[3840]="0:4:2:1:Mail::1:0::2:0", -- Green Iron Shoulders
	[3841]="0:4:2:1:Mail::1:0::2:0", -- Golden Scale Shoulders
	[3842]="0:4:2:1:Mail::1:0::2:0", -- Green Iron Leggings
	[3843]="0:4:2:1:Mail::1:0::2:0", -- Golden Scale Leggings
	[3844]="0:4:3:1:Mail::1:0::2:0", -- Green Iron Hauberk
	[3845]="0:4:2:1:Mail::1:0::2:0", -- Golden Scale Cuirass
	[3846]="0:4:2:1:Mail::1:0::2:0", -- Polished Steel Boots
	[3847]="0:4:2:1:Mail::1:0::2:0", -- Golden Scale Boots
	[3848]="0:2:2:1:Dagger::1:0::2:0", -- Big Bronze Knife
	[3849]="0:2:2:1:OneHandSword::1:0::2:0", -- Hardened Iron Shortsword
	[3850]="0:2:2:1:OneHandSword::1:0::2:0", -- Jade Serpentblade
	[3851]="0:2:2:1:TwoHandMace::1:0::2:0", -- Solid Iron Maul
	[3852]="0:2:2:1:TwoHandMace::1:0::2:0", -- Golden Iron Destroyer
	[3853]="0:2:2:1:TwoHandSword::1:0::2:0", -- Moonsteel Broadsword
	[3854]="0:2:2:1:TwoHandSword::1:0::2:0", -- Frost Tiger Blade
	[3855]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Massive Iron Axe
	[3856]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Shadow Crescent Axe
	[3857]="500:7:1:20:MetalStone:186:1:0:372,790,960,989,1148,1286,1456,1690,2225,2393,2810,2821,2844,2847,2999,3002,3133,3167,3343,3356,3358,3367,3477,3779,3954,4229,4256,4257,4259,4561,4597,4599,4775,4888,4897,5100,5135,5163,5411,5512,5514,5817,7947,8145,8161,8176,8363,8934,9636,11186,11189,12022,12028,12245,12941,12958,14624,14737,15176,15179,15400,16376,16583,16613,16664,16670,16713,16751,16768,16823,17245,17486,17655,18009,19011,19012,19056,19244,19342,19372,19450,19520,19530,19662,19879,20082,20463,20981,22264,22476,23144,23908,24052,24843,24935,25010,25051,25082,26081,26599,26934,27019,27021,27026,27043,27045,27057,27062,27134,27267,28344,28692,28716,28728,28796,28831,28872,29252,29253,29288,29907,29923,29964,29969,30241,30253,30311,30336,30436,31024,32594,32979,33231,33599,33631,33640,33675,33682,40474,41053,41054,41274,41275,41490,41493,41675,41676,41890,41891,43410,43548,43564,43615,43625,43772,43882,43980,43998,44005,44022,44181,44186,44195,44279,44301,44311,44337,44341,44377,44383,44780,45093,45148,45286,45451,45549,45552,46358,46359,46702,47059,47104,47153,47164,47267,47286,47347,47532,47721,47863,47864,47937,47939,48057,48058,48090,48098,48123,48228,48235,48251,48258,48356,48551,48573,48574,48868,49549,49575,49592,49605,49695,49702,49726,49756,49768,49800,49885,50129,50460,52641,52643,53409,53421:0:0", -- Coal
	[3858]="0:7:1:20:MetalStone:171,186:1:0::0:0", -- Mithril Ore
	[3859]="0:7:1:20:MetalStone:164,202:1:0::0:0", -- Steel Bar
	[3860]="0:7:1:20:MetalStone:171,164,202,755:1:0::0:0", -- Mithril Bar
	[3862]="0:12:1:1:::1:0::4:0", -- Aged Gorilla Sinew
	[3863]="0:12:1:20:::1:0::4:0", -- Jungle Stalker Feather
	[3864]="0:3:2:20:GemSimple:164,202,755,165,197:1:0::0:0", -- Citrine
	[3866]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Jade Serpentblade
	[3867]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Golden Iron Destroyer
	[3868]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Frost Tiger Blade
	[3869]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Shadow Crescent Axe
	[3870]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Green Iron Shoulders
	[3871]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Golden Scale Shoulders
	[3872]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Golden Scale Leggings
	[3873]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Golden Scale Cuirass
	[3874]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Polished Steel Boots
	[3875]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Golden Scale Boots
	[3876]="0:12:1:1:::1:0::4:0", -- Fang of Bhag'thera
	[3877]="0:12:1:1:::1:0::4:0", -- Talon of Tethis
	[3879]="0:12:1:1:::1:0::4:0", -- Paw of Sin'Dall
	[3880]="0:12:1:1:::1:0::4:0", -- Head of Bangalash
	[3882]="0:15:0:20:Junk::1:0::0:0", -- Buzzard Feather
	[3889]="7923:4:1:1:Cloth::1:0:1147,1310,1314,1407,2849,3092,3315,3316,4175,5155,5821,8159,10293,38561,45149:0:0", -- Russet Hat
	[3890]="10201:4:1:1:Leather::1:0:1147,1310,1314,1320,1407,3315,3316,4236,5129,5820,8159,38561,44083:0:0", -- Studded Hat
	[3891]="12285:4:1:1:Mail::1:0:1310,1322,1323,1349,1381,2845,3095,4177,5125,5812,5819,8129,43750,53641:0:0", -- Augmented Chain Helm
	[3892]="21940:4:1:1:Cloth::1:0:984,1310,1314,2849,3092,3315,3316,4175,5129,5155,5821,10293,11183,12023,26707,45149:0:0", -- Embroidered Hat
	[3893]="27523:4:1:1:Leather::1:0:984,1310,1314,1320,3315,3316,4236,5129,5820,11183,12023,26707,27037,44083:0:0", -- Reinforced Leather Cap
	[3894]="29986:4:1:1:Mail::1:0:980,1310,1323,1349,4177,5126,5508,5819,8129,11182,12040,16626,16753,25274,27067,45500,53641:0:0", -- Brigandine Helm
	[3897]="0:12:1:1:::1:0::4:0", -- Dizzy's Eye
	[3898]="0:12:1:1:::1:0::3:0", -- Library Scrip
	[3899]="0:15:0:1:Junk::1:0::0:0", -- Legends of the Gurubashi, Volume 3
	[3900]="0:12:1:20:::1:0::4:0", -- Pupellyverbos Port
	[3901]="0:12:1:20:::1:0::4:0", -- Bloodscalp Tusk
	[3902]="0:2:3:1:Stave::1:0::2:0", -- Staff of Nobles
	[3904]="0:12:1:1:::1:0::4:0", -- Gan'zulah's Head
	[3905]="0:12:1:1:::1:0::4:0", -- Nezzliok's Head
	[3906]="0:12:1:20:::1:0::4:0", -- Balia'mah Trophy
	[3907]="0:12:1:20:::1:0::4:0", -- Ziata'jai Trophy
	[3908]="0:12:1:20:::1:0::4:0", -- Zul'Mamwe Trophy
	[3909]="0:12:1:1:::1:0::4:0", -- Broken Armor of Ana'thek
	[3910]="0:12:1:20:::1:0::4:0", -- Snuff
	[3911]="0:12:1:20:::1:0::4:0", -- Pulsing Blue Shard
	[3912]="0:12:1:1:::1:0::4:0", -- Soul Gem
	[3913]="0:12:1:1:::1:0::4:0", -- Filled Soul Gem
	[3914]="0:1:1:1:Bag::1:0::0:0", -- Journeyman's Backpack
	[3915]="0:12:1:25:::1:0::4:0", -- Bloody Bone Necklace
	[3916]="0:12:1:25:::1:0::4:0", -- Split Bone Necklace
	[3917]="0:12:1:20:::1:0::4:0", -- Singing Blue Crystal
	[3918]="0:12:1:20:::1:0::4:0", -- Singing Crystal Shard
	[3919]="0:12:1:20:::1:0::4:0", -- Mistvale Giblets
	[3920]="0:12:1:1:::1:0::4:0", -- Bloodsail Charts
	[3921]="0:12:1:1:::1:0::4:0", -- Bloodsail Orders
	[3922]="0:12:1:1:::1:0::4:0", -- Shaky's Payment
	[3923]="0:12:1:20:::1:0::4:0", -- Water Elemental Bracers
	[3924]="0:12:1:1:::1:0::4:0", -- Maury's Clubbed Foot
	[3925]="0:12:1:1:::1:0::4:0", -- Jon-Jon's Golden Spyglass
	[3926]="0:12:1:1:::1:0::4:0", -- Chucky's Huge Ring
	[3927]="2000:0:1:20:FoodDrink::5:0:295,465,483,1237,3298,3546,4782,4891,4894,4981,5620,6746,6790,6930,9501,11106,16553,17630,18929,23521,23604,24934,38714,40815,43972,44268,44417,44785,46269,46995,48125,49917:0:0", -- Fine Aged Cheddar
	[3928]="1000:0:1:20:Potion::1:1:983,8157,8158,8177,8178,11188,14847,18905,18908:0:0", -- Superior Healing Potion
	[3931]="0:15:0:20:Junk::1:0::0:0", -- Poisoned Spider Fang
	[3932]="0:12:1:1:::1:0::4:0", -- Smotts' Chest
	[3935]="0:2:1:1:OneHandSword::1:0::4:0", -- Smotts' Cutlass
	[3936]="0:4:0:1:Cloth::1:0::0:0", -- Crochet Belt
	[3937]="0:4:0:1:Cloth::1:0::0:0", -- Crochet Boots
	[3938]="0:4:0:1:Cloth::1:0::0:0", -- Crochet Bracers
	[3939]="0:4:0:1:Cloak::1:0::0:0", -- Crochet Cloak
	[3940]="0:4:0:1:Cloth::1:0::0:0", -- Crochet Gloves
	[3941]="0:4:0:1:Cloth::1:0::0:0", -- Crochet Pants
	[3942]="0:4:0:1:Cloth::1:0::0:0", -- Crochet Shoulderpads
	[3943]="0:4:0:1:Cloth::1:0::0:0", -- Crochet Vest
	[3944]="0:4:0:1:Cloth::1:0::0:0", -- Twill Belt
	[3945]="0:4:0:1:Cloth::1:0::0:0", -- Twill Boots
	[3946]="0:4:0:1:Cloth::1:0::0:0", -- Twill Bracers
	[3947]="0:4:0:1:Cloak::1:0::0:0", -- Twill Cloak
	[3948]="0:4:0:1:Cloth::1:0::0:0", -- Twill Gloves
	[3949]="0:4:0:1:Cloth::1:0::0:0", -- Twill Pants
	[3950]="0:4:0:1:Cloth::1:0::0:0", -- Twill Shoulderpads
	[3951]="0:4:0:1:Cloth::1:0::0:0", -- Twill Vest
	[3960]="0:12:1:1:::1:0::4:0", -- Bag of Water Elemental Bracers
	[3961]="0:4:0:1:Leather::1:0::0:0", -- Thick Leather Belt
	[3962]="0:4:0:1:Leather::1:0::0:0", -- Thick Leather Boots
	[3963]="0:4:0:1:Leather::1:0::0:0", -- Thick Leather Bracers
	[3964]="0:4:0:1:Cloak::1:0::0:0", -- Thick Cloak
	[3965]="0:4:0:1:Leather::1:0::0:0", -- Thick Leather Gloves
	[3966]="0:4:0:1:Leather::1:0::0:0", -- Thick Leather Pants
	[3967]="0:4:0:1:Leather::1:0::0:0", -- Thick Leather Shoulderpads
	[3968]="0:4:0:1:Leather::1:0::0:0", -- Thick Leather Tunic
	[3969]="0:4:0:1:Leather::1:0::0:0", -- Smooth Leather Belt
	[3970]="0:4:0:1:Leather::1:0::0:0", -- Smooth Leather Boots
	[3971]="0:4:0:1:Leather::1:0::0:0", -- Smooth Leather Bracers
	[3972]="0:4:0:1:Cloak::1:0::0:0", -- Smooth Cloak
	[3973]="0:4:0:1:Leather::1:0::0:0", -- Smooth Leather Gloves
	[3974]="0:4:0:1:Leather::1:0::0:0", -- Smooth Leather Pants
	[3975]="0:4:0:1:Leather::1:0::0:0", -- Smooth Leather Shoulderpads
	[3976]="0:4:0:1:Leather::1:0::0:0", -- Smooth Leather Armor
	[3985]="0:4:2:1:Cloth::1:0::3:0", -- Monogrammed Sash
	[3986]="0:4:0:1:Shield::1:0::0:0", -- Protective Pavise
	[3987]="0:4:0:1:Shield::1:0::0:0", -- Deflecting Tower
	[3989]="0:4:0:1:Shield::1:0::0:0", -- Blocking Targe
	[3990]="0:4:0:1:Shield::1:0::0:0", -- Crested Buckler
	[3992]="0:4:0:1:Mail::1:0::0:0", -- Laminated Scale Belt
	[3993]="0:4:0:1:Mail::1:0::0:0", -- Laminated Scale Boots
	[3994]="0:4:0:1:Mail::1:0::0:0", -- Laminated Scale Bracers
	[3995]="0:4:0:1:Cloak::1:0::0:0", -- Laminated Scale Cloak
	[3996]="0:4:0:1:Mail::1:0::0:0", -- Laminated Scale Gloves
	[3997]="0:4:0:1:Mail::1:0::0:0", -- Laminated Scale Pants
	[3998]="0:4:0:1:Mail::1:0::0:0", -- Laminated Scale Shoulderpads
	[3999]="0:4:0:1:Mail::1:0::0:0", -- Laminated Scale Armor
	[4000]="0:4:0:1:Mail::1:0::0:0", -- Overlinked Chain Belt
	[4001]="0:4:0:1:Mail::1:0::0:0", -- Overlinked Chain Boots
	[4002]="0:4:0:1:Mail::1:0::0:0", -- Overlinked Chain Bracers
	[4003]="0:4:0:1:Cloak::1:0::0:0", -- Overlinked Chain Cloak
	[4004]="0:4:0:1:Mail::1:0::0:0", -- Overlinked Chain Gloves
	[4005]="0:4:0:1:Mail::1:0::0:0", -- Overlinked Chain Pants
	[4006]="0:4:0:1:Mail::1:0::0:0", -- Overlinked Chain Shoulderpads
	[4007]="0:4:0:1:Mail::1:0::0:0", -- Overlinked Chain Armor
	[4016]="0:12:1:20:::1:0::4:0", -- Zanzil's Mixture
	[4017]="0:2:0:1:OneHandSword::1:0::0:0", -- Sharp Shortsword
	[4018]="0:2:0:1:TwoHandSword::1:0::0:0", -- Whetted Claymore
	[4019]="0:2:0:1:OneHandAxe::1:0::0:0", -- Heavy Flint Axe
	[4020]="0:2:0:1:TwoHandAxe::1:0::0:0", -- Splintering Battle Axe
	[4021]="0:2:0:1:OneHandMace::1:0::0:0", -- Blunting Mace
	[4022]="0:2:0:1:TwoHandMace::1:0::0:0", -- Crushing Maul
	[4023]="0:2:0:1:Dagger::1:0::0:0", -- Fine Pointed Dagger
	[4024]="0:2:0:1:Stave::1:0::0:0", -- Heavy War Staff
	[4025]="0:2:0:1:Bow::1:0::0:0", -- Balanced Long Bow
	[4026]="0:2:0:1:Gun::1:0::0:0", -- Sentinel Musket
	[4027]="0:12:1:1:::1:0::4:0", -- Catelyn's Blade
	[4028]="0:12:1:1:::1:0::4:0", -- Bundle of Akiris Reeds
	[4029]="0:12:1:20:::1:0::4:0", -- Akiris Reed
	[4034]="0:12:1:1:::1:0::4:0", -- Stone of the Tides
	[4035]="0:4:2:1:Cloth::1:0::2:0", -- Silver-Thread Robe
	[4036]="0:4:2:1:Cloth::1:0::2:0", -- Silver-Thread Cuffs
	[4037]="0:4:2:1:Cloth::1:0::2:0", -- Silver-Thread Pants
	[4038]="0:4:2:1:Cloth::1:0::2:0", -- Nightsky Robe
	[4039]="0:4:2:1:Cloth::1:0::2:0", -- Nightsky Cowl
	[4040]="0:4:2:1:Cloth::1:0::2:0", -- Nightsky Gloves
	[4041]="0:4:2:1:Cloth::1:0::2:0", -- Aurora Cowl
	[4042]="0:4:2:1:Cloth::1:0::2:0", -- Aurora Gloves
	[4043]="0:4:2:1:Cloth::1:0::2:0", -- Aurora Bracers
	[4044]="0:4:2:1:Cloth::1:0::2:0", -- Aurora Pants
	[4045]="0:4:2:1:Cloth::1:0::2:0", -- Mistscape Bracers
	[4046]="0:4:2:1:Cloth::1:0::2:0", -- Mistscape Pants
	[4047]="0:4:2:1:Cloth::1:0::2:0", -- Mistscape Boots
	[4048]="0:4:2:1:Leather::1:0::2:0", -- Emblazoned Hat
	[4049]="0:4:2:1:Leather::1:0::2:0", -- Emblazoned Bracers
	[4050]="0:4:2:1:Leather::1:0::2:0", -- Emblazoned Leggings
	[4051]="0:4:2:1:Leather::1:0::2:0", -- Emblazoned Boots
	[4052]="0:4:2:1:Leather::1:0::2:0", -- Insignia Cap
	[4053]="0:12:1:20:::1:0::4:0", -- Large River Crocolisk Skin
	[4054]="0:4:2:1:Leather::1:0::2:0", -- Insignia Leggings
	[4055]="0:4:2:1:Leather::1:0::2:0", -- Insignia Boots
	[4056]="0:12:1:1:::1:0::0:0", -- Cortello's Riddle
	[4057]="0:4:2:1:Leather::1:0::2:0", -- Insignia Chestguard
	[4058]="0:4:2:1:Leather::1:0::2:0", -- Glyphed Breastplate
	[4059]="0:4:2:1:Leather::1:0::2:0", -- Glyphed Bracers
	[4060]="0:4:2:1:Leather::1:0::2:0", -- Glyphed Leggings
	[4061]="0:4:2:1:Leather::1:0::2:0", -- Imperial Leather Bracers
	[4062]="0:4:2:1:Leather::1:0::2:0", -- Imperial Leather Pants
	[4063]="0:4:2:1:Leather::1:0::2:0", -- Imperial Leather Gloves
	[4064]="0:4:2:1:Shield::1:0::2:0", -- Emblazoned Buckler
	[4065]="0:4:2:1:Shield::1:0::2:0", -- Combat Shield
	[4066]="0:4:2:1:Shield::1:0::2:0", -- Insignia Buckler
	[4067]="0:4:2:1:Shield::1:0::2:0", -- Glyphed Buckler
	[4068]="0:4:2:1:Shield::1:0::2:0", -- Chief Brigadier Shield
	[4069]="0:4:2:1:Shield::1:0::2:0", -- Blackforge Buckler
	[4070]="0:4:2:1:Shield::1:0::2:0", -- Jouster's Crest
	[4071]="0:4:2:1:Mail::1:0::2:0", -- Glimmering Mail Breastplate
	[4072]="0:4:2:1:Mail::1:0::2:0", -- Glimmering Mail Gauntlets
	[4073]="0:4:2:1:Mail::1:0::2:0", -- Glimmering Mail Greaves
	[4074]="0:4:2:1:Mail::1:0::2:0", -- Mail Combat Armor
	[4075]="0:4:2:1:Mail::1:0::2:0", -- Mail Combat Gauntlets
	[4076]="0:4:2:1:Mail::1:0::2:0", -- Mail Combat Boots
	[4077]="0:4:2:1:Mail::1:0::2:0", -- Mail Combat Headguard
	[4078]="0:4:2:1:Mail::1:0::2:0", -- Chief Brigadier Coif
	[4079]="0:4:2:1:Mail::1:0::2:0", -- Chief Brigadier Leggings
	[4080]="0:4:2:1:Mail::1:0::2:0", -- Blackforge Cowl
	[4082]="0:4:2:1:Mail::1:0::2:0", -- Blackforge Breastplate
	[4083]="0:4:2:1:Mail::1:0::2:0", -- Blackforge Gauntlets
	[4084]="0:4:2:1:Mail::1:0::2:0", -- Blackforge Leggings
	[4085]="0:12:1:1:::1:0::4:0", -- Krazek's Crock Pot
	[4086]="0:2:2:1:Gun::1:0::3:0", -- Flash Rifle
	[4087]="0:2:2:1:Bow::1:0::2:0", -- Trueshot Bow
	[4088]="0:2:2:1:Dagger::1:0::2:0", -- Dreadblade
	[4089]="0:2:2:1:Gun::1:0::2:0", -- Ricochet Blunderbuss
	[4090]="0:2:3:1:OneHandMace::1:0::2:0", -- Mug O' Hurt
	[4091]="0:2:3:1:Dagger::1:0::2:0", -- Widowmaker
	[4092]="0:15:0:20:Junk::1:0::0:0", -- Prismatic Basilisk Scale
	[4093]="0:15:0:20:Junk::1:0::0:0", -- Large Basilisk Tail
	[4094]="0:12:1:1:::1:0::4:0", -- Tablet Shard
	[4096]="0:15:0:10:Junk::1:0::0:0", -- Coarse Gorilla Hair
	[4097]="0:15:0:20:Junk::1:0::0:0", -- Chipped Gorilla Tooth
	[4098]="0:15:0:1:Junk::1:0::0:0", -- Carefully Folded Note
	[4099]="0:15:0:20:Junk::1:0::0:0", -- Tuft of Gorilla Hair
	[4100]="0:15:0:20:Junk::1:0::0:0", -- Crumpled Note
	[4101]="0:15:0:20:Junk::1:0::0:0", -- Ripped Note
	[4102]="0:15:0:20:Junk::1:0::0:0", -- Torn Note
	[4103]="0:13:1:1:::1:0::4:0", -- Shackle Key
	[4104]="0:12:1:20:::1:0::4:0", -- Snapjaw Crocolisk Skin
	[4105]="0:12:1:20:::1:0::4:0", -- Elder Crocolisk Skin
	[4106]="0:12:1:20:::1:0::4:0", -- Tumbled Crystal
	[4107]="0:4:2:1:Leather::1:0::3:0", -- Tiger Hunter Gloves
	[4108]="0:4:2:1:Leather::1:0::3:0", -- Panther Hunter Leggings
	[4109]="0:4:2:1:Leather::1:0::3:0", -- Excelsior Boots
	[4112]="0:4:2:1:Amulet::1:0::3:0", -- Choker of the High Shaman
	[4113]="0:4:2:1:Cloak::1:0::3:0", -- Medicine Blanket
	[4114]="0:4:2:1:Cloak::1:0::3:0", -- Darktide Cape
	[4115]="0:4:2:1:Shield::1:0::3:0", -- Grom'gol Buckler
	[4116]="0:2:2:1:OneHandSword::1:0::3:0", -- Olmann Sewar
	[4117]="0:4:2:1:Cloth::1:0::3:0", -- Scorching Sash
	[4118]="0:4:2:1:Mail::1:0::3:0", -- Poobah's Nose Ring
	[4119]="0:4:2:1:Leather::1:0::3:0", -- Raptor Hunter Tunic
	[4120]="0:4:3:1:Cloth::1:0::3:0", -- Robe of Crystal Waters
	[4121]="0:4:2:1:Cloth::1:0::3:0", -- Gemmed Gloves
	[4122]="0:2:2:1:OneHandMace::1:0::3:0", -- Bookmaker's Scepter
	[4123]="0:4:2:1:Mail::1:0::3:0", -- Frost Metal Pauldrons
	[4124]="0:4:2:1:Leather::1:0::3:0", -- Cap of Harmony
	[4125]="0:4:2:1:OffHandFrill::1:0::3:0", -- Tranquil Orb
	[4126]="0:2:2:1:OneHandAxe::1:0::3:0", -- Guerrilla Cleaver
	[4127]="0:2:2:1:Gun::1:0::3:0", -- Shrapnel Blaster
	[4128]="0:2:2:1:TwoHandMace::1:0::3:0", -- Silver Spade
	[4129]="0:4:2:1:Shield::1:0::3:0", -- Collection Plate
	[4130]="0:4:2:1:Trinket::1:0::3:0", -- Smotts' Compass
	[4131]="0:4:2:1:Leather::1:0::3:0", -- Belt of Corruption
	[4132]="0:4:2:1:Mail::1:0::3:0", -- Darkspear Armsplints
	[4133]="0:4:2:1:Cloth::1:0::3:0", -- Darkspear Cuffs
	[4134]="0:2:3:1:Stave::1:0::3:0", -- Nimboya's Mystical Staff
	[4135]="0:4:2:1:Ring::1:0::3:0", -- Bloodbone Band
	[4136]="0:4:2:1:Mail::1:0::3:0", -- Darkspear Boots
	[4137]="0:4:2:1:Cloth::1:0::3:0", -- Darkspear Shoes
	[4138]="0:4:2:1:Mail::1:0::3:0", -- Blackwater Tunic
	[4139]="0:4:2:1:Cloth::1:0::3:0", -- Junglewalker Sandals
	[4140]="0:4:2:1:Cloth::1:0::3:0", -- Palm Frond Mantle
	[4197]="0:4:3:1:Cloth::1:0::3:0", -- Berylline Pads
	[4213]="0:9:0:1:Book::1:0::3:0", -- Grimoire of Doom
	[4228]="0:9:1:1:Book::1:0::0:0", -- Book of Moonfire IV
	[4231]="0:7:1:20:Leather:165:1:0::0:0", -- Cured Light Hide
	[4232]="500:7:1:10:Leather:165:1:1:44286:0:0", -- Medium Hide
	[4233]="0:7:1:20:Leather:165:1:0::0:0", -- Cured Medium Hide
	[4234]="600:7:1:20:Leather:164,202,165,197:1:1:14846,44286:0:0", -- Heavy Leather
	[4235]="0:7:1:10:Leather:165:1:0::0:0", -- Heavy Hide
	[4236]="0:7:1:20:Leather:165:1:0::0:0", -- Cured Heavy Hide
	[4237]="0:4:1:1:Leather::1:0::0:0", -- Handstitched Leather Belt
	[4238]="0:1:1:1:Bag::1:0::0:0", -- Linen Bag
	[4239]="0:4:2:1:Leather::1:0::2:0", -- Embossed Leather Gloves
	[4240]="0:1:1:1:Bag::1:0::0:0", -- Woolen Bag
	[4241]="0:1:1:1:Bag::1:0::0:0", -- Green Woolen Bag
	[4242]="0:4:2:1:Leather::1:0::2:0", -- Embossed Leather Pants
	[4243]="0:4:2:1:Leather:165:1:0::2:0", -- Fine Leather Tunic
	[4244]="0:4:2:1:Leather::1:0::2:0", -- Hillman's Leather Vest
	[4245]="0:1:1:1:Bag::1:0::0:0", -- Small Silk Pack
	[4246]="0:4:2:1:Leather:165:1:0::2:0", -- Fine Leather Belt
	[4247]="0:4:2:1:Leather::1:0::2:0", -- Hillman's Leather Gloves
	[4248]="0:4:2:1:Leather::1:0::2:0", -- Dark Leather Gloves
	[4249]="0:4:2:1:Leather::1:0::2:0", -- Dark Leather Belt
	[4250]="0:4:2:1:Leather::1:0::2:0", -- Hillman's Belt
	[4251]="0:4:2:1:Leather::1:0::2:0", -- Hillman's Shoulders
	[4252]="0:4:2:1:Leather::1:0::2:0", -- Dark Leather Shoulders
	[4253]="0:4:3:1:Leather::1:0::2:0", -- Toughened Leather Gloves
	[4254]="0:4:2:1:Leather::1:0::2:0", -- Barbaric Gloves
	[4255]="0:4:2:1:Leather:164:1:0::2:0", -- Green Leather Armor
	[4256]="0:4:2:1:Leather::1:0::2:0", -- Guardian Armor
	[4257]="0:4:2:1:Leather::1:0::2:0", -- Green Leather Belt
	[4258]="0:4:2:1:Leather::1:0::2:0", -- Guardian Belt
	[4259]="0:4:2:1:Leather::1:0::2:0", -- Green Leather Bracers
	[4260]="0:4:2:1:Leather::1:0::2:0", -- Guardian Leather Bracers
	[4261]="0:4:1:1:Cloth::1:0::0:0", -- Solliden's Trousers
	[4262]="0:4:3:1:Leather::1:0::2:0", -- Gem-Studded Leather Belt
	[4263]="0:4:1:1:Shield::1:0::0:0", -- Standard Issue Shield
	[4264]="0:4:2:1:Leather::1:0::2:0", -- Barbaric Belt
	[4265]="0:0:1:10:EnhPerm::1:0::0:0", -- Heavy Armor Kit
	[4278]="0:12:1:20:::1:0::0:0", -- Lesser Bloodstone Ore
	[4289]="50:7:1:20:Leather:165:1:0:66,777,843,960,989,1148,1250,1286,1456,1465,1692,2118,2225,2393,2697,2698,2699,2810,2816,2819,2821,2846,3008,3081,3168,3187,3366,3367,3482,3499,3556,3614,3779,3954,3958,4194,4225,4229,4561,4589,4775,4897,5100,5128,5135,5163,5565,5817,7854,7947,8145,8160,8363,8934,9636,11189,11874,12022,12028,12043,12245,12941,12942,12943,12956,12958,15179,16224,16261,16262,16613,16689,16748,16768,17486,17490,18009,18277,18426,18427,18754,18771,19196,19244,19372,19450,19532,21085,24843,24935,25010,25051,25082,27021,27026,27037,27043,27057,28692,28718,28798,28831,28872,29288,30311,32979,33601,33635,33641,33681,33683,34601,36695,36779,38783,38853,38873,40226,40474,41053,41275,41490,41676,41891,42853,43380,43495,43550,43554,43558,43568,43880,43980,44027,44034,44186,44301,44341,44383,44386,44780,45093,45286,45490,45497,45552,46184,47104,47153,47164,47347,47721,47863,47939,48058,48098,48123,48235,48551,48574,48608,48868,49404,49714,49885,50071,50094,50457,53075,53436,53782:0:0", -- Salt
	[4290]="0:4:2:1:Shield::1:0::2:0", -- Dust Bowl
	[4291]="500:7:1:20:Cloth:165,197:1:0:960,989,1148,1286,1347,1454,1456,1474,1672,2225,2393,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3008,3091,3364,3366,3367,3485,3779,3954,3958,4168,4225,4229,4561,4577,4589,4775,4897,5100,5128,5135,5154,5163,5565,5817,6567,6568,6574,7854,7940,7947,8145,8160,8363,8681,8934,9636,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12958,15179,16366,16613,16638,16689,16748,16767,16768,17486,18009,18277,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,25010,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,32979,33596,33601,33635,33636,33681,33684,34601,38873,40226,40474,40572,41053,41275,41490,41676,41891,43380,43495,43550,43554,43568,43880,43980,44027,44186,44301,44341,44383,44386,44780,45093,45286,45552,45558,46184,47104,47153,47164,47347,47721,47856,47863,47939,48058,48098,48123,48235,48551,48574,48587,48608,48857,48860,48868,49404,49705,49714,49885,49888,50071,50094,50456,50457,53075,53436,53782:0:0", -- Silken Thread
	[4292]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Green Woolen Bag
	[4293]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Hillman's Leather Vest
	[4294]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Hillman's Belt
	[4296]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Dark Leather Shoulders
	[4297]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Barbaric Gloves
	[4298]="0:9:3:1:Leatherworking::1:0::0:0", -- Pattern: Guardian Belt
	[4299]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Guardian Armor
	[4300]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Guardian Leather Bracers
	[4301]="0:9:3:1:Leatherworking::1:0::0:0", -- Pattern: Barbaric Belt
	[4302]="0:2:1:1:Dagger::1:0::0:0", -- Small Green Dagger
	[4303]="0:2:2:1:OneHandMace::1:0::2:0", -- Cranial Thumper
	[4304]="1200:7:1:20:Leather:164,202,165,197:1:1:14846:0:0", -- Thick Leather
	[4305]="2400:7:1:20:Cloth:165,197:1:1:16631:0:0", -- Bolt of Silk Cloth
	[4306]="600:7:1:20:Cloth:164,202,129,197:1:1:16631:0:0", -- Silk Cloth
	[4307]="0:4:2:1:Cloth::1:0::2:0", -- Heavy Linen Gloves
	[4308]="0:4:2:1:Cloth::1:0::2:0", -- Green Linen Bracers
	[4309]="0:4:2:1:Cloth::1:0::2:0", -- Handstitched Linen Britches
	[4310]="0:4:2:1:Cloth::1:0::2:0", -- Heavy Woolen Gloves
	[4311]="0:4:2:1:Cloak::1:0::2:0", -- Heavy Woolen Cloak
	[4312]="0:4:2:1:Cloth::1:0::2:0", -- Soft-Soled Linen Boots
	[4313]="0:4:2:1:Cloth::1:0::2:0", -- Red Woolen Boots
	[4314]="0:4:2:1:Cloth::1:0::2:0", -- Double-Stitched Woolen Shoulders
	[4315]="0:4:2:1:Cloth::1:0::2:0", -- Reinforced Woolen Shoulders
	[4316]="0:4:2:1:Cloth::1:0::2:0", -- Heavy Woolen Pants
	[4317]="0:4:2:1:Cloth::1:0::2:0", -- Phoenix Pants
	[4318]="0:4:2:1:Cloth::1:0::2:0", -- Gloves of Meditation
	[4319]="0:4:2:1:Cloth::1:0::2:0", -- Azure Silk Gloves
	[4320]="0:4:3:1:Cloth::1:0::2:0", -- Spidersilk Boots
	[4321]="0:4:2:1:Cloth::1:0::2:0", -- Spider Silk Slippers
	[4322]="0:4:2:1:Cloth::1:0::2:0", -- Enchanter's Cowl
	[4323]="0:4:2:1:Cloth::1:0::2:0", -- Shadow Hood
	[4324]="0:4:2:1:Cloth::1:0::2:0", -- Azure Silk Vest
	[4325]="0:4:2:1:Cloth::1:0::2:0", -- Boots of the Enchanter
	[4326]="0:4:2:1:Cloak::1:0::2:0", -- Long Silken Cloak
	[4327]="0:4:3:1:Cloak::1:0::2:0", -- Icy Cloak
	[4328]="0:4:2:1:Cloth::1:0::2:0", -- Spider Belt
	[4329]="0:4:2:1:Cloth::1:0::2:0", -- Star Belt
	[4330]="0:4:1:1:Shirt::1:0::0:0", -- Stylish Red Shirt
	[4331]="0:4:2:1:Cloth::1:0::2:0", -- Phoenix Gloves
	[4332]="0:4:1:1:Shirt::1:0::0:0", -- Bright Yellow Shirt
	[4333]="0:4:1:1:Shirt::1:0::0:0", -- Dark Silk Shirt
	[4334]="0:4:1:1:Shirt::1:0::0:0", -- Formal White Shirt
	[4335]="0:4:1:1:Shirt::1:0::0:0", -- Rich Purple Silk Shirt
	[4336]="0:4:1:1:Shirt::1:0::0:0", -- Black Swashbuckler's Shirt
	[4337]="0:7:1:10:Cloth:202,165,197:1:0::0:0", -- Thick Spider's Silk
	[4338]="1000:7:1:20:Cloth:164,202,129,165,197:1:1:16631:0:0", -- Mageweave Cloth
	[4339]="0:7:1:20:Cloth:202,197:1:0::0:0", -- Bolt of Mageweave
	[4340]="350:7:1:10:Other:165,197:1:0:989,1148,1286,1347,1454,1474,1672,2225,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3008,3091,3364,3366,3367,3485,3779,3954,3958,4168,4225,4229,4561,4577,4589,4775,4897,5128,5135,5154,5163,5565,5817,6567,6568,6574,7854,7940,7947,8145,8160,8363,8681,8934,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12958,15179,16366,16613,16638,16689,16748,16767,16768,17486,18009,18277,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,25010,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,32979,33596,33601,33635,33636,33681,33684,34601,38873,40226,40474,40572,41053,41275,41490,41676,41891,43380,43495,43550,43554,43568,43880,43980,44027,44186,44341,44383,44386,44780,45093,45552,45558,46184,47153,47164,47347,47856,48098,48551,48574,48587,48608,48857,48860,48868,49404,49705,49714,49888,50071,50094,50456,50457,53075,53436,53782:0:0", -- Gray Dye
	[4341]="500:7:1:10:Other:197:1:0:989,1148,1286,1347,1454,1474,1672,2225,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3008,3091,3364,3366,3367,3485,3779,3954,3958,4168,4225,4229,4561,4577,4589,4775,4897,5128,5135,5154,5163,5565,5817,6567,6568,6574,7854,7940,7947,8145,8160,8363,8681,8934,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12958,15179,16366,16613,16638,16689,16748,16767,16768,17486,18009,18277,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,25010,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,32979,33596,33601,33635,33636,33681,33684,34601,38873,40226,40474,40572,41053,41275,41490,41676,41891,43380,43495,43550,43554,43568,43880,43980,44027,44186,44341,44383,44386,44780,45093,45552,45558,46184,47153,47164,47347,47856,48098,48551,48574,48587,48608,48857,48860,48868,49404,49705,49714,49888,50071,50094,50456,50457,53075,53436,53782:0:0", -- Yellow Dye
	[4342]="2500:7:1:10:Other:171,202,165,197:1:0:989,1148,1286,1347,1454,1474,1672,2225,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3008,3091,3364,3366,3367,3485,3779,3954,3958,4168,4225,4229,4561,4577,4589,4775,4897,5128,5135,5154,5163,5565,5817,6567,6568,6574,7854,7940,7947,8145,8160,8363,8681,8934,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12958,15179,16366,16613,16638,16689,16748,16767,16768,17486,18009,18277,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,25010,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,32979,33596,33601,33635,33636,33681,33684,34601,38873,40226,40474,40572,41053,41275,41490,41676,41891,43380,43495,43550,43554,43568,43880,43980,44027,44186,44341,44383,44386,44780,45093,45552,45558,46184,47153,47164,47347,47856,48098,48551,48574,48587,48608,48857,48860,48868,49404,49705,49714,49888,50071,50094,50456,50457,53075,53436,53782:0:0", -- Purple Dye
	[4343]="0:4:2:1:Cloth::1:0::2:0", -- Brown Linen Pants
	[4344]="0:4:1:1:Shirt::1:0::0:0", -- Brown Linen Shirt
	[4345]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Red Woolen Boots
	[4346]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Heavy Woolen Cloak
	[4347]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Reinforced Woolen Shoulders
	[4348]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Phoenix Gloves
	[4349]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Phoenix Pants
	[4350]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Spider Silk Slippers
	[4351]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Shadow Hood
	[4352]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Boots of the Enchanter
	[4353]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Spider Belt
	[4354]="0:9:3:1:Tailoring::1:0::0:0", -- Pattern: Rich Purple Silk Shirt
	[4355]="1500:9:1:1:Tailoring::1:1:6567:0:0", -- Pattern: Icy Cloak
	[4356]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Star Belt
	[4357]="16:7:1:20:Part:202:1:1:1448,1694,2685,2687,2688,3133,3413,3495,4587,4941,5175,5519,6777,8679,9676,11185,14337,14637,16657,16782,17222,17421,18278,18484,18752,18775,19383,20890,26600,26898,27711,28722,28797,29688,29907,30345,30434,30825,31776,31781,33594,33634,33669,33677,37904,37935,41435,41493,41675,41890,42488,42676,42876,42909,42972,43705,43708,43709,43710,43711,44005,44194,44280,45293,45294,45546,45843,47340,47530,48056,48238,49409,49433,49788,49918,52637,52655:0:0", -- Rough Blasting Powder
	[4358]="0:7:1:20:Explosive::1:0::0:0", -- Rough Dynamite
	[4359]="0:7:1:20:Part:202:1:0::0:0", -- Handful of Copper Bolts
	[4360]="0:7:1:20:Explosive::1:0::0:0", -- Rough Copper Bomb
	[4361]="480:15:0:20:Junk::1:1:1448,1694,2685,2687,2688,3133,3413,3495,4587,5175,5519,6777,8679,11185,14637,16657,16782,17222,17421,18278,18484,18752,18775,19383,20890,26600,26898,27711,28722,28797,29688,29907,30345,30434,30825,31776,31781,33594,33634,33669,33677,41435,41493,41675,41890,42488,42676,42876,42909,42972,43705,43708,43709,43710,43711,44005,44194,44280,45293,45294,45546,45843,47340,47530,48056,48238,49409,49433,49788,49918,52637,52655:0:0", -- Bent Copper Tube
	[4362]="0:2:2:1:Gun::1:0::2:0", -- Rough Boomstick
	[4363]="200:15:0:20:Junk::1:1:2685,3413,3495,5175,5519,16782,17421,18278,18484,19383,26898,27711,28722,28797,29688,29907,30434,33669,33677,41675,42488,42876,42909,42972,43705,43709,43710,44194,45293,45294,45546,45843,47530,49409,49788:0:0", -- Broken Modulator
	[4364]="48:7:1:20:Part:202:1:1:1448,1694,2685,2687,2688,3133,3413,3495,4587,4941,5175,5519,6777,8679,9676,11185,14337,14637,16657,16782,17222,17421,18278,18484,18752,18775,19383,20890,26600,26898,27711,28722,28797,29688,29907,30345,30434,30825,31776,31781,33594,33634,33669,33677,37904,37935,41435,41493,41675,41890,42488,42676,42876,42909,42972,43705,43708,43709,43710,43711,44005,44194,44280,44305,45293,45294,45546,45843,47340,47530,48056,48238,49409,49433,49788,49918,52637,52655:0:0", -- Coarse Blasting Powder
	[4365]="0:7:1:20:Explosive::1:0::0:0", -- Coarse Dynamite
	[4366]="0:7:1:10:Device::1:0::0:0", -- Target Dummy
	[4367]="0:7:1:10:Explosive::1:0::0:0", -- Small Seaforium Charge
	[4368]="0:4:2:1:Cloth:202:1:0::2:0", -- Flying Tiger Goggles
	[4369]="0:2:2:1:Gun::1:0::2:0", -- Deadly Blunderbuss
	[4370]="0:7:1:20:Explosive::1:0::0:0", -- Large Copper Bomb
	[4371]="800:7:1:20:Part:202:1:1:1448,1694,2685,2687,2688,3133,3413,3495,4587,4941,5175,5519,6777,8679,11185,14637,16657,16782,17222,17421,18278,18484,18752,18775,19383,20890,26600,26898,27711,28722,28797,29688,29907,30345,30434,30825,31776,31781,33594,33634,33669,33677,41435,41493,41675,41890,42488,42676,42876,42909,42972,43705,43708,43709,43710,43711,44005,44194,44280,44305,45293,45294,45546,45843,47340,47530,48056,48238,49409,49433,49788,49918,52637,52655:0:0", -- Bronze Tube
	[4372]="0:2:2:1:Gun::1:0::2:0", -- Lovingly Crafted Boomstick
	[4373]="0:4:2:1:Cloth::1:0::2:0", -- Shadow Goggles
	[4374]="0:7:1:20:Explosive::1:0::0:0", -- Small Bronze Bomb
	[4375]="0:7:1:10:Part:202:1:0::0:0", -- Whirring Bronze Gizmo
	[4376]="0:7:1:1:Device::1:0::0:0", -- Flame Deflector
	[4377]="0:7:1:20:Part:202:1:0::0:0", -- Heavy Blasting Powder
	[4378]="1400:7:1:20:Explosive::1:1:3180:0:0", -- Heavy Dynamite
	[4379]="0:2:2:1:Gun::1:0::2:0", -- Silver-Plated Shotgun
	[4380]="0:7:1:20:Explosive::1:0::0:0", -- Big Bronze Bomb
	[4381]="0:4:2:1:Trinket::1:0::0:0", -- Minor Recombobulator
	[4382]="2400:7:1:10:Part:202:1:1:1448,2685,2687,2688,3133,3413,3495,4587,4941,5175,5519,6777,8679,11185,14637,16657,16782,17222,17421,18278,18484,18752,18775,19383,20890,26600,26898,27711,28722,28797,29688,29907,30345,30434,30825,31776,31781,33594,33634,33669,33677,41435,41493,41675,41890,42488,42676,42876,42909,42972,43705,43708,43709,43710,43711,44005,44194,44280,45293,45294,45546,45843,47340,47530,48056,48238,49409,49433,49788,49918,52637,52655:0:0", -- Bronze Framework
	[4383]="0:2:2:1:Gun::1:0::2:0", -- Moonsight Rifle
	[4384]="0:7:1:20:Explosive::1:0::0:0", -- Explosive Sheep
	[4385]="0:4:2:1:Cloth:202:1:0::2:0", -- Green Tinted Goggles
	[4386]="0:7:1:1:Device::1:0::0:0", -- Ice Deflector
	[4387]="0:7:1:10:Part:202:1:0::0:0", -- Iron Strut
	[4388]="0:7:1:1:Device::1:0::0:0", -- Discombobulator Ray
	[4389]="3000:7:1:10:Part:202:1:1:1448,2685,2687,3413,3495,4587,5175,5519,6777,8679,11185,14637,16782,18278,18484,18752,18775,19383,20890,26600,26898,27711,28722,28797,29688,29907,30345,30434,30825,31776,33594,33669,33677,41435,41493,41675,41890,42488,42676,42876,42909,42972,43705,43708,43709,43710,44005,44305,45293,45294,45546,45843,47340,47530,49409,49433,49788,49918,52637,52655:0:0", -- Gyrochronatom
	[4390]="0:7:1:20:Explosive::1:0::0:0", -- Iron Grenade
	[4391]="0:7:1:5:Device::1:0::0:0", -- Compact Harvest Reaper Kit
	[4392]="0:7:1:10:Device::1:0::0:0", -- Advanced Target Dummy
	[4393]="0:4:2:1:Cloth::1:0::2:0", -- Craftsman's Monocle
	[4394]="0:7:1:20:Explosive:202:1:0::0:0", -- Big Iron Bomb
	[4395]="0:7:1:20:Explosive::1:0::0:0", -- Goblin Land Mine
	[4396]="0:4:2:1:Trinket::1:0::2:0", -- Mechanical Dragonling
	[4397]="0:4:2:1:Trinket::1:0::2:0", -- Gnomish Cloaking Device
	[4398]="0:7:1:20:Explosive::1:0::0:0", -- Large Seaforium Charge
	[4399]="200:7:1:10:Part:202:1:0:960,989,1148,1286,1448,1456,1694,2225,2393,2685,2687,2688,2810,2821,3133,3367,3413,3495,3779,3954,4229,4561,4587,4775,4897,4941,5100,5135,5163,5175,5519,5817,6777,7947,8145,8363,8679,8934,9636,9676,11185,11189,12022,12028,12245,12941,12958,14337,14637,15179,16613,16657,16768,16782,17222,17421,17486,18009,18278,18484,18752,18775,19244,19372,19383,19450,20890,24843,24935,25010,25051,25082,26600,26898,27021,27026,27043,27057,27711,28692,28722,28797,28831,28872,29288,29688,29907,30311,30345,30434,30825,31776,31781,32979,33594,33634,33669,33677,37904,37935,40474,41053,41275,41435,41490,41493,41675,41676,41890,41891,42488,42676,42876,42909,42972,43705,43708,43709,43710,43711,43980,44005,44186,44194,44280,44301,44305,44341,44383,44780,45093,45286,45293,45294,45546,45552,45843,47104,47153,47164,47340,47347,47530,47721,47863,47939,48056,48058,48098,48123,48235,48238,48551,48574,48868,49409,49433,49702,49788,49885,49918,50460,52637,52655:0:0", -- Wooden Stock
	[4400]="2000:7:1:10:Part:202:1:0:960,989,1148,1286,1448,1456,1694,2225,2393,2685,2687,2688,2810,2821,3133,3367,3413,3495,3779,3954,4229,4561,4587,4775,4897,4941,5100,5135,5163,5175,5519,5817,6777,7947,8145,8363,8679,8934,9636,9676,11185,11189,12022,12028,12245,12941,12958,14337,14637,15179,16613,16657,16768,16782,17222,17421,17486,18009,18278,18484,18752,18775,19244,19372,19383,19450,20890,24843,24935,25010,25051,25082,26600,26898,27021,27026,27043,27057,27711,28692,28722,28797,28831,28872,29288,29688,29907,30311,30345,30434,30825,31776,31781,32979,33594,33634,33669,33677,37904,37935,40474,41053,41275,41435,41490,41493,41675,41676,41890,41891,42488,42676,42876,42909,42972,43705,43708,43709,43710,43711,43980,44005,44186,44194,44280,44301,44305,44341,44383,44780,45093,45286,45293,45294,45546,45552,45843,47104,47153,47164,47340,47347,47530,47721,47863,47939,48056,48058,48098,48123,48235,48238,48551,48574,48868,49409,49433,49702,49788,49885,49918,50460,52637,52655:0:0", -- Heavy Stock
	[4401]="0:15:1:1:Companion::1:0::0:0", -- Mechanical Squirrel Box
	[4402]="0:7:1:5:Other:171,185,202:1:0::0:0", -- Small Flame Sac
	[4403]="0:7:1:1:Device::1:0::0:0", -- Portable Bronze Mortar
	[4404]="100:7:1:20:Part:202:1:1:1448,1694,2685,2687,2688,3133,3413,3495,4587,5175,5519,6777,8679,11185,14637,16657,16782,17421,18278,18484,18752,18775,19383,20890,26600,26898,27711,28722,28797,29688,29907,30345,30434,30825,31776,31781,33594,33669,33677,41435,41493,41675,41890,42488,42676,42876,42909,42972,43705,43708,43709,43710,44005,44280,44305,45293,45294,45546,45843,47340,47530,48056,48238,49409,49433,49788,49918,52637,52655:0:0", -- Silver Contact
	[4405]="0:0:1:5:EnhPerm::1:0::0:0", -- Crude Scope
	[4406]="0:0:1:5:EnhPerm:202:1:0::0:0", -- Standard Scope
	[4407]="0:0:2:5:EnhPerm:202:1:0::0:0", -- Accurate Scope
	[4408]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Mechanical Squirrel Box
	[4409]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Small Seaforium Charge
	[4410]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Shadow Goggles
	[4411]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Flame Deflector
	[4412]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Moonsight Rifle
	[4413]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Discombobulator Ray
	[4414]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Portable Bronze Mortar
	[4415]="0:9:3:1:Engineering::1:0::0:0", -- Schematic: Craftsman's Monocle
	[4416]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Goblin Land Mine
	[4417]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Large Seaforium Charge
	[4419]="450:0:1:20:Scroll::1:1:14847:0:0", -- Scroll of Intellect III
	[4421]="400:0:1:20:Scroll::1:1:4581,12246,14847:0:0", -- Scroll of Protection III
	[4422]="450:0:1:20:Scroll::1:1:14847:0:0", -- Scroll of Stamina III
	[4424]="400:0:1:20:Scroll::1:1:4581,12246,14847:0:0", -- Scroll of Spirit III
	[4425]="500:0:1:20:Scroll::1:1:4581,14847,20092:0:0", -- Scroll of Agility III
	[4426]="500:0:1:20:Scroll::1:1:4581,14847,20092:0:0", -- Scroll of Strength III
	[4428]="0:15:0:20:Junk::1:0::0:0", -- Spider Palp
	[4429]="0:12:1:1:::1:0::4:0", -- Deepfury's Orders
	[4430]="0:4:2:1:Amulet::1:0::3:0", -- Ethereal Talisman
	[4432]="0:12:1:1:::1:0::4:0", -- Sully Balloo's Letter
	[4434]="0:4:2:1:Cloth::1:0::2:0", -- Scarecrow Trousers
	[4435]="0:12:1:20:::1:0::4:0", -- Mote of Myzrael
	[4436]="0:4:2:1:Cloth::1:0::2:0", -- Jewel-Encrusted Sash
	[4437]="0:2:2:1:Stave::1:0::2:0", -- Channeler's Staff
	[4438]="0:4:3:1:Mail::1:0::2:0", -- Pugilist Bracers
	[4439]="0:2:2:1:OneHandMace::1:0::2:0", -- Bruiser Club
	[4440]="0:12:1:1:::1:0::4:0", -- Sigil of Strom
	[4441]="0:12:1:1:::1:0::4:0", -- MacKreel's Moonshine
	[4443]="0:4:2:1:Mail::1:0::3:0", -- Grim Pauldrons
	[4444]="0:4:2:1:Shield::1:0::2:0", -- Black Husk Shield
	[4445]="0:2:2:1:OneHandAxe::1:0::2:0", -- Flesh Carver
	[4446]="0:2:3:1:Dagger::1:0::2:0", -- Blackvenom Blade
	[4447]="0:4:2:1:Cloak::1:0::2:0", -- Cloak of Night
	[4448]="0:4:2:1:Mail::1:0::2:0", -- Husk of Naraxis
	[4449]="0:2:2:1:Dagger::1:0::2:0", -- Naraxis' Fang
	[4450]="0:12:1:20:::1:0::4:0", -- Sigil Fragment
	[4453]="0:12:1:1:::1:0::4:0", -- Sigil of Thoradin
	[4454]="0:2:3:1:Dagger::1:0::2:0", -- Talon of Vultros
	[4455]="0:4:2:1:Leather::1:0::2:0", -- Raptor Hide Harness
	[4456]="0:4:2:1:Leather::1:0::2:0", -- Raptor Hide Belt
	[4457]="0:0:1:20:FoodDrink::1:0::0:0", -- Barbecued Buzzard Wing
	[4458]="0:12:1:1:::1:0::4:0", -- Sigil of Arathor
	[4459]="0:15:0:20:Junk::1:0::0:0", -- Brittle Dragon Bone
	[4460]="0:15:0:20:Junk::1:0::0:0", -- Ripped Wing Webbing
	[4461]="0:7:1:10:Leather:165:1:0::0:0", -- Raptor Hide
	[4462]="0:4:2:1:Cloak::1:0::2:0", -- Cloak of Rot
	[4463]="0:4:2:1:Cloth::1:0::2:0", -- Beaded Raptor Collar
	[4464]="0:4:2:1:Mail::1:0::2:0", -- Trouncing Boots
	[4465]="0:4:2:1:Mail::1:0::2:0", -- Felstrom's Gauntlets
	[4466]="0:12:1:1:::1:0::4:0", -- Sigil of Trollbane
	[4467]="0:12:1:1:::1:0::4:0", -- Sigil of Ignaeus
	[4468]="0:12:1:1:::1:0::4:0", -- Sheathed Trol'kalar
	[4469]="0:12:1:1:::1:0::4:0", -- Rod of Order
	[4470]="38:7:1:20:Other:333,202:1:0:151,227,491,791,1149,1250,1285,1318,1448,1452,1650,1682,1685,1691,2084,2134,2140,2401,2803,2808,2820,2908,3012,3076,3164,3186,3313,3346,3350,3481,3498,3608,3625,3962,4082,4170,4228,4241,4555,4617,4896,5101,5134,5158,5757,5758,7942,8362,11038,11555,12021,12027,12036,12246,12959,12960,14624,15174,15397,15419,16187,16191,16259,16260,16444,16635,16722,16732,16826,17421,17446,17489,18011,18753,18773,18810,18811,18907,18951,18959,19020,19021,19053,19197,19234,19243,19314,19315,19343,19374,19436,19452,19474,19498,19534,19537,19540,19560,19574,19625,19649,19663,19679,20080,20092,20194,20231,20249,20892,21082,21111,21172,21183,22099,22270,23143,23802,24053,24141,24188,24348,25035,26388,26569,26718,26934,26936,26938,27011,27022,27025,27030,27039,27041,27051,27054,27058,27071,27145,27147,27182,27193,27940,28691,28714,28715,28792,28807,28830,28867,29035,29207,29537,29908,29925,29944,29962,29970,30011,30070,30256,30257,30310,31022,32477,32638,32642,33597,33633,33676,33872,36365,36695,36779,38783,38847,38853,40826,40914,41053,41128,41275,41490,41676,41891,42853,43384,43419,43424,43425,43558,43637,43748,43953,44001,44019,44030,44034,44114,44177,44183,44294,44296,44297,44300,44302,44303,44304,44321,44343,44344,44376,44381,44398,44779,45094,45286,45289,45290,45361,45484,45491,45496,45497,45553,46659,46994,47105,47139,47148,47167,47757,47858,47938,48067,48093,48122,48236,48607,48884,49397,49406,49435,49525,49547,49603,49775,49885,49919,50126,50458,50459,51709,53410:0:0", -- Simple Wood
	[4471]="0:7:0:1:Other::1:0::0:0", -- Flint and Tinder
	[4472]="0:12:1:1:::1:0::4:0", -- Scroll of Myzrael
	[4473]="0:12:1:1:::1:0::4:0", -- Eldritch Shackles
	[4474]="0:2:2:1:Bow::1:0::2:0", -- Ravenwood Bow
	[4476]="0:4:2:1:Cloth::1:0::2:0", -- Beastwalker Robe
	[4477]="0:4:2:1:Shield::1:0::2:0", -- Nefarious Buckler
	[4478]="0:4:2:1:Mail::1:0::2:0", -- Iridescent Scale Leggings
	[4479]="0:0:1:10:Other::1:0::0:0", -- Burning Charm
	[4480]="0:0:1:10:Other::1:0::0:0", -- Thundering Charm
	[4481]="0:0:1:10:Other::1:0::0:0", -- Cresting Charm
	[4482]="0:12:1:1:::1:0::4:0", -- Sealed Folder
	[4483]="0:13:1:1:::1:0::4:0", -- Burning Key
	[4484]="0:13:1:1:::1:0::4:0", -- Cresting Key
	[4485]="0:13:1:1:::1:0::4:0", -- Thundering Key
	[4487]="0:12:1:1:::1:0::4:0", -- Maiden's Folly Charts
	[4488]="0:12:1:1:::1:0::4:0", -- Spirit of Silverpine Charts
	[4489]="0:12:1:1:::1:0::4:0", -- Maiden's Folly Log
	[4490]="0:12:1:1:::1:0::4:0", -- Spirit of Silverpine Log
	[4491]="0:12:1:1:::1:0::4:0", -- Goggles of Gem Hunting
	[4492]="0:12:1:20:::1:0::4:0", -- Elven Gem
	[4493]="0:12:1:1:::1:0::4:0", -- Elven Gems
	[4494]="0:12:1:1:::1:0::4:0", -- Seahorn's Sealed Letter
	[4495]="0:12:1:20:::1:0::4:0", -- Bloodstone Amulet
	[4496]="500:1:1:1:Bag::1:0:151,152,491,791,829,1250,1321,1682,1685,1691,2115,2134,2140,3016,3072,3076,3158,3164,3186,3313,3369,3481,3487,3498,3587,3608,4082,4170,4230,4241,4555,4590,5132,7942,8362,8364,8416,12027,12960,16187,16191,16259,16260,16444,16690,16709,16732,17421,17446,17489,18810,18811,18947,19197,19560,36695,36779,38783,38853,39032,42853,43384,43419,43424,43425,43558,43637,43953,44034,44183,45484,45491,45496,45497,46966,46994,48858,49397,49435,51709:0:0", -- Small Brown Pouch
	[4497]="20000:1:1:1:Bag::1:0:227,1149,1285,1321,1448,1452,2084,2401,2803,2808,2820,2908,3016,3313,3350,3369,3487,3625,3962,4170,4230,4241,4555,4590,4896,5101,5132,5134,7942,8362,8364,11038,11555,12021,12027,12036,12246,12959,12960,14624,15174,15397,16191,16690,16709,16732,17489,18947,19197,19560,38847,40826,40914,41053,41128,41275,41490,41676,41891,43637,43748,43953,44001,44019,44114,44177,44183,44294,44296,44297,44300,44302,44303,44304,44343,44344,44376,44398,44779,45094,45553,46659,47105,47139,47148,47167,47757,47858,47938,48067,48093,48122,48236,48607,48858,49919,50126:0:0", -- Heavy Brown Bag
	[4498]="2500:1:1:1:Bag::1:0:151,227,491,791,1250,1321,1448,1452,1682,1685,1691,2134,2140,2401,2803,3016,3076,3164,3186,3313,3369,3481,3487,3498,3608,3962,4082,4170,4230,4241,4555,4590,5132,7942,8362,8364,12021,12027,12036,12960,16187,16191,16259,16260,16444,16690,16709,16732,17421,17446,17489,18810,18811,18947,19197,19560,36695,36779,38783,38853,41128,42853,43384,43419,43424,43425,43558,43637,43953,44001,44034,44114,44177,44183,44294,44296,44297,44300,44303,44304,45484,45491,45496,45497,46659,46994,47858,48067,48093,48858,49397,49435,51709:0:0", -- Brown Leather Satchel
	[4499]="100000:1:1:1:Bag::1:0:1149,1285,1321,2084,2401,2803,2808,2820,2908,3313,3350,3369,3625,4170,4230,4241,4555,4590,4896,5101,5132,5134,7942,8362,8364,11038,11555,12021,12027,12036,12246,12959,12960,14624,15174,15397,16191,16690,16709,16732,16826,18011,18907,18959,19020,19021,19053,19197,19243,19314,19315,19343,19374,19436,19452,19474,19498,19534,19560,19574,19625,19649,19679,20080,20092,20194,20231,20249,20892,21082,21111,21172,21183,22099,22270,23143,24053,24141,24348,25035,26718,27071,28792,28807,29207,38847,40826,40914,41053,41275,41490,41676,41891,43637,43748,43953,44019,44183,44302,44343,44344,44376,44398,44779,45094,45553,46659,47105,47139,47148,47167,47757,47858,47938,48067,48093,48122,48236,48607,48858,49919,50126:0:0", -- Huge Brown Sack
	[4500]="0:1:2:1:Bag::1:0::0:0", -- Traveler's Backpack
	[4502]="0:12:1:1:::1:0::4:0", -- Sample Elven Gem
	[4503]="0:12:1:20:::1:0::4:0", -- Witherbark Tusk
	[4504]="0:4:2:1:Cloak::1:0::3:0", -- Dwarven Guard Cloak
	[4505]="0:4:2:1:Cloth::1:0::3:0", -- Swampland Trousers
	[4506]="0:12:1:20:::1:0::4:0", -- Stromgarde Badge
	[4507]="0:4:3:1:Shield::1:0::3:0", -- Pit Fighter's Shield
	[4508]="0:4:3:1:Mail::1:0::3:0", -- Blood-Tinged Armor
	[4509]="0:4:2:1:Leather::1:0::3:0", -- Seawolf Gloves
	[4510]="0:12:1:1:::1:0::4:0", -- Befouled Bloodstone Orb
	[4511]="0:2:2:1:OneHandMace::1:0::3:0", -- Black Water Hammer
	[4512]="0:12:1:20:::1:0::4:0", -- Highland Raptor Eye
	[4513]="0:12:1:20:::1:0::4:0", -- Raptor Heart
	[4514]="0:12:1:1:::1:0::4:0", -- Sara Balloo's Plea
	[4515]="0:12:1:1:::1:0::4:0", -- Marez's Head
	[4516]="0:12:1:1:::1:0::4:0", -- Otto's Head
	[4517]="0:12:1:1:::1:0::4:0", -- Falconcrest's Head
	[4518]="0:12:1:1:::1:0::4:0", -- Torn Scroll Fragment
	[4519]="0:12:1:1:::1:0::4:0", -- Crumpled Scroll Fragment
	[4520]="0:12:1:1:::1:0::4:0", -- Singed Scroll Fragment
	[4521]="0:12:1:20:::1:0::4:0", -- Alterac Granite
	[4522]="0:12:1:20:::1:0::4:0", -- Witherbark Medicine Pouch
	[4525]="0:12:1:1:::1:0::4:0", -- Trelane's Wand of Invocation
	[4526]="0:12:1:1:::1:0::4:0", -- Raptor Talon Amulet
	[4527]="0:12:1:1:::1:0::4:0", -- Azure Agate
	[4528]="0:12:1:1:::1:0::4:0", -- Tor'gan's Orb
	[4529]="0:12:1:1:::1:0::4:0", -- Enchanted Agate
	[4530]="0:12:1:1:::1:0::4:0", -- Trelane's Phylactery
	[4531]="0:12:1:1:::1:0::4:0", -- Trelane's Orb
	[4532]="0:12:1:1:::1:0::4:0", -- Trelane's Ember Agate
	[4533]="0:12:1:1:::1:0::4:0", -- Sealed Letter to Archmage Malin
	[4534]="0:4:2:1:Mail::1:0::3:0", -- Steel-Clasped Bracers
	[4535]="0:4:2:1:Ring::1:0::3:0", -- Ironforge Memorial Ring
	[4536]="25:0:1:20:FoodDrink::5:0:894,1671,3017,3342,3934,3961,4891,5814,6735,6740,7978,16443,16542,17630,19223,21145,23573,24934,29547,40968,43945,43946,44190,44270,44325,44340,44344,44379,44391,44397,45008,45086,46642,47165,47363,47717,47756,48054,48215,48555,48599:0:0", -- Shiny Red Apple
	[4537]="125:0:1:20:FoodDrink::5:0:894,1671,3017,3342,3934,3961,4891,5814,6735,6740,7978,16443,16542,17630,21145,23573,24934,29547,40968,43945,43946,44190,44270,44325,44340,44344,44379,44391,44397,45008,45086,46642,47165,47363,47717,48054,48215,48555,48599,52820:0:0", -- Tel'Abim Banana
	[4538]="500:0:1:20:FoodDrink::5:0:894,1671,3017,3342,3934,3961,4891,5814,6735,6740,7978,14963,14964,15124,15125,16443,16542,17630,21145,23573,24934,29547,40968,43945,43946,44190,44270,44325,44340,44344,44379,44391,44397,45008,45086,46642,47165,47363,47717,48054,48215,48555,48599:0:0", -- Snapvine Watermelon
	[4539]="1000:0:1:20:FoodDrink::5:0:894,1671,3017,3342,3934,3961,4891,5814,6735,6740,7978,14963,14964,15124,15125,16443,16542,17630,19223,21145,23573,24934,29547,40968,43945,43946,44190,44270,44325,44340,44344,44379,44391,44397,45008,45086,45417,46642,47165,47363,47717,47756,48054,48215,48555,48599:0:0", -- Goldenbark Apple
	[4540]="25:0:1:20:FoodDrink::5:0:151,152,233,829,1237,1247,1250,1670,1682,1685,1691,2115,2134,2140,2832,3003,3072,3076,3086,3158,3164,3186,3291,3313,3368,3480,3481,3518,3546,3587,3608,3708,3883,3884,3937,3948,3959,4170,4190,4241,4266,4891,4894,5109,5620,6272,6734,6736,6740,6747,6929,7485,7737,7744,7941,8143,8307,8362,8416,11103,11287,15433,16187,16191,16256,16259,16260,16444,16732,16739,17421,17446,17489,17630,18810,23522,23603,24834,24934,25012,25052,25089,29291,33996,36378,36695,36779,38783,38853,39032,40467,42853,43384,43419,43424,43425,43558,43637,43699,43953,44006,44034,44196,44219,44235,44237,44267,44340,44379,44785,45484,45491,45496,45497,45563,46269,46271,46966,46994,47142,47338,47363,47756,47942,48607,49394,49430,49917,50126,51709:0:0", -- Tough Hunk of Bread
	[4541]="125:0:1:20:FoodDrink::5:0:227,233,491,791,1237,1247,1448,1452,1670,1682,1685,2140,2401,2803,2832,3003,3086,3291,3313,3368,3480,3481,3498,3518,3546,3708,3883,3884,3937,3948,3959,3962,4082,4190,4266,4555,4891,4894,5109,5620,6272,6734,6736,6740,6747,6929,7485,7737,7744,7941,7942,8143,8307,8362,11103,11287,12021,12027,12036,12960,15433,16187,16191,16256,16444,16732,16739,17421,17489,17630,18810,18811,23522,23603,24834,24934,25012,25052,25089,29291,33996,36378,40467,41128,43384,43419,43424,43425,43637,43699,43953,44001,44006,44114,44177,44183,44196,44219,44235,44237,44267,44294,44296,44297,44300,44303,44304,44340,44379,44785,45484,45491,45496,45497,45563,46269,46271,46659,46994,47142,47338,47363,47756,47858,47942,48067,48093,48607,49394,49397,49430,49435,49917,50126,51709:0:0", -- Freshly Baked Bread
	[4542]="500:0:1:20:FoodDrink::5:0:227,233,491,791,1149,1237,1247,1285,1448,1452,1670,2084,2401,2803,2808,2820,2832,2908,3003,3086,3291,3313,3350,3368,3480,3498,3518,3546,3625,3708,3883,3884,3937,3948,3959,3962,4082,4170,4190,4241,4266,4555,4891,4894,4896,5101,5109,5134,5620,6272,6734,6736,6740,6747,6929,7485,7737,7744,7941,7942,8143,8307,8362,11038,11103,11287,11555,12021,12027,12036,12246,12959,12960,14624,15174,15397,15433,16191,16256,16732,16739,17489,17630,18811,23522,23603,24834,24934,25012,25052,25089,29291,33996,36378,38847,40467,40826,40914,41053,41128,41275,41490,41676,41891,43384,43424,43637,43699,43748,43953,44001,44006,44019,44114,44177,44183,44196,44219,44235,44237,44267,44294,44296,44297,44300,44302,44303,44304,44340,44343,44344,44376,44379,44398,44779,44785,45094,45484,45496,45553,45563,46269,46271,46659,47105,47139,47142,47148,47167,47338,47363,47756,47757,47858,47938,47942,48067,48093,48122,48236,48607,49394,49397,49430,49435,49917,49919,50126,51709:0:0", -- Moist Cornbread
	[4543]="0:4:2:1:Leather::1:0::3:0", -- White Drakeskin Cap
	[4544]="1000:0:1:20:FoodDrink::5:0:233,1237,1247,1670,2832,3003,3086,3291,3368,3480,3518,3546,3708,3883,3884,3937,3948,3959,4190,4266,4891,4894,5109,5620,6272,6734,6736,6740,6747,6929,7485,7737,7744,7941,8143,8307,11103,11287,15433,16256,16739,17630,23522,23603,24834,24934,25012,25052,25089,29291,33996,36378,40467,43384,43699,44006,44196,44219,44235,44237,44267,44340,44379,44785,45563,46269,46271,47142,47338,47363,47756,47942,48607,49394,49430,49917,50126:0:0", -- Mulgore Spice Bread
	[4545]="0:4:2:1:Cloth::1:0::3:0", -- Radiant Silver Bracers
	[4546]="0:0:1:1:Consumable::1:0::3:0", -- Call of the Raptor
	[4547]="0:2:2:1:Wand::1:0::3:0", -- Gnomish Zapper
	[4548]="0:2:2:1:TwoHandMace::1:0::3:0", -- Servomechanic Sledgehammer
	[4549]="0:4:2:1:Ring::1:0::3:0", -- Seafire Band
	[4550]="0:4:2:1:Ring::1:0::3:0", -- Coldwater Ring
	[4551]="0:12:1:1:::1:0::4:0", -- Or'Kalar's Head
	[4552]="0:15:0:20:Junk::1:0::0:0", -- Smooth Stone Chip
	[4553]="0:15:0:20:Junk::1:0::0:0", -- Jagged Piece of Stone
	[4554]="0:15:0:20:Junk::1:0::0:0", -- Shiny Polished Stone
	[4555]="0:15:0:20:Junk::1:0::0:0", -- Thick Scaly Tail
	[4556]="0:15:0:20:Junk::1:0::0:0", -- Speckled Shell Fragment
	[4557]="0:15:0:20:Junk::1:0::0:0", -- Fiery Gland
	[4558]="0:15:0:20:Junk::1:0::0:0", -- Empty Barrel
	[4560]="0:2:1:1:OneHandSword::1:0::0:0", -- Fine Scimitar
	[4561]="0:2:2:1:OneHandAxe::1:0::2:0", -- Scalping Tomahawk
	[4562]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Severing Axe
	[4563]="0:2:1:1:OneHandMace::1:0::0:0", -- Billy Club
	[4564]="0:2:2:1:TwoHandMace::1:0::2:0", -- Spiked Club
	[4565]="0:2:1:1:Dagger::1:0::0:0", -- Simple Dagger
	[4566]="0:2:2:1:Stave::1:0::2:0", -- Sturdy Quarterstaff
	[4567]="0:2:2:1:TwoHandSword::1:0::2:0", -- Merc Sword
	[4568]="0:2:2:1:OneHandAxe::1:0::2:0", -- Grunt Axe
	[4569]="0:2:2:1:OneHandMace::1:0::2:0", -- Staunch Hammer
	[4570]="0:2:2:1:TwoHandMace::1:0::2:0", -- Birchwood Maul
	[4571]="0:2:2:1:Dagger::1:0::2:0", -- War Knife
	[4575]="0:2:2:1:Stave::1:0::2:0", -- Medicine Staff
	[4576]="0:2:2:1:Bow::1:0::2:0", -- Light Bow
	[4577]="0:2:2:1:Gun::1:0::2:0", -- Compact Shotgun
	[4580]="0:15:0:20:Junk::1:0::0:0", -- Sabertooth Fang
	[4581]="0:15:0:20:Junk::1:0::0:0", -- Patch of Fine Fur
	[4582]="0:12:1:5:::1:0::0:0", -- Soft Bushy Tail
	[4583]="0:15:0:20:Junk::1:0::0:0", -- Thick Furry Mane
	[4584]="0:15:0:20:Junk::1:0::0:0", -- Large Trophy Paw
	[4585]="0:15:0:20:Junk::1:0::0:0", -- Dripping Spider Mandible
	[4586]="0:15:0:20:Junk::1:0::0:0", -- Smooth Raptor Skin
	[4587]="0:15:0:20:Junk::1:0::0:0", -- Tribal Raptor Feathers
	[4588]="0:15:0:20:Junk::1:0::0:0", -- Pristine Raptor Skull
	[4589]="0:15:0:10:Junk::1:0::0:0", -- Long Elegant Feather
	[4590]="0:15:0:20:Junk::1:0::0:0", -- Curved Yellow Bill
	[4591]="0:15:0:20:Junk::1:0::0:0", -- Eagle Eye
	[4592]="20:0:1:20:FoodDrink::5:0:1678,1684,2842,3029,3086,3178,3497,4221,4305,5814,6727,6738,6791,6807,7943,8931,11187,12962,14731,16618,16739,17553,17656,19045,23896,24834,25012,25052,25089,29291,43899,43945,43946,44334,45008,45086,46182,46642,47334,56069:0:0", -- Longjaw Mud Snapper
	[4593]="500:0:1:20:FoodDrink::5:0:1678,1684,2842,3029,3086,3178,3497,4221,4305,5814,6727,6738,6791,6807,7943,8931,11187,12962,14731,16618,16739,17553,17656,19045,23896,24834,25012,25052,25089,29291,43899,43945,43946,44334,45008,45086,46182,46642,47334,56069:0:0", -- Bristle Whisker Catfish
	[4594]="1000:0:1:20:FoodDrink::5:0:1678,1684,2842,3029,3086,3178,3497,4221,4305,5814,6727,6738,6791,6807,7943,8931,11187,12962,14731,16618,16739,17553,17656,19045,23896,24834,25012,25052,25089,29291,43899,43945,43946,44334,45008,45086,46182,46642,47334,56069:0:0", -- Rockscale Cod
	[4595]="300:0:1:10:FoodDrink::1:0:2832:0:0", -- Junglevine Wine
	[4596]="0:0:1:20:Potion::1:0::0:0", -- Discolored Healing Potion
	[4597]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Discolored Healing Potion
	[4598]="0:0:1:10:Consumable::1:0::3:0", -- Goblin Fishing Pole
	[4599]="2000:0:1:20:FoodDrink::5:0:982,1156,1464,2388,2814,3025,3089,3312,3368,3411,3489,3705,3881,3882,3933,3935,4169,4782,4879,4891,4894,4954,5111,5124,5611,5620,5688,5870,6739,6741,6928,6929,7485,7731,7733,9356,11118,11187,12196,12959,14624,14963,14964,15124,15125,15174,15397,16443,16618,16739,17553,17630,17656,19182,23263,23481,23605,24208,24291,24343,36378,39031,40589,40898,41286,41491,41674,41892,42953,43606,43624,43633,43739,43771,43899,43956,44177,44276,44312,44343,45563,47165,47288,47668,47854,48555,48735,50092,51142:0:0", -- Cured Ham Steak
	[4600]="340:0:1:20:FoodDrink::1:0:2832,4782,5570,19617,20377,24333,24834,25012,25052,25089,29291,36915,38714,41341,41618,44325:0:0", -- Cherry Grog
	[4601]="2000:0:1:20:FoodDrink::5:0:233,1149,1237,1247,1285,1670,2084,2401,2803,2808,2820,2832,2908,3003,3086,3291,3313,3350,3368,3480,3518,3546,3625,3708,3883,3884,3937,3948,3959,4170,4190,4241,4266,4555,4891,4894,4896,5101,5109,5134,5620,6272,6734,6736,6740,6747,6929,7485,7737,7744,7941,7942,8143,8307,8362,11038,11103,11287,11555,12021,12027,12036,12246,12959,12960,14624,15174,15397,15433,16191,16256,16732,16739,17630,23522,23603,24834,24934,25012,25052,25089,29291,33996,36378,38847,40467,40826,40914,41053,41275,41490,41676,41891,43384,43637,43699,43748,43953,44006,44019,44183,44196,44219,44235,44237,44267,44302,44340,44343,44344,44376,44379,44398,44779,44785,45094,45553,45563,46269,46271,46659,47105,47139,47142,47148,47167,47338,47363,47756,47757,47858,47938,47942,48067,48093,48122,48236,48607,49394,49430,49917,49919,50126:0:0", -- Soft Banana Bread
	[4602]="2000:0:1:20:FoodDrink::5:0:894,1671,3017,3342,3934,3961,4891,5814,6735,6740,7978,14963,14964,15124,15125,16443,16542,17630,21145,23573,24934,29547,40968,43945,43946,44190,44270,44325,44340,44344,44379,44391,44397,45008,45086,46642,47165,47363,47717,48054,48215,48555,48599:0:0", -- Moon Harvest Pumpkin
	[4603]="0:7:1:20:Meat:185:1:0::0:0", -- Raw Spotted Yellowtail
	[4604]="25:0:1:20:FoodDrink::5:0:2803,3138,3329,3544,3547,4554,4571,5688,5886,6739,6741,8150,8152,10666,11038,12384,17656,36378,43899,44235,44237,46271,47142,47334,47367,47547,47668,47854,49394,49430,53528:0:0", -- Forest Mushroom Cap
	[4605]="125:0:1:20:FoodDrink::5:0:2803,3138,3329,3544,3547,4554,4571,5688,5886,6739,6741,8150,8152,10666,11038,12384,17656,36378,43899,44235,44237,46271,47142,47334,47367,47547,47668,47854,49394,49430,53528:0:0", -- Red-Speckled Mushroom
	[4606]="500:0:1:20:FoodDrink::5:0:2803,3138,3329,3544,3547,4554,4571,5688,5886,6739,6741,8150,8152,10666,11038,12384,14963,14964,15124,15125,17656,36378,43899,44235,44237,46271,47142,47334,47367,47547,47668,47854,49394,49430,53528:0:0", -- Spongy Morel
	[4607]="1000:0:1:20:FoodDrink::5:0:2803,3138,3329,3544,3547,4554,4571,5688,5886,6739,6741,8150,8152,10666,11038,12384,14963,14964,15124,15125,17656,36378,43899,44235,44237,46271,47142,47334,47367,47547,47668,47854,49394,49430,53528:0:0", -- Delicious Cave Mold
	[4608]="2000:0:1:20:FoodDrink::5:0:2803,3138,3329,3544,3547,4554,4571,5688,5886,6739,6741,8150,8152,10666,11038,12384,14963,14964,15124,15125,17656,36378,43899,44235,44237,46271,47142,47334,47367,47547,47668,47854,49394,49430,53528:0:0", -- Raw Black Truffle
	[4609]="1000:9:1:1:Cooking::1:0:2814,12246:0:0", -- Recipe: Barbecued Buzzard Wing
	[4610]="0:12:1:20:::1:0::4:0", -- Carved Stone Urn
	[4611]="0:7:1:20:Other:202:1:0::0:0", -- Blue Pearl
	[4612]="0:12:1:20:::1:0::4:0", -- Black Drake's Heart
	[4613]="0:12:1:1:::1:0::3:0", -- Corroded Black Box
	[4614]="0:4:2:1:Amulet::1:0::3:0", -- Pendant of Myzrael
	[4615]="0:12:1:1:::1:0::4:0", -- Blacklash's Bindings
	[4616]="0:2:1:1:Miscellaneous::1:0::4:0", -- Ryedol's Lucky Pick
	[4621]="0:12:1:1:::1:0::4:0", -- Ambassador Infernus' Bracer
	[4623]="0:0:1:20:Potion::1:0::0:0", -- Lesser Stoneshield Potion
	[4624]="0:9:1:1:Alchemy::1:0::0:0", -- Recipe: Lesser Stoneshield Potion
	[4625]="0:7:1:20:Herb:171,333,197:1:0::0:0", -- Firebloom
	[4626]="0:12:1:20:::1:0::4:0", -- Small Stone Shard
	[4627]="0:12:1:5:::1:0::4:0", -- Large Stone Slab
	[4628]="0:12:1:20:::1:0::4:0", -- Bracers of Rock Binding
	[4629]="0:12:1:20:::1:0::4:0", -- Supply Crate
	[4631]="0:12:1:1:::1:0::4:0", -- Tablet of Ryun'eh
	[4632]="0:15:2:1:Junk::1:0::0:0", -- Ornate Bronze Lockbox
	[4633]="0:15:2:1:Junk::1:0::0:0", -- Heavy Bronze Lockbox
	[4634]="0:15:2:1:Junk::1:0::0:0", -- Iron Lockbox
	[4635]="0:12:1:1:::1:0::4:0", -- Hammertoe's Amulet
	[4636]="0:15:2:1:Junk::1:0::0:0", -- Strong Iron Lockbox
	[4637]="0:15:2:1:Junk::1:0::0:0", -- Steel Lockbox
	[4638]="0:15:2:1:Junk::1:0::0:0", -- Reinforced Steel Lockbox
	[4639]="0:12:1:1:::1:0::0:0", -- Enchanted Sea Kelp
	[4640]="0:12:1:1:::1:0::4:0", -- Sign of the Earth
	[4641]="0:12:1:1:::1:0::4:0", -- Hand of Dagun
	[4643]="0:4:2:1:Cloak::1:0::3:0", -- Grimsteel Cape
	[4644]="0:12:1:1:::1:0::4:0", -- The Legacy Heart
	[4645]="0:12:1:1:::1:0::4:0", -- Chains of Hematus
	[4646]="0:12:1:1:::1:0::4:0", -- Star of Xil'yeh
	[4647]="0:12:1:1:::1:0::4:0", -- Yagyin's Digest
	[4648]="0:12:1:1:::1:0::4:0", -- Sigil of the Hammer
	[4649]="0:12:1:1:::1:0::4:0", -- Bonegrip's Note
	[4650]="0:12:1:1:::1:0::4:0", -- Bel'dugur's Note
	[4652]="0:4:2:1:Shield::1:0::3:0", -- Salbac Shield
	[4653]="0:4:2:1:Mail::1:0::3:0", -- Ironheel Boots
	[4654]="0:12:1:1:::1:0::4:0", -- Mysterious Fossil
	[4655]="0:7:1:20:Meat:185:1:0::0:0", -- Giant Clam Meat
	[4656]="0:0:1:20:FoodDrink::1:0::0:0", -- Small Pumpkin
	[4658]="0:4:1:1:Cloak::1:0::0:0", -- Warrior's Cloak
	[4659]="0:4:1:1:Mail::1:0::0:0", -- Warrior's Girdle
	[4660]="0:4:3:1:Cloth::1:0::2:0", -- Walking Boots
	[4661]="0:4:2:1:Cloth::1:0::2:0", -- Bright Mantle
	[4662]="0:4:1:1:Cloak::1:0::0:0", -- Journeyman's Cloak
	[4663]="0:4:1:1:Cloth::1:0::0:0", -- Journeyman's Belt
	[4665]="0:4:1:1:Cloak::1:0::0:0", -- Burnt Cloak
	[4666]="0:4:1:1:Leather::1:0::0:0", -- Burnt Leather Belt
	[4668]="0:4:1:1:Cloak::1:0::0:0", -- Battle Chain Cloak
	[4669]="0:4:1:1:Mail::1:0::0:0", -- Battle Chain Girdle
	[4671]="0:4:1:1:Cloak::1:0::0:0", -- Ancestral Cloak
	[4672]="0:4:1:1:Cloth::1:0::0:0", -- Ancestral Belt
	[4674]="0:4:1:1:Cloak::1:0::0:0", -- Tribal Cloak
	[4675]="0:4:1:1:Leather::1:0::0:0", -- Tribal Belt
	[4676]="0:4:3:1:Mail::1:0::3:0", -- Skeletal Gauntlets
	[4677]="0:4:1:1:Cloak::1:0::0:0", -- Veteran Cloak
	[4678]="0:4:1:1:Mail::1:0::0:0", -- Veteran Girdle
	[4680]="0:4:1:1:Cloak::1:0::0:0", -- Brackwater Cloak
	[4681]="0:4:1:1:Mail::1:0::0:0", -- Brackwater Girdle
	[4683]="0:4:1:1:Cloak::1:0::0:0", -- Spellbinder Cloak
	[4684]="0:4:1:1:Cloth::1:0::0:0", -- Spellbinder Belt
	[4686]="0:4:1:1:Cloak::1:0::0:0", -- Barbaric Cloth Cloak
	[4687]="0:4:1:1:Cloth::1:0::0:0", -- Barbaric Cloth Belt
	[4689]="0:4:1:1:Cloak::1:0::0:0", -- Hunting Cloak
	[4690]="0:4:1:1:Leather::1:0::0:0", -- Hunting Belt
	[4692]="0:4:1:1:Cloak::1:0::0:0", -- Ceremonial Cloak
	[4693]="0:4:1:1:Leather::1:0::0:0", -- Ceremonial Leather Belt
	[4694]="0:4:1:1:Mail::1:0::0:0", -- Burnished Pauldrons
	[4695]="0:4:2:1:Cloak::1:0::2:0", -- Burnished Cloak
	[4696]="0:4:3:1:OffHandFrill::1:0::2:0", -- Lapidis Tankard of Tidesippe
	[4697]="0:4:2:1:Mail::1:0::2:0", -- Burnished Girdle
	[4698]="0:4:1:1:Cloth::1:0::0:0", -- Seer's Mantle
	[4699]="0:4:2:1:Cloth::1:0::2:0", -- Seer's Belt
	[4700]="0:4:1:1:Leather::1:0::0:0", -- Inscribed Leather Spaulders
	[4701]="0:4:2:1:Cloak::1:0::2:0", -- Inscribed Cloak
	[4702]="0:12:1:20:::1:0::4:0", -- Prospector's Pick
	[4703]="0:12:1:20:::1:0::4:0", -- Broken Tools
	[4705]="0:4:2:1:Mail::1:0::2:0", -- Lambent Scale Pauldrons
	[4706]="0:4:2:1:Cloak::1:0::2:0", -- Lambent Scale Cloak
	[4707]="0:4:2:1:Mail::1:0::2:0", -- Lambent Scale Girdle
	[4708]="0:4:2:1:Cloth::1:0::2:0", -- Bright Belt
	[4709]="0:4:2:1:Leather::1:0::2:0", -- Forest Leather Mantle
	[4710]="0:4:2:1:Cloak::1:0::2:0", -- Forest Cloak
	[4711]="0:4:2:1:Cloak::1:0::2:0", -- Glimmering Cloak
	[4712]="0:4:2:1:Mail::1:0::2:0", -- Glimmering Mail Girdle
	[4713]="0:4:2:1:Cloak::1:0::2:0", -- Silver-Thread Cloak
	[4714]="0:4:2:1:Cloth::1:0::2:0", -- Silver-Thread Sash
	[4715]="0:4:2:1:Cloak::1:0::2:0", -- Emblazoned Cloak
	[4716]="0:4:2:1:Cloak::1:0::2:0", -- Combat Cloak
	[4717]="0:4:2:1:Mail::1:0::2:0", -- Mail Combat Belt
	[4718]="0:4:2:1:Cloth::1:0::2:0", -- Nightsky Mantle
	[4719]="0:4:2:1:Cloak::1:0::2:0", -- Nightsky Cloak
	[4720]="0:4:2:1:Cloth::1:0::2:0", -- Nightsky Sash
	[4721]="0:4:2:1:Leather::1:0::2:0", -- Insignia Mantle
	[4722]="0:4:2:1:Cloak::1:0::2:0", -- Insignia Cloak
	[4723]="0:4:2:1:Cloth::1:0::2:0", -- Humbert's Pants
	[4724]="0:4:2:1:Leather::1:0::2:0", -- Humbert's Helm
	[4725]="0:4:2:1:Mail::1:0::2:0", -- Chief Brigadier Pauldrons
	[4726]="0:4:2:1:Cloak::1:0::2:0", -- Chief Brigadier Cloak
	[4727]="0:4:2:1:Mail::1:0::2:0", -- Chief Brigadier Girdle
	[4729]="0:4:2:1:Cloth::1:0::2:0", -- Aurora Mantle
	[4731]="0:4:2:1:Leather::1:0::2:0", -- Glyphed Epaulets
	[4732]="0:4:2:1:Cloak::1:0::2:0", -- Glyphed Cloak
	[4733]="0:4:2:1:Mail::1:0::2:0", -- Blackforge Pauldrons
	[4734]="0:4:2:1:Cloth::1:0::2:0", -- Mistscape Mantle
	[4735]="0:4:2:1:Cloak::1:0::2:0", -- Mistscape Cloak
	[4736]="0:4:2:1:Cloth::1:0::2:0", -- Mistscape Sash
	[4737]="0:4:2:1:Leather::1:0::2:0", -- Imperial Leather Spaulders
	[4738]="0:4:2:1:Leather::1:0::2:0", -- Imperial Leather Belt
	[4739]="0:12:1:20:::1:0::4:0", -- Plainstrider Meat
	[4740]="0:12:1:20:::1:0::4:0", -- Plainstrider Feather
	[4741]="0:4:2:1:Mail::1:0::3:0", -- Stromgarde Cavalry Leggings
	[4742]="0:12:1:20:::1:0::4:0", -- Mountain Cougar Pelt
	[4743]="0:4:3:1:Amulet::1:0::3:0", -- Pulsating Crystalline Shard
	[4744]="0:4:2:1:Cloth::1:0::3:0", -- Arcane Runed Bracers
	[4745]="0:4:2:1:Mail::1:0::3:0", -- War Rider Bracers
	[4746]="0:4:2:1:Cloth::1:0::3:0", -- Doomsayer's Robe
	[4751]="0:12:1:20:::1:0::4:0", -- Windfury Talon
	[4752]="0:12:1:20:::1:0::4:0", -- Azure Feather
	[4753]="0:12:1:20:::1:0::4:0", -- Bronze Feather
	[4755]="0:12:1:1:::1:0::4:0", -- Water Pitcher
	[4757]="0:15:0:20:Junk::1:0::0:0", -- Cracked Egg Shells
	[4758]="0:12:1:20:::1:0::4:0", -- Prairie Wolf Paw
	[4759]="0:12:1:20:::1:0::4:0", -- Plainstrider Talon
	[4765]="2878:2:2:1:OneHandSword::1:1:167,3479,3658,3682:2:0", -- Enamelled Broadsword
	[4766]="2407:2:2:1:OneHandSword::1:1:167,3479,3658,3682:2:0", -- Feral Blade
	[4767]="0:4:2:1:Cloth::1:0::2:0", -- Coppercloth Gloves
	[4768]="0:4:2:1:Cloth::1:0::2:0", -- Adept's Gloves
	[4769]="0:12:1:20:::1:0::4:0", -- Trophy Swoop Quill
	[4770]="0:12:1:20:::1:0::4:0", -- Bristleback Belt
	[4771]="0:4:2:1:Cloak::1:0::2:0", -- Harvest Cloak
	[4772]="0:4:1:1:Cloak::1:0::0:0", -- Warm Cloak
	[4775]="0:15:0:20:Junk::1:0::0:0", -- Cracked Bill
	[4776]="0:15:0:20:Junk::1:0::0:0", -- Ruffled Feather
	[4777]="7040:2:2:1:TwoHandMace::1:1:222,844,2840,3534,3658,3682:2:0", -- Ironwood Maul
	[4778]="7351:2:2:1:TwoHandMace::1:1:222,844,2840,3534,3658,3682:2:0", -- Heavy Spiked Mace
	[4779]="0:15:0:20:Junk::1:0::0:0", -- Dull Kodo Tooth
	[4780]="0:15:0:20:Junk::1:0::0:0", -- Kodo Horn Fragment
	[4781]="2736:4:2:1:Cloth::1:1:1214,3091,3486,3554:2:0", -- Whispering Vest
	[4782]="2077:4:2:1:Cloth::1:1:1214,3091,3486,3554:2:0", -- Solstice Robe
	[4783]="0:12:1:1:::1:0::4:0", -- Totem of Hawkwind
	[4784]="0:15:0:20:Junk::1:0::0:0", -- Lifeless Stone
	[4785]="0:4:2:1:Cloth::1:0::2:0", -- Brimstone Belt
	[4786]="1394:4:2:1:Cloth::1:1:1214,3091,3486,3554:2:0", -- Wise Man's Belt
	[4787]="0:15:0:20:Junk::1:0::0:0", -- Burning Pitch
	[4788]="2634:4:2:1:Leather::1:1:954,3552:2:0", -- Agile Boots
	[4789]="1999:4:2:1:Leather::1:1:954,3552:2:0", -- Stable Boots
	[4790]="4159:4:2:1:Cloak::1:1:1454,3486:2:0", -- Inferno Cloak
	[4791]="0:0:1:20:FoodDrink::1:0::0:0", -- Enchanted Water
	[4792]="3280:4:2:1:Cloak::1:1:1454,3486:2:0", -- Spirit Cloak
	[4793]="3720:4:2:1:Cloak::1:1:1454,3486:2:0", -- Sylvan Cloak
	[4794]="3515:4:2:1:Leather::1:1:844,3492,3536:2:0", -- Wolf Bracers
	[4795]="3528:4:2:1:Leather::1:1:844,3492,3536:2:0", -- Bear Bracers
	[4796]="3540:4:2:1:Leather::1:1:844,3492,3536:2:0", -- Owl Bracers
	[4797]="4263:4:2:1:Cloak::1:1:226,3493,3682,44283:2:0", -- Fiery Cloak
	[4798]="3871:4:2:1:Cloak::1:1:226,3493,3682,44283:2:0", -- Heavy Runed Cloak
	[4799]="3043:4:2:1:Cloak::1:1:226,3493,3682,44283:2:0", -- Antiquated Cloak
	[4800]="6110:4:2:1:Mail::1:1:226,3493,3682,44283:2:0", -- Mighty Chain Pants
	[4801]="0:12:1:20:::1:0::4:0", -- Stalker Claws
	[4802]="0:12:1:20:::1:0::4:0", -- Cougar Claws
	[4803]="0:12:1:20:::1:0::4:0", -- Prairie Alpha Tooth
	[4804]="0:12:1:1:::1:0::4:0", -- Prairie Wolf Heart
	[4805]="0:12:1:1:::1:0::4:0", -- Flatland Cougar Femur
	[4806]="0:12:1:1:::1:0::4:0", -- Plainstrider Scale
	[4807]="0:12:1:1:::1:0::4:0", -- Swoop Gizzard
	[4808]="0:12:1:20:::1:0::4:0", -- Well Stone
	[4809]="0:12:1:20:::1:0::4:0", -- Ambercorn
	[4810]="0:4:2:1:Leather::1:0::2:0", -- Boulder Pads
	[4813]="0:15:0:20:Junk::1:0::0:0", -- Small Leather Collar
	[4814]="0:15:0:20:Junk::1:0::0:0", -- Discolored Fang
	[4816]="7519:4:2:1:Mail::1:1:226,3493,3682,44283:2:0", -- Legionnaire's Leggings
	[4817]="12311:2:2:1:TwoHandSword::1:1:844,1441,3534,3539,4890,47712:2:0", -- Blessed Claymore
	[4818]="14273:2:2:1:TwoHandSword::1:1:844,1441,3534,3539,4890,47712:2:0", -- Executioner's Sword
	[4819]="0:12:1:1:::1:0::4:0", -- Fizsprocket's Clipboard
	[4820]="8321:4:2:1:Shield::1:1:793,3493:2:0", -- Guardian Buckler
	[4821]="6541:4:2:1:Shield::1:1:793,3493:2:0", -- Bear Buckler
	[4822]="6746:4:2:1:Shield::1:1:793,3493:2:0", -- Owl's Disk
	[4823]="0:12:1:1:::1:0::4:0", -- Water of the Seers
	[4824]="16856:2:2:1:OneHandAxe::1:1:1307,3180,3539,4890:2:0", -- Blurred Axe
	[4825]="20472:2:2:1:OneHandAxe::1:1:1307,3180,3539,4890:2:0", -- Callous Axe
	[4826]="15436:2:2:1:OneHandAxe::1:1:1307,3180,3539,4890:2:0", -- Marauder Axe
	[4827]="3749:4:2:1:Cloth::1:1:1307,1454,2679,3134,3537:2:0", -- Wizard's Belt
	[4828]="3420:4:2:1:Cloth::1:1:1307,1454,2679,3134,3537:2:0", -- Nightwind Belt
	[4829]="4154:4:2:1:Cloth::1:1:1307,1454,2679,3134,3537:2:0", -- Dreamer's Belt
	[4830]="9475:4:2:1:Leather::1:1:2679,3180,3536,4890:2:0", -- Saber Leggings
	[4831]="7859:4:2:1:Leather::1:1:2679,3180,3536,4890:2:0", -- Stalking Pants
	[4832]="10498:4:2:1:Leather::1:1:2679,3180,3536,4890:2:0", -- Mystic Sarong
	[4833]="8658:4:2:1:Mail::1:1:2679,3180:2:0", -- Glorious Shoulders
	[4834]="0:12:1:1:::1:0::4:0", -- Venture Co. Documents
	[4835]="10551:4:2:1:Mail::1:1:2679,3180:2:0", -- Elite Shoulders
	[4836]="8002:4:2:1:OffHandFrill::1:1:3134,3537:2:0", -- Fireproof Orb
	[4837]="8002:4:2:1:OffHandFrill::1:1:3134,3537:2:0", -- Strength of Will
	[4838]="8002:4:2:1:OffHandFrill::1:1:3134,3537:2:0", -- Orb of Power
	[4840]="0:2:2:1:Dagger::1:0::3:0", -- Long Bayonet
	[4841]="0:12:1:1:::1:0::4:0", -- Horn of Arra'chea
	[4843]="0:12:1:1:::1:0::3:0", -- Amethyst Runestone
	[4844]="0:12:1:1:::1:0::3:0", -- Opal Runestone
	[4845]="0:12:1:1:::1:0::3:0", -- Diamond Runestone
	[4846]="0:12:1:1:::1:0::4:0", -- Cog #5
	[4848]="0:12:1:20:::1:0::4:0", -- Battleboar Snout
	[4849]="0:12:1:20:::1:0::4:0", -- Battleboar Flank
	[4850]="0:12:1:1:::1:0::4:0", -- Bristleback Attack Plans
	[4851]="0:12:1:1:::1:0::3:0", -- Dirt-Stained Map
	[4852]="0:7:1:20:Explosive::1:0::0:0", -- Flash Bomb
	[4854]="0:4:1:1:Cloak::1:0::3:0", -- Demon Scarred Cloak
	[4859]="0:12:1:1:::1:0::4:0", -- Burning Blade Medallion
	[4860]="0:15:0:20:Junk::1:0::0:0", -- Glistening Frenzy Scale
	[4861]="0:4:2:1:Leather::1:0::2:0", -- Sleek Feathered Tunic
	[4862]="0:12:1:20:::1:0::4:0", -- Scorpid Worker Tail
	[4863]="0:12:1:20:::1:0::4:0", -- Gnomish Tools
	[4864]="0:12:1:10:::1:0::4:0", -- Minshina's Skull
	[4865]="0:15:0:20:Junk::1:0::0:0", -- Ruined Pelt
	[4867]="0:15:0:20:Junk::1:0::0:0", -- Broken Scorpid Leg
	[4869]="0:12:1:1:::1:0::4:0", -- Fizzle's Claw
	[4870]="0:12:1:20:::1:0::4:0", -- Canvas Scraps
	[4871]="0:12:1:20:::1:0::4:0", -- Searing Collar
	[4872]="0:15:0:20:Junk::1:0::0:0", -- Dry Scorpid Eye
	[4873]="0:15:0:20:Junk::1:0::0:0", -- Dry Hardened Barnacle
	[4874]="0:15:0:20:Junk::1:0::0:0", -- Clean Fishbones
	[4875]="0:15:0:20:Junk::1:0::0:0", -- Slimy Bone
	[4876]="0:15:0:20:Junk::1:0::0:0", -- Bloody Leather Boot
	[4877]="0:15:0:20:Junk::1:0::0:0", -- Stone Arrowhead
	[4878]="0:15:0:1:Junk::1:0::0:0", -- Broken Bloodstained Bow
	[4879]="0:15:0:20:Junk::1:0::0:0", -- Squashed Rabbit Carcass
	[4880]="0:15:0:20:Junk::1:0::0:0", -- Broken Spear
	[4881]="0:12:1:1:::1:0::3:0", -- Aged Envelope
	[4882]="0:13:1:1:::1:0::0:0", -- Benedict's Key
	[4883]="0:12:1:1:::1:0::4:0", -- Admiral Proudmoore's Orders
	[4886]="0:12:1:20:::1:0::4:0", -- Venomtail Poison Sac
	[4887]="0:12:1:20:::1:0::4:0", -- Intact Makrura Eye
	[4888]="0:12:1:20:::1:0::4:0", -- Crawler Mucus
	[4890]="0:12:1:20:::1:0::4:0", -- Taillasher Egg
	[4892]="0:12:1:20:::1:0::4:0", -- Durotar Tiger Fur
	[4893]="0:12:1:20:::1:0::4:0", -- Savannah Lion Tusk
	[4894]="0:12:1:20:::1:0::4:0", -- Plainstrider Kidney
	[4895]="0:12:1:1:::1:0::4:0", -- Thunder Lizard Horn
	[4896]="0:12:1:20:::1:0::4:0", -- Kodo Liver
	[4897]="0:12:1:20:::1:0::4:0", -- Thunderhawk Saliva Gland
	[4898]="0:12:1:20:::1:0::4:0", -- Lightning Gland
	[4903]="0:0:0:1:Consumable::1:0::0:0", -- Eye of Burning Shadow
	[4904]="0:12:1:20:::1:0::4:0", -- Venomtail Antidote
	[4905]="0:12:1:1:::1:0::4:0", -- Sarkoth's Mangled Claw
	[4906]="0:4:1:1:Leather::1:0::3:0", -- Rainwalker Boots
	[4907]="0:4:1:1:Leather::1:0::3:0", -- Woodland Tunic
	[4908]="0:4:1:1:Leather::1:0::3:0", -- Nomadic Bracers
	[4909]="0:4:2:1:Leather::1:0::3:0", -- Kodo Hunter's Leggings
	[4910]="0:4:1:1:Mail::1:0::3:0", -- Painted Chain Gloves
	[4911]="0:4:1:1:Shield::1:0::3:0", -- Thick Bark Buckler
	[4913]="0:4:1:1:Mail::1:0::3:0", -- Painted Chain Belt
	[4914]="0:4:1:1:Leather::1:0::3:0", -- Battleworn Leather Gloves
	[4915]="0:4:1:1:Cloth::1:0::3:0", -- Soft Wool Boots
	[4916]="0:4:1:1:Cloth::1:0::3:0", -- Soft Wool Vest
	[4917]="0:4:1:1:Mail::1:0::3:0", -- Battleworn Chain Leggings
	[4918]="0:12:1:20:::1:0::4:0", -- Sack of Supplies
	[4919]="0:4:1:1:Cloth::1:0::3:0", -- Soft Wool Belt
	[4920]="0:4:1:1:Cloak::1:0::3:0", -- Battleworn Cape
	[4921]="0:4:1:1:Leather::1:0::3:0", -- Dust-Covered Leggings
	[4922]="0:4:1:1:Mail::1:0::3:0", -- Jagged Chain Vest
	[4923]="0:2:1:1:OneHandAxe::1:0::3:0", -- Primitive Hatchet
	[4924]="0:2:1:1:OneHandMace::1:0::3:0", -- Primitive Club
	[4925]="0:2:1:1:Dagger::1:0::3:0", -- Primitive Hand Blade
	[4928]="0:4:1:1:Leather::1:0::3:0", -- Sandrunner Wristguards
	[4929]="0:4:1:1:Leather::1:0::3:0", -- Light Scorpid Armor
	[4931]="0:2:1:1:Bow::1:0::3:0", -- Hickory Shortbow
	[4932]="0:2:1:1:OneHandSword::1:0::3:0", -- Harpy Wing Clipper
	[4933]="0:4:1:1:Cloak::1:0::3:0", -- Seasoned Fighter's Cloak
	[4935]="0:4:1:1:Mail::1:0::3:0", -- Wide Metal Girdle
	[4936]="0:4:1:1:Cloth::1:0::3:0", -- Dirt-Trodden Boots
	[4937]="0:4:1:1:Shield::1:0::3:0", -- Charging Buckler
	[4938]="0:2:1:1:Stave::1:0::3:0", -- Blemished Wooden Staff
	[4939]="0:2:2:1:TwoHandSword::1:0::3:0", -- Steady Bastard Sword
	[4940]="0:4:1:1:Leather::1:0::3:0", -- Veiled Grips
	[4941]="0:0:1:20:Consumable::1:0::3:0", -- Really Sticky Glue
	[4942]="0:4:1:1:Leather::1:0::3:0", -- Tiger Hide Boots
	[4944]="0:4:1:1:Cloak::1:0::3:0", -- Handsewn Cloak
	[4945]="0:0:1:1:Consumable::1:0::3:0", -- Faintly Glowing Skull
	[4946]="0:4:1:1:Mail::1:0::3:0", -- Lightweight Boots
	[4947]="0:2:2:1:Dagger::1:0::3:0", -- Jagged Dagger
	[4948]="0:2:2:1:OneHandMace::1:0::3:0", -- Stinging Mace
	[4949]="0:2:2:1:OneHandAxe::1:0::2:0", -- Orcish Cleaver
	[4951]="0:4:1:1:Leather::1:0::0:0", -- Squealer's Belt
	[4952]="0:0:1:10:Consumable::1:0::3:0", -- Stormstout
	[4953]="0:0:1:10:Consumable::1:0::3:0", -- Trogg Ale
	[4954]="0:4:1:1:Leather::1:0::3:0", -- Nomadic Belt
	[4957]="0:1:1:1:Bag::1:0::3:0", -- Old Moneybag
	[4958]="0:4:1:1:Cloak::1:0::3:0", -- Sun-Beaten Cloak
	[4960]="0:15:0:1000:Junk::1:0::0:0", -- Flash Pellet
	[4961]="0:2:1:1:Stave::1:0::3:0", -- Dreamwatcher Staff
	[4962]="0:4:1:1:Leather::1:0::3:0", -- Double-Layered Gloves
	[4963]="0:4:1:1:Cloak::1:0::3:0", -- Thunderhorn Cloak
	[4964]="0:2:2:1:TwoHandMace::1:0::3:0", -- Goblin Smasher
	[4967]="0:4:1:1:Shield::1:0::3:0", -- Tribal Warrior's Shield
	[4968]="0:4:1:1:Leather::1:0::3:0", -- Bound Harness
	[4969]="0:4:1:1:Mail::1:0::3:0", -- Fortified Bindings
	[4970]="0:4:1:1:Leather::1:0::3:0", -- Rough-Hewn Kodo Leggings
	[4971]="0:2:2:1:OneHandMace::1:0::3:0", -- Skorn's Hammer
	[4972]="0:4:1:1:Mail::1:0::3:0", -- Cliff Runner Boots
	[4973]="0:4:1:1:Leather::1:0::3:0", -- Plains Hunter Wristguards
	[4974]="0:2:2:1:Dagger::1:0::3:0", -- Compact Fighting Knife
	[4975]="0:4:3:1:Shield::1:0::3:0", -- Vigilant Buckler
	[4976]="0:4:2:1:Leather::1:0::3:0", -- Mistspray Kilt
	[4977]="0:2:2:1:OneHandSword::1:0::3:0", -- Sword of Hammerfall
	[4978]="0:2:2:1:OneHandMace::1:0::3:0", -- Ryedol's Hammer
	[4979]="0:4:2:1:Cloth::1:0::3:0", -- Enchanted Stonecloth Bracers
	[4980]="0:4:2:1:Leather::1:0::3:0", -- Prospector Gloves
	[4982]="0:4:0:1:Leather::1:0::3:0", -- Ripped Prospector Belt
	[4983]="0:2:2:1:TwoHandMace::1:0::3:0", -- Rock Pulverizer
	[4984]="0:4:2:1:OffHandFrill::1:0::3:0", -- Skull of Impending Doom
	[4986]="0:12:1:1:::1:0::4:0", -- Flawed Power Stone
	[4987]="0:2:2:1:OneHandSword::1:0::3:0", -- Dwarf Captain's Sword
	[4992]="0:12:1:1:::1:0::4:0", -- Recruitment Letter
	[4995]="0:12:1:1:::1:0::4:0", -- Signed Recruitment Letter
	[4998]="0:4:2:1:Ring::1:0::2:0", -- Blood Ring
	[4999]="0:4:2:1:Ring::1:0::2:0", -- Azora's Will
	[5001]="0:4:2:1:Ring::1:0::2:0", -- Heart Ring
	[5002]="0:4:2:1:Amulet::1:0::2:0", -- Glowing Green Talisman
	[5003]="0:4:2:1:Amulet::1:0::2:0", -- Crystal Starfire Medallion
	[5005]="0:4:2:1:Amulet::1:0::2:0", -- Emberspark Pendant
	[5006]="0:12:1:1:::1:0::4:0", -- Khazgorm's Journal
	[5007]="0:4:2:1:Ring::1:0::2:0", -- Band of Thorns
	[5008]="0:4:2:1:Ring::1:0::2:0", -- Quicksilver Ring
	[5009]="0:4:2:1:Ring::1:0::2:0", -- Mindbender Loop
	[5010]="0:4:2:1:Ring::1:0::2:0", -- Inscribed Gold Ring
	[5011]="0:4:2:1:Ring::1:0::2:0", -- Welken Ring
	[5012]="0:12:1:20:::1:0::4:0", -- Fungal Spores
	[5016]="0:4:2:1:Cloth::1:0::3:0", -- Artisan's Trousers
	[5017]="0:12:1:20:::1:0::4:0", -- Nitroglycerin
	[5018]="0:12:1:20:::1:0::4:0", -- Wood Pulp
	[5019]="0:12:1:20:::1:0::4:0", -- Sodium Nitrate
	[5020]="0:13:1:1:::1:0::0:0", -- Kolkar Booty Key
	[5021]="0:12:1:1:::1:0::4:0", -- Explosive Stick of Gann
	[5022]="0:12:1:1:::1:0::4:0", -- Kodobane's Head
	[5023]="0:12:1:1:::1:0::4:0", -- Verog's Head
	[5025]="0:12:1:1:::1:0::4:0", -- Hezrul's Head
	[5026]="0:12:1:1:::1:0::4:0", -- Fire Tar
	[5027]="0:12:1:1:::1:0::4:0", -- Rendered Spores
	[5028]="0:4:2:1:OffHandFrill::1:0::2:0", -- Lord Sakrasis' Scepter
	[5029]="0:4:2:1:Amulet::1:0::2:0", -- Talisman of the Naga Lord
	[5030]="0:12:1:20:::1:0::4:0", -- Centaur Bracers
	[5038]="0:12:1:1:::1:0::4:0", -- Tear of the Moons
	[5040]="0:2:1:1:Dagger::1:0::4:0", -- Shadow Hunter Knife
	[5042]="50:0:1:10:Other::1:0:151,1250,1682,1685,1691,2134,2140,3076,3164,3186,3313,3481,3608,4170,4241,8362,16187,16191,16259,16260,16444,16732,17421,17446,17489,18810,19197,36695,36779,38783,38853,42853,43384,43419,43424,43425,43558,43637,43953,44034,45484,45491,45496,45497,46994,51709:0:0", -- Red Ribboned Wrapping Paper
	[5043]="0:0:1:1:Other::1:0::0:0", -- Red Ribboned Gift
	[5044]="0:0:1:1:Other::1:0::0:0", -- Blue Ribboned Gift
	[5048]="50:0:1:10:Other::1:0:491,791,3313,3498,4082,4555,7942,8362,12027,12960,16191,16732,17489,18811,19197,43424,43637,43953,44183,45484,45496,49397,49435,51709:0:0", -- Blue Ribboned Wrapping Paper
	[5050]="0:13:1:1:::1:0::4:0", -- Ignition Key
	[5051]="1:12:1:20::185:1:1:3443:0:0", -- Dig Rat
	[5052]="0:12:1:1:::1:0::0:0", -- Unconscious Dig Rat
	[5054]="0:12:1:1:::1:0::4:0", -- Samophlange
	[5055]="0:12:1:20:::1:0::4:0", -- Intact Raptor Horn
	[5056]="0:12:1:20:::1:0::4:0", -- Root Sample
	[5057]="0:0:1:20:FoodDrink::1:0::0:0", -- Ripe Watermelon
	[5058]="0:12:1:20:::1:0::4:0", -- Silithid Egg
	[5059]="0:12:1:1:::1:0::3:0", -- Digging Claw
	[5060]="0:15:1:1:Reagent::1:0::3:0", -- Thieves' Tools
	[5061]="0:12:1:20:::1:0::4:0", -- Stolen Silver
	[5062]="0:12:1:20:::1:0::4:0", -- Raptor Head
	[5063]="0:12:1:1:::1:0::4:0", -- Kreenig Snarlsnout's Tusk
	[5064]="0:12:1:20:::1:0::4:0", -- Witchwing Talon
	[5065]="0:12:1:20:::1:0::4:0", -- Harpy Lieutenant Ring
	[5066]="0:0:1:10:FoodDrink::1:0::0:0", -- Fissure Plant
	[5067]="0:12:1:1:::1:0::4:0", -- Serena's Head
	[5068]="0:12:1:1:::1:0::4:0", -- Dried Seeds
	[5069]="0:2:2:1:Wand::1:0::2:0", -- Fire Wand
	[5071]="0:2:2:1:Wand::1:0::2:0", -- Shadow Wand
	[5072]="0:12:1:1:::1:0::4:0", -- Lok's Skull
	[5073]="0:12:1:1:::1:0::4:0", -- Nak's Skull
	[5074]="0:12:1:1:::1:0::4:0", -- Kuz's Skull
	[5075]="0:12:1:10:::1:0::0:0", -- Blood Shard
	[5076]="0:12:1:20:::1:0::4:0", -- Shipment of Boots
	[5077]="0:12:1:20:::1:0::4:0", -- Telescopic Lens
	[5078]="0:12:1:20:::1:0::4:0", -- Theramore Medal
	[5079]="0:4:2:1:Trinket::1:0::2:0", -- Cold Basilisk Eye
	[5080]="0:12:1:10:::1:0::4:0", -- Gazlowe's Ledger
	[5081]="0:1:1:1:Bag::1:0::0:0", -- Kodo Hide Bag
	[5082]="0:7:1:10:Leather:165:1:0::0:0", -- Thin Kodo Leather
	[5083]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Kodo Hide Bag
	[5084]="0:12:1:1:::1:0::4:0", -- Cap'n Garvey's Head
	[5085]="0:12:1:60:::1:0::4:0", -- Quilboar Tusk
	[5086]="0:12:1:20:::1:0::4:0", -- Zhevra Hooves
	[5087]="0:12:1:20:::1:0::4:0", -- Plainstrider Beak
	[5088]="0:12:1:1:::1:0::4:0", -- Control Console Operating Manual
	[5089]="0:13:1:1:::1:0::4:0", -- Console Key
	[5092]="0:2:1:1:Wand::1:0::3:0", -- Charred Razormane Wand
	[5093]="0:2:1:1:Dagger::1:0::3:0", -- Razormane Backstabber
	[5094]="0:4:1:1:Shield::1:0::3:0", -- Razormane War Shield
	[5095]="0:0:1:20:FoodDrink::1:0::0:0", -- Rainbow Fin Albacore
	[5096]="0:12:1:20:::1:0::4:0", -- Huntress Claws
	[5097]="0:12:1:1:::1:0::4:0", -- Cats Eye Emerald
	[5098]="0:12:1:20:::1:0::4:0", -- Altered Snapjaw Shell
	[5099]="0:12:1:1:::1:0::3:0", -- Hoof of Lakota'mani
	[5100]="0:12:1:1:::1:0::4:0", -- Echeyakee's Hide
	[5102]="0:12:1:1:::1:0::3:0", -- Owatanka's Tailspike
	[5104]="0:12:1:1:::1:0::4:0", -- Heart of Isha Awak
	[5105]="0:15:1:20:Junk::1:0::0:0", -- Explosive Shell
	[5107]="0:4:1:1:Shirt::1:0::0:0", -- Deckhand's Shirt
	[5109]="0:4:1:1:Cloth::1:0::0:0", -- Stonesplinter Rags
	[5110]="0:4:1:1:Cloth::1:0::0:0", -- Dalaran Wizard's Robe
	[5111]="0:4:2:1:Cloak::1:0::2:0", -- Rathorian's Cape
	[5112]="0:2:2:1:Dagger::1:0::2:0", -- Ritual Blade
	[5113]="0:15:0:20:Junk::1:0::0:0", -- Mark of the Syndicate
	[5114]="0:15:0:20:Junk::1:0::0:0", -- Severed Talon
	[5115]="0:15:0:20:Junk::1:0::0:0", -- Broken Wishbone
	[5116]="0:7:0:20:Leather::1:0::0:0", -- Long Tail Feather
	[5117]="0:12:1:10:::1:0::0:0", -- Vibrant Plume
	[5118]="0:15:0:20:Junk::1:0::0:0", -- Large Flat Tooth
	[5119]="0:15:0:20:Junk::1:0::0:0", -- Fine Loose Hair
	[5120]="0:15:0:20:Junk::1:0::0:0", -- Long Tail Hair
	[5121]="0:15:0:20:Junk::1:0::0:0", -- Dirty Kodo Scale
	[5122]="0:15:0:20:Junk::1:0::0:0", -- Thick Kodo Hair
	[5123]="0:15:0:20:Junk::1:0::0:0", -- Steel Arrowhead
	[5124]="0:15:0:20:Junk::1:0::0:0", -- Small Raptor Tooth
	[5125]="0:15:0:20:Junk::1:0::0:0", -- Charged Scale
	[5128]="0:15:0:20:Junk::1:0::0:0", -- Shed Lizard Skin
	[5133]="0:15:0:20:Junk::1:0::0:0", -- Seeping Gizzard
	[5134]="0:12:1:5:::1:0::0:0", -- Small Furry Paw
	[5135]="0:15:0:20:Junk::1:0::0:0", -- Thin Black Claw
	[5136]="0:15:0:20:Junk::1:0::0:0", -- Torn Furry Ear
	[5137]="0:15:0:20:Junk::1:0::0:0", -- Bright Eyeball
	[5138]="0:12:1:1:::1:0::3:0", -- Harvester's Head
	[5140]="0:15:0:20:Reagent::1:0::0:0", -- Flash Powder
	[5143]="0:12:1:20:::1:0::4:0", -- Thunder Lizard Blood
	[5164]="0:12:1:1:::1:0::4:0", -- Thunderhawk Wings
	[5165]="0:12:1:20:::1:0::4:0", -- Sunscale Feather
	[5166]="0:12:1:20:::1:0::4:0", -- Webwood Venom Sac
	[5167]="0:12:1:20:::1:0::4:0", -- Webwood Egg
	[5168]="0:12:1:20:::1:0::4:0", -- Timberling Seed
	[5169]="0:12:1:20:::1:0::4:0", -- Timberling Sprout
	[5170]="0:12:1:20:::1:0::4:0", -- Mossy Tumor
	[5173]="0:15:0:20:Junk::1:0::0:0", -- Deathweed
	[5175]="0:15:1:1:Reagent::1:0::3:0", -- Earth Totem
	[5176]="0:15:1:1:Reagent::1:0::3:0", -- Fire Totem
	[5177]="0:15:1:1:Reagent::1:0::3:0", -- Water Totem
	[5178]="0:15:1:1:Reagent::1:0::3:0", -- Air Totem
	[5179]="0:12:1:1:::1:0::3:0", -- Moss-Twined Heart
	[5180]="0:4:2:1:Amulet::1:0::2:0", -- Necklace of Harmony
	[5181]="0:4:2:1:Cloak::1:0::2:0", -- Vibrant Silk Cape
	[5182]="0:2:2:1:TwoHandSword::1:0::2:0", -- Shiver Blade
	[5183]="0:4:3:1:OffHandFrill::1:0::2:0", -- Pulsating Hydra Heart
	[5184]="0:12:1:1:::1:0::4:0", -- Filled Crystal Phial
	[5185]="0:12:1:1:::1:0::4:0", -- Crystal Phial
	[5186]="0:12:1:1:::1:0::4:0", -- Partially Filled Vessel
	[5187]="0:2:3:1:TwoHandMace::1:0::3:0", -- Foe Reaper
	[5188]="0:12:1:1:::1:0::4:0", -- Filled Vessel
	[5189]="0:12:1:1:::1:0::4:0", -- Glowing Fruit
	[5190]="0:12:1:1:::1:0::4:0", -- Shimmering Frond
	[5191]="0:2:3:1:OneHandSword::1:0::3:0", -- Cruel Barb
	[5192]="0:2:3:1:OneHandSword::1:0::3:0", -- Thief's Blade
	[5193]="0:4:3:1:Cloak::1:0::3:0", -- Cape of the Brotherhood
	[5194]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Taskmaster Axe
	[5195]="0:4:3:1:Cloth::1:0::3:0", -- Gold-Flecked Gloves
	[5196]="0:2:3:1:OneHandAxe::1:0::3:0", -- Smite's Reaver
	[5197]="0:2:3:1:OneHandMace::1:0::3:0", -- Cookie's Tenderizer
	[5198]="0:2:3:1:Wand::1:0::3:0", -- Cookie's Stirring Rod
	[5199]="0:4:3:1:Leather::1:0::3:0", -- Smelting Pants
	[5200]="0:2:3:1:Polearm::1:0::3:0", -- Impaling Harpoon
	[5201]="0:2:3:1:Stave::1:0::3:0", -- Emberstone Staff
	[5202]="0:4:3:1:Cloth::1:0::3:0", -- Corsair's Overshirt
	[5203]="0:12:1:20:::1:0::4:0", -- Flatland Prowler Claw
	[5204]="0:12:1:20:::1:0::4:0", -- Bloodfeather Belt
	[5205]="0:0:1:10:Other::1:0::0:0", -- Sprouted Frond
	[5206]="0:0:1:10:Other::1:0::0:0", -- Bogling Root
	[5207]="0:2:2:1:Wand::1:0::2:0", -- Opaque Wand
	[5208]="3340:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943:0:0", -- Smoldering Wand
	[5209]="3855:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943:0:0", -- Gloom Wand
	[5210]="5808:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943:0:0", -- Burning Wand
	[5211]="5830:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943:0:0", -- Dusk Wand
	[5212]="0:2:2:1:Wand::1:0::2:0", -- Blazing Wand
	[5213]="0:2:2:1:Wand::1:0::2:0", -- Scorching Wand
	[5214]="0:2:2:1:Wand::1:0::2:0", -- Wand of Eventide
	[5215]="0:2:2:1:Wand::1:0::2:0", -- Ember Wand
	[5216]="0:2:2:1:Wand::1:0::2:0", -- Umbral Wand
	[5217]="0:12:1:1:::1:0::4:0", -- Tainted Heart
	[5218]="0:12:1:1:::1:0::4:0", -- Cleansed Timberling Heart
	[5219]="0:12:1:1:::1:0::4:0", -- Inscribed Bark
	[5221]="0:12:1:1:::1:0::4:0", -- Melenas' Head
	[5232]="0:0:1:1:Consumable::1:0::3:0", -- Soulstone
	[5233]="0:12:1:1:::1:0::4:0", -- Stone of Relu
	[5234]="0:12:1:1:::1:0::4:0", -- Flagongut's Fossil
	[5236]="14394:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943:0:0", -- Combustible Wand
	[5237]="40:0:1:20:EnhTemp::1:0:1325,1326,2622,3090,3135,3334,3405,3490,3551,3561,3969,4585,5139,5169,6779,12096,15175,16268,16588,16683,16829,18006,18019,18802,19013,19014,19049,19239,19679,20081,20194,20915,20986,22479,23145,23373,23732,24148,24313,24357,24780,25043,25736,26382,26568,26598,26900,26945,27031,27038,27053,27089,27133,27149,27176,27186,28347,28832,28869,29015,29037,29535,29561,29909,29922,29947,29961,30010,30306,30438,31115,32639,32641,33630,33674,35642,39144,39878,41275,41490,41508,41676,41891,42622,42878,42910,42967,43155,43381,43411,43493,43547,43551,43555,43563,43646,43774,44047,44187,44313,44333,44970,45289,45290,45361,47860,53040,53076:0:0", -- Mind-Numbing Poison
	[5238]="35727:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943:0:0", -- Pitchwood Wand
	[5239]="38731:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943:0:0", -- Blackbone Wand
	[5240]="0:2:2:1:Wand::1:0::3:0", -- Torchlight Wand
	[5241]="0:2:2:1:Wand::1:0::3:0", -- Dwarven Flamestick
	[5242]="0:2:2:1:Wand::1:0::3:0", -- Cinder Wand
	[5243]="0:2:3:1:Wand::1:0::3:0", -- Firebelcher
	[5244]="0:2:2:1:Wand::1:0::3:0", -- Consecrated Wand
	[5245]="0:2:2:1:Wand::1:0::2:0", -- Summoner's Wand
	[5246]="0:2:2:1:Wand::1:0::3:0", -- Excavation Rod
	[5247]="0:2:2:1:Wand::1:0::3:0", -- Rod of Sorrow
	[5248]="0:2:2:1:Wand::1:0::3:0", -- Flash Wand
	[5249]="0:2:2:1:Wand::1:0::3:0", -- Burning Sliver
	[5250]="0:2:2:1:Wand::1:0::3:0", -- Charred Wand
	[5251]="0:12:1:1:::1:0::4:0", -- Phial of Scrying
	[5252]="0:2:2:1:Wand::1:0::3:0", -- Wand of Decay
	[5253]="0:2:2:1:Wand::1:0::3:0", -- Goblin Igniter
	[5254]="0:4:3:1:Leather::1:0::3:0", -- Rugged Spaulders
	[5256]="0:2:2:1:OneHandMace::1:0::2:0", -- Kovork's Rattle
	[5257]="0:4:3:1:Cloak::1:0::2:0", -- Dark Hooded Cape
	[5263]="0:15:0:20:Junk::1:0::0:0", -- Pocket Lint
	[5266]="0:4:3:1:Ring::1:0::2:0", -- Eye of Adaegus
	[5267]="0:2:3:1:Dagger::1:0::2:0", -- Scarlet Kris
	[5268]="0:15:0:20:Junk::1:0::0:0", -- Cracked Silithid Shell
	[5269]="0:15:0:20:Junk::1:0::0:0", -- Silithid Ichor
	[5270]="0:12:1:20:::1:0::4:0", -- Death Cap
	[5271]="0:12:1:20:::1:0::4:0", -- Scaber Stalk
	[5272]="0:12:1:1:::1:0::4:0", -- Insane Scribbles
	[5273]="0:12:1:20:::1:0::4:0", -- Mathystra Relic
	[5274]="0:4:2:1:Cloth::1:0::3:0", -- Rose Mantle
	[5275]="0:4:2:1:Leather::1:0::3:0", -- Binding Girdle
	[5279]="0:2:2:1:Dagger::1:0::3:0", -- Harpy Skinner
	[5299]="0:4:2:1:Leather::1:0::3:0", -- Gloves of the Moon
	[5302]="0:4:2:1:Shield::1:0::3:0", -- Cobalt Buckler
	[5306]="0:2:2:1:Stave::1:0::3:0", -- Wind Rider Staff
	[5309]="0:2:2:1:Gun::1:0::3:0", -- Privateer Musket
	[5310]="0:4:2:1:Cloth::1:0::3:0", -- Sea Dog Britches
	[5311]="0:4:2:1:Leather::1:0::3:0", -- Buckled Boots
	[5312]="0:4:2:1:Mail::1:0::3:0", -- Riveted Gauntlets
	[5313]="0:4:2:1:Ring::1:0::3:0", -- Totemic Clan Ring
	[5314]="0:4:2:1:Cloak::1:0::3:0", -- Boar Hunter's Cape
	[5315]="0:4:2:1:Cloth::1:0::3:0", -- Timberland Armguards
	[5316]="0:4:2:1:Leather::1:0::3:0", -- Barkshell Tunic
	[5317]="0:4:2:1:Leather::1:0::3:0", -- Dry Moss Tunic
	[5318]="0:2:2:1:TwoHandAxe::1:0::3:0", -- Zhovur Axe
	[5319]="0:4:1:1:Leather::1:0::0:0", -- Bashing Pauldrons
	[5320]="0:4:2:1:Mail::1:0::3:0", -- Padded Lamellar Boots
	[5321]="0:2:2:1:OneHandSword::1:0::3:0", -- Elegant Shortsword
	[5322]="0:2:2:1:TwoHandMace::1:0::3:0", -- Demolition Hammer
	[5323]="0:4:2:1:OffHandFrill::1:0::3:0", -- Everglow Lantern
	[5324]="0:2:2:1:OneHandMace::1:0::3:0", -- Engineer's Hammer
	[5325]="0:4:2:1:Shield::1:0::3:0", -- Welding Shield
	[5326]="0:2:2:1:Wand::1:0::3:0", -- Flaring Baton
	[5327]="0:4:2:1:Leather::1:0::3:0", -- Greasy Tinker's Pants
	[5328]="0:4:2:1:Mail::1:0::3:0", -- Cinched Belt
	[5329]="0:15:0:20:Junk::1:0::0:0", -- Cat Figurine
	[5332]="0:15:1:1:Junk::1:0::3:0", -- Glowing Cat Figurine
	[5334]="0:12:1:1:::1:0::4:0", -- 99-Year-Old Port
	[5335]="0:15:1:1:Junk::1:0::3:0", -- A Sack of Coins
	[5336]="0:12:1:20:::1:0::4:0", -- Grell Earring
	[5337]="0:4:2:1:Cloth::1:0::3:0", -- Wayfaring Gloves
	[5338]="0:12:1:1:::1:0::4:0", -- Ancient Moonstone Seal
	[5339]="0:12:1:20:::1:0::4:0", -- Serpentbloom
	[5340]="0:2:2:1:Stave::1:0::3:0", -- Cauldron Stirrer
	[5341]="0:4:2:1:Leather::1:0::3:0", -- Spore-Covered Tunic
	[5342]="0:0:1:10:FoodDrink::1:0::0:0", -- Raptor Punch
	[5343]="0:4:2:1:Cloak::1:0::3:0", -- Barkeeper's Cloak
	[5344]="0:2:2:1:OneHandAxe::1:0::3:0", -- Pointed Axe
	[5345]="0:2:2:1:TwoHandMace::1:0::3:0", -- Stonewood Hammer
	[5346]="0:2:2:1:Bow::1:0::3:0", -- Orcish Battle Bow
	[5347]="15713:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943:0:0", -- Pestilent Wand
	[5348]="0:12:1:20:::1:0::4:0", -- Worn Parchment
	[5349]="0:0:1:20:FoodDrink::1:0::0:0", -- Conjured Muffin
	[5350]="0:0:1:20:FoodDrink::1:0::0:0", -- Conjured Water
	[5351]="0:4:2:1:Ring::1:0::3:0", -- Bounty Hunter's Ring
	[5352]="0:12:1:1:::1:0::3:0", -- Book: The Powers Below
	[5354]="0:12:1:1:::1:0::4:0", -- Letter to Delgren
	[5355]="0:4:2:1:Leather::1:0::3:0", -- Beastmaster's Girdle
	[5356]="0:2:2:1:Wand::1:0::3:0", -- Branding Rod
	[5357]="0:4:2:1:Shield::1:0::3:0", -- Ward of the Vale
	[5359]="0:12:1:1:::1:0::4:0", -- Lorgalis Manuscript
	[5360]="0:12:1:20:::1:0::4:0", -- Highborne Relic
	[5361]="0:15:0:20:Junk::1:0::0:0", -- Fishbone Toothpick
	[5362]="0:15:0:20:Junk::1:0::0:0", -- Chew Toy
	[5363]="0:15:0:20:Junk::1:0::0:0", -- Folded Handkerchief
	[5364]="0:15:0:20:Junk::1:0::0:0", -- Dry Salt Lick
	[5366]="0:12:1:1:::1:0::4:0", -- Glowing Soul Gem
	[5367]="0:15:0:20:Junk::1:0::0:0", -- Primitive Rock Tool
	[5368]="0:15:0:20:Junk::1:0::0:0", -- Empty Wallet
	[5369]="0:15:0:20:Junk::1:0::0:0", -- Gnawed Bone
	[5370]="0:15:0:20:Junk::1:0::0:0", -- Bent Spoon
	[5371]="0:15:0:20:Junk::1:0::0:0", -- Piece of Coral
	[5373]="0:15:1:5:Junk:165:1:0::0:0", -- Lucky Charm
	[5374]="0:15:0:20:Junk::1:0::0:0", -- Small Pocket Watch
	[5375]="0:15:0:20:Junk::1:0::0:0", -- Scratching Stick
	[5376]="0:15:0:20:Junk::1:0::0:0", -- Broken Mirror
	[5377]="0:15:0:20:Junk::1:0::0:0", -- Scallop Shell
	[5379]="0:15:0:200:Junk::1:0::0:0", -- Broken Boot Knife
	[5382]="0:12:1:1:::1:0::4:0", -- Anaya's Pendant
	[5385]="0:12:1:20:::1:0::4:0", -- Crawler Leg
	[5386]="0:12:1:20:::1:0::4:0", -- Fine Moonstalker Pelt
	[5387]="0:4:2:1:Cloak::1:0::3:0", -- Enchanted Moonstalker Cloak
	[5388]="0:12:1:1:::1:0::4:0", -- Ran Bloodtooth's Skull
	[5390]="0:12:1:1:::1:0::4:0", -- Fandral's Message
	[5391]="0:12:1:1:::1:0::4:0", -- Rare Earth
	[5392]="0:2:1:1:Dagger::1:0::3:0", -- Thistlewood Dagger
	[5393]="0:2:1:1:Stave::1:0::3:0", -- Thistlewood Staff
	[5394]="0:4:1:1:Leather::1:0::3:0", -- Archery Training Gloves
	[5395]="0:4:1:1:Shield::1:0::3:0", -- Woodland Shield
	[5396]="0:13:1:1:::1:0::3:0", -- Key to Searing Gorge
	[5397]="0:15:1:1:Junk::1:0::3:0", -- Defias Gunpowder
	[5398]="0:4:1:1:Leather::1:0::3:0", -- Canopy Leggings
	[5399]="0:4:1:1:Mail::1:0::3:0", -- Tracking Boots
	[5404]="0:4:3:1:Leather::1:0::3:0", -- Serpent's Shoulders
	[5405]="0:4:1:1:Cloak::1:0::3:0", -- Draped Cloak
	[5411]="0:4:1:1:Miscellaneous::1:0::4:0", -- Winterhoof Cleansing Totem
	[5412]="0:12:1:20:::1:0::4:0", -- Thresher Eye
	[5413]="0:12:1:20:::1:0::4:0", -- Moonstalker Fang
	[5414]="0:12:1:20:::1:0::4:0", -- Grizzled Scalp
	[5415]="0:12:1:1:::1:0::4:0", -- Thunderhorn Cleansing Totem
	[5416]="0:12:1:1:::1:0::4:0", -- Wildmane Cleansing Totem
	[5419]="0:4:1:1:Leather::1:0::3:0", -- Feral Bracers
	[5420]="0:4:2:1:Cloth::1:0::3:0", -- Banshee Armor
	[5421]="0:0:1:1:EnhPerm::1:0::3:0", -- Fiery Blaze Enchantment
	[5422]="0:4:2:1:Leather::1:0::2:0", -- Brambleweed Leggings
	[5423]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Boahn's Fang
	[5424]="0:12:1:20:::1:0::4:0", -- Ancient Statuette
	[5425]="0:4:3:1:Mail::1:0::2:0", -- Runescale Girdle
	[5426]="0:2:3:1:OneHandAxe::1:0::2:0", -- Serpent's Kiss
	[5427]="0:15:0:20:Junk::1:0::0:0", -- Crude Pocket Watch
	[5428]="0:15:0:20:Junk::1:0::0:0", -- An Exotic Cookbook
	[5429]="0:15:0:20:Junk::1:0::0:0", -- A Pretty Rock
	[5430]="0:15:0:20:Junk::1:0::0:0", -- Intricate Bauble
	[5431]="0:15:0:20:Junk::1:0::0:0", -- Empty Hip Flask
	[5432]="0:15:0:20:Junk::1:0::0:0", -- Hickory Pipe
	[5433]="0:15:0:20:Junk::1:0::0:0", -- Rag Doll
	[5435]="0:15:0:20:Junk::1:0::0:0", -- Shiny Dinglehopper
	[5437]="0:12:1:20:::1:0::4:0", -- Bathran's Hair
	[5439]="0:1:1:1:Bag::1:0::0:0", -- Small Quiver
	[5440]="0:12:1:1:::1:0::4:0", -- Bottle of Disease
	[5441]="0:1:1:1:Bag::1:0::0:0", -- Small Shot Pouch
	[5442]="0:12:1:1:::1:0::4:0", -- Head of Arugal
	[5443]="0:4:3:1:Shield::1:0::3:0", -- Gold-Plated Buckler
	[5444]="0:4:3:1:Cloak::1:0::3:0", -- Miner's Cape
	[5445]="0:12:1:1:::1:0::4:0", -- Ring of Zoram
	[5446]="0:15:0:20:Junk::1:0::0:0", -- Broken Elemental Bracer
	[5447]="0:15:0:20:Junk::1:0::0:0", -- Damaged Elemental Bracer
	[5448]="0:15:0:20:Junk::1:0::0:0", -- Fractured Elemental Bracer
	[5451]="0:15:0:20:Junk::1:0::0:0", -- Crushed Elemental Bracer
	[5455]="0:12:1:1:::1:0::4:0", -- Divined Scroll
	[5456]="0:12:1:1:::1:0::4:0", -- Divining Scroll
	[5457]="0:0:1:10:Consumable::1:0::3:0", -- Severed Voodoo Claw
	[5458]="0:4:2:1:Cloth::1:0::3:0", -- Dirtwood Belt
	[5459]="0:2:2:1:OneHandAxe::1:0::3:0", -- Defender Axe
	[5460]="0:12:1:1:::1:0::4:0", -- Orendil's Cure
	[5461]="0:12:1:1:::1:0::4:0", -- Branch of Cenarius
	[5462]="0:12:1:1:::1:0::4:0", -- Dartol's Rod of Transformation
	[5463]="0:12:1:1:::1:0::4:0", -- Glowing Gem
	[5464]="0:12:1:1:::1:0::4:0", -- Iron Shaft
	[5465]="0:7:1:20:Meat:185:1:0::0:0", -- Small Spider Leg
	[5466]="0:7:1:20:Meat:185:1:0::0:0", -- Scorpid Stinger
	[5467]="0:7:1:20:Meat:185:1:0::0:0", -- Kodo Meat
	[5468]="0:7:1:20:Meat:185:1:0::0:0", -- Soft Frenzy Flesh
	[5469]="0:7:1:20:Meat:185:1:0::0:0", -- Strider Meat
	[5470]="0:7:1:20:Meat:185:1:0::0:0", -- Thunder Lizard Tail
	[5471]="0:7:1:20:Meat:185:1:0::0:0", -- Stag Meat
	[5472]="0:0:1:20:FoodDrink::1:0::0:0", -- Kaldorei Spider Kabob
	[5473]="0:0:1:20:FoodDrink::1:0::0:0", -- Scorpid Surprise
	[5474]="0:0:1:20:FoodDrink::1:0::0:0", -- Roasted Kodo Meat
	[5475]="0:13:1:1:::1:0::4:0", -- Wooden Key
	[5476]="0:0:1:20:FoodDrink::1:0::0:0", -- Fillet of Frenzy
	[5477]="0:0:1:20:FoodDrink::1:0::0:0", -- Strider Stew
	[5478]="0:0:1:20:FoodDrink::1:0::0:0", -- Dig Rat Stew
	[5479]="0:0:1:20:FoodDrink::1:0::0:0", -- Crispy Lizard Tail
	[5480]="0:0:1:20:FoodDrink::1:0::0:0", -- Lean Venison
	[5481]="0:12:1:20:::1:0::4:0", -- Satyr Horns
	[5482]="0:9:1:1:Cooking::1:0::0:0", -- Recipe: Kaldorei Spider Kabob
	[5483]="140:9:1:1:Cooking::1:0:3881:0:0", -- Recipe: Scorpid Surprise
	[5484]="240:9:1:1:Cooking::1:0:3081:0:0", -- Recipe: Roasted Kodo Meat
	[5485]="0:9:1:1:Cooking::1:0::0:0", -- Recipe: Fillet of Frenzy
	[5486]="440:9:1:1:Cooking::1:0:3482:0:0", -- Recipe: Strider Stew
	[5487]="0:9:1:1:Cooking::1:0::0:0", -- Recipe: Dig Rat Stew
	[5488]="400:9:1:1:Cooking::1:0:3482:0:0", -- Recipe: Crispy Lizard Tail
	[5489]="1200:9:1:1:Cooking::1:1:12245:0:0", -- Recipe: Lean Venison
	[5490]="0:12:1:20:::1:0::4:0", -- Wrathtail Head
	[5493]="0:12:1:1:::1:0::4:0", -- Elune's Tear
	[5494]="0:12:1:20:::1:0::4:0", -- Handful of Stardust
	[5498]="0:3:2:20:GemSimple:164,755,165,197:1:0::0:0", -- Small Lustrous Pearl
	[5500]="0:3:2:20:GemSimple:164,333,165,197:1:0::0:0", -- Iridescent Pearl
	[5503]="0:7:1:20:Meat:185:1:0::0:0", -- Clam Meat
	[5504]="0:7:1:20:Meat:185:1:0::0:0", -- Tangy Clam Meat
	[5505]="0:12:1:1:::1:0::4:0", -- Teronis' Journal
	[5506]="0:15:0:20:Junk::1:0::0:0", -- Beady Eye Stalk
	[5507]="0:7:1:1:Device::1:0::0:0", -- Ornate Spyglass
	[5508]="0:12:1:5:::1:0::4:0", -- Fallen Moonstone
	[5509]="0:0:1:1:Other::1:0::0:0", -- Healthstone
	[5510]="0:0:1:1:Other::1:0::0:0", -- Greater Healthstone
	[5511]="0:0:1:1:Other::1:0::0:0", -- Lesser Healthstone
	[5512]="0:0:1:1:Other::1:0::0:0", -- Healthstone
	[5513]="0:0:1:1:Consumable::1:0::3:0", -- Mana Jade
	[5514]="0:4:1:1:Miscellaneous::1:0::3:0", -- Mana Agate
	[5516]="0:2:0:1:Dagger::1:0::0:0", -- Threshadon Fang
	[5517]="0:13:1:10:::1:0::0:0", -- Tiny Bronze Key
	[5518]="0:13:1:10:::1:0::0:0", -- Tiny Iron Key
	[5519]="0:12:1:1:::1:0::4:0", -- Iron Pommel
	[5520]="0:12:1:1:::1:0::4:0", -- Velinde's Journal
	[5521]="0:13:1:1:::1:0::4:0", -- Velinde's Key
	[5523]="0:7:1:20:Other::1:0::0:0", -- Small Barnacled Clam
	[5524]="0:7:1:20:Other::1:0::0:0", -- Thick-Shelled Clam
	[5525]="0:0:1:20:FoodDrink::1:0::0:0", -- Boiled Clams
	[5526]="0:0:1:20:FoodDrink::1:0::0:0", -- Clam Chowder
	[5527]="0:0:1:20:FoodDrink::1:0::0:0", -- Goblin Deviled Clams
	[5528]="800:9:1:1:Cooking::1:0:4305:0:0", -- Recipe: Clam Chowder
	[5529]="0:15:0:20:Junk::1:0::0:0", -- Tomb Dust
	[5534]="0:12:1:1:::1:0::4:0", -- Parker's Lunch
	[5535]="0:12:1:1:::1:0::4:0", -- Compendium of the Fallen
	[5536]="0:12:1:1:::1:0::4:0", -- Mythology of the Titans
	[5537]="0:12:1:1:::1:0::4:0", -- Sarilus Foulborne's Head
	[5538]="0:12:1:1:::1:0::4:0", -- Vorrel's Wedding Ring
	[5539]="0:12:1:1:::1:0::4:0", -- Letter of Commendation
	[5540]="0:2:2:1:Dagger::1:0::2:0", -- Pearl-Handled Dagger
	[5541]="0:2:2:1:OneHandMace::1:0::2:0", -- Iridescent Hammer
	[5542]="0:4:2:1:Cloak::1:0::2:0", -- Pearl-Clasped Cloak
	[5543]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Iridescent Hammer
	[5544]="0:12:1:1:::1:0::4:0", -- Bloodclaw's Collection
	[5547]="0:12:1:1:::1:0::3:0", -- Reconstructed Rod
	[5565]="0:15:0:5:Reagent:-9:1:0::0:0", -- Infernal Stone
	[5566]="0:15:0:20:Junk::1:0::0:0", -- Broken Antler
	[5567]="0:15:0:20:Junk::1:0::0:0", -- Silver Hook
	[5568]="0:15:0:1000:Junk::1:0::0:0", -- Smooth Pebble
	[5569]="0:15:0:20:Junk::1:0::0:0", -- Seaweed
	[5570]="0:12:1:20:::1:0::4:0", -- Deepmoss Egg
	[5571]="0:1:1:1:Bag::1:0::0:0", -- Small Black Pouch
	[5572]="0:1:1:1:Bag::1:0::0:0", -- Small Green Pouch
	[5573]="0:1:1:1:Bag::1:0::0:0", -- Green Leather Bag
	[5574]="0:1:1:1:Bag::1:0::0:0", -- White Leather Bag
	[5575]="0:1:1:1:Bag::1:0::0:0", -- Large Green Sack
	[5576]="0:1:1:1:Bag::1:0::0:0", -- Large Brown Sack
	[5578]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Silvered Bronze Breastplate
	[5579]="0:2:1:1:TwoHandMace::1:0::3:0", -- Militia Warhammer
	[5580]="0:2:1:1:OneHandMace::1:0::3:0", -- Militia Hammer
	[5581]="0:2:1:1:Stave::1:0::3:0", -- Smooth Walking Staff
	[5582]="0:12:1:20:::1:0::4:0", -- Stonetalon Sap
	[5583]="0:12:1:20:::1:0::4:0", -- Fey Dragon Scale
	[5584]="0:12:1:20:::1:0::4:0", -- Twilight Whisker
	[5585]="0:12:1:20:::1:0::4:0", -- Courser Eye
	[5586]="0:2:1:1:OneHandSword::1:0::3:0", -- Thistlewood Blade
	[5587]="0:2:2:1:OneHandMace::1:0::3:0", -- Thornroot Club
	[5588]="0:12:1:1:::1:0::4:0", -- Lydon's Toxin
	[5589]="0:4:2:1:Mail::1:0::3:0", -- Moss-covered Gauntlets
	[5590]="0:4:2:1:Cloth::1:0::3:0", -- Cord Bracers
	[5591]="0:4:2:1:Cloak::1:0::3:0", -- Rain-Spotted Cape
	[5592]="0:4:1:1:Mail::1:0::3:0", -- Shackled Girdle
	[5593]="0:4:2:1:Shield::1:0::3:0", -- Crag Buckler
	[5594]="0:12:1:1:::1:0::4:0", -- Letter to Jin'Zil
	[5595]="0:2:2:1:TwoHandMace::1:0::3:0", -- Thicket Hammer
	[5596]="0:2:2:1:Bow::1:0::3:0", -- Ashwood Bow
	[5601]="0:15:0:20:Junk::1:0::0:0", -- Hatched Egg Sac
	[5602]="0:15:0:20:Junk::1:0::0:0", -- Sticky Spider Webbing
	[5604]="0:2:2:1:Wand::1:0::3:0", -- Elven Wand
	[5605]="0:2:1:1:Dagger::1:0::3:0", -- Pruning Knife
	[5606]="0:4:1:1:Cloth::1:0::3:0", -- Gardening Gloves
	[5608]="0:4:2:1:Cloth::1:0::2:0", -- Living Cowl
	[5609]="0:4:2:1:Leather::1:0::3:0", -- Steadfast Cinch
	[5610]="0:4:2:1:Cloak::1:0::3:0", -- Gustweald Cloak
	[5611]="0:4:2:1:OffHandFrill::1:0::3:0", -- Tear of Grief
	[5612]="0:4:1:1:Leather::1:0::3:0", -- Ivy Cuffs
	[5613]="0:2:2:1:Stave::1:0::3:0", -- Staff of the Purifier
	[5614]="0:2:2:1:TwoHandSword::1:0::3:0", -- Seraph's Strike
	[5615]="0:2:2:1:TwoHandSword::1:0::3:0", -- Woodsman Sword
	[5616]="0:2:3:1:Dagger::1:0::2:0", -- Gutwrencher
	[5617]="0:4:2:1:Leather::1:0::3:0", -- Vagabond Leggings
	[5618]="0:4:1:1:Cloak::1:0::3:0", -- Scout's Cloak
	[5619]="0:12:1:1:::1:0::4:0", -- Jade Phial
	[5620]="0:12:1:20:::1:0::4:0", -- Vial of Innocent Blood
	[5621]="0:12:1:1:::1:0::4:0", -- Tourmaline Phial
	[5622]="0:4:2:1:Ring::1:0::3:0", -- Clergy Ring
	[5623]="0:12:1:1:::1:0::4:0", -- Amethyst Phial
	[5624]="0:4:2:1:Cloth::1:0::2:0", -- Circlet of the Order
	[5626]="0:2:2:1:TwoHandAxe::1:0::3:0", -- Skullchipper
	[5627]="0:2:2:1:Dagger::1:0::3:0", -- Relic Blade
	[5628]="0:12:1:1:::1:0::4:0", -- Zamah's Note
	[5629]="0:4:2:1:Leather::1:0::3:0", -- Hammerfist Gloves
	[5630]="0:4:2:1:Leather::1:0::3:0", -- Windfelt Gloves
	[5631]="0:0:1:20:Potion::1:0::0:0", -- Rage Potion
	[5633]="0:0:1:20:Potion:165:1:0::0:0", -- Great Rage Potion
	[5634]="0:0:1:20:Potion::1:0::0:0", -- Free Action Potion
	[5635]="0:7:1:5:Other:171,164:1:0::0:0", -- Sharp Claw
	[5636]="0:15:0:20:Junk::1:0::0:0", -- Delicate Feather
	[5637]="0:7:1:5:Other:171,164,333,755,165:1:0::0:0", -- Large Fang
	[5638]="0:12:1:1:::1:0::4:0", -- Toxic Fogger
	[5639]="0:12:1:1:::1:0::4:0", -- Filled Jade Phial
	[5640]="100:9:1:1:Alchemy::1:1:1685,3335,3499:0:0", -- Recipe: Rage Potion
	[5642]="1800:9:1:1:Alchemy::1:1:3348,4226,5178:0:0", -- Recipe: Free Action Potion
	[5643]="2000:9:1:1:Alchemy::1:1:3335,4226:0:0", -- Recipe: Great Rage Potion
	[5645]="0:12:1:1:::1:0::4:0", -- Filled Tourmaline Phial
	[5646]="0:12:1:1:::1:0::4:0", -- Vial of Blessed Water
	[5655]="10000:15:3:1:Mount::1:0:384,1460,4885,43694:3:0", -- Chestnut Mare Bridle
	[5656]="10000:15:3:1:Mount::1:0:384,1460,4885,43694:3:0", -- Brown Horse Bridle
	[5659]="0:12:1:20:::1:0::4:0", -- Smoldering Embers
	[5664]="0:12:1:20:::1:0::4:0", -- Corroded Shrapnel
	[5665]="10000:15:3:1:Mount::1:0:3362:3:0", -- Horn of the Dire Wolf
	[5668]="10000:15:3:1:Mount::1:0:3362:3:0", -- Horn of the Brown Wolf
	[5669]="0:12:1:1:::1:0::4:0", -- Dust Devil Debris
	[5675]="0:12:1:20:::1:0::4:0", -- Crystalized Scales
	[5686]="0:12:1:1:::1:0::4:0", -- Ordanus' Head
	[5687]="0:13:1:1:::1:0::4:0", -- Gatekeeper's Key
	[5689]="0:13:1:1:::1:0::4:0", -- Sleepers' Key
	[5690]="0:13:1:1:::1:0::4:0", -- Claw Key
	[5691]="0:13:1:1:::1:0::4:0", -- Barrow Key
	[5692]="0:12:1:1:::1:0::3:0", -- Remote Detonator (Red)
	[5693]="0:12:1:1:::1:0::3:0", -- Remote Detonator (Blue)
	[5694]="0:12:1:1:::1:0::3:0", -- NG-5 Explosives (Red)
	[5695]="0:12:1:1:::1:0::3:0", -- NG-5 Explosives (Blue)
	[5717]="0:12:1:1:::1:0::4:0", -- Venture Co. Letters
	[5718]="0:12:1:1:::1:0::4:0", -- Venture Co. Engineering Plans
	[5731]="0:12:1:1:::1:0::4:0", -- Scroll of Messaging
	[5732]="0:12:1:1:::1:0::4:0", -- NG-5
	[5733]="0:12:1:1:::1:0::4:0", -- Unidentified Ore
	[5734]="0:12:1:1:::1:0::4:0", -- Super Reaper 6000 Blueprints
	[5735]="0:12:1:1:::1:0::4:0", -- Sealed Envelope
	[5736]="0:12:1:1:::1:0::4:0", -- Gerenzo's Mechanical Arm
	[5737]="0:12:1:1:::1:0::3:0", -- Covert Ops Plans: Alpha & Beta
	[5738]="0:12:1:1:::1:0::4:0", -- Covert Ops Pack
	[5739]="0:4:2:1:Leather::1:0::2:0", -- Barbaric Harness
	[5740]="100:0:1:5:Other::1:0:1304,2838,3180,5569,8116,8117,8118,16650,23208,44305,47166,55278:0:0", -- Red Fireworks Rocket
	[5741]="0:15:0:20:Junk::1:0::0:0", -- Rock Chip
	[5742]="0:2:2:1:Dagger::1:0::2:0", -- Gemstone Dagger
	[5743]="0:4:2:1:Ring::1:0::2:0", -- Prismstone Ring
	[5744]="0:2:2:1:OneHandSword::1:0::2:0", -- Pale Skinner
	[5749]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Scythe Axe
	[5750]="0:4:2:1:Mail::1:0::2:0", -- Warchief's Girdle
	[5751]="0:4:2:1:Cloak::1:0::2:0", -- Webwing Cloak
	[5752]="0:2:2:1:Dagger::1:0::2:0", -- Wyvern Tailspike
	[5753]="0:4:2:1:Leather::1:0::2:0", -- Ruffled Chaplet
	[5754]="0:4:2:1:Amulet::1:0::2:0", -- Wolfpack Medallion
	[5755]="0:4:2:1:Mail::1:0::2:0", -- Onyx Shredder Plate
	[5756]="0:2:3:1:Dagger::1:0::2:0", -- Sliverblade
	[5757]="0:2:2:1:OneHandMace::1:0::3:0", -- Hardwood Cudgel
	[5758]="0:15:2:1:Junk::1:0::0:0", -- Mithril Lockbox
	[5759]="0:15:2:1:Junk::1:0::0:0", -- Thorium Lockbox
	[5760]="0:15:2:1:Junk::1:0::0:0", -- Eternium Lockbox
	[5761]="0:2:1:1:TwoHandMace::1:0::3:0", -- Anvilmar Sledge
	[5762]="0:1:1:1:Bag::1:0::0:0", -- Red Linen Bag
	[5763]="0:1:1:1:Bag::1:0::0:0", -- Red Woolen Bag
	[5764]="0:1:1:1:Bag::1:0::0:0", -- Green Silk Pack
	[5765]="0:1:1:1:Bag::1:0::0:0", -- Black Silk Pack
	[5766]="0:4:2:1:Cloth::1:0::2:0", -- Lesser Wizard's Robe
	[5767]="0:4:1:1:Cloth::1:0::0:0", -- Violet Robes
	[5770]="0:4:2:1:Cloth::1:0::2:0", -- Robes of Arcana
	[5771]="200:9:1:1:Tailoring::1:1:843,3005,3556,16224:0:0", -- Pattern: Red Linen Bag
	[5772]="500:9:1:1:Tailoring::1:1:777,1454,1474,3005,3364,3485,3537,4577,45558:0:0", -- Pattern: Red Woolen Bag
	[5773]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Robes of Arcana
	[5774]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Green Silk Pack
	[5775]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Black Silk Pack
	[5776]="0:2:1:1:Stave::1:0::3:0", -- Elder's Cane
	[5777]="0:2:1:1:TwoHandAxe::1:0::3:0", -- Brave's Axe
	[5778]="0:2:1:1:Stave::1:0::3:0", -- Primitive Walking Stick
	[5779]="0:2:1:1:TwoHandSword::1:0::3:0", -- Forsaken Bastard Sword
	[5780]="0:4:2:1:Leather::1:0::2:0", -- Murloc Scale Belt
	[5781]="0:4:2:1:Leather::1:0::2:0", -- Murloc Scale Breastplate
	[5782]="0:4:2:1:Leather::1:0::2:0", -- Thick Murloc Armor
	[5783]="0:4:2:1:Leather::1:0::2:0", -- Murloc Scale Bracers
	[5784]="0:7:1:10:Leather:165:1:0::0:0", -- Slimy Murloc Scale
	[5785]="0:7:1:10:Leather:165:1:0::0:0", -- Thick Murloc Scale
	[5786]="550:9:1:1:Leatherworking::1:1:843,3556:0:0", -- Pattern: Murloc Scale Belt
	[5787]="600:9:1:1:Leatherworking::1:1:843,3556:0:0", -- Pattern: Murloc Scale Breastplate
	[5788]="650:9:2:1:Leatherworking::1:1:2393,2846:0:0", -- Pattern: Thick Murloc Armor
	[5789]="2800:9:2:1:Leatherworking::1:1:2846,4897:0:0", -- Pattern: Murloc Scale Bracers
	[5790]="0:12:1:1:::1:0::4:0", -- Lonebrow's Journal
	[5791]="0:12:1:1:::1:0::0:0", -- Henrig Lonebrow's Journal
	[5792]="0:12:1:1:::1:0::4:0", -- Razorflank's Medallion
	[5793]="0:12:1:1:::1:0::4:0", -- Razorflank's Heart
	[5794]="0:12:1:20:::1:0::4:0", -- Salty Scorpid Venom
	[5795]="0:12:1:20:::1:0::4:0", -- Hardened Tortoise Shell
	[5796]="0:12:1:20:::1:0::4:0", -- Encrusted Tail Fin
	[5797]="0:12:1:20:::1:0::4:0", -- Indurium Flake
	[5799]="0:12:1:1:::1:0::4:0", -- Kravel's Parts Order
	[5800]="0:12:1:1:::1:0::4:0", -- Kravel's Parts
	[5801]="0:12:1:20:::1:0::4:0", -- Kraul Guano
	[5802]="0:12:1:1:::1:0::4:0", -- Delicate Car Parts
	[5803]="0:12:1:20:::1:0::4:0", -- Speck of Dream Dust
	[5804]="0:12:1:1:::1:0::4:0", -- Goblin Rumors
	[5805]="0:12:1:20:::1:0::4:0", -- Heart of Zeal
	[5806]="0:12:1:1:::1:0::4:0", -- Fool's Stout
	[5807]="0:12:1:1:::1:0::4:0", -- Fool's Stout Report
	[5808]="0:12:1:20:::1:0::4:0", -- Pridewing Venom Sac
	[5809]="0:12:1:20:::1:0::4:0", -- Highperch Venom Sac
	[5810]="0:12:1:1:::1:0::4:0", -- Fresh Carcass
	[5811]="0:12:1:1:::1:0::4:0", -- Frostmaw's Mane
	[5812]="0:4:2:1:Cloth::1:0::3:0", -- Robes of Antiquity
	[5813]="0:2:2:1:TwoHandSword::1:0::3:0", -- Emil's Brand
	[5814]="0:4:2:1:Leather::1:0::3:0", -- Snapbrook Armor
	[5815]="0:2:2:1:TwoHandMace::1:0::3:0", -- Glacial Stone
	[5816]="0:0:1:1:Potion::1:0::3:0", -- Light of Elune
	[5817]="0:2:2:1:Bow::1:0::3:0", -- Lunaris Bow
	[5818]="0:2:2:1:Wand::1:0::3:0", -- Moonbeam Wand
	[5819]="0:4:3:1:Mail::1:0::2:0", -- Sunblaze Coif
	[5820]="0:4:2:1:Cloth::1:0::3:0", -- Faerie Mantle
	[5824]="0:12:1:1:::1:0::4:0", -- Tablet of Will
	[5825]="0:12:1:1:::1:0::4:0", -- Treshala's Pendant
	[5826]="0:12:1:1:::1:0::4:0", -- Kravel's Scheme
	[5827]="0:12:1:1:::1:0::4:0", -- Fizzle Brassbolts' Letter
	[5829]="0:15:0:20:Junk::1:0::0:0", -- Razor-Sharp Beak
	[5830]="0:12:1:1:::1:0::4:0", -- Kenata's Head
	[5831]="0:12:1:1:::1:0::4:0", -- Fardel's Head
	[5832]="0:12:1:1:::1:0::4:0", -- Marcel's Head
	[5833]="0:12:1:20:::1:0::0:0", -- Indurium Ore
	[5834]="0:12:1:1:::1:0::4:0", -- Mok'Morokk's Snuff
	[5835]="0:12:1:1:::1:0::4:0", -- Mok'Morokk's Grog
	[5836]="0:12:1:1:::1:0::4:0", -- Mok'Morokk's Strongbox
	[5838]="0:12:1:1:::1:0::4:0", -- Kodo Skin Scroll
	[5839]="0:15:0:1:Junk::1:0::0:0", -- Journal Page
	[5840]="0:12:1:20:::1:0::4:0", -- Searing Tongue
	[5841]="0:12:1:20:::1:0::4:0", -- Searing Heart
	[5842]="0:12:1:1:::1:0::4:0", -- Unrefined Ore Sample
	[5843]="0:12:1:1:::1:0::4:0", -- Grenka's Claw
	[5844]="0:12:1:1:::1:0::4:0", -- Fragments of Rok'Alim
	[5846]="0:12:1:1:::1:0::4:0", -- Korran's Sealed Note
	[5847]="0:12:1:20:::1:0::4:0", -- Mirefin Head
	[5848]="0:12:1:20:::1:0::4:0", -- Hollow Vulture Bone
	[5849]="0:12:1:1:::1:0::4:0", -- Crate of Crash Helmets
	[5850]="0:12:1:1:::1:0::4:0", -- Belgrom's Sealed Note
	[5851]="0:13:1:1:::1:0::4:0", -- Cozzle's Key
	[5852]="0:12:1:1:::1:0::4:0", -- Fuel Regulator Blueprints
	[5853]="0:12:1:20:::1:0::4:0", -- Intact Silithid Carapace
	[5854]="0:12:1:20:::1:0::4:0", -- Silithid Talon
	[5855]="0:12:1:20:::1:0::4:0", -- Silithid Heart
	[5860]="0:12:1:1:::1:0::4:0", -- Legacy of the Aspects
	[5861]="0:12:1:1:::1:0::4:0", -- Beginnings of the Undead Threat
	[5862]="0:12:1:1:::1:0::4:0", -- Seaforium Booster
	[5863]="0:15:1:1:Junk::1:0::3:0", -- Guild Charter
	[5864]="10000:15:3:1:Mount::1:0:1261:3:0", -- Gray Ram
	[5865]="0:12:1:1:::1:0::4:0", -- Modified Seaforium Booster
	[5866]="0:12:1:1:::1:0::4:0", -- Sample of Indurium Ore
	[5867]="0:12:1:1:::1:0::4:0", -- Etched Phial
	[5868]="0:12:1:1:::1:0::4:0", -- Filled Etched Phial
	[5869]="0:12:1:1:::1:0::4:0", -- Cloven Hoof
	[5871]="0:15:0:20:Junk::1:0::0:0", -- Large Hoof
	[5872]="10000:15:3:1:Mount::1:0:1261:3:0", -- Brown Ram
	[5873]="10000:15:3:1:Mount::1:0:1261:3:0", -- White Ram
	[5876]="0:12:1:20:::1:0::4:0", -- Blueleaf Tuber
	[5877]="0:12:1:1:::1:0::3:0", -- Cracked Silithid Carapace
	[5879]="0:12:1:20:::1:0::4:0", -- Twilight Pendant
	[5880]="0:0:1:1:Consumable::1:0::4:0", -- Crate With Holes
	[5881]="0:12:1:1:::1:0::4:0", -- Head of Kelris
	[5882]="0:12:1:1:::1:0::4:0", -- Captain's Documents
	[5883]="0:12:1:20:::1:0::4:0", -- Forked Mudrock Tongue
	[5884]="0:12:1:20:::1:0::4:0", -- Unpopped Darkmist Eye
	[5897]="0:12:1:1:::1:0::4:0", -- Snufflenose Owner's Manual
	[5917]="0:12:1:1:::1:0::4:0", -- Spy's Report
	[5918]="0:12:1:1:::1:0::4:0", -- Defiant Orc Head
	[5919]="0:12:1:1:::1:0::4:0", -- Blackened Iron Shield
	[5936]="0:4:1:1:Leather::1:0::3:0", -- Animal Skin Belt
	[5938]="0:12:1:20:::1:0::4:0", -- Pristine Crawler Leg
	[5939]="0:4:1:1:Leather::1:0::3:0", -- Sewing Gloves
	[5940]="0:4:1:1:Shield::1:0::3:0", -- Bone Buckler
	[5941]="0:4:1:1:Mail::1:0::3:0", -- Brass Scale Pants
	[5942]="0:12:1:1:::1:0::4:0", -- Jeweled Pendant
	[5943]="0:4:3:1:Mail::1:0::3:0", -- Rift Bracers
	[5944]="0:4:2:1:Mail::1:0::3:0", -- Greaves of the People's Militia
	[5945]="0:12:1:1:::1:0::4:0", -- Deadmire's Tooth
	[5946]="0:12:1:1:::1:0::4:0", -- Sealed Note to Elling
	[5947]="0:12:1:1:::1:0::4:0", -- Defias Docket
	[5948]="0:12:1:1:::1:0::4:0", -- Letter to Jorgen
	[5950]="0:12:1:1:::1:0::4:0", -- Reethe's Badge
	[5951]="0:0:1:10:Consumable::1:0::3:0", -- Moist Towelette
	[5952]="0:12:1:20:::1:0::4:0", -- Corrupted Brain Stem
	[5956]="18:2:1:1:Miscellaneous:202:1:0:66,777,790,843,960,989,1148,1250,1286,1448,1456,1465,1690,1692,1694,2118,2225,2393,2685,2687,2688,2810,2821,2844,2847,2999,3081,3133,3168,3187,3343,3356,3367,3413,3477,3482,3495,3499,3556,3614,3779,3954,4194,4229,4257,4259,4561,4587,4597,4775,4888,4897,4941,5100,5135,5163,5175,5411,5512,5519,5817,6777,7947,8145,8161,8176,8363,8679,8934,9636,9676,11185,11189,12022,12028,12043,12245,12941,12958,14337,14624,14637,14737,15176,15179,15400,16224,16261,16262,16376,16583,16613,16657,16670,16713,16768,16782,16823,17222,17245,17421,17486,17490,17655,18009,18278,18426,18427,18484,18752,18775,19011,19012,19056,19244,19342,19372,19383,19450,19520,19530,19575,19661,19662,19879,20082,20463,20890,21112,22264,22476,23144,23908,24052,24843,24935,25010,25051,25082,26081,26599,26600,26898,26934,27019,27021,27026,27043,27045,27057,27062,27134,27267,27711,28344,28692,28716,28722,28796,28797,28831,28872,29252,29253,29288,29688,29907,29923,29964,29969,30241,30253,30311,30336,30345,30434,30436,30825,31024,31776,31781,32594,32979,33231,33594,33599,33631,33634,33669,33675,33677,36695,36779,37904,37935,38783,38853,40474,41053,41054,41274,41275,41435,41490,41493,41675,41676,41890,41891,42488,42676,42853,42876,42909,42972,43410,43548,43558,43564,43615,43625,43705,43708,43709,43710,43711,43772,43882,43980,43998,44005,44022,44034,44181,44186,44194,44195,44279,44280,44301,44305,44311,44337,44341,44377,44383,44780,45093,45148,45286,45293,45294,45451,45490,45497,45546,45549,45552,45843,46359,46702,47059,47104,47153,47164,47267,47286,47340,47347,47530,47532,47721,47863,47864,47937,47939,48056,48057,48058,48098,48123,48228,48235,48238,48251,48258,48356,48551,48573,48574,48868,49409,49433,49549,49575,49592,49605,49695,49702,49726,49756,49768,49788,49800,49885,49918,50129,50460,52637,52641,52655:0:0", -- Blacksmith Hammer
	[5957]="0:4:1:1:Leather::1:0::0:0", -- Handstitched Leather Vest
	[5958]="0:4:2:1:Leather::1:0::2:0", -- Fine Leather Pants
	[5959]="0:12:1:20:::1:0::4:0", -- Acidic Venom Sac
	[5960]="0:12:1:1:::1:0::4:0", -- Sealed Note to Watcher Backus
	[5961]="0:4:2:1:Leather::1:0::2:0", -- Dark Leather Pants
	[5962]="0:4:2:1:Leather::1:0::2:0", -- Guardian Pants
	[5963]="0:4:2:1:Leather::1:0::2:0", -- Barbaric Leggings
	[5964]="0:4:2:1:Leather::1:0::2:0", -- Barbaric Shoulders
	[5965]="0:4:2:1:Cloak::1:0::2:0", -- Guardian Cloak
	[5966]="0:4:2:1:Leather:164:1:0::2:0", -- Guardian Gloves
	[5967]="0:4:3:1:Cloth::1:0::3:0", -- Girdle of Nobility
	[5969]="0:4:2:1:Cloak::1:0::2:0", -- Regent's Cloak
	[5970]="0:4:3:1:Cloth::1:0::3:0", -- Serpent Gloves
	[5971]="0:4:2:1:Cloak::1:0::2:0", -- Feathered Cape
	[5972]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Fine Leather Pants
	[5973]="650:9:1:1:Leatherworking::1:1:2810,2821,3958:0:0", -- Pattern: Barbaric Leggings
	[5974]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Guardian Cloak
	[5975]="0:4:2:1:Leather::1:0::2:0", -- Ruffian Belt
	[5976]="10000:4:1:1:Tabard::1:0:5049,5188,5189,5190,5191,5193,16610,16766,28776,52278:0:0", -- Guild Tabard
	[5996]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Water Breathing
	[5997]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Minor Defense
	[5998]="0:12:1:1:::1:0::4:0", -- Stormpike's Request
	[6016]="0:12:1:1:::1:0::4:0", -- Wolf Heart Sample
	[6037]="0:7:2:20:MetalStone:164,333,202,755,197:1:0::0:0", -- Truesilver Bar
	[6038]="0:0:1:20:FoodDrink::1:0::0:0", -- Giant Clam Scorcho
	[6039]="5000:9:1:1:Cooking::1:0:2664:0:0", -- Recipe: Giant Clam Scorcho
	[6040]="0:4:2:1:Mail::1:0::2:0", -- Golden Scale Bracers
	[6041]="0:0:1:5:EnhPerm::1:0::0:0", -- Steel Weapon Chain
	[6042]="0:0:1:5:EnhPerm::1:0::0:0", -- Iron Shield Spike
	[6043]="0:0:1:5:EnhPerm::1:0::0:0", -- Iron Counterweight
	[6044]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Iron Shield Spike
	[6045]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Iron Counterweight
	[6046]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Steel Weapon Chain
	[6047]="4400:9:1:1:Blacksmithing::1:1:5411:0:0", -- Plans: Golden Scale Coif
	[6048]="0:0:1:20:Potion:333,197:1:0::0:0", -- Shadow Protection Potion
	[6049]="0:0:1:20:Potion::1:0::0:0", -- Fire Protection Potion
	[6050]="0:0:1:20:Potion::1:0::0:0", -- Frost Protection Potion
	[6051]="0:0:1:20:Potion::1:0::0:0", -- Holy Protection Potion
	[6052]="0:0:1:20:Potion::1:0::0:0", -- Nature Protection Potion
	[6053]="800:9:1:1:Alchemy::1:1:1685,3134,3490:0:0", -- Recipe: Holy Protection Potion
	[6054]="900:9:1:1:Alchemy::1:1:2393:0:0", -- Recipe: Shadow Protection Potion
	[6055]="1500:9:1:1:Alchemy::1:1:4083:0:0", -- Recipe: Fire Protection Potion
	[6056]="2000:9:1:1:Alchemy::1:1:2812,2848:0:0", -- Recipe: Frost Protection Potion
	[6057]="2000:9:1:1:Alchemy::1:1:2848,5594,8157,8158:0:0", -- Recipe: Nature Protection Potion
	[6058]="0:4:1:1:Leather::1:0::3:0", -- Blackened Leather Belt
	[6059]="0:4:1:1:Leather::1:0::3:0", -- Nomadic Vest
	[6060]="0:4:1:1:Cloth::1:0::3:0", -- Flax Bracers
	[6061]="0:4:1:1:Mail::1:0::3:0", -- Graystone Bracers
	[6062]="0:4:1:1:Cloth::1:0::3:0", -- Heavy Cord Bracers
	[6063]="0:4:1:1:Mail::1:0::3:0", -- Cold Steel Gauntlets
	[6064]="0:12:1:1:::1:0::4:0", -- Miniature Platinum Discs
	[6065]="0:12:1:1:::1:0::4:0", -- Khadgar's Essays on Dimensional Convergence
	[6067]="0:12:1:20:::1:0::4:0", -- Centaur Ear
	[6068]="0:9:1:1:Alchemy::1:0::0:0", -- Recipe: Shadow Oil
	[6069]="0:12:1:20:::1:0::4:0", -- Crudely Dried Meat
	[6070]="0:4:1:1:Leather::1:0::3:0", -- Wolfskin Bracers
	[6071]="0:12:1:20:::1:0::4:0", -- Draenethyst Crystal
	[6072]="0:12:1:1:::1:0::4:0", -- Khan Jehn's Head
	[6073]="0:12:1:1:::1:0::4:0", -- Khan Shaka's Head
	[6074]="0:0:1:1:Consumable::1:0::4:0", -- War Horn Mouthpiece
	[6076]="0:4:1:1:Cloth::1:0::3:0", -- Tapered Pants
	[6077]="0:12:1:1:::1:0::4:0", -- Maraudine Key Fragment
	[6078]="0:4:1:1:Shield::1:0::3:0", -- Pikeman Shield
	[6079]="0:12:1:20:::1:0::4:0", -- Crude Charm
	[6080]="0:12:1:20:::1:0::4:0", -- Shadow Panther Heart
	[6081]="0:12:1:1:::1:0::4:0", -- Mire Lord Fungus
	[6082]="0:12:1:1:::1:0::4:0", -- Green Whelp Blood
	[6083]="0:12:1:20:::1:0::4:0", -- Broken Tears
	[6084]="0:4:2:1:Mail::1:0::3:0", -- Stormwind Guard Leggings
	[6085]="0:4:2:1:Leather::1:0::3:0", -- Footman Tunic
	[6086]="0:12:1:1:::1:0::4:0", -- Faustin's Truth Serum
	[6087]="0:4:3:1:Mail::1:0::3:0", -- Chausses of Westfall
	[6089]="0:12:1:1:::1:0::4:0", -- Zraedus' Brew
	[6091]="0:12:1:1:::1:0::4:0", -- Crate of Power Stones
	[6092]="0:4:2:1:Leather::1:0::3:0", -- Black Whelp Boots
	[6093]="0:2:2:1:TwoHandMace::1:0::3:0", -- Orc Crusher
	[6094]="0:2:2:1:TwoHandAxe::1:0::3:0", -- Piercing Axe
	[6095]="0:4:2:1:Cloth::1:0::3:0", -- Wandering Boots
	[6096]="1:4:1:1:Shirt::1:0:18672:0:0", -- Apprentice's Shirt
	[6097]="1:4:1:1:Shirt::1:0:18672,24539:0:0", -- Acolyte's Shirt
	[6098]="7:4:1:1:Cloth::1:0:18672:0:0", -- Neophyte's Robe
	[6116]="0:4:1:1:Cloth::1:0::0:0", -- Apprentice's Robe
	[6117]="0:4:1:1:Shirt::1:0::0:0", -- Squire's Shirt
	[6118]="0:4:1:1:Cloth::1:0::0:0", -- Squire's Pants
	[6119]="0:4:1:1:Cloth::1:0::0:0", -- Neophyte's Robe
	[6120]="0:4:1:1:Shirt::1:0::0:0", -- Recruit's Shirt
	[6121]="0:4:1:1:Cloth::1:0::0:0", -- Recruit's Pants
	[6122]="0:4:1:1:Cloth::1:0::0:0", -- Recruit's Boots
	[6123]="0:4:1:1:Cloth::1:0::0:0", -- Novice's Robe
	[6124]="0:4:1:1:Cloth::1:0::0:0", -- Novice's Pants
	[6125]="0:4:1:1:Shirt::1:0::0:0", -- Brawler's Harness
	[6126]="0:4:1:1:Cloth::1:0::0:0", -- Trapper's Pants
	[6127]="0:4:1:1:Cloth::1:0::0:0", -- Trapper's Boots
	[6129]="0:4:1:1:Cloth::1:0::0:0", -- Acolyte's Robe
	[6134]="0:4:1:1:Shirt::1:0::0:0", -- Primitive Mantle
	[6135]="0:4:1:1:Leather::1:0::0:0", -- Primitive Kilt
	[6136]="0:4:1:1:Shirt::1:0::0:0", -- Trapper's Shirt
	[6137]="0:4:1:1:Cloth::1:0::0:0", -- Thug Pants
	[6138]="0:4:1:1:Cloth::1:0::0:0", -- Trapper's Boots
	[6139]="0:4:1:1:Cloth::1:0::0:0", -- Novice's Robe
	[6140]="0:4:1:1:Cloth::1:0::0:0", -- Apprentice's Robe
	[6144]="0:4:1:1:Cloth::1:0::0:0", -- Neophyte's Robe
	[6145]="0:12:1:1:::1:0::4:0", -- Clarice's Pendant
	[6146]="0:12:1:20:::1:0::4:0", -- Sundried Driftwood
	[6147]="0:4:1:1:Leather::1:0::0:0", -- Ratty Old Belt
	[6148]="0:4:1:1:Cloth::1:0::0:0", -- Web-Covered Boots
	[6149]="1200:0:1:20:Potion:755:1:1:983,8157,8158,8177,8178,11188,18810,18905,18906,18908:0:0", -- Greater Mana Potion
	[6150]="0:15:0:20:Junk::1:0::0:0", -- A Frayed Knot
	[6166]="0:12:1:20:::1:0::4:0", -- Coyote Jawbone
	[6167]="0:12:1:1:::1:0::4:0", -- Neeka's Report
	[6168]="0:12:1:20:::1:0::4:0", -- Sawtooth Snapper Claw
	[6169]="0:12:1:20:::1:0::4:0", -- Unprepared Sawtooth Flank
	[6170]="0:12:1:1:::1:0::4:0", -- Wizards' Reagents
	[6171]="0:4:1:1:Leather::1:0::3:0", -- Wolf Handler Gloves
	[6172]="0:12:1:1:::1:0::3:0", -- Lost Supplies
	[6173]="0:4:1:1:Cloth::1:0::3:0", -- Snow Boots
	[6176]="0:4:1:1:Shield::1:0::3:0", -- Dwarven Kite Shield
	[6177]="0:4:1:1:Mail::1:0::3:0", -- Ironwrought Bracers
	[6178]="0:12:1:1:::1:0::4:0", -- Shipment to Nethergarde
	[6179]="0:4:2:1:Cloak::1:0::2:0", -- Privateer's Cape
	[6180]="0:4:2:1:Mail::1:0::2:0", -- Slarkskin
	[6181]="0:12:1:20:::1:0::4:0", -- Fetish of Hakkar
	[6182]="0:4:1:1:OffHandFrill::1:0::0:0", -- Dim Torch
	[6184]="0:12:1:20:::1:0::4:0", -- Monstrous Crawler Leg
	[6185]="0:4:1:1:Cloak::1:0::3:0", -- Bear Shawl
	[6186]="0:2:2:1:TwoHandSword::1:0::3:0", -- Trogg Slicer
	[6187]="0:4:2:1:Shield::1:0::3:0", -- Dwarven Defender
	[6188]="0:4:2:1:Mail::1:0::3:0", -- Mud Stompers
	[6189]="0:4:1:1:Mail::1:0::3:0", -- Durable Chain Shoulders
	[6190]="0:12:1:1:::1:0::4:0", -- Draenethyst Shard
	[6191]="0:4:2:1:Cloth::1:0::3:0", -- Kimbra Boots
	[6194]="0:2:2:1:OneHandAxe::1:0::3:0", -- Barreling Reaper
	[6195]="0:4:2:1:Mail::1:0::2:0", -- Wax-Polished Armor
	[6196]="0:2:0:1:OneHandMace::1:0::3:0", -- Noboru's Cudgel
	[6197]="0:4:2:1:Leather::1:0::2:0", -- Loch Croc Hide Vest
	[6198]="0:4:2:1:Leather::1:0::2:0", -- Jurassic Wristguards
	[6199]="0:4:2:1:Ring::1:0::2:0", -- Black Widow Band
	[6200]="0:4:2:1:Mail::1:0::2:0", -- Garneg's War Belt
	[6201]="0:4:1:1:Leather::1:0::0:0", -- Lithe Boots
	[6202]="0:4:1:1:Cloth::1:0::0:0", -- Fingerless Gloves
	[6203]="0:4:1:1:Shield::1:0::0:0", -- Thuggish Shield
	[6204]="0:4:2:1:Leather::1:0::2:0", -- Tribal Worg Helm
	[6205]="0:2:2:1:TwoHandMace::1:0::2:0", -- Burrowing Shovel
	[6206]="0:2:1:1:TwoHandAxe::1:0::0:0", -- Rock Chipper
	[6211]="0:9:1:1:Alchemy::1:0::0:0", -- Recipe: Elixir of Ogre's Strength
	[6212]="0:12:1:1:::1:0::4:0", -- Head of Jammal'an
	[6214]="0:2:2:1:TwoHandMace::1:0::2:0", -- Heavy Copper Maul
	[6215]="0:2:2:1:Stave::1:0::3:0", -- Balanced Fighting Stick
	[6217]="124:7:1:1:Enchanting:333:1:0:66,777,843,960,989,1148,1250,1286,1318,1456,1465,1692,2118,2225,2393,2810,2821,3012,3081,3168,3187,3346,3367,3482,3499,3556,3614,3779,3954,4194,4228,4229,4561,4617,4775,4897,5100,5135,5158,5163,5757,5758,5817,7947,8145,8363,8934,9636,11189,12022,12028,12043,12245,12941,12958,15179,15419,16224,16261,16262,16613,16635,16722,16768,17486,17490,18009,18426,18427,18753,18773,18951,19234,19244,19372,19450,19537,19540,19663,24843,24935,25010,25051,25082,26569,27021,27026,27030,27039,27043,27054,27057,27147,28692,28714,28715,28831,28872,29288,29537,30311,32979,33597,33633,33676,36365,36695,36779,38783,38853,40474,41053,41275,41490,41676,41891,42853,43558,43980,44030,44034,44186,44301,44321,44341,44381,44383,44780,45093,45286,45490,45497,45552,47104,47153,47164,47347,47721,47863,47939,48058,48098,48123,48235,48551,48574,48868,49885,50458,50459,53410:0:0", -- Copper Rod
	[6218]="0:7:1:1:Enchanting:333:1:0::3:0", -- Runed Copper Rod
	[6219]="0:2:1:1:Miscellaneous::1:0::0:0", -- Arclight Spanner
	[6220]="0:2:3:1:Dagger::1:0::3:0", -- Meteor Shard
	[6223]="0:4:2:1:Shield::1:0::3:0", -- Crest of Darkshire
	[6226]="0:4:3:1:Cloth::1:0::3:0", -- Bloody Apron
	[6238]="0:4:2:1:Cloth::1:0::2:0", -- Brown Linen Robe
	[6239]="0:4:2:1:Cloth::1:0::2:0", -- Red Linen Vest
	[6240]="0:4:2:1:Cloth::1:0::2:0", -- Blue Linen Vest
	[6241]="0:4:2:1:Cloth::1:0::2:0", -- White Linen Robe
	[6242]="0:4:2:1:Cloth::1:0::2:0", -- Blue Linen Robe
	[6243]="0:4:2:1:Cloth::1:0::2:0", -- Green Woolen Robe
	[6245]="0:12:1:1:::1:0::4:0", -- Karnitol's Satchel
	[6246]="0:12:1:20:::1:0::4:0", -- Hatefury Claw
	[6247]="0:12:1:20:::1:0::4:0", -- Hatefury Horn
	[6248]="0:12:1:20:::1:0::4:0", -- Scorpashi Venom
	[6249]="0:12:1:20:::1:0::4:0", -- Aged Kodo Hide
	[6250]="0:12:1:20:::1:0::4:0", -- Felhound Brain
	[6251]="0:12:1:20:::1:0::4:0", -- Nether Wing
	[6252]="0:12:1:20:::1:0::4:0", -- Doomwarder Blood
	[6253]="0:12:1:1:::1:0::4:0", -- Leftwitch's Package
	[6256]="23:2:1:1:FishingPole::1:0:66,777,843,989,1148,1250,1286,1465,1678,1684,1692,2118,2225,2626,2810,2821,3029,3081,3168,3178,3187,3333,3367,3482,3497,3499,3550,3556,3572,3614,3779,3954,4194,4222,4229,4561,4574,4775,4897,5135,5162,5163,5494,5817,5940,5942,7945,7947,8145,8363,8508,8934,10118,11189,12022,12028,12031,12043,12245,12941,12958,12962,14740,15179,16224,16261,16262,16613,16708,16768,17101,17486,17490,18009,18018,18347,18426,18427,18911,19244,19372,19450,19472,23896,24843,24935,25010,25051,25082,27021,27026,27043,27057,27144,27181,27190,28692,28707,28742,28812,28831,28872,29288,30311,31804,31805,32979,36695,36779,38783,38853,40474,41053,41275,41490,41676,41891,42853,43558,43776,43980,44034,44186,44192,44336,44341,44383,44780,44975,45093,45286,45490,45497,45552,47153,47164,47343,47347,48551,48552,48574,48853,48868,49885,56069:0:0", -- Fishing Pole
	[6257]="0:12:1:20:::1:0::4:0", -- Roc Gizzard
	[6258]="0:12:1:20:::1:0::4:0", -- Ironfur Liver
	[6259]="0:12:1:20:::1:0::4:0", -- Groddoc Liver
	[6260]="50:7:1:10:Other:197:1:0:66,843,1250,1347,1454,1465,1474,1672,1692,2118,2225,2394,2668,2669,2670,2672,2697,2698,2699,2816,2819,2846,3005,3008,3081,3091,3168,3187,3364,3366,3482,3485,3614,3958,4168,4194,4225,4577,4589,5128,5135,5154,5565,5817,6567,6568,6574,7854,7940,8160,8363,8681,8934,11557,11874,12942,12943,12956,16224,16261,16262,16366,16638,16689,16748,16767,17490,18277,18426,18427,18749,18754,18771,18772,19196,19213,19521,19532,19722,21085,28718,28726,28798,28810,32979,33596,33601,33635,33636,33681,33684,34601,36695,36779,38783,38853,38873,40226,40572,42853,43380,43495,43550,43554,43558,43568,43880,44027,44034,44386,45286,45490,45497,45552,45558,46184,47856,48098,48587,48608,48857,48860,49404,49705,49714,49885,49888,50071,50094,50456,50457,53075,53436,53782:0:0", -- Blue Dye
	[6261]="1000:7:1:10:Other:197:1:0:1347,1454,1474,1672,2394,2668,2669,2670,2672,2697,2698,2699,2816,2819,2846,3005,3008,3091,3364,3366,3485,3958,4168,4225,4577,4589,5128,5154,5565,6567,6568,6574,7854,7940,8160,8681,11557,11874,12942,12943,12956,16366,16638,16689,16748,16767,18277,18749,18754,18771,18772,19196,19213,19521,19532,19722,21085,28718,28726,28798,28810,33596,33601,33635,33636,33681,33684,34601,38873,40226,40572,43380,43495,43550,43554,43568,43880,44027,44386,45558,46184,47856,48098,48587,48608,48857,48860,49404,49705,49714,49888,50071,50094,50456,50457,53075,53436,53782:0:0", -- Orange Dye
	[6263]="0:4:2:1:Cloth::1:0::2:0", -- Blue Overalls
	[6264]="0:4:2:1:Cloth::1:0::2:0", -- Greater Adept's Robe
	[6265]="0:15:1:1:Reagent:-9:1:0::3:0", -- Soul Shard
	[6266]="0:4:2:1:Cloth::1:0::2:0", -- Disciple's Vest
	[6267]="0:4:2:1:Cloth::1:0::2:0", -- Disciple's Pants
	[6268]="0:4:2:1:Leather::1:0::2:0", -- Pioneer Tunic
	[6269]="0:4:2:1:Leather::1:0::2:0", -- Pioneer Trousers
	[6270]="200:9:1:1:Tailoring::1:1:66,3364,3485,3522,45558:0:0", -- Pattern: Blue Linen Vest
	[6271]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Red Linen Vest
	[6272]="300:9:1:1:Tailoring::1:1:1250,3485,3499,3556,4168:0:0", -- Pattern: Blue Linen Robe
	[6274]="400:9:1:1:Tailoring::1:1:843,1347,2394,3364,45558:0:0", -- Pattern: Blue Overalls
	[6275]="800:9:1:1:Tailoring::1:1:1454,1474,2669,3499,4168,4577:0:0", -- Pattern: Greater Adept's Robe
	[6281]="0:12:1:20:::1:0::4:0", -- Rattlecage Skull
	[6282]="0:4:2:1:Cloth::1:0::3:0", -- Sacred Burial Trousers
	[6283]="0:12:1:1:::1:0::4:0", -- The Book of Ur
	[6284]="0:12:1:1:::1:0::4:0", -- Runes of Summoning
	[6285]="0:12:1:1:::1:0::4:0", -- Egalin's Grimoire
	[6286]="0:12:1:1:::1:0::4:0", -- Pure Hearts
	[6289]="0:7:1:20:Meat:185:1:0::0:0", -- Raw Longjaw Mud Snapper
	[6290]="0:0:1:20:FoodDrink::1:0::0:0", -- Brilliant Smallfish
	[6291]="0:7:1:20:Meat:185:1:0::0:0", -- Raw Brilliant Smallfish
	[6292]="0:4:1:1:OffHandFrill::1:0::0:0", -- 10 Pound Mud Snapper
	[6293]="0:15:0:20:Junk::1:0::0:0", -- Dried Bat Blood
	[6294]="0:4:1:1:OffHandFrill::1:0::0:0", -- 12 Pound Mud Snapper
	[6295]="0:4:1:1:OffHandFrill::1:0::0:0", -- 15 Pound Mud Snapper
	[6296]="0:15:0:20:Junk::1:0::0:0", -- Patch of Bat Hair
	[6297]="0:15:0:20:Junk::1:0::0:0", -- Old Skull
	[6298]="0:15:0:20:Junk::1:0::0:0", -- Bloody Bat Fang
	[6299]="0:0:1:20:FoodDrink::1:0::0:0", -- Sickly Looking Fish
	[6300]="0:15:0:20:Junk::1:0::0:0", -- Husk Fragment
	[6301]="0:15:0:1:Junk::1:0::0:0", -- Old Teamster's Skull
	[6302]="0:15:0:20:Junk::1:0::0:0", -- Delicate Insect Wing
	[6303]="0:7:1:20:Meat:185:1:0::0:0", -- Raw Slitherskin Mackerel
	[6304]="0:15:0:20:Junk::1:0::0:0", -- Damp Diary Page (Day 4)
	[6305]="0:15:0:20:Junk::1:0::0:0", -- Damp Diary Page (Day 87)
	[6306]="0:15:0:20:Junk::1:0::0:0", -- Damp Diary Page (Day 512)
	[6307]="0:15:1:1:Junk::1:0::0:0", -- Message in a Bottle
	[6308]="0:7:1:20:Meat:185:1:0::0:0", -- Raw Bristle Whisker Catfish
	[6309]="0:4:1:1:OffHandFrill::1:0::0:0", -- 17 Pound Catfish
	[6310]="0:4:1:1:OffHandFrill::1:0::0:0", -- 19 Pound Catfish
	[6311]="0:4:1:1:OffHandFrill::1:0::0:0", -- 22 Pound Catfish
	[6312]="0:12:1:1:::1:0::4:0", -- Dalin's Heart
	[6313]="0:12:1:1:::1:0::4:0", -- Comar's Heart
	[6314]="0:4:3:1:Cloak::1:0::3:0", -- Wolfmaster Cape
	[6315]="0:2:2:1:Crossbow::1:0::2:0", -- Steelarrow Crossbow
	[6316]="0:0:1:20:FoodDrink::1:0::0:0", -- Loch Frenzy Delight
	[6317]="0:7:1:20:Meat:185:1:0::0:0", -- Raw Loch Frenzy
	[6318]="0:2:3:1:Stave::1:0::3:0", -- Odo's Ley Staff
	[6319]="0:4:3:1:Leather::1:0::3:0", -- Girdle of the Blindwatcher
	[6320]="0:4:3:1:Shield::1:0::3:0", -- Commander's Crest
	[6321]="0:4:3:1:Ring::1:0::3:0", -- Silverlaine's Family Seal
	[6323]="0:2:3:1:OneHandMace::1:0::3:0", -- Baron's Scepter
	[6324]="0:4:3:1:Cloth::1:0::3:0", -- Robes of Arugal
	[6325]="40:9:1:1:Cooking::1:0:66,1684,3029,3550,4265,4574,5494,5940,8508,56069:0:0", -- Recipe: Brilliant Smallfish
	[6326]="40:9:1:1:Cooking::1:0:3550,4305,5162,5942,10118:0:0", -- Recipe: Slitherskin Mackerel
	[6327]="0:2:3:1:TwoHandMace::1:0::2:0", -- The Pacifier
	[6328]="400:9:1:1:Cooking::1:0:66,1684,3027,4265,4574,5162,5748,5940:0:0", -- Recipe: Longjaw Mud Snapper
	[6329]="400:9:1:1:Cooking::1:0:1684:0:0", -- Recipe: Loch Frenzy Delight
	[6330]="1200:9:1:1:Cooking::1:0:2397,3027,3029,3497,4553,5494,56069:0:0", -- Recipe: Bristle Whisker Catfish
	[6331]="0:2:3:1:Dagger::1:0::2:0", -- Howling Blade
	[6332]="0:4:3:1:Ring::1:0::2:0", -- Black Pearl Ring
	[6333]="0:2:2:1:Dagger::1:0::2:0", -- Spikelash Dagger
	[6335]="0:4:2:1:Leather::1:0::3:0", -- Grizzled Boots
	[6336]="0:4:2:1:Mail::1:0::2:0", -- Infantry Tunic
	[6337]="0:4:2:1:Mail::1:0::2:0", -- Infantry Leggings
	[6338]="0:7:1:1:Enchanting:333:1:0::0:0", -- Silver Rod
	[6339]="0:7:2:1:Enchanting:333:1:0::3:0", -- Runed Silver Rod
	[6340]="0:4:3:1:Cloak::1:0::3:0", -- Fenrus' Hide
	[6341]="0:4:3:1:OffHandFrill::1:0::3:0", -- Eerie Stable Lantern
	[6342]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Chest - Minor Mana
	[6344]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Bracer - Minor Spirit
	[6346]="400:9:2:1:Enchanting::1:1:3346,5757:0:0", -- Formula: Enchant Chest - Lesser Mana
	[6347]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Bracer - Minor Strength
	[6348]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Weapon - Minor Beastslayer
	[6349]="500:9:1:1:Enchanting::1:1:3012,3346,5158,5758:0:0", -- Formula: Enchant 2H Weapon - Lesser Intellect
	[6350]="0:4:2:1:Mail::1:0::2:0", -- Rough Bronze Boots
	[6351]="0:15:1:1:Other::1:0::0:0", -- Dented Crate
	[6352]="0:15:1:1:Other::1:0::0:0", -- Waterlogged Crate
	[6353]="0:15:1:1:Junk::1:0::0:0", -- Small Chest
	[6354]="0:15:1:1:Junk::1:0::0:0", -- Small Locked Chest
	[6355]="0:15:1:1:Junk::1:0::0:0", -- Sturdy Locked Chest
	[6356]="0:15:1:1:Junk::1:0::0:0", -- Battered Chest
	[6357]="0:15:1:1:Other::1:0::0:0", -- Sealed Crate
	[6358]="0:7:1:20:Other:171:1:0::0:0", -- Oily Blackmouth
	[6359]="0:7:1:20:Other:171:1:0::0:0", -- Firefin Snapper
	[6360]="0:2:2:1:OneHandMace::1:0::2:0", -- Steelscale Crushfish
	[6361]="0:7:1:20:Meat:185:1:0::0:0", -- Raw Rainbow Fin Albacore
	[6362]="0:7:1:20:Meat:185:1:0::0:0", -- Raw Rockscale Cod
	[6363]="0:4:1:1:OffHandFrill::1:0::0:0", -- 26 Pound Catfish
	[6364]="0:4:1:1:OffHandFrill::1:0::0:0", -- 32 Pound Catfish
	[6365]="902:2:1:1:FishingPole::1:1:1678,1684,2626,3029,3178,3333,3497,3550,3572,4222,4574,5162,5494,5940,5942,7945,8508,10118,12031,12962,14740,16708,17101,18018,18347,18911,19472,23896,27144,27181,27190,28707,28742,28812,31804,31805,43776,44192,44336,44975,47343,48853,56069:0:0", -- Strong Fishing Pole
	[6366]="0:2:1:1:FishingPole::1:0::0:0", -- Darkwood Fishing Pole
	[6367]="0:2:1:1:FishingPole::1:0::0:0", -- Big Iron Fishing Pole
	[6368]="400:9:1:1:Cooking::1:0:3178,3333,3497,4305,4553,5494,5748,5942,10118:0:0", -- Recipe: Rainbow Fin Albacore
	[6369]="2200:9:1:1:Cooking::1:0:2664,3178,3333,4574,5162,12033,12962:0:0", -- Recipe: Rockscale Cod
	[6370]="0:7:1:20:Other:171,333:1:0::0:0", -- Blackmouth Oil
	[6371]="0:7:1:20:Other:171,333,197:1:0::0:0", -- Fire Oil
	[6372]="0:0:1:20:Potion::1:0::0:0", -- Swim Speed Potion
	[6373]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Firepower
	[6374]="0:7:1:20:Enchanting::1:0::0:0", -- Enchanted Powder
	[6375]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Bracer - Lesser Spirit
	[6377]="1000:9:2:1:Enchanting::1:1:3012,3537:0:0", -- Formula: Enchant Boots - Minor Agility
	[6378]="0:4:2:1:Cloak::1:0::2:0", -- Seer's Cape
	[6379]="0:4:2:1:Leather::1:0::2:0", -- Inscribed Leather Belt
	[6380]="0:4:2:1:Shield::1:0::2:0", -- Inscribed Buckler
	[6381]="0:4:2:1:Cloak::1:0::2:0", -- Bright Cloak
	[6382]="0:4:2:1:Leather::1:0::2:0", -- Forest Leather Belt
	[6383]="0:4:2:1:Shield::1:0::2:0", -- Forest Buckler
	[6384]="0:4:1:1:Shirt::1:0::0:0", -- Stylish Blue Shirt
	[6385]="0:4:1:1:Shirt::1:0::0:0", -- Stylish Green Shirt
	[6386]="0:4:2:1:Mail::1:0::2:0", -- Glimmering Mail Legguards
	[6387]="0:4:2:1:Mail::1:0::2:0", -- Glimmering Mail Bracers
	[6388]="0:4:2:1:Mail::1:0::2:0", -- Glimmering Mail Pauldrons
	[6389]="0:4:2:1:Mail::1:0::2:0", -- Glimmering Mail Coif
	[6390]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Stylish Blue Shirt
	[6391]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Stylish Green Shirt
	[6392]="0:4:3:1:Cloth::1:0::3:0", -- Belt of Arugal
	[6393]="0:4:2:1:Cloth::1:0::2:0", -- Silver-Thread Gloves
	[6394]="0:4:2:1:Cloth::1:0::2:0", -- Silver-Thread Boots
	[6395]="0:4:2:1:Cloth::1:0::2:0", -- Silver-Thread Amice
	[6396]="0:4:2:1:Leather::1:0::2:0", -- Emblazoned Chestpiece
	[6397]="0:4:2:1:Leather::1:0::2:0", -- Emblazoned Gloves
	[6398]="0:4:2:1:Leather::1:0::2:0", -- Emblazoned Belt
	[6399]="0:4:2:1:Leather::1:0::2:0", -- Emblazoned Shoulders
	[6400]="0:4:2:1:Shield::1:0::2:0", -- Glimmering Shield
	[6401]="1100:9:1:1:Tailoring::1:1:2394,2669:0:0", -- Pattern: Dark Silk Shirt
	[6402]="0:4:2:1:Mail::1:0::2:0", -- Mail Combat Leggings
	[6403]="0:4:2:1:Mail::1:0::2:0", -- Mail Combat Armguards
	[6404]="0:4:2:1:Mail::1:0::2:0", -- Mail Combat Spaulders
	[6405]="0:4:2:1:Cloth::1:0::2:0", -- Nightsky Trousers
	[6406]="0:4:2:1:Cloth::1:0::2:0", -- Nightsky Boots
	[6407]="0:4:2:1:Cloth::1:0::2:0", -- Nightsky Wristbands
	[6408]="0:4:2:1:Leather::1:0::2:0", -- Insignia Gloves
	[6409]="0:4:2:1:Leather::1:0::2:0", -- Insignia Belt
	[6410]="0:4:2:1:Leather::1:0::2:0", -- Insignia Bracers
	[6411]="0:4:2:1:Mail::1:0::2:0", -- Chief Brigadier Armor
	[6412]="0:4:2:1:Mail::1:0::2:0", -- Chief Brigadier Boots
	[6413]="0:4:2:1:Mail::1:0::2:0", -- Chief Brigadier Bracers
	[6414]="0:4:3:1:Ring::1:0::3:0", -- Seal of Sylvanas
	[6415]="0:4:2:1:Cloth::1:0::2:0", -- Aurora Robe
	[6416]="0:4:2:1:Cloth::1:0::2:0", -- Aurora Boots
	[6417]="0:4:2:1:Cloak::1:0::2:0", -- Aurora Cloak
	[6418]="0:4:2:1:Cloth::1:0::2:0", -- Aurora Sash
	[6419]="0:4:2:1:Leather::1:0::2:0", -- Glyphed Mitts
	[6420]="0:4:2:1:Leather::1:0::2:0", -- Glyphed Boots
	[6421]="0:4:2:1:Leather::1:0::2:0", -- Glyphed Belt
	[6422]="0:4:2:1:Leather::1:0::2:0", -- Glyphed Helm
	[6423]="0:4:2:1:Mail::1:0::2:0", -- Blackforge Greaves
	[6424]="0:4:2:1:Cloak::1:0::2:0", -- Blackforge Cape
	[6425]="0:4:2:1:Mail::1:0::2:0", -- Blackforge Girdle
	[6426]="0:4:2:1:Mail::1:0::2:0", -- Blackforge Bracers
	[6427]="0:4:2:1:Cloth::1:0::2:0", -- Mistscape Robe
	[6428]="0:4:2:1:Cloth::1:0::2:0", -- Mistscape Gloves
	[6429]="0:4:2:1:Cloth::1:0::2:0", -- Mistscape Wizard Hat
	[6430]="0:4:2:1:Leather::1:0::2:0", -- Imperial Leather Breastplate
	[6431]="0:4:2:1:Leather::1:0::2:0", -- Imperial Leather Boots
	[6432]="0:4:2:1:Cloak::1:0::2:0", -- Imperial Cloak
	[6433]="0:4:2:1:Leather::1:0::2:0", -- Imperial Leather Helm
	[6435]="0:12:1:20:::1:0::4:0", -- Infused Burning Gem
	[6436]="0:12:1:1:::1:0::3:0", -- Burning Gem
	[6438]="0:15:0:20:Junk::1:0::0:0", -- Dull Elemental Bracer
	[6439]="0:15:0:20:Junk::1:0::0:0", -- Broken Binding Bracer
	[6440]="0:4:3:1:Ring::1:0::2:0", -- Brainlash
	[6441]="0:12:1:1:::1:0::4:0", -- Shadowstalker Scalp
	[6442]="0:12:1:1:::1:0::4:0", -- Oracle Crystal
	[6443]="0:12:1:10:::1:0::4:0", -- Deviate Hide
	[6444]="0:15:0:20:Junk::1:0::0:0", -- Forked Tongue
	[6445]="0:15:0:20:Junk::1:0::0:0", -- Brittle Molting
	[6446]="0:1:3:1:Bag::1:0::3:0", -- Snakeskin Bag
	[6447]="0:4:3:1:Shield::1:0::3:0", -- Worn Turtle Shell Shield
	[6448]="0:2:3:1:Dagger::1:0::3:0", -- Tail Spike
	[6449]="0:4:3:1:Cloak::1:0::3:0", -- Glowing Lizardscale Cloak
	[6450]="0:0:1:20:Bandage::1:0::0:0", -- Silk Bandage
	[6451]="0:0:1:20:Bandage::1:0::0:0", -- Heavy Silk Bandage
	[6452]="0:0:1:20:Other::1:0::0:0", -- Anti-Venom
	[6453]="0:0:1:20:Other::1:0::0:0", -- Strong Anti-Venom
	[6454]="0:9:2:1:FirstAid::1:0::0:0", -- Manual: Strong Anti-Venom
	[6455]="0:15:0:20:Junk::1:0::0:0", -- Old Wagonwheel
	[6456]="0:15:0:20:Junk::1:0::0:0", -- Acidic Slime
	[6457]="0:15:0:20:Junk::1:0::0:0", -- Rusted Engineering Parts
	[6458]="0:0:1:20:Other::1:0::0:0", -- Oil Covered Fish
	[6459]="0:4:3:1:Mail::1:0::3:0", -- Savage Trodders
	[6460]="0:4:3:1:Mail::1:0::3:0", -- Cobrahn's Grasp
	[6461]="0:4:3:1:Cloth::1:0::3:0", -- Slime-Encrusted Pads
	[6462]="0:12:1:1:::1:0::4:0", -- Secure Crate
	[6463]="0:4:3:1:Ring::1:0::3:0", -- Deep Fathom Ring
	[6464]="0:0:1:20:Consumable::1:0::4:0", -- Wailing Essence
	[6465]="0:4:3:1:Cloth::1:0::3:0", -- Robe of the Moccasin
	[6466]="0:4:2:1:Cloak::1:0::2:0", -- Deviate Scale Cloak
	[6467]="0:4:2:1:Leather::1:0::2:0", -- Deviate Scale Gloves
	[6468]="0:4:3:1:Leather::1:0::2:0", -- Deviate Scale Belt
	[6469]="0:2:3:1:Bow::1:0::3:0", -- Venomstrike
	[6470]="0:7:1:20:Leather:165:1:0::0:0", -- Deviate Scale
	[6471]="0:7:1:20:Leather:165:1:0::0:0", -- Perfect Deviate Scale
	[6472]="0:2:3:1:OneHandMace::1:0::3:0", -- Stinging Viper
	[6473]="0:4:3:1:Leather::1:0::3:0", -- Armor of the Fang
	[6476]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Deviate Scale Belt
	[6477]="0:4:2:1:Cloth::1:0::3:0", -- Grassland Sash
	[6479]="0:12:1:1:::1:0::4:0", -- Malem Pendant
	[6480]="0:4:2:1:Leather::1:0::3:0", -- Slick Deviate Leggings
	[6481]="0:4:2:1:Mail::1:0::3:0", -- Dagmire Gauntlets
	[6482]="0:4:2:1:Cloth::1:0::3:0", -- Firewalker Boots
	[6486]="0:0:1:20:Consumable::1:0::4:0", -- Singed Scale
	[6487]="0:12:1:20:::1:0::4:0", -- Vile Familiar Head
	[6488]="0:12:1:1:::1:0::4:0", -- Simple Tablet
	[6490]="0:12:1:1:::1:0::0:0", -- Dark Parchment
	[6502]="0:4:2:1:Mail::1:0::3:0", -- Violet Scale Armor
	[6503]="0:4:2:1:Cloth::1:0::3:0", -- Harlequin Robes
	[6504]="0:2:3:1:OneHandSword::1:0::3:0", -- Wingblade
	[6505]="0:2:3:1:Stave::1:0::3:0", -- Crescent Staff
	[6506]="0:4:1:1:Mail::1:0::0:0", -- Infantry Boots
	[6507]="0:4:1:1:Mail::1:0::0:0", -- Infantry Bracers
	[6508]="0:4:1:1:Cloak::1:0::0:0", -- Infantry Cloak
	[6509]="0:4:1:1:Mail::1:0::0:0", -- Infantry Belt
	[6510]="0:4:1:1:Mail::1:0::0:0", -- Infantry Gauntlets
	[6511]="0:4:2:1:Cloth::1:0::2:0", -- Journeyman's Robe
	[6512]="0:4:2:1:Cloth::1:0::2:0", -- Disciple's Robe
	[6513]="0:4:1:1:Cloth::1:0::0:0", -- Disciple's Sash
	[6514]="0:4:1:1:Cloak::1:0::0:0", -- Disciple's Cloak
	[6515]="0:4:1:1:Cloth::1:0::0:0", -- Disciple's Gloves
	[6517]="0:4:1:1:Leather::1:0::0:0", -- Pioneer Belt
	[6518]="0:4:1:1:Leather::1:0::0:0", -- Pioneer Boots
	[6519]="0:4:1:1:Leather::1:0::0:0", -- Pioneer Bracers
	[6520]="0:4:1:1:Cloak::1:0::0:0", -- Pioneer Cloak
	[6521]="0:4:1:1:Leather::1:0::0:0", -- Pioneer Gloves
	[6522]="0:0:1:20:FoodDrink:171,185:1:0::0:0", -- Deviate Fish
	[6523]="1422:4:1:1:Leather::1:0:3023,3359:0:0", -- Buckled Harness
	[6524]="2871:4:1:1:Leather::1:0:3023,3359:0:0", -- Studded Leather Harness
	[6525]="5168:4:1:1:Leather::1:0:3023,3359:0:0", -- Grunt's Harness
	[6526]="12487:4:1:1:Leather::1:0:3023,3359:0:0", -- Battle Harness
	[6527]="0:4:2:1:Cloth::1:0::2:0", -- Ancestral Robe
	[6528]="0:4:2:1:Cloth::1:0::2:0", -- Spellbinder Robe
	[6529]="50:0:1:20:EnhTemp::1:0:66,777,843,1250,1465,1678,1684,1692,2118,2225,2626,3029,3081,3168,3178,3187,3333,3482,3497,3499,3550,3556,3572,3614,4194,4222,4574,5135,5162,5494,5817,5940,5942,7945,8363,8508,8934,10118,12028,12031,12043,12962,14740,16224,16261,16262,16708,17101,17490,18018,18347,18426,18427,18911,19472,23896,27144,27181,27190,28707,28742,28812,31804,31805,32979,36695,36779,38783,38853,42853,43558,43776,44034,44192,44336,44975,45286,45490,45497,45552,47343,48552,48853,49885,56069:0:0", -- Shiny Bauble
	[6530]="100:0:1:20:EnhTemp:202:1:0:777,843,960,989,1148,1286,1456,1465,1678,1684,2225,2393,2626,2810,2821,3029,3178,3333,3367,3482,3497,3499,3550,3556,3572,3779,3954,4194,4222,4229,4561,4574,4775,4897,5100,5135,5162,5163,5494,5817,5940,5942,7945,7947,8145,8363,8508,8934,9636,10118,11189,12022,12028,12031,12043,12245,12941,12958,12962,14740,15179,16224,16613,16708,16768,17101,17486,17490,18009,18018,18347,18426,18427,18911,19244,19372,19450,19472,23896,24843,24935,25010,25051,25082,27021,27026,27043,27057,27144,27181,27190,28692,28707,28742,28812,28831,28872,29288,30311,31804,31805,32979,40474,41053,41275,41490,41676,41891,43776,43980,44186,44192,44301,44336,44341,44383,44780,44975,45093,45286,45490,45497,45552,47104,47153,47164,47343,47347,47721,47863,47939,48058,48098,48123,48235,48551,48552,48574,48853,48868,49885,56069:0:0", -- Nightcrawlers
	[6531]="0:4:2:1:Cloth::1:0::2:0", -- Barbaric Cloth Robe
	[6532]="250:0:1:20:EnhTemp::1:0:960,989,1148,1286,1456,1678,1684,2225,2393,2626,2810,2821,3029,3178,3333,3367,3497,3550,3572,3779,3954,4222,4229,4561,4574,4775,4897,5100,5135,5162,5163,5494,5817,5940,5942,7945,7947,8145,8363,8508,8934,9636,10118,11189,12022,12028,12031,12245,12941,12958,12962,14740,15179,16602,16613,16708,16768,16826,17101,17486,18009,18015,18018,18347,18907,18911,18960,19015,19017,19042,19194,19197,19244,19345,19372,19450,19472,19497,19533,19562,19573,20081,20092,20194,20250,20891,21083,21113,22099,22271,23802,23896,24054,24147,24188,24341,24356,24843,24935,25010,25034,25051,25082,26374,26474,26720,26939,26941,27012,27021,27026,27043,27057,27063,27070,27132,27144,27146,27181,27184,27190,27195,27938,28692,28707,28742,28794,28806,28812,28831,28872,29208,29270,29277,29288,30311,30345,30438,30825,31115,31804,31805,32477,32639,32641,32979,33669,37904,37935,40474,41053,41275,41490,41676,41891,43149,43776,43980,44186,44192,44301,44336,44341,44383,44780,44975,45093,45286,45552,47104,47153,47164,47343,47347,47721,47863,47939,48058,48098,48123,48235,48551,48552,48574,48853,48868,49409,49579,49595,49752,49765,49805,49885,56069:0:0", -- Bright Baubles
	[6533]="250:0:1:20:EnhTemp::1:1:1678,1684,2626,3029,3178,3333,3497,3550,3572,4222,4574,5162,5494,5940,5942,7945,8508,10118,12031,12962,14740,16708,17101,18018,18347,18911,19472,23896,27144,27181,27190,28707,28742,28812,31804,31805,43776,44192,44336,44975,47343,48552,48853,56069:0:0", -- Aquadynamic Fish Attractor
	[6534]="0:12:1:1:::1:0::4:0", -- Forged Steel Bars
	[6535]="0:12:1:1:::1:0::4:0", -- Tablet of Verga
	[6536]="0:4:2:1:Cloth::1:0::2:0", -- Willow Vest
	[6537]="0:4:2:1:Cloth::1:0::2:0", -- Willow Boots
	[6538]="0:4:2:1:Cloth::1:0::2:0", -- Willow Robe
	[6539]="0:4:2:1:Cloth::1:0::2:0", -- Willow Belt
	[6540]="0:4:2:1:Cloth::1:0::2:0", -- Willow Pants
	[6541]="0:4:2:1:Cloth::1:0::2:0", -- Willow Gloves
	[6542]="0:4:2:1:Cloak::1:0::2:0", -- Willow Cape
	[6543]="0:4:2:1:Cloth::1:0::2:0", -- Willow Bracers
	[6545]="0:4:2:1:Mail::1:0::2:0", -- Soldier's Armor
	[6546]="0:4:2:1:Mail::1:0::2:0", -- Soldier's Leggings
	[6547]="0:4:2:1:Mail::1:0::2:0", -- Soldier's Gauntlets
	[6548]="0:4:2:1:Mail::1:0::2:0", -- Soldier's Girdle
	[6549]="0:4:1:1:Cloak::1:0::0:0", -- Soldier's Cloak
	[6550]="0:4:2:1:Mail::1:0::2:0", -- Soldier's Wristguards
	[6551]="0:4:2:1:Mail::1:0::2:0", -- Soldier's Boots
	[6552]="0:4:2:1:Leather::1:0::2:0", -- Bard's Tunic
	[6553]="0:4:2:1:Leather::1:0::2:0", -- Bard's Trousers
	[6554]="0:4:2:1:Leather::1:0::2:0", -- Bard's Gloves
	[6555]="0:4:1:1:Cloak::1:0::0:0", -- Bard's Cloak
	[6556]="0:4:2:1:Leather::1:0::2:0", -- Bard's Bracers
	[6557]="0:4:2:1:Leather::1:0::2:0", -- Bard's Boots
	[6558]="0:4:2:1:Leather::1:0::2:0", -- Bard's Belt
	[6559]="0:4:2:1:Shield::1:0::2:0", -- Bard's Buckler
	[6560]="0:4:2:1:Shield::1:0::2:0", -- Soldier's Shield
	[6561]="0:4:2:1:Cloth::1:0::2:0", -- Seer's Padded Armor
	[6562]="0:4:2:1:Cloth::1:0::2:0", -- Shimmering Boots
	[6563]="0:4:2:1:Cloth::1:0::2:0", -- Shimmering Bracers
	[6564]="0:4:2:1:Cloak::1:0::2:0", -- Shimmering Cloak
	[6565]="0:4:2:1:Cloth::1:0::2:0", -- Shimmering Gloves
	[6566]="0:4:1:1:Cloth::1:0::0:0", -- Shimmering Amice
	[6567]="0:4:2:1:Cloth::1:0::2:0", -- Shimmering Armor
	[6568]="0:4:2:1:Cloth::1:0::2:0", -- Shimmering Trousers
	[6569]="0:4:2:1:Cloth::1:0::2:0", -- Shimmering Robe
	[6570]="0:4:2:1:Cloth::1:0::2:0", -- Shimmering Sash
	[6571]="0:4:2:1:Shield::1:0::2:0", -- Scouting Buckler
	[6572]="0:4:2:1:Shield::1:0::2:0", -- Defender Shield
	[6573]="0:4:2:1:Mail::1:0::2:0", -- Defender Boots
	[6574]="0:4:2:1:Mail::1:0::2:0", -- Defender Bracers
	[6575]="0:4:2:1:Cloak::1:0::2:0", -- Defender Cloak
	[6576]="0:4:2:1:Mail::1:0::2:0", -- Defender Girdle
	[6577]="0:4:2:1:Mail::1:0::2:0", -- Defender Gauntlets
	[6578]="0:4:2:1:Mail::1:0::2:0", -- Defender Leggings
	[6579]="0:4:1:1:Mail::1:0::0:0", -- Defender Spaulders
	[6580]="0:4:2:1:Mail::1:0::2:0", -- Defender Tunic
	[6581]="0:4:2:1:Leather::1:0::2:0", -- Scouting Belt
	[6582]="0:4:2:1:Leather::1:0::2:0", -- Scouting Boots
	[6583]="0:4:2:1:Leather::1:0::2:0", -- Scouting Bracers
	[6584]="0:4:2:1:Leather::1:0::2:0", -- Scouting Tunic
	[6585]="0:4:2:1:Cloak::1:0::2:0", -- Scouting Cloak
	[6586]="0:4:2:1:Leather::1:0::2:0", -- Scouting Gloves
	[6587]="0:4:2:1:Leather::1:0::2:0", -- Scouting Trousers
	[6588]="0:4:1:1:Leather::1:0::0:0", -- Scouting Spaulders
	[6590]="0:4:2:1:Mail::1:0::2:0", -- Battleforge Boots
	[6591]="0:4:2:1:Mail::1:0::2:0", -- Battleforge Wristguards
	[6592]="0:4:2:1:Mail::1:0::2:0", -- Battleforge Armor
	[6593]="0:4:2:1:Cloak::1:0::2:0", -- Battleforge Cloak
	[6594]="0:4:2:1:Mail::1:0::2:0", -- Battleforge Girdle
	[6595]="0:4:2:1:Mail::1:0::2:0", -- Battleforge Gauntlets
	[6596]="0:4:2:1:Mail::1:0::2:0", -- Battleforge Legguards
	[6597]="0:4:2:1:Mail::1:0::2:0", -- Battleforge Shoulderguards
	[6598]="0:4:2:1:Shield::1:0::2:0", -- Dervish Buckler
	[6599]="0:4:2:1:Shield::1:0::2:0", -- Battleforge Shield
	[6600]="0:4:2:1:Leather::1:0::2:0", -- Dervish Belt
	[6601]="0:4:2:1:Leather::1:0::2:0", -- Dervish Boots
	[6602]="0:4:2:1:Leather::1:0::2:0", -- Dervish Bracers
	[6603]="0:4:2:1:Leather::1:0::2:0", -- Dervish Tunic
	[6604]="0:4:2:1:Cloak::1:0::2:0", -- Dervish Cape
	[6605]="0:4:2:1:Leather::1:0::2:0", -- Dervish Gloves
	[6607]="0:4:2:1:Leather::1:0::2:0", -- Dervish Leggings
	[6608]="0:4:2:1:Cloth::1:0::2:0", -- Bright Armor
	[6609]="0:4:2:1:Cloth::1:0::2:0", -- Sage's Cloth
	[6610]="0:4:2:1:Cloth::1:0::2:0", -- Sage's Robe
	[6611]="0:4:2:1:Cloth::1:0::2:0", -- Sage's Sash
	[6612]="0:4:2:1:Cloth::1:0::2:0", -- Sage's Boots
	[6613]="0:4:2:1:Cloth::1:0::2:0", -- Sage's Bracers
	[6614]="0:4:2:1:Cloak::1:0::2:0", -- Sage's Cloak
	[6615]="0:4:2:1:Cloth::1:0::2:0", -- Sage's Gloves
	[6616]="0:4:2:1:Cloth::1:0::2:0", -- Sage's Pants
	[6617]="0:4:2:1:Cloth::1:0::2:0", -- Sage's Mantle
	[6622]="0:2:3:1:OneHandSword::1:0::2:0", -- Sword of Zeal
	[6624]="0:12:1:1:::1:0::4:0", -- Ken'zigla's Draught
	[6625]="0:12:1:1:::1:0::4:0", -- Dirt-Caked Pendant
	[6626]="0:12:1:1:::1:0::4:0", -- Dogran's Pendant
	[6627]="0:4:3:1:Mail::1:0::3:0", -- Mutant Scale Breastplate
	[6628]="0:4:2:1:Cloth::1:0::2:0", -- Raven's Claws
	[6629]="0:4:3:1:Cloak::1:0::3:0", -- Sporid Cape
	[6630]="0:4:3:1:Shield::1:0::3:0", -- Seedcloud Buckler
	[6631]="0:2:3:1:Stave::1:0::3:0", -- Living Root
	[6632]="0:4:3:1:Cloak::1:0::3:0", -- Feyscale Cloak
	[6633]="0:2:3:1:OneHandSword::1:0::3:0", -- Butcher's Slicer
	[6634]="0:12:1:20:::1:0::4:0", -- Ritual Salve
	[6635]="0:0:1:1:Consumable::1:0::3:0", -- Earth Sapta
	[6636]="0:0:1:1:Consumable::1:0::3:0", -- Fire Sapta
	[6637]="0:0:1:1:Consumable::1:0::3:0", -- Water Sapta
	[6640]="0:12:1:20:::1:0::4:0", -- Felstalker Hoof
	[6641]="0:2:3:1:TwoHandSword::1:0::3:0", -- Haunting Blade
	[6642]="0:4:3:1:Mail::1:0::3:0", -- Phantom Armor
	[6643]="0:15:1:1:Other::1:0::0:0", -- Bloated Smallfish
	[6645]="0:15:1:1:Other::1:0::0:0", -- Bloated Mud Snapper
	[6647]="0:15:1:1:Other::1:0::0:0", -- Bloated Catfish
	[6651]="0:2:1:1:OneHandMace::1:0::0:0", -- Broken Wine Bottle
	[6652]="0:12:1:1:::1:0::4:0", -- Reagent Pouch
	[6653]="0:4:1:1:OffHandFrill::1:0::4:0", -- Torch of the Dormant Flame
	[6654]="0:4:1:1:OffHandFrill::1:0::4:0", -- Torch of the Eternal Flame
	[6655]="0:12:1:1:::1:0::4:0", -- Glowing Ember
	[6656]="0:12:1:1:::1:0::4:0", -- Rough Quartz
	[6657]="0:0:1:20:FoodDrink::1:0::0:0", -- Savory Deviate Delight
	[6658]="0:12:1:1:::1:0::4:0", -- Example Collar
	[6659]="0:4:2:1:Cloth::1:0::3:0", -- Scarab Trousers
	[6660]="0:2:3:1:Dagger::1:0::2:0", -- Julie's Dagger
	[6661]="0:9:2:1:Cooking::1:0::0:0", -- Recipe: Savory Deviate Delight
	[6662]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Giant Growth
	[6663]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Elixir of Giant Growth
	[6664]="0:4:2:1:Cloth::1:0::3:0", -- Voodoo Mantle
	[6665]="0:4:2:1:Mail::1:0::3:0", -- Hexed Bracers
	[6666]="0:4:2:1:Mail::1:0::3:0", -- Dredge Boots
	[6667]="0:4:2:1:Cloak::1:0::3:0", -- Engineer's Cloak
	[6668]="0:4:2:1:Leather::1:0::3:0", -- Draftsman Boots
	[6669]="0:4:2:1:Ring::1:0::3:0", -- Sacred Band
	[6670]="0:4:2:1:Leather::1:0::3:0", -- Panther Armor
	[6671]="0:4:2:1:Mail::1:0::3:0", -- Juggernaut Leggings
	[6672]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Flash Bomb
	[6675]="0:4:2:1:Mail::1:0::3:0", -- Tempered Bracers
	[6676]="0:4:2:1:Shield::1:0::3:0", -- Constable Buckler
	[6677]="0:2:2:1:Wand::1:0::3:0", -- Spellcrafter Wand
	[6678]="0:4:2:1:Ring::1:0::3:0", -- Band of Elven Grace
	[6679]="0:2:3:1:Polearm::1:0::3:0", -- Armor Piercer
	[6681]="0:2:3:1:Dagger::1:0::3:0", -- Thornspike
	[6682]="0:4:3:1:Cloth::1:0::3:0", -- Death Speaker Robes
	[6684]="0:12:1:1:::1:0::4:0", -- Snufflenose Command Stick
	[6685]="0:4:3:1:Cloth::1:0::3:0", -- Death Speaker Mantle
	[6686]="0:4:3:1:Mail::1:0::3:0", -- Tusken Helm
	[6687]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Corpsemaker
	[6688]="0:4:3:1:Leather::1:0::3:0", -- Whisperwind Headdress
	[6689]="0:2:3:1:Stave::1:0::3:0", -- Wind Spirit Staff
	[6690]="0:4:3:1:Leather::1:0::3:0", -- Ferine Leggings
	[6691]="0:2:3:1:Dagger::1:0::3:0", -- Swinetusk Shank
	[6692]="0:2:3:1:OneHandAxe::1:0::3:0", -- Pronged Reaver
	[6693]="0:4:3:1:Ring::1:0::3:0", -- Agamaggan's Clutch
	[6694]="0:4:3:1:Shield::1:0::3:0", -- Heart of Agamaggan
	[6695]="0:4:3:1:Amulet::1:0::3:0", -- Stygian Bone Amulet
	[6696]="0:2:3:1:Bow::1:0::3:0", -- Nightstalker Bow
	[6697]="0:4:3:1:Cloth::1:0::3:0", -- Batwing Mantle
	[6709]="0:4:2:1:Leather::1:0::2:0", -- Moonglow Vest
	[6710]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Moonglow Vest
	[6712]="0:15:1:20:Junk::1:0::0:0", -- Clockwork Box
	[6713]="0:4:1:1:Cloth::1:0::3:0", -- Ripped Pants
	[6714]="0:7:1:20:Explosive::1:0::0:0", -- Ez-Thro Dynamite
	[6715]="0:7:1:1:Device::1:0::0:0", -- Ruined Jumper Cables
	[6716]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: EZ-Thro Dynamite
	[6717]="0:12:1:20:::1:0::4:0", -- Gaffer Jack
	[6718]="0:12:1:20:::1:0::4:0", -- Electropeller
	[6719]="0:4:2:1:Leather::1:0::3:0", -- Windborne Belt
	[6720]="0:4:2:1:Leather::1:0::3:0", -- Spirit Hunter Headdress
	[6721]="0:4:2:1:Mail::1:0::3:0", -- Chestplate of Kor
	[6722]="0:4:2:1:Mail::1:0::3:0", -- Beastial Manacles
	[6723]="0:4:3:1:Amulet::1:0::3:0", -- Medal of Courage
	[6725]="0:4:3:1:Shield::1:0::3:0", -- Marbled Buckler
	[6726]="0:4:2:1:Cloth::1:0::3:0", -- Razzeric's Customized Seatbelt
	[6727]="0:4:2:1:Leather::1:0::3:0", -- Razzeric's Racing Grips
	[6729]="0:2:2:1:Wand::1:0::3:0", -- Fizzle's Zippy Lighter
	[6730]="0:4:2:1:Mail::1:0::2:0", -- Ironforge Chain
	[6731]="0:4:2:1:Mail::1:0::2:0", -- Ironforge Breastplate
	[6732]="0:4:2:1:Leather::1:0::3:0", -- Gnomish Mechanic's Gloves
	[6733]="0:4:2:1:Mail::1:0::2:0", -- Ironforge Gauntlets
	[6735]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Ironforge Breastplate
	[6737]="0:4:2:1:Cloth::1:0::3:0", -- Dryleaf Pants
	[6738]="0:2:2:1:OneHandAxe::1:0::3:0", -- Bleeding Crescent
	[6739]="0:2:2:1:Bow::1:0::3:0", -- Cliffrunner's Aim
	[6740]="0:4:2:1:Leather::1:0::3:0", -- Azure Sash
	[6741]="0:2:1:1:TwoHandSword::1:0::3:0", -- Orcish War Sword
	[6742]="0:4:3:1:Mail::1:0::3:0", -- Stonefist Girdle
	[6743]="0:4:2:1:Ring::1:0::3:0", -- Sustaining Ring
	[6744]="0:4:2:1:Cloth::1:0::3:0", -- Gloves of Kapelan
	[6745]="0:4:2:1:Cloak::1:0::3:0", -- Swiftrunner Cape
	[6746]="0:4:2:1:Shield::1:0::3:0", -- Basalt Buckler
	[6747]="0:4:2:1:Mail::1:0::3:0", -- Enforcer Pauldrons
	[6748]="0:4:3:1:Ring::1:0::3:0", -- Monkey Ring
	[6749]="0:4:3:1:Ring::1:0::3:0", -- Tiger Band
	[6750]="0:4:3:1:Ring::1:0::3:0", -- Snake Hoop
	[6751]="0:4:3:1:Cloak::1:0::3:0", -- Mourning Shawl
	[6752]="0:4:3:1:Leather::1:0::3:0", -- Lancer Boots
	[6753]="0:12:1:20:::1:0::4:0", -- Feather Charm
	[6755]="0:15:1:1:Junk::1:0::3:0", -- A Small Container of Gems
	[6756]="0:1:1:1:Bag::1:0::3:0", -- Jewelry Box
	[6757]="0:4:2:1:Ring::1:0::3:0", -- Jaina's Signet Ring
	[6767]="0:12:1:1:::1:0::4:0", -- Tyranis' Pendant
	[6773]="0:4:2:1:Mail::1:0::3:0", -- Gelkis Marauder Chain
	[6774]="0:4:2:1:OffHandFrill::1:0::3:0", -- Uthek's Finger
	[6776]="0:12:1:1:::1:0::3:0", -- Tome of Valor
	[6780]="0:4:2:1:Cloth::1:0::3:0", -- Lilac Sash
	[6781]="0:0:1:1:Consumable::1:0::4:0", -- Bartleby's Mug
	[6782]="0:0:1:1:Consumable::1:0::4:0", -- Marshal Haggard's Badge
	[6784]="0:4:2:1:Leather::1:0::3:0", -- Braced Handguards
	[6785]="0:12:1:1:::1:0::4:0", -- Powers of the Void
	[6786]="0:4:1:1:Miscellaneous::1:0::0:0", -- Simple Dress
	[6787]="0:4:1:1:Miscellaneous::1:0::0:0", -- White Woolen Dress
	[6788]="0:4:2:1:Leather::1:0::3:0", -- Magram Hunter's Belt
	[6789]="0:4:2:1:Cloak::1:0::3:0", -- Ceremonial Centaur Blanket
	[6790]="0:4:2:1:Ring::1:0::3:0", -- Ring of Calm
	[6791]="0:4:2:1:Cloth::1:0::3:0", -- Hellion Boots
	[6792]="0:4:2:1:Mail::1:0::3:0", -- Sanguine Pauldrons
	[6793]="0:4:2:1:Mail::1:0::3:0", -- Auric Bracers
	[6794]="0:4:2:1:Leather::1:0::3:0", -- Stormfire Gauntlets
	[6795]="0:4:1:1:Shirt::1:0::0:0", -- White Swashbuckler's Shirt
	[6796]="0:4:1:1:Shirt::1:0::0:0", -- Red Swashbuckler's Shirt
	[6797]="0:2:2:1:Wand::1:0::3:0", -- Eyepoker
	[6798]="0:2:2:1:Gun::1:0::3:0", -- Blasting Hackbut
	[6799]="0:12:1:1:::1:0::4:0", -- Vejrek's Head
	[6800]="0:12:1:20:::1:0::4:0", -- Umbral Ore
	[6801]="0:4:2:1:Cloth::1:0::3:0", -- Baroque Apron
	[6802]="0:2:3:1:OneHandSword::1:0::3:0", -- Sword of Omen
	[6803]="0:4:3:1:OffHandFrill::1:0::3:0", -- Prophetic Cane
	[6804]="0:2:3:1:OneHandMace::1:0::3:0", -- Windstorm Hammer
	[6805]="0:12:1:1:::1:0::4:0", -- Horn of Vorlus
	[6806]="0:2:3:1:Wand::1:0::3:0", -- Dancing Flame
	[6807]="0:0:1:20:FoodDrink::1:0::0:0", -- Frog Leg Stew
	[6808]="0:12:1:20:::1:0::4:0", -- Elunite Ore
	[6809]="0:12:1:1:::1:0::4:0", -- Elura's Medallion
	[6810]="0:12:1:1:::1:0::4:0", -- Surena's Choker
	[6811]="0:0:1:20:EnhTemp::1:0::0:0", -- Aquadynamic Fish Lens
	[6812]="0:0:1:1:Consumable::1:0::4:0", -- Case of Elunite
	[6826]="0:15:0:20:Junk::1:0::0:0", -- Brilliant Scale
	[6827]="0:15:1:1:Junk::1:0::0:0", -- Box of Supplies
	[6828]="0:4:2:1:Shield::1:0::3:0", -- Visionary Buckler
	[6829]="0:2:3:1:OneHandSword::1:0::3:0", -- Sword of Serenity
	[6830]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Bonebiter
	[6831]="0:2:3:1:Dagger::1:0::3:0", -- Black Menace
	[6832]="0:4:2:1:Cloak::1:0::3:0", -- Cloak of Blight
	[6833]="0:4:1:1:Shirt::1:0::0:0", -- White Tuxedo Shirt
	[6834]="0:4:1:1:Cloth::1:0::0:0", -- Black Tuxedo
	[6835]="0:4:1:1:Cloth::1:0::0:0", -- Black Tuxedo Pants
	[6836]="0:4:1:1:Cloth::1:0::0:0", -- Dress Shoes
	[6838]="0:12:1:20:::1:0::4:0", -- Scorched Spider Fang
	[6839]="0:12:1:20:::1:0::4:0", -- Charred Horn
	[6840]="0:12:1:20:::1:0::4:0", -- Galvanized Horn
	[6841]="0:0:1:1:Consumable::1:0::4:0", -- Vial of Phlogiston
	[6842]="0:0:1:1:Consumable::1:0::4:0", -- Furen's Instructions
	[6843]="0:12:1:1:::1:0::4:0", -- Cask of Scalder
	[6844]="0:12:1:20:::1:0::4:0", -- Burning Blood
	[6845]="0:12:1:20:::1:0::4:0", -- Burning Rock
	[6846]="0:12:1:1:::1:0::4:0", -- Defias Script
	[6847]="0:12:1:1:::1:0::4:0", -- Dark Iron Script
	[6848]="0:12:1:20:::1:0::4:0", -- Searing Coral
	[6849]="0:12:1:20:::1:0::4:0", -- Sunscorched Shell
	[6851]="0:0:1:1:Consumable::1:0::4:0", -- Essence of the Exile
	[6866]="0:12:1:1:::1:0::3:0", -- Symbol of Life
	[6887]="0:0:1:20:FoodDrink::1:0::0:0", -- Spotted Yellowtail
	[6888]="0:0:1:20:FoodDrink::1:0::0:0", -- Herb Baked Egg
	[6889]="0:7:1:20:Meat:185:1:0::0:0", -- Small Egg
	[6890]="0:0:1:20:FoodDrink::1:0::0:0", -- Smoked Bear Meat
	[6892]="250:9:1:1:Cooking::1:0:1465,3556:0:0", -- Recipe: Smoked Bear Meat
	[6893]="0:13:1:1:::1:0::3:0", -- Workshop Key
	[6894]="0:12:1:1:::1:0::4:0", -- Whirlwind Heart
	[6895]="0:12:1:1:::1:0::4:0", -- Jordan's Smithing Hammer
	[6898]="0:4:2:1:OffHandFrill::1:0::3:0", -- Orb of Soran'ruk
	[6900]="0:4:3:1:Cloth::1:0::3:0", -- Enchanted Gold Bloodrobe
	[6901]="0:4:3:1:Cloak::1:0::3:0", -- Glowing Thresher Cape
	[6902]="0:4:3:1:Leather::1:0::3:0", -- Bands of Serra'kis
	[6903]="0:4:3:1:Cloth::1:0::3:0", -- Gaze Dreamer Pants
	[6904]="0:2:3:1:Dagger::1:0::3:0", -- Bite of Serra'kis
	[6905]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Reef Axe
	[6906]="0:4:3:1:Mail::1:0::3:0", -- Algae Fists
	[6907]="0:4:3:1:Mail::1:0::3:0", -- Tortoise Armor
	[6908]="0:4:3:1:Cloth::1:0::3:0", -- Ghamoo-Ra's Bind
	[6909]="0:2:3:1:TwoHandSword::1:0::3:0", -- Strike of the Hydra
	[6910]="0:4:3:1:Cloth::1:0::3:0", -- Leech Pants
	[6911]="0:4:3:1:Leather::1:0::3:0", -- Moss Cinch
	[6912]="0:12:1:1:::1:0::4:0", -- Heartswood
	[6913]="0:12:1:1:::1:0::4:0", -- Heartswood Core
	[6914]="0:12:1:20:::1:0::4:0", -- Soran'ruk Fragment
	[6915]="0:12:1:1:::1:0::4:0", -- Large Soran'ruk Fragment
	[6926]="0:0:1:1:Consumable::1:0::4:0", -- Furen's Notes
	[6928]="0:12:1:1:::1:0::4:0", -- Bloodstone Choker
	[6929]="0:0:1:1:Consumable::1:0::4:0", -- Bath'rah's Parchment
	[6930]="0:12:1:20:::1:0::4:0", -- Rod of Channeling
	[6931]="0:12:1:1:::1:0::4:0", -- Moldy Tome
	[6947]="25:0:1:20:EnhTemp::1:0:1325,1326,2622,3090,3135,3334,3405,3490,3551,3561,3969,4585,5139,5169,6779,10364,12096,15175,16268,16588,16683,16829,18006,18019,18802,19013,19014,19049,19239,19679,20081,20121,20194,20915,20986,22479,23145,23373,23732,24148,24313,24357,24780,25043,25736,26382,26568,26598,26900,26945,27031,27038,27053,27089,27133,27149,27176,27186,28347,28832,28869,29015,29037,29535,29561,29909,29922,29947,29961,30010,30244,30306,30438,31115,32639,32641,33630,33674,35642,39144,39878,41275,41490,41508,41676,41891,42622,42878,42910,42967,43155,43381,43411,43493,43547,43551,43555,43563,43646,43774,44047,44187,44313,44333,44970,45289,45290,45361,47860,53040,53076:0:0", -- Instant Poison
	[6948]="0:15:1:1:Junk::1:0::3:0", -- Hearthstone
	[6949]="0:0:1:20:EnhTemp::1:0::0:0", -- Instant Poison
	[6950]="0:0:1:20:EnhTemp::1:0::0:0", -- Instant Poison
	[6951]="0:15:0:20:Junk::1:0::0:0", -- Mind-Numbing Poison
	[6952]="0:12:1:20:::1:0::4:0", -- Thick Bear Fur
	[6953]="0:2:3:1:TwoHandMace::1:0::3:0", -- Verigan's Fist
	[6966]="0:2:2:1:OneHandAxe::1:0::3:0", -- Elunite Axe
	[6967]="0:2:2:1:OneHandSword::1:0::3:0", -- Elunite Sword
	[6968]="0:2:2:1:OneHandMace::1:0::3:0", -- Elunite Hammer
	[6969]="0:2:2:1:Dagger::1:0::3:0", -- Elunite Dagger
	[6970]="0:4:2:1:Shield::1:0::3:0", -- Furen's Favor
	[6971]="0:4:2:1:Mail::1:0::3:0", -- Fire Hardened Coif
	[6972]="0:4:3:1:Mail::1:0::3:0", -- Fire Hardened Hauberk
	[6973]="0:4:2:1:Mail::1:0::3:0", -- Fire Hardened Leggings
	[6974]="0:4:2:1:Mail::1:0::3:0", -- Fire Hardened Gauntlets
	[6975]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Whirlwind Axe
	[6976]="0:2:3:1:TwoHandMace::1:0::3:0", -- Whirlwind Warhammer
	[6977]="0:2:3:1:TwoHandSword::1:0::3:0", -- Whirlwind Sword
	[6978]="0:2:2:1:OneHandAxe::1:0::3:0", -- Umbral Axe
	[6979]="0:2:2:1:OneHandAxe::1:0::3:0", -- Haggard's Axe
	[6980]="0:2:2:1:Dagger::1:0::3:0", -- Haggard's Dagger
	[6981]="0:2:2:1:Dagger::1:0::3:0", -- Umbral Dagger
	[6982]="0:2:2:1:OneHandMace::1:0::3:0", -- Umbral Mace
	[6983]="0:2:2:1:OneHandMace::1:0::3:0", -- Haggard's Hammer
	[6984]="0:2:2:1:OneHandSword::1:0::3:0", -- Umbral Sword
	[6985]="0:2:2:1:OneHandSword::1:0::3:0", -- Haggard's Sword
	[6986]="0:15:0:20:Junk::1:0::0:0", -- Crimson Lotus
	[6989]="0:12:1:20:::1:0::4:0", -- Vial of Hatefury Blood
	[6990]="0:12:1:1:::1:0::4:0", -- Lesser Infernal Stone
	[6991]="0:12:1:20:::1:0::4:0", -- Smoldering Coal
	[6992]="0:12:1:1:::1:0::4:0", -- Jordan's Ore Shipment
	[6993]="0:12:1:1:::1:0::4:0", -- Jordan's Refined Ore Shipment
	[6994]="0:12:1:1:::1:0::4:0", -- Whitestone Oak Lumber
	[6995]="0:12:1:1:::1:0::4:0", -- Corrupted Kor Gem
	[6996]="0:12:1:1:::1:0::3:0", -- Jordan's Weapon Notes
	[6997]="0:12:1:1:::1:0::4:0", -- Tattered Manuscript
	[6998]="0:4:2:1:Cloth::1:0::3:0", -- Nimbus Boots
	[6999]="0:12:1:1:::1:0::4:0", -- Tome of the Cabal
	[7000]="0:4:2:1:Leather::1:0::3:0", -- Heartwood Girdle
	[7001]="0:2:3:1:Wand::1:0::3:0", -- Gravestone Scepter
	[7002]="0:4:3:1:Shield::1:0::3:0", -- Arctic Buckler
	[7003]="0:4:2:1:Mail::1:0::3:0", -- Beetle Clasps
	[7004]="0:4:2:1:Cloak::1:0::3:0", -- Prelacy Cape
	[7005]="82:2:1:1:Miscellaneous:202:1:0:66,777,843,989,1148,1250,1286,1465,1692,2118,2225,2697,2698,2699,2810,2816,2819,2821,2846,3008,3081,3168,3187,3366,3367,3482,3499,3556,3614,3779,3954,3958,4194,4225,4229,4561,4589,4775,4897,5128,5135,5163,5565,5817,7854,7947,8145,8160,8363,8934,11189,11874,12022,12028,12043,12245,12941,12942,12943,12956,12958,15179,16224,16261,16262,16613,16689,16748,16768,17486,17490,18009,18277,18426,18427,18754,18771,19196,19244,19372,19450,19532,21085,24843,24935,25010,25051,25082,27021,27026,27037,27043,27057,28692,28718,28798,28831,28872,29288,30311,32979,33601,33635,33641,33681,33683,34601,36695,36779,38783,38853,38873,40226,40474,41053,41275,41490,41676,41891,42853,43380,43495,43550,43554,43558,43568,43880,43980,44027,44034,44186,44341,44383,44386,44780,45093,45286,45490,45497,45552,46184,47153,47164,47347,48098,48551,48574,48608,48868,49404,49714,49885,50071,50094,50457,53075,53436,53782:0:0", -- Skinning Knife
	[7006]="0:12:1:1:::1:0::4:0", -- Reconstructed Tome
	[7026]="0:4:1:1:Cloth::1:0::0:0", -- Linen Belt
	[7027]="0:4:2:1:Cloth::1:0::2:0", -- Boots of Darkness
	[7046]="0:4:2:1:Cloth::1:0::2:0", -- Azure Silk Pants
	[7047]="0:4:2:1:Cloth::1:0::2:0", -- Hands of Darkness
	[7048]="0:4:2:1:Cloth::1:0::2:0", -- Azure Silk Hood
	[7049]="0:4:2:1:Cloth::1:0::2:0", -- Truefaith Gloves
	[7050]="0:4:2:1:Cloth::1:0::2:0", -- Silk Headband
	[7051]="0:4:2:1:Cloth::1:0::2:0", -- Earthen Vest
	[7052]="0:4:2:1:Cloth::1:0::2:0", -- Azure Silk Belt
	[7053]="0:4:2:1:Cloak::1:0::2:0", -- Azure Silk Cloak
	[7054]="0:4:3:1:Cloth::1:0::3:0", -- Robe of Power
	[7055]="0:4:2:1:Cloth::1:0::2:0", -- Crimson Silk Belt
	[7056]="0:4:2:1:Cloak::1:0::2:0", -- Crimson Silk Cloak
	[7057]="0:4:2:1:Cloth::1:0::2:0", -- Green Silken Shoulders
	[7058]="0:4:2:1:Cloth::1:0::2:0", -- Crimson Silk Vest
	[7059]="0:4:2:1:Cloth::1:0::2:0", -- Crimson Silk Shoulders
	[7060]="0:4:2:1:Cloth::1:0::2:0", -- Azure Shoulders
	[7061]="0:4:2:1:Cloth::1:0::2:0", -- Earthen Silk Belt
	[7062]="0:4:2:1:Cloth::1:0::2:0", -- Crimson Silk Pantaloons
	[7063]="0:4:2:1:Cloth::1:0::2:0", -- Crimson Silk Robe
	[7064]="0:4:2:1:Cloth::1:0::2:0", -- Crimson Silk Gloves
	[7065]="0:4:2:1:Cloth::1:0::2:0", -- Green Silk Armor
	[7067]="0:7:1:10:Elemental:171,164,333,202,755,165,197:1:0::0:0", -- Elemental Earth
	[7068]="0:7:1:10:Elemental:171,164,333,202,197:1:0::0:0", -- Elemental Fire
	[7069]="0:7:1:10:Elemental:164,202,197:1:0::0:0", -- Elemental Air
	[7070]="0:7:1:10:Elemental:171,164,755,165,197:1:0::0:0", -- Elemental Water
	[7071]="0:7:1:5:Part:165,197:1:0::0:0", -- Iron Buckle
	[7072]="0:7:1:10:Other:197:1:0::0:0", -- Naga Scale
	[7073]="0:15:0:20:Junk::1:0::0:0", -- Broken Fang
	[7074]="0:15:0:20:Junk::1:0::0:0", -- Chipped Claw
	[7075]="0:7:1:10:Elemental:164,333,202,755,165:1:0::0:0", -- Core of Earth
	[7076]="0:7:2:10:Elemental:171,164,333,202,755,165,197:1:0::0:0", -- Essence of Earth
	[7077]="0:7:1:10:Elemental:171,164,333,202,755,165,197:1:0::0:0", -- Heart of Fire
	[7078]="0:7:2:10:Elemental:171,164,333,202,755,165,197:1:0::0:0", -- Essence of Fire
	[7079]="0:7:1:10:Elemental:333,202,755,165,197:1:0::0:0", -- Globe of Water
	[7080]="0:7:2:10:Elemental:171,164,333,202,165,197:1:0::0:0", -- Essence of Water
	[7081]="0:7:1:10:Elemental:164,333,755,165:1:0::0:0", -- Breath of Wind
	[7082]="0:7:2:10:Elemental:171,333,202,755,165,197:1:0::0:0", -- Essence of Air
	[7083]="0:12:1:1:::1:0::4:0", -- Purified Kor Gem
	[7084]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Crimson Silk Shoulders
	[7085]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Azure Shoulders
	[7086]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Earthen Silk Belt
	[7087]="1200:9:1:1:Tailoring::1:1:2670:0:0", -- Pattern: Crimson Silk Cloak
	[7088]="5000:9:1:1:Tailoring::1:1:6568:0:0", -- Pattern: Crimson Silk Robe
	[7089]="1500:9:1:1:Tailoring::1:1:6574:0:0", -- Pattern: Azure Silk Cloak
	[7090]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Green Silk Armor
	[7091]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Truefaith Gloves
	[7092]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Hands of Darkness
	[7094]="0:2:1:1:Stave::1:0::0:0", -- Driftwood Branch
	[7095]="0:4:1:1:Cloth::1:0::0:0", -- Bog Boots
	[7096]="0:15:0:20:Junk::1:0::0:0", -- Plucked Feather
	[7097]="0:0:1:20:FoodDrink::1:0::0:0", -- Leg Meat
	[7098]="0:15:0:20:Junk::1:0::0:0", -- Splintered Tusk
	[7099]="0:15:0:20:Junk::1:0::0:0", -- Severed Pincer
	[7100]="0:15:0:20:Junk::1:0::0:0", -- Sticky Ichor
	[7101]="0:15:0:20:Junk::1:0::0:0", -- Bug Eye
	[7106]="0:4:2:1:Cloth::1:0::3:0", -- Zodiac Gloves
	[7107]="0:4:2:1:Mail::1:0::3:0", -- Belt of the Stars
	[7108]="0:4:2:1:Shield::1:0::2:0", -- Infantry Shield
	[7109]="0:4:1:1:Shield::1:0::0:0", -- Pioneer Buckler
	[7110]="0:4:2:1:Cloth::1:0::2:0", -- Silver-Thread Armor
	[7111]="0:4:2:1:Cloth::1:0::2:0", -- Nightsky Armor
	[7112]="0:4:2:1:Cloth::1:0::2:0", -- Aurora Armor
	[7113]="0:4:2:1:Cloth::1:0::2:0", -- Mistscape Armor
	[7114]="1000:9:1:1:Tailoring::1:1:2679,9636:0:0", -- Pattern: Azure Silk Gloves
	[7115]="0:2:2:1:OneHandAxe::1:0::3:0", -- Heirloom Axe
	[7116]="0:2:2:1:Dagger::1:0::3:0", -- Heirloom Dagger
	[7117]="0:2:2:1:OneHandMace::1:0::3:0", -- Heirloom Hammer
	[7118]="0:2:2:1:OneHandSword::1:0::3:0", -- Heirloom Sword
	[7119]="0:12:1:1:::1:0::4:0", -- Twitching Antenna
	[7120]="0:4:2:1:Shield::1:0::3:0", -- Ruga's Bulwark
	[7126]="0:12:1:20:::1:0::4:0", -- Smoky Iron Ingot
	[7127]="0:0:1:20:Consumable::1:0::4:0", -- Powdered Azurite
	[7128]="0:12:1:20:::1:0::4:0", -- Uncloven Satyr Hoof
	[7129]="0:4:2:1:Mail::1:0::3:0", -- Brutal Gauntlets
	[7130]="0:4:2:1:Mail::1:0::3:0", -- Brutal Helm
	[7131]="0:12:1:20:::1:0::4:0", -- Dragonmaw Shinbone
	[7132]="0:4:2:1:Mail::1:0::3:0", -- Brutal Legguards
	[7133]="0:4:3:1:Mail::1:0::3:0", -- Brutal Hauberk
	[7134]="0:12:1:20:::1:0::4:0", -- Sturdy Dragonmaw Shinbone
	[7135]="0:15:0:20:Junk::1:0::0:0", -- Broken Dragonmaw Shinbone
	[7146]="0:13:2:1:::1:0::3:0", -- The Scarlet Key
	[7148]="0:7:1:1:Device::1:0::0:0", -- Goblin Jumper Cables
	[7166]="0:2:1:1:Dagger::1:0::0:0", -- Copper Dagger
	[7189]="0:4:2:1:Cloth::1:0::2:0", -- Goblin Rocket Boots
	[7190]="0:15:0:1:Junk::1:0::0:0", -- Scorched Rocket Boots
	[7191]="0:7:1:5:Part:202:1:0::0:0", -- Fused Wiring
	[7206]="0:12:1:1:::1:0::4:0", -- Mirror Lake Water Sample
	[7207]="0:12:1:1:::1:0::4:0", -- Jennea's Flask
	[7208]="0:13:1:1:::1:0::4:0", -- Tazan's Key
	[7209]="0:12:1:1:::1:0::4:0", -- Tazan's Satchel
	[7226]="0:12:1:1:::1:0::4:0", -- Mage-Tastic Gizmonitor
	[7227]="0:0:1:1:Consumable::1:0::4:0", -- Balnir Snapdragons
	[7228]="500:0:1:20:FoodDrink::5:0:15353,15354,18913,18914,24934,47383,49893:0:0", -- Tigule and Foror's Strawberry Ice Cream
	[7229]="0:4:2:1:Mail::1:0::3:0", -- Explorer's Vest
	[7230]="0:2:3:1:TwoHandMace::1:0::3:0", -- Smite's Mighty Hammer
	[7231]="0:12:1:1:::1:0::4:0", -- Astor's Letter of Introduction
	[7247]="0:12:1:1:::1:0::4:0", -- Chest of Containment Coffers
	[7249]="0:12:1:20:::1:0::4:0", -- Charged Rift Gem
	[7266]="0:0:1:1:Consumable::1:0::4:0", -- Ur's Treatise on Shadow Magic
	[7267]="0:12:1:20:::1:0::4:0", -- Pristine Spider Silk
	[7268]="0:12:1:1:::1:0::4:0", -- Xavian Water Sample
	[7269]="0:12:1:1:::1:0::4:0", -- Deino's Flask
	[7270]="0:12:1:20:::1:0::4:0", -- Laughing Sister's Hair
	[7271]="0:12:1:20:::1:0::4:0", -- Flawless Ivory Tusk
	[7272]="0:12:1:1:::1:0::4:0", -- Bolt Charged Bramble
	[7273]="0:12:1:20:::1:0::4:0", -- Witherbark Totem Stick
	[7274]="0:12:1:1:::1:0::4:0", -- Rituals of Power
	[7276]="0:4:1:1:Cloak::1:0::0:0", -- Handstitched Leather Cloak
	[7277]="0:4:1:1:Leather::1:0::0:0", -- Handstitched Leather Bracers
	[7278]="0:1:1:1:Bag::1:0::0:0", -- Light Leather Quiver
	[7279]="0:1:1:1:Bag::1:0::0:0", -- Small Leather Ammo Pouch
	[7280]="0:4:2:1:Leather::1:0::2:0", -- Rugged Leather Pants
	[7281]="0:4:2:1:Leather::1:0::2:0", -- Light Leather Bracers
	[7282]="0:4:2:1:Leather::1:0::2:0", -- Light Leather Pants
	[7283]="0:4:2:1:Cloak::1:0::2:0", -- Black Whelp Cloak
	[7284]="0:4:2:1:Leather::1:0::2:0", -- Red Whelp Gloves
	[7285]="0:4:2:1:Leather::1:0::2:0", -- Nimble Leather Gloves
	[7286]="0:7:1:10:Leather:165:1:0::0:0", -- Black Whelp Scale
	[7287]="0:15:0:5:Junk::1:0::0:0", -- Red Whelp Scale
	[7288]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Rugged Leather Pants
	[7289]="650:9:1:1:Leatherworking::1:1:2697:0:0", -- Pattern: Black Whelp Cloak
	[7290]="1600:9:1:1:Leatherworking::1:1:2679:0:0", -- Pattern: Red Whelp Gloves
	[7291]="0:12:1:1:::1:0::4:0", -- Infernal Orb
	[7292]="0:12:1:20:::1:0::4:0", -- Filled Containment Coffer
	[7293]="0:12:1:20:::1:0::4:0", -- Dalaran Mana Gem
	[7294]="0:12:1:1:::1:0::4:0", -- Andron's Ledger
	[7295]="0:12:1:1:::1:0::3:0", -- Tazan's Logbook
	[7296]="0:15:0:20:Junk::1:0::0:0", -- Extinguished Torch
	[7297]="0:4:1:1:OffHandFrill::1:0::3:0", -- Morbent's Bane
	[7298]="0:2:2:1:Dagger::1:0::3:0", -- Blade of Cunning
	[7306]="0:12:1:1:::1:0::4:0", -- Fenwick's Head
	[7307]="0:0:1:20:EnhTemp::1:0::0:0", -- Flesh Eating Worm
	[7308]="0:12:1:1:::1:0::4:0", -- Cantation of Manifestation
	[7309]="0:12:1:1:::1:0::4:0", -- Dalaran Status Report
	[7326]="0:2:2:1:OneHandAxe::1:0::3:0", -- Thun'grim's Axe
	[7327]="0:2:2:1:Dagger::1:0::3:0", -- Thun'grim's Dagger
	[7328]="0:2:2:1:OneHandMace::1:0::3:0", -- Thun'grim's Mace
	[7329]="0:2:2:1:OneHandSword::1:0::3:0", -- Thun'grim's Sword
	[7330]="0:4:2:1:Shield::1:0::2:0", -- Infiltrator Buckler
	[7331]="0:4:2:1:Shield::1:0::2:0", -- Phalanx Shield
	[7332]="0:4:2:1:Cloth::1:0::2:0", -- Regal Armor
	[7334]="0:4:2:1:Cloth::1:0::3:0", -- Efflorescent Robe
	[7335]="0:4:2:1:Leather::1:0::3:0", -- Grizzly Tunic
	[7336]="0:4:2:1:Mail::1:0::3:0", -- Wildwood Chain
	[7337]="1000000:4:1:1:Ring::1:0:2849,16624,17512,49887:0:0", -- The Rock
	[7338]="10000:4:1:1:Ring::1:0:2849,16624,17512,49887:0:0", -- Mood Ring
	[7339]="250000:4:1:1:Ring::1:0:2849,16624,17512,45417,49887:0:0", -- Miniscule Diamond Ring
	[7340]="500000:4:1:1:Ring::1:0:2849,16624,17512,49887:0:0", -- Flawless Diamond Solitaire
	[7341]="50000:4:1:1:Ring::1:0:2849,16624,17512,49887:0:0", -- Cubic Zirconia Ring
	[7342]="100000:4:1:1:Ring::1:0:2849,16624,17512,49887:0:0", -- Silver Piffeny Band
	[7343]="0:12:1:1:::1:0::4:0", -- Bingles' Wrench
	[7344]="0:4:2:1:OffHandFrill::1:0::3:0", -- Torch of Holy Flame
	[7345]="0:12:1:1:::1:0::4:0", -- Bingles' Screwdriver
	[7346]="0:12:1:1:::1:0::4:0", -- Bingles' Hammer
	[7348]="0:4:3:1:Leather::1:0::2:0", -- Fletcher's Gloves
	[7349]="0:4:2:1:Leather::1:0::2:0", -- Herbalist's Gloves
	[7350]="0:4:1:1:Cloth::1:0::0:0", -- Disciple's Bracers
	[7351]="0:4:1:1:Cloth::1:0::0:0", -- Disciple's Boots
	[7352]="0:4:2:1:Leather::1:0::2:0", -- Earthen Leather Shoulders
	[7353]="0:4:2:1:Cloth::1:0::2:0", -- Elder's Padded Armor
	[7354]="0:4:2:1:Cloth::1:0::2:0", -- Elder's Boots
	[7355]="0:4:2:1:Cloth::1:0::2:0", -- Elder's Bracers
	[7356]="0:4:2:1:Cloak::1:0::2:0", -- Elder's Cloak
	[7357]="0:4:2:1:Cloth::1:0::2:0", -- Elder's Hat
	[7358]="0:4:2:1:Leather::1:0::2:0", -- Pilferer's Gloves
	[7359]="0:4:2:1:Leather::1:0::2:0", -- Heavy Earthen Gloves
	[7360]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Dark Leather Gloves
	[7361]="1800:9:2:1:Leatherworking::1:1:34601:0:0", -- Pattern: Herbalist's Gloves
	[7362]="2000:9:1:1:Leatherworking::1:1:3537:0:0", -- Pattern: Earthen Leather Shoulders
	[7363]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Pilferer's Gloves
	[7364]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Heavy Earthen Gloves
	[7365]="0:12:1:1:::1:0::4:0", -- Gnoam Sprecklesprocket
	[7366]="0:4:2:1:Cloth::1:0::2:0", -- Elder's Gloves
	[7367]="0:4:2:1:Cloth::1:0::2:0", -- Elder's Mantle
	[7368]="0:4:2:1:Cloth::1:0::2:0", -- Elder's Pants
	[7369]="0:4:2:1:Cloth::1:0::2:0", -- Elder's Robe
	[7370]="0:4:2:1:Cloth::1:0::2:0", -- Elder's Sash
	[7371]="0:1:2:1:Bag::1:0::0:0", -- Heavy Quiver
	[7372]="0:1:2:1:Bag::1:0::0:0", -- Heavy Leather Ammo Pouch
	[7373]="0:4:2:1:Leather::1:0::2:0", -- Dusky Leather Leggings
	[7374]="0:4:2:1:Leather::1:0::2:0", -- Dusky Leather Armor
	[7375]="0:4:2:1:Leather::1:0::2:0", -- Green Whelp Armor
	[7376]="0:12:1:1:::1:0::4:0", -- Bingles' Blastencapper
	[7377]="0:4:2:1:Cloak::1:0::2:0", -- Frost Leather Cloak
	[7378]="0:4:2:1:Leather::1:0::2:0", -- Dusky Bracers
	[7386]="0:4:2:1:Leather::1:0::2:0", -- Green Whelp Bracers
	[7387]="0:4:2:1:Leather:202:1:0::2:0", -- Dusky Belt
	[7390]="0:4:2:1:Leather::1:0::2:0", -- Dusky Boots
	[7391]="0:4:2:1:Leather::1:0::2:0", -- Swift Boots
	[7392]="0:7:1:5:Leather:333,165:1:0::0:0", -- Green Whelp Scale
	[7406]="0:4:2:1:Leather::1:0::2:0", -- Infiltrator Cord
	[7407]="0:4:2:1:Leather::1:0::2:0", -- Infiltrator Armor
	[7408]="0:4:2:1:Leather::1:0::2:0", -- Infiltrator Shoulders
	[7409]="0:4:2:1:Leather::1:0::2:0", -- Infiltrator Boots
	[7410]="0:4:2:1:Leather::1:0::2:0", -- Infiltrator Bracers
	[7411]="0:4:2:1:Cloak::1:0::2:0", -- Infiltrator Cloak
	[7412]="0:4:2:1:Leather::1:0::2:0", -- Infiltrator Gloves
	[7413]="0:4:2:1:Leather::1:0::2:0", -- Infiltrator Cap
	[7414]="0:4:2:1:Leather::1:0::2:0", -- Infiltrator Pants
	[7415]="0:4:2:1:Leather::1:0::2:0", -- Dervish Spaulders
	[7416]="0:4:2:1:Mail::1:0::2:0", -- Phalanx Bracers
	[7417]="0:4:2:1:Mail::1:0::2:0", -- Phalanx Boots
	[7418]="0:4:2:1:Mail::1:0::2:0", -- Phalanx Breastplate
	[7419]="0:4:2:1:Cloak::1:0::2:0", -- Phalanx Cloak
	[7420]="0:4:2:1:Mail::1:0::2:0", -- Phalanx Headguard
	[7421]="0:4:2:1:Mail::1:0::2:0", -- Phalanx Gauntlets
	[7422]="0:4:2:1:Mail::1:0::2:0", -- Phalanx Girdle
	[7423]="0:4:2:1:Mail::1:0::2:0", -- Phalanx Leggings
	[7424]="0:4:2:1:Mail::1:0::2:0", -- Phalanx Spaulders
	[7428]="0:15:0:20:Junk::1:0::0:0", -- Shadowcat Hide
	[7429]="0:4:2:1:Cloth::1:0::2:0", -- Twilight Armor
	[7430]="0:4:2:1:Cloth::1:0::2:0", -- Twilight Robe
	[7431]="0:4:2:1:Cloth::1:0::2:0", -- Twilight Pants
	[7432]="0:4:2:1:Cloth::1:0::2:0", -- Twilight Cowl
	[7433]="0:4:2:1:Cloth::1:0::2:0", -- Twilight Gloves
	[7434]="0:4:2:1:Cloth::1:0::2:0", -- Twilight Boots
	[7435]="0:4:2:1:Cloth::1:0::2:0", -- Twilight Mantle
	[7436]="0:4:2:1:Cloak::1:0::2:0", -- Twilight Cape
	[7437]="0:4:2:1:Cloth::1:0::2:0", -- Twilight Cuffs
	[7438]="0:4:2:1:Cloth::1:0::2:0", -- Twilight Belt
	[7439]="0:4:2:1:Leather::1:0::2:0", -- Sentinel Breastplate
	[7440]="0:4:2:1:Leather::1:0::2:0", -- Sentinel Trousers
	[7441]="0:4:2:1:Leather::1:0::2:0", -- Sentinel Cap
	[7442]="0:12:1:1:::1:0::3:0", -- Gyromast's Key
	[7443]="0:4:2:1:Leather::1:0::2:0", -- Sentinel Gloves
	[7444]="0:4:2:1:Leather::1:0::2:0", -- Sentinel Boots
	[7445]="0:4:2:1:Leather::1:0::2:0", -- Sentinel Shoulders
	[7446]="0:4:2:1:Cloak::1:0::2:0", -- Sentinel Cloak
	[7447]="0:4:2:1:Leather::1:0::2:0", -- Sentinel Bracers
	[7448]="0:4:2:1:Leather::1:0::2:0", -- Sentinel Girdle
	[7449]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Dusky Leather Leggings
	[7450]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Green Whelp Armor
	[7451]="2800:9:2:1:Leatherworking::1:1:4225,4589,7854,40226:0:0", -- Pattern: Green Whelp Bracers
	[7452]="0:9:3:1:Leatherworking::1:0::0:0", -- Pattern: Dusky Boots
	[7453]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Swift Boots
	[7454]="0:4:2:1:Mail::1:0::2:0", -- Knight's Breastplate
	[7455]="0:4:2:1:Mail::1:0::2:0", -- Knight's Legguards
	[7456]="0:4:2:1:Mail::1:0::2:0", -- Knight's Headguard
	[7457]="0:4:2:1:Mail::1:0::2:0", -- Knight's Gauntlets
	[7458]="0:4:2:1:Mail::1:0::2:0", -- Knight's Boots
	[7459]="0:4:2:1:Mail::1:0::2:0", -- Knight's Pauldrons
	[7460]="0:4:2:1:Cloak::1:0::2:0", -- Knight's Cloak
	[7461]="0:4:2:1:Mail::1:0::2:0", -- Knight's Bracers
	[7462]="0:4:2:1:Mail::1:0::2:0", -- Knight's Girdle
	[7463]="0:4:2:1:Shield::1:0::2:0", -- Sentinel Buckler
	[7464]="0:12:1:1:::1:0::4:0", -- Glyphs of Summoning
	[7465]="0:4:2:1:Shield::1:0::2:0", -- Knight's Crest
	[7468]="0:4:2:1:Cloth::1:0::2:0", -- Regal Robe
	[7469]="0:4:2:1:Cloth::1:0::2:0", -- Regal Leggings
	[7470]="0:4:2:1:Cloth::1:0::2:0", -- Regal Wizard Hat
	[7471]="0:4:2:1:Cloth::1:0::2:0", -- Regal Gloves
	[7472]="0:4:2:1:Cloth::1:0::2:0", -- Regal Boots
	[7473]="0:4:2:1:Cloth::1:0::2:0", -- Regal Mantle
	[7474]="0:4:2:1:Cloak::1:0::2:0", -- Regal Cloak
	[7475]="0:4:2:1:Cloth::1:0::2:0", -- Regal Cuffs
	[7476]="0:4:2:1:Cloth::1:0::2:0", -- Regal Sash
	[7477]="0:4:2:1:Leather::1:0::2:0", -- Ranger Tunic
	[7478]="0:4:2:1:Leather::1:0::2:0", -- Ranger Leggings
	[7479]="0:4:2:1:Leather::1:0::2:0", -- Ranger Helm
	[7480]="0:4:2:1:Leather::1:0::2:0", -- Ranger Gloves
	[7481]="0:4:2:1:Leather::1:0::2:0", -- Ranger Boots
	[7482]="0:4:2:1:Leather::1:0::2:0", -- Ranger Shoulders
	[7483]="0:4:2:1:Cloak::1:0::2:0", -- Ranger Cloak
	[7484]="0:4:2:1:Leather::1:0::2:0", -- Ranger Wristguards
	[7485]="0:4:2:1:Leather::1:0::2:0", -- Ranger Cord
	[7486]="0:4:2:1:Mail::1:0::2:0", -- Captain's Breastplate
	[7487]="0:4:2:1:Mail::1:0::2:0", -- Captain's Leggings
	[7488]="0:4:2:1:Mail::1:0::2:0", -- Captain's Circlet
	[7489]="0:4:2:1:Mail::1:0::2:0", -- Captain's Gauntlets
	[7490]="0:4:2:1:Mail::1:0::2:0", -- Captain's Boots
	[7491]="0:4:2:1:Mail::1:0::2:0", -- Captain's Shoulderguards
	[7492]="0:4:2:1:Cloak::1:0::2:0", -- Captain's Cloak
	[7493]="0:4:2:1:Mail::1:0::2:0", -- Captain's Bracers
	[7494]="0:4:2:1:Mail::1:0::2:0", -- Captain's Waistguard
	[7495]="0:4:2:1:Shield::1:0::2:0", -- Captain's Buckler
	[7496]="0:4:2:1:Shield::1:0::2:0", -- Field Plate Shield
	[7498]="0:12:1:1:::1:0::4:0", -- Top of Gelkak's Key
	[7500]="0:12:1:1:::1:0::4:0", -- Bottom of Gelkak's Key
	[7506]="0:4:2:1:Trinket::1:0::2:0", -- Gnomish Universal Remote
	[7507]="0:4:2:1:OffHandFrill::1:0::3:0", -- Arcane Orb
	[7508]="0:4:2:1:OffHandFrill::1:0::3:0", -- Ley Orb
	[7509]="0:4:2:1:Cloth::1:0::3:0", -- Manaweave Robe
	[7510]="0:4:2:1:Cloth::1:0::3:0", -- Lesser Spellfire Robes
	[7511]="0:4:2:1:Cloth::1:0::3:0", -- Astral Knot Robe
	[7512]="0:4:2:1:Cloth::1:0::3:0", -- Nether-Lace Robe
	[7513]="0:2:3:1:Wand::1:0::3:0", -- Ragefire Wand
	[7514]="0:2:3:1:Wand::1:0::3:0", -- Icefury Wand
	[7515]="0:4:3:1:OffHandFrill::1:0::3:0", -- Celestial Orb
	[7516]="0:0:1:1:Consumable::1:0::3:0", -- Tabetha's Instructions
	[7517]="0:4:2:1:Cloth::1:0::2:0", -- Gossamer Tunic
	[7518]="0:4:2:1:Cloth::1:0::2:0", -- Gossamer Robe
	[7519]="0:4:2:1:Cloth::1:0::2:0", -- Gossamer Pants
	[7520]="0:4:2:1:Cloth::1:0::2:0", -- Gossamer Headpiece
	[7521]="0:4:2:1:Cloth::1:0::2:0", -- Gossamer Gloves
	[7522]="0:4:2:1:Cloth::1:0::2:0", -- Gossamer Boots
	[7523]="0:4:2:1:Cloth::1:0::2:0", -- Gossamer Shoulderpads
	[7524]="0:4:2:1:Cloak::1:0::2:0", -- Gossamer Cape
	[7525]="0:4:2:1:Cloth::1:0::2:0", -- Gossamer Bracers
	[7526]="0:4:2:1:Cloth::1:0::2:0", -- Gossamer Belt
	[7527]="0:4:2:1:Leather::1:0::2:0", -- Cabalist Chestpiece
	[7528]="0:4:2:1:Leather::1:0::2:0", -- Cabalist Leggings
	[7529]="0:4:2:1:Leather::1:0::2:0", -- Cabalist Helm
	[7530]="0:4:2:1:Leather::1:0::2:0", -- Cabalist Gloves
	[7531]="0:4:2:1:Leather::1:0::2:0", -- Cabalist Boots
	[7532]="0:4:2:1:Leather::1:0::2:0", -- Cabalist Spaulders
	[7533]="0:4:2:1:Cloak::1:0::2:0", -- Cabalist Cloak
	[7534]="0:4:2:1:Leather::1:0::2:0", -- Cabalist Bracers
	[7535]="0:4:2:1:Leather::1:0::2:0", -- Cabalist Belt
	[7536]="0:4:2:1:Shield::1:0::2:0", -- Champion's Wall Shield
	[7537]="0:4:2:1:Shield::1:0::2:0", -- Gothic Shield
	[7538]="0:4:2:1:Mail::1:0::2:0", -- Champion's Armor
	[7539]="0:4:2:1:Mail::1:0::2:0", -- Champion's Leggings
	[7540]="0:4:2:1:Mail::1:0::2:0", -- Champion's Helmet
	[7541]="0:4:2:1:Mail::1:0::2:0", -- Champion's Gauntlets
	[7542]="0:4:2:1:Mail::1:0::2:0", -- Champion's Greaves
	[7543]="0:4:2:1:Mail::1:0::2:0", -- Champion's Pauldrons
	[7544]="0:4:2:1:Cloak::1:0::2:0", -- Champion's Cape
	[7545]="0:4:2:1:Mail::1:0::2:0", -- Champion's Bracers
	[7546]="0:4:2:1:Mail::1:0::2:0", -- Champion's Girdle
	[7552]="0:4:2:1:Ring::1:0::2:0", -- Falcon's Hook
	[7553]="0:4:2:1:Ring::1:0::2:0", -- Band of the Unicorn
	[7554]="0:4:2:1:OffHandFrill::1:0::2:0", -- Willow Branch
	[7555]="0:4:2:1:OffHandFrill::1:0::2:0", -- Regal Star
	[7556]="0:4:2:1:OffHandFrill::1:0::2:0", -- Twilight Orb
	[7557]="0:4:2:1:OffHandFrill::1:0::2:0", -- Gossamer Rod
	[7558]="0:4:2:1:OffHandFrill::1:0::2:0", -- Shimmering Stave
	[7559]="0:4:2:1:OffHandFrill::1:0::2:0", -- Runic Cane
	[7560]="1200:9:1:1:Engineering::1:1:5175:0:0", -- Schematic: Gnomish Universal Remote
	[7561]="2000:9:1:1:Engineering::1:1:3134,3537:0:0", -- Schematic: Goblin Jumper Cables
	[7566]="0:12:1:1:::1:0::4:0", -- Agamand Family Sword
	[7567]="0:12:1:1:::1:0::4:0", -- Agamand Family Axe
	[7568]="0:12:1:1:::1:0::4:0", -- Agamand Family Dagger
	[7569]="0:12:1:1:::1:0::4:0", -- Agamand Family Mace
	[7586]="0:12:1:1:::1:0::4:0", -- Tharnariun's Hope
	[7587]="0:12:1:1:::1:0::3:0", -- Thun'grim's Instructions
	[7606]="0:4:2:1:Mail::1:0::3:0", -- Polar Gauntlets
	[7607]="0:2:2:1:Wand::1:0::3:0", -- Sable Wand
	[7608]="0:4:2:1:OffHandFrill::1:0::2:0", -- Seer's Fine Stein
	[7609]="0:4:2:1:OffHandFrill::1:0::2:0", -- Elder's Amber Stave
	[7610]="0:4:2:1:OffHandFrill::1:0::2:0", -- Aurora Sphere
	[7611]="0:4:2:1:OffHandFrill::1:0::2:0", -- Mistscape Stave
	[7613]="2000:9:1:1:Leatherworking::1:1:2679,2698:0:0", -- Pattern: Green Leather Armor
	[7626]="0:12:1:1:::1:0::4:0", -- Bundle of Furs
	[7627]="0:0:1:1:Consumable::1:0::4:0", -- Dolanaar Delivery
	[7628]="0:12:1:1:::1:0::4:0", -- Nondescript Letter
	[7629]="0:0:1:1:Consumable::1:0::4:0", -- Ukor's Burden
	[7646]="0:12:1:1:::1:0::4:0", -- Crate of Inn Supplies
	[7666]="0:15:0:1:Junk::1:0::0:0", -- Shattered Necklace
	[7667]="0:12:1:1:::1:0::4:0", -- Talvash's Phial of Scrying
	[7668]="0:15:1:1:Junk::1:0::3:0", -- Bloodstained Journal
	[7669]="0:12:1:1:::1:0::4:0", -- Shattered Necklace Ruby
	[7670]="0:12:1:1:::1:0::4:0", -- Shattered Necklace Sapphire
	[7671]="0:12:1:1:::1:0::4:0", -- Shattered Necklace Topaz
	[7672]="0:12:1:1:::1:0::4:0", -- Shattered Necklace Power Source
	[7673]="0:4:3:1:Amulet::1:0::3:0", -- Talvash's Enhancing Necklace
	[7674]="0:12:1:1:::1:0::4:0", -- Delivery to Mathias
	[7675]="0:12:1:1:::1:0::4:0", -- Shipping Schedule
	[7676]="0:0:1:10:FoodDrink::1:0::0:0", -- Thistle Tea
	[7678]="0:9:1:1:Cooking::1:0::0:0", -- Recipe: Thistle Tea
	[7682]="0:2:3:1:Dagger::1:0::3:0", -- Torturing Poker
	[7683]="0:2:3:1:FistWeapon::1:0::3:0", -- Bloody Brass Knuckles
	[7684]="0:4:3:1:Cloth::1:0::3:0", -- Bloodmage Mantle
	[7685]="0:4:3:1:OffHandFrill::1:0::3:0", -- Orb of the Forgotten Seer
	[7686]="0:4:3:1:Ring::1:0::3:0", -- Ironspine's Eye
	[7687]="0:2:3:1:OneHandMace::1:0::3:0", -- Ironspine's Fist
	[7688]="0:4:3:1:Mail::1:0::3:0", -- Ironspine's Ribcage
	[7689]="0:2:3:1:TwoHandSword::1:0::3:0", -- Morbid Dawn
	[7690]="0:4:3:1:Leather::1:0::3:0", -- Ebon Vise
	[7691]="0:4:3:1:Cloth::1:0::3:0", -- Embalmed Shroud
	[7708]="0:2:3:1:Wand::1:0::3:0", -- Necrotic Wand
	[7709]="0:4:3:1:Cloth::1:0::3:0", -- Blighted Leggings
	[7710]="0:2:3:1:Stave::1:0::3:0", -- Loksey's Training Stick
	[7711]="0:4:3:1:Cloth::1:0::3:0", -- Robe of Doan
	[7712]="0:4:3:1:Cloth::1:0::3:0", -- Mantle of Doan
	[7713]="0:2:3:1:Stave::1:0::3:0", -- Illusionary Rod
	[7714]="0:2:3:1:Dagger::1:0::3:0", -- Hypnotic Blade
	[7715]="0:12:1:1:::1:0::4:0", -- Onin's Report
	[7717]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Ravager
	[7718]="0:4:3:1:Mail::1:0::3:0", -- Herod's Shoulder
	[7719]="0:4:3:1:Mail::1:0::3:0", -- Raging Berserker's Helm
	[7720]="0:4:3:1:Cloth::1:0::3:0", -- Whitemane's Chapeau
	[7721]="0:2:3:1:OneHandMace::1:0::3:0", -- Hand of Righteousness
	[7722]="0:4:3:1:Amulet::1:0::3:0", -- Triune Amulet
	[7723]="0:2:3:1:TwoHandMace::1:0::3:0", -- Mograine's Might
	[7724]="0:4:3:1:Mail::1:0::3:0", -- Gauntlets of Divinity
	[7726]="0:4:3:1:Shield::1:0::3:0", -- Aegis of the Scarlet Commander
	[7727]="0:4:3:1:Leather::1:0::2:0", -- Watchman Pauldrons
	[7728]="0:4:3:1:Cloth::1:0::2:0", -- Beguiler Robes
	[7729]="0:2:3:1:Gun::1:0::2:0", -- Chesterfall Musket
	[7730]="0:2:3:1:TwoHandMace::1:0::2:0", -- Cobalt Crusher
	[7731]="0:4:3:1:Amulet::1:0::3:0", -- Ghostshard Talisman
	[7734]="0:4:3:1:Trinket::1:0::2:0", -- Six Demon Bag
	[7735]="0:12:1:1:::1:0::4:0", -- Jannok's Rose
	[7736]="0:2:3:1:OneHandMace::1:0::2:0", -- Fight Club
	[7737]="0:12:1:1:::1:0::4:0", -- Sethir's Journal
	[7738]="0:4:2:1:Cloth::1:0::3:0", -- Evergreen Gloves
	[7739]="0:4:2:1:Cloak::1:0::3:0", -- Timberland Cape
	[7742]="2400:9:1:1:Engineering::1:1:6777:0:0", -- Schematic: Gnomish Cloaking Device
	[7746]="0:4:2:1:Amulet::1:0::3:0", -- Explorers' League Commendation
	[7747]="0:4:2:1:Shield::1:0::3:0", -- Vile Protector
	[7749]="0:4:2:1:OffHandFrill::1:0::3:0", -- Omega Orb
	[7750]="0:4:2:1:Cloth::1:0::3:0", -- Mantle of Woe
	[7751]="0:4:2:1:Leather::1:0::3:0", -- Vorrel's Boots
	[7752]="0:2:3:1:OneHandMace::1:0::2:0", -- Dreamslayer
	[7753]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Bloodspiller
	[7754]="0:4:3:1:Leather::1:0::2:0", -- Harbinger Boots
	[7755]="0:4:3:1:Leather::1:0::2:0", -- Flintrock Shoulders
	[7756]="0:4:3:1:Leather::1:0::3:0", -- Dog Training Gloves
	[7757]="0:2:3:1:Stave::1:0::2:0", -- Windweaver Staff
	[7758]="0:2:3:1:Polearm::1:0::2:0", -- Ruthless Shiv
	[7759]="0:4:3:1:Mail::1:0::2:0", -- Archon Chestpiece
	[7760]="0:4:3:1:Leather::1:0::2:0", -- Warchief Kilt
	[7761]="0:2:3:1:OneHandAxe::1:0::2:0", -- Steelclaw Reaver
	[7766]="0:12:1:1:::1:0::4:0", -- Empty Brown Waterskin
	[7767]="0:12:1:1:::1:0::4:0", -- Empty Blue Waterskin
	[7768]="0:12:1:1:::1:0::4:0", -- Empty Red Waterskin
	[7769]="0:12:1:1:::1:0::4:0", -- Filled Brown Waterskin
	[7770]="0:12:1:1:::1:0::4:0", -- Filled Blue Waterskin
	[7771]="0:12:1:1:::1:0::4:0", -- Filled Red Waterskin
	[7786]="0:2:3:1:OneHandAxe::1:0::2:0", -- Headsplitter
	[7787]="0:4:3:1:Shield::1:0::2:0", -- Resplendent Guardian
	[7806]="0:0:1:20:FoodDrink::1:0::0:0", -- Lollipop
	[7807]="0:0:1:20:FoodDrink::1:0::0:0", -- Candy Bar
	[7808]="0:0:1:20:FoodDrink::1:0::0:0", -- Chocolate Square
	[7809]="0:4:1:1:Miscellaneous::1:0::0:0", -- Easter Dress
	[7810]="0:12:1:1:::1:0::4:0", -- Vial of Purest Water
	[7811]="0:12:1:1:::1:0::4:0", -- Remaining Drops of Purest Water
	[7812]="0:12:1:1:::1:0::4:0", -- Corrupt Manifestation's Bracers
	[7813]="0:12:1:1:::1:0::4:0", -- Shard of Water
	[7846]="0:12:1:20:::1:0::4:0", -- Crag Coyote Fang
	[7847]="0:12:1:20:::1:0::4:0", -- Buzzard Gizzard
	[7848]="0:12:1:20:::1:0::4:0", -- Rock Elemental Shard
	[7866]="0:12:1:1:::1:0::3:0", -- Empty Thaumaturgy Vessel
	[7867]="0:12:1:20:::1:0::4:0", -- Vessel of Dragon's Blood
	[7870]="0:12:1:1:::1:0::4:0", -- Thaumaturgy Vessel Lockbox
	[7871]="0:12:1:1:::1:0::4:0", -- Token of Thievery
	[7886]="0:12:1:1:::1:0::4:0", -- Untranslated Journal
	[7887]="0:12:1:1:::1:0::4:0", -- Necklace and Gem Salvage
	[7888]="0:4:3:1:Amulet::1:0::3:0", -- Jarkal's Enhancing Necklace
	[7906]="0:12:1:1:::1:0::4:0", -- Horns of Nez'ra
	[7907]="0:15:1:1:Junk::1:0::3:0", -- Certificate of Thievery
	[7908]="0:12:1:1:::1:0::4:0", -- Klaven Mortwake's Journal
	[7909]="0:3:2:20:GemSimple:164,333,202,755:1:0::0:0", -- Aquamarine
	[7910]="0:3:2:20:GemSimple:164,202,755,197:1:0::0:0", -- Star Ruby
	[7911]="0:7:2:20:MetalStone:186:1:0::0:0", -- Truesilver Ore
	[7912]="0:7:1:20:MetalStone:164,202,755:1:0::0:0", -- Solid Stone
	[7913]="0:4:2:1:Mail::1:0::2:0", -- Barbaric Iron Shoulders
	[7914]="0:4:2:1:Mail::1:0::3:0", -- Barbaric Iron Breastplate
	[7915]="0:4:2:1:Mail::1:0::2:0", -- Barbaric Iron Helm
	[7916]="0:4:2:1:Mail::1:0::2:0", -- Barbaric Iron Boots
	[7917]="0:4:2:1:Mail::1:0::2:0", -- Barbaric Iron Gloves
	[7918]="0:4:2:1:Plate::1:0::2:0", -- Heavy Mithril Shoulder
	[7919]="0:4:2:1:Plate::1:0::2:0", -- Heavy Mithril Gauntlet
	[7920]="0:4:2:1:Mail::1:0::2:0", -- Mithril Scale Pants
	[7921]="0:4:2:1:Plate::1:0::2:0", -- Heavy Mithril Pants
	[7922]="0:4:3:1:Plate::1:0::2:0", -- Steel Plate Helm
	[7923]="0:13:1:1:::1:0::4:0", -- Defias Tower Key
	[7924]="0:4:2:1:Mail::1:0::2:0", -- Mithril Scale Bracers
	[7925]="0:4:2:1:Mail::1:0::2:0", -- Mithril Scale Gloves
	[7926]="0:4:2:1:Plate::1:0::2:0", -- Ornate Mithril Pants
	[7927]="0:4:2:1:Plate::1:0::2:0", -- Ornate Mithril Gloves
	[7928]="0:4:2:1:Plate::1:0::2:0", -- Ornate Mithril Shoulder
	[7929]="0:4:2:1:Mail::1:0::2:0", -- Orcish War Leggings
	[7930]="0:4:2:1:Plate::1:0::2:0", -- Heavy Mithril Breastplate
	[7931]="0:4:2:1:Mail::1:0::2:0", -- Mithril Coif
	[7932]="0:4:2:1:Mail::1:0::2:0", -- Mithril Scale Shoulders
	[7933]="0:4:2:1:Plate::1:0::2:0", -- Heavy Mithril Boots
	[7934]="0:4:2:1:Plate::1:0::2:0", -- Heavy Mithril Helm
	[7935]="0:4:2:1:Plate::1:0::2:0", -- Ornate Mithril Breastplate
	[7936]="0:4:2:1:Plate::1:0::2:0", -- Ornate Mithril Boots
	[7937]="0:4:2:1:Plate::1:0::2:0", -- Ornate Mithril Helm
	[7938]="0:4:3:1:Plate::1:0::2:0", -- Truesilver Gauntlets
	[7939]="0:4:3:1:Plate::1:0::2:0", -- Truesilver Breastplate
	[7941]="0:2:2:1:OneHandAxe::1:0::2:0", -- Heavy Mithril Axe
	[7942]="0:2:2:1:OneHandAxe::1:0::2:0", -- Blue Glittering Axe
	[7943]="0:2:2:1:OneHandSword::1:0::2:0", -- Wicked Mithril Blade
	[7944]="0:2:2:1:OneHandSword::1:0::2:0", -- Dazzling Mithril Rapier
	[7945]="0:2:2:1:OneHandMace::1:0::2:0", -- Big Black Mace
	[7946]="0:2:2:1:OneHandMace::1:0::2:0", -- Runed Mithril Hammer
	[7947]="0:2:2:1:Dagger::1:0::2:0", -- Ebon Shiv
	[7954]="0:2:3:1:OneHandMace::1:0::2:0", -- The Shatterer
	[7955]="0:2:1:1:TwoHandSword::1:0::0:0", -- Copper Claymore
	[7956]="0:2:2:1:TwoHandMace::1:0::2:0", -- Bronze Warhammer
	[7957]="0:2:2:1:TwoHandSword::1:0::2:0", -- Bronze Greatsword
	[7958]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Bronze Battle Axe
	[7959]="0:2:3:1:Polearm::1:0::2:0", -- Blight
	[7960]="0:2:3:1:TwoHandSword::1:0::2:0", -- Truesilver Champion
	[7961]="0:2:3:1:OneHandSword::1:0::2:0", -- Phantom Blade
	[7963]="0:4:2:1:Mail::1:0::2:0", -- Steel Breastplate
	[7964]="0:0:1:20:EnhTemp::1:0::0:0", -- Solid Sharpening Stone
	[7965]="0:0:1:20:EnhTemp::1:0::0:0", -- Solid Weightstone
	[7966]="0:7:1:20:MetalStone:164:1:0::0:0", -- Solid Grinding Stone
	[7967]="0:0:2:5:EnhPerm::1:0::0:0", -- Mithril Shield Spike
	[7968]="0:12:1:1:::1:0::4:0", -- Southsea Treasure
	[7969]="0:0:2:1:EnhPerm::1:0::0:0", -- Mithril Spurs
	[7970]="0:0:1:1:Consumable::1:0::3:0", -- E.C.A.C.
	[7971]="0:3:2:20:GemSimple:164,333,755,165,197:1:0::0:0", -- Black Pearl
	[7972]="0:7:1:10:Elemental:171,164,333,202,197:1:0::0:0", -- Ichor of Undeath
	[7973]="0:7:1:20:Other::1:0::0:0", -- Big-Mouth Clam
	[7974]="0:7:1:20:Meat:185:1:0::0:0", -- Zesty Clam Meat
	[7975]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Heavy Mithril Pants
	[7976]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Mithril Shield Spike
	[7978]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Barbaric Iron Shoulders
	[7979]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Barbaric Iron Breastplate
	[7980]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Barbaric Iron Helm
	[7981]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Barbaric Iron Boots
	[7982]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Barbaric Iron Gloves
	[7983]="0:9:2:1:Blacksmithing::1:0::3:0", -- Plans: Ornate Mithril Pants
	[7984]="0:9:2:1:Blacksmithing::1:0::3:0", -- Plans: Ornate Mithril Gloves
	[7985]="0:9:2:1:Blacksmithing::1:0::3:0", -- Plans: Ornate Mithril Shoulder
	[7989]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Mithril Spurs
	[7990]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Heavy Mithril Helm
	[7991]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Mithril Scale Shoulders
	[7992]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Blue Glittering Axe
	[7993]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Dazzling Mithril Rapier
	[7995]="6000:9:1:1:Blacksmithing::1:1:8161,8176:0:0", -- Plans: Mithril Scale Bracers
	[7997]="0:4:0:1:Miscellaneous::1:0::3:0", -- Red Defias Mask
	[8006]="0:2:3:1:Dagger::1:0::2:0", -- The Ziggler
	[8007]="0:0:1:1:Consumable::1:0::3:0", -- Mana Citrine
	[8008]="0:0:1:1:Consumable::1:0::3:0", -- Mana Ruby
	[8009]="0:12:1:20:::1:0::4:0", -- Dentrium Power Stone
	[8026]="0:12:1:1:::1:0::4:0", -- Garrett Family Treasure
	[8027]="0:12:1:1:::1:0::4:0", -- Krom Stoutarm's Treasure
	[8028]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Runed Mithril Hammer
	[8029]="0:9:2:1:Blacksmithing::1:0::3:0", -- Plans: Wicked Mithril Blade
	[8030]="10000:9:1:1:Blacksmithing::1:0:11278:3:0", -- Plans: Ebon Shiv
	[8046]="0:9:1:1:Book::1:0::3:0", -- Kearnen's Journal
	[8047]="0:12:1:20:::1:0::4:0", -- Magenta Fungus Cap
	[8048]="0:0:1:1:Consumable::1:0::4:0", -- Emerald Dreamcatcher
	[8049]="0:12:1:1:::1:0::4:0", -- Gnarlpine Necklace
	[8050]="0:12:1:1:::1:0::4:0", -- Tallonkai's Jewel
	[8051]="0:12:1:1:::1:0::3:0", -- Flare Gun
	[8052]="0:12:1:20:::1:0::4:0", -- An'Alleum Power Stone
	[8053]="0:12:1:1:::1:0::4:0", -- Obsidian Power Source
	[8066]="0:12:1:1:::1:0::3:0", -- Fizzule's Whistle
	[8067]="0:15:0:1000:Junk::1:0::0:0", -- Crafted Light Shot
	[8068]="0:15:0:1000:Junk::1:0::0:0", -- Crafted Heavy Shot
	[8069]="0:15:0:1000:Junk::1:0::0:0", -- Crafted Solid Shot
	[8070]="0:12:1:1:::1:0::4:0", -- Reward Voucher
	[8071]="0:2:2:1:Wand::1:0::3:0", -- Sizzle Stick
	[8072]="0:13:1:1:::1:0::4:0", -- Silixiz's Tower Key
	[8073]="0:12:1:1:::1:0::4:0", -- Cache of Zanzil's Altered Mixture
	[8074]="0:12:1:1:::1:0::4:0", -- Gallywix's Head
	[8075]="0:0:1:20:FoodDrink::1:0::0:0", -- Conjured Sourdough
	[8076]="0:0:1:20:FoodDrink::1:0::0:0", -- Conjured Sweet Roll
	[8077]="0:0:1:20:FoodDrink::1:0::0:0", -- Conjured Mineral Water
	[8078]="0:0:1:20:FoodDrink::1:0::0:0", -- Conjured Sparkling Water
	[8079]="0:0:1:20:FoodDrink::1:0::0:0", -- Conjured Crystal Water
	[8080]="0:4:0:1:Plate::1:0::0:0", -- Light Plate Chestpiece
	[8081]="0:4:0:1:Plate::1:0::0:0", -- Light Plate Belt
	[8082]="0:4:0:1:Plate::1:0::0:0", -- Light Plate Boots
	[8083]="0:4:0:1:Plate::1:0::0:0", -- Light Plate Bracers
	[8084]="0:4:0:1:Plate::1:0::0:0", -- Light Plate Gloves
	[8085]="0:4:0:1:Plate::1:0::0:0", -- Light Plate Pants
	[8086]="0:4:0:1:Plate::1:0::0:0", -- Light Plate Shoulderpads
	[8087]="0:12:1:1:::1:0::4:0", -- Sample of Zanzil's Altered Mixture
	[8088]="23470:4:1:1:Plate::1:0:980,1323,1349,4177,5126,5508,5819,8129,11182,12040,16626,16753,25274,27067,45500,53641:0:0", -- Platemail Belt
	[8089]="35075:4:1:1:Plate::1:0:980,1323,1349,4177,5126,5508,5819,8129,11182,12040,16626,16753,25274,27067,45500,53641:0:0", -- Platemail Boots
	[8090]="23653:4:1:1:Plate::1:0:980,1323,1349,4177,5126,5508,5819,8129,11182,12040,16626,16753,25274,27067,45500,53641:0:0", -- Platemail Bracers
	[8091]="23742:4:1:1:Plate::1:0:980,1323,1349,4177,5126,5508,5819,8129,11182,12040,16626,16753,25274,27067,45500,53641:0:0", -- Platemail Gloves
	[8092]="35479:4:1:1:Plate::1:0:980,1323,1349,4177,5126,5508,5819,8129,11182,12040,16626,16753,25274,27067,45500,53641:0:0", -- Platemail Helm
	[8093]="47577:4:1:1:Plate::1:0:980,1323,1349,4177,5126,5508,5819,8129,11182,12040,16626,16753,25274,27067,45500,53641:0:0", -- Platemail Leggings
	[8094]="47759:4:1:1:Plate::1:0:980,1323,1349,4177,5126,5508,5819,8129,11182,12040,16626,16753,25274,27067,45500,53641:0:0", -- Platemail Armor
	[8095]="0:0:1:1:Consumable::1:0::3:0", -- Hinott's Oil
	[8106]="0:4:2:1:Cloth::1:0::2:0", -- Hibernal Armor
	[8107]="0:4:2:1:Cloth::1:0::2:0", -- Hibernal Boots
	[8108]="0:4:2:1:Cloth::1:0::2:0", -- Hibernal Bracers
	[8109]="0:4:2:1:Cloak::1:0::2:0", -- Hibernal Cloak
	[8110]="0:4:2:1:Cloth::1:0::2:0", -- Hibernal Gloves
	[8111]="0:4:2:1:Cloth::1:0::2:0", -- Hibernal Mantle
	[8112]="0:4:2:1:Cloth::1:0::2:0", -- Hibernal Pants
	[8113]="0:4:2:1:Cloth::1:0::2:0", -- Hibernal Robe
	[8114]="0:4:2:1:Cloth::1:0::2:0", -- Hibernal Sash
	[8115]="0:4:2:1:Cloth::1:0::2:0", -- Hibernal Cowl
	[8116]="0:4:2:1:Leather::1:0::2:0", -- Heraldic Belt
	[8117]="0:4:2:1:Leather::1:0::2:0", -- Heraldic Boots
	[8118]="0:4:2:1:Leather::1:0::2:0", -- Heraldic Bracers
	[8119]="0:4:2:1:Leather::1:0::2:0", -- Heraldic Breastplate
	[8120]="0:4:2:1:Cloak::1:0::2:0", -- Heraldic Cloak
	[8121]="0:4:2:1:Leather::1:0::2:0", -- Heraldic Gloves
	[8122]="0:4:2:1:Leather::1:0::2:0", -- Heraldic Headpiece
	[8123]="0:4:2:1:Leather::1:0::2:0", -- Heraldic Leggings
	[8124]="0:4:2:1:Leather::1:0::2:0", -- Heraldic Spaulders
	[8125]="0:4:2:1:Mail::1:0::2:0", -- Myrmidon's Bracers
	[8126]="0:4:2:1:Mail::1:0::2:0", -- Myrmidon's Breastplate
	[8127]="0:4:2:1:Cloak::1:0::2:0", -- Myrmidon's Cape
	[8128]="0:4:2:1:Mail::1:0::2:0", -- Myrmidon's Gauntlets
	[8129]="0:4:2:1:Mail::1:0::2:0", -- Myrmidon's Girdle
	[8130]="0:4:2:1:Mail::1:0::2:0", -- Myrmidon's Greaves
	[8131]="0:4:2:1:Mail::1:0::2:0", -- Myrmidon's Helm
	[8132]="0:4:2:1:Mail::1:0::2:0", -- Myrmidon's Leggings
	[8133]="0:4:2:1:Mail::1:0::2:0", -- Myrmidon's Pauldrons
	[8134]="0:4:2:1:Shield::1:0::2:0", -- Myrmidon's Defender
	[8135]="0:4:2:1:Shield::1:0::2:0", -- Chromite Shield
	[8136]="0:12:1:1:::1:0::4:0", -- Gargantuan Tumor
	[8137]="0:4:2:1:Plate::1:0::2:0", -- Chromite Bracers
	[8138]="0:4:2:1:Plate::1:0::2:0", -- Chromite Chestplate
	[8139]="0:4:2:1:Plate::1:0::2:0", -- Chromite Gauntlets
	[8140]="0:4:2:1:Plate::1:0::2:0", -- Chromite Girdle
	[8141]="0:4:2:1:Plate::1:0::2:0", -- Chromite Greaves
	[8142]="0:4:2:1:Plate::1:0::2:0", -- Chromite Barbute
	[8143]="0:4:2:1:Plate::1:0::2:0", -- Chromite Legplates
	[8144]="0:4:2:1:Plate::1:0::2:0", -- Chromite Pauldrons
	[8146]="0:15:0:20:Junk::1:0::0:0", -- Wicked Claw
	[8147]="0:13:1:10:::1:0::0:0", -- Tiny Copper Key
	[8148]="0:13:1:10:::1:0::0:0", -- Tiny Silver Key
	[8149]="0:12:1:1:::1:0::4:0", -- Voodoo Charm
	[8150]="0:7:1:20:Leather:185,202,165:1:0::0:0", -- Deeprock Salt
	[8151]="0:15:0:20:Junk::1:0::0:0", -- Flask of Mojo
	[8152]="0:15:0:20:Junk::1:0::0:0", -- Flask of Big Mojo
	[8153]="0:7:2:20:Herb:171,164,333,202,165,197:1:0::0:0", -- Wildvine
	[8154]="0:7:1:20:Leather:165:1:0::0:0", -- Scorpid Scale
	[8155]="0:12:1:1:::1:0::4:0", -- Sathrah's Sacrifice
	[8156]="0:4:2:1:Plate::1:0::2:0", -- Jouster's Wristguards
	[8157]="0:4:2:1:Plate::1:0::2:0", -- Jouster's Chestplate
	[8158]="0:4:2:1:Plate::1:0::2:0", -- Jouster's Gauntlets
	[8159]="0:4:2:1:Plate::1:0::2:0", -- Jouster's Girdle
	[8160]="0:4:2:1:Plate::1:0::2:0", -- Jouster's Greaves
	[8161]="0:4:2:1:Plate::1:0::2:0", -- Jouster's Visor
	[8162]="0:4:2:1:Plate::1:0::2:0", -- Jouster's Legplates
	[8163]="0:4:2:1:Plate::1:0::2:0", -- Jouster's Pauldrons
	[8165]="0:7:1:20:Leather:165:1:0::0:0", -- Worn Dragonscale
	[8167]="0:7:1:20:Leather:165:1:0::0:0", -- Turtle Scale
	[8168]="0:7:0:20:Leather::1:0::0:0", -- Jet Black Feather
	[8169]="0:7:1:10:Leather:165:1:0::0:0", -- Thick Hide
	[8170]="2000:7:1:20:Leather:164,333,202,165,197:1:1:14846:0:0", -- Rugged Leather
	[8171]="0:7:1:10:Leather:165:1:0::0:0", -- Rugged Hide
	[8172]="0:7:1:20:Leather:165:1:0::0:0", -- Cured Thick Hide
	[8173]="0:0:1:10:EnhPerm::1:0::0:0", -- Thick Armor Kit
	[8174]="0:4:3:1:Leather::1:0::2:0", -- Comfortable Leather Hat
	[8175]="0:4:2:1:Leather::1:0::2:0", -- Nightscape Tunic
	[8176]="0:4:2:1:Leather::1:0::2:0", -- Nightscape Headband
	[8177]="0:2:1:1:TwoHandSword::1:0::0:0", -- Practice Sword
	[8178]="0:2:2:1:TwoHandSword::1:0::2:0", -- Training Sword
	[8179]="0:2:1:1:Bow::1:0::0:0", -- Cadet's Bow
	[8180]="0:2:2:1:Bow::1:0::2:0", -- Hunting Bow
	[8181]="0:2:1:1:Gun::1:0::0:0", -- Hunting Rifle
	[8182]="0:2:1:1:Gun::1:0::0:0", -- Pellet Rifle
	[8183]="0:2:2:1:Bow::1:0::2:0", -- Precision Bow
	[8184]="0:2:2:1:Wand::1:0::2:0", -- Firestarter
	[8185]="0:4:2:1:Mail::1:0::2:0", -- Turtle Scale Leggings
	[8186]="0:2:2:1:Wand::1:0::2:0", -- Dire Wand
	[8187]="0:4:2:1:Mail::1:0::2:0", -- Turtle Scale Gloves
	[8188]="0:2:2:1:Gun::1:0::2:0", -- Explosive Shotgun
	[8189]="0:4:2:1:Mail::1:0::2:0", -- Turtle Scale Breastplate
	[8190]="0:2:3:1:OneHandSword::1:0::2:0", -- Hanzo Sword
	[8191]="0:4:2:1:Mail::1:0::2:0", -- Turtle Scale Helm
	[8192]="0:4:2:1:Leather::1:0::2:0", -- Nightscape Shoulders
	[8193]="0:4:2:1:Leather::1:0::2:0", -- Nightscape Pants
	[8194]="0:2:2:1:OneHandMace::1:0::2:0", -- Goblin Nutcracker
	[8195]="0:4:2:1:Cloak::1:0::2:0", -- Nightscape Cloak
	[8196]="0:2:2:1:OneHandSword::1:0::2:0", -- Ebon Scimitar
	[8197]="0:4:2:1:Leather::1:0::2:0", -- Nightscape Boots
	[8198]="0:4:2:1:Mail::1:0::2:0", -- Turtle Scale Bracers
	[8199]="0:2:2:1:TwoHandSword::1:0::2:0", -- Battlefield Destroyer
	[8200]="0:4:2:1:Leather::1:0::2:0", -- Big Voodoo Robe
	[8201]="0:4:2:1:Leather::1:0::2:0", -- Big Voodoo Mask
	[8202]="0:4:2:1:Leather::1:0::2:0", -- Big Voodoo Pants
	[8203]="0:4:2:1:Mail::1:0::2:0", -- Tough Scorpid Breastplate
	[8204]="0:4:2:1:Mail::1:0::2:0", -- Tough Scorpid Gloves
	[8205]="0:4:2:1:Mail::1:0::2:0", -- Tough Scorpid Bracers
	[8206]="0:4:2:1:Mail::1:0::2:0", -- Tough Scorpid Leggings
	[8207]="0:4:2:1:Mail::1:0::2:0", -- Tough Scorpid Shoulders
	[8208]="0:4:2:1:Mail::1:0::2:0", -- Tough Scorpid Helm
	[8209]="0:4:2:1:Mail::1:0::2:0", -- Tough Scorpid Boots
	[8210]="0:4:2:1:Leather::1:0::2:0", -- Wild Leather Shoulders
	[8211]="0:4:2:1:Leather::1:0::2:0", -- Wild Leather Vest
	[8212]="0:4:2:1:Leather::1:0::2:0", -- Wild Leather Leggings
	[8213]="0:4:2:1:Leather::1:0::2:0", -- Wild Leather Boots
	[8214]="0:4:2:1:Leather::1:0::2:0", -- Wild Leather Helmet
	[8215]="0:4:2:1:Cloak::1:0::2:0", -- Wild Leather Cloak
	[8216]="0:4:2:1:Cloak::1:0::2:0", -- Big Voodoo Cloak
	[8217]="0:1:2:1:Bag::1:0::0:0", -- Quickdraw Quiver
	[8218]="0:1:2:1:Bag::1:0::0:0", -- Thick Leather Ammo Pouch
	[8223]="0:2:3:1:OneHandSword::1:0::2:0", -- Blade of the Basilisk
	[8224]="0:2:2:1:OneHandSword::1:0::2:0", -- Silithid Ripper
	[8225]="0:2:3:1:OneHandSword::1:0::2:0", -- Tainted Pierce
	[8226]="0:2:3:1:OneHandSword::1:0::2:0", -- The Butcher
	[8244]="0:12:3:20:::1:0::0:0", -- Flawless Draenethyst Sphere
	[8245]="0:4:2:1:Cloth::1:0::2:0", -- Imperial Red Tunic
	[8246]="0:4:2:1:Cloth::1:0::2:0", -- Imperial Red Boots
	[8247]="0:4:2:1:Cloth::1:0::2:0", -- Imperial Red Bracers
	[8248]="0:4:2:1:Cloak::1:0::2:0", -- Imperial Red Cloak
	[8249]="0:4:2:1:Cloth::1:0::2:0", -- Imperial Red Gloves
	[8250]="0:4:2:1:Cloth::1:0::2:0", -- Imperial Red Mantle
	[8251]="0:4:2:1:Cloth::1:0::2:0", -- Imperial Red Pants
	[8252]="0:4:2:1:Cloth::1:0::2:0", -- Imperial Red Robe
	[8253]="0:4:2:1:Cloth::1:0::2:0", -- Imperial Red Sash
	[8254]="0:4:2:1:Cloth::1:0::2:0", -- Imperial Red Circlet
	[8255]="0:4:2:1:Leather::1:0::2:0", -- Serpentskin Girdle
	[8256]="0:4:2:1:Leather::1:0::2:0", -- Serpentskin Boots
	[8257]="0:4:2:1:Leather::1:0::2:0", -- Serpentskin Bracers
	[8258]="0:4:2:1:Leather::1:0::2:0", -- Serpentskin Armor
	[8259]="0:4:2:1:Cloak::1:0::2:0", -- Serpentskin Cloak
	[8260]="0:4:2:1:Leather::1:0::2:0", -- Serpentskin Gloves
	[8261]="0:4:2:1:Leather::1:0::2:0", -- Serpentskin Helm
	[8262]="0:4:2:1:Leather::1:0::2:0", -- Serpentskin Leggings
	[8263]="0:4:2:1:Leather::1:0::2:0", -- Serpentskin Spaulders
	[8264]="0:4:2:1:Mail::1:0::2:0", -- Ebonhold Wristguards
	[8265]="0:4:2:1:Mail::1:0::2:0", -- Ebonhold Armor
	[8266]="0:4:2:1:Cloak::1:0::2:0", -- Ebonhold Cloak
	[8267]="0:4:2:1:Mail::1:0::2:0", -- Ebonhold Gauntlets
	[8268]="0:4:2:1:Mail::1:0::2:0", -- Ebonhold Girdle
	[8269]="0:4:2:1:Mail::1:0::2:0", -- Ebonhold Boots
	[8270]="0:4:2:1:Mail::1:0::2:0", -- Ebonhold Helmet
	[8271]="0:4:2:1:Mail::1:0::2:0", -- Ebonhold Leggings
	[8272]="0:4:2:1:Mail::1:0::2:0", -- Ebonhold Shoulderpads
	[8273]="0:4:2:1:Plate::1:0::2:0", -- Valorous Wristguards
	[8274]="0:4:2:1:Plate::1:0::2:0", -- Valorous Chestguard
	[8275]="0:4:2:1:Shield::1:0::2:0", -- Ebonhold Buckler
	[8276]="0:4:2:1:Plate::1:0::2:0", -- Valorous Gauntlets
	[8277]="0:4:2:1:Plate::1:0::2:0", -- Valorous Girdle
	[8278]="0:4:2:1:Plate::1:0::2:0", -- Valorous Greaves
	[8279]="0:4:2:1:Plate::1:0::2:0", -- Valorous Helm
	[8280]="0:4:2:1:Plate::1:0::2:0", -- Valorous Legguards
	[8281]="0:4:2:1:Plate::1:0::2:0", -- Valorous Pauldrons
	[8282]="0:4:2:1:Shield::1:0::2:0", -- Valorous Shield
	[8283]="0:4:2:1:Cloth::1:0::2:0", -- Arcane Armor
	[8284]="0:4:2:1:Cloth::1:0::2:0", -- Arcane Boots
	[8285]="0:4:2:1:Cloth::1:0::2:0", -- Arcane Bands
	[8286]="0:4:2:1:Cloak::1:0::2:0", -- Arcane Cloak
	[8287]="0:4:2:1:Cloth::1:0::2:0", -- Arcane Gloves
	[8288]="0:4:2:1:Cloth::1:0::2:0", -- Arcane Pads
	[8289]="0:4:2:1:Cloth::1:0::2:0", -- Arcane Leggings
	[8290]="0:4:2:1:Cloth::1:0::2:0", -- Arcane Robe
	[8291]="0:4:2:1:Cloth::1:0::2:0", -- Arcane Sash
	[8292]="0:4:2:1:Cloth::1:0::2:0", -- Arcane Cover
	[8293]="0:4:2:1:Leather::1:0::2:0", -- Traveler's Belt
	[8294]="0:4:2:1:Leather::1:0::2:0", -- Traveler's Boots
	[8295]="0:4:2:1:Leather::1:0::2:0", -- Traveler's Bracers
	[8296]="0:4:2:1:Leather::1:0::2:0", -- Traveler's Jerkin
	[8297]="0:4:2:1:Cloak::1:0::2:0", -- Traveler's Cloak
	[8298]="0:4:2:1:Leather::1:0::2:0", -- Traveler's Gloves
	[8299]="0:4:2:1:Leather::1:0::2:0", -- Traveler's Helm
	[8300]="0:4:2:1:Leather::1:0::2:0", -- Traveler's Leggings
	[8301]="0:4:2:1:Leather::1:0::2:0", -- Traveler's Spaulders
	[8302]="0:4:2:1:Mail::1:0::2:0", -- Hero's Bracers
	[8303]="0:4:2:1:Mail::1:0::2:0", -- Hero's Breastplate
	[8304]="0:4:2:1:Cloak::1:0::2:0", -- Hero's Cape
	[8305]="0:4:2:1:Mail::1:0::2:0", -- Hero's Gauntlets
	[8306]="0:4:2:1:Mail::1:0::2:0", -- Hero's Belt
	[8307]="0:4:2:1:Mail::1:0::2:0", -- Hero's Boots
	[8308]="0:4:2:1:Mail::1:0::2:0", -- Hero's Band
	[8309]="0:4:2:1:Mail::1:0::2:0", -- Hero's Leggings
	[8310]="0:4:2:1:Mail::1:0::2:0", -- Hero's Pauldrons
	[8311]="0:4:2:1:Plate::1:0::2:0", -- Alabaster Plate Vambraces
	[8312]="0:4:2:1:Plate::1:0::2:0", -- Alabaster Breastplate
	[8313]="0:4:2:1:Shield::1:0::2:0", -- Hero's Buckler
	[8314]="0:4:2:1:Plate::1:0::2:0", -- Alabaster Plate Gauntlets
	[8315]="0:4:2:1:Plate::1:0::2:0", -- Alabaster Plate Girdle
	[8316]="0:4:2:1:Plate::1:0::2:0", -- Alabaster Plate Greaves
	[8317]="0:4:2:1:Plate::1:0::2:0", -- Alabaster Plate Helmet
	[8318]="0:4:2:1:Plate::1:0::2:0", -- Alabaster Plate Leggings
	[8319]="0:4:2:1:Plate::1:0::2:0", -- Alabaster Plate Pauldrons
	[8320]="0:4:2:1:Shield::1:0::2:0", -- Alabaster Shield
	[8343]="2000:7:1:20:Cloth:165,197:1:0:989,1148,1286,1347,1454,1474,1672,2225,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3008,3091,3364,3366,3367,3485,3779,3954,3958,4168,4225,4229,4561,4577,4589,4775,4897,5128,5135,5154,5163,5565,5817,6567,6568,6574,7854,7940,7947,8145,8160,8363,8681,8934,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12958,15179,16366,16613,16638,16689,16748,16767,16768,17486,18009,18277,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,25010,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,32979,33596,33601,33635,33636,33681,33684,34601,38873,40226,40474,40572,41053,41275,41490,41676,41891,43380,43495,43550,43554,43568,43880,43980,44027,44186,44341,44383,44386,44780,45093,45552,45558,46184,47153,47164,47347,47856,48098,48551,48574,48587,48608,48857,48860,48868,49404,49705,49714,49888,50071,50094,50456,50457,53075,53436,53782:0:0", -- Heavy Silken Thread
	[8344]="0:12:1:1:::1:0::4:0", -- Silvery Spinnerets
	[8345]="0:4:3:1:Leather::1:0::2:0", -- Wolfshead Helm
	[8346]="0:4:3:1:Leather::1:0::2:0", -- Gauntlets of the Sea
	[8347]="0:4:3:1:Mail::1:0::2:0", -- Dragonscale Gauntlets
	[8348]="0:4:3:1:Leather::1:0::2:0", -- Helm of Fire
	[8349]="0:4:3:1:Leather::1:0::2:0", -- Feathered Breastplate
	[8350]="0:4:2:1:Ring::1:0::2:0", -- The 1 Ring
	[8363]="0:12:1:1:::1:0::4:0", -- Shaman Voodoo Charm
	[8364]="0:0:1:20:FoodDrink::1:0::0:0", -- Mithril Head Trout
	[8365]="0:7:1:20:Meat:185:1:0::0:0", -- Raw Mithril Head Trout
	[8366]="0:15:1:1:Other::1:0::0:0", -- Bloated Trout
	[8367]="0:4:3:1:Mail::1:0::2:0", -- Dragonscale Breastplate
	[8368]="0:15:0:20:Junk::1:0::0:0", -- Thick Wolfhide
	[8383]="0:15:1:1:Junk::1:0::0:0", -- Plain Letter
	[8384]="0:9:3:1:Leatherworking::1:0::0:0", -- Pattern: Comfortable Leather Hat
	[8385]="3500:9:1:1:Leatherworking::1:1:7854,40226:0:0", -- Pattern: Turtle Scale Gloves
	[8386]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Big Voodoo Robe
	[8387]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Big Voodoo Mask
	[8389]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Big Voodoo Pants
	[8390]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Big Voodoo Cloak
	[8391]="0:12:1:20:::1:0::0:0", -- Snickerfang Jowl
	[8392]="0:12:1:20:::1:0::0:0", -- Blasted Boar Lung
	[8393]="0:12:1:20:::1:0::0:0", -- Scorpok Pincer
	[8394]="0:12:1:20:::1:0::0:0", -- Basilisk Brain
	[8395]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Tough Scorpid Breastplate
	[8396]="0:12:1:20:::1:0::0:0", -- Vulture Gizzard
	[8397]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Tough Scorpid Bracers
	[8398]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Tough Scorpid Gloves
	[8399]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Tough Scorpid Boots
	[8400]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Tough Scorpid Shoulders
	[8401]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Tough Scorpid Leggings
	[8402]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Tough Scorpid Helm
	[8403]="0:9:2:1:Leatherworking::1:0::3:0", -- Pattern: Wild Leather Shoulders
	[8404]="0:9:2:1:Leatherworking::1:0::3:0", -- Pattern: Wild Leather Vest
	[8405]="0:9:2:1:Leatherworking::1:0::3:0", -- Pattern: Wild Leather Helmet
	[8406]="0:9:2:1:Leatherworking::1:0::3:0", -- Pattern: Wild Leather Boots
	[8407]="0:9:2:1:Leatherworking::1:0::3:0", -- Pattern: Wild Leather Leggings
	[8408]="0:9:2:1:Leatherworking::1:0::3:0", -- Pattern: Wild Leather Cloak
	[8409]="4000:9:2:1:Leatherworking::1:1:7854,8160:0:0", -- Pattern: Nightscape Shoulders
	[8410]="0:0:1:1:Elixir::1:0::3:0", -- R.O.I.D.S.
	[8411]="0:0:1:1:Elixir::1:0::3:0", -- Lung Juice Cocktail
	[8412]="0:0:1:1:Elixir::1:0::3:0", -- Ground Scorpok Assay
	[8423]="0:0:1:1:Elixir::1:0::3:0", -- Cerebral Cortex Compound
	[8424]="0:0:1:1:Elixir::1:0::3:0", -- Gizzard Gum
	[8425]="0:15:0:20:Junk::1:0::0:0", -- Parrot Droppings
	[8426]="0:15:0:20:Junk::1:0::0:0", -- Large Ruffled Feather
	[8427]="0:15:0:20:Junk::1:0::0:0", -- Mutilated Rat Carcass
	[8428]="0:12:1:1:::1:0::4:0", -- Laden Dew Gland
	[8429]="0:15:0:20:Junk::1:0::0:0", -- Punctured Dew Gland
	[8430]="0:15:0:20:Junk::1:0::0:0", -- Empty Dew Gland
	[8431]="0:12:1:1:::1:0::4:0", -- Spool of Light Chartreuse Silk Thread
	[8432]="0:0:1:1:Consumable::1:0::3:0", -- Eau de Mixilpixil
	[8443]="0:12:1:20:::1:0::4:0", -- Gahz'ridian Ornament
	[8444]="0:13:1:1:::1:0::0:0", -- Executioner's Key
	[8463]="0:12:1:1:::1:0::4:0", -- Warchief's Orders
	[8483]="0:15:0:20:Junk::1:0::0:0", -- Wastewander Water Pouch
	[8484]="0:15:1:1:Junk::1:0::3:0", -- Gadgetzan Water Co. Care Package
	[8485]="4000:15:1:1:Companion::1:0:6367:0:0", -- Cat Carrier (Bombay)
	[8486]="4000:15:1:1:Companion::1:0:6367:0:0", -- Cat Carrier (Cornish Rex)
	[8487]="4000:15:1:1:Companion::1:0:6367:0:0", -- Cat Carrier (Orange Tabby)
	[8488]="4000:15:1:1:Companion::1:0:6367:0:0", -- Cat Carrier (Silver Tabby)
	[8489]="6000:15:1:1:Companion::1:1:8666:0:0", -- Cat Carrier (White Kitten)
	[8490]="6000:15:1:1:Companion::1:0:20980:0:0", -- Cat Carrier (Siamese)
	[8491]="0:15:1:1:Companion::1:0::0:0", -- Cat Carrier (Black Tabby)
	[8492]="0:15:1:1:Companion::1:0::0:0", -- Parrot Cage (Green Wing Macaw)
	[8494]="0:15:4:1:Companion::1:0::0:0", -- Parrot Cage (Hyacinth Macaw)
	[8495]="4000:15:1:1:Companion::1:0:2663,20980,44179:0:0", -- Parrot Cage (Senegal)
	[8496]="4000:15:1:1:Companion::1:0:2663,44179:0:0", -- Parrot Cage (Cockatiel)
	[8497]="2000:15:1:1:Companion::1:0:1263:0:0", -- Rabbit Crate (Snowshoe)
	[8498]="0:15:1:1:Companion::1:0::0:0", -- Tiny Emerald Whelpling
	[8499]="0:15:1:1:Companion::1:0::0:0", -- Tiny Crimson Whelpling
	[8500]="5000:15:1:1:Companion::1:0:8665:0:0", -- Great Horned Owl
	[8501]="5000:15:1:1:Companion::1:0:8665:0:0", -- Hawk Owl
	[8508]="0:15:0:20:Junk::1:0::0:0", -- Large Fin
	[8523]="1000:12:1:1:::1:0:7683:4:0", -- Field Testing Kit
	[8524]="0:12:2:1:::1:0::3:0", -- Model 4711-FTZ Power Source
	[8525]="0:12:1:1:::1:0::4:0", -- Zinge's Purchase Order
	[8526]="0:12:1:1:::1:0::4:0", -- Violet Tragan
	[8527]="0:12:1:1:::1:0::4:0", -- Sealed Field Testing Kit
	[8528]="0:12:1:1:::1:0::4:0", -- Violet Powder
	[8529]="3500:0:1:20:Elixir::5:0:43418:3:0", -- Noggenfogger Elixir
	[8544]="0:0:1:20:Bandage::1:0::0:0", -- Mageweave Bandage
	[8545]="0:0:1:20:Bandage::1:0::0:0", -- Heavy Mageweave Bandage
	[8548]="0:0:1:1:Consumable::1:0::4:0", -- Divino-Matic Rod
	[8563]="10000:15:3:1:Mount::1:0:7955:3:0", -- Red Mechanostrider
	[8564]="0:12:1:1:::1:0::3:0", -- Hippogryph Egg
	[8584]="0:12:1:1:::1:0::4:0", -- Untapped Dowsing Widget
	[8585]="0:12:1:1:::1:0::4:0", -- Tapped Dowsing Widget
	[8586]="0:15:4:1:Mount::1:0::3:0", -- Whistle of the Mottled Red Raptor
	[8587]="0:12:1:20:::1:0::4:0", -- Centipaar Insect Parts
	[8588]="10000:15:3:1:Mount::1:0:7952:3:0", -- Whistle of the Emerald Raptor
	[8591]="10000:15:3:1:Mount::1:0:7952:3:0", -- Whistle of the Turquoise Raptor
	[8592]="10000:15:3:1:Mount::1:0:7952:3:0", -- Whistle of the Violet Raptor
	[8593]="0:12:1:1:::1:0::4:0", -- Scrimshank's Surveying Gear
	[8594]="0:12:1:1:::1:0::4:0", -- Insect Analysis Report
	[8595]="10000:15:3:1:Mount::1:0:7955:3:0", -- Blue Mechanostrider
	[8603]="0:12:1:1:::1:0::4:0", -- Thistleshrub Dew
	[8623]="0:12:2:1:::1:0::3:0", -- OOX-17/TN Distress Beacon
	[8624]="1000:4:1:1:OffHandFrill::1:0:8116,8117,8118:0:0", -- Red Sparkler
	[8625]="1000:4:1:1:OffHandFrill::1:0:8116,8117,8118:0:0", -- White Sparkler
	[8626]="1000:4:1:1:OffHandFrill::1:0:8116,8117,8118:0:0", -- Blue Sparkler
	[8629]="10000:15:3:1:Mount::1:0:4730:3:0", -- Reins of the Striped Nightsaber
	[8631]="10000:15:3:1:Mount::1:0:4730:3:0", -- Reins of the Striped Frostsaber
	[8632]="10000:15:3:1:Mount::1:0:4730:3:0", -- Reins of the Spotted Frostsaber
	[8643]="0:12:1:1:::1:0::3:0", -- Extraordinary Egg
	[8644]="0:12:1:1:::1:0::3:0", -- Fine Egg
	[8645]="0:12:1:1:::1:0::3:0", -- Ordinary Egg
	[8646]="0:12:1:1:::1:0::3:0", -- Bad Egg
	[8647]="0:12:1:1:::1:0::3:0", -- Egg Crate
	[8663]="0:4:2:1:Trinket::1:0::3:0", -- Mithril Insignia
	[8683]="0:12:1:20:::1:0::3:0", -- Clara's Fresh Apple
	[8684]="0:12:1:20:::1:0::4:0", -- Hinterlands Honey Ripple
	[8685]="0:12:1:1:::1:0::0:0", -- Dran's Ripple Delivery
	[8686]="0:12:1:1:::1:0::4:0", -- Mithril Pendant
	[8687]="0:12:1:1:::1:0::4:0", -- Sealed Description of Thredd's Visitor
	[8703]="0:4:2:1:Trinket::1:0::3:0", -- Signet of Expertise
	[8704]="0:12:2:1:::1:0::3:0", -- OOX-09/HL Distress Beacon
	[8705]="0:12:2:1:::1:0::3:0", -- OOX-22/FE Distress Beacon
	[8707]="0:12:1:1:::1:0::4:0", -- Gahz'rilla's Electrified Scale
	[8708]="0:2:4:1:OneHandMace::1:0::3:0", -- Hammer of Expertise
	[8723]="0:12:1:1:::1:0::4:0", -- Caliph Scorpidsting's Head
	[8724]="0:12:1:1:::1:0::4:0", -- Rin'ji's Secret
	[8746]="0:4:0:1:Cloth::1:0::0:0", -- Interlaced Cowl
	[8747]="0:4:0:1:Leather::1:0::0:0", -- Hardened Leather Helm
	[8748]="0:4:0:1:Mail::1:0::0:0", -- Double Mail Coif
	[8749]="0:4:0:1:Cloth::1:0::0:0", -- Crochet Hat
	[8750]="0:4:0:1:Leather::1:0::0:0", -- Thick Leather Hat
	[8751]="0:4:0:1:Mail::1:0::0:0", -- Overlinked Coif
	[8752]="0:4:0:1:Mail::1:0::0:0", -- Laminated Scale Circlet
	[8753]="0:4:0:1:Leather::1:0::0:0", -- Smooth Leather Helmet
	[8754]="0:4:0:1:Cloth::1:0::0:0", -- Twill Cover
	[8755]="0:4:0:1:Plate::1:0::0:0", -- Light Plate Helmet
	[8766]="4000:0:1:20:FoodDrink::5:0:258,274,295,465,955,982,1156,1237,1247,1327,1328,1464,1697,2303,2388,2803,2832,3086,3298,3411,3546,3708,3881,3882,3883,3884,3934,3937,3959,3961,4167,4169,4181,4190,4255,4266,4554,4555,4571,4782,4879,4893,4981,5111,5112,5140,5611,5620,5688,5814,5871,6091,6272,6727,6734,6735,6736,6738,6739,6740,6741,6746,6747,6790,6791,6807,6928,6929,6930,7485,7731,7733,7737,7744,7941,7943,8143,8150,8152,8931,9356,9501,10367,11038,11103,11106,11118,11187,11287,12019,12026,12096,12097,12196,12959,14371,14624,14731,14961,14962,14963,14964,15124,15125,15174,15397,15433,16256,16443,16542,16553,16585,16602,16618,16739,16798,16826,17277,17553,17630,17656,18245,18905,18906,18907,18908,18913,18914,18957,19050,19182,19232,19245,19296,19314,19315,19348,19352,19435,19451,19470,19495,19518,19528,19559,19572,19617,19679,19718,20080,20231,20893,20916,21084,21110,21145,21183,21484,21487,21744,21746,23110,23143,23573,23995,24033,24057,24149,24208,24333,24342,24834,24934,25012,25036,25052,25089,26375,26680,29205,29291,33018,33209,36378,39031,40467,40589,40815,40898,40968,41286,41491,41674,41892,42709,43034,43384,43606,43624,43633,43699,43771,43899,43945,43946,43972,44006,44177,44190,44196,44219,44235,44236,44237,44267,44268,44270,44276,44312,44334,44340,44343,44344,44379,44391,44417,44785,45008,45086,45563,45565,45566,46269,46271,46642,46995,47142,47165,47288,47334,47363,47367,47547,47668,47717,47756,47854,47942,48054,48125,48215,48555,48599,48607,48735,49394,49430,49917,50092,50126,53528:0:0", -- Morning Glory Dew
	[8827]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Water Walking
	[8831]="0:7:1:20:Herb:171,333,197:1:0::0:0", -- Purple Lotus
	[8836]="0:7:1:20:Herb::1:0::0:0", -- Arthas' Tears
	[8838]="0:7:1:20:Herb:171,333:1:0::0:0", -- Sungrass
	[8839]="0:7:1:20:Herb:171:1:0::0:0", -- Blindweed
	[8845]="1500:7:1:20:Herb:171:1:1:14846:0:0", -- Ghost Mushroom
	[8846]="1000:7:1:20:Herb:171:1:1:16015:0:0", -- Gromsblood
	[8923]="0:15:0:20:Junk::1:0::0:0", -- Essence of Agony
	[8924]="0:15:0:20:Junk::1:0::0:0", -- Dust of Deterioration
	[8925]="0:7:0:20:Other::1:0::0:0", -- Tainted Vial
	[8926]="0:0:1:20:EnhTemp::1:0::0:0", -- Instant Poison
	[8927]="0:0:1:20:EnhTemp::1:0::0:0", -- Instant Poison
	[8928]="0:0:1:20:EnhTemp::1:0::0:0", -- Instant Poison
	[8932]="4000:0:1:20:FoodDrink::5:0:295,465,483,1237,3298,3546,4255,4782,4891,4894,4981,5620,6746,6790,6930,9501,10367,11106,16553,17630,18929,19232,19296,19718,20080,20916,21110,21744,21746,22266,23521,23604,24342,24934,38714,40815,43972,44268,44417,44785,46269,46995,48125,49917:0:0", -- Alterac Swiss
	[8948]="4000:0:1:20:FoodDrink::5:0:2803,3138,3329,3544,3547,4554,4571,5688,5886,6739,6741,8150,8152,10367,10666,11038,12096,12097,12384,14961,14962,14963,14964,15124,15125,17656,19471,22266,24149,24342,27032,29205,33018,36378,43899,44235,44237,46271,47142,47334,47367,47547,47668,47854,49394,49430,53528:0:0", -- Dried King Bolete
	[8949]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Agility
	[8950]="4000:0:1:20:FoodDrink::5:0:233,1237,1247,1670,2832,3003,3086,3291,3368,3480,3518,3546,3708,3883,3884,3937,3948,3959,4190,4255,4266,4891,4894,5109,5620,6272,6734,6736,6740,6747,6929,7485,7737,7744,7941,8143,8307,9099,10367,11103,11287,15433,16256,16739,17630,18245,18907,19038,19232,19348,19352,19451,19495,19518,19664,20893,21744,21746,23522,23603,23937,24033,24057,24834,24934,25012,25052,25089,29291,33996,36378,40467,43384,43699,44006,44196,44219,44235,44237,44267,44340,44379,44785,45417,45563,46269,46271,47142,47338,47363,47756,47942,48607,49394,49430,49917,50126:0:0", -- Homemade Cherry Pie
	[8951]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Greater Defense
	[8952]="4000:0:1:20:FoodDrink::5:0:982,1156,1464,2388,2814,3025,3089,3312,3368,3411,3489,3705,3881,3882,3933,3935,4169,4255,4782,4879,4891,4894,4954,5111,5124,5611,5620,5688,5870,6739,6741,6928,6929,7485,7731,7733,9356,10367,11118,11187,12096,12097,12196,12959,14624,14961,14962,14963,14964,15124,15125,15174,15397,16443,16585,16602,16618,16739,16798,16826,17277,17553,17630,17656,18905,18906,18908,18913,18914,18957,19038,19182,19314,19315,19348,19352,19435,19470,19528,19559,19572,19679,19718,20097,20231,20378,20893,21084,22266,23143,23263,23481,23605,24208,24343,25036,26375,28760,28943,29205,36378,39031,40589,40898,41286,41491,41674,41892,42953,43606,43624,43633,43739,43771,43899,43956,44177,44276,44312,44343,45563,47165,47288,47668,47854,48555,48735,50092,51142:0:0", -- Roasted Quail
	[8953]="4000:0:1:20:FoodDrink::5:0:894,1671,3017,3342,3934,3961,4255,4891,5814,6735,6740,7978,12096,12097,14961,14962,14963,14964,15124,15125,16443,16542,16798,17277,17630,18957,19050,19223,19232,19471,19572,19718,21145,21484,21487,21744,21746,22266,23573,24934,25036,26375,26680,29547,40968,43945,43946,44190,44270,44325,44340,44344,44379,44391,44397,45008,45086,46642,47165,47363,47717,48054,48215,48555,48599:0:0", -- Deep Fried Plantains
	[8956]="0:0:1:5:Other::1:0::0:0", -- Oil of Immolation
	[8957]="4000:0:1:20:FoodDrink::5:0:1678,1684,2842,3029,3086,3178,3497,4221,4255,4305,5814,6727,6738,6791,6807,7943,8931,10367,11187,12962,14731,16618,16739,17553,17656,19045,19296,19472,22266,23896,24033,24057,24834,25012,25036,25052,25089,29291,43899,43945,43946,44334,45008,45086,46182,46642,47334,56069:0:0", -- Spinefin Halibut
	[8959]="0:7:1:20:Meat::1:0::0:0", -- Raw Spinefin Halibut
	[8973]="0:12:1:20:::1:0::4:0", -- Thick Yeti Hide
	[8984]="0:0:1:20:EnhTemp::1:0::0:0", -- Deadly Poison
	[8985]="0:0:1:20:EnhTemp::1:0::0:0", -- Deadly Poison
	[9030]="0:0:1:20:Potion::1:0::0:0", -- Restorative Potion
	[9036]="0:0:1:20:Potion::1:0::0:0", -- Magic Resistance Potion
	[9060]="0:7:1:20:Part:202:1:0::0:0", -- Inlaid Mithril Cylinder
	[9061]="0:7:1:20:Part:185,202:1:0::0:0", -- Goblin Rocket Fuel
	[9088]="0:0:1:20:Elixir::1:0::0:0", -- Gift of Arthas
	[9144]="0:0:1:20:Potion::1:0::0:0", -- Wildvine Potion
	[9149]="0:4:2:1:Trinket:171:1:0::3:0", -- Philosopher's Stone
	[9153]="0:12:1:1:::1:0::4:0", -- Rig Blueprints
	[9154]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Detect Undead
	[9155]="0:0:1:20:Elixir::1:0::0:0", -- Arcane Elixir
	[9172]="0:0:1:20:Potion::1:0::0:0", -- Invisibility Potion
	[9173]="0:12:0:1:::1:0::3:0", -- Goblin Transponder
	[9179]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Greater Intellect
	[9186]="0:15:0:20:Junk::1:0::0:0", -- Mind-numbing Poison III
	[9187]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Greater Agility
	[9189]="0:12:1:1:::1:0::4:0", -- Shay's Bell
	[9197]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Dream Vision
	[9206]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Giants
	[9210]="0:7:1:10:Other:197:1:0::0:0", -- Ghost Dye
	[9214]="0:9:0:1:Book::1:0::3:0", -- Grimoire of Inferno
	[9224]="0:0:1:20:Elixir:333:1:0::0:0", -- Elixir of Demonslaying
	[9233]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Detect Demon
	[9234]="0:12:1:1:::1:0::4:0", -- Tiara of the Deep
	[9235]="0:12:1:1:::1:0::4:0", -- Pratt's Letter
	[9236]="0:12:1:1:::1:0::4:0", -- Jangdor's Letter
	[9237]="0:12:1:20:::1:0::4:0", -- Woodpaw Gnoll Mane
	[9238]="0:12:1:20:::1:0::4:0", -- Uncracked Scarab Shell
	[9240]="0:2:3:1:OneHandMace::1:0::3:0", -- Mallet of Zul'Farrak
	[9241]="0:12:1:1:::1:0::3:0", -- Sacred Mallet
	[9242]="0:15:0:1:Junk::1:0::0:0", -- Ancient Tablet
	[9243]="0:4:3:1:Amulet::1:0::3:0", -- Shriveled Troll Heart
	[9244]="0:12:1:1:::1:0::4:0", -- Stoley's Shipment
	[9245]="0:12:1:1:::1:0::4:0", -- Stoley's Bottle
	[9246]="0:12:1:1:::1:0::4:0", -- Firebeard's Head
	[9247]="0:12:1:20:::1:0::4:0", -- Hatecrest Naga Scale
	[9248]="0:12:1:1:::1:0::4:0", -- Mysterious Relic
	[9249]="0:13:2:1:::1:0::0:0", -- Captain's Key
	[9250]="0:15:0:1:Junk::1:0::0:0", -- Water-Damaged Ship Schedule
	[9251]="0:15:0:1:Junk::1:0::0:0", -- Upper Map Fragment
	[9252]="0:15:0:1:Junk::1:0::0:0", -- Lower Map Fragment
	[9253]="0:15:0:1:Junk::1:0::0:0", -- Middle Map Fragment
	[9254]="0:15:0:1:Junk::1:0::0:0", -- Cuergo's Treasure Map
	[9255]="0:12:1:1:::1:0::3:0", -- Lahassa Essence
	[9256]="0:12:1:1:::1:0::3:0", -- Imbel Essence
	[9257]="0:12:1:1:::1:0::3:0", -- Samha Essence
	[9258]="0:12:1:1:::1:0::3:0", -- Byltan Essence
	[9259]="0:12:1:20:::1:0::4:0", -- Troll Tribal Necklace
	[9260]="1600:0:1:10:FoodDrink:171:1:1:14322,37903,40832,44179:0:0", -- Volatile Rum
	[9261]="0:15:0:20:Junk::1:0::0:0", -- Lead Ore
	[9262]="0:7:1:20:Other:171:1:0::0:0", -- Black Vitriol
	[9263]="0:12:1:1:::1:0::4:0", -- Troyas' Stave
	[9264]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Shadow Power
	[9265]="0:12:2:1:::1:0::0:0", -- Cuergo's Hidden Treasure
	[9266]="0:12:1:1:::1:0::4:0", -- Woodpaw Battle Plans
	[9276]="0:15:1:1:Junk::1:0::0:0", -- Pirate's Footlocker
	[9277]="0:12:1:1:::1:0::4:0", -- Techbot's Memory Core
	[9278]="0:12:1:20:::1:0::4:0", -- Essential Artificial
	[9279]="0:12:1:1:::1:0::3:0", -- White Punch Card
	[9280]="0:12:1:1:::1:0::4:0", -- Yellow Punch Card
	[9281]="0:12:1:1:::1:0::4:0", -- Red Punch Card
	[9282]="0:12:1:1:::1:0::4:0", -- Blue Punch Card
	[9283]="0:12:1:1:::1:0::4:0", -- Empty Leaden Collection Phial
	[9284]="0:12:1:1:::1:0::4:0", -- Full Leaden Collection Phial
	[9285]="0:4:2:1:Plate::1:0::2:0", -- Field Plate Vambraces
	[9286]="0:4:2:1:Plate::1:0::2:0", -- Field Plate Armor
	[9287]="0:4:2:1:Plate::1:0::2:0", -- Field Plate Gauntlets
	[9288]="0:4:2:1:Plate::1:0::2:0", -- Field Plate Girdle
	[9289]="0:4:2:1:Plate::1:0::2:0", -- Field Plate Boots
	[9290]="0:4:2:1:Plate::1:0::2:0", -- Field Plate Helmet
	[9291]="0:4:2:1:Plate::1:0::2:0", -- Field Plate Leggings
	[9292]="0:4:2:1:Plate::1:0::2:0", -- Field Plate Pauldrons
	[9293]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Magic Resistance Potion
	[9294]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Wildvine Potion
	[9295]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Invisibility Potion
	[9296]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Gift of Arthas
	[9297]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Elixir of Dream Vision
	[9298]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Elixir of Giants
	[9299]="0:12:1:1:::1:0::4:0", -- Thermaplugg's Safe Combination
	[9300]="10000:9:1:1:Alchemy::1:1:8177,8178:0:0", -- Recipe: Elixir of Demonslaying
	[9301]="10000:9:2:1:Alchemy::1:1:1313,4610:0:0", -- Recipe: Elixir of Shadow Power
	[9302]="9000:9:1:1:Alchemy::1:1:8157,8158:0:0", -- Recipe: Ghost Dye
	[9303]="8000:9:1:1:Alchemy::1:0:5594:0:0", -- Recipe: Philosopher's Stone
	[9304]="8000:9:1:1:Alchemy::1:0:5594:0:0", -- Recipe: Transmute Iron to Gold
	[9305]="8000:9:1:1:Alchemy::1:1:5594:0:0", -- Recipe: Transmute Mithril to Truesilver
	[9306]="0:12:1:1:::1:0::4:0", -- Stave of Equinex
	[9307]="0:12:1:1:::1:0::4:0", -- A Sparkling Stone
	[9308]="0:12:1:20:::1:0::0:0", -- Grime-Encrusted Object
	[9309]="0:12:1:20:::1:0::4:0", -- Robo-Mechanical Guts
	[9311]="0:0:1:1:Other::1:0::0:0", -- Default Stationery
	[9312]="20:0:1:5:Other::1:0:8116,8117,8118,15011,15012,55278:0:0", -- Blue Firework
	[9313]="20:0:1:5:Other::1:0:8116,8117,8118,15011,15012,55278:0:0", -- Green Firework
	[9314]="50:0:1:5:Other::1:0:8116,8117,8118,15011,15012,23208,55278:0:0", -- Red Streaks Firework
	[9315]="40:0:1:5:Other::1:0:8116,8117,8118,15011,15012,55278:0:0", -- Yellow Rose Firework
	[9316]="0:12:1:1:::1:0::4:0", -- Prismatic Punch Card
	[9317]="100:0:1:5:Other::1:0:8116,8117,8118,55278:0:0", -- Red, White and Blue Firework
	[9318]="20:0:1:5:Other::1:0:8116,8117,8118,15011,15012,55278:0:0", -- Red Firework
	[9319]="0:0:1:1:Consumable::1:0::4:0", -- Nimboya's Laden Pike
	[9320]="0:12:1:20:::1:0::4:0", -- Witherbark Skull
	[9321]="0:12:1:1:::1:0::4:0", -- Venom Bottle
	[9322]="0:12:1:20:::1:0::4:0", -- Undamaged Venom Sac
	[9323]="0:12:1:1:::1:0::4:0", -- Gadrin's Parchment
	[9326]="0:12:1:1:::1:0::3:0", -- Grime-Encrusted Ring
	[9327]="0:12:2:1:::1:0::0:0", -- Security DELTA Data Access Card
	[9328]="0:12:1:1:::1:0::4:0", -- Super Snapper FX
	[9329]="0:12:1:1:::1:0::4:0", -- A Short Note
	[9330]="0:12:1:1:::1:0::4:0", -- Snapshot of Gammerita
	[9331]="0:12:1:1:::1:0::4:0", -- Feralas: A History
	[9332]="0:15:0:20:Junk::1:0::0:0", -- Crusted Bandages
	[9333]="0:4:0:20:Amulet::1:0::0:0", -- Tarnished Silver Necklace
	[9334]="0:15:0:20:Junk::1:0::0:0", -- Cracked Pottery
	[9335]="0:15:0:20:Junk::1:0::0:0", -- Broken Obsidian Club
	[9336]="0:15:0:20:Junk::1:0::0:0", -- Gold-Capped Troll Tusk
	[9355]="0:15:0:20:Junk::1:0::0:0", -- Hoop Earring
	[9356]="0:15:0:20:Junk::1:0::0:0", -- A Wooden Leg
	[9357]="0:15:0:20:Junk::1:0::0:0", -- A Parrot Skeleton
	[9358]="0:15:0:20:Junk::1:0::0:0", -- A Head Rag
	[9359]="0:2:3:1:OneHandMace::1:0::2:0", -- Wirt's Third Leg
	[9360]="0:0:1:1:FoodDrink::1:0::0:0", -- Cuergo's Gold
	[9361]="0:0:1:1:FoodDrink::1:0::0:0", -- Cuergo's Gold with Worm
	[9362]="0:4:2:1:Ring::1:0::3:0", -- Brilliant Gold Ring
	[9363]="0:15:1:1:Junk::1:0::3:0", -- Sparklematic-Wrapped Box
	[9364]="0:12:1:1:::1:0::4:0", -- Heavy Leaden Collection Phial
	[9365]="0:12:1:1:::1:0::4:0", -- High Potency Radioactive Fallout
	[9366]="0:4:2:1:Mail::1:0::2:0", -- Golden Scale Gauntlets
	[9367]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Golden Scale Gauntlets
	[9368]="0:12:1:1:::1:0::4:0", -- Jer'kai's Signet Ring
	[9369]="0:12:1:20:::1:0::4:0", -- Iridescent Sprite Darter Wing
	[9370]="0:12:1:1:::1:0::3:0", -- Gordunni Scroll
	[9371]="0:12:1:1:::1:0::4:0", -- Gordunni Orb
	[9372]="0:2:4:1:TwoHandSword::1:0::3:0", -- Sul'thraze the Lasher
	[9375]="0:4:3:1:Leather::1:0::2:0", -- Expert Goldminer's Helmet
	[9378]="0:2:3:1:OneHandAxe::1:0::2:0", -- Shovelphlange's Mining Axe
	[9379]="0:2:3:1:OneHandSword::1:0::3:0", -- Sang'thraze the Deflector
	[9381]="0:2:3:1:Wand::1:0::2:0", -- Earthen Rod
	[9382]="0:4:2:1:Leather::1:0::2:0", -- Tromping Miner's Boots
	[9383]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Obsidian Cleaver
	[9384]="0:2:3:1:Dagger::1:0::2:0", -- Stonevault Shiv
	[9385]="0:2:3:1:TwoHandSword::1:0::2:0", -- Archaic Defender
	[9386]="0:2:3:1:OneHandMace::1:0::2:0", -- Excavator's Brand
	[9387]="0:4:3:1:Mail::1:0::3:0", -- Revelosh's Boots
	[9388]="0:4:3:1:Mail::1:0::3:0", -- Revelosh's Armguards
	[9389]="0:4:3:1:Leather::1:0::3:0", -- Revelosh's Spaulders
	[9390]="0:4:3:1:Cloth::1:0::3:0", -- Revelosh's Gloves
	[9391]="0:2:3:1:TwoHandMace::1:0::2:0", -- The Shoveler
	[9392]="0:2:3:1:OneHandSword::1:0::2:0", -- Annealed Blade
	[9393]="0:4:3:1:OffHandFrill::1:0::2:0", -- Beacon of Hope
	[9394]="0:4:3:1:Mail::1:0::3:0", -- Horned Viking Helmet
	[9395]="0:4:3:1:Cloth::1:0::2:0", -- Gloves of Old
	[9396]="0:4:3:1:Mail::1:0::2:0", -- Legguards of the Vault
	[9397]="0:4:3:1:Cloak::1:0::2:0", -- Energy Cloak
	[9398]="0:4:3:1:Leather::1:0::3:0", -- Worn Running Boots
	[9399]="0:15:0:1000:Junk::1:0::0:0", -- Precision Arrow
	[9400]="0:2:3:1:Bow::1:0::3:0", -- Baelog's Shortbow
	[9401]="0:2:3:1:OneHandSword::1:0::3:0", -- Nordic Longshank
	[9402]="0:4:3:1:Leather::1:0::2:0", -- Earthborn Kilt
	[9403]="0:4:3:1:Shield::1:0::3:0", -- Battered Viking Shield
	[9404]="0:4:3:1:Shield::1:0::3:0", -- Olaf's All Purpose Shield
	[9405]="0:4:3:1:Mail::1:0::2:0", -- Girdle of Golem Strength
	[9406]="0:4:3:1:Leather::1:0::2:0", -- Spirewind Fetter
	[9407]="0:4:3:1:Cloth::1:0::3:0", -- Stoneweaver Leggings
	[9408]="0:2:3:1:Stave::1:0::3:0", -- Ironshod Bludgeon
	[9409]="0:4:3:1:Mail::1:0::3:0", -- Ironaya's Bracers
	[9410]="0:4:3:1:Mail::1:0::3:0", -- Cragfists
	[9411]="0:4:3:1:Leather::1:0::3:0", -- Rockshard Pauldrons
	[9412]="0:2:3:1:Gun::1:0::3:0", -- Galgann's Fireblaster
	[9413]="0:2:3:1:TwoHandMace::1:0::3:0", -- The Rockpounder
	[9414]="0:4:3:1:Leather::1:0::3:0", -- Oilskin Leggings
	[9415]="0:4:3:1:Cloth::1:0::3:0", -- Grimlok's Tribal Vestments
	[9416]="0:2:3:1:Polearm::1:0::3:0", -- Grimlok's Charge
	[9418]="0:2:3:1:TwoHandSword::1:0::3:0", -- Stoneslayer
	[9419]="0:2:3:1:OneHandMace::1:0::3:0", -- Galgann's Firehammer
	[9420]="0:4:3:1:Leather::1:0::2:0", -- Adventurer's Pith Helmet
	[9421]="0:0:1:1:Other::1:0::0:0", -- Major Healthstone
	[9422]="0:2:3:1:Gun::1:0::2:0", -- Shadowforge Bushmaster
	[9423]="0:2:3:1:TwoHandMace::1:0::2:0", -- The Jackhammer
	[9424]="0:2:3:1:OneHandSword::1:0::2:0", -- Ginn-Su Sword
	[9425]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Pendulum of Doom
	[9426]="0:2:3:1:Bow::1:0::2:0", -- Monolithic Bow
	[9427]="0:2:3:1:OneHandMace::1:0::2:0", -- Stonevault Bonebreaker
	[9428]="0:4:3:1:Leather::1:0::2:0", -- Unearthed Bands
	[9429]="0:4:3:1:Cloth::1:0::2:0", -- Miner's Hat of the Deep
	[9430]="0:4:3:1:Leather::1:0::2:0", -- Spaulders of a Lost Age
	[9431]="0:4:3:1:Cloth::1:0::2:0", -- Papal Fez
	[9432]="0:4:3:1:Mail::1:0::2:0", -- Skullplate Bracers
	[9433]="0:4:3:1:Cloth::1:0::2:0", -- Forgotten Wraps
	[9434]="0:4:3:1:Cloth::1:0::2:0", -- Elemental Raiment
	[9435]="0:4:3:1:Mail::1:0::2:0", -- Reticulated Bone Gauntlets
	[9436]="0:12:1:1:::1:0::4:0", -- Faranell's Parcel
	[9437]="0:12:1:20:::1:0::4:0", -- Untested Basilisk Sample
	[9438]="0:12:1:20:::1:0::4:0", -- Acceptable Scorpid Sample
	[9439]="0:12:1:20:::1:0::4:0", -- Untested Hyena Sample
	[9440]="0:12:1:20:::1:0::4:0", -- Acceptable Basilisk Sample
	[9441]="0:12:1:20:::1:0::4:0", -- Acceptable Hyena Sample
	[9442]="0:12:1:20:::1:0::4:0", -- Untested Scorpid Sample
	[9444]="0:4:1:1:Shield::1:0::0:0", -- Techbot CPU Shell
	[9445]="0:4:3:1:Mail::1:0::3:0", -- Grubbis Paws
	[9446]="0:2:3:1:OneHandSword::1:0::3:0", -- Electrocutioner Leg
	[9447]="0:4:3:1:Ring::1:0::3:0", -- Electrocutioner Lagnut
	[9448]="0:4:3:1:Cloth::1:0::3:0", -- Spidertank Oilrag
	[9449]="0:2:3:1:TwoHandMace::1:0::3:0", -- Manual Crowd Pummeler
	[9450]="0:4:3:1:Leather::1:0::3:0", -- Gnomebot Operating Boots
	[9451]="0:0:1:20:FoodDrink::1:0::0:0", -- Bubbling Water
	[9452]="0:2:3:1:Stave::1:0::3:0", -- Hydrocane
	[9453]="0:2:3:1:Dagger::1:0::3:0", -- Toxic Revenger
	[9454]="0:4:3:1:Cloth::1:0::3:0", -- Acidic Walkers
	[9455]="0:4:3:1:Leather::1:0::3:0", -- Emissary Cuffs
	[9456]="0:2:3:1:Gun::1:0::3:0", -- Glass Shooter
	[9457]="0:2:3:1:OneHandMace::1:0::3:0", -- Royal Diplomatic Scepter
	[9458]="0:4:3:1:Shield::1:0::3:0", -- Thermaplugg's Central Core
	[9459]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Thermaplugg's Left Arm
	[9460]="0:12:1:20:::1:0::4:0", -- Grimtotem Horn
	[9461]="0:4:3:1:Ring::1:0::3:0", -- Charged Gear
	[9462]="0:12:1:1:::1:0::4:0", -- Crate of Grimtotem Horns
	[9463]="0:12:1:20:::1:0::4:0", -- Gordunni Cobalt
	[9465]="0:2:3:1:OneHandAxe::1:0::2:0", -- Digmaster 5000
	[9466]="0:12:1:1:::1:0::4:0", -- Orwin's Shovel
	[9467]="0:2:3:1:Dagger::1:0::3:0", -- Gahz'rilla Fang
	[9468]="0:12:1:1:::1:0::4:0", -- Sharpbeak's Feather
	[9469]="0:4:3:1:Mail::1:0::3:0", -- Gahz'rilla Scale Armor
	[9470]="0:4:3:1:Cloth::1:0::3:0", -- Bad Mojo Mask
	[9471]="0:12:1:1:::1:0::4:0", -- Nekrum's Medallion
	[9473]="0:4:3:1:Leather::1:0::3:0", -- Jinxed Hoodoo Skin
	[9474]="0:4:3:1:Leather::1:0::3:0", -- Jinxed Hoodoo Kilt
	[9475]="0:2:3:1:Polearm::1:0::3:0", -- Diabolic Skiver
	[9476]="0:4:3:1:Plate::1:0::3:0", -- Big Bad Pauldrons
	[9477]="0:2:3:1:Stave::1:0::3:0", -- The Chief's Enforcer
	[9478]="0:2:3:1:OneHandAxe::1:0::3:0", -- Ripsaw
	[9479]="0:4:3:1:Leather::1:0::3:0", -- Embrace of the Lycan
	[9480]="0:2:3:1:Polearm::1:0::2:0", -- Eyegouger
	[9481]="0:2:3:1:TwoHandAxe::1:0::2:0", -- The Minotaur
	[9482]="0:2:3:1:Stave::1:0::2:0", -- Witch Doctor's Cane
	[9483]="0:2:3:1:Wand::1:0::2:0", -- Flaming Incinerator
	[9484]="0:4:3:1:Cloth::1:0::2:0", -- Spellshock Leggings
	[9485]="0:2:3:1:OneHandAxe::1:0::2:0", -- Vibroblade
	[9486]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Supercharger Battle Axe
	[9487]="0:2:3:1:Gun::1:0::2:0", -- Hi-Tech Supergun
	[9488]="0:2:3:1:OneHandMace::1:0::2:0", -- Oscillating Power Hammer
	[9489]="0:2:2:1:Wand::1:0::3:0", -- Gyromatic Icemaker
	[9490]="0:2:3:1:TwoHandSword::1:0::2:0", -- Gizmotron Megachopper
	[9491]="0:4:3:1:Cloth::1:0::2:0", -- Hotshot Pilot's Gloves
	[9492]="0:4:3:1:Cloth::1:0::3:0", -- Electromagnetic Gigaflux Reactivator
	[9507]="0:12:1:1:::1:0::4:0", -- A Carefully-Packed Crate
	[9508]="0:4:3:1:Cloth::1:0::2:0", -- Mechbuilder's Overalls
	[9509]="0:4:3:1:Leather::1:0::2:0", -- Petrolspill Leggings
	[9510]="0:4:3:1:Mail::1:0::2:0", -- Caverndeep Trudgers
	[9511]="0:2:3:1:OneHandSword::1:0::2:0", -- Bloodletter Scalpel
	[9512]="0:4:3:1:Cloak::1:0::2:0", -- Blackmetal Cape
	[9513]="0:2:2:1:Stave::1:0::3:0", -- Ley Staff
	[9514]="0:2:2:1:Stave::1:0::3:0", -- Arcane Staff
	[9515]="0:4:2:1:Cloth::1:0::3:0", -- Nether-Lace Tunic
	[9516]="0:4:2:1:Cloth::1:0::3:0", -- Astral Knot Blouse
	[9517]="0:2:3:1:Stave::1:0::3:0", -- Celestial Stave
	[9518]="0:4:2:1:Leather::1:0::3:0", -- Mud's Crushers
	[9519]="0:4:2:1:Cloth::1:0::3:0", -- Durtfeet Stompers
	[9520]="0:2:2:1:Dagger::1:0::3:0", -- Silent Hunter
	[9521]="0:2:2:1:TwoHandAxe::1:0::3:0", -- Skullsplitter
	[9522]="0:4:2:1:Shield::1:0::3:0", -- Energized Stone Circle
	[9523]="0:12:1:20:::1:0::4:0", -- Troll Temper
	[9527]="0:2:3:1:Stave::1:0::3:0", -- Spellshifter Rod
	[9528]="0:12:1:1:::1:0::4:0", -- Edana's Dark Heart
	[9530]="0:12:1:1:::1:0::4:0", -- Horn of Hatetalon
	[9531]="0:4:3:1:Plate::1:0::3:0", -- Gemshale Pauldrons
	[9533]="0:4:3:1:Ring::1:0::3:0", -- Masons Fraternity Ring
	[9534]="0:4:3:1:Leather::1:0::3:0", -- Engineer's Guild Headpiece
	[9535]="0:4:2:1:Mail::1:0::3:0", -- Fire-Welded Bracers
	[9536]="0:4:2:1:Cloth::1:0::3:0", -- Fairywing Mantle
	[9538]="0:4:3:1:Ring::1:0::3:0", -- Talvash's Gold Ring
	[9539]="0:15:1:1:Junk::1:0::0:0", -- Box of Rations
	[9540]="0:15:1:1:Junk::1:0::0:0", -- Box of Spells
	[9541]="0:15:1:1:Junk::1:0::0:0", -- Box of Goodies
	[9542]="0:12:1:1:::1:0::4:0", -- Simple Letter
	[9543]="0:12:1:1:::1:0::4:0", -- Simple Rune
	[9544]="0:12:1:1:::1:0::4:0", -- Simple Memorandum
	[9545]="0:12:1:1:::1:0::4:0", -- Simple Sigil
	[9546]="0:0:1:1:Consumable::1:0::4:0", -- Simple Scroll
	[9547]="0:12:1:1:::1:0::4:0", -- Simple Note
	[9548]="0:12:1:1:::1:0::4:0", -- Hallowed Letter
	[9550]="0:12:1:1:::1:0::4:0", -- Encrypted Rune
	[9551]="0:12:1:1:::1:0::4:0", -- Encrypted Sigil
	[9552]="0:12:1:1:::1:0::4:0", -- Rune-Inscribed Note
	[9553]="0:12:1:1:::1:0::4:0", -- Etched Parchment
	[9554]="0:12:1:1:::1:0::4:0", -- Encrypted Tablet
	[9555]="0:12:1:1:::1:0::4:0", -- Encrypted Letter
	[9556]="0:12:1:1:::1:0::4:0", -- Hallowed Rune
	[9557]="0:12:1:1:::1:0::4:0", -- Hallowed Sigil
	[9558]="0:12:1:1:::1:0::4:0", -- Encrypted Memorandum
	[9559]="0:12:1:1:::1:0::4:0", -- Encrypted Scroll
	[9560]="0:12:1:1:::1:0::4:0", -- Encrypted Parchment
	[9561]="0:12:1:1:::1:0::4:0", -- Hallowed Tablet
	[9562]="0:12:1:1:::1:0::4:0", -- Rune-Inscribed Tablet
	[9563]="0:12:1:1:::1:0::4:0", -- Consecrated Rune
	[9564]="0:12:1:1:::1:0::4:0", -- Etched Tablet
	[9565]="0:12:1:1:::1:0::4:0", -- Etched Note
	[9566]="0:12:1:1:::1:0::4:0", -- Etched Rune
	[9567]="0:12:1:1:::1:0::4:0", -- Etched Sigil
	[9568]="0:12:1:1:::1:0::4:0", -- Rune-Inscribed Parchment
	[9569]="0:0:1:1:Consumable::1:0::4:0", -- Hallowed Scroll
	[9570]="0:12:1:1:::1:0::4:0", -- Consecrated Letter
	[9571]="0:12:1:1:::1:0::4:0", -- Glyphic Letter
	[9573]="0:12:1:1:::1:0::4:0", -- Glyphic Memorandum
	[9574]="0:12:1:1:::1:0::4:0", -- Glyphic Scroll
	[9575]="0:12:1:1:::1:0::4:0", -- Glyphic Tablet
	[9576]="0:12:1:1:::1:0::4:0", -- Tainted Letter
	[9577]="0:12:1:1:::1:0::4:0", -- Tainted Rune
	[9578]="0:12:1:1:::1:0::4:0", -- Tainted Scroll
	[9579]="0:12:1:1:::1:0::4:0", -- Tainted Parchment
	[9580]="0:12:1:1:::1:0::4:0", -- Verdant Sigil
	[9581]="0:12:1:1:::1:0::4:0", -- Verdant Note
	[9587]="0:1:2:1:Bag::1:0::3:0", -- Thawpelt Sack
	[9588]="0:4:3:1:Ring::1:0::3:0", -- Nogg's Gold Ring
	[9589]="0:12:1:20:::1:0::4:0", -- Encrusted Minerals
	[9590]="0:12:1:2:::1:0::4:0", -- Splintered Log
	[9591]="0:12:1:20:::1:0::4:0", -- Resilient Sinew
	[9592]="0:12:1:40:::1:0::4:0", -- Metallic Fragments
	[9593]="0:12:1:20:::1:0::4:0", -- Treant Muisek
	[9594]="0:12:1:20:::1:0::4:0", -- Beast Muisek
	[9595]="0:12:1:20:::1:0::4:0", -- Hippogryph Muisek
	[9596]="0:12:1:20:::1:0::4:0", -- Faerie Dragon Muisek
	[9597]="0:12:1:20:::1:0::4:0", -- Mountain Giant Muisek
	[9598]="0:4:2:1:Cloth::1:0::3:0", -- Sleeping Robes
	[9599]="0:4:1:1:Mail::1:0::3:0", -- Barkmail Leggings
	[9600]="0:4:1:1:Cloth::1:0::3:0", -- Lace Pants
	[9601]="0:4:1:1:Leather::1:0::3:0", -- Cushioned Boots
	[9602]="0:2:2:1:TwoHandSword::1:0::3:0", -- Brushwood Blade
	[9603]="0:2:2:1:Stave::1:0::3:0", -- Gritroot Staff
	[9604]="0:2:2:1:TwoHandMace::1:0::3:0", -- Mechanic's Pipehammer
	[9605]="0:4:2:1:Cloak::1:0::3:0", -- Repairman's Cape
	[9606]="0:12:1:1:::1:0::4:0", -- Treant Muisek Vessel
	[9607]="0:4:2:1:Shield::1:0::3:0", -- Bastion of Stormwind
	[9608]="0:2:2:1:OneHandAxe::1:0::3:0", -- Shoni's Disarming Tool
	[9609]="0:4:2:1:Cloth::1:0::3:0", -- Shilly Mitts
	[9618]="0:12:1:1:::1:0::4:0", -- Beast Muisek Vessel
	[9619]="0:12:1:1:::1:0::4:0", -- Hippogryph Muisek Vessel
	[9620]="0:12:1:1:::1:0::4:0", -- Faerie Dragon Muisek Vessel
	[9621]="0:12:1:1:::1:0::4:0", -- Mountain Giant Muisek Vessel
	[9622]="0:4:2:1:Ring::1:0::3:0", -- Reedknot Ring
	[9623]="0:4:3:1:Cloth::1:0::3:0", -- Civinad Robes
	[9624]="0:4:3:1:Leather::1:0::3:0", -- Triprunner Dungarees
	[9625]="0:4:3:1:Mail::1:0::3:0", -- Dual Reinforced Leggings
	[9626]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Dwarven Charge
	[9627]="0:4:3:1:OffHandFrill::1:0::3:0", -- Explorers' League Lodestar
	[9628]="0:12:1:1:::1:0::4:0", -- Xerash's Herb Pouch
	[9629]="0:12:1:1:::1:0::4:0", -- A Shrunken Head
	[9630]="0:4:2:1:Leather::1:0::3:0", -- Pratt's Handcrafted Boots
	[9631]="0:4:2:1:Leather::1:0::3:0", -- Pratt's Handcrafted Gloves
	[9632]="0:4:2:1:Leather::1:0::3:0", -- Jangdor's Handcrafted Gloves
	[9633]="0:4:2:1:Leather::1:0::3:0", -- Jangdor's Handcrafted Boots
	[9634]="0:4:2:1:Cloth::1:0::3:0", -- Skilled Handling Gloves
	[9635]="0:4:2:1:Cloak::1:0::3:0", -- Master Apothecary Cape
	[9636]="0:4:2:1:Cloth::1:0::3:0", -- Swashbuckler Sash
	[9637]="0:4:2:1:Plate::1:0::3:0", -- Shinkicker Boots
	[9638]="0:4:2:1:Mail::1:0::3:0", -- Chelonian Cuffs
	[9639]="0:2:3:1:OneHandMace::1:0::3:0", -- The Hand of Antu'sul
	[9640]="0:4:3:1:Plate::1:0::3:0", -- Vice Grips
	[9641]="0:4:3:1:Amulet::1:0::3:0", -- Lifeblood Amulet
	[9642]="0:4:2:1:Ring::1:0::3:0", -- Band of the Great Tortoise
	[9643]="0:4:2:1:Shield::1:0::3:0", -- Optomatic Deflector
	[9644]="0:4:2:1:OffHandFrill::1:0::3:0", -- Thermotastic Egg Timer
	[9645]="0:4:2:1:Cloth::1:0::3:0", -- Gnomish Inventor Boots
	[9646]="0:4:2:1:Plate::1:0::3:0", -- Gnomish Water Sinking Device
	[9647]="0:4:2:1:Leather::1:0::3:0", -- Failed Flying Experiment
	[9648]="0:4:2:1:Cloak::1:0::3:0", -- Chainlink Towel
	[9649]="0:4:3:1:Cloth::1:0::3:0", -- Royal Highmark Vestments
	[9650]="0:4:3:1:Mail::1:0::3:0", -- Honorguard Chestpiece
	[9651]="0:2:3:1:OneHandMace::1:0::3:0", -- Gryphon Rider's Stormhammer
	[9652]="0:4:3:1:Leather::1:0::3:0", -- Gryphon Rider's Leggings
	[9653]="0:4:2:1:Cloth::1:0::3:0", -- Speedy Racer Goggles
	[9654]="0:2:2:1:Wand::1:0::3:0", -- Cairnstone Sliver
	[9655]="0:4:2:1:Ring::1:0::3:0", -- Seedtime Hoop
	[9656]="0:4:2:1:Plate::1:0::3:0", -- Granite Grips
	[9657]="0:4:2:1:Leather::1:0::3:0", -- Vinehedge Cinch
	[9658]="0:4:2:1:Cloth::1:0::3:0", -- Boots of the Maharishi
	[9660]="0:4:2:1:Cloak::1:0::3:0", -- Stargazer Cloak
	[9661]="0:4:2:1:Shield::1:0::3:0", -- Earthclasp Barrier
	[9662]="0:4:2:1:Plate::1:0::3:0", -- Rushridge Boots
	[9663]="0:4:2:1:Mail::1:0::3:0", -- Dawnrider's Chestpiece
	[9664]="0:4:2:1:Plate::1:0::3:0", -- Sentinel's Guard
	[9665]="0:4:2:1:Cloth::1:0::3:0", -- Wingcrest Gloves
	[9666]="0:4:2:1:Mail::1:0::3:0", -- Stronghorn Girdle
	[9678]="0:2:2:1:TwoHandMace::1:0::3:0", -- Tok'kar's Murloc Basher
	[9679]="0:2:2:1:TwoHandAxe::1:0::3:0", -- Tok'kar's Murloc Chopper
	[9680]="0:2:2:1:Dagger::1:0::3:0", -- Tok'kar's Murloc Shanker
	[9681]="0:0:1:20:FoodDrink::1:0::0:0", -- Grilled King Crawler Legs
	[9682]="0:4:2:1:Leather::1:0::3:0", -- Leather Chef's Belt
	[9683]="0:2:3:1:Stave::1:0::3:0", -- Strength of the Treant
	[9684]="0:2:3:1:OneHandAxe::1:0::3:0", -- Force of the Hippogryph
	[9686]="0:2:3:1:OneHandMace::1:0::3:0", -- Spirit of the Faerie Dragon
	[9687]="0:4:2:1:Leather::1:0::3:0", -- Grappler's Belt
	[9698]="0:4:2:1:Leather::1:0::3:0", -- Gloves of Insight
	[9699]="0:4:2:1:Cloak::1:0::3:0", -- Garrison Cloak
	[9703]="0:4:2:1:Cloak::1:0::3:0", -- Scorched Cape
	[9704]="0:4:2:1:Leather::1:0::3:0", -- Rustler Gloves
	[9705]="0:4:2:1:Leather::1:0::3:0", -- Tharg's Shoelace
	[9706]="0:4:2:1:Shield::1:0::3:0", -- Tharg's Disk
	[9718]="0:2:3:1:OneHandSword::1:0::2:0", -- Reforged Blade of Heroes
	[9719]="0:7:3:1:Other::1:0::0:0", -- Broken Blade of Heroes
	[9738]="0:12:1:20:::1:0::4:0", -- Gem of Cobrahn
	[9739]="0:12:1:20:::1:0::4:0", -- Gem of Anacondra
	[9740]="0:12:1:20:::1:0::4:0", -- Gem of Pythas
	[9741]="0:12:1:20:::1:0::4:0", -- Gem of Serpentis
	[9742]="0:4:1:1:Cloth::1:0::0:0", -- Simple Cord
	[9743]="0:4:1:1:Cloth::1:0::0:0", -- Simple Shoes
	[9744]="0:4:1:1:Cloth::1:0::0:0", -- Simple Bands
	[9745]="0:4:1:1:Cloak::1:0::0:0", -- Simple Cape
	[9746]="0:4:1:1:Cloth::1:0::0:0", -- Simple Gloves
	[9747]="0:4:2:1:Cloth::1:0::2:0", -- Simple Britches
	[9748]="0:4:2:1:Cloth::1:0::2:0", -- Simple Robe
	[9749]="0:4:2:1:Cloth::1:0::2:0", -- Simple Blouse
	[9750]="0:4:1:1:Leather::1:0::0:0", -- Gypsy Sash
	[9751]="0:4:1:1:Leather::1:0::0:0", -- Gypsy Sandals
	[9752]="0:4:1:1:Leather::1:0::0:0", -- Gypsy Bands
	[9753]="0:4:2:1:Shield::1:0::2:0", -- Gypsy Buckler
	[9754]="0:4:1:1:Cloak::1:0::0:0", -- Gypsy Cloak
	[9755]="0:4:1:1:Leather::1:0::0:0", -- Gypsy Gloves
	[9756]="0:4:2:1:Leather::1:0::2:0", -- Gypsy Trousers
	[9757]="0:4:2:1:Leather::1:0::2:0", -- Gypsy Tunic
	[9758]="0:4:1:1:Mail::1:0::0:0", -- Cadet Belt
	[9759]="0:4:1:1:Mail::1:0::0:0", -- Cadet Boots
	[9760]="0:4:1:1:Mail::1:0::0:0", -- Cadet Bracers
	[9761]="0:4:1:1:Cloak::1:0::0:0", -- Cadet Cloak
	[9762]="0:4:1:1:Mail::1:0::0:0", -- Cadet Gauntlets
	[9763]="0:4:2:1:Mail::1:0::2:0", -- Cadet Leggings
	[9764]="0:4:2:1:Shield::1:0::2:0", -- Cadet Shield
	[9765]="0:4:2:1:Mail::1:0::2:0", -- Cadet Vest
	[9766]="0:4:2:1:Cloth::1:0::2:0", -- Greenweave Sash
	[9767]="0:4:2:1:Cloth::1:0::2:0", -- Greenweave Sandals
	[9768]="0:4:2:1:Cloth::1:0::2:0", -- Greenweave Bracers
	[9769]="0:4:2:1:OffHandFrill::1:0::2:0", -- Greenweave Branch
	[9770]="0:4:2:1:Cloak::1:0::2:0", -- Greenweave Cloak
	[9771]="0:4:2:1:Cloth::1:0::2:0", -- Greenweave Gloves
	[9772]="0:4:2:1:Cloth::1:0::2:0", -- Greenweave Leggings
	[9773]="0:4:2:1:Cloth::1:0::2:0", -- Greenweave Robe
	[9774]="0:4:2:1:Cloth::1:0::2:0", -- Greenweave Vest
	[9775]="0:4:2:1:Leather::1:0::2:0", -- Bandit Cinch
	[9776]="0:4:2:1:Leather::1:0::2:0", -- Bandit Boots
	[9777]="0:4:2:1:Leather::1:0::2:0", -- Bandit Bracers
	[9778]="0:4:2:1:Shield::1:0::2:0", -- Bandit Buckler
	[9779]="0:4:2:1:Cloak::1:0::2:0", -- Bandit Cloak
	[9780]="0:4:2:1:Leather::1:0::2:0", -- Bandit Gloves
	[9781]="0:4:2:1:Leather::1:0::2:0", -- Bandit Pants
	[9782]="0:4:2:1:Leather::1:0::2:0", -- Bandit Jerkin
	[9783]="0:4:2:1:Mail::1:0::2:0", -- Raider's Chestpiece
	[9784]="0:4:2:1:Mail::1:0::2:0", -- Raider's Boots
	[9785]="0:4:2:1:Mail::1:0::2:0", -- Raider's Bracers
	[9786]="0:4:2:1:Cloak::1:0::2:0", -- Raider's Cloak
	[9787]="0:4:2:1:Mail::1:0::2:0", -- Raider's Gauntlets
	[9788]="0:4:2:1:Mail::1:0::2:0", -- Raider's Belt
	[9789]="0:4:2:1:Mail::1:0::2:0", -- Raider's Legguards
	[9790]="0:4:2:1:Shield::1:0::2:0", -- Raider's Shield
	[9791]="0:4:2:1:Cloth::1:0::2:0", -- Ivycloth Tunic
	[9792]="0:4:2:1:Cloth::1:0::2:0", -- Ivycloth Boots
	[9793]="0:4:2:1:Cloth::1:0::2:0", -- Ivycloth Bracelets
	[9794]="0:4:2:1:Cloak::1:0::2:0", -- Ivycloth Cloak
	[9795]="0:4:2:1:Cloth::1:0::2:0", -- Ivycloth Gloves
	[9796]="0:4:2:1:Cloth::1:0::2:0", -- Ivycloth Mantle
	[9797]="0:4:2:1:Cloth::1:0::2:0", -- Ivycloth Pants
	[9798]="0:4:2:1:Cloth::1:0::2:0", -- Ivycloth Robe
	[9799]="0:4:2:1:Cloth::1:0::2:0", -- Ivycloth Sash
	[9800]="0:4:2:1:OffHandFrill::1:0::2:0", -- Ivy Orb
	[9801]="0:4:2:1:Leather::1:0::2:0", -- Superior Belt
	[9802]="0:4:2:1:Leather::1:0::2:0", -- Superior Boots
	[9803]="0:4:2:1:Leather::1:0::2:0", -- Superior Bracers
	[9804]="0:4:2:1:Shield::1:0::2:0", -- Superior Buckler
	[9805]="0:4:2:1:Cloak::1:0::2:0", -- Superior Cloak
	[9806]="0:4:2:1:Leather::1:0::2:0", -- Superior Gloves
	[9807]="0:4:2:1:Leather::1:0::2:0", -- Superior Shoulders
	[9808]="0:4:2:1:Leather::1:0::2:0", -- Superior Leggings
	[9809]="0:4:2:1:Leather::1:0::2:0", -- Superior Tunic
	[9810]="0:4:2:1:Mail::1:0::2:0", -- Fortified Boots
	[9811]="0:4:2:1:Mail::1:0::2:0", -- Fortified Bracers
	[9812]="0:4:2:1:Cloak::1:0::2:0", -- Fortified Cloak
	[9813]="0:4:2:1:Mail::1:0::2:0", -- Fortified Gauntlets
	[9814]="0:4:2:1:Mail::1:0::2:0", -- Fortified Belt
	[9815]="0:4:2:1:Mail::1:0::2:0", -- Fortified Leggings
	[9816]="0:4:2:1:Shield::1:0::2:0", -- Fortified Shield
	[9817]="0:4:2:1:Mail::1:0::2:0", -- Fortified Spaulders
	[9818]="0:4:2:1:Mail::1:0::2:0", -- Fortified Chain
	[9819]="0:4:2:1:Cloth::1:0::2:0", -- Durable Tunic
	[9820]="0:4:2:1:Cloth::1:0::2:0", -- Durable Boots
	[9821]="0:4:2:1:Cloth::1:0::2:0", -- Durable Bracers
	[9822]="0:4:2:1:Cloak::1:0::2:0", -- Durable Cape
	[9823]="0:4:2:1:Cloth::1:0::2:0", -- Durable Gloves
	[9824]="0:4:2:1:Cloth::1:0::2:0", -- Durable Shoulders
	[9825]="0:4:2:1:Cloth::1:0::2:0", -- Durable Pants
	[9826]="0:4:2:1:Cloth::1:0::2:0", -- Durable Robe
	[9827]="0:4:2:1:Leather::1:0::2:0", -- Scaled Leather Belt
	[9828]="0:4:2:1:Leather::1:0::2:0", -- Scaled Leather Boots
	[9829]="0:4:2:1:Leather::1:0::2:0", -- Scaled Leather Bracers
	[9830]="0:4:2:1:Shield::1:0::2:0", -- Scaled Shield
	[9831]="0:4:2:1:Cloak::1:0::2:0", -- Scaled Cloak
	[9832]="0:4:2:1:Leather::1:0::2:0", -- Scaled Leather Gloves
	[9833]="0:4:2:1:Leather::1:0::2:0", -- Scaled Leather Leggings
	[9834]="0:4:2:1:Leather::1:0::2:0", -- Scaled Leather Shoulders
	[9835]="0:4:2:1:Leather::1:0::2:0", -- Scaled Leather Tunic
	[9836]="0:4:2:1:Mail::1:0::2:0", -- Banded Armor
	[9837]="0:4:2:1:Mail::1:0::2:0", -- Banded Bracers
	[9838]="0:4:2:1:Cloak::1:0::2:0", -- Banded Cloak
	[9839]="0:4:2:1:Mail::1:0::2:0", -- Banded Gauntlets
	[9840]="0:4:2:1:Mail::1:0::2:0", -- Banded Girdle
	[9841]="0:4:2:1:Mail::1:0::2:0", -- Banded Leggings
	[9842]="0:4:2:1:Mail::1:0::2:0", -- Banded Pauldrons
	[9843]="0:4:2:1:Shield::1:0::2:0", -- Banded Shield
	[9844]="0:4:2:1:Cloth::1:0::2:0", -- Conjurer's Vest
	[9845]="0:4:2:1:Cloth::1:0::2:0", -- Conjurer's Shoes
	[9846]="0:4:2:1:Cloth::1:0::2:0", -- Conjurer's Bracers
	[9847]="0:4:2:1:Cloak::1:0::2:0", -- Conjurer's Cloak
	[9848]="0:4:2:1:Cloth::1:0::2:0", -- Conjurer's Gloves
	[9849]="0:4:2:1:Cloth::1:0::2:0", -- Conjurer's Hood
	[9850]="0:4:2:1:Cloth::1:0::2:0", -- Conjurer's Mantle
	[9851]="0:4:2:1:Cloth::1:0::2:0", -- Conjurer's Breeches
	[9852]="0:4:2:1:Cloth::1:0::2:0", -- Conjurer's Robe
	[9853]="0:4:2:1:Cloth::1:0::2:0", -- Conjurer's Cinch
	[9854]="0:4:2:1:Leather::1:0::2:0", -- Archer's Jerkin
	[9855]="0:4:2:1:Leather::1:0::2:0", -- Archer's Belt
	[9856]="0:4:2:1:Leather::1:0::2:0", -- Archer's Boots
	[9857]="0:4:2:1:Leather::1:0::2:0", -- Archer's Bracers
	[9858]="0:4:2:1:Shield::1:0::2:0", -- Archer's Buckler
	[9859]="0:4:2:1:Leather::1:0::2:0", -- Archer's Cap
	[9860]="0:4:2:1:Cloak::1:0::2:0", -- Archer's Cloak
	[9861]="0:4:2:1:Leather::1:0::2:0", -- Archer's Gloves
	[9862]="0:4:2:1:Leather::1:0::2:0", -- Archer's Trousers
	[9863]="0:4:2:1:Leather::1:0::2:0", -- Archer's Shoulderpads
	[9864]="0:4:2:1:Mail::1:0::2:0", -- Renegade Boots
	[9865]="0:4:2:1:Mail::1:0::2:0", -- Renegade Bracers
	[9866]="0:4:2:1:Mail::1:0::2:0", -- Renegade Chestguard
	[9867]="0:4:2:1:Cloak::1:0::2:0", -- Renegade Cloak
	[9868]="0:4:2:1:Mail::1:0::2:0", -- Renegade Gauntlets
	[9869]="0:4:2:1:Mail::1:0::2:0", -- Renegade Belt
	[9870]="0:4:2:1:Mail::1:0::2:0", -- Renegade Circlet
	[9871]="0:4:2:1:Mail::1:0::2:0", -- Renegade Leggings
	[9872]="0:4:2:1:Mail::1:0::2:0", -- Renegade Pauldrons
	[9873]="0:4:2:1:Shield::1:0::2:0", -- Renegade Shield
	[9874]="0:4:2:1:Cloth::1:0::2:0", -- Sorcerer Drape
	[9875]="0:4:2:1:Cloth::1:0::2:0", -- Sorcerer Sash
	[9876]="0:4:2:1:Cloth::1:0::2:0", -- Sorcerer Slippers
	[9877]="0:4:2:1:Cloak::1:0::2:0", -- Sorcerer Cloak
	[9878]="0:4:2:1:Cloth::1:0::2:0", -- Sorcerer Hat
	[9879]="0:4:2:1:Cloth::1:0::2:0", -- Sorcerer Bracelets
	[9880]="0:4:2:1:Cloth::1:0::2:0", -- Sorcerer Gloves
	[9881]="0:4:2:1:Cloth::1:0::2:0", -- Sorcerer Mantle
	[9882]="0:4:2:1:OffHandFrill::1:0::2:0", -- Sorcerer Sphere
	[9883]="0:4:2:1:Cloth::1:0::2:0", -- Sorcerer Pants
	[9884]="0:4:2:1:Cloth::1:0::2:0", -- Sorcerer Robe
	[9885]="0:4:2:1:Leather::1:0::2:0", -- Huntsman's Boots
	[9886]="0:4:2:1:Leather::1:0::2:0", -- Huntsman's Bands
	[9887]="0:4:2:1:Leather::1:0::2:0", -- Huntsman's Armor
	[9889]="0:4:2:1:Leather::1:0::2:0", -- Huntsman's Cap
	[9890]="0:4:2:1:Cloak::1:0::2:0", -- Huntsman's Cape
	[9891]="0:4:2:1:Leather::1:0::2:0", -- Huntsman's Belt
	[9892]="0:4:2:1:Leather::1:0::2:0", -- Huntsman's Gloves
	[9893]="0:4:2:1:Leather::1:0::2:0", -- Huntsman's Leggings
	[9894]="0:4:2:1:Leather::1:0::2:0", -- Huntsman's Shoulders
	[9895]="0:4:2:1:Mail::1:0::2:0", -- Jazeraint Boots
	[9896]="0:4:2:1:Mail::1:0::2:0", -- Jazeraint Bracers
	[9897]="0:4:2:1:Mail::1:0::2:0", -- Jazeraint Chestguard
	[9898]="0:4:2:1:Cloak::1:0::2:0", -- Jazeraint Cloak
	[9899]="0:4:2:1:Shield::1:0::2:0", -- Jazeraint Shield
	[9900]="0:4:2:1:Mail::1:0::2:0", -- Jazeraint Gauntlets
	[9901]="0:4:2:1:Mail::1:0::2:0", -- Jazeraint Belt
	[9902]="0:4:2:1:Mail::1:0::2:0", -- Jazeraint Helm
	[9903]="0:4:2:1:Mail::1:0::2:0", -- Jazeraint Leggings
	[9904]="0:4:2:1:Mail::1:0::2:0", -- Jazeraint Pauldrons
	[9905]="0:4:2:1:Cloth::1:0::2:0", -- Royal Blouse
	[9906]="0:4:2:1:Cloth::1:0::2:0", -- Royal Sash
	[9907]="0:4:2:1:Cloth::1:0::2:0", -- Royal Boots
	[9908]="0:4:2:1:Cloak::1:0::2:0", -- Royal Cape
	[9909]="0:4:2:1:Cloth::1:0::2:0", -- Royal Bands
	[9910]="0:4:2:1:Cloth::1:0::2:0", -- Royal Gloves
	[9911]="0:4:2:1:Cloth::1:0::2:0", -- Royal Trousers
	[9912]="0:4:2:1:Cloth::1:0::2:0", -- Royal Amice
	[9913]="0:4:2:1:Cloth::1:0::2:0", -- Royal Gown
	[9914]="0:4:2:1:OffHandFrill::1:0::2:0", -- Royal Scepter
	[9915]="0:4:2:1:Cloth::1:0::2:0", -- Royal Headband
	[9916]="0:4:2:1:Leather::1:0::2:0", -- Tracker's Belt
	[9917]="0:4:2:1:Leather::1:0::2:0", -- Tracker's Boots
	[9918]="0:4:2:1:Shield::1:0::2:0", -- Brigade Defender
	[9919]="0:4:2:1:Cloak::1:0::2:0", -- Tracker's Cloak
	[9920]="0:4:2:1:Leather::1:0::2:0", -- Tracker's Gloves
	[9921]="0:4:2:1:Leather::1:0::2:0", -- Tracker's Headband
	[9922]="0:4:2:1:Leather::1:0::2:0", -- Tracker's Leggings
	[9923]="0:4:2:1:Leather::1:0::2:0", -- Tracker's Shoulderpads
	[9924]="0:4:2:1:Leather::1:0::2:0", -- Tracker's Tunic
	[9925]="0:4:2:1:Leather::1:0::2:0", -- Tracker's Wristguards
	[9926]="0:4:2:1:Mail::1:0::2:0", -- Brigade Boots
	[9927]="0:4:2:1:Mail::1:0::2:0", -- Brigade Bracers
	[9928]="0:4:2:1:Mail::1:0::2:0", -- Brigade Breastplate
	[9929]="0:4:2:1:Cloak::1:0::2:0", -- Brigade Cloak
	[9930]="0:4:2:1:Mail::1:0::2:0", -- Brigade Gauntlets
	[9931]="0:4:2:1:Mail::1:0::2:0", -- Brigade Girdle
	[9932]="0:4:2:1:Mail::1:0::2:0", -- Brigade Circlet
	[9933]="0:4:2:1:Mail::1:0::2:0", -- Brigade Leggings
	[9934]="0:4:2:1:Mail::1:0::2:0", -- Brigade Pauldrons
	[9935]="0:4:2:1:Shield::1:0::2:0", -- Embossed Plate Shield
	[9936]="0:4:2:1:Cloth::1:0::2:0", -- Abjurer's Boots
	[9937]="0:4:2:1:Cloth::1:0::2:0", -- Abjurer's Bands
	[9938]="0:4:2:1:Cloak::1:0::2:0", -- Abjurer's Cloak
	[9939]="0:4:2:1:Cloth::1:0::2:0", -- Abjurer's Gloves
	[9940]="0:4:2:1:Cloth::1:0::2:0", -- Abjurer's Hood
	[9941]="0:4:2:1:Cloth::1:0::2:0", -- Abjurer's Mantle
	[9942]="0:4:2:1:Cloth::1:0::2:0", -- Abjurer's Pants
	[9943]="0:4:2:1:Cloth::1:0::2:0", -- Abjurer's Robe
	[9944]="0:4:2:1:OffHandFrill::1:0::2:0", -- Abjurer's Crystal
	[9945]="0:4:2:1:Cloth::1:0::2:0", -- Abjurer's Sash
	[9946]="0:4:2:1:Cloth::1:0::2:0", -- Abjurer's Tunic
	[9947]="0:4:2:1:Leather::1:0::2:0", -- Chieftain's Belt
	[9948]="0:4:2:1:Leather::1:0::2:0", -- Chieftain's Boots
	[9949]="0:4:2:1:Leather::1:0::2:0", -- Chieftain's Bracers
	[9950]="0:4:2:1:Leather::1:0::2:0", -- Chieftain's Breastplate
	[9951]="0:4:2:1:Cloak::1:0::2:0", -- Chieftain's Cloak
	[9952]="0:4:2:1:Leather::1:0::2:0", -- Chieftain's Gloves
	[9953]="0:4:2:1:Leather::1:0::2:0", -- Chieftain's Headdress
	[9954]="0:4:2:1:Leather::1:0::2:0", -- Chieftain's Leggings
	[9955]="0:4:2:1:Leather::1:0::2:0", -- Chieftain's Shoulders
	[9956]="0:4:2:1:Mail::1:0::2:0", -- Warmonger's Bracers
	[9957]="0:4:2:1:Mail::1:0::2:0", -- Warmonger's Chestpiece
	[9958]="0:4:2:1:Shield::1:0::2:0", -- Warmonger's Buckler
	[9959]="0:4:2:1:Cloak::1:0::2:0", -- Warmonger's Cloak
	[9960]="0:4:2:1:Mail::1:0::2:0", -- Warmonger's Gauntlets
	[9961]="0:4:2:1:Mail::1:0::2:0", -- Warmonger's Belt
	[9962]="0:4:2:1:Mail::1:0::2:0", -- Warmonger's Greaves
	[9963]="0:4:2:1:Mail::1:0::2:0", -- Warmonger's Circlet
	[9964]="0:4:2:1:Mail::1:0::2:0", -- Warmonger's Leggings
	[9965]="0:4:2:1:Mail::1:0::2:0", -- Warmonger's Pauldrons
	[9966]="0:4:2:1:Plate::1:0::2:0", -- Embossed Plate Armor
	[9967]="0:4:2:1:Plate::1:0::2:0", -- Embossed Plate Gauntlets
	[9968]="0:4:2:1:Plate::1:0::2:0", -- Embossed Plate Girdle
	[9969]="0:4:2:1:Plate::1:0::2:0", -- Embossed Plate Helmet
	[9970]="0:4:2:1:Plate::1:0::2:0", -- Embossed Plate Leggings
	[9971]="0:4:2:1:Plate::1:0::2:0", -- Embossed Plate Pauldrons
	[9972]="0:4:2:1:Plate::1:0::2:0", -- Embossed Plate Bracers
	[9973]="0:4:2:1:Plate::1:0::2:0", -- Embossed Plate Boots
	[9974]="0:4:2:1:Shield::1:0::2:0", -- Overlord's Shield
	[9978]="0:12:1:1:::1:0::4:0", -- Gahz'ridian Detector
	[9998]="0:4:2:1:Cloth::1:0::2:0", -- Black Mageweave Vest
	[9999]="0:4:2:1:Cloth::1:0::2:0", -- Black Mageweave Leggings
	[10000]="0:12:1:1:::1:0::3:0", -- Margol's Horn
	[10001]="0:4:2:1:Cloth::1:0::2:0", -- Black Mageweave Robe
	[10002]="0:4:2:1:Cloth::1:0::2:0", -- Shadoweave Pants
	[10003]="0:4:2:1:Cloth::1:0::2:0", -- Black Mageweave Gloves
	[10004]="0:4:2:1:Cloth::1:0::2:0", -- Shadoweave Robe
	[10005]="0:12:1:1:::1:0::4:0", -- Margol's Gigantic Horn
	[10007]="0:4:2:1:Cloth::1:0::2:0", -- Red Mageweave Vest
	[10008]="0:4:2:1:Cloth::1:0::2:0", -- White Bandit Mask
	[10009]="0:4:2:1:Cloth::1:0::2:0", -- Red Mageweave Pants
	[10010]="0:4:2:1:Cloth::1:0::2:0", -- Stormcloth Pants
	[10011]="0:4:2:1:Cloth::1:0::2:0", -- Stormcloth Gloves
	[10018]="0:4:2:1:Cloth::1:0::2:0", -- Red Mageweave Gloves
	[10019]="0:4:3:1:Cloth::1:0::2:0", -- Dreamweave Gloves
	[10020]="0:4:2:1:Cloth::1:0::2:0", -- Stormcloth Vest
	[10021]="0:4:3:1:Cloth::1:0::2:0", -- Dreamweave Vest
	[10022]="0:12:1:1:::1:0::4:0", -- Proof of Deed
	[10023]="0:4:2:1:Cloth::1:0::2:0", -- Shadoweave Gloves
	[10024]="0:4:2:1:Cloth::1:0::2:0", -- Black Mageweave Headband
	[10025]="0:4:2:1:Cloth::1:0::2:0", -- Shadoweave Mask
	[10026]="0:4:2:1:Cloth:202:1:0::2:0", -- Black Mageweave Boots
	[10027]="0:4:2:1:Cloth::1:0::2:0", -- Black Mageweave Shoulders
	[10028]="0:4:2:1:Cloth::1:0::2:0", -- Shadoweave Shoulders
	[10029]="0:4:2:1:Cloth::1:0::2:0", -- Red Mageweave Shoulders
	[10030]="0:4:2:1:Cloth::1:0::2:0", -- Admiral's Hat
	[10031]="0:4:2:1:Cloth::1:0::2:0", -- Shadoweave Boots
	[10032]="0:4:2:1:Cloth::1:0::2:0", -- Stormcloth Headband
	[10033]="0:4:2:1:Cloth::1:0::2:0", -- Red Mageweave Headband
	[10034]="0:4:1:1:Shirt::1:0::0:0", -- Tuxedo Shirt
	[10035]="0:4:1:1:Cloth::1:0::0:0", -- Tuxedo Pants
	[10036]="0:4:1:1:Cloth::1:0::0:0", -- Tuxedo Jacket
	[10038]="0:4:2:1:Cloth::1:0::2:0", -- Stormcloth Shoulders
	[10039]="0:4:2:1:Cloth::1:0::2:0", -- Stormcloth Boots
	[10040]="0:4:1:1:Cloth::1:0::0:0", -- White Wedding Dress
	[10041]="0:4:3:1:Cloth::1:0::2:0", -- Dreamweave Circlet
	[10042]="0:4:2:1:Cloth::1:0::2:0", -- Cindercloth Robe
	[10043]="0:4:2:1:Cloth::1:0::3:0", -- Pious Legwraps
	[10044]="0:4:2:1:Cloth::1:0::2:0", -- Cindercloth Boots
	[10045]="0:4:1:1:Cloth::1:0::0:0", -- Simple Linen Pants
	[10046]="0:4:1:1:Cloth::1:0::0:0", -- Simple Linen Boots
	[10047]="0:4:2:1:Cloth::1:0::2:0", -- Simple Kilt
	[10048]="0:4:2:1:Cloth::1:0::2:0", -- Colorful Kilt
	[10050]="0:1:1:1:Bag::1:0::0:0", -- Mageweave Bag
	[10051]="0:1:1:1:Bag::1:0::0:0", -- Red Mageweave Bag
	[10052]="0:4:1:1:Shirt::1:0::0:0", -- Orange Martial Shirt
	[10053]="0:4:1:1:Miscellaneous::1:0::0:0", -- Simple Black Dress
	[10054]="0:4:1:1:Shirt::1:0::0:0", -- Lavender Mageweave Shirt
	[10055]="0:4:1:1:Shirt::1:0::0:0", -- Pink Mageweave Shirt
	[10056]="0:4:1:1:Shirt::1:0::0:0", -- Orange Mageweave Shirt
	[10057]="0:4:2:1:Cloth::1:0::2:0", -- Duskwoven Tunic
	[10058]="0:4:2:1:Cloth::1:0::2:0", -- Duskwoven Sandals
	[10059]="0:4:2:1:Cloth::1:0::2:0", -- Duskwoven Bracers
	[10060]="0:4:2:1:Cloak::1:0::2:0", -- Duskwoven Cape
	[10061]="0:4:2:1:Cloth::1:0::2:0", -- Duskwoven Turban
	[10062]="0:4:2:1:Cloth::1:0::2:0", -- Duskwoven Gloves
	[10063]="0:4:2:1:Cloth::1:0::2:0", -- Duskwoven Amice
	[10064]="0:4:2:1:Cloth::1:0::2:0", -- Duskwoven Pants
	[10065]="0:4:2:1:Cloth::1:0::2:0", -- Duskwoven Robe
	[10066]="0:4:2:1:Cloth::1:0::2:0", -- Duskwoven Sash
	[10067]="0:4:2:1:Leather::1:0::2:0", -- Righteous Waistguard
	[10068]="0:4:2:1:Leather::1:0::2:0", -- Righteous Boots
	[10069]="0:4:2:1:Leather::1:0::2:0", -- Righteous Bracers
	[10070]="0:4:2:1:Leather::1:0::2:0", -- Righteous Armor
	[10071]="0:4:2:1:Cloak::1:0::2:0", -- Righteous Cloak
	[10072]="0:4:2:1:Leather::1:0::2:0", -- Righteous Gloves
	[10073]="0:4:2:1:Leather::1:0::2:0", -- Righteous Helmet
	[10074]="0:4:2:1:Leather::1:0::2:0", -- Righteous Leggings
	[10075]="0:4:2:1:Leather::1:0::2:0", -- Righteous Spaulders
	[10076]="0:4:2:1:Mail::1:0::2:0", -- Lord's Armguards
	[10077]="0:4:2:1:Mail::1:0::2:0", -- Lord's Breastplate
	[10078]="0:4:2:1:Shield::1:0::2:0", -- Lord's Crest
	[10079]="0:4:2:1:Cloak::1:0::2:0", -- Lord's Cape
	[10080]="0:4:2:1:Mail::1:0::2:0", -- Lord's Gauntlets
	[10081]="0:4:2:1:Mail::1:0::2:0", -- Lord's Girdle
	[10082]="0:4:2:1:Mail::1:0::2:0", -- Lord's Boots
	[10083]="0:4:2:1:Mail::1:0::2:0", -- Lord's Crown
	[10084]="0:4:2:1:Mail::1:0::2:0", -- Lord's Legguards
	[10085]="0:4:2:1:Mail::1:0::2:0", -- Lord's Pauldrons
	[10086]="0:4:2:1:Plate::1:0::2:0", -- Gothic Plate Armor
	[10087]="0:4:2:1:Plate::1:0::2:0", -- Gothic Plate Gauntlets
	[10088]="0:4:2:1:Plate::1:0::2:0", -- Gothic Plate Girdle
	[10089]="0:4:2:1:Plate::1:0::2:0", -- Gothic Sabatons
	[10090]="0:4:2:1:Plate::1:0::2:0", -- Gothic Plate Helmet
	[10091]="0:4:2:1:Plate::1:0::2:0", -- Gothic Plate Leggings
	[10092]="0:4:2:1:Plate::1:0::2:0", -- Gothic Plate Spaulders
	[10093]="0:4:2:1:Shield::1:0::2:0", -- Revenant Deflector
	[10094]="0:4:2:1:Plate::1:0::2:0", -- Gothic Plate Vambraces
	[10095]="0:4:2:1:Cloth::1:0::2:0", -- Councillor's Boots
	[10096]="0:4:2:1:Cloth::1:0::2:0", -- Councillor's Cuffs
	[10097]="0:4:2:1:Cloth::1:0::2:0", -- Councillor's Circlet
	[10098]="0:4:2:1:Cloak::1:0::2:0", -- Councillor's Cloak
	[10099]="0:4:2:1:Cloth::1:0::2:0", -- Councillor's Gloves
	[10100]="0:4:2:1:Cloth::1:0::2:0", -- Councillor's Shoulders
	[10101]="0:4:2:1:Cloth::1:0::2:0", -- Councillor's Pants
	[10102]="0:4:2:1:Cloth::1:0::2:0", -- Councillor's Robes
	[10103]="0:4:2:1:Cloth::1:0::2:0", -- Councillor's Sash
	[10104]="0:4:2:1:Cloth::1:0::2:0", -- Councillor's Tunic
	[10105]="0:4:2:1:Leather::1:0::2:0", -- Wanderer's Armor
	[10106]="0:4:2:1:Leather::1:0::2:0", -- Wanderer's Boots
	[10107]="0:4:2:1:Leather::1:0::2:0", -- Wanderer's Bracers
	[10108]="0:4:2:1:Cloak::1:0::2:0", -- Wanderer's Cloak
	[10109]="0:4:2:1:Leather::1:0::2:0", -- Wanderer's Belt
	[10110]="0:4:2:1:Leather::1:0::2:0", -- Wanderer's Gloves
	[10111]="0:4:2:1:Leather::1:0::2:0", -- Wanderer's Hat
	[10112]="0:4:2:1:Leather::1:0::2:0", -- Wanderer's Leggings
	[10113]="0:4:2:1:Leather::1:0::2:0", -- Wanderer's Shoulders
	[10118]="0:4:2:1:Mail::1:0::2:0", -- Ornate Breastplate
	[10119]="0:4:2:1:Mail::1:0::2:0", -- Ornate Greaves
	[10120]="0:4:2:1:Cloak::1:0::2:0", -- Ornate Cloak
	[10121]="0:4:2:1:Mail::1:0::2:0", -- Ornate Gauntlets
	[10122]="0:4:2:1:Mail::1:0::2:0", -- Ornate Girdle
	[10123]="0:4:2:1:Mail::1:0::2:0", -- Ornate Circlet
	[10124]="0:4:2:1:Mail::1:0::2:0", -- Ornate Legguards
	[10125]="0:4:2:1:Mail::1:0::2:0", -- Ornate Pauldrons
	[10126]="0:4:2:1:Mail::1:0::2:0", -- Ornate Bracers
	[10127]="0:4:2:1:Plate::1:0::2:0", -- Revenant Bracers
	[10128]="0:4:2:1:Plate::1:0::2:0", -- Revenant Chestplate
	[10129]="0:4:2:1:Plate::1:0::2:0", -- Revenant Gauntlets
	[10130]="0:4:2:1:Plate::1:0::2:0", -- Revenant Girdle
	[10131]="0:4:2:1:Plate::1:0::2:0", -- Revenant Boots
	[10132]="0:4:2:1:Plate::1:0::2:0", -- Revenant Helmet
	[10133]="0:4:2:1:Plate::1:0::2:0", -- Revenant Leggings
	[10134]="0:4:2:1:Plate::1:0::2:0", -- Revenant Shoulders
	[10135]="0:4:2:1:Cloth::1:0::2:0", -- High Councillor's Tunic
	[10136]="0:4:2:1:Cloth::1:0::2:0", -- High Councillor's Bracers
	[10137]="0:4:2:1:Cloth::1:0::2:0", -- High Councillor's Boots
	[10138]="0:4:2:1:Cloak::1:0::2:0", -- High Councillor's Cloak
	[10139]="0:4:2:1:Cloth::1:0::2:0", -- High Councillor's Circlet
	[10140]="0:4:2:1:Cloth::1:0::2:0", -- High Councillor's Gloves
	[10141]="0:4:2:1:Cloth::1:0::2:0", -- High Councillor's Pants
	[10142]="0:4:2:1:Cloth::1:0::2:0", -- High Councillor's Mantle
	[10143]="0:4:2:1:Cloth::1:0::2:0", -- High Councillor's Robe
	[10144]="0:4:2:1:Cloth::1:0::2:0", -- High Councillor's Sash
	[10145]="0:4:2:1:Leather::1:0::2:0", -- Mighty Girdle
	[10146]="0:4:2:1:Leather::1:0::2:0", -- Mighty Boots
	[10147]="0:4:2:1:Leather::1:0::2:0", -- Mighty Armsplints
	[10148]="0:4:2:1:Cloak::1:0::2:0", -- Mighty Cloak
	[10149]="0:4:2:1:Leather::1:0::2:0", -- Mighty Gauntlets
	[10150]="0:4:2:1:Leather::1:0::2:0", -- Mighty Helmet
	[10151]="0:4:2:1:Leather::1:0::2:0", -- Mighty Tunic
	[10152]="0:4:2:1:Leather::1:0::2:0", -- Mighty Leggings
	[10153]="0:4:2:1:Leather::1:0::2:0", -- Mighty Spaulders
	[10154]="0:4:2:1:Mail::1:0::2:0", -- Mercurial Girdle
	[10155]="0:4:2:1:Mail::1:0::2:0", -- Mercurial Greaves
	[10156]="0:4:2:1:Mail::1:0::2:0", -- Mercurial Bracers
	[10157]="0:4:2:1:Mail::1:0::2:0", -- Mercurial Breastplate
	[10158]="0:4:2:1:Shield::1:0::2:0", -- Mercurial Guard
	[10159]="0:4:2:1:Cloak::1:0::2:0", -- Mercurial Cloak
	[10160]="0:4:2:1:Mail::1:0::2:0", -- Mercurial Circlet
	[10161]="0:4:2:1:Mail::1:0::2:0", -- Mercurial Gauntlets
	[10162]="0:4:2:1:Mail::1:0::2:0", -- Mercurial Legguards
	[10163]="0:4:2:1:Mail::1:0::2:0", -- Mercurial Pauldrons
	[10164]="0:4:2:1:Plate::1:0::2:0", -- Templar Chestplate
	[10165]="0:4:2:1:Plate::1:0::2:0", -- Templar Gauntlets
	[10166]="0:4:2:1:Plate::1:0::2:0", -- Templar Girdle
	[10167]="0:4:2:1:Plate::1:0::2:0", -- Templar Boots
	[10168]="0:4:2:1:Plate::1:0::2:0", -- Templar Crown
	[10169]="0:4:2:1:Plate::1:0::2:0", -- Templar Legplates
	[10170]="0:4:2:1:Plate::1:0::2:0", -- Templar Pauldrons
	[10171]="0:4:2:1:Plate::1:0::2:0", -- Templar Bracers
	[10172]="0:4:2:1:Cloth::1:0::2:0", -- Mystical Mantle
	[10173]="0:4:2:1:Cloth::1:0::2:0", -- Mystical Bracers
	[10174]="0:4:2:1:Cloak::1:0::2:0", -- Mystical Cape
	[10175]="0:4:2:1:Cloth::1:0::2:0", -- Mystical Headwrap
	[10176]="0:4:2:1:Cloth::1:0::2:0", -- Mystical Gloves
	[10177]="0:4:2:1:Cloth::1:0::2:0", -- Mystical Leggings
	[10178]="0:4:2:1:Cloth::1:0::2:0", -- Mystical Robe
	[10179]="0:4:2:1:Cloth::1:0::2:0", -- Mystical Boots
	[10180]="0:4:2:1:Cloth::1:0::2:0", -- Mystical Belt
	[10181]="0:4:2:1:Cloth::1:0::2:0", -- Mystical Armor
	[10182]="0:4:2:1:Leather::1:0::2:0", -- Swashbuckler's Breastplate
	[10183]="0:4:2:1:Leather::1:0::2:0", -- Swashbuckler's Boots
	[10184]="0:4:2:1:Leather::1:0::2:0", -- Swashbuckler's Bracers
	[10185]="0:4:2:1:Cloak::1:0::2:0", -- Swashbuckler's Cape
	[10186]="0:4:2:1:Leather::1:0::2:0", -- Swashbuckler's Gloves
	[10187]="0:4:2:1:Leather::1:0::2:0", -- Swashbuckler's Eyepatch
	[10188]="0:4:2:1:Leather::1:0::2:0", -- Swashbuckler's Leggings
	[10189]="0:4:2:1:Leather::1:0::2:0", -- Swashbuckler's Shoulderpads
	[10190]="0:4:2:1:Leather::1:0::2:0", -- Swashbuckler's Belt
	[10191]="0:4:2:1:Mail::1:0::2:0", -- Crusader's Armguards
	[10192]="0:4:2:1:Mail::1:0::2:0", -- Crusader's Boots
	[10193]="0:4:2:1:Mail::1:0::2:0", -- Crusader's Armor
	[10194]="0:4:2:1:Cloak::1:0::2:0", -- Crusader's Cloak
	[10195]="0:4:2:1:Shield::1:0::2:0", -- Crusader's Shield
	[10196]="0:4:2:1:Mail::1:0::2:0", -- Crusader's Gauntlets
	[10197]="0:4:2:1:Mail::1:0::2:0", -- Crusader's Belt
	[10198]="0:4:2:1:Mail::1:0::2:0", -- Crusader's Helm
	[10199]="0:4:2:1:Mail::1:0::2:0", -- Crusader's Leggings
	[10200]="0:4:2:1:Mail::1:0::2:0", -- Crusader's Pauldrons
	[10201]="0:4:2:1:Plate::1:0::2:0", -- Overlord's Greaves
	[10202]="0:4:2:1:Plate::1:0::2:0", -- Overlord's Vambraces
	[10203]="0:4:2:1:Plate::1:0::2:0", -- Overlord's Chestplate
	[10204]="0:4:2:1:Shield::1:0::2:0", -- Heavy Lamellar Shield
	[10205]="0:4:2:1:Plate::1:0::2:0", -- Overlord's Gauntlets
	[10206]="0:4:2:1:Plate::1:0::2:0", -- Overlord's Girdle
	[10207]="0:4:2:1:Plate::1:0::2:0", -- Overlord's Crown
	[10208]="0:4:2:1:Plate::1:0::2:0", -- Overlord's Legplates
	[10209]="0:4:2:1:Plate::1:0::2:0", -- Overlord's Spaulders
	[10210]="0:4:2:1:Cloth::1:0::2:0", -- Elegant Mantle
	[10211]="0:4:2:1:Cloth::1:0::2:0", -- Elegant Boots
	[10212]="0:4:2:1:Cloak::1:0::2:0", -- Elegant Cloak
	[10213]="0:4:2:1:Cloth::1:0::2:0", -- Elegant Bracers
	[10214]="0:4:2:1:Cloth::1:0::2:0", -- Elegant Gloves
	[10215]="0:4:2:1:Cloth::1:0::2:0", -- Elegant Robes
	[10216]="0:4:2:1:Cloth::1:0::2:0", -- Elegant Belt
	[10217]="0:4:2:1:Cloth::1:0::2:0", -- Elegant Leggings
	[10218]="0:4:2:1:Cloth::1:0::2:0", -- Elegant Tunic
	[10219]="0:4:2:1:Cloth::1:0::2:0", -- Elegant Circlet
	[10220]="0:4:2:1:Leather::1:0::2:0", -- Nightshade Tunic
	[10221]="0:4:2:1:Leather::1:0::2:0", -- Nightshade Girdle
	[10222]="0:4:2:1:Leather::1:0::2:0", -- Nightshade Boots
	[10223]="0:4:2:1:Leather::1:0::2:0", -- Nightshade Armguards
	[10224]="0:4:2:1:Cloak::1:0::2:0", -- Nightshade Cloak
	[10225]="0:4:2:1:Leather::1:0::2:0", -- Nightshade Gloves
	[10226]="0:4:2:1:Leather::1:0::2:0", -- Nightshade Helmet
	[10227]="0:4:2:1:Leather::1:0::2:0", -- Nightshade Leggings
	[10228]="0:4:2:1:Leather::1:0::2:0", -- Nightshade Spaulders
	[10229]="0:4:2:1:Mail::1:0::2:0", -- Engraved Bracers
	[10230]="0:4:2:1:Mail::1:0::2:0", -- Engraved Breastplate
	[10231]="0:4:2:1:Cloak::1:0::2:0", -- Engraved Cape
	[10232]="0:4:2:1:Mail::1:0::2:0", -- Engraved Gauntlets
	[10233]="0:4:2:1:Mail::1:0::2:0", -- Engraved Girdle
	[10234]="0:4:2:1:Mail::1:0::2:0", -- Engraved Boots
	[10235]="0:4:2:1:Mail::1:0::2:0", -- Engraved Helm
	[10236]="0:4:2:1:Mail::1:0::2:0", -- Engraved Leggings
	[10237]="0:4:2:1:Mail::1:0::2:0", -- Engraved Pauldrons
	[10238]="0:4:2:1:Plate::1:0::2:0", -- Heavy Lamellar Boots
	[10239]="0:4:2:1:Plate::1:0::2:0", -- Heavy Lamellar Vambraces
	[10240]="0:4:2:1:Plate::1:0::2:0", -- Heavy Lamellar Chestpiece
	[10241]="0:4:2:1:Plate::1:0::2:0", -- Heavy Lamellar Helm
	[10242]="0:4:2:1:Plate::1:0::2:0", -- Heavy Lamellar Gauntlets
	[10243]="0:4:2:1:Plate::1:0::2:0", -- Heavy Lamellar Girdle
	[10244]="0:4:2:1:Plate::1:0::2:0", -- Heavy Lamellar Leggings
	[10245]="0:4:2:1:Plate::1:0::2:0", -- Heavy Lamellar Pauldrons
	[10246]="0:4:2:1:Cloth::1:0::2:0", -- Master's Vest
	[10247]="0:4:2:1:Cloth::1:0::2:0", -- Master's Boots
	[10248]="0:4:2:1:Cloth::1:0::2:0", -- Master's Bracers
	[10249]="0:4:2:1:Cloak::1:0::2:0", -- Master's Cloak
	[10250]="0:4:2:1:Cloth::1:0::2:0", -- Master's Hat
	[10251]="0:4:2:1:Cloth::1:0::2:0", -- Master's Gloves
	[10252]="0:4:2:1:Cloth::1:0::2:0", -- Master's Leggings
	[10253]="0:4:2:1:Cloth::1:0::2:0", -- Master's Mantle
	[10254]="0:4:2:1:Cloth::1:0::2:0", -- Master's Robe
	[10255]="0:4:2:1:Cloth::1:0::2:0", -- Master's Belt
	[10256]="0:4:2:1:Leather::1:0::2:0", -- Adventurer's Bracers
	[10257]="0:4:2:1:Leather::1:0::2:0", -- Adventurer's Boots
	[10258]="0:4:2:1:Cloak::1:0::2:0", -- Adventurer's Cape
	[10259]="0:4:2:1:Leather::1:0::2:0", -- Adventurer's Belt
	[10260]="0:4:2:1:Leather::1:0::2:0", -- Adventurer's Gloves
	[10261]="0:4:2:1:Leather::1:0::2:0", -- Adventurer's Bandana
	[10262]="0:4:2:1:Leather::1:0::2:0", -- Adventurer's Legguards
	[10263]="0:4:2:1:Leather::1:0::2:0", -- Adventurer's Shoulders
	[10264]="0:4:2:1:Leather::1:0::2:0", -- Adventurer's Tunic
	[10265]="0:4:2:1:Mail::1:0::2:0", -- Masterwork Bracers
	[10266]="0:4:2:1:Mail::1:0::2:0", -- Masterwork Breastplate
	[10267]="0:4:2:1:Cloak::1:0::2:0", -- Masterwork Cape
	[10268]="0:4:2:1:Mail::1:0::2:0", -- Masterwork Gauntlets
	[10269]="0:4:2:1:Mail::1:0::2:0", -- Masterwork Girdle
	[10270]="0:4:2:1:Mail::1:0::2:0", -- Masterwork Boots
	[10271]="0:4:2:1:Shield::1:0::2:0", -- Masterwork Shield
	[10272]="0:4:2:1:Mail::1:0::2:0", -- Masterwork Circlet
	[10273]="0:4:2:1:Mail::1:0::2:0", -- Masterwork Legplates
	[10274]="0:4:2:1:Mail::1:0::2:0", -- Masterwork Pauldrons
	[10275]="0:4:2:1:Plate::1:0::2:0", -- Emerald Breastplate
	[10276]="0:4:2:1:Plate::1:0::2:0", -- Emerald Sabatons
	[10277]="0:4:2:1:Plate::1:0::2:0", -- Emerald Gauntlets
	[10278]="0:4:2:1:Plate::1:0::2:0", -- Emerald Girdle
	[10279]="0:4:2:1:Plate::1:0::2:0", -- Emerald Helm
	[10280]="0:4:2:1:Plate::1:0::2:0", -- Emerald Legplates
	[10281]="0:4:2:1:Plate::1:0::2:0", -- Emerald Pauldrons
	[10282]="0:4:2:1:Plate::1:0::2:0", -- Emerald Vambraces
	[10283]="0:12:1:1:::1:0::4:0", -- Wolf Heart Samples
	[10285]="0:7:1:10:Cloth:202,165,197:1:0::0:0", -- Shadow Silk
	[10286]="0:7:1:10:Elemental:171,202,755,197:1:0::0:0", -- Heart of the Wild
	[10287]="0:4:2:1:Cloth::1:0::2:0", -- Greenweave Mantle
	[10288]="0:4:2:1:Cloth::1:0::2:0", -- Sage's Circlet
	[10289]="0:4:2:1:Cloth::1:0::2:0", -- Durable Hat
	[10290]="2500:7:1:10:Other:197:1:0:1347,1454,1474,1672,2394,2668,2669,2670,2672,2697,2698,2699,2816,2819,2846,3005,3008,3091,3364,3366,3485,3958,4168,4225,4577,4589,5128,5154,5565,6567,6568,6574,7854,7940,8160,8681,11557,11874,12942,12943,12956,16366,16638,16689,16748,16767,18277,18749,18754,18771,18772,19196,19213,19521,19532,19722,21085,28718,28726,28798,28810,33596,33601,33635,33636,33681,33684,34601,38873,40226,40572,43380,43495,43550,43554,43568,43880,44027,44386,45558,46184,47856,48098,48587,48608,48857,48860,49404,49705,49714,49888,50071,50094,50456,50457,53075,53436,53782:0:0", -- Pink Dye
	[10298]="0:4:2:1:Ring::1:0::3:0", -- Gnomeregan Band
	[10299]="0:4:2:1:Amulet::1:0::3:0", -- Gnomeregan Amulet
	[10300]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Red Mageweave Vest
	[10301]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: White Bandit Mask
	[10302]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Red Mageweave Pants
	[10305]="550:0:1:20:Scroll::1:1:14847:0:0", -- Scroll of Protection IV
	[10306]="550:0:1:20:Scroll::1:1:4581,14847,20092:0:0", -- Scroll of Spirit IV
	[10307]="600:0:1:20:Scroll::1:1:4581,14847,20092:0:0", -- Scroll of Stamina IV
	[10308]="600:0:1:20:Scroll::1:1:4581,14847,20092:0:0", -- Scroll of Intellect IV
	[10309]="650:0:1:20:Scroll::1:1:14847:0:0", -- Scroll of Agility IV
	[10310]="650:0:1:20:Scroll::1:1:14847:0:0", -- Scroll of Strength IV
	[10311]="3000:9:1:1:Tailoring::1:1:3005,4168:0:0", -- Pattern: Orange Martial Shirt
	[10312]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Red Mageweave Gloves
	[10314]="4000:9:1:1:Tailoring::1:1:3364,8681,45558:0:0", -- Pattern: Lavender Mageweave Shirt
	[10315]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Red Mageweave Shoulders
	[10316]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Colorful Kilt
	[10317]="4000:9:1:1:Tailoring::1:1:3364,8681,45558:0:0", -- Pattern: Pink Mageweave Shirt
	[10318]="7000:9:1:1:Tailoring::1:1:2672:0:0", -- Pattern: Admiral's Hat
	[10320]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Red Mageweave Headband
	[10321]="4500:9:1:1:Tailoring::1:1:4577,8681:0:0", -- Pattern: Tuxedo Shirt
	[10323]="4500:9:1:1:Tailoring::1:1:4577,8681:0:0", -- Pattern: Tuxedo Pants
	[10325]="10000:9:1:1:Tailoring::1:1:1347,3005:0:0", -- Pattern: White Wedding Dress
	[10326]="5000:9:1:1:Tailoring::1:1:4577,8681:0:0", -- Pattern: Tuxedo Jacket
	[10327]="0:12:1:1:::1:0::4:0", -- Horn of Echeyakee
	[10328]="0:4:3:1:Mail::1:0::2:0", -- Scarlet Chestpiece
	[10329]="0:4:2:1:Mail::1:0::2:0", -- Scarlet Belt
	[10330]="0:4:3:1:Mail::1:0::3:0", -- Scarlet Leggings
	[10331]="0:4:2:1:Mail::1:0::2:0", -- Scarlet Gauntlets
	[10332]="0:4:3:1:Mail::1:0::2:0", -- Scarlet Boots
	[10333]="0:4:2:1:Mail::1:0::2:0", -- Scarlet Wristguards
	[10338]="0:12:1:1:::1:0::4:0", -- Fresh Zhevra Carcass
	[10358]="0:4:2:1:Mail::1:0::3:0", -- Duracin Bracers
	[10359]="0:4:2:1:Cloth::1:0::3:0", -- Everlast Boots
	[10360]="5000:15:1:1:Companion::1:0:8404:0:0", -- Black Kingsnake
	[10361]="5000:15:1:1:Companion::1:0:8404:0:0", -- Brown Snake
	[10362]="0:4:2:1:Shield::1:0::2:0", -- Ornate Shield
	[10363]="0:4:2:1:Shield::1:0::2:0", -- Engraved Wall
	[10364]="0:4:2:1:Shield::1:0::2:0", -- Templar Shield
	[10365]="0:4:2:1:Shield::1:0::2:0", -- Emerald Shield
	[10366]="0:4:2:1:Shield::1:0::2:0", -- Demon Guard
	[10367]="0:4:2:1:Shield::1:0::2:0", -- Hyperion Shield
	[10368]="0:4:2:1:Plate::1:0::2:0", -- Imbued Plate Armor
	[10369]="0:4:2:1:Plate::1:0::2:0", -- Imbued Plate Gauntlets
	[10370]="0:4:2:1:Plate::1:0::2:0", -- Imbued Plate Girdle
	[10371]="0:4:2:1:Plate::1:0::2:0", -- Imbued Plate Greaves
	[10372]="0:4:2:1:Plate::1:0::2:0", -- Imbued Plate Helmet
	[10373]="0:4:2:1:Plate::1:0::2:0", -- Imbued Plate Leggings
	[10374]="0:4:2:1:Plate::1:0::2:0", -- Imbued Plate Pauldrons
	[10375]="0:4:2:1:Plate::1:0::2:0", -- Imbued Plate Vambraces
	[10376]="0:4:2:1:Plate::1:0::2:0", -- Commander's Boots
	[10377]="0:4:2:1:Plate::1:0::2:0", -- Commander's Vambraces
	[10378]="0:4:2:1:Plate::1:0::2:0", -- Commander's Armor
	[10379]="0:4:2:1:Plate::1:0::2:0", -- Commander's Helm
	[10380]="0:4:2:1:Plate::1:0::2:0", -- Commander's Gauntlets
	[10381]="0:4:2:1:Plate::1:0::2:0", -- Commander's Girdle
	[10382]="0:4:2:1:Plate::1:0::2:0", -- Commander's Leggings
	[10383]="0:4:2:1:Plate::1:0::2:0", -- Commander's Pauldrons
	[10384]="0:4:2:1:Plate::1:0::2:0", -- Hyperion Armor
	[10385]="0:4:2:1:Plate::1:0::2:0", -- Hyperion Greaves
	[10386]="0:4:2:1:Plate::1:0::2:0", -- Hyperion Gauntlets
	[10387]="0:4:2:1:Plate::1:0::2:0", -- Hyperion Girdle
	[10388]="0:4:2:1:Plate::1:0::2:0", -- Hyperion Helm
	[10389]="0:4:2:1:Plate::1:0::2:0", -- Hyperion Legplates
	[10390]="0:4:2:1:Plate::1:0::2:0", -- Hyperion Pauldrons
	[10391]="0:4:2:1:Plate::1:0::2:0", -- Hyperion Vambraces
	[10392]="5000:15:1:1:Companion::1:0:8404,20980:0:0", -- Crimson Snake
	[10393]="5000:15:1:1:Companion::1:0:8403,20980:0:0", -- Cockroach
	[10394]="5000:15:1:1:Companion::1:0:8401:0:0", -- Prairie Dog Whistle
	[10398]="0:15:1:1:Companion::1:0::0:0", -- Mechanical Chicken
	[10399]="0:4:3:1:Leather::1:0::3:0", -- Blackened Defias Armor
	[10400]="0:4:3:1:Leather::1:0::2:0", -- Blackened Defias Leggings
	[10401]="0:4:3:1:Leather::1:0::2:0", -- Blackened Defias Gloves
	[10402]="0:4:3:1:Leather::1:0::2:0", -- Blackened Defias Boots
	[10403]="0:4:3:1:Leather::1:0::2:0", -- Blackened Defias Belt
	[10404]="0:4:2:1:Cloth::1:0::2:0", -- Durable Belt
	[10405]="0:4:1:1:Leather::1:0::0:0", -- Bandit Shoulders
	[10406]="0:4:2:1:Leather::1:0::2:0", -- Scaled Leather Headband
	[10407]="0:4:1:1:Mail::1:0::0:0", -- Raider's Shoulderpads
	[10408]="0:4:2:1:Mail::1:0::2:0", -- Banded Helm
	[10409]="0:4:2:1:Mail::1:0::2:0", -- Banded Boots
	[10410]="0:4:3:1:Leather::1:0::3:0", -- Leggings of the Fang
	[10411]="0:4:3:1:Leather::1:0::3:0", -- Footpads of the Fang
	[10412]="0:4:3:1:Leather::1:0::3:0", -- Belt of the Fang
	[10413]="0:4:3:1:Leather::1:0::2:0", -- Gloves of the Fang
	[10414]="0:12:1:1:::1:0::4:0", -- Sample Snapjaw Shell
	[10418]="0:4:3:1:Trinket::1:0::3:0", -- Glimmering Mithril Insignia
	[10420]="0:12:1:1:::1:0::4:0", -- Skull of the Coldbringer
	[10421]="0:4:1:1:Mail::1:0::0:0", -- Rough Copper Vest
	[10423]="0:4:2:1:Mail::1:0::2:0", -- Silvered Bronze Leggings
	[10424]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Silvered Bronze Leggings
	[10438]="0:12:1:1:::1:0::4:0", -- Felix's Box
	[10439]="0:12:1:1:::1:0::4:0", -- Durnan's Scalding Mornbrew
	[10440]="0:12:1:1:::1:0::4:0", -- Nori's Mug
	[10441]="0:12:1:1:::1:0::3:0", -- Glowing Shard
	[10442]="0:12:1:1:::1:0::4:0", -- Mysterious Artifact
	[10443]="0:12:1:1:::1:0::3:0", -- Singed Letter
	[10444]="0:12:1:1:::1:0::4:0", -- Standard Issue Flare Gun
	[10445]="0:12:1:1:::1:0::4:0", -- Drawing Kit
	[10446]="0:12:1:1:::1:0::4:0", -- Heart of Obsidion
	[10447]="0:12:1:1:::1:0::4:0", -- Head of Lathoric the Black
	[10450]="0:15:0:20:Junk::1:0::0:0", -- Undamaged Hippogryph Feather
	[10454]="0:12:2:1:::1:0::3:0", -- Essence of Eranikus
	[10455]="0:4:3:1:Trinket::1:0::3:0", -- Chained Essence of Eranikus
	[10456]="0:15:1:1:Junk::1:0::3:0", -- A Bulging Coin Purse
	[10457]="0:15:0:20:Junk::1:0::0:0", -- Empty Sea Snail Shell
	[10458]="0:12:1:1:::1:0::4:0", -- Prayer to Elune
	[10459]="0:12:1:1:::1:0::4:0", -- Chief Sharptusk Thornmantle's Head
	[10460]="0:15:1:1:Junk::1:0::0:0", -- Hakkari Blood
	[10461]="0:4:2:1:Cloth::1:0::3:0", -- Shadowy Bracers
	[10462]="0:4:2:1:Cloth::1:0::3:0", -- Shadowy Belt
	[10463]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Shadoweave Mask
	[10464]="0:12:1:1:::1:0::4:0", -- Staff of Command
	[10465]="0:12:1:1:::1:0::4:0", -- Egg of Hakkar
	[10467]="0:12:1:1:::1:0::4:0", -- Trader's Satchel
	[10479]="0:15:2:1:Junk::1:0::3:0", -- Kovic's Trading Satchel
	[10498]="0:7:1:1:Part::1:0::0:0", -- Gyromatic Micro-Adjustor
	[10499]="0:4:2:1:Cloth::1:0::2:0", -- Bright-Eye Goggles
	[10500]="0:4:2:1:Cloth:202:1:0::2:0", -- Fire Goggles
	[10501]="0:4:2:1:Cloth::1:0::2:0", -- Catseye Ultra Goggles
	[10502]="0:4:2:1:Cloth:202:1:0::2:0", -- Spellpower Goggles Xtreme
	[10503]="0:4:2:1:Cloth::1:0::2:0", -- Rose Colored Goggles
	[10504]="0:4:3:1:Cloth::1:0::2:0", -- Green Lens
	[10505]="0:7:1:20:Part:202:1:0::0:0", -- Solid Blasting Powder
	[10506]="0:4:2:1:Cloth::1:0::2:0", -- Deepdive Helmet
	[10507]="0:7:1:20:Explosive:202:1:0::0:0", -- Solid Dynamite
	[10508]="0:2:2:1:Gun::1:0::2:0", -- Mithril Blunderbuss
	[10509]="0:12:1:4:::1:0::4:0", -- Heart of Flame
	[10510]="0:2:2:1:Gun::1:0::2:0", -- Mithril Heavy-Bore Rifle
	[10511]="0:12:1:4:::1:0::4:0", -- Golem Oil
	[10512]="0:15:0:1000:Junk::1:0::0:0", -- Hi-Impact Mithril Slugs
	[10513]="0:15:0:1000:Junk::1:0::0:0", -- Mithril Gyro-Shot
	[10514]="0:7:1:20:Explosive::1:0::0:0", -- Mithril Frag Bomb
	[10515]="0:12:1:1:::1:0::4:0", -- Torch of Retribution
	[10518]="0:4:2:1:Cloak::1:0::2:0", -- Parachute Cloak
	[10538]="0:12:1:1:::1:0::4:0", -- Tablet of Beth'Amara
	[10539]="0:12:1:1:::1:0::4:0", -- Tablet of Jin'yael
	[10540]="0:12:1:1:::1:0::4:0", -- Tablet of Markri
	[10541]="0:12:1:1:::1:0::4:0", -- Tablet of Sael'hai
	[10542]="0:4:2:1:Mail::1:0::3:0", -- Goblin Mining Helmet
	[10543]="0:4:2:1:Cloth:202:1:0::3:0", -- Goblin Construction Helmet
	[10544]="0:2:1:1:OneHandMace::1:0::3:0", -- Thistlewood Maul
	[10545]="0:4:2:1:Cloth::1:0::3:0", -- Gnomish Goggles
	[10546]="0:0:1:5:EnhPerm:202:1:0::0:0", -- Deadly Scope
	[10547]="0:2:1:1:Dagger::1:0::3:0", -- Camping Knife
	[10548]="0:0:1:5:EnhPerm::1:0::0:0", -- Sniper Scope
	[10549]="0:4:1:1:Cloth::1:0::3:0", -- Rancher's Trousers
	[10550]="0:4:1:1:Cloth::1:0::3:0", -- Wooly Mittens
	[10551]="0:12:1:10:::1:0::4:0", -- Thorium Plated Dagger
	[10552]="0:12:1:1:::1:0::4:0", -- Symbol of Ragnaros
	[10553]="0:4:2:1:Cloth::1:0::2:0", -- Foreman Vest
	[10554]="0:4:2:1:Cloth::1:0::2:0", -- Foreman Pants
	[10556]="0:12:1:1:::1:0::4:0", -- Stone Circle
	[10558]="0:7:1:20:Part:202:1:0::0:0", -- Gold Power Core
	[10559]="0:7:1:20:Part:202:1:0::0:0", -- Mithril Tube
	[10560]="0:7:1:10:Part:202:1:0::0:0", -- Unstable Trigger
	[10561]="0:7:1:10:Part:202:1:0::0:0", -- Mithril Casing
	[10562]="0:7:1:20:Explosive::1:0::0:0", -- Hi-Explosive Bomb
	[10563]="0:12:1:1:::1:0::4:0", -- Rubbing: Rune of Beth'Amara
	[10564]="0:12:1:1:::1:0::4:0", -- Rubbing: Rune of Jin'yael
	[10565]="0:12:1:1:::1:0::4:0", -- Rubbing: Rune of Markri
	[10566]="0:12:1:1:::1:0::4:0", -- Rubbing: Rune of Sael'hai
	[10567]="0:2:3:1:Bow::1:0::2:0", -- Quillshooter
	[10569]="0:15:1:1:Junk::1:0::3:0", -- Hoard of the Black Dragonflight
	[10570]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Manslayer
	[10571]="0:2:3:1:OneHandMace::1:0::2:0", -- Ebony Boneclub
	[10572]="0:2:3:1:Wand::1:0::2:0", -- Freezing Shard
	[10573]="0:2:3:1:TwoHandSword::1:0::2:0", -- Boneslasher
	[10574]="0:4:3:1:Cloth::1:0::2:0", -- Corpseshroud
	[10575]="0:15:1:10:Junk::1:0::3:0", -- Black Dragonflight Molt
	[10576]="0:4:2:1:Trinket:202:1:0::2:0", -- Mithril Mechanical Dragonling
	[10577]="0:4:2:1:Trinket:202:1:0::2:0", -- Goblin Mortar
	[10578]="0:4:3:1:Cloth::1:0::2:0", -- Thoughtcast Boots
	[10579]="0:15:0:1000:Junk::1:0::0:0", -- Explosive Arrow
	[10580]="0:7:1:10:Explosive::1:0::0:0", -- Goblin "Boom" Box
	[10581]="0:4:3:1:Cloth::1:0::2:0", -- Death's Head Vestment
	[10582]="0:4:3:1:Leather::1:0::2:0", -- Briar Tredders
	[10583]="0:4:3:1:Leather::1:0::2:0", -- Quillward Harness
	[10584]="0:4:3:1:Plate::1:0::2:0", -- Stormgale Fists
	[10585]="0:4:1:10:Trinket::1:0::0:0", -- Goblin Radio
	[10586]="0:7:1:20:Explosive:202:1:0::0:0", -- The Big One
	[10587]="0:4:1:1:Trinket::1:0::3:0", -- Goblin Bomb Dispenser
	[10588]="0:4:2:1:Cloth::1:0::2:0", -- Goblin Rocket Helmet
	[10589]="0:12:1:1:::1:0::4:0", -- Oathstone of Ysera's Dragonflight
	[10592]="0:0:1:20:Elixir:202:1:0::0:0", -- Catseye Elixir
	[10593]="0:12:2:20:::1:0::0:0", -- Imperfect Draenethyst Fragment
	[10598]="0:12:1:1:::1:0::4:0", -- Hetaera's Bloodied Head
	[10599]="0:12:1:1:::1:0::4:0", -- Hetaera's Beaten Head
	[10600]="0:12:1:1:::1:0::4:0", -- Hetaera's Bruised Head
	[10601]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Bright-Eye Goggles
	[10602]="3000:9:1:1:Engineering::1:1:8679,45843:0:0", -- Schematic: Deadly Scope
	[10603]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Catseye Ultra Goggles
	[10604]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Mithril Heavy-Bore Rifle
	[10605]="0:9:3:1:Engineering::1:0::0:0", -- Schematic: Spellpower Goggles Xtreme
	[10606]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Parachute Cloak
	[10607]="0:9:1:1:Engineering::1:0::0:0", -- Schematic: Deepdive Helmet
	[10608]="0:9:3:1:Engineering::1:0::0:0", -- Schematic: Sniper Scope
	[10609]="4000:9:1:1:Engineering::1:1:2688,35826:0:0", -- Schematic: Mithril Mechanical Dragonling
	[10610]="0:12:1:1:::1:0::4:0", -- Hetaera's Blood
	[10620]="0:7:1:20:MetalStone:171,186:1:0::0:0", -- Thorium Ore
	[10621]="0:0:1:1:Consumable::1:0::3:0", -- Runed Scroll
	[10622]="0:12:1:1:::1:0::4:0", -- Kadrak's Flag
	[10623]="0:2:3:1:OneHandAxe::1:0::2:0", -- Winter's Bite
	[10624]="0:2:3:1:Bow::1:0::2:0", -- Stinging Bow
	[10625]="0:2:3:1:Dagger::1:0::2:0", -- Stealthblade
	[10626]="0:2:3:1:TwoHandMace::1:0::2:0", -- Ragehammer
	[10627]="0:2:3:1:Stave::1:0::2:0", -- Bludgeon of the Grinning Dog
	[10628]="0:2:3:1:TwoHandSword::1:0::2:0", -- Deathblow
	[10629]="0:4:3:1:Cloth::1:0::2:0", -- Mistwalker Boots
	[10630]="0:4:3:1:Cloth::1:0::2:0", -- Soulcatcher Halo
	[10631]="0:4:3:1:Mail::1:0::2:0", -- Murkwater Gauntlets
	[10632]="0:4:3:1:Mail::1:0::2:0", -- Slimescale Bracers
	[10633]="0:4:3:1:Plate::1:0::2:0", -- Silvershell Leggings
	[10634]="0:4:3:1:Ring::1:0::2:0", -- Mindseye Circle
	[10635]="0:4:1:1:Mail::1:0::3:0", -- Painted Chain Leggings
	[10636]="0:4:1:1:Leather::1:0::3:0", -- Nomadic Gloves
	[10637]="0:4:2:1:Cloth::1:0::3:0", -- Brewer's Gloves
	[10638]="0:4:2:1:Cloak::1:0::3:0", -- Long Draping Cape
	[10639]="0:12:1:20:::1:0::4:0", -- Hyacinth Mushroom
	[10640]="0:12:1:20:::1:0::4:0", -- Webwood Ichor
	[10641]="0:12:1:20:::1:0::4:0", -- Moonpetal Lily
	[10642]="0:12:1:1:::1:0::4:0", -- Iverron's Antidote
	[10643]="0:12:1:1:::1:0::4:0", -- Sealed Letter to Ag'tor
	[10644]="0:9:1:1:Alchemy::1:0::0:0", -- Recipe: Goblin Rocket Fuel
	[10645]="0:4:1:1:Trinket::1:0::3:0", -- Gnomish Death Ray
	[10646]="0:7:1:20:Explosive::1:0::0:0", -- Goblin Sapper Charge
	[10647]="2000:7:1:10:Part:202:1:0:1316,1448,1694,2685,2687,2688,3133,3413,3495,4581,4587,4941,5175,5519,6777,8679,9676,11185,14337,14637,16657,16782,17222,17421,18278,18484,18752,18775,19383,19575,19661,20890,21112,26600,26898,27711,28722,28797,29688,29907,30345,30434,30825,31776,31781,33594,33634,33669,33677,37904,37935,41435,41493,41675,41890,42488,42676,42876,42909,42972,43705,43708,43709,43710,43711,44005,44194,44280,44305,45293,45294,45546,45843,47340,47530,48056,48238,49409,49433,49702,49788,49918,50460,52637,52655:0:0", -- Engineer's Ink
	[10648]="125:7:1:20:Other:202,773:1:0:66,1250,1316,1448,1692,1694,2118,2685,2687,2688,3081,3133,3168,3187,3413,3495,3614,4581,4587,4941,5175,5519,5817,6777,8363,8679,8934,9676,11185,14337,14637,16261,16262,16602,16657,16782,16826,17222,17421,17490,18015,18278,18484,18752,18775,18907,18960,19015,19017,19042,19194,19197,19345,19372,19383,19450,19497,19533,19562,19573,19575,19661,20081,20092,20194,20250,20890,20891,21083,21112,21113,22099,22271,23363,23802,24054,24147,24188,24341,24356,25034,26374,26474,26600,26720,26898,26916,26939,26941,26959,26977,26995,27012,27021,27026,27043,27057,27063,27070,27132,27143,27146,27184,27195,27711,27938,28692,28722,28723,28794,28797,28806,28831,28872,29208,29270,29277,29688,29907,30311,30345,30434,30438,30723,30724,30727,30729,30730,30731,30732,30733,30734,30735,30825,31115,31776,31781,32477,32639,32641,33594,33598,33634,33638,33669,33677,33679,36695,36779,37904,37935,38783,38853,41435,41493,41675,41890,42488,42676,42853,42876,42909,42972,43149,43558,43705,43708,43709,43710,43711,44005,44034,44194,44280,44305,44322,45293,45294,45546,45552,45843,46718,47340,47530,48056,48238,48581,48860,49409,49433,49579,49595,49702,49703,49752,49765,49788,49805,49918,50248,50460,52637,52655,53415:0:0", -- Common Parchment
	[10649]="0:12:1:1:::1:0::4:0", -- Nightmare Shard
	[10652]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Will of the Mountain Giant
	[10653]="0:4:2:1:Leather::1:0::3:0", -- Trailblazer Boots
	[10654]="0:4:2:1:Cloth::1:0::3:0", -- Jutebraid Gloves
	[10655]="0:4:1:1:Cloth::1:0::3:0", -- Sedgeweed Britches
	[10656]="0:4:1:1:Mail::1:0::3:0", -- Barkmail Vest
	[10657]="0:4:2:1:Cloth::1:0::3:0", -- Talbar Mantle
	[10658]="0:4:2:1:Mail::1:0::3:0", -- Quagmire Galoshes
	[10659]="0:4:2:1:Trinket::1:0::3:0", -- Shard of Afrasa
	[10660]="0:12:1:1:::1:0::4:0", -- First Mosh'aru Tablet
	[10661]="0:12:1:1:::1:0::4:0", -- Second Mosh'aru Tablet
	[10662]="0:12:1:1:::1:0::4:0", -- Filled Egg of Hakkar
	[10663]="0:0:1:1:Consumable::1:0::4:0", -- Essence of Hakkar
	[10664]="0:12:1:1:::1:0::3:0", -- A Note to Magus Rimtori
	[10678]="0:12:1:1:::1:0::4:0", -- Magatha's Note
	[10679]="0:12:1:1:::1:0::4:0", -- Andron's Note
	[10680]="0:12:1:1:::1:0::4:0", -- Jes'rimon's Note
	[10681]="0:12:1:1:::1:0::4:0", -- Xylem's Note
	[10682]="0:12:1:1:::1:0::4:0", -- Belnistrasz's Oathstone
	[10684]="2000:0:1:1:Consumable::1:0:7772:3:0", -- Colossal Parachute
	[10686]="0:4:3:1:Shield::1:0::3:0", -- Aegis of Battle
	[10687]="0:0:1:1:Consumable::1:0::3:0", -- Empty Vial Labeled #1
	[10688]="0:0:1:1:Consumable::1:0::3:0", -- Empty Vial Labeled #2
	[10689]="0:0:1:1:Consumable::1:0::3:0", -- Empty Vial Labeled #3
	[10690]="0:0:1:1:Consumable::1:0::3:0", -- Empty Vial Labeled #4
	[10691]="0:12:1:1:::1:0::4:0", -- Filled Vial Labeled #1
	[10692]="0:12:1:1:::1:0::4:0", -- Filled Vial Labeled #2
	[10693]="0:12:1:1:::1:0::4:0", -- Filled Vial Labeled #3
	[10694]="0:12:1:1:::1:0::4:0", -- Filled Vial Labeled #4
	[10695]="0:15:1:1:Junk::1:0::3:0", -- Box of Empty Vials
	[10696]="0:2:2:1:OneHandSword::1:0::3:0", -- Enchanted Azsharite Felbane Sword
	[10697]="0:2:2:1:Dagger::1:0::3:0", -- Enchanted Azsharite Felbane Dagger
	[10698]="0:2:2:1:Stave::1:0::3:0", -- Enchanted Azsharite Felbane Staff
	[10699]="0:12:1:1:::1:0::4:0", -- Yeh'kinya's Bramble
	[10700]="0:4:2:1:Cloth::1:0::3:0", -- Encarmine Boots
	[10701]="0:4:2:1:Mail::1:0::3:0", -- Boots of Zua'tec
	[10702]="0:4:2:1:Leather::1:0::3:0", -- Enormous Ogre Boots
	[10703]="0:2:2:1:Dagger::1:0::3:0", -- Fiendish Skiv
	[10704]="0:2:2:1:Wand::1:0::3:0", -- Chillnail Splinter
	[10705]="0:4:2:1:Cloth::1:0::3:0", -- Firwillow Wristbands
	[10706]="0:4:2:1:Mail::1:0::3:0", -- Nightscale Girdle
	[10707]="0:4:2:1:Plate::1:0::3:0", -- Steelsmith Greaves
	[10708]="0:4:2:1:OffHandFrill::1:0::3:0", -- Skullspell Orb
	[10709]="0:4:2:1:OffHandFrill::1:0::3:0", -- Pyrestone Orb
	[10710]="0:4:3:1:Ring::1:0::3:0", -- Dragonclaw Ring
	[10711]="0:4:3:1:Amulet::1:0::3:0", -- Dragon's Blood Necklace
	[10712]="0:12:1:1:::1:0::4:0", -- Cuely's Elixir
	[10713]="0:9:1:1:Blacksmithing::1:0::0:0", -- Plans: Inlaid Mithril Cylinder
	[10714]="0:12:1:20:::1:0::4:0", -- Crystallized Azsharite
	[10715]="0:12:1:1:::1:0::4:0", -- Kim'Jael's Scope
	[10716]="0:4:2:1:Trinket::1:0::2:0", -- Gnomish Shrink Ray
	[10717]="0:12:1:1:::1:0::4:0", -- Kim'Jael's Compass
	[10718]="0:12:1:1:::1:0::4:0", -- Kim'Jael's Wizzlegoober
	[10720]="0:4:2:1:Trinket::1:0::2:0", -- Gnomish Net-o-Matic Projector
	[10721]="0:4:2:1:Leather::1:0::2:0", -- Gnomish Harm Prevention Belt
	[10722]="0:12:1:1:::1:0::4:0", -- Kim'Jael's Stuffed Chicken
	[10723]="0:4:1:10:Trinket::1:0::0:0", -- Gnomish Ham Radio
	[10724]="0:4:2:1:Cloth::1:0::2:0", -- Gnomish Rocket Boots
	[10725]="0:4:1:1:Trinket::1:0::3:0", -- Gnomish Battle Chicken
	[10726]="0:4:2:1:Cloth::1:0::2:0", -- Gnomish Mind Control Cap
	[10727]="0:4:1:1:Trinket::1:0::3:0", -- Goblin Dragon Gun
	[10728]="1500:9:1:1:Tailoring::1:1:2663:0:0", -- Pattern: Black Swashbuckler's Shirt
	[10738]="0:12:1:1:::1:0::4:0", -- Shipment to Galvan
	[10739]="0:4:2:1:Ring::1:0::3:0", -- Ring of Fortitude
	[10740]="0:4:2:1:Plate::1:0::3:0", -- Centurion Legplates
	[10741]="0:4:2:1:Leather::1:0::3:0", -- Lordrec Helmet
	[10742]="0:4:2:1:Cloth::1:0::3:0", -- Dragonflight Leggings
	[10743]="0:4:2:1:Mail::1:0::3:0", -- Drakefire Headguard
	[10744]="0:2:2:1:OneHandAxe::1:0::3:0", -- Axe of the Ebon Drake
	[10745]="0:4:2:1:Leather::1:0::3:0", -- Kaylari Shoulders
	[10746]="0:4:2:1:Plate::1:0::3:0", -- Runesteel Vambraces
	[10747]="0:4:2:1:Cloth::1:0::3:0", -- Teacher's Sash
	[10748]="0:4:2:1:Leather::1:0::3:0", -- Wanderlust Boots
	[10749]="0:4:3:1:Plate::1:0::3:0", -- Avenguard Helm
	[10750]="0:2:3:1:Dagger::1:0::3:0", -- Lifeforce Dirk
	[10751]="0:4:3:1:Cloth::1:0::3:0", -- Gemburst Circlet
	[10752]="0:15:2:1:Junk::1:0::3:0", -- Emerald Encrusted Chest
	[10753]="0:12:1:1:::1:0::4:0", -- Amulet of Grol
	[10754]="0:12:1:1:::1:0::4:0", -- Amulet of Sevine
	[10755]="0:12:1:1:::1:0::4:0", -- Amulet of Allistarj
	[10757]="0:12:1:1:::1:0::4:0", -- Ward of the Defiler
	[10758]="0:2:3:1:TwoHandSword::1:0::3:0", -- X'caliboar
	[10759]="0:12:1:1:::1:0::4:0", -- Severed Horn of the Defiler
	[10760]="0:4:3:1:Leather::1:0::3:0", -- Swine Fists
	[10761]="0:2:3:1:Dagger::1:0::3:0", -- Coldrage Dagger
	[10762]="0:4:3:1:Cloth::1:0::3:0", -- Robes of the Lich
	[10763]="0:4:3:1:Plate::1:0::3:0", -- Icemetal Barbute
	[10764]="0:4:3:1:Mail::1:0::3:0", -- Deathchill Armor
	[10765]="0:4:3:1:Leather::1:0::3:0", -- Bonefingers
	[10766]="0:2:3:1:Wand::1:0::3:0", -- Plaguerot Sprig
	[10767]="0:4:3:1:Shield::1:0::3:0", -- Savage Boar's Guard
	[10768]="0:4:3:1:Mail::1:0::3:0", -- Boar Champion's Belt
	[10769]="0:4:3:1:Amulet::1:0::3:0", -- Glowing Eye of Mordresh
	[10770]="0:4:3:1:OffHandFrill::1:0::3:0", -- Mordresh's Lifeless Skull
	[10771]="0:4:3:1:Cloth::1:0::3:0", -- Deathmage Sash
	[10772]="0:2:3:1:OneHandAxe::1:0::3:0", -- Glutton's Cleaver
	[10773]="0:15:2:1:Junk::1:0::3:0", -- Hakkari Urn
	[10774]="0:4:3:1:Leather::1:0::3:0", -- Fleshhide Shoulders
	[10775]="0:4:3:1:Plate::1:0::3:0", -- Carapace of Tuten'kash
	[10776]="0:4:3:1:Cloak::1:0::3:0", -- Silky Spider Cape
	[10777]="0:4:3:1:Leather::1:0::3:0", -- Arachnid Gloves
	[10778]="0:4:2:1:Amulet::1:0::3:0", -- Necklace of Sanctuary
	[10779]="0:4:2:1:Trinket::1:0::3:0", -- Demon's Blood
	[10780]="0:4:2:1:Ring::1:0::3:0", -- Mark of Hakkar
	[10781]="0:4:2:1:Leather::1:0::3:0", -- Hakkari Breastplate
	[10782]="0:4:2:1:Cloth::1:0::3:0", -- Hakkari Shroud
	[10783]="0:4:3:1:Leather::1:0::3:0", -- Atal'ai Spaulders
	[10784]="0:4:3:1:Mail::1:0::3:0", -- Atal'ai Breastplate
	[10785]="0:4:3:1:Leather::1:0::3:0", -- Atal'ai Leggings
	[10786]="0:4:3:1:Mail::1:0::3:0", -- Atal'ai Boots
	[10787]="0:4:3:1:Cloth::1:0::3:0", -- Atal'ai Gloves
	[10788]="0:4:3:1:Plate::1:0::3:0", -- Atal'ai Girdle
	[10789]="0:12:1:1:::1:0::4:0", -- Manual of Engineering Disciplines
	[10790]="0:12:0:1:::1:0::3:0", -- Gnome Engineer Membership Card
	[10791]="0:12:0:1:::1:0::3:0", -- Goblin Engineer Membership Card
	[10792]="0:12:1:1:::1:0::4:0", -- Nixx's Pledge of Secrecy
	[10793]="0:12:1:1:::1:0::4:0", -- Overspark's Pledge of Secrecy
	[10794]="0:12:1:1:::1:0::4:0", -- Oglethorpe's Pledge of Secrecy
	[10795]="0:4:3:1:Ring::1:0::3:0", -- Drakeclaw Band
	[10796]="0:4:3:1:OffHandFrill::1:0::3:0", -- Drakestone
	[10797]="0:2:3:1:OneHandSword::1:0::3:0", -- Firebreather
	[10798]="0:4:3:1:Plate::1:0::3:0", -- Atal'alarion's Tusk Ring
	[10799]="0:2:3:1:Polearm::1:0::3:0", -- Headspike
	[10800]="0:4:3:1:Leather::1:0::3:0", -- Darkwater Bracers
	[10801]="0:4:3:1:Leather::1:0::3:0", -- Slitherscale Boots
	[10802]="0:4:3:1:Cloak::1:0::3:0", -- Wingveil Cloak
	[10803]="0:2:3:1:OneHandSword::1:0::3:0", -- Blade of the Wretched
	[10804]="0:2:3:1:OneHandMace::1:0::3:0", -- Fist of the Damned
	[10805]="0:2:3:1:OneHandAxe::1:0::3:0", -- Eater of the Dead
	[10806]="0:4:3:1:Cloth::1:0::3:0", -- Vestments of the Atal'ai Prophet
	[10807]="0:4:3:1:Cloth::1:0::3:0", -- Kilt of the Atal'ai Prophet
	[10808]="0:4:3:1:Cloth::1:0::3:0", -- Gloves of the Atal'ai Prophet
	[10818]="0:12:1:1:::1:0::3:0", -- Yeh'kinya's Scroll
	[10819]="0:12:1:20:::1:0::4:0", -- Wildkin Feather
	[10820]="0:4:2:1:Cloth::1:0::3:0", -- Jackseed Belt
	[10821]="0:4:2:1:Cloak::1:0::3:0", -- Sower's Cloak
	[10822]="0:15:1:1:Companion::1:0::0:0", -- Dark Whelpling
	[10823]="0:2:3:1:OneHandSword::1:0::3:0", -- Vanquisher's Sword
	[10824]="0:4:3:1:Amulet::1:0::3:0", -- Amberglow Talisman
	[10826]="0:2:2:1:Stave::1:0::3:0", -- Staff of Lore
	[10827]="0:4:2:1:Leather::1:0::3:0", -- Surveyor's Tunic
	[10828]="0:2:3:1:Dagger::1:0::3:0", -- Dire Nail
	[10829]="0:4:3:1:Amulet::1:0::3:0", -- The Dragon's Eye
	[10830]="0:0:1:10:Consumable::1:0::3:0", -- M73 Frag Grenade
	[10831]="0:12:1:1:::1:0::3:0", -- Fel Orb
	[10832]="0:12:1:1:::1:0::3:0", -- Fel Tracker Owner's Manual
	[10833]="0:4:3:1:Mail::1:0::3:0", -- Horns of Eranikus
	[10834]="0:15:1:1:Junk::1:0::3:0", -- Felhound Tracker Kit
	[10835]="0:4:3:1:Shield::1:0::3:0", -- Crest of Supremacy
	[10836]="0:2:3:1:Wand::1:0::3:0", -- Rod of Corrosion
	[10837]="0:2:3:1:OneHandAxe::1:0::3:0", -- Tooth of Eranikus
	[10838]="0:2:3:1:OneHandMace::1:0::3:0", -- Might of Hakkar
	[10839]="0:15:0:20:Junk::1:0::0:0", -- Crystallized Note
	[10840]="0:15:0:20:Junk::1:0::0:0", -- Crystallized Note
	[10841]="0:0:1:20:FoodDrink::1:0::0:0", -- Goldthorn Tea
	[10842]="0:4:3:1:Leather::1:0::3:0", -- Windscale Sarong
	[10843]="0:4:3:1:Cloak::1:0::3:0", -- Featherskin Cape
	[10844]="0:2:3:1:Stave::1:0::3:0", -- Spire of Hakkar
	[10845]="0:4:3:1:Plate::1:0::3:0", -- Warrior's Embrace
	[10846]="0:4:3:1:Mail::1:0::3:0", -- Bloodshot Greaves
	[10847]="0:2:4:1:OneHandSword::1:0::3:0", -- Dragon's Call
	[10858]="3000:9:1:1:Blacksmithing::1:1:1471,8878,26081:0:0", -- Plans: Solid Iron Maul
	[10918]="50:0:1:20:EnhTemp::1:0:1325,1326,2622,3090,3135,3334,3405,3490,3551,3561,3969,4585,5139,5169,6779,10364,12096,15175,16268,16588,16683,16829,18006,18019,18802,19013,19014,19049,19239,19679,20081,20121,20194,20915,20986,22479,23145,23373,23732,24148,24313,24357,24780,25043,25736,26382,26568,26598,26900,26945,27031,27038,27053,27089,27133,27149,27176,27186,28347,28832,28869,29015,29037,29535,29561,29909,29922,29947,29961,30010,30244,30306,30438,31115,32639,32641,33630,33674,35642,39144,39878,41275,41490,41508,41676,41891,42622,42878,42910,42967,43155,43381,43411,43493,43547,43551,43555,43563,43646,43774,44047,44187,44313,44333,44970,45289,45290,45361,47860,53040,53076:0:0", -- Wound Poison
	[10919]="0:4:2:1:Cloth::1:0::3:0", -- Apothecary Gloves
	[10920]="0:0:1:20:EnhTemp::1:0::0:0", -- Wound Poison
	[10921]="0:0:1:20:EnhTemp::1:0::0:0", -- Wound Poison
	[10922]="0:0:1:20:EnhTemp::1:0::0:0", -- Wound Poison
	[10938]="800:7:2:10:Enchanting:333:1:1:1318,3012,3346,4228,4617,5158,5757,5758,15419,16635,16722,18753,18773,18951,19234,19537,19540,19663,26569,27030,27039,27054,27147,28714,28715,29537,33597,33633,33676,36365,44030,44321,44381,50458,50459,53410:0:0", -- Lesser Magic Essence
	[10939]="0:7:2:10:Enchanting:333:1:0::0:0", -- Greater Magic Essence
	[10940]="800:7:1:20:Enchanting:333:1:1:1318,3012,3346,4228,4617,5158,5757,5758,15419,16635,16722,18753,18773,18951,19234,19537,19540,19663,26569,27030,27039,27054,27147,28714,28715,29537,33597,33633,33676,36365,44030,44321,44381,50458,50459,53410:0:0", -- Strange Dust
	[10958]="0:12:1:1:::1:0::4:0", -- Nida's Necklace
	[10959]="0:1:2:1:Bag::1:0::3:0", -- Demon Hide Sack
	[10978]="0:7:3:20:Enchanting:333:1:0::0:0", -- Small Glimmering Shard
	[10998]="0:7:2:10:Enchanting:333:1:0::0:0", -- Lesser Astral Essence
	[10999]="0:12:1:1:::1:0::4:0", -- Ironfel
	[11000]="0:13:1:1:::1:0::3:0", -- Shadowforge Key
	[11018]="0:12:1:100:::1:0::0:0", -- Un'Goro Soil
	[11020]="10000:12:1:1:::1:0:4217,9087:3:0", -- Evergreen Pouch
	[11022]="1000:12:1:20:::1:0:4217,9087:0:0", -- Packet of Tharlendris Seeds
	[11023]="10000:15:1:1:Companion::1:0:41135:0:0", -- Ancona Chicken
	[11024]="0:12:1:1:::1:0::3:0", -- Evergreen Herb Casing
	[11026]="10000:15:1:1:Companion::1:0:14860:0:0", -- Tree Frog Box
	[11027]="10000:15:1:1:Companion::1:1:14860:0:0", -- Wood Frog Box
	[11038]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant 2H Weapon - Lesser Spirit
	[11039]="800:9:2:1:Enchanting::1:1:3954,12043:0:0", -- Formula: Enchant Cloak - Minor Agility
	[11040]="0:12:1:20:::1:0::0:0", -- Morrowgrain
	[11078]="0:13:1:20:::1:0::0:0", -- Relic Coffer Key
	[11079]="0:12:1:1:::1:0::4:0", -- Gor'tesh's Lopped Off Head
	[11080]="0:12:1:1:::1:0::4:0", -- Gor'tesh's Lopped Off Head
	[11081]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Shield - Lesser Protection
	[11082]="0:7:2:10:Enchanting:333:1:0::0:0", -- Greater Astral Essence
	[11083]="0:7:1:20:Enchanting:333,755:1:0::0:0", -- Soul Dust
	[11084]="0:7:3:20:Enchanting:333:1:0::0:0", -- Large Glimmering Shard
	[11086]="0:2:3:1:OneHandSword::1:0::3:0", -- Jang'thraze the Protector
	[11098]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Cloak - Lesser Shadow Resistance
	[11101]="2500:9:2:1:Enchanting::1:1:3954,12043:0:0", -- Formula: Enchant Bracer - Lesser Strength
	[11102]="0:12:1:1:::1:0::3:0", -- Unhatched Sprite Darter Egg
	[11103]="0:12:1:1:::1:0::4:0", -- Seed Voucher
	[11106]="0:13:1:1:::1:0::4:0", -- Lion-Headed Key
	[11109]="25:0:1:1:FoodDrink::1:0:233,33996:0:0", -- Special Chicken Feed
	[11110]="0:15:1:1:Companion::1:0::3:0", -- Chicken Egg
	[11112]="0:12:1:1:::1:0::4:0", -- Research Equipment
	[11113]="0:12:1:1:::1:0::4:0", -- Crate of Foodstuffs
	[11114]="0:12:1:20:::1:0::4:0", -- Dinosaur Bone
	[11118]="0:4:3:1:Ring::1:0::3:0", -- Archaedic Stone
	[11119]="0:12:1:20:::1:0::4:0", -- Milly's Harvest
	[11120]="0:2:2:1:OneHandMace::1:0::3:0", -- Belgrom's Hammer
	[11121]="0:2:3:1:OneHandSword::1:0::3:0", -- Darkwater Talwar
	[11122]="0:4:2:1:Trinket::1:0::3:0", -- Carrot on a Stick
	[11123]="0:4:3:1:Cloth::1:0::3:0", -- Rainstrider Leggings
	[11124]="0:4:3:1:Mail::1:0::3:0", -- Helm of Exile
	[11125]="0:12:1:1:::1:0::4:0", -- Grape Manifest
	[11126]="0:12:1:1:::1:0::4:0", -- Tablet of Kurniya
	[11127]="0:12:1:20:::1:0::4:0", -- Scavenged Goods
	[11128]="0:7:1:1:Enchanting:333:1:0::0:0", -- Golden Rod
	[11129]="0:12:1:20:::1:0::4:0", -- Essence of the Elements
	[11130]="0:7:2:1:Enchanting:333:1:0::3:0", -- Runed Golden Rod
	[11131]="0:12:1:1:::1:0::4:0", -- Hive Wall Sample
	[11132]="0:12:1:1:::1:0::4:0", -- Unused Scraping Vial
	[11133]="0:12:1:1:::1:0::4:0", -- Linken's Training Sword
	[11134]="0:7:2:10:Enchanting:333:1:0::0:0", -- Lesser Mystic Essence
	[11135]="0:7:2:10:Enchanting:333:1:0::0:0", -- Greater Mystic Essence
	[11136]="0:12:1:1:::1:0::4:0", -- Linken's Tempered Sword
	[11137]="0:7:1:20:Enchanting:333,755,197:1:0::0:0", -- Vision Dust
	[11138]="0:7:3:20:Enchanting:333:1:0::0:0", -- Small Glowing Shard
	[11139]="0:7:3:20:Enchanting:333:1:0::0:0", -- Large Glowing Shard
	[11140]="0:13:1:1:::1:0::3:0", -- Prison Cell Key
	[11141]="0:12:1:1:::1:0::4:0", -- Bait
	[11142]="0:12:1:1:::1:0::4:0", -- Broken Samophlange
	[11143]="0:12:1:20:::1:0::4:0", -- Nugget Slug
	[11144]="0:7:1:1:Enchanting:333:1:0::0:0", -- Truesilver Rod
	[11145]="0:7:2:1:Enchanting:333:1:0::3:0", -- Runed Truesilver Rod
	[11146]="0:12:1:1:::1:0::4:0", -- Broken and Battered Samophlange
	[11147]="0:12:1:1:::1:0::4:0", -- Samophlange Manual Cover
	[11148]="0:0:1:20:Consumable::1:0::4:0", -- Samophlange Manual Page
	[11149]="0:12:1:1:::1:0::4:0", -- Samophlange Manual
	[11150]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Gloves - Mining
	[11151]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Gloves - Herbalism
	[11152]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Gloves - Fishing
	[11162]="0:12:1:1:::1:0::4:0", -- Linken's Superior Sword
	[11163]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Bracer - Lesser Dodge
	[11164]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Weapon - Lesser Beastslayer
	[11165]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Weapon - Lesser Elemental Slayer
	[11166]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Gloves - Skinning
	[11167]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Boots - Lesser Spirit
	[11168]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Shield - Lesser Parry
	[11169]="0:12:1:1:::1:0::4:0", -- Book of Aquor
	[11172]="0:12:1:20:::1:0::4:0", -- Silvery Claws
	[11173]="0:12:1:1:::1:0::4:0", -- Irontree Heart
	[11174]="0:7:2:10:Enchanting:333:1:0::0:0", -- Lesser Nether Essence
	[11175]="0:7:2:10:Enchanting:333:1:0::0:0", -- Greater Nether Essence
	[11176]="0:7:1:20:Enchanting:171,333,186,197:1:0::0:0", -- Dream Dust
	[11177]="0:7:3:20:Enchanting:333:1:0::0:0", -- Small Radiant Shard
	[11178]="0:7:3:20:Enchanting:333,755:1:0::0:0", -- Large Radiant Shard
	[11179]="0:12:1:1:::1:0::4:0", -- Golden Flame
	[11184]="0:12:1:100:::1:0::0:0", -- Blue Power Crystal
	[11185]="0:12:1:100:::1:0::0:0", -- Green Power Crystal
	[11186]="0:12:1:100:::1:0::0:0", -- Red Power Crystal
	[11187]="0:4:1:1:Cloth::1:0::3:0", -- Stemleaf Bracers
	[11188]="0:12:1:100:::1:0::0:0", -- Yellow Power Crystal
	[11189]="0:4:1:1:Cloth::1:0::3:0", -- Woodland Robes
	[11190]="0:4:1:1:Cloth::1:0::3:0", -- Viny Gloves
	[11191]="0:4:1:1:Cloth::1:0::3:0", -- Farmer's Boots
	[11192]="0:4:1:1:Cloth::1:0::3:0", -- Outfitter Gloves
	[11193]="0:4:2:1:Leather::1:0::3:0", -- Blazewind Breastplate
	[11194]="0:4:2:1:Mail::1:0::3:0", -- Prismscale Hauberk
	[11195]="0:4:2:1:Plate::1:0::3:0", -- Warforged Chestplate
	[11196]="0:4:2:1:Amulet::1:0::3:0", -- Mindburst Medallion
	[11197]="0:13:1:1:::1:0::0:0", -- Dark Keeper Key
	[11202]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Shield - Stamina
	[11203]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Gloves - Advanced Mining
	[11204]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Bracer - Greater Spirit
	[11205]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Gloves - Advanced Herbalism
	[11206]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Cloak - Lesser Agility
	[11207]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Weapon - Fiery Weapon
	[11208]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Weapon - Demonslaying
	[11222]="0:12:1:1:::1:0::4:0", -- Head of Krom'zar
	[11223]="5800:9:2:1:Enchanting::1:1:989,4229:0:0", -- Formula: Enchant Bracer - Dodge
	[11224]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Shield - Frost Resistance
	[11225]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Bracer - Greater Stamina
	[11226]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Gloves - Riding Skill
	[11227]="0:12:1:1:::1:0::4:0", -- Piece of Krom'zar's Banner
	[11229]="0:4:2:1:Mail::1:0::3:0", -- Brightscale Girdle
	[11230]="0:12:1:1:::1:0::4:0", -- Encased Fiery Essence
	[11231]="0:12:1:10:::1:0::3:0", -- Altered Black Dragonflight Molt
	[11242]="0:12:1:1:::1:0::0:0", -- Evoroot
	[11243]="0:12:1:20:::1:0::4:0", -- Videre Elixir
	[11262]="0:4:3:1:OffHandFrill::1:0::3:0", -- Orb of Lorica
	[11263]="0:2:3:1:Wand::1:0::3:0", -- Nether Force Wand
	[11265]="0:2:2:1:TwoHandMace::1:0::3:0", -- Cragwood Maul
	[11266]="0:12:1:20:::1:0::4:0", -- Fractured Elemental Shard
	[11267]="0:12:1:1:::1:0::4:0", -- Elemental Shard Sample
	[11268]="0:12:1:1:::1:0::4:0", -- Head of Argelmach
	[11269]="0:12:1:10:::1:0::4:0", -- Intact Elemental Core
	[11270]="0:12:1:1:::1:0::4:0", -- Nixx's Signed Pledge
	[11282]="0:12:1:1:::1:0::4:0", -- Oglethorpe's Signed Pledge
	[11283]="0:12:1:1:::1:0::4:0", -- Overspark's Signed Pledge
	[11284]="0:15:0:1000:Junk::1:0::0:0", -- Accurate Slugs
	[11285]="0:15:0:1000:Junk::1:0::0:0", -- Jagged Arrow
	[11286]="0:12:1:1:::1:0::4:0", -- Thorium Shackles
	[11287]="0:2:2:1:Wand::1:0::2:0", -- Lesser Magic Wand
	[11288]="0:2:2:1:Wand::1:0::2:0", -- Greater Magic Wand
	[11289]="0:2:2:1:Wand::1:0::2:0", -- Lesser Mystic Wand
	[11290]="0:2:2:1:Wand::1:0::2:0", -- Greater Mystic Wand
	[11291]="4500:7:1:20:Other:333,202:1:0:1318,3012,3346,4228,4617,5158,5757,5758,15419,16635,16722,18753,18773,18951,19234,19537,19540,19663,26569,27030,27039,27054,27147,28714,28715,29537,33597,33633,33676,36365,44030,44321,44381,50458,50459,53410:0:0", -- Star Wood
	[11302]="0:4:3:1:Trinket::1:0::2:0", -- Uther's Strength
	[11303]="3185:2:2:1:Bow::1:1:1198,1298,3015,3322,4173,4604,5122:2:0", -- Fine Shortbow
	[11304]="4862:2:2:1:Bow::1:1:228,1459,1668,1687,3488,3534,9549,9553,41452:2:0", -- Fine Longbow
	[11305]="25814:2:2:1:Bow::1:1:2839,3951,4892,9552,9555,41452:2:0", -- Dense Shortbow
	[11306]="19468:2:2:1:Bow::1:1:1298,3015,3322,4173,4604:2:0", -- Sturdy Recurve
	[11307]="67952:2:2:1:Bow::1:1:1298,3015,3322,4604,24028:2:0", -- Massive Longbow
	[11308]="78829:2:2:1:Bow::1:1:4173,9548,12029,19499,24028,48577,49605:2:0", -- Sylvan Shortbow
	[11309]="0:12:1:1:::1:0::4:0", -- The Heart of the Mountain
	[11310]="0:4:3:1:Cloth::1:0::3:0", -- Flameseer Mantle
	[11311]="0:4:3:1:Cloak::1:0::3:0", -- Emberscale Cape
	[11312]="0:12:1:1:::1:0::4:0", -- Lost Thunderbrew Recipe
	[11313]="0:12:1:1:::1:0::4:0", -- Ribbly's Head
	[11315]="0:12:1:100:::1:0::3:0", -- Bloodpetal Sprout
	[11316]="0:12:1:20:::1:0::4:0", -- Bloodpetal
	[11319]="0:12:1:1:::1:0::4:0", -- Unloaded Zapper
	[11320]="0:12:1:1:::1:0::4:0", -- Bloodpetal Zapper
	[11324]="0:1:1:1:Bag::1:0::3:0", -- Explorer's Knapsack
	[11325]="600:0:1:20:Other::1:1:9499:0:0", -- Dark Iron Ale Mug
	[11362]="0:1:1:1:Bag::1:0::0:0", -- Medium Quiver
	[11363]="0:1:1:1:Bag::1:0::0:0", -- Medium Shot Pouch
	[11364]="0:4:1:1:Tabard::1:0::3:0", -- Tabard of Stormwind
	[11366]="0:12:1:1:::1:0::4:0", -- Helendis Riverhorn's Letter
	[11367]="0:12:1:1:::1:0::4:0", -- Solomon's Plea to King Wrynn
	[11368]="0:12:1:1:::1:0::4:0", -- Wrynn's Decree
	[11370]="0:7:1:20:MetalStone:186:1:0::0:0", -- Dark Iron Ore
	[11371]="0:7:1:20:MetalStone:164,202,755:1:0::0:0", -- Dark Iron Bar
	[11382]="0:3:2:20:GemSimple:164,755:1:0::0:0", -- Blood of the Mountain
	[11384]="0:15:0:20:Junk::1:0::0:0", -- Broken Basilisk Teeth
	[11385]="0:15:0:20:Junk::1:0::0:0", -- Basilisk Scale
	[11386]="0:15:0:20:Junk::1:0::0:0", -- Squishy Basilisk Eye
	[11387]="0:15:0:20:Junk::1:0::0:0", -- Basilisk Heart
	[11388]="0:15:0:20:Junk::1:0::0:0", -- Basilisk Venom
	[11389]="0:15:0:20:Junk::1:0::0:0", -- Shimmering Basilisk Skin
	[11390]="0:15:0:20:Junk::1:0::0:0", -- Broken Bat Fang
	[11391]="0:15:0:20:Junk::1:0::0:0", -- Spined Bat Wing
	[11392]="0:15:0:20:Junk::1:0::0:0", -- Severed Bat Claw
	[11393]="0:15:0:20:Junk::1:0::0:0", -- Small Bat Skull
	[11394]="0:15:0:20:Junk::1:0::0:0", -- Bat Heart
	[11395]="0:15:0:20:Junk::1:0::0:0", -- Bat Ear
	[11402]="0:15:0:20:Junk::1:0::0:0", -- Sleek Bat Pelt
	[11403]="0:15:0:20:Junk::1:0::0:0", -- Large Bat Fang
	[11404]="0:12:1:10:::1:0::0:0", -- Evil Bat Eye
	[11405]="0:0:1:20:Consumable::1:0::4:0", -- Giant Silver Vein
	[11406]="0:15:0:20:Junk::1:0::0:0", -- Rotting Bear Carcass
	[11407]="0:12:1:10:::1:0::0:0", -- Torn Bear Pelt
	[11408]="0:15:0:20:Junk::1:0::0:0", -- Bear Jaw
	[11409]="0:15:0:20:Junk::1:0::0:0", -- Bear Organ
	[11410]="0:15:0:20:Junk::1:0::0:0", -- Savage Bear Claw
	[11411]="0:2:0:1:OneHandMace::1:0::0:0", -- Large Bear Bone
	[11412]="0:12:1:1:::1:0::4:0", -- Nagmara's Vial
	[11413]="0:0:1:1:Consumable::1:0::4:0", -- Nagmara's Filled Vial
	[11414]="0:15:0:20:Junk::1:0::0:0", -- Grizzled Mane
	[11415]="0:0:1:20:FoodDrink::1:0::0:0", -- Mixed Berries
	[11416]="0:15:0:20:Junk::1:0::0:0", -- Delicate Ribcage
	[11417]="0:15:0:20:Junk::1:0::0:0", -- Feathery Wing
	[11418]="0:15:0:20:Junk::1:0::0:0", -- Hollow Wing Bone
	[11419]="0:15:0:20:Junk::1:0::0:0", -- Mysterious Unhatched Egg
	[11420]="0:15:0:20:Junk::1:0::0:0", -- Elegant Writing Tool
	[11422]="0:15:1:1:Junk::1:0::3:0", -- Goblin Engineer's Renewal Gift
	[11423]="0:15:1:1:Junk::1:0::3:0", -- Gnome Engineer's Renewal Gift
	[11444]="4000:0:1:20:FoodDrink::5:0:9499:0:0", -- Grim Guzzler Boar
	[11445]="0:12:1:1:::1:0::4:0", -- Flute of the Ancients
	[11446]="0:12:1:1:::1:0::3:0", -- A Crumpled Up Note
	[11462]="0:12:1:1:::1:0::4:0", -- Discarded Knife
	[11463]="0:15:0:1:Junk::1:0::3:0", -- Undelivered Parcel
	[11464]="0:12:1:1:::1:0::4:0", -- Marshal Windsor's Lost Information
	[11465]="0:12:1:1:::1:0::4:0", -- Marshal Windsor's Lost Information
	[11466]="0:12:1:1:::1:0::4:0", -- Raschal's Report
	[11467]="0:12:1:50:::1:0::4:0", -- Blackrock Medallion
	[11468]="0:12:1:20:::1:0::4:0", -- Dark Iron Fanny Pack
	[11469]="0:4:2:1:Cloth::1:0::3:0", -- Bloodband Bracers
	[11470]="0:12:1:1:::1:0::4:0", -- Tablet Transcript
	[11471]="0:12:1:1:::1:0::3:0", -- Fragile Sprite Darter Egg
	[11472]="0:12:1:10:::1:0::4:0", -- Silvermane Stalker Flank
	[11474]="0:15:1:1:Companion::1:0::3:0", -- Sprite Darter Egg
	[11475]="0:4:1:1:Cloak::1:0::3:0", -- Wine-Stained Cloak
	[11476]="0:12:1:1:::1:0::4:0", -- U'cha's Pelt
	[11477]="0:12:1:10:::1:0::4:0", -- White Ravasaur Claw
	[11478]="0:12:1:10:::1:0::4:0", -- Un'Goro Gorilla Pelt
	[11479]="0:12:1:10:::1:0::4:0", -- Un'Goro Stomper Pelt
	[11480]="0:12:1:10:::1:0::4:0", -- Un'Goro Thunderer Pelt
	[11482]="0:15:0:1:Junk::1:0::0:0", -- Crystal Pylon User's Manual
	[11502]="0:4:2:1:Leather::1:0::3:0", -- Loreskin Shoulders
	[11503]="0:12:1:20:::1:0::4:0", -- Blood Amber
	[11504]="0:12:1:1:::1:0::4:0", -- Piece of Threshadon Carcass
	[11507]="0:12:1:20:::1:0::4:0", -- Spotted Hyena Pelt
	[11508]="0:4:1:1:Cloth::1:0::3:0", -- Gamemaster's Slippers
	[11509]="0:12:1:5:::1:0::4:0", -- Ravasaur Pheromone Gland
	[11510]="0:12:1:1:::1:0::4:0", -- Lar'korwi's Head
	[11511]="0:12:1:1:::1:0::4:0", -- Cenarion Beacon
	[11512]="0:12:1:20:::1:0::3:0", -- Patch of Tainted Skin
	[11513]="0:12:1:20:::1:0::3:0", -- Tainted Vitriol
	[11514]="0:12:1:20:::1:0::3:0", -- Fel Creep
	[11515]="0:12:1:20:::1:0::3:0", -- Corrupted Soul Shard
	[11516]="0:12:1:100:::1:0::3:0", -- Cenarion Plant Salve
	[11522]="0:4:1:1:OffHandFrill::1:0::4:0", -- Silver Totem of Aquementas
	[11562]="0:12:1:20:::1:0::3:0", -- Crystal Restore
	[11563]="0:12:1:20:::1:0::3:0", -- Crystal Force
	[11564]="0:12:1:20:::1:0::3:0", -- Crystal Ward
	[11565]="0:12:1:20:::1:0::3:0", -- Crystal Yield
	[11566]="0:12:1:20:::1:0::3:0", -- Crystal Charge
	[11567]="0:12:1:20:::1:0::3:0", -- Crystal Spire
	[11568]="0:12:1:1:::1:0::4:0", -- Torwa's Pouch
	[11569]="0:12:1:1:::1:0::4:0", -- Preserved Threshadon Meat
	[11570]="0:12:1:1:::1:0::4:0", -- Preserved Pheromone Mixture
	[11582]="0:15:1:1:Junk::1:0::3:0", -- Fel Salve
	[11583]="0:12:1:10:::1:0::4:0", -- Cactus Apple
	[11584]="0:0:1:20:FoodDrink::1:0::0:0", -- Cactus Apple Surprise
	[11590]="0:7:1:5:Device::1:0::0:0", -- Mechanical Repair Kit
	[11602]="0:13:1:1:::1:0::0:0", -- Grim Guzzler Key
	[11603]="0:2:3:1:FistWeapon::1:0::2:0", -- Vilerend Slicer
	[11604]="0:4:3:1:Plate::1:0::3:0", -- Dark Iron Plate
	[11605]="0:4:3:1:Plate::1:0::2:0", -- Dark Iron Shoulders
	[11606]="0:4:3:1:Mail::1:0::2:0", -- Dark Iron Mail
	[11607]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Dark Iron Sunderer
	[11608]="0:2:3:1:TwoHandMace::1:0::2:0", -- Dark Iron Pulverizer
	[11610]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Dark Iron Pulverizer
	[11611]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Dark Iron Sunderer
	[11612]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Dark Iron Plate
	[11613]="0:12:1:1:::1:0::4:0", -- DEBUG Samophlange Manual Cover
	[11614]="0:9:2:1:Blacksmithing::1:0::3:0", -- Plans: Dark Iron Mail
	[11615]="0:9:2:1:Blacksmithing::1:0::3:0", -- Plans: Dark Iron Shoulders
	[11616]="0:0:1:20:Consumable::1:0::4:0", -- DEBUG Samophlange Manual Page
	[11617]="0:12:1:1:::1:0::4:0", -- Eridan's Supplies
	[11622]="0:0:2:1:EnhPerm::1:0::3:0", -- Lesser Arcanum of Rumination
	[11623]="0:4:3:1:Cloak::1:0::3:0", -- Spritecaster Cape
	[11624]="0:4:3:1:Cloth::1:0::3:0", -- Kentic Amice
	[11625]="0:4:3:1:OffHandFrill::1:0::3:0", -- Enthralled Sphere
	[11626]="0:4:3:1:Cloak::1:0::3:0", -- Blackveil Cape
	[11627]="0:4:3:1:Mail::1:0::3:0", -- Fleetfoot Greaves
	[11628]="0:2:3:1:Bow::1:0::3:0", -- Houndmaster's Bow
	[11629]="0:2:3:1:Gun::1:0::3:0", -- Houndmaster's Rifle
	[11630]="0:15:0:1000:Junk::1:0::0:0", -- Rockshard Pellets
	[11631]="0:4:3:1:Shield::1:0::3:0", -- Stoneshell Guard
	[11632]="0:4:3:1:Plate::1:0::3:0", -- Earthslag Shoulders
	[11633]="0:4:3:1:Plate::1:0::3:0", -- Spiderfang Carapace
	[11634]="0:4:3:1:Cloth::1:0::3:0", -- Silkweb Gloves
	[11635]="0:2:3:1:Dagger::1:0::3:0", -- Hookfang Shanker
	[11642]="0:0:2:1:EnhPerm::1:0::3:0", -- Lesser Arcanum of Constitution
	[11643]="0:0:2:1:EnhPerm::1:0::3:0", -- Lesser Arcanum of Tenacity
	[11644]="0:0:2:1:EnhPerm::1:0::3:0", -- Lesser Arcanum of Resilience
	[11645]="0:0:2:1:EnhPerm::1:0::3:0", -- Lesser Arcanum of Voracity
	[11646]="0:0:2:1:EnhPerm::1:0::3:0", -- Lesser Arcanum of Voracity
	[11647]="0:0:2:1:EnhPerm::1:0::3:0", -- Lesser Arcanum of Voracity
	[11648]="0:0:2:1:EnhPerm::1:0::3:0", -- Lesser Arcanum of Voracity
	[11649]="0:0:2:1:EnhPerm::1:0::3:0", -- Lesser Arcanum of Voracity
	[11662]="0:4:3:1:Cloth::1:0::3:0", -- Ban'thok Sash
	[11665]="0:4:3:1:Leather::1:0::3:0", -- Ogreseer Fists
	[11668]="0:12:1:1:::1:0::3:0", -- Flute of Xavaric
	[11669]="0:4:3:1:Ring::1:0::3:0", -- Naglering
	[11674]="0:12:1:20:::1:0::4:0", -- Jadefire Felbind
	[11675]="0:4:3:1:Leather::1:0::3:0", -- Shadefiend Boots
	[11677]="0:4:3:1:Cloak::1:0::3:0", -- Graverot Cape
	[11678]="0:4:3:1:Plate::1:0::3:0", -- Carapace of Anub'shiah
	[11679]="0:4:3:1:Mail::1:0::3:0", -- Rubicund Armguards
	[11682]="0:12:1:1:::1:0::4:0", -- Eridan's Vial
	[11684]="0:2:4:1:OneHandMace::1:0::3:0", -- Ironfoe
	[11685]="0:4:3:1:Leather::1:0::3:0", -- Splinthide Shoulders
	[11686]="0:4:3:1:Leather::1:0::3:0", -- Girdle of Beastial Fury
	[11702]="0:2:3:1:OneHandAxe::1:0::3:0", -- Grizzle's Skinner
	[11703]="0:4:3:1:Plate::1:0::3:0", -- Stonewall Girdle
	[11722]="0:4:3:1:Mail::1:0::3:0", -- Dregmetal Spaulders
	[11723]="0:12:1:1:::1:0::4:0", -- Goodsteel's Balanced Flameberge
	[11724]="0:12:1:1:::1:0::4:0", -- Overdue Package
	[11725]="0:12:1:50:::1:0::4:0", -- Solid Crystal Leg Shaft
	[11726]="0:4:4:1:Mail::1:0::3:0", -- Savage Gladiator Chain
	[11727]="0:12:1:1:::1:0::4:0", -- Goodsteel Ledger
	[11728]="0:4:3:1:Mail::1:0::3:0", -- Savage Gladiator Leggings
	[11729]="0:4:3:1:Mail::1:0::3:0", -- Savage Gladiator Helm
	[11730]="0:4:3:1:Mail::1:0::3:0", -- Savage Gladiator Grips
	[11731]="0:4:3:1:Mail::1:0::3:0", -- Savage Gladiator Greaves
	[11732]="0:9:2:1:Book::1:0::0:0", -- Libram of Rumination
	[11733]="0:9:2:1:Book::1:0::0:0", -- Libram of Constitution
	[11734]="0:9:2:1:Book::1:0::0:0", -- Libram of Tenacity
	[11735]="0:4:3:1:Leather::1:0::3:0", -- Ragefury Eyepatch
	[11736]="0:9:2:1:Book::1:0::0:0", -- Libram of Resilience
	[11737]="0:9:2:1:Book::1:0::0:0", -- Libram of Voracity
	[11742]="0:1:3:1:Bag::1:0::3:0", -- Wayfarer's Knapsack
	[11743]="0:2:3:1:FistWeapon::1:0::3:0", -- Rockfist
	[11744]="0:2:3:1:FistWeapon::1:0::3:0", -- Bloodfist
	[11745]="0:4:3:1:Plate::1:0::3:0", -- Fists of Phalanx
	[11746]="0:4:3:1:Plate::1:0::3:0", -- Golem Skull Helm
	[11747]="0:4:3:1:Leather::1:0::3:0", -- Flamestrider Robes
	[11748]="0:2:3:1:Wand::1:0::3:0", -- Pyric Caduceus
	[11749]="0:4:3:1:Mail::1:0::3:0", -- Searingscale Leggings
	[11750]="0:2:3:1:Stave::1:0::3:0", -- Kindling Stave
	[11751]="0:12:1:5:::1:0::3:0", -- Burning Essence
	[11752]="0:12:1:5:::1:0::3:0", -- Black Blood of the Tormented
	[11753]="0:12:1:1:::1:0::3:0", -- Eye of Kajal
	[11754]="0:12:2:20::164,755,165:1:0::0:0", -- Black Diamond
	[11755]="0:4:3:1:Amulet::1:0::3:0", -- Verek's Collar
	[11764]="0:4:3:1:Leather::1:0::3:0", -- Cinderhide Armsplints
	[11765]="0:4:3:1:Mail::1:0::3:0", -- Pyremail Wristguards
	[11766]="0:4:3:1:Cloth::1:0::3:0", -- Flameweave Cuffs
	[11767]="0:4:3:1:Plate::1:0::3:0", -- Emberplate Armguards
	[11768]="0:4:3:1:Cloth::1:0::3:0", -- Incendic Bracers
	[11782]="0:4:3:1:Cloth::1:0::3:0", -- Boreal Mantle
	[11783]="0:4:3:1:Mail::1:0::3:0", -- Chillsteel Girdle
	[11784]="0:2:3:1:OneHandSword::1:0::3:0", -- Arbiter's Blade
	[11785]="0:4:3:1:Shield::1:0::3:0", -- Rock Golem Bulwark
	[11786]="0:2:3:1:TwoHandSword::1:0::3:0", -- Stone of the Earth
	[11787]="0:4:3:1:Plate::1:0::3:0", -- Shalehusk Boots
	[11802]="0:4:3:1:Plate::1:0::3:0", -- Lavacrest Leggings
	[11803]="0:2:3:1:TwoHandMace::1:0::3:0", -- Force of Magma
	[11804]="0:12:1:1:::1:0::4:0", -- Spraggle's Canteen
	[11805]="0:2:3:1:OneHandMace::1:0::3:0", -- Rubidium Hammer
	[11807]="0:4:3:1:Cloth::1:0::3:0", -- Sash of the Burning Heart
	[11808]="0:4:4:1:Cloth::1:0::3:0", -- Circle of Flame
	[11809]="0:2:3:1:Polearm::1:0::3:0", -- Flame Wrath
	[11810]="0:4:3:1:Trinket::1:0::3:0", -- Force of Will
	[11811]="0:4:3:1:Trinket::1:0::3:0", -- Smoking Heart of the Mountain
	[11812]="0:4:3:1:Cloak::1:0::3:0", -- Cape of the Fire Salamander
	[11813]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Smoking Heart of the Mountain
	[11814]="0:4:3:1:Mail::1:0::3:0", -- Molten Fists
	[11815]="0:4:3:1:Trinket::1:0::3:0", -- Hand of Justice
	[11816]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Angerforge's Battle Axe
	[11817]="0:2:3:1:OneHandSword::1:0::3:0", -- Lord General's Sword
	[11818]="0:12:1:1:::1:0::0:0", -- Grimesilt Outhouse Key
	[11819]="0:4:3:1:Trinket::1:0::3:0", -- Second Wind
	[11820]="0:4:3:1:Mail::1:0::3:0", -- Royal Decorated Armor
	[11821]="0:4:3:1:Leather::1:0::3:0", -- Warstrife Leggings
	[11822]="0:4:3:1:Cloth::1:0::3:0", -- Omnicast Boots
	[11823]="0:4:3:1:Leather::1:0::3:0", -- Luminary Kilt
	[11824]="0:4:3:1:Ring::1:0::3:0", -- Cyclopean Band
	[11825]="0:15:1:1:Companion::1:0::0:0", -- Pet Bombling
	[11826]="0:15:1:1:Companion::1:0::0:0", -- Lil' Smoky
	[11827]="0:9:2:1:Engineering::1:0::3:0", -- Schematic: Lil' Smoky
	[11828]="0:9:2:1:Engineering::1:0::3:0", -- Schematic: Pet Bombling
	[11829]="0:12:1:20:::1:0::4:0", -- Un'Goro Ash
	[11830]="0:12:1:20:::1:0::4:0", -- Webbed Diemetradon Scale
	[11831]="0:12:1:100:::1:0::4:0", -- Webbed Pterrordax Scale
	[11832]="0:4:3:1:Trinket::1:0::3:0", -- Burst of Knowledge
	[11833]="0:12:1:1:::1:0::4:0", -- Gorishi Queen Lure
	[11834]="0:12:1:20:::1:0::4:0", -- Super Sticky Tar
	[11835]="0:12:1:1:::1:0::4:0", -- Gorishi Queen Brain
	[11837]="0:12:1:1:::1:0::4:0", -- Gorishi Scent Gland
	[11839]="0:4:3:1:Cloth::1:0::3:0", -- Chief Architect's Monocle
	[11840]="0:4:1:1:Shirt::1:0::3:0", -- Master Builder's Shirt
	[11841]="0:4:3:1:Cloth::1:0::3:0", -- Senior Designer's Pantaloons
	[11842]="0:4:3:1:Mail::1:0::3:0", -- Lead Surveyor's Mantle
	[11843]="0:12:1:1:::1:0::4:0", -- Bank Voucher
	[11844]="0:12:1:1:::1:0::4:0", -- Pestlezugg's Un'Goro Report
	[11845]="0:1:1:1:Bag::1:0::3:0", -- Handmade Leather Bag
	[11846]="0:0:1:20:FoodDrink::1:0::0:0", -- Wizbang's Special Brew
	[11847]="0:4:1:1:Cloak::1:0::3:0", -- Battered Cloak
	[11848]="0:4:1:1:Cloth::1:0::3:0", -- Flax Belt
	[11849]="0:4:1:1:Mail::1:0::3:0", -- Rustmetal Bracers
	[11850]="0:4:1:1:Cloak::1:0::3:0", -- Short Duskbat Cape
	[11851]="0:4:1:1:Leather::1:0::3:0", -- Scavenger Tunic
	[11852]="0:4:1:1:Mail::1:0::3:0", -- Roamer's Leggings
	[11853]="0:4:2:1:Leather::1:0::3:0", -- Rambling Boots
	[11854]="0:2:2:1:TwoHandSword::1:0::3:0", -- Samophlange Screwdriver
	[11855]="0:4:2:1:OffHandFrill::1:0::3:0", -- Tork Wrench
	[11856]="0:2:2:1:Dagger::1:0::3:0", -- Ceremonial Elven Blade
	[11857]="0:2:2:1:Stave::1:0::3:0", -- Sanctimonial Rod
	[11858]="0:4:2:1:Cloak::1:0::3:0", -- Battlehard Cape
	[11859]="0:4:2:1:OffHandFrill::1:0::3:0", -- Jademoon Orb
	[11860]="0:2:2:1:Wand::1:0::3:0", -- Charged Lightning Rod
	[11861]="0:4:2:1:Mail::1:0::3:0", -- Girdle of Reprisal
	[11862]="0:4:2:1:Ring::1:0::3:0", -- White Bone Band
	[11863]="0:2:2:1:FistWeapon::1:0::3:0", -- White Bone Shredder
	[11864]="0:2:2:1:Polearm::1:0::3:0", -- White Bone Spear
	[11865]="0:4:3:1:Cloth::1:0::3:0", -- Rancor Boots
	[11866]="0:4:3:1:Leather::1:0::3:0", -- Nagmara's Whipping Belt
	[11867]="0:4:2:1:Mail::1:0::3:0", -- Maddening Gauntlets
	[11868]="0:4:2:1:Ring::1:0::3:0", -- Choking Band
	[11869]="0:4:2:1:Ring::1:0::3:0", -- Sha'ni's Ring
	[11870]="0:4:2:1:OffHandFrill::1:0::3:0", -- Oblivion Orb
	[11871]="0:4:2:1:Leather::1:0::3:0", -- Snarkshaw Spaulders
	[11872]="0:4:2:1:Plate::1:0::3:0", -- Eschewal Greaves
	[11873]="0:4:2:1:Cloak::1:0::3:0", -- Ethereal Mist Cape
	[11874]="0:4:2:1:Leather::1:0::3:0", -- Clouddrift Mantle
	[11875]="0:4:2:1:Cloth::1:0::3:0", -- Breezecloud Bracers
	[11876]="0:4:2:1:Leather::1:0::3:0", -- Plainstalker Tunic
	[11882]="0:4:2:1:Mail::1:0::3:0", -- Outrider Leggings
	[11883]="0:15:1:1:Junk::1:0::3:0", -- A Dingy Fanny Pack
	[11884]="0:4:2:1:Cloth::1:0::3:0", -- Moonlit Amice
	[11885]="0:12:1:1:::1:0::0:0", -- Shadowforge Torch
	[11886]="0:12:1:1:::1:0::4:0", -- Urgent Message
	[11887]="0:15:1:1:Junk::1:0::3:0", -- Cenarion Circle Cache
	[11888]="0:4:2:1:Cloth::1:0::3:0", -- Quintis' Research Gloves
	[11889]="0:4:2:1:Plate::1:0::3:0", -- Bark Iron Pauldrons
	[11902]="0:2:2:1:OneHandSword::1:0::3:0", -- Linken's Sword of Mastery
	[11904]="0:4:2:1:OffHandFrill::1:0::3:0", -- Spirit of Aquementas
	[11905]="0:4:2:1:Trinket::1:0::3:0", -- Linken's Boomerang
	[11906]="0:2:2:1:OneHandMace::1:0::3:0", -- Beastsmasher
	[11907]="0:2:2:1:TwoHandAxe::1:0::3:0", -- Beastslayer
	[11908]="0:4:2:1:Cloth::1:0::3:0", -- Archaeologist's Quarry Boots
	[11909]="0:4:2:1:Leather::1:0::3:0", -- Excavator's Utility Belt
	[11910]="0:4:2:1:Plate::1:0::3:0", -- Bejeweled Legguards
	[11911]="0:4:2:1:Cloth::1:0::3:0", -- Treetop Leggings
	[11912]="0:12:1:1:::1:0::4:0", -- Package of Empty Ooze Containers
	[11913]="0:4:2:1:Mail::1:0::3:0", -- Clayridge Helm
	[11914]="0:0:1:20:Consumable::1:0::3:0", -- Empty Cursed Ooze Jar
	[11915]="0:4:2:1:Shield::1:0::3:0", -- Shizzle's Drizzle Blocker
	[11916]="0:4:2:1:Leather::1:0::3:0", -- Shizzle's Muzzle
	[11917]="0:4:2:1:Cloth::1:0::3:0", -- Shizzle's Nozzle Wiper
	[11918]="0:4:2:1:Mail::1:0::3:0", -- Grotslab Gloves
	[11919]="0:4:2:1:Plate::1:0::3:0", -- Cragplate Greaves
	[11920]="0:2:3:1:OneHandAxe::1:0::3:0", -- Wraith Scythe
	[11921]="0:2:3:1:TwoHandMace::1:0::3:0", -- Impervious Giant
	[11922]="0:2:3:1:Dagger::1:0::3:0", -- Blood-Etched Blade
	[11923]="0:2:3:1:OneHandMace::1:0::3:0", -- The Hammer of Grace
	[11924]="0:4:3:1:Cloth::1:0::3:0", -- Robes of the Royal Crown
	[11925]="0:4:3:1:Leather::1:0::3:0", -- Ghostshroud
	[11926]="0:4:3:1:Mail::1:0::3:0", -- Deathdealer Breastplate
	[11927]="0:4:3:1:Plate::1:0::3:0", -- Legplates of the Eternal Guardian
	[11928]="0:4:3:1:OffHandFrill::1:0::3:0", -- Thaurissan's Royal Scepter
	[11929]="0:4:3:1:Cloth::1:0::3:0", -- Haunting Specter Leggings
	[11930]="0:4:3:1:Cloak::1:0::3:0", -- The Emperor's New Cape
	[11931]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Dreadforge Retaliator
	[11932]="0:2:3:1:Stave::1:0::3:0", -- Guiding Stave of Wisdom
	[11933]="0:4:3:1:Amulet::1:0::3:0", -- Imperial Jewel
	[11934]="0:4:3:1:Ring::1:0::3:0", -- Emperor's Seal
	[11935]="0:4:3:1:OffHandFrill::1:0::3:0", -- Magmus Stone
	[11936]="0:4:2:1:Cloth::1:0::3:0", -- Relic Hunter Belt
	[11937]="0:15:1:1:Junk::1:0::0:0", -- Fat Sack of Coins
	[11938]="0:15:1:1:Junk::1:0::0:0", -- Sack of Gems
	[11939]="0:15:0:20:Junk::1:0::0:0", -- Shiny Bracelet
	[11940]="0:15:0:20:Junk::1:0::0:0", -- Sparkly Necklace
	[11941]="0:15:0:20:Junk::1:0::0:0", -- False Documents
	[11942]="0:15:0:20:Junk::1:0::0:0", -- Legal Documents
	[11943]="0:15:0:1:Junk::1:0::0:0", -- Deed to Thandol Span
	[11944]="0:15:0:1:Junk::1:0::0:0", -- Dark Iron Baby Booties
	[11945]="0:4:3:1:Ring::1:0::3:0", -- Dark Iron Ring
	[11946]="0:4:3:1:Amulet::1:0::3:0", -- Fire Opal Necklace
	[11947]="0:12:1:20:::1:0::4:0", -- Filled Cursed Ooze Jar
	[11948]="0:0:1:20:Consumable::1:0::3:0", -- Empty Tainted Ooze Jar
	[11949]="0:12:1:20:::1:0::4:0", -- Filled Tainted Ooze Jar
	[11950]="0:0:1:20:Other::1:0::3:0", -- Windblossom Berries
	[11951]="0:0:1:20:FoodDrink::1:0::3:0", -- Whipper Root Tuber
	[11952]="0:0:1:20:Other::1:0::3:0", -- Night Dragon's Breath
	[11953]="0:0:1:20:Consumable::1:0::3:0", -- Empty Pure Sample Jar
	[11954]="0:12:1:20:::1:0::4:0", -- Filled Pure Sample Jar
	[11955]="0:12:1:1:::1:0::4:0", -- Bag of Empty Ooze Containers
	[11962]="0:4:3:1:Cloth::1:0::3:0", -- Manacle Cuffs
	[11963]="0:4:3:1:Leather::1:0::3:0", -- Penance Spaulders
	[11964]="0:2:3:1:OneHandMace::1:0::3:0", -- Swiftstrike Cudgel
	[11965]="0:4:2:1:Ring::1:0::2:0", -- Quartz Ring
	[11966]="0:15:1:1:Junk::1:0::0:0", -- Small Sack of Coins
	[11967]="0:4:2:1:Ring::1:0::2:0", -- Zircon Band
	[11968]="0:4:2:1:Ring::1:0::2:0", -- Amber Hoop
	[11969]="0:4:2:1:Ring::1:0::2:0", -- Jacinth Circle
	[11970]="0:4:2:1:Ring::1:0::2:0", -- Spinel Ring
	[11971]="0:4:2:1:Ring::1:0::2:0", -- Amethyst Band
	[11972]="0:4:2:1:Ring::1:0::2:0", -- Carnelian Loop
	[11973]="0:4:2:1:Ring::1:0::2:0", -- Hematite Link
	[11974]="0:4:2:1:Ring::1:0::2:0", -- Aquamarine Ring
	[11975]="0:4:2:1:Ring::1:0::2:0", -- Topaz Ring
	[11976]="0:4:2:1:Ring::1:0::2:0", -- Sardonyx Knuckle
	[11977]="0:4:2:1:Ring::1:0::2:0", -- Serpentine Loop
	[11978]="0:4:2:1:Ring::1:0::2:0", -- Jasper Link
	[11979]="0:4:2:1:Ring::1:0::2:0", -- Peridot Circle
	[11980]="0:4:2:1:Ring::1:0::2:0", -- Opal Ring
	[11981]="0:4:2:1:Ring::1:0::2:0", -- Lead Band
	[11982]="0:4:2:1:Ring::1:0::2:0", -- Viridian Band
	[11983]="0:4:2:1:Ring::1:0::2:0", -- Chrome Ring
	[11984]="0:4:2:1:Ring::1:0::2:0", -- Cobalt Ring
	[11985]="0:4:2:1:Ring::1:0::2:0", -- Cerulean Ring
	[11986]="0:4:2:1:Ring::1:0::2:0", -- Thallium Hoop
	[11987]="0:4:2:1:Ring::1:0::2:0", -- Iridium Circle
	[11988]="0:4:2:1:Ring::1:0::2:0", -- Tellurium Band
	[11989]="0:4:2:1:Ring::1:0::2:0", -- Vanadium Loop
	[11990]="0:4:2:1:Ring::1:0::2:0", -- Selenium Loop
	[11991]="0:4:2:1:Ring::1:0::2:0", -- Quicksilver Ring
	[11992]="0:4:2:1:Ring::1:0::2:0", -- Vermilion Band
	[11993]="0:4:2:1:Ring::1:0::2:0", -- Clay Ring
	[11994]="0:4:2:1:Ring::1:0::2:0", -- Coral Band
	[11995]="0:4:2:1:Ring::1:0::2:0", -- Ivory Band
	[11996]="0:4:2:1:Ring::1:0::2:0", -- Basalt Ring
	[11997]="0:4:2:1:Ring::1:0::2:0", -- Greenstone Circle
	[11998]="0:4:2:1:Ring::1:0::2:0", -- Jet Loop
	[11999]="0:4:2:1:Ring::1:0::2:0", -- Lodestone Hoop
	[12000]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Limb Cleaver
	[12001]="0:4:2:1:Ring::1:0::2:0", -- Onyx Ring
	[12002]="0:4:2:1:Ring::1:0::2:0", -- Marble Circle
	[12003]="0:0:1:20:FoodDrink::1:0::0:0", -- Dark Dwarven Lager
	[12004]="0:4:2:1:Ring::1:0::2:0", -- Obsidian Band
	[12005]="0:4:2:1:Ring::1:0::2:0", -- Granite Ring
	[12006]="0:4:2:1:Ring::1:0::2:0", -- Meadow Ring
	[12007]="0:4:2:1:Ring::1:0::2:0", -- Prairie Ring
	[12008]="0:4:2:1:Ring::1:0::2:0", -- Savannah Ring
	[12009]="0:4:2:1:Ring::1:0::2:0", -- Tundra Ring
	[12010]="0:4:2:1:Ring::1:0::2:0", -- Fen Ring
	[12011]="0:4:2:1:Ring::1:0::2:0", -- Forest Hoop
	[12012]="0:4:2:1:Ring::1:0::2:0", -- Marsh Ring
	[12013]="0:4:2:1:Ring::1:0::2:0", -- Desert Ring
	[12014]="0:4:2:1:Ring::1:0::2:0", -- Arctic Ring
	[12015]="0:4:2:1:Ring::1:0::2:0", -- Swamp Ring
	[12016]="0:4:2:1:Ring::1:0::2:0", -- Jungle Ring
	[12017]="0:4:2:1:Ring::1:0::2:0", -- Prismatic Band
	[12018]="0:4:3:1:Mail::1:0::3:0", -- Conservator Helm
	[12019]="0:4:2:1:Amulet::1:0::2:0", -- Cerulean Talisman
	[12020]="0:4:2:1:Amulet::1:0::2:0", -- Thallium Choker
	[12021]="0:4:3:1:Plate::1:0::3:0", -- Shieldplate Sabatons
	[12022]="0:4:2:1:Amulet::1:0::2:0", -- Iridium Chain
	[12023]="0:4:2:1:Amulet::1:0::2:0", -- Tellurium Necklace
	[12024]="0:4:2:1:Amulet::1:0::2:0", -- Vanadium Talisman
	[12025]="0:4:2:1:Amulet::1:0::2:0", -- Selenium Chain
	[12026]="0:4:2:1:Amulet::1:0::2:0", -- Quicksilver Pendant
	[12027]="0:4:2:1:Amulet::1:0::2:0", -- Vermilion Necklace
	[12028]="0:4:2:1:Amulet::1:0::2:0", -- Basalt Necklace
	[12029]="0:4:2:1:Amulet::1:0::2:0", -- Greenstone Talisman
	[12030]="0:4:2:1:Amulet::1:0::2:0", -- Jet Chain
	[12031]="0:4:2:1:Amulet::1:0::2:0", -- Lodestone Necklace
	[12032]="0:4:2:1:Amulet::1:0::2:0", -- Onyx Choker
	[12033]="0:15:1:1:Junk::1:0::0:0", -- Thaurissan Family Jewels
	[12034]="0:4:2:1:Amulet::1:0::2:0", -- Marble Necklace
	[12035]="0:4:2:1:Amulet::1:0::2:0", -- Obsidian Pendant
	[12036]="0:4:2:1:Amulet::1:0::2:0", -- Granite Necklace
	[12037]="350:7:1:20:Meat:185:1:0:24291:0:0", -- Mystery Meat
	[12038]="0:4:3:1:Ring::1:0::3:0", -- Lagrave's Seal
	[12039]="0:4:2:1:Amulet::1:0::2:0", -- Tundra Necklace
	[12040]="0:4:2:1:Amulet::1:0::2:0", -- Forest Pendant
	[12041]="0:4:3:1:Leather::1:0::3:0", -- Windshear Leggings
	[12042]="0:4:2:1:Amulet::1:0::2:0", -- Marsh Chain
	[12043]="0:4:2:1:Amulet::1:0::2:0", -- Desert Choker
	[12044]="0:4:2:1:Amulet::1:0::2:0", -- Arctic Pendant
	[12045]="0:4:2:1:Amulet::1:0::2:0", -- Swamp Pendant
	[12046]="0:4:2:1:Amulet::1:0::2:0", -- Jungle Necklace
	[12047]="0:4:2:1:Amulet::1:0::2:0", -- Spectral Necklace
	[12048]="0:4:2:1:Amulet::1:0::2:0", -- Prismatic Pendant
	[12049]="0:4:3:1:Mail::1:0::3:0", -- Splintsteel Armor
	[12050]="0:4:2:1:Cloth::1:0::3:0", -- Hazecover Boots
	[12051]="0:4:2:1:Mail::1:0::3:0", -- Brazen Gauntlets
	[12052]="0:4:2:1:Ring::1:0::2:0", -- Ring of the Moon
	[12053]="0:4:2:1:Ring::1:0::2:0", -- Volcanic Rock Ring
	[12054]="0:4:2:1:Ring::1:0::2:0", -- Demon Band
	[12055]="0:4:2:1:Ring::1:0::2:0", -- Stardust Band
	[12056]="0:4:2:1:Ring::1:0::2:0", -- Ring of the Heavens
	[12057]="0:4:2:1:Ring::1:0::2:0", -- Dragonscale Band
	[12058]="0:4:2:1:Ring::1:0::2:0", -- Demonic Bone Ring
	[12059]="0:4:3:1:Amulet::1:0::3:0", -- Conqueror's Medallion
	[12060]="0:12:1:1:::1:0::4:0", -- Shindrell's Note
	[12061]="0:2:3:1:OneHandSword::1:0::3:0", -- Blade of Reckoning
	[12062]="0:2:3:1:Dagger::1:0::3:0", -- Skilled Fighting Blade
	[12064]="0:4:1:1:Cloth::1:0::3:0", -- Gamemaster Hood
	[12065]="0:4:3:1:Trinket::1:0::3:0", -- Ward of the Elements
	[12066]="0:4:3:1:Cloak::1:0::3:0", -- Shaleskin Cape
	[12082]="0:4:2:1:Leather::1:0::3:0", -- Wyrmhide Spaulders
	[12083]="0:4:2:1:Cloth::1:0::3:0", -- Valconian Sash
	[12102]="0:4:2:1:Ring::1:0::3:0", -- Ring of the Aristocrat
	[12103]="0:4:3:1:Amulet::1:0::3:0", -- Star of Mystaria
	[12108]="0:4:2:1:Mail::1:0::3:0", -- Basaltscale Armor
	[12109]="0:4:3:1:Cloth::1:0::3:0", -- Azure Moon Amice
	[12110]="0:4:3:1:Cloak::1:0::3:0", -- Raincaster Drape
	[12111]="0:4:3:1:Plate::1:0::3:0", -- Lavaplate Gauntlets
	[12112]="0:4:3:1:Mail::1:0::3:0", -- Crypt Demon Bracers
	[12113]="0:4:3:1:Cloak::1:0::3:0", -- Sunborne Cape
	[12114]="0:4:3:1:Leather::1:0::3:0", -- Nightfall Gloves
	[12115]="0:4:3:1:Plate::1:0::3:0", -- Stalwart Clutch
	[12122]="0:15:2:1:Junk::1:0::3:0", -- Kum'isha's Junk
	[12144]="0:15:1:1:Junk::1:0::3:0", -- Eggscilloscope
	[12162]="3000:9:1:1:Blacksmithing::1:1:2843,3356,5512,45549,46359,52641:0:0", -- Plans: Hardened Iron Shortsword
	[12163]="4400:9:1:1:Blacksmithing::1:1:2482:0:0", -- Plans: Moonsteel Broadsword
	[12164]="4400:9:1:1:Blacksmithing::1:1:1146,2483:0:0", -- Plans: Massive Iron Axe
	[12184]="0:7:1:20:Meat:185:1:0::0:0", -- Raptor Flesh
	[12185]="0:4:2:1:Cloth::1:0::3:0", -- Bloodsail Admiral's Hat
	[12190]="0:0:1:20:Potion::1:0::0:0", -- Dreamless Sleep Potion
	[12191]="0:12:1:1:::1:0::4:0", -- Silver Dawning's Lockbox
	[12192]="0:12:1:1:::1:0::4:0", -- Mist Veil's Lockbox
	[12202]="0:7:1:20:Meat:185:1:0::0:0", -- Tiger Meat
	[12203]="0:7:1:20:Meat:185:1:0::0:0", -- Red Wolf Meat
	[12204]="0:7:1:20:Meat:185:1:0::0:0", -- Heavy Kodo Meat
	[12205]="0:7:1:20:Meat:185:1:0::0:0", -- White Spider Meat
	[12206]="0:7:1:20:Meat:185:1:0::0:0", -- Tender Crab Meat
	[12207]="0:7:1:20:Meat:185:1:0::0:0", -- Giant Egg
	[12208]="0:7:1:20:Meat:185:1:0::0:0", -- Tender Wolf Meat
	[12209]="0:0:1:20:FoodDrink::1:0::0:0", -- Lean Wolf Steak
	[12210]="0:0:1:20:FoodDrink::1:0::0:0", -- Roast Raptor
	[12212]="0:0:1:20:FoodDrink::1:0::0:0", -- Jungle Stew
	[12213]="0:0:1:20:FoodDrink::1:0::0:0", -- Carrion Surprise
	[12214]="0:0:1:20:FoodDrink::1:0::0:0", -- Mystery Stew
	[12215]="0:0:1:20:FoodDrink::1:0::0:0", -- Heavy Kodo Stew
	[12216]="0:0:1:20:FoodDrink::1:0::0:0", -- Spiced Chili Crab
	[12217]="0:0:1:20:FoodDrink::1:0::0:0", -- Dragonbreath Chili
	[12218]="0:0:1:20:FoodDrink::1:0::0:0", -- Monster Omelet
	[12219]="0:12:1:1:::1:0::0:0", -- Unadorned Seal of Ascension
	[12220]="0:12:1:20:::1:0::4:0", -- Intact Elemental Bracer
	[12223]="0:7:1:20:Meat:185:1:0::0:0", -- Meaty Bat Wing
	[12224]="0:0:1:20:FoodDrink::1:0::0:0", -- Crispy Bat Wing
	[12225]="0:2:1:1:FishingPole::1:0::3:0", -- Blump Family Fishing Pole
	[12226]="25:9:1:1:Cooking::1:0:2118:0:0", -- Recipe: Crispy Bat Wing
	[12227]="1600:9:1:1:Cooking::1:1:12246:0:0", -- Recipe: Lean Wolf Steak
	[12228]="5000:9:1:1:Cooking::1:0:1148,2810,2821,4879,4897,12245:0:0", -- Recipe: Roast Raptor
	[12229]="5000:9:1:1:Cooking::1:0:7947,8145,12246:0:0", -- Recipe: Hot Wolf Ribs
	[12230]="0:12:1:20:::1:0::4:0", -- Felwood Slime Sample
	[12231]="3000:9:1:1:Cooking::1:0:1148,12245:0:0", -- Recipe: Jungle Stew
	[12232]="5000:9:1:1:Cooking::1:0:989,4879,9636,12245:0:0", -- Recipe: Carrion Surprise
	[12233]="3000:9:1:1:Cooking::1:0:4897,8150,12246:0:0", -- Recipe: Mystery Stew
	[12234]="0:12:1:20:::1:0::4:0", -- Corrupted Felwood Sample
	[12235]="0:12:1:20:::1:0::4:0", -- Un'Goro Slime Sample
	[12236]="0:12:1:20:::1:0::4:0", -- Pure Un'Goro Sample
	[12237]="0:12:1:20:::1:0::4:0", -- Fine Crab Chunks
	[12238]="0:0:1:20:FoodDrink::1:0::0:0", -- Darkshore Grouper
	[12239]="7000:9:1:1:Cooking::1:0:4879,4897,12246:0:0", -- Recipe: Dragonbreath Chili
	[12240]="7000:9:1:1:Cooking::1:0:8150,9636,12245:0:0", -- Recipe: Heavy Kodo Stew
	[12241]="0:12:1:20:::1:0::4:0", -- Collected Dragon Egg
	[12242]="0:12:1:1:::1:0::4:0", -- Sea Creature Bones
	[12243]="0:2:3:1:Polearm::1:0::3:0", -- Smoldering Claw
	[12247]="28373:2:2:1:Dagger::1:1:225,3539,4235:2:0", -- Broad Bladed Knife
	[12248]="32030:2:2:1:Dagger::1:1:1146,2843,4886:2:0", -- Daring Dirk
	[12249]="30195:2:2:1:TwoHandAxe::1:1:225,3019,3539,4232,12045:2:0", -- Merciless Axe
	[12250]="40342:2:2:1:TwoHandAxe::1:1:1146,2483,4884,4886:2:0", -- Midnight Axe
	[12251]="53897:2:2:1:Stave::1:1:2482,4884,19043:2:0", -- Big Stick
	[12252]="63096:2:2:1:Stave::1:1:2482,19238:2:0", -- Staff of Protection
	[12253]="17728:4:2:1:Cloak::1:1:8159,11874:2:0", -- Brilliant Red Cloak
	[12254]="22416:4:2:1:Cloak::1:1:8159,11874,12023:2:0", -- Well Oiled Cloak
	[12255]="34988:4:2:1:Cloth::1:1:984,3315:2:0", -- Pale Leggings
	[12256]="43828:4:2:1:Cloth::1:1:984,3316,4175:2:0", -- Cindercloth Leggings
	[12257]="19430:4:2:1:Mail::1:1:2845,12040:2:0", -- Heavy Notched Belt
	[12259]="0:2:2:1:Dagger::1:0::2:0", -- Glinting Steel Dagger
	[12260]="0:2:2:1:Dagger::1:0::2:0", -- Searing Golden Blade
	[12261]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Searing Golden Blade
	[12262]="0:12:1:1:::1:0::4:0", -- Empty Worg Pup Cage
	[12263]="0:12:1:1:::1:0::4:0", -- Caged Worg Pup
	[12264]="0:15:3:1:Companion::1:0::3:0", -- Worg Carrier
	[12282]="0:2:1:1:TwoHandAxe::1:0::0:0", -- Worn Battleaxe
	[12283]="0:12:1:20:::1:0::4:0", -- Broodling Essence
	[12284]="0:12:1:1:::1:0::0:0", -- Draco-Incarcinatrix 900
	[12286]="0:12:1:1:::1:0::0:0", -- Eggscilloscope Prototype
	[12287]="0:12:1:1:::1:0::4:0", -- Collectronic Module
	[12288]="0:12:1:1:::1:0::3:0", -- Encased Corrupt Ooze
	[12289]="0:12:1:1:::1:0::4:0", -- Sea Turtle Remains
	[12291]="0:12:1:1:::1:0::4:0", -- Merged Ooze Sample
	[12292]="0:12:1:1:::1:0::4:0", -- Strangely Marked Box
	[12293]="0:12:1:1:::1:0::4:0", -- Fine Gold Thread
	[12295]="0:4:2:1:Cloth::1:0::3:0", -- Leggings of the People's Militia
	[12296]="0:2:2:1:Wand::1:0::3:0", -- Spark of the People's Militia
	[12299]="0:4:1:1:Cloth::1:0::3:0", -- Netted Gloves
	[12300]="0:12:1:1:::1:0::3:0", -- Orb of Draconic Energy
	[12301]="0:13:1:1:::1:0::4:0", -- Bamboo Cage Key
	[12302]="0:15:4:1:Mount::1:0::3:0", -- Reins of the Ancient Frostsaber
	[12303]="0:15:4:1:Mount::1:0::3:0", -- Reins of the Nightsaber
	[12323]="0:12:1:1:::1:0::3:0", -- Unforged Seal of Ascension
	[12324]="0:12:1:1:::1:0::4:0", -- Forged Seal of Ascension
	[12330]="0:15:4:1:Mount::1:0::3:0", -- Horn of the Red Wolf
	[12334]="0:12:1:20:::1:0::4:0", -- Frostmaul Shards
	[12335]="0:12:2:1:::1:0::3:0", -- Gemstone of Smolderthorn
	[12336]="0:12:2:1:::1:0::3:0", -- Gemstone of Spirestone
	[12337]="0:12:2:1:::1:0::3:0", -- Gemstone of Bloodaxe
	[12339]="0:12:1:1:::1:0::3:0", -- Vaelan's Gift
	[12341]="0:12:1:1:::1:0::4:0", -- Blackwood Fruit Sample
	[12342]="0:12:1:1:::1:0::4:0", -- Blackwood Grain Sample
	[12343]="0:12:1:1:::1:0::4:0", -- Blackwood Nut Sample
	[12344]="0:4:3:1:Ring::1:0::3:0", -- Seal of Ascension
	[12346]="0:12:1:1:::1:0::4:0", -- Empty Cleansing Bowl
	[12347]="0:12:1:1:::1:0::4:0", -- Filled Cleansing Bowl
	[12349]="0:12:1:1:::1:0::4:0", -- Cliffspring River Sample
	[12350]="0:12:1:1:::1:0::4:0", -- Empty Sampling Tube
	[12351]="0:15:4:1:Mount::1:0::3:0", -- Horn of the Arctic Wolf
	[12352]="0:12:1:1:::1:0::4:0", -- Doomrigger's Clasp
	[12353]="0:15:4:1:Mount::1:0::3:0", -- White Stallion Bridle
	[12354]="0:15:4:1:Mount::1:0::3:0", -- Palomino Bridle
	[12355]="0:12:1:1:::1:0::4:0", -- Talisman of Corruption
	[12356]="0:12:1:20:::1:0::4:0", -- Highperch Wyvern Egg
	[12358]="0:12:1:1:::1:0::4:0", -- Darkstone Tablet
	[12359]="0:7:1:20:MetalStone:171,164,333,202,755,186:1:0::0:0", -- Thorium Bar
	[12360]="0:7:2:20:MetalStone:164,202,755,186,197:1:0::0:0", -- Arcanite Bar
	[12361]="0:3:2:20:GemSimple:164,202,755:1:0::0:0", -- Blue Sapphire
	[12363]="0:3:2:20:GemSimple:171,755:1:0::0:0", -- Arcane Crystal
	[12364]="0:3:2:20:GemSimple:164,202,755,197:1:0::0:0", -- Huge Emerald
	[12365]="0:7:1:20:MetalStone:164,202,755:1:0::0:0", -- Dense Stone
	[12366]="0:12:1:20:::1:0::4:0", -- Thick Yeti Fur
	[12367]="0:12:1:20:::1:0::4:0", -- Pristine Yeti Horn
	[12368]="0:12:1:1:::1:0::4:0", -- Alexi's Gambit
	[12382]="0:13:2:1:::1:0::3:0", -- Key to the City
	[12383]="0:12:1:20:::1:0::4:0", -- Moontouched Feather
	[12384]="0:12:1:1:::1:0::3:0", -- Cache of Mau'ari
	[12402]="0:12:1:1:::1:0::4:0", -- Ancient Egg
	[12404]="0:0:1:20:EnhTemp::1:0::0:0", -- Dense Sharpening Stone
	[12405]="0:4:2:1:Plate::1:0::2:0", -- Thorium Armor
	[12406]="0:4:2:1:Plate::1:0::2:0", -- Thorium Belt
	[12408]="0:4:2:1:Plate::1:0::2:0", -- Thorium Bracers
	[12409]="0:4:2:1:Plate::1:0::2:0", -- Thorium Boots
	[12410]="0:4:2:1:Plate::1:0::2:0", -- Thorium Helm
	[12411]="0:12:1:1:::1:0::4:0", -- Third Mosh'aru Tablet
	[12412]="0:12:1:1:::1:0::4:0", -- Fourth Mosh'aru Tablet
	[12414]="0:4:2:1:Plate::1:0::2:0", -- Thorium Leggings
	[12415]="0:4:2:1:Mail::1:0::2:0", -- Radiant Breastplate
	[12416]="0:4:2:1:Mail::1:0::2:0", -- Radiant Belt
	[12417]="0:4:2:1:Mail::1:0::2:0", -- Radiant Circlet
	[12418]="0:4:2:1:Mail::1:0::2:0", -- Radiant Gloves
	[12419]="0:4:2:1:Mail::1:0::2:0", -- Radiant Boots
	[12420]="0:4:2:1:Mail::1:0::2:0", -- Radiant Leggings
	[12422]="0:4:2:1:Plate::1:0::2:0", -- Imperial Plate Chest
	[12424]="0:4:2:1:Plate::1:0::2:0", -- Imperial Plate Belt
	[12425]="0:4:2:1:Plate::1:0::2:0", -- Imperial Plate Bracers
	[12426]="0:4:2:1:Plate::1:0::2:0", -- Imperial Plate Boots
	[12427]="0:4:2:1:Plate::1:0::2:0", -- Imperial Plate Helm
	[12428]="0:4:2:1:Plate::1:0::2:0", -- Imperial Plate Shoulders
	[12429]="0:4:2:1:Plate::1:0::2:0", -- Imperial Plate Leggings
	[12430]="0:12:1:20:::1:0::0:0", -- Frostsaber E'ko
	[12431]="0:12:1:20:::1:0::0:0", -- Winterfall E'ko
	[12432]="0:12:1:20:::1:0::0:0", -- Shardtooth E'ko
	[12433]="0:12:1:20:::1:0::0:0", -- Wildkin E'ko
	[12434]="0:12:1:20:::1:0::0:0", -- Chillwind E'ko
	[12435]="0:12:1:20:::1:0::0:0", -- Ice Thistle E'ko
	[12436]="0:12:1:20:::1:0::0:0", -- Frostmaul E'ko
	[12437]="0:12:1:1:::1:0::4:0", -- Ridgewell's Crate
	[12438]="0:12:1:1:::1:0::4:0", -- Tinkee's Letter
	[12444]="0:12:1:20:::1:0::4:0", -- Uncracked Chillwind Horn
	[12445]="0:12:1:1:::1:0::0:0", -- Felnok's Package
	[12446]="0:2:1:1:Gun::1:0::3:0", -- Anvilmar Musket
	[12447]="0:2:1:1:Bow::1:0::3:0", -- Thistlewood Bow
	[12448]="0:2:1:1:Gun::1:0::3:0", -- Light Hunting Rifle
	[12449]="0:2:1:1:Bow::1:0::3:0", -- Primitive Bow
	[12450]="0:12:1:20:::1:0::3:0", -- Juju Flurry
	[12451]="0:12:1:20:::1:0::3:0", -- Juju Power
	[12455]="0:12:1:20:::1:0::3:0", -- Juju Ember
	[12457]="0:12:1:20:::1:0::3:0", -- Juju Chill
	[12458]="0:12:1:20:::1:0::3:0", -- Juju Guile
	[12459]="0:12:1:20:::1:0::3:0", -- Juju Escape
	[12460]="0:12:1:20:::1:0::3:0", -- Juju Might
	[12462]="0:4:4:1:Cloth::1:0::3:0", -- Embrace of the Wind Serpent
	[12463]="0:2:3:1:TwoHandSword::1:0::3:0", -- Drakefang Butcher
	[12464]="0:4:3:1:Leather::1:0::3:0", -- Bloodfire Talons
	[12465]="0:4:3:1:Cloak::1:0::3:0", -- Nightfall Drape
	[12466]="0:4:3:1:Cloth::1:0::3:0", -- Dawnspire Cord
	[12467]="0:12:1:1:::1:0::4:0", -- Alien Egg
	[12470]="0:4:3:1:Leather::1:0::3:0", -- Sandstalker Ankleguards
	[12471]="0:4:3:1:OffHandFrill::1:0::3:0", -- Desertwalker Cane
	[12472]="0:12:1:1:::1:0::4:0", -- Krakle's Thermometer
	[12522]="0:4:2:1:Leather::1:0::3:0", -- Bingles' Flying Gloves
	[12524]="0:12:1:1:::1:0::4:0", -- Blue-Feathered Amulet
	[12525]="0:12:1:1:::1:0::4:0", -- Jaron's Supplies
	[12527]="0:2:3:1:OneHandAxe::1:0::2:0", -- Ribsplitter
	[12528]="0:2:3:1:TwoHandMace::1:0::2:0", -- The Judge's Gavel
	[12529]="0:15:3:1:Companion::1:0::3:0", -- Smolderweb Carrier
	[12530]="0:12:1:20:::1:0::4:0", -- Spire Spider Egg
	[12531]="0:2:3:1:Dagger::1:0::2:0", -- Searing Needle
	[12532]="0:2:3:1:Stave::1:0::2:0", -- Spire of the Stoneshaper
	[12533]="0:0:1:1:Consumable::1:0::3:0", -- Roughshod Pike
	[12534]="0:12:1:1:::1:0::3:0", -- Omokk's Head
	[12535]="0:2:3:1:OneHandSword::1:0::2:0", -- Doomforged Straightedge
	[12542]="0:4:3:1:Cloth::1:0::2:0", -- Funeral Pyre Vestment
	[12543]="0:4:3:1:Ring::1:0::3:0", -- Songstone of Ironforge
	[12544]="0:4:3:1:Ring::1:0::3:0", -- Thrall's Resolve
	[12545]="0:4:3:1:Ring::1:0::3:0", -- Eye of Orgrimmar
	[12546]="0:4:3:1:Cloth::1:0::2:0", -- Aristocratic Cuffs
	[12547]="0:4:3:1:Leather::1:0::2:0", -- Mar Alom's Grip
	[12548]="0:4:3:1:Ring::1:0::3:0", -- Magni's Will
	[12549]="0:4:3:1:Mail::1:0::2:0", -- Braincage
	[12550]="0:4:3:1:Plate::1:0::2:0", -- Runed Golem Shackles
	[12551]="0:4:3:1:Cloak::1:0::2:0", -- Stoneshield Cloak
	[12552]="0:4:3:1:Cloak::1:0::2:0", -- Blisterbane Wrap
	[12553]="0:4:3:1:Leather::1:0::3:0", -- Swiftwalker Boots
	[12554]="0:4:3:1:Cloth::1:0::3:0", -- Hands of the Exalted Herald
	[12555]="0:4:3:1:Plate::1:0::2:0", -- Battlechaser's Greaves
	[12556]="0:4:3:1:Cloth::1:0::3:0", -- High Priestess Boots
	[12557]="0:4:3:1:Plate::1:0::3:0", -- Ebonsteel Spaulders
	[12558]="0:12:1:1:::1:0::3:0", -- Blue-Feathered Necklace
	[12562]="0:12:1:1:::1:0::4:0", -- Important Blackrock Documents
	[12563]="0:12:1:1:::1:0::3:0", -- Warlord Goretooth's Command
	[12564]="0:12:1:1:::1:0::3:0", -- Assassination Note
	[12565]="0:12:1:1:::1:0::4:0", -- Winna's Kitten Carrier
	[12566]="0:12:1:1:::1:0::4:0", -- Hardened Flasket
	[12567]="0:12:1:1:::1:0::4:0", -- Filled Flasket
	[12582]="0:2:3:1:Dagger::1:0::3:0", -- Keris of Zul'Serak
	[12583]="0:2:3:1:Polearm::1:0::3:0", -- Blackhand Doomsaw
	[12584]="430223:2:4:1:OneHandSword::1:0:12784:3:0", -- Grand Marshal's Longsword
	[12586]="0:0:1:50:Other::1:0::0:0", -- Immature Venom Sac
	[12587]="0:4:3:1:Leather::1:0::3:0", -- Eye of Rend
	[12588]="0:4:3:1:Mail::1:0::3:0", -- Bonespike Shoulder
	[12589]="0:4:3:1:Cloth::1:0::3:0", -- Dustfeather Sash
	[12590]="0:2:4:1:Dagger::1:0::3:0", -- Felstriker
	[12592]="0:2:4:1:TwoHandSword::1:0::3:0", -- Blackblade of Shahram
	[12602]="0:4:3:1:Shield::1:0::3:0", -- Draconian Deflector
	[12603]="0:4:3:1:Leather::1:0::3:0", -- Nightbrace Tunic
	[12604]="0:4:3:1:Cloth::1:0::3:0", -- Starfire Tiara
	[12605]="0:2:3:1:Wand::1:0::3:0", -- Serpentine Skuller
	[12606]="0:4:3:1:Leather::1:0::3:0", -- Crystallized Girdle
	[12607]="0:12:3:20::165:1:0::0:0", -- Brilliant Chromatic Scale
	[12608]="0:4:3:1:Cloak::1:0::3:0", -- Butcher's Apron
	[12609]="0:4:3:1:Cloth::1:0::3:0", -- Polychromatic Visionwrap
	[12610]="0:4:2:1:Plate::1:0::2:0", -- Runic Plate Shoulders
	[12611]="0:4:2:1:Plate::1:0::2:0", -- Runic Plate Boots
	[12612]="0:4:2:1:Plate::1:0::2:0", -- Runic Plate Helm
	[12613]="0:4:2:1:Plate::1:0::2:0", -- Runic Breastplate
	[12614]="0:4:2:1:Plate::1:0::2:0", -- Runic Plate Leggings
	[12618]="0:4:3:1:Plate::1:0::2:0", -- Enchanted Thorium Breastplate
	[12619]="0:4:3:1:Plate::1:0::2:0", -- Enchanted Thorium Leggings
	[12620]="0:4:3:1:Plate::1:0::2:0", -- Enchanted Thorium Helm
	[12621]="0:2:3:1:OneHandAxe::1:0::3:0", -- Demonfork
	[12622]="0:12:1:10:::1:0::4:0", -- Shardtooth Meat
	[12623]="0:12:1:10:::1:0::4:0", -- Chillwind Meat
	[12624]="0:4:3:1:Mail::1:0::2:0", -- Wildthorn Mail
	[12625]="0:4:3:1:Plate::1:0::2:0", -- Dawnbringer Shoulders
	[12626]="0:4:3:1:Cloth::1:0::3:0", -- Funeral Cuffs
	[12627]="0:12:1:1:::1:0::4:0", -- Temporal Displacer
	[12628]="0:4:3:1:Plate::1:0::2:0", -- Demon Forged Breastplate
	[12630]="0:12:1:1:::1:0::4:0", -- Head of Rend Blackhand
	[12631]="0:4:3:1:Plate::1:0::2:0", -- Fiery Plate Gauntlets
	[12632]="0:4:3:1:Mail::1:0::2:0", -- Storm Gauntlets
	[12633]="0:4:3:1:Plate::1:0::2:0", -- Whitesoul Helm
	[12634]="0:4:3:1:Mail::1:0::3:0", -- Chiselbrand Girdle
	[12635]="0:12:1:1:::1:0::4:0", -- Simple Parchment
	[12636]="0:4:3:1:Mail::1:0::2:0", -- Helm of the Great Chief
	[12637]="0:4:3:1:Plate::1:0::3:0", -- Backusarian Gauntlets
	[12638]="0:12:1:20:::1:0::4:0", -- Andorhal Watch
	[12639]="0:4:4:1:Plate::1:0::2:0", -- Stronghold Gauntlets
	[12640]="0:4:4:1:Plate::1:0::2:0", -- Lionheart Helm
	[12641]="0:4:4:1:Mail::1:0::2:0", -- Invulnerable Mail
	[12642]="0:12:1:1:::1:0::4:0", -- Cleansed Infernal Orb
	[12643]="0:0:1:20:EnhTemp::1:0::0:0", -- Dense Weightstone
	[12644]="0:7:1:20:MetalStone:164:1:0::0:0", -- Dense Grinding Stone
	[12645]="0:0:2:5:EnhPerm::1:0::0:0", -- Thorium Shield Spike
	[12646]="0:12:1:1:::1:0::3:0", -- Infus Emerald
	[12647]="0:12:1:1:::1:0::3:0", -- Felhas Ruby
	[12648]="0:12:1:1:::1:0::4:0", -- Imprisoned Felhound Spirit
	[12649]="0:12:1:1:::1:0::4:0", -- Imprisoned Infernal Spirit
	[12650]="0:0:1:1:Consumable::1:0::3:0", -- Attuned Dampener
	[12651]="0:2:3:1:Crossbow::1:0::3:0", -- Blackcrow
	[12653]="0:2:3:1:Bow::1:0::3:0", -- Riphook
	[12654]="0:15:0:1000:Junk::1:0::3:0", -- Doomshot
	[12655]="0:7:1:20:MetalStone:164,202:1:0::0:0", -- Enchanted Thorium Bar
	[12662]="0:7:2:20:Other:164,755,197:1:0::3:0", -- Demonic Rune
	[12663]="0:12:1:1:::1:0::4:0", -- Glyphed Oaken Branch
	[12682]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Thorium Armor
	[12683]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Thorium Belt
	[12684]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Thorium Bracers
	[12685]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Radiant Belt
	[12687]="0:9:2:1:Blacksmithing::1:0::3:0", -- Plans: Imperial Plate Shoulders
	[12688]="0:9:2:1:Blacksmithing::1:0::3:0", -- Plans: Imperial Plate Belt
	[12689]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Radiant Breastplate
	[12690]="0:9:2:1:Blacksmithing::1:0::3:0", -- Plans: Imperial Plate Bracers
	[12691]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Wildthorn Mail
	[12692]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Thorium Shield Spike
	[12693]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Thorium Boots
	[12694]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Thorium Helm
	[12695]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Radiant Gloves
	[12696]="0:9:3:1:Blacksmithing::1:0::3:0", -- Plans: Demon Forged Breastplate
	[12697]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Radiant Boots
	[12698]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Dawnbringer Shoulders
	[12699]="0:9:3:1:Blacksmithing::1:0::3:0", -- Plans: Fiery Plate Gauntlets
	[12700]="0:9:2:1:Blacksmithing::1:0::3:0", -- Plans: Imperial Plate Boots
	[12701]="0:9:2:1:Blacksmithing::1:0::3:0", -- Plans: Imperial Plate Helm
	[12702]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Radiant Circlet
	[12703]="40000:9:3:1:Blacksmithing::1:0:11278:0:0", -- Plans: Storm Gauntlets
	[12704]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Thorium Leggings
	[12705]="0:9:2:1:Blacksmithing::1:0::3:0", -- Plans: Imperial Plate Chest
	[12706]="30000:9:2:1:Blacksmithing::1:0:38561:0:0", -- Plans: Runic Plate Shoulders
	[12707]="30000:9:2:1:Blacksmithing::1:0:38561:0:0", -- Plans: Runic Plate Boots
	[12708]="0:12:1:5:::1:0::4:0", -- Crossroads Supply Crate
	[12709]="0:2:3:1:Dagger::1:0::3:0", -- Finkle's Skinner
	[12710]="0:12:1:1:::1:0::4:0", -- Glowing Hunk of the Beast's Flesh
	[12711]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Whitesoul Helm
	[12712]="0:0:1:1:Consumable::1:0::4:0", -- Warosh's Mojo
	[12713]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Radiant Leggings
	[12714]="40000:9:2:1:Blacksmithing::1:0:38561:0:0", -- Plans: Runic Plate Helm
	[12715]="0:9:2:1:Blacksmithing::1:0::3:0", -- Plans: Imperial Plate Leggings
	[12716]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Helm of the Great Chief
	[12717]="0:9:4:1:Blacksmithing::1:0::0:0", -- Plans: Lionheart Helm
	[12718]="0:9:2:1:Blacksmithing::1:0::3:0", -- Plans: Runic Breastplate
	[12719]="60000:9:2:1:Blacksmithing::1:0:38561:0:0", -- Plans: Runic Plate Leggings
	[12720]="0:9:4:1:Blacksmithing::1:0::0:0", -- Plans: Stronghold Gauntlets
	[12721]="0:12:1:1:::1:0::4:0", -- Good Luck Half-Charm
	[12722]="0:12:1:1:::1:0::4:0", -- Good Luck Other-Half-Charm
	[12723]="0:12:1:1:::1:0::4:0", -- Good Luck Charm
	[12724]="0:12:1:1:::1:0::4:0", -- Janice's Parcel
	[12725]="0:9:3:1:Blacksmithing::1:0::3:0", -- Plans: Enchanted Thorium Helm
	[12726]="0:9:3:1:Blacksmithing::1:0::3:0", -- Plans: Enchanted Thorium Leggings
	[12727]="0:9:3:1:Blacksmithing::1:0::3:0", -- Plans: Enchanted Thorium Breastplate
	[12728]="0:9:4:1:Blacksmithing::1:0::0:0", -- Plans: Invulnerable Mail
	[12730]="0:12:1:1:::1:0::3:0", -- Warosh's Scroll
	[12731]="0:12:4:1:::1:0::0:0", -- Pristine Hide of the Beast
	[12732]="0:12:1:20:::1:0::4:0", -- Incendia Agave
	[12733]="0:12:1:1:::1:0::4:0", -- Sacred Frostsaber Meat
	[12734]="0:12:1:10:::1:0::3:0", -- Enchanted Scarlet Thread
	[12735]="0:15:0:20:Junk::1:0::0:0", -- Frayed Abomination Stitching
	[12736]="0:12:1:10:::1:0::3:0", -- Frostwhisper's Embalming Fluid
	[12737]="0:12:1:20:::1:0::4:0", -- Gloom Weed
	[12740]="0:12:1:1:::1:0::4:0", -- Fifth Mosh'aru Tablet
	[12741]="0:12:1:1:::1:0::4:0", -- Sixth Mosh'aru Tablet
	[12752]="0:4:4:1:Cloth::1:0::3:0", -- Cap of the Scarlet Savant
	[12753]="0:12:2:10:::1:0::3:0", -- Skin of Shadow
	[12756]="0:4:4:1:Leather::1:0::3:0", -- Leggings of Arcana
	[12757]="0:4:4:1:Leather::1:0::3:0", -- Breastplate of Bloodthirst
	[12764]="0:2:2:1:TwoHandSword::1:0::2:0", -- Thorium Greatsword
	[12765]="0:12:1:1:::1:0::4:0", -- Secret Note #1
	[12766]="0:12:1:1:::1:0::4:0", -- Secret Note #2
	[12768]="0:12:1:1:::1:0::4:0", -- Secret Note #3
	[12769]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Bleakwood Hew
	[12771]="0:12:1:1:::1:0::3:0", -- Empty Firewater Flask
	[12772]="0:2:2:1:TwoHandMace::1:0::2:0", -- Inlaid Thorium Hammer
	[12773]="0:2:2:1:OneHandAxe::1:0::3:0", -- Ornate Thorium Handaxe
	[12774]="0:2:3:1:OneHandAxe::1:0::2:0", -- Dawn's Edge
	[12775]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Huge Thorium Battleaxe
	[12776]="0:2:3:1:TwoHandMace::1:0::2:0", -- Enchanted Battlehammer
	[12777]="0:2:3:1:OneHandSword::1:0::2:0", -- Blazing Rapier
	[12779]="0:2:2:1:OneHandAxe::1:0::3:0", -- Rune Edge
	[12780]="0:12:1:1:::1:0::3:0", -- General Drakkisath's Command
	[12781]="0:2:3:1:OneHandMace::1:0::2:0", -- Serenity
	[12782]="0:2:3:1:TwoHandSword::1:0::3:0", -- Corruption
	[12783]="0:2:3:1:Dagger::1:0::2:0", -- Heartseeker
	[12784]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Arcanite Reaper
	[12785]="0:12:1:1:::1:0::4:0", -- Incendia Powder
	[12790]="0:2:3:1:TwoHandSword::1:0::2:0", -- Arcanite Champion
	[12791]="0:2:3:1:Dagger::1:0::3:0", -- Barman Shanker
	[12792]="0:2:2:1:OneHandMace::1:0::2:0", -- Volcanic Hammer
	[12793]="0:4:3:1:Leather::1:0::3:0", -- Mixologist's Tunic
	[12794]="0:2:3:1:OneHandMace::1:0::2:0", -- Masterwork Stormhammer
	[12795]="0:2:3:1:FistWeapon::1:0::3:0", -- Blood Talon
	[12796]="0:2:3:1:TwoHandMace::1:0::2:0", -- Hammer of the Titans
	[12797]="0:2:3:1:OneHandSword::1:0::2:0", -- Frostguard
	[12798]="0:2:3:1:OneHandAxe::1:0::2:0", -- Annihilator
	[12799]="0:3:2:20:GemSimple:164,202,755:1:0::0:0", -- Large Opal
	[12800]="0:3:2:20:GemSimple:164,202,755,197:1:0::0:0", -- Azerothian Diamond
	[12803]="0:7:2:10:Elemental:171,164,333,202,755,165,197:1:0::0:0", -- Living Essence
	[12804]="0:7:1:20:Other:171,164,202,755,165,197:1:0::0:0", -- Powerful Mojo
	[12806]="0:12:3:1:::1:0::3:0", -- Unforged Rune Covered Breastplate
	[12807]="0:12:1:1:::1:0::4:0", -- Scourge Banner
	[12808]="0:7:2:10:Elemental:171,164,185,333,202,755,197:1:0::0:0", -- Essence of Undeath
	[12809]="0:7:2:20:MetalStone:164,165,197:1:0::0:0", -- Guardian Stone
	[12810]="0:7:1:20:Leather:164,202,165,197:1:0::0:0", -- Enchanted Leather
	[12811]="0:7:2:20:Other:164,333,197:1:0::0:0", -- Righteous Orb
	[12812]="0:12:3:1:::1:0::3:0", -- Unfired Plate Gauntlets
	[12813]="0:12:1:1:::1:0::4:0", -- Flask of Mystery Goo
	[12814]="0:12:1:1:::1:0::4:0", -- Flame in a Bottle
	[12815]="0:12:1:1:::1:0::4:0", -- Beacon Torch
	[12819]="16000:9:2:1:Blacksmithing::1:0:11278:3:0", -- Plans: Ornate Thorium Handaxe
	[12820]="0:0:1:10:Elixir::1:0::0:0", -- Winterfall Firewater
	[12821]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Dawn's Edge
	[12822]="0:12:1:20:::1:0::4:0", -- Toxic Horror Droplet
	[12823]="20000:9:1:1:Blacksmithing::1:0:11278:3:0", -- Plans: Huge Thorium Battleaxe
	[12824]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Enchanted Battlehammer
	[12825]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Blazing Rapier
	[12827]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Serenity
	[12828]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Volcanic Hammer
	[12829]="0:12:1:1:::1:0::4:0", -- Winterfall Crate
	[12830]="0:9:1:1:Blacksmithing::1:0::0:0", -- Plans: Corruption
	[12833]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Hammer of the Titans
	[12834]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Arcanite Champion
	[12835]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Annihilator
	[12836]="80000:9:3:1:Blacksmithing::1:1:50129:0:0", -- Plans: Frostguard
	[12837]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Masterwork Stormhammer
	[12838]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Arcanite Reaper
	[12839]="0:9:3:1:Blacksmithing::1:0::0:0", -- Plans: Heartseeker
	[12842]="0:12:1:1:::1:0::3:0", -- Crudely-Written Log
	[12844]="0:12:2:250:::1:0::3:0", -- Argent Dawn Valor Token
	[12845]="0:12:1:1:::1:0::0:0", -- Medallion of Faith
	[12846]="0:4:1:1:Trinket::1:0::3:0", -- Argent Dawn Commission
	[12847]="0:12:1:1:::1:0::4:0", -- Soul Stained Pike
	[12848]="0:12:1:1:::1:0::3:0", -- Blood Stained Pike
	[12849]="0:12:2:1:::1:0::3:0", -- Demon Kissed Sack
	[12871]="0:15:4:1:Junk::1:0::3:0", -- Chromatic Carapace
	[12884]="0:0:1:1:Consumable::1:0::4:0", -- Arnak's Hoof
	[12885]="0:0:1:1:Consumable::1:0::4:0", -- Pamela's Doll
	[12886]="0:0:1:1:Consumable::1:0::4:0", -- Pamela's Doll's Head
	[12887]="0:12:1:1:::1:0::4:0", -- Pamela's Doll's Left Side
	[12888]="0:12:1:1:::1:0::4:0", -- Pamela's Doll's Right Side
	[12891]="0:12:1:1:::1:0::4:0", -- Jaron's Pick
	[12894]="0:0:1:1:Consumable::1:0::4:0", -- Joseph's Wedding Ring
	[12895]="0:4:4:1:Plate::1:0::3:0", -- Breastplate of the Chromatic Flight
	[12896]="0:12:1:1:::1:0::4:0", -- First Relic Fragment
	[12897]="0:12:1:1:::1:0::4:0", -- Second Relic Fragment
	[12898]="0:12:1:1:::1:0::4:0", -- Third Relic Fragment
	[12899]="0:12:1:1:::1:0::4:0", -- Fourth Relic Fragment
	[12900]="0:12:1:1:::1:0::4:0", -- Annals of Darrowshire
	[12903]="0:4:4:1:Mail::1:0::3:0", -- Legguards of the Chromatic Defier
	[12905]="0:4:3:1:Cloak::1:0::3:0", -- Wildfire Cape
	[12906]="0:12:1:1:::1:0::4:0", -- Purified Moonwell Water
	[12907]="0:12:1:1:::1:0::4:0", -- Corrupt Moonwell Water
	[12922]="0:0:1:1:Consumable::1:0::4:0", -- Empty Canteen
	[12923]="0:12:1:1:::1:0::4:0", -- Awbee's Scale
	[12924]="0:0:1:5:Consumable::1:0::3:0", -- Ritual Candle
	[12925]="0:12:1:1:::1:0::4:0", -- Arikara Serpent Skin
	[12926]="0:4:3:1:Ring::1:0::3:0", -- Flaming Band
	[12927]="0:4:3:1:Leather::1:0::3:0", -- Truestrike Shoulders
	[12928]="0:12:1:1:::1:0::4:0", -- Umi's Mechanical Yeti
	[12929]="0:4:3:1:Amulet::1:0::3:0", -- Emberfury Talisman
	[12930]="0:4:3:1:Trinket::1:0::3:0", -- Briarwood Reed
	[12935]="0:4:3:1:Plate::1:0::3:0", -- Warmaster Legguards
	[12936]="0:4:3:1:Plate::1:0::3:0", -- Battleborn Armbraces
	[12938]="0:12:1:20::171,755:1:0::3:0", -- Blood of Heroes
	[12939]="0:2:3:1:OneHandSword::1:0::3:0", -- Dal'Rend's Tribal Guardian
	[12940]="0:2:3:1:OneHandSword::1:0::3:0", -- Dal'Rend's Sacred Charge
	[12942]="0:13:1:1:::1:0::4:0", -- Panther Cage Key
	[12945]="0:4:4:1:Mail::1:0::3:0", -- Legplates of the Chromatic Defier
	[12946]="0:12:1:1:::1:0::4:0", -- Hypercapacitor Gizmo
	[12947]="0:4:6:1:Ring::1:0::0:0", -- Alex's Ring of Audacity
	[12952]="0:4:3:1:Plate::1:0::3:0", -- Gyth's Skull
	[12953]="0:4:3:1:Mail::1:0::3:0", -- Dragoneye Coif
	[12954]="0:12:1:1:::1:0::4:0", -- Davil's Libram
	[12955]="0:12:1:1:::1:0::4:0", -- Redpath's Shield
	[12956]="0:12:1:1:::1:0::4:0", -- Skull of Horgus
	[12957]="0:12:1:1:::1:0::4:0", -- Shattered Sword of Marduk
	[12958]="50000:9:1:1:Alchemy::1:0:5594:0:0", -- Recipe: Transmute Arcanite
	[12960]="0:4:3:1:Leather::1:0::3:0", -- Tribal War Feathers
	[12963]="0:4:3:1:Leather::1:0::3:0", -- Blademaster Leggings
	[12964]="0:4:3:1:Mail::1:0::3:0", -- Tristam Legguards
	[12965]="0:4:3:1:Cloth::1:0::3:0", -- Spiritshroud Leggings
	[12966]="0:4:3:1:Leather::1:0::3:0", -- Blackmist Armguards
	[12967]="0:4:3:1:Cloak::1:0::3:0", -- Bloodmoon Cloak
	[12968]="0:4:3:1:Cloak::1:0::3:0", -- Frostweaver Cape
	[12969]="0:2:3:1:TwoHandMace::1:0::3:0", -- Seeping Willow
	[12973]="0:15:1:5:Junk::1:0::0:0", -- Scarlet Cannonball
	[12974]="0:2:3:1:OneHandSword::1:0::2:0", -- The Black Knight
	[12975]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Prospector Axe
	[12976]="0:2:3:1:OneHandSword::1:0::2:0", -- Ironpatch Blade
	[12977]="0:4:3:1:Cloth::1:0::2:0", -- Magefist Gloves
	[12978]="0:4:3:1:Mail::1:0::2:0", -- Stormbringer Belt
	[12979]="0:4:3:1:Cloak::1:0::2:0", -- Firebane Cloak
	[12982]="0:4:3:1:Mail::1:0::2:0", -- Silver-Linked Footguards
	[12983]="0:2:3:1:TwoHandMace::1:0::2:0", -- Rakzur Club
	[12984]="0:2:3:1:Wand::1:0::2:0", -- Skycaller
	[12985]="0:4:3:1:Ring::1:0::2:0", -- Ring of Defense
	[12987]="0:4:3:1:Cloth::1:0::2:0", -- Darkweave Breeches
	[12988]="0:4:3:1:Leather::1:0::2:0", -- Starsight Tunic
	[12989]="0:2:3:1:Polearm::1:0::2:0", -- Gargoyle's Bite
	[12990]="0:2:3:1:OneHandAxe::1:0::2:0", -- Razor's Edge
	[12992]="0:2:3:1:TwoHandSword::1:0::2:0", -- Searing Blade
	[12994]="0:4:3:1:Mail::1:0::2:0", -- Thorbia's Gauntlets
	[12996]="0:4:3:1:Ring::1:0::2:0", -- Band of Purification
	[12997]="0:4:3:1:Shield::1:0::2:0", -- Redbeard Crest
	[12998]="0:4:3:1:Cloth::1:0::2:0", -- Magician's Mantle
	[12999]="0:4:3:1:Leather::1:0::2:0", -- Drakewing Bands
	[13000]="0:2:3:1:Stave::1:0::2:0", -- Staff of Hale Magefire
	[13001]="0:4:3:1:Ring::1:0::2:0", -- Maiden's Circle
	[13002]="0:4:3:1:Amulet::1:0::2:0", -- Lady Alizabeth's Pendant
	[13003]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Lord Alexander's Battle Axe
	[13004]="0:2:3:1:Wand::1:0::2:0", -- Torch of Austen
	[13005]="0:4:3:1:Cloak::1:0::2:0", -- Amy's Blanket
	[13006]="0:2:3:1:OneHandMace::1:0::2:0", -- Mass of McGowan
	[13007]="0:4:3:1:Cloak::1:0::2:0", -- Mageflame Cloak
	[13008]="0:4:3:1:Cloth::1:0::2:0", -- Dalewind Trousers
	[13009]="0:4:3:1:Leather::1:0::2:0", -- Cow King's Hide
	[13010]="0:4:3:1:Mail::1:0::2:0", -- Dreamsinger Legguards
	[13011]="0:4:3:1:Leather::1:0::2:0", -- Silver-Lined Belt
	[13012]="0:4:3:1:Mail::1:0::2:0", -- Yorgen Bracers
	[13013]="0:4:3:1:Cloth::1:0::2:0", -- Elder Wizard's Mantle
	[13014]="0:2:3:1:OneHandAxe::1:0::2:0", -- Axe of Rin'ji
	[13015]="0:2:3:1:OneHandAxe::1:0::2:0", -- Serathil
	[13016]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Killmaim
	[13017]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Hellslayer Battle Axe
	[13018]="0:2:3:1:TwoHandAxe::1:0::2:0", -- Executioner's Cleaver
	[13019]="0:2:3:1:Bow::1:0::2:0", -- Harpyclaw Short Bow
	[13020]="0:2:3:1:Bow::1:0::2:0", -- Skystriker Bow
	[13021]="0:2:3:1:Bow::1:0::2:0", -- Needle Threader
	[13022]="0:2:3:1:Bow::1:0::2:0", -- Gryphonwing Long Bow
	[13023]="0:2:3:1:Bow::1:0::2:0", -- Eaglehorn Long Bow
	[13024]="0:2:3:1:OneHandMace::1:0::2:0", -- Beazel's Basher
	[13025]="0:2:3:1:OneHandMace::1:0::2:0", -- Deadwood Sledge
	[13026]="0:2:3:1:OneHandMace::1:0::2:0", -- Heaven's Light
	[13027]="0:2:3:1:OneHandMace::1:0::2:0", -- Bonesnapper
	[13028]="0:2:3:1:OneHandMace::1:0::2:0", -- Bludstone Hammer
	[13029]="0:4:3:1:OffHandFrill::1:0::2:0", -- Umbral Crystal
	[13030]="0:4:3:1:OffHandFrill::1:0::2:0", -- Basilisk Bone
	[13031]="0:4:3:1:OffHandFrill::1:0::2:0", -- Orb of Mistmantle
	[13032]="0:2:3:1:OneHandSword::1:0::2:0", -- Sword of Corruption
	[13033]="0:2:3:1:OneHandSword::1:0::2:0", -- Zealot Blade
	[13034]="0:2:3:1:OneHandSword::1:0::2:0", -- Speedsteel Rapier
	[13035]="0:2:3:1:OneHandSword::1:0::2:0", -- Serpent Slicer
	[13036]="0:2:3:1:OneHandSword::1:0::2:0", -- Assassination Blade
	[13037]="0:2:3:1:Crossbow::1:0::2:0", -- Crystalpine Stinger
	[13038]="0:2:3:1:Crossbow::1:0::2:0", -- Swiftwind
	[13039]="0:2:3:1:Crossbow::1:0::2:0", -- Skull Splitting Crossbow
	[13040]="0:2:3:1:Crossbow::1:0::2:0", -- Heartseeking Crossbow
	[13041]="0:2:3:1:TwoHandSword::1:0::2:0", -- Guardian Blade
	[13042]="0:2:3:1:TwoHandSword::1:0::2:0", -- Sword of the Magistrate
	[13043]="0:2:3:1:TwoHandSword::1:0::2:0", -- Blade of the Titans
	[13044]="0:2:3:1:TwoHandSword::1:0::2:0", -- Demonslayer
	[13045]="0:2:3:1:TwoHandMace::1:0::2:0", -- Viscous Hammer
	[13046]="0:2:3:1:TwoHandMace::1:0::2:0", -- Blanchard's Stout
	[13047]="0:2:3:1:TwoHandMace::1:0::2:0", -- Twig of the World Tree
	[13048]="0:2:3:1:OneHandMace::1:0::2:0", -- Looming Gavel
	[13049]="0:2:3:1:TwoHandSword::1:0::2:0", -- Deanship Claymore
	[13051]="0:2:3:1:TwoHandSword::1:0::2:0", -- Witchfury
	[13052]="0:2:3:1:TwoHandSword::1:0::2:0", -- Warmonger
	[13053]="0:2:3:1:TwoHandSword::1:0::2:0", -- Doombringer
	[13054]="0:2:3:1:Polearm::1:0::2:0", -- Grim Reaper
	[13055]="0:2:3:1:Polearm::1:0::2:0", -- Bonechewer
	[13056]="0:2:3:1:Polearm::1:0::2:0", -- Frenzied Striker
	[13057]="0:2:3:1:Polearm::1:0::2:0", -- Bloodpike
	[13058]="0:2:3:1:Polearm::1:0::2:0", -- Khoo's Point
	[13059]="0:2:3:1:Polearm::1:0::2:0", -- Stoneraven
	[13060]="0:2:3:1:Polearm::1:0::2:0", -- The Needler
	[13062]="0:2:3:1:Wand::1:0::2:0", -- Thunderwood
	[13063]="0:2:3:1:Wand::1:0::2:0", -- Starfaller
	[13064]="0:2:3:1:Wand::1:0::2:0", -- Jaina's Firestarter
	[13065]="0:2:3:1:Wand::1:0::2:0", -- Wand of Allistarj
	[13066]="0:4:3:1:Plate::1:0::2:0", -- Wyrmslayer Spaulders
	[13067]="0:4:3:1:Plate::1:0::2:0", -- Hydralick Armor
	[13068]="0:4:3:1:Plate::1:0::2:0", -- Obsidian Greaves
	[13070]="0:4:3:1:Plate::1:0::2:0", -- Sapphiron's Scale Boots
	[13071]="0:4:3:1:Plate::1:0::2:0", -- Plated Fist of Hakoo
	[13072]="0:4:3:1:Plate::1:0::2:0", -- Stonegrip Gauntlets
	[13073]="0:4:3:1:Plate::1:0::2:0", -- Mugthol's Helm
	[13074]="0:4:3:1:Plate::1:0::2:0", -- Golem Shard Leggings
	[13075]="0:4:3:1:Plate::1:0::2:0", -- Direwing Legguards
	[13076]="0:4:3:1:Plate::1:0::2:0", -- Giantslayer Bracers
	[13077]="0:4:3:1:Plate::1:0::2:0", -- Girdle of Uther
	[13079]="0:4:3:1:Shield::1:0::2:0", -- Shield of Thorsen
	[13081]="0:4:3:1:Shield::1:0::2:0", -- Skullance Shield
	[13082]="0:4:3:1:Shield::1:0::2:0", -- Mountainside Buckler
	[13083]="0:4:3:1:Shield::1:0::2:0", -- Garrett Family Crest
	[13084]="0:4:3:1:Amulet::1:0::2:0", -- Kaleidoscope Chain
	[13085]="0:4:3:1:Amulet::1:0::2:0", -- Horizon Choker
	[13086]="1000000:15:4:1:Mount::1:0:10618:3:0", -- Reins of the Winterspring Frostsaber
	[13087]="0:4:3:1:Amulet::1:0::2:0", -- River Pride Choker
	[13088]="0:4:3:1:Amulet::1:0::2:0", -- Gazlowe's Charm
	[13089]="0:4:3:1:Amulet::1:0::2:0", -- Skibi's Pendant
	[13091]="0:4:3:1:Amulet::1:0::2:0", -- Medallion of Grand Marshal Morris
	[13093]="0:4:3:1:Ring::1:0::2:0", -- Blush Ember Ring
	[13094]="0:4:3:1:Ring::1:0::2:0", -- The Queen's Jewel
	[13095]="0:4:3:1:Ring::1:0::2:0", -- Assault Band
	[13096]="0:4:3:1:Ring::1:0::2:0", -- Band of the Hierophant
	[13097]="0:4:3:1:Ring::1:0::2:0", -- Thunderbrow Ring
	[13098]="0:4:3:1:Ring::1:0::3:0", -- Painweaver Band
	[13099]="0:4:3:1:Cloth::1:0::2:0", -- Moccasins of the White Hare
	[13100]="0:4:3:1:Cloth::1:0::2:0", -- Furen's Boots
	[13101]="0:4:3:1:Cloth::1:0::2:0", -- Wolfrunner Shoes
	[13102]="0:4:3:1:Cloth::1:0::2:0", -- Cassandra's Grace
	[13103]="0:4:3:1:Cloth::1:0::2:0", -- Pads of the Venom Spider
	[13105]="0:4:3:1:Cloth::1:0::2:0", -- Sutarn's Ring
	[13106]="0:4:3:1:Cloth::1:0::2:0", -- Glowing Magical Bracelets
	[13107]="0:4:3:1:Cloth::1:0::2:0", -- Magiskull Cuffs
	[13108]="0:4:3:1:Cloak::1:0::2:0", -- Tigerstrike Mantle
	[13109]="0:4:3:1:Cloak::1:0::2:0", -- Blackflame Cape
	[13110]="0:4:3:1:Leather::1:0::2:0", -- Wolffear Harness
	[13111]="0:4:3:1:Leather::1:0::2:0", -- Sandals of the Insurgent
	[13112]="0:4:3:1:Leather::1:0::2:0", -- Winged Helm
	[13113]="0:4:3:1:Leather::1:0::2:0", -- Feathermoon Headdress
	[13114]="0:4:3:1:Leather::1:0::2:0", -- Troll's Bane Leggings
	[13115]="0:4:3:1:Leather::1:0::2:0", -- Sheepshear Mantle
	[13116]="0:4:3:1:Leather::1:0::2:0", -- Spaulders of the Unseen
	[13117]="0:4:3:1:Leather::1:0::2:0", -- Ogron's Sash
	[13118]="0:4:3:1:Leather::1:0::2:0", -- Serpentine Sash
	[13119]="0:4:3:1:Leather::1:0::2:0", -- Enchanted Kodo Bracers
	[13120]="0:4:3:1:Leather::1:0::2:0", -- Deepfury Bracers
	[13121]="0:4:3:1:Cloak::1:0::2:0", -- Wing of the Whelpling
	[13122]="0:4:3:1:Cloak::1:0::2:0", -- Dark Phantom Cape
	[13123]="0:4:3:1:Mail::1:0::2:0", -- Dreamwalker Armor
	[13124]="0:4:3:1:Mail::1:0::2:0", -- Ravasaur Scale Boots
	[13125]="0:4:3:1:Mail::1:0::2:0", -- Elven Chain Boots
	[13126]="0:4:3:1:Mail::1:0::2:0", -- Battlecaller Gauntlets
	[13127]="0:4:3:1:Mail::1:0::2:0", -- Frostreaver Crown
	[13128]="0:4:3:1:Mail::1:0::2:0", -- High Bergg Helm
	[13129]="0:4:3:1:Mail::1:0::2:0", -- Firemane Leggings
	[13130]="0:4:3:1:Mail::1:0::2:0", -- Windrunner Legguards
	[13131]="0:4:3:1:Mail::1:0::2:0", -- Sparkleshell Mantle
	[13132]="0:4:3:1:Mail::1:0::2:0", -- Skeletal Shoulders
	[13133]="0:4:3:1:Mail::1:0::2:0", -- Drakesfire Epaulets
	[13134]="0:4:3:1:Mail::1:0::2:0", -- Belt of the Gladiator
	[13135]="0:4:3:1:Mail::1:0::2:0", -- Lordly Armguards
	[13136]="0:2:3:1:Gun::1:0::2:0", -- Lil Timmy's Peashooter
	[13137]="0:2:3:1:Gun::1:0::2:0", -- Ironweaver
	[13138]="0:2:3:1:Gun::1:0::2:0", -- The Silencer
	[13139]="0:2:3:1:Gun::1:0::2:0", -- Guttbuster
	[13140]="0:13:1:1:::1:0::3:0", -- Blood Red Key
	[13141]="0:4:3:1:Amulet::1:0::3:0", -- Tooth of Gnarr
	[13142]="0:4:3:1:Plate::1:0::3:0", -- Brigam Girdle
	[13143]="0:4:4:1:Ring::1:0::3:0", -- Mark of the Dragon Lord
	[13144]="0:4:3:1:Cloth::1:0::2:0", -- Serenity Belt
	[13145]="0:4:3:1:Plate::1:0::2:0", -- Enormous Ogre Belt
	[13146]="0:2:3:1:Gun::1:0::2:0", -- Shell Launcher Shotgun
	[13148]="0:2:3:1:Polearm::1:0::3:0", -- Chillpike
	[13155]="0:0:1:20:Consumable::1:0::4:0", -- Resonating Skull
	[13156]="0:0:1:1:Consumable::1:0::4:0", -- Mystic Crystal
	[13157]="0:12:1:20:::1:0::4:0", -- Fetid Skull
	[13158]="0:12:1:1:::1:0::3:0", -- Words of the High Chief
	[13159]="0:12:1:20:::1:0::0:0", -- Bone Dust
	[13161]="0:2:3:1:Stave::1:0::3:0", -- Trindlehaven Staff
	[13162]="0:4:3:1:Plate::1:0::3:0", -- Reiver Claws
	[13163]="0:2:3:1:TwoHandSword::1:0::3:0", -- Relentless Scythe
	[13164]="0:4:3:1:Trinket::1:0::3:0", -- Heart of the Scale
	[13166]="0:4:3:1:Plate::1:0::3:0", -- Slamshot Shoulders
	[13167]="0:2:3:1:TwoHandMace::1:0::3:0", -- Fist of Omokk
	[13168]="0:4:3:1:Plate::1:0::3:0", -- Plate of the Shaman King
	[13169]="0:4:3:1:Leather::1:0::3:0", -- Tressermane Leggings
	[13170]="0:4:3:1:Cloth::1:0::3:0", -- Skyshroud Leggings
	[13171]="0:4:2:1:Trinket::1:0::3:0", -- Smokey's Lighter
	[13172]="0:12:1:1:::1:0::4:0", -- Siabi's Premium Tobacco
	[13173]="0:15:3:200:Junk::1:0::3:0", -- Broken Flightblade Throwing Axe
	[13174]="0:12:1:30:::1:0::4:0", -- Plagued Flesh Sample
	[13175]="0:2:3:1:Bow::1:0::3:0", -- Voone's Twitchbow
	[13176]="0:12:1:1:::1:0::4:0", -- Scourge Data
	[13177]="0:4:3:1:Amulet::1:0::3:0", -- Talisman of Evasion
	[13178]="0:4:3:1:Ring::1:0::3:0", -- Rosewine Circle
	[13179]="0:4:3:1:Mail::1:0::3:0", -- Brazecore Armguards
	[13180]="0:12:1:50:::1:0::3:0", -- Stratholme Holy Water
	[13181]="0:4:3:1:Cloth::1:0::3:0", -- Demonskin Gloves
	[13182]="0:2:3:1:OneHandSword::1:0::3:0", -- Phase Blade
	[13183]="0:2:3:1:OneHandMace::1:0::3:0", -- Venomspitter
	[13184]="0:4:3:1:Leather::1:0::3:0", -- Fallbrush Handgrips
	[13185]="0:4:3:1:Cloth::1:0::3:0", -- Sunderseer Mantle
	[13186]="0:12:1:1:::1:0::4:0", -- Empty Felstone Field Bottle
	[13187]="0:12:1:1:::1:0::4:0", -- Empty Dalson's Tears Bottle
	[13188]="0:12:1:1:::1:0::4:0", -- Empty Writhing Haunt Bottle
	[13189]="0:12:1:1:::1:0::4:0", -- Empty Gahrron's Withering Bottle
	[13190]="0:12:1:1:::1:0::4:0", -- Filled Felstone Field Bottle
	[13191]="0:12:1:1:::1:0::4:0", -- Filled Dalson's Tears Bottle
	[13192]="0:12:1:1:::1:0::4:0", -- Filled Writhing Haunt Bottle
	[13193]="0:12:1:1:::1:0::4:0", -- Filled Gahrron's Withering Bottle
	[13194]="0:13:1:1:::1:0::4:0", -- Felstone Field Cauldron Key
	[13195]="0:13:1:1:::1:0::4:0", -- Dalson's Tears Cauldron Key
	[13196]="0:13:1:1:::1:0::4:0", -- Gahrron's Withering Cauldron Key
	[13198]="0:2:3:1:FistWeapon::1:0::3:0", -- Hurd Smasher
	[13199]="0:4:3:1:Mail::1:0::2:0", -- Crushridge Bindings
	[13202]="0:12:1:1:::1:0::4:0", -- Extended Annals of Darrowshire
	[13203]="0:4:3:1:Cloak::1:0::3:0", -- Armswake Cloak
	[13204]="0:2:3:1:OneHandMace::1:0::3:0", -- Bashguuder
	[13205]="0:4:3:1:Shield::1:0::3:0", -- Rhombeard Protector
	[13206]="0:4:3:1:Cloth::1:0::3:0", -- Wolfshear Leggings
	[13207]="0:12:1:1:::1:0::4:0", -- Shadow Lord Fel'dan's Head
	[13208]="0:4:3:1:Leather::1:0::3:0", -- Bleak Howler Armguards
	[13209]="0:4:3:1:Trinket::1:0::3:0", -- Seal of the Dawn
	[13210]="0:4:3:1:Leather::1:0::3:0", -- Pads of the Dread Wolf
	[13211]="0:4:3:1:Mail::1:0::3:0", -- Slashclaw Bracers
	[13212]="0:4:3:1:Amulet::1:0::3:0", -- Halycon's Spiked Collar
	[13213]="0:4:3:1:Trinket::1:0::3:0", -- Smolderweb's Eye
	[13216]="0:4:2:1:Cloth::1:0::3:0", -- Crown of the Penitent
	[13217]="0:4:2:1:Ring::1:0::3:0", -- Band of the Penitent
	[13218]="0:2:3:1:Dagger::1:0::3:0", -- Fang of the Crystal Spider
	[13243]="0:4:3:1:Shield::1:0::3:0", -- Argent Defender
	[13244]="0:4:3:1:Mail::1:0::3:0", -- Gilded Gauntlets
	[13245]="0:4:3:1:Shield::1:0::3:0", -- Kresh's Back
	[13246]="0:2:3:1:OneHandSword::1:0::3:0", -- Argent Avenger
	[13248]="0:2:3:1:Gun::1:0::3:0", -- Burstshot Harquebus
	[13249]="0:2:3:1:Stave::1:0::3:0", -- Argent Crusader
	[13250]="0:12:1:1:::1:0::3:0", -- Head of Balnazzar
	[13251]="0:12:1:1:::1:0::4:0", -- Head of Baron Rivendare
	[13252]="0:4:3:1:Leather::1:0::3:0", -- Cloudrunner Girdle
	[13253]="0:4:3:1:Cloth::1:0::3:0", -- Hands of Power
	[13254]="0:4:3:1:Shield::1:0::3:0", -- Astral Guard
	[13255]="0:4:3:1:Mail::1:0::3:0", -- Trueaim Gauntlets
	[13257]="0:4:3:1:Leather::1:0::3:0", -- Demonic Runed Spaulders
	[13258]="0:4:3:1:Leather::1:0::3:0", -- Slaghide Gauntlets
	[13259]="0:4:3:1:Plate::1:0::3:0", -- Ribsteel Footguards
	[13260]="0:4:3:1:Mail::1:0::2:0", -- Wind Dancer Boots
	[13261]="0:4:3:1:OffHandFrill::1:0::3:0", -- Globe of D'sak
	[13262]="0:2:5:1:TwoHandSword::1:0::3:0", -- Ashbringer
	[13282]="0:4:3:1:Cloth::1:0::3:0", -- Ogreseer Tower Boots
	[13283]="0:4:3:1:Ring::1:0::3:0", -- Magus Ring
	[13284]="0:4:3:1:Mail::1:0::3:0", -- Swiftdart Battleboots
	[13285]="0:2:3:1:TwoHandAxe::1:0::3:0", -- The Blackrock Slicer
	[13286]="0:2:3:1:OneHandAxe::1:0::3:0", -- Rivenspike
	[13287]="2500:9:2:1:Leatherworking::1:1:2819:0:0", -- Pattern: Raptor Hide Harness
	[13288]="2500:9:2:1:Leatherworking::1:1:2816:0:0", -- Pattern: Raptor Hide Belt
	[13289]="0:12:1:1:::1:0::4:0", -- Egan's Blaster
	[13302]="0:13:1:20:::1:0::0:0", -- Market Row Postbox Key
	[13303]="0:13:1:20:::1:0::0:0", -- Crusaders' Square Postbox Key
	[13304]="0:13:1:20:::1:0::0:0", -- Festival Lane Postbox Key
	[13305]="0:13:1:20:::1:0::0:0", -- Elders' Square Postbox Key
	[13306]="0:13:1:20:::1:0::0:0", -- King's Square Postbox Key
	[13307]="0:13:1:20:::1:0::0:0", -- Fras Siabi's Postbox Key
	[13308]="0:9:1:1:Engineering::1:0::0:0", -- Schematic: Ice Deflector
	[13309]="0:9:1:1:Engineering::1:0::0:0", -- Schematic: Lovingly Crafted Boomstick
	[13310]="2000:9:1:1:Engineering::1:1:2685:0:0", -- Schematic: Accurate Scope
	[13311]="10000:9:1:1:Engineering::1:1:2687,35826:0:0", -- Schematic: Mechanical Dragonling
	[13313]="0:12:1:1:::1:0::4:0", -- Sacred Highborne Writings
	[13314]="0:4:4:1:Cloth::1:0::3:0", -- Alanna's Embrace
	[13315]="0:4:2:1:OffHandFrill::1:0::3:0", -- Testament of Hope
	[13317]="0:15:4:1:Mount::1:0::3:0", -- Whistle of the Ivory Raptor
	[13320]="5000:12:1:1:::1:0:11056,11057:4:0", -- Arcane Quickener
	[13321]="10000:15:3:1:Mount::1:0:7955:3:0", -- Green Mechanostrider
	[13322]="10000:15:3:1:Mount::1:0:7955:3:0", -- Unpainted Mechanostrider
	[13326]="0:15:4:1:Mount::1:0::3:0", -- White Mechanostrider Mod B
	[13327]="0:15:4:1:Mount::1:0::3:0", -- Icy Blue Mechanostrider Mod A
	[13328]="0:15:4:1:Mount::1:0::3:0", -- Black Ram
	[13329]="0:15:4:1:Mount::1:0::3:0", -- Frost Ram
	[13331]="10000:15:3:1:Mount::1:0:4731:3:0", -- Red Skeletal Horse
	[13332]="10000:15:3:1:Mount::1:0:4731:3:0", -- Blue Skeletal Horse
	[13333]="10000:15:3:1:Mount::1:0:4731:3:0", -- Brown Skeletal Horse
	[13334]="100000:15:4:1:Mount::1:0:4731:3:0", -- Green Skeletal Warhorse
	[13335]="0:15:4:1:Mount::1:0::3:0", -- Deathcharger's Reins
	[13340]="0:4:3:1:Cloak::1:0::3:0", -- Cape of the Black Baron
	[13344]="0:4:3:1:Mail::1:0::3:0", -- Dracorian Gauntlets
	[13345]="0:4:3:1:Ring::1:0::3:0", -- Seal of Rivendare
	[13346]="0:4:3:1:Cloth::1:0::3:0", -- Robes of the Exalted
	[13347]="0:12:1:1:::1:0::4:0", -- Crystal of Zin-Malor
	[13348]="0:2:3:1:TwoHandSword::1:0::3:0", -- Demonshear
	[13349]="0:2:3:1:OneHandMace::1:0::3:0", -- Scepter of the Unholy
	[13350]="0:12:1:1:::1:0::4:0", -- Insignia of the Black Guard
	[13351]="0:12:1:1:::1:0::4:0", -- Crimson Hammersmith's Apron
	[13352]="0:12:1:1:::1:0::4:0", -- Vosh'gajin's Snakestone
	[13353]="0:4:4:1:OffHandFrill::1:0::3:0", -- Book of the Dead
	[13354]="0:12:1:200:::1:0::3:0", -- Ectoplasmic Resonator
	[13356]="0:12:1:200:::1:0::3:0", -- Somatic Intensifier
	[13357]="0:12:1:200:::1:0::3:0", -- Osseous Agitator
	[13358]="0:4:3:1:Leather::1:0::3:0", -- Wyrmtongue Shoulders
	[13359]="0:4:3:1:Mail::1:0::3:0", -- Crown of Tyranny
	[13360]="0:2:3:1:Dagger::1:0::3:0", -- Gift of the Elven Magi
	[13361]="0:2:3:1:OneHandSword::1:0::3:0", -- Skullforge Reaver
	[13362]="0:15:0:20:Junk::1:0::0:0", -- Letter from the Front
	[13363]="0:15:0:20:Junk::1:0::0:0", -- Municipal Proclamation
	[13364]="0:15:0:20:Junk::1:0::0:0", -- Fras Siabi's Advertisement
	[13365]="0:15:0:20:Junk::1:0::0:0", -- Town Meeting Notice
	[13366]="0:15:0:20:Junk::1:0::0:0", -- Ingenious Toy
	[13367]="0:0:0:1:Other::1:0::0:0", -- Wrapped Gift
	[13368]="0:2:3:1:Dagger::1:0::3:0", -- Bonescraper
	[13369]="0:4:3:1:Cloth::1:0::3:0", -- Fire Striders
	[13370]="0:12:1:1:::1:0::4:0", -- Vitreous Focuser
	[13371]="0:4:3:1:OffHandFrill::1:0::3:0", -- Father Flame
	[13372]="0:2:3:1:Stave::1:0::3:0", -- Slavedriver's Cane
	[13373]="0:4:3:1:Ring::1:0::3:0", -- Band of Flesh
	[13374]="0:4:3:1:Cloth::1:0::3:0", -- Soulstealer Mantle
	[13375]="0:4:3:1:Shield::1:0::3:0", -- Crest of Retribution
	[13376]="0:4:3:1:Cloak::1:0::3:0", -- Royal Tribunal Cloak
	[13377]="0:15:0:1000:Junk::1:0::3:0", -- Miniature Cannon Balls
	[13378]="0:4:3:1:Leather::1:0::3:0", -- Songbird Blouse
	[13379]="0:4:3:1:Trinket::1:0::3:0", -- Piccolo of the Flaming Fire
	[13380]="0:2:3:1:Gun::1:0::3:0", -- Willey's Portable Howitzer
	[13381]="0:4:3:1:Plate::1:0::3:0", -- Master Cannoneer Boots
	[13382]="0:4:3:1:Trinket::1:0::3:0", -- Cannonball Runner
	[13383]="0:4:3:1:Mail::1:0::3:0", -- Woollies of the Prancing Minstrel
	[13384]="0:4:3:1:Plate::1:0::3:0", -- Rainbow Girdle
	[13385]="0:4:3:1:OffHandFrill::1:0::3:0", -- Tome of Knowledge
	[13386]="0:4:3:1:Cloak::1:0::3:0", -- Archivist Cape
	[13387]="0:4:3:1:Mail::1:0::3:0", -- Foresight Girdle
	[13388]="0:4:3:1:Cloth::1:0::3:0", -- The Postmaster's Tunic
	[13389]="0:4:3:1:Cloth::1:0::3:0", -- The Postmaster's Trousers
	[13390]="0:4:3:1:Cloth::1:0::3:0", -- The Postmaster's Band
	[13391]="0:4:3:1:Cloth::1:0::3:0", -- The Postmaster's Treads
	[13392]="0:4:3:1:Ring::1:0::3:0", -- The Postmaster's Seal
	[13393]="0:2:3:1:TwoHandMace::1:0::3:0", -- Malown's Slam
	[13394]="0:4:3:1:Plate::1:0::3:0", -- Skul's Cold Embrace
	[13395]="0:4:3:1:Leather::1:0::3:0", -- Skul's Fingerbone Claws
	[13396]="0:2:3:1:Wand::1:0::3:0", -- Skul's Ghastly Touch
	[13397]="0:4:3:1:Cloak::1:0::3:0", -- Stoneskin Gargoyle Cape
	[13398]="0:4:3:1:Leather::1:0::3:0", -- Boots of the Shrieker
	[13399]="0:2:3:1:FistWeapon::1:0::3:0", -- Gargoyle Shredder Talons
	[13400]="0:4:3:1:Plate::1:0::3:0", -- Vambraces of the Sadist
	[13401]="0:2:3:1:OneHandMace::1:0::3:0", -- The Cruel Hand of Timmy
	[13402]="0:4:3:1:Mail::1:0::3:0", -- Timmy's Galoshes
	[13403]="0:4:3:1:Cloth::1:0::3:0", -- Grimgore Noose
	[13404]="0:4:3:1:Leather::1:0::3:0", -- Mask of the Unforgiven
	[13405]="0:4:3:1:Plate::1:0::3:0", -- Wailing Nightbane Pauldrons
	[13408]="0:2:3:1:OneHandAxe::1:0::3:0", -- Soul Breaker
	[13409]="0:4:3:1:Cloth::1:0::3:0", -- Tearfall Bracers
	[13422]="0:7:1:20:Other:171:1:0::0:0", -- Stonescale Eel
	[13423]="0:7:1:20:Other:171:1:0::0:0", -- Stonescale Oil
	[13442]="0:0:1:20:Potion::1:0::0:0", -- Mighty Rage Potion
	[13443]="1600:0:1:20:Potion::1:1:14847,28715,29537:0:0", -- Superior Mana Potion
	[13444]="6000:0:1:20:Potion:333:1:1:15471,19837,20092,20989:0:0", -- Major Mana Potion
	[13445]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Superior Defense
	[13446]="4000:0:1:20:Potion:333:1:1:15471,19837,20092,20989,29628:0:0", -- Major Healing Potion
	[13447]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of the Sages
	[13448]="0:12:1:1:::1:0::4:0", -- The Deed to Caer Darrow
	[13450]="0:12:1:1:::1:0::4:0", -- The Deed to Southshore
	[13451]="0:12:1:1:::1:0::4:0", -- The Deed to Tarren Mill
	[13452]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of the Mongoose
	[13453]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Brute Force
	[13454]="0:0:1:20:Elixir::1:0::0:0", -- Greater Arcane Elixir
	[13455]="0:0:1:20:Potion::1:0::0:0", -- Greater Stoneshield Potion
	[13456]="0:0:1:20:Potion::1:0::0:0", -- Greater Frost Protection Potion
	[13457]="0:0:1:20:Potion::1:0::0:0", -- Greater Fire Protection Potion
	[13458]="0:0:1:20:Potion::1:0::0:0", -- Greater Nature Protection Potion
	[13459]="0:0:1:20:Potion::1:0::0:0", -- Greater Shadow Protection Potion
	[13460]="0:0:1:20:Potion::1:0::0:0", -- Greater Holy Protection Potion
	[13461]="0:0:1:20:Potion::1:0::0:0", -- Greater Arcane Protection Potion
	[13462]="0:0:1:20:Potion::1:0::0:0", -- Purification Potion
	[13463]="400:7:1:20:Herb:171:1:1:14846:0:0", -- Dreamfoil
	[13464]="400:7:1:20:Herb:171:1:1:14846:0:0", -- Golden Sansam
	[13465]="0:7:1:20:Herb:171:1:0::0:0", -- Mountain Silversage
	[13466]="0:7:1:20:Herb:171:1:0::0:0", -- Sorrowmoss
	[13467]="1000:7:1:20:Herb:171,333,202:1:1:20989,24975:0:0", -- Icecap
	[13468]="4000:7:2:20:Herb:171,197:1:1:14846:0:0", -- Black Lotus
	[13469]="0:12:1:1:::1:0::4:0", -- Head of Weldon Barov
	[13470]="0:12:1:1:::1:0::4:0", -- Head of Alexi Barov
	[13471]="0:12:1:1:::1:0::4:0", -- The Deed to Brill
	[13473]="0:4:2:1:Amulet::1:0::3:0", -- Felstone Good Luck Charm
	[13474]="0:2:2:1:Gun::1:0::3:0", -- Farmer Dalson's Shotgun
	[13475]="0:4:2:1:Ring::1:0::3:0", -- Dalson Family Wedding Ring
	[13476]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Mighty Rage Potion
	[13477]="0:9:1:1:Alchemy::1:0::0:0", -- Recipe: Superior Mana Potion
	[13478]="13000:9:1:1:Alchemy::1:1:3348,5178:0:0", -- Recipe: Elixir of Superior Defense
	[13479]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Elixir of the Sages
	[13480]="0:9:1:1:Alchemy::1:0::0:0", -- Recipe: Major Healing Potion
	[13481]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Elixir of Brute Force
	[13482]="15000:9:2:1:Alchemy::1:0:10856,10857,11536:3:0", -- Recipe: Transmute Air to Fire
	[13483]="15000:9:2:1:Alchemy::1:0:9499:3:0", -- Recipe: Transmute Fire to Earth
	[13484]="15000:9:2:1:Alchemy::1:0:11557:3:0", -- Recipe: Transmute Earth to Water
	[13485]="15000:9:2:1:Alchemy::1:0:11278:3:0", -- Recipe: Transmute Water to Air
	[13486]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Transmute Undeath to Water
	[13487]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Transmute Water to Undeath
	[13488]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Transmute Life to Earth
	[13489]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Transmute Earth to Life
	[13490]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Greater Stoneshield Potion
	[13491]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Elixir of the Mongoose
	[13492]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Purification Potion
	[13493]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Greater Arcane Elixir
	[13494]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Greater Fire Protection Potion
	[13495]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Greater Frost Protection Potion
	[13496]="24000:9:2:1:Alchemy::1:1:15174:0:0", -- Recipe: Greater Nature Protection Potion
	[13497]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Greater Arcane Protection Potion
	[13498]="0:4:3:1:Plate::1:0::3:0", -- Handcrafted Mastersmith Leggings
	[13499]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Greater Shadow Protection Potion
	[13501]="30000:9:2:1:Alchemy::1:0:11278:3:0", -- Recipe: Major Mana Potion
	[13502]="0:4:3:1:Plate::1:0::3:0", -- Handcrafted Mastersmith Girdle
	[13503]="0:4:4:1:Trinket:171:1:0::3:0", -- Alchemist Stone
	[13505]="0:2:4:1:TwoHandSword::1:0::3:0", -- Runeblade of Baron Rivendare
	[13506]="0:0:1:20:Potion::1:0::0:0", -- Potion of Petrification
	[13507]="0:12:1:1:::1:0::4:0", -- Cliffwatcher Longhorn Report
	[13508]="0:0:2:1:Consumable::1:0::3:0", -- Eye of Arachnida
	[13509]="0:0:2:1:Consumable::1:0::3:0", -- Clutch of Foresight
	[13510]="0:0:1:20:Flask:164:1:0::0:0", -- Flask of the Titans
	[13511]="0:0:1:20:Flask::1:0::0:0", -- Flask of Distilled Wisdom
	[13512]="0:0:1:20:Flask:164:1:0::0:0", -- Flask of Supreme Power
	[13513]="0:0:1:20:Flask::1:0::0:0", -- Flask of Chromatic Resistance
	[13514]="0:0:2:1:Consumable::1:0::3:0", -- Wail of the Banshee
	[13515]="0:4:3:1:Trinket::1:0::3:0", -- Ramstein's Lightning Bolts
	[13517]="80000:9:1:1:Alchemy::1:0:21432:3:0", -- Recipe: Alchemist Stone
	[13518]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Potion of Petrification
	[13519]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Flask of the Titans
	[13520]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Flask of Distilled Wisdom
	[13521]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Flask of Supreme Power
	[13522]="0:9:2:1:Alchemy::1:0::0:0", -- Recipe: Flask of Chromatic Resistance
	[13524]="0:4:3:1:OffHandFrill::1:0::3:0", -- Skull of Burning Shadows
	[13525]="0:4:3:1:Cloth::1:0::3:0", -- Darkbind Fingers
	[13526]="0:4:3:1:Leather::1:0::3:0", -- Flamescarred Girdle
	[13527]="0:4:3:1:Plate::1:0::3:0", -- Lavawalker Greaves
	[13528]="0:4:3:1:Mail::1:0::3:0", -- Twilight Void Bracers
	[13529]="0:4:3:1:Shield::1:0::3:0", -- Husk of Nerub'enkan
	[13530]="0:4:2:1:Cloth::1:0::3:0", -- Fangdrip Runners
	[13531]="0:4:2:1:Leather::1:0::3:0", -- Crypt Stalker Leggings
	[13532]="0:4:2:1:Mail::1:0::3:0", -- Darkspinner Claws
	[13533]="0:4:2:1:Plate::1:0::3:0", -- Acid-Etched Pauldrons
	[13534]="0:2:3:1:Wand::1:0::3:0", -- Banshee Finger
	[13535]="0:4:3:1:Cloth::1:0::3:0", -- Coldtouch Phantom Wraps
	[13536]="0:12:1:1:::1:0::4:0", -- Horn of Awakening
	[13537]="0:4:3:1:Leather::1:0::3:0", -- Chillhide Bracers
	[13538]="0:4:3:1:Mail::1:0::3:0", -- Windshrieker Pauldrons
	[13539]="0:4:3:1:Plate::1:0::3:0", -- Banshee's Touch
	[13544]="0:4:2:1:Trinket::1:0::3:0", -- Spectral Essence
	[13545]="0:12:1:20:::1:0::4:0", -- Shellfish
	[13546]="0:0:1:20:FoodDrink::1:0::0:0", -- Bloodbelly Fish
	[13562]="0:0:1:1:Consumable::1:0::4:0", -- Remains of Trey Lightforge
	[13582]="0:15:3:1:Companion::1:0::3:1", -- Zergling Leash
	[13583]="0:15:3:1:Companion::1:0::3:1", -- Panda Collar
	[13584]="0:15:3:1:Companion::1:0::3:1", -- Diablo Stone
	[13585]="0:12:1:1:::1:0::4:0", -- Keepsake of Remembrance
	[13624]="0:12:1:1:::1:0::4:0", -- Soulbound Keepsake
	[13626]="0:12:1:1:::1:0::4:0", -- Human Head of Ras Frostwhisper
	[13702]="0:12:1:20:::1:0::4:0", -- Doom Weed
	[13703]="0:0:1:20:Consumable::1:0::4:0", -- Kodo Bone
	[13704]="0:13:1:1:::1:0::3:0", -- Skeleton Key
	[13724]="6000:0:1:20:FoodDrink::5:0:10856,10857,11536:0:0", -- Enriched Manna Biscuit
	[13725]="0:12:1:1:::1:0::4:0", -- Krastinov's Bag of Horrors
	[13752]="0:12:1:1:::1:0::4:0", -- Soulbound Keepsake
	[13754]="0:7:1:20:Meat:185:1:0::0:0", -- Raw Glossy Mightfish
	[13755]="0:0:1:20:FoodDrink:185:1:0::0:0", -- Winter Squid
	[13756]="0:7:1:20:Meat:185:1:0::0:0", -- Raw Summer Bass
	[13757]="0:7:1:20:Other:185:1:0::0:0", -- Lightning Eel
	[13758]="0:7:1:20:Meat:185:1:0::0:0", -- Raw Redgill
	[13759]="0:7:1:20:Meat:185:1:0::0:0", -- Raw Nightfin Snapper
	[13760]="0:7:1:20:Meat:185:1:0::0:0", -- Raw Sunscale Salmon
	[13761]="0:0:1:1:Consumable::1:0::4:0", -- Frozen Eggs
	[13810]="6000:0:1:20:FoodDrink::5:0:10856,10857,11536:3:0", -- Blessed Sunfruit
	[13813]="6000:0:1:20:Consumable::5:0:10856,10857,11536:3:0", -- Blessed Sunfruit Juice
	[13815]="0:12:1:1:::1:0::4:0", -- Some Rune
	[13816]="0:2:0:1:OneHandSword::1:0::0:0", -- Fine Longsword
	[13817]="0:2:0:1:TwoHandSword::1:0::0:0", -- Tapered Greatsword
	[13818]="0:2:0:1:OneHandAxe::1:0::0:0", -- Jagged Axe
	[13819]="0:2:0:1:TwoHandAxe::1:0::0:0", -- Balanced War Axe
	[13820]="0:2:0:1:OneHandMace::1:0::0:0", -- Clout Mace
	[13821]="0:2:0:1:TwoHandMace::1:0::0:0", -- Bulky Maul
	[13822]="0:2:0:1:Dagger::1:0::0:0", -- Spiked Dagger
	[13823]="0:2:0:1:Stave::1:0::0:0", -- Stout War Staff
	[13824]="0:2:0:1:Bow::1:0::0:0", -- Recurve Long Bow
	[13825]="0:2:0:1:Gun::1:0::0:0", -- Primed Musket
	[13850]="0:12:1:1:::1:0::4:0", -- Rumbleshot's Ammo
	[13851]="0:0:1:20:FoodDrink::1:0::0:0", -- Hot Wolf Ribs
	[13852]="0:12:1:1:::1:0::4:0", -- The Grand Crusader's Command
	[13853]="0:12:1:20:::1:0::4:0", -- Slab of Carrion Worm Meat
	[13856]="0:4:2:1:Cloth::1:0::2:0", -- Runecloth Belt
	[13857]="0:4:2:1:Cloth::1:0::2:0", -- Runecloth Tunic
	[13858]="0:4:2:1:Cloth::1:0::2:0", -- Runecloth Robe
	[13860]="0:4:2:1:Cloak::1:0::2:0", -- Runecloth Cloak
	[13863]="0:4:2:1:Cloth::1:0::2:0", -- Runecloth Gloves
	[13864]="0:4:2:1:Cloth::1:0::2:0", -- Runecloth Boots
	[13865]="0:4:2:1:Cloth::1:0::2:0", -- Runecloth Pants
	[13866]="0:4:2:1:Cloth::1:0::2:0", -- Runecloth Headband
	[13867]="0:4:2:1:Cloth::1:0::2:0", -- Runecloth Shoulders
	[13868]="0:4:2:1:Cloth::1:0::2:0", -- Frostweave Robe
	[13869]="0:4:2:1:Cloth::1:0::2:0", -- Frostweave Tunic
	[13870]="0:4:2:1:Cloth::1:0::2:0", -- Frostweave Gloves
	[13871]="0:4:2:1:Cloth::1:0::2:0", -- Frostweave Pants
	[13872]="0:12:1:20:::1:0::4:0", -- Bundle of Wood
	[13873]="0:13:1:1:::1:0::3:0", -- Viewing Room Key
	[13874]="0:15:1:1:Other::1:0::0:0", -- Heavy Crate
	[13875]="0:15:1:1:Junk::1:0::0:0", -- Ironbound Locked Chest
	[13876]="0:15:1:1:Junk::1:0::0:0", -- 40 Pound Grouper
	[13877]="0:15:1:1:Junk::1:0::0:0", -- 47 Pound Grouper
	[13878]="0:15:1:1:Junk::1:0::0:0", -- 53 Pound Grouper
	[13879]="0:15:1:1:Junk::1:0::0:0", -- 59 Pound Grouper
	[13880]="0:15:1:1:Junk::1:0::0:0", -- 68 Pound Grouper
	[13881]="0:15:1:1:Other::1:0::0:0", -- Bloated Redgill
	[13882]="0:4:1:1:OffHandFrill::1:0::0:0", -- 42 Pound Redgill
	[13883]="0:4:1:1:OffHandFrill::1:0::0:0", -- 45 Pound Redgill
	[13884]="0:4:1:1:OffHandFrill::1:0::0:0", -- 49 Pound Redgill
	[13885]="0:4:1:1:OffHandFrill::1:0::0:0", -- 34 Pound Redgill
	[13886]="0:4:1:1:OffHandFrill::1:0::0:0", -- 37 Pound Redgill
	[13887]="0:4:1:1:OffHandFrill::1:0::0:0", -- 52 Pound Redgill
	[13888]="0:7:1:20:Meat:185:1:0::0:0", -- Darkclaw Lobster
	[13889]="0:7:1:20:Meat:185:1:0::0:0", -- Raw Whitescale Salmon
	[13890]="0:15:0:20:Junk::1:0::0:0", -- Plated Armorfish
	[13891]="0:15:1:1:Other::1:0::0:0", -- Bloated Salmon
	[13892]="0:12:1:1:::1:0::4:0", -- Kodo Kombobulator
	[13893]="0:0:1:20:FoodDrink:185:1:0::0:0", -- Large Raw Mightfish
	[13895]="0:4:1:1:Miscellaneous::1:0::0:0", -- Formal Dangui
	[13896]="75000:4:1:1:Miscellaneous::1:0:1299,4184,5821:0:0", -- Dark Green Wedding Hanbok
	[13897]="15000:4:1:1:Miscellaneous::1:0:1299,4184,5821:0:0", -- White Traditional Hanbok
	[13898]="359000:4:1:1:Miscellaneous::1:0:1299,4184,5821:0:0", -- Royal Dangui
	[13899]="45000:4:1:1:Miscellaneous::1:1:4184:0:0", -- Red Traditional Hanbok
	[13900]="147000:4:1:1:Miscellaneous::1:1:4184:0:0", -- Green Wedding Hanbok
	[13901]="0:4:1:1:OffHandFrill::1:0::0:0", -- 15 Pound Salmon
	[13902]="0:4:1:1:OffHandFrill::1:0::0:0", -- 18 Pound Salmon
	[13903]="0:4:1:1:OffHandFrill::1:0::0:0", -- 22 Pound Salmon
	[13904]="0:4:1:1:OffHandFrill::1:0::0:0", -- 25 Pound Salmon
	[13905]="0:4:1:1:OffHandFrill::1:0::0:0", -- 29 Pound Salmon
	[13906]="0:4:1:1:OffHandFrill::1:0::0:0", -- 32 Pound Salmon
	[13907]="0:15:1:1:Junk::1:0::0:0", -- 7 Pound Lobster
	[13908]="0:15:1:1:Junk::1:0::0:0", -- 9 Pound Lobster
	[13909]="0:15:1:1:Junk::1:0::0:0", -- 12 Pound Lobster
	[13910]="0:15:1:1:Junk::1:0::0:0", -- 15 Pound Lobster
	[13911]="0:15:1:1:Junk::1:0::0:0", -- 19 Pound Lobster
	[13912]="0:15:1:1:Junk::1:0::0:0", -- 21 Pound Lobster
	[13913]="0:15:1:1:Junk::1:0::0:0", -- 22 Pound Lobster
	[13914]="0:4:1:1:OffHandFrill::1:0::0:0", -- 70 Pound Mightfish
	[13915]="0:4:1:1:OffHandFrill::1:0::0:0", -- 85 Pound Mightfish
	[13916]="0:4:1:1:OffHandFrill::1:0::0:0", -- 92 Pound Mightfish
	[13917]="0:4:1:1:OffHandFrill::1:0::0:0", -- 103 Pound Mightfish
	[13918]="0:15:1:1:Junk::1:0::0:0", -- Reinforced Locked Chest
	[13920]="0:12:1:1:::1:0::3:0", -- Healthy Dragon Scale
	[13926]="0:3:2:20:GemSimple:333,197:1:0::0:0", -- Golden Pearl
	[13927]="0:0:1:20:FoodDrink::1:0::0:0", -- Cooked Glossy Mightfish
	[13928]="0:0:1:20:FoodDrink::1:0::0:0", -- Grilled Squid
	[13929]="0:0:1:20:FoodDrink::1:0::0:0", -- Hot Smoked Bass
	[13930]="0:0:1:20:FoodDrink::1:0::0:0", -- Filet of Redgill
	[13931]="0:0:1:20:FoodDrink::1:0::0:0", -- Nightfin Soup
	[13932]="0:0:1:20:FoodDrink::1:0::0:0", -- Poached Sunscale Salmon
	[13933]="0:0:1:20:FoodDrink::1:0::0:0", -- Lobster Stew
	[13934]="0:0:1:20:FoodDrink::1:0::0:0", -- Mightfish Steak
	[13935]="0:0:1:20:FoodDrink::1:0::0:0", -- Baked Salmon
	[13937]="0:2:4:1:Stave::1:0::3:0", -- Headmaster's Charge
	[13938]="0:2:3:1:Wand::1:0::3:0", -- Bonecreeper Stylus
	[13940]="16000:9:1:1:Cooking::1:0:2664:0:0", -- Recipe: Cooked Glossy Mightfish
	[13941]="16000:9:1:1:Cooking::1:0:2664:0:0", -- Recipe: Filet of Redgill
	[13943]="16000:9:1:1:Cooking::1:0:2664:0:0", -- Recipe: Hot Smoked Bass
	[13944]="0:4:3:1:Leather::1:0::3:0", -- Tombstone Breastplate
	[13947]="20000:9:1:1:Cooking::1:0:7947,8145:0:0", -- Recipe: Lobster Stew
	[13948]="20000:9:1:1:Cooking::1:0:2664,7947,8145:0:0", -- Recipe: Mightfish Steak
	[13949]="20000:9:1:1:Cooking::1:0:7947,8145:0:0", -- Recipe: Baked Salmon
	[13950]="0:4:3:1:Mail::1:0::3:0", -- Detention Strap
	[13951]="0:4:3:1:Plate::1:0::3:0", -- Vigorsteel Vambraces
	[13952]="0:2:3:1:OneHandAxe::1:0::3:0", -- Iceblade Hacker
	[13953]="0:2:3:1:OneHandSword::1:0::3:0", -- Silent Fang
	[13954]="0:4:3:1:Leather::1:0::3:0", -- Verdant Footpads
	[13955]="0:4:3:1:Plate::1:0::3:0", -- Stoneform Shoulders
	[13956]="0:4:3:1:Cloth::1:0::3:0", -- Clutch of Andros
	[13957]="0:4:3:1:Leather::1:0::3:0", -- Gargoyle Slashers
	[13958]="0:4:3:1:Cloth::1:0::3:0", -- Wyrmthalak's Shackles
	[13959]="0:4:3:1:Plate::1:0::3:0", -- Omokk's Girth Restrainer
	[13960]="0:4:3:1:Amulet::1:0::3:0", -- Heart of the Fiend
	[13961]="0:4:3:1:Leather::1:0::3:0", -- Halycon's Muzzle
	[13962]="0:4:3:1:Leather::1:0::3:0", -- Vosh'gajin's Strand
	[13963]="0:4:3:1:Mail::1:0::3:0", -- Voone's Vice Grips
	[13964]="0:2:3:1:Dagger::1:0::3:0", -- Witchblade
	[13965]="0:4:3:1:Trinket::1:0::3:0", -- Blackhand's Breadth
	[13966]="0:4:3:1:Trinket::1:0::3:0", -- Mark of Tyranny
	[13967]="0:4:3:1:Mail::1:0::3:0", -- Windreaver Greaves
	[13968]="0:4:3:1:Trinket::1:0::3:0", -- Eye of the Beast
	[13969]="0:4:3:1:Mail::1:0::3:0", -- Loomguard Armbraces
	[13982]="0:2:3:1:TwoHandSword::1:0::3:0", -- Warblade of Caer Darrow
	[13983]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Gravestone War Axe
	[13984]="0:2:3:1:Dagger::1:0::3:0", -- Darrowspike
	[13986]="0:4:3:1:Cloth::1:0::3:0", -- Crown of Caer Darrow
	[14002]="0:4:3:1:Shield::1:0::3:0", -- Darrowshire Strongguard
	[14022]="0:4:3:1:Trinket::1:0::3:0", -- Barov Peasant Caller
	[14023]="0:4:3:1:Trinket::1:0::3:0", -- Barov Peasant Caller
	[14024]="0:2:3:1:Dagger::1:0::3:0", -- Frightalon
	[14025]="0:4:2:1:Cloth::1:0::2:0", -- Mystic's Belt
	[14042]="0:4:2:1:Cloth::1:0::2:0", -- Cindercloth Vest
	[14043]="0:4:2:1:Cloth::1:0::2:0", -- Cindercloth Gloves
	[14044]="0:4:2:1:Cloak:165:1:0::2:0", -- Cindercloth Cloak
	[14045]="0:4:2:1:Cloth::1:0::2:0", -- Cindercloth Pants
	[14046]="0:1:1:1:Bag::1:0::0:0", -- Runecloth Bag
	[14047]="0:7:1:20:Cloth:164,202,129,165,197:1:0::0:0", -- Runecloth
	[14048]="0:7:1:20:Cloth:165,197:1:0::0:0", -- Bolt of Runecloth
	[14086]="0:4:1:1:Cloth::1:0::0:0", -- Beaded Sandals
	[14087]="0:4:1:1:Cloth::1:0::0:0", -- Beaded Cuffs
	[14088]="0:4:1:1:Cloak::1:0::0:0", -- Beaded Cloak
	[14089]="0:4:1:1:Cloth::1:0::0:0", -- Beaded Gloves
	[14090]="0:4:2:1:Cloth::1:0::2:0", -- Beaded Britches
	[14091]="0:4:2:1:Cloth::1:0::2:0", -- Beaded Robe
	[14093]="0:4:1:1:Cloth::1:0::0:0", -- Beaded Cord
	[14094]="0:4:2:1:Cloth::1:0::2:0", -- Beaded Wraps
	[14095]="0:4:1:1:Cloth::1:0::0:0", -- Native Bands
	[14096]="0:4:2:1:Cloth::1:0::2:0", -- Native Vest
	[14097]="0:4:2:1:Cloth::1:0::2:0", -- Native Pants
	[14098]="0:4:1:1:Cloak::1:0::0:0", -- Native Cloak
	[14099]="0:4:1:1:Cloth::1:0::0:0", -- Native Sash
	[14100]="0:4:2:1:Cloth::1:0::2:0", -- Brightcloth Robe
	[14101]="0:4:2:1:Cloth::1:0::2:0", -- Brightcloth Gloves
	[14102]="0:4:1:1:Cloth::1:0::0:0", -- Native Handwraps
	[14103]="0:4:2:1:Cloak::1:0::2:0", -- Brightcloth Cloak
	[14104]="0:4:2:1:Cloth::1:0::2:0", -- Brightcloth Pants
	[14106]="0:4:2:1:Cloth::1:0::2:0", -- Felcloth Robe
	[14107]="0:4:2:1:Cloth::1:0::2:0", -- Felcloth Pants
	[14108]="0:4:2:1:Cloth::1:0::2:0", -- Felcloth Boots
	[14109]="0:4:2:1:Cloth::1:0::2:0", -- Native Robe
	[14110]="0:4:1:1:Cloth::1:0::0:0", -- Native Sandals
	[14111]="0:4:2:1:Cloth::1:0::2:0", -- Felcloth Hood
	[14112]="0:4:2:1:Cloth::1:0::2:0", -- Felcloth Shoulders
	[14113]="0:4:2:1:Cloth::1:0::2:0", -- Aboriginal Sash
	[14114]="0:4:2:1:Cloth::1:0::2:0", -- Aboriginal Footwraps
	[14115]="0:4:1:1:Cloth::1:0::0:0", -- Aboriginal Bands
	[14116]="0:4:1:1:Cloak::1:0::0:0", -- Aboriginal Cape
	[14117]="0:4:2:1:Cloth::1:0::2:0", -- Aboriginal Gloves
	[14119]="0:4:2:1:Cloth::1:0::2:0", -- Aboriginal Loincloth
	[14120]="0:4:2:1:Cloth::1:0::2:0", -- Aboriginal Robe
	[14121]="0:4:2:1:Cloth::1:0::2:0", -- Aboriginal Vest
	[14122]="0:4:2:1:Cloth::1:0::2:0", -- Ritual Bands
	[14123]="0:4:2:1:Cloak::1:0::2:0", -- Ritual Cape
	[14124]="0:4:2:1:Cloth::1:0::2:0", -- Ritual Gloves
	[14125]="0:4:2:1:Cloth::1:0::2:0", -- Ritual Leggings
	[14126]="0:4:1:1:Cloth::1:0::0:0", -- Ritual Amice
	[14127]="0:4:2:1:Cloth::1:0::2:0", -- Ritual Shroud
	[14128]="0:4:2:1:Cloth::1:0::2:0", -- Wizardweave Robe
	[14129]="0:4:2:1:Cloth::1:0::2:0", -- Ritual Sandals
	[14130]="0:4:2:1:Cloth::1:0::2:0", -- Wizardweave Turban
	[14131]="0:4:2:1:Cloth::1:0::2:0", -- Ritual Belt
	[14132]="0:4:2:1:Cloth::1:0::2:0", -- Wizardweave Leggings
	[14133]="0:4:2:1:Cloth::1:0::2:0", -- Ritual Tunic
	[14134]="0:4:3:1:Cloak::1:0::2:0", -- Cloak of Fire
	[14136]="0:4:3:1:Cloth::1:0::2:0", -- Robe of Winter Night
	[14137]="0:4:3:1:Cloth::1:0::2:0", -- Mooncloth Leggings
	[14138]="0:4:3:1:Cloth::1:0::2:0", -- Mooncloth Vest
	[14139]="0:4:3:1:Cloth::1:0::2:0", -- Mooncloth Shoulders
	[14140]="0:4:3:1:Cloth::1:0::2:0", -- Mooncloth Circlet
	[14141]="0:4:2:1:Cloth::1:0::2:0", -- Ghostweave Vest
	[14142]="0:4:2:1:Cloth::1:0::2:0", -- Ghostweave Gloves
	[14143]="0:4:2:1:Cloth::1:0::2:0", -- Ghostweave Belt
	[14144]="0:4:2:1:Cloth::1:0::2:0", -- Ghostweave Pants
	[14145]="0:2:3:1:OneHandSword::1:0::3:0", -- Cursed Felblade
	[14146]="0:4:4:1:Cloth::1:0::2:0", -- Gloves of Spell Mastery
	[14147]="0:4:3:1:Mail::1:0::3:0", -- Cavedweller Bracers
	[14148]="0:4:3:1:Cloth::1:0::3:0", -- Crystalline Cuffs
	[14149]="0:4:3:1:Cloak::1:0::3:0", -- Subterranean Cape
	[14150]="0:4:3:1:Cloth::1:0::3:0", -- Robe of Evocation
	[14151]="0:2:3:1:Dagger::1:0::3:0", -- Chanting Blade
	[14152]="0:4:4:1:Cloth::1:0::3:0", -- Robe of the Archmage
	[14153]="0:4:4:1:Cloth::1:0::3:0", -- Robe of the Void
	[14154]="0:4:4:1:Cloth::1:0::3:0", -- Truefaith Vestments
	[14155]="0:1:2:1:Bag::1:0::0:0", -- Mooncloth Bag
	[14156]="0:1:3:1:Bag::1:0::2:0", -- Bottomless Bag
	[14157]="0:4:1:1:Cloth::1:0::0:0", -- Pagan Mantle
	[14158]="0:4:2:1:Cloth::1:0::2:0", -- Pagan Vest
	[14159]="0:4:2:1:Cloth::1:0::2:0", -- Pagan Shoes
	[14160]="0:4:2:1:Cloth::1:0::2:0", -- Pagan Bands
	[14161]="0:4:2:1:Cloak::1:0::2:0", -- Pagan Cape
	[14162]="0:4:2:1:Cloth::1:0::2:0", -- Pagan Mitts
	[14163]="0:4:2:1:Cloth::1:0::2:0", -- Pagan Wraps
	[14164]="0:4:2:1:Cloth::1:0::2:0", -- Pagan Belt
	[14165]="0:4:2:1:Cloth::1:0::2:0", -- Pagan Britches
	[14166]="0:4:2:1:Cloth::1:0::2:0", -- Buccaneer's Bracers
	[14167]="0:4:2:1:Cloak::1:0::2:0", -- Buccaneer's Cape
	[14168]="0:4:2:1:Cloth::1:0::2:0", -- Buccaneer's Gloves
	[14169]="0:4:1:1:Cloth::1:0::0:0", -- Aboriginal Shoulder Pads
	[14170]="0:4:1:1:Cloth::1:0::0:0", -- Buccaneer's Mantle
	[14171]="0:4:2:1:Cloth::1:0::2:0", -- Buccaneer's Pants
	[14172]="0:4:2:1:Cloth::1:0::2:0", -- Buccaneer's Robes
	[14173]="0:4:2:1:Cloth::1:0::2:0", -- Buccaneer's Cord
	[14174]="0:4:2:1:Cloth::1:0::2:0", -- Buccaneer's Boots
	[14175]="0:4:2:1:Cloth::1:0::2:0", -- Buccaneer's Vest
	[14176]="0:4:2:1:Cloth::1:0::2:0", -- Watcher's Boots
	[14177]="0:4:2:1:Cloth::1:0::2:0", -- Watcher's Cuffs
	[14178]="0:4:2:1:Cloth::1:0::2:0", -- Watcher's Cap
	[14179]="0:4:2:1:Cloak::1:0::2:0", -- Watcher's Cape
	[14180]="0:4:2:1:Cloth::1:0::2:0", -- Watcher's Jerkin
	[14181]="0:4:2:1:Cloth::1:0::2:0", -- Watcher's Handwraps
	[14182]="0:4:2:1:Cloth::1:0::2:0", -- Watcher's Mantle
	[14183]="0:4:2:1:Cloth::1:0::2:0", -- Watcher's Leggings
	[14184]="0:4:2:1:Cloth::1:0::2:0", -- Watcher's Robes
	[14185]="0:4:2:1:Cloth::1:0::2:0", -- Watcher's Cinch
	[14186]="0:4:2:1:Cloth::1:0::2:0", -- Raincaller Mantle
	[14187]="0:4:2:1:Cloth::1:0::2:0", -- Raincaller Cuffs
	[14188]="0:4:2:1:Cloak::1:0::2:0", -- Raincaller Cloak
	[14189]="0:4:2:1:Cloth::1:0::2:0", -- Raincaller Cap
	[14190]="0:4:2:1:Cloth::1:0::2:0", -- Raincaller Vest
	[14191]="0:4:2:1:Cloth::1:0::2:0", -- Raincaller Mitts
	[14192]="0:4:2:1:Cloth::1:0::2:0", -- Raincaller Robes
	[14193]="0:4:2:1:Cloth::1:0::2:0", -- Raincaller Pants
	[14194]="0:4:2:1:Cloth::1:0::2:0", -- Raincaller Cord
	[14195]="0:4:2:1:Cloth::1:0::2:0", -- Raincaller Boots
	[14196]="0:4:2:1:Cloth::1:0::2:0", -- Thistlefur Sandals
	[14197]="0:4:2:1:Cloth::1:0::2:0", -- Thistlefur Bands
	[14198]="0:4:2:1:Cloak::1:0::2:0", -- Thistlefur Cloak
	[14199]="0:4:2:1:Cloth::1:0::2:0", -- Thistlefur Gloves
	[14200]="0:4:2:1:Cloth::1:0::2:0", -- Thistlefur Cap
	[14201]="0:4:2:1:Cloth::1:0::2:0", -- Thistlefur Mantle
	[14202]="0:4:2:1:Cloth::1:0::2:0", -- Thistlefur Jerkin
	[14203]="0:4:2:1:Cloth::1:0::2:0", -- Thistlefur Pants
	[14204]="0:4:2:1:Cloth::1:0::2:0", -- Thistlefur Robe
	[14205]="0:4:2:1:Cloth::1:0::2:0", -- Thistlefur Belt
	[14206]="0:4:2:1:Cloth::1:0::2:0", -- Vital Bracelets
	[14207]="0:4:2:1:Cloth::1:0::2:0", -- Vital Leggings
	[14208]="0:4:2:1:Cloth::1:0::2:0", -- Vital Headband
	[14209]="0:4:2:1:Cloth::1:0::2:0", -- Vital Sash
	[14210]="0:4:2:1:Cloak::1:0::2:0", -- Vital Cape
	[14211]="0:4:2:1:Cloth::1:0::2:0", -- Vital Handwraps
	[14212]="0:4:2:1:Cloth::1:0::2:0", -- Vital Shoulders
	[14213]="0:4:2:1:Cloth::1:0::2:0", -- Vital Raiment
	[14214]="0:4:2:1:Cloth::1:0::2:0", -- Vital Boots
	[14215]="0:4:2:1:Cloth::1:0::2:0", -- Vital Tunic
	[14216]="0:4:2:1:Cloth::1:0::2:0", -- Geomancer's Jerkin
	[14217]="0:4:2:1:Cloth::1:0::2:0", -- Geomancer's Cord
	[14218]="0:4:2:1:Cloth::1:0::2:0", -- Geomancer's Boots
	[14219]="0:4:2:1:Cloak::1:0::2:0", -- Geomancer's Cloak
	[14220]="0:4:2:1:Cloth::1:0::2:0", -- Geomancer's Cap
	[14221]="0:4:2:1:Cloth::1:0::2:0", -- Geomancer's Bracers
	[14222]="0:4:2:1:Cloth::1:0::2:0", -- Geomancer's Gloves
	[14223]="0:4:2:1:Cloth::1:0::2:0", -- Geomancer's Spaulders
	[14224]="0:4:2:1:Cloth::1:0::2:0", -- Geomancer's Trousers
	[14225]="0:4:2:1:Cloth::1:0::2:0", -- Geomancer's Wraps
	[14226]="0:4:2:1:Cloth::1:0::2:0", -- Embersilk Bracelets
	[14227]="0:7:1:10:Cloth:202,165,197:1:0::0:0", -- Ironweb Spider Silk
	[14228]="0:4:2:1:Cloth::1:0::2:0", -- Embersilk Coronet
	[14229]="0:4:2:1:Cloak::1:0::2:0", -- Embersilk Cloak
	[14230]="0:4:2:1:Cloth::1:0::2:0", -- Embersilk Tunic
	[14231]="0:4:2:1:Cloth::1:0::2:0", -- Embersilk Mitts
	[14232]="0:4:2:1:Cloth::1:0::2:0", -- Embersilk Mantle
	[14233]="0:4:2:1:Cloth::1:0::2:0", -- Embersilk Leggings
	[14234]="0:4:2:1:Cloth::1:0::2:0", -- Embersilk Robes
	[14235]="0:4:2:1:Cloth::1:0::2:0", -- Embersilk Cord
	[14236]="0:4:2:1:Cloth::1:0::2:0", -- Embersilk Boots
	[14237]="0:4:2:1:Cloth::1:0::2:0", -- Darkmist Armor
	[14238]="0:4:2:1:Cloth::1:0::2:0", -- Darkmist Boots
	[14239]="0:4:2:1:Cloak::1:0::2:0", -- Darkmist Cape
	[14240]="0:4:2:1:Cloth::1:0::2:0", -- Darkmist Bands
	[14241]="0:4:2:1:Cloth::1:0::2:0", -- Darkmist Handguards
	[14242]="0:4:2:1:Cloth::1:0::2:0", -- Darkmist Pants
	[14243]="0:4:2:1:Cloth::1:0::2:0", -- Darkmist Mantle
	[14244]="0:4:2:1:Cloth::1:0::2:0", -- Darkmist Wraps
	[14245]="0:4:2:1:Cloth::1:0::2:0", -- Darkmist Girdle
	[14246]="0:4:2:1:Cloth::1:0::2:0", -- Darkmist Wizard Hat
	[14247]="0:4:2:1:Cloth::1:0::2:0", -- Lunar Mantle
	[14248]="0:4:2:1:Cloth::1:0::2:0", -- Lunar Bindings
	[14249]="0:4:2:1:Cloth::1:0::2:0", -- Lunar Vest
	[14250]="0:4:2:1:Cloth::1:0::2:0", -- Lunar Slippers
	[14251]="0:4:2:1:Cloak::1:0::2:0", -- Lunar Cloak
	[14252]="0:4:2:1:Cloth::1:0::2:0", -- Lunar Coronet
	[14253]="0:4:2:1:Cloth::1:0::2:0", -- Lunar Handwraps
	[14254]="0:4:2:1:Cloth::1:0::2:0", -- Lunar Raiment
	[14255]="0:4:2:1:Cloth::1:0::2:0", -- Lunar Belt
	[14256]="8000:7:1:20:Cloth:165,197:1:1:16015:0:0", -- Felcloth
	[14257]="0:4:2:1:Cloth::1:0::2:0", -- Lunar Leggings
	[14258]="0:4:2:1:Cloth::1:0::2:0", -- Bloodwoven Cord
	[14259]="0:4:2:1:Cloth::1:0::2:0", -- Bloodwoven Boots
	[14260]="0:4:2:1:Cloth::1:0::2:0", -- Bloodwoven Bracers
	[14261]="0:4:2:1:Cloak::1:0::2:0", -- Bloodwoven Cloak
	[14262]="0:4:2:1:Cloth::1:0::2:0", -- Bloodwoven Mitts
	[14263]="0:4:2:1:Cloth::1:0::2:0", -- Bloodwoven Mask
	[14264]="0:4:2:1:Cloth::1:0::2:0", -- Bloodwoven Pants
	[14265]="0:4:2:1:Cloth::1:0::2:0", -- Bloodwoven Wraps
	[14266]="0:4:2:1:Cloth::1:0::2:0", -- Bloodwoven Pads
	[14267]="0:4:2:1:Cloth::1:0::2:0", -- Bloodwoven Jerkin
	[14268]="0:4:2:1:Cloth::1:0::2:0", -- Gaea's Cuffs
	[14269]="0:4:2:1:Cloth::1:0::2:0", -- Gaea's Slippers
	[14270]="0:4:2:1:Cloak::1:0::2:0", -- Gaea's Cloak
	[14271]="0:4:2:1:Cloth::1:0::2:0", -- Gaea's Circlet
	[14272]="0:4:2:1:Cloth::1:0::2:0", -- Gaea's Handwraps
	[14273]="0:4:2:1:Cloth::1:0::2:0", -- Gaea's Amice
	[14274]="0:4:2:1:Cloth::1:0::2:0", -- Gaea's Leggings
	[14275]="0:4:2:1:Cloth::1:0::2:0", -- Gaea's Raiment
	[14276]="0:4:2:1:Cloth::1:0::2:0", -- Gaea's Belt
	[14277]="0:4:2:1:Cloth::1:0::2:0", -- Gaea's Tunic
	[14278]="0:4:2:1:Cloth::1:0::2:0", -- Opulent Mantle
	[14279]="0:4:2:1:Cloth::1:0::2:0", -- Opulent Bracers
	[14280]="0:4:2:1:Cloak::1:0::2:0", -- Opulent Cape
	[14281]="0:4:2:1:Cloth::1:0::2:0", -- Opulent Crown
	[14282]="0:4:2:1:Cloth::1:0::2:0", -- Opulent Gloves
	[14283]="0:4:2:1:Cloth::1:0::2:0", -- Opulent Leggings
	[14284]="0:4:2:1:Cloth::1:0::2:0", -- Opulent Robes
	[14285]="0:4:2:1:Cloth::1:0::2:0", -- Opulent Boots
	[14286]="0:4:2:1:Cloth::1:0::2:0", -- Opulent Belt
	[14287]="0:4:2:1:Cloth::1:0::2:0", -- Opulent Tunic
	[14288]="0:4:2:1:Cloth::1:0::2:0", -- Arachnidian Armor
	[14289]="0:4:2:1:Cloth::1:0::2:0", -- Arachnidian Girdle
	[14290]="0:4:2:1:Cloth::1:0::2:0", -- Arachnidian Footpads
	[14291]="0:4:2:1:Cloth::1:0::2:0", -- Arachnidian Bracelets
	[14292]="0:4:2:1:Cloak::1:0::2:0", -- Arachnidian Cape
	[14293]="0:4:2:1:Cloth::1:0::2:0", -- Arachnidian Circlet
	[14294]="0:4:2:1:Cloth::1:0::2:0", -- Arachnidian Gloves
	[14295]="0:4:2:1:Cloth::1:0::2:0", -- Arachnidian Legguards
	[14296]="0:4:2:1:Cloth::1:0::2:0", -- Arachnidian Pauldrons
	[14297]="0:4:2:1:Cloth::1:0::2:0", -- Arachnidian Robes
	[14298]="0:4:2:1:Cloth::1:0::2:0", -- Bonecaster's Spaulders
	[14299]="0:4:2:1:Cloth::1:0::2:0", -- Bonecaster's Boots
	[14300]="0:4:2:1:Cloak::1:0::2:0", -- Bonecaster's Cape
	[14301]="0:4:2:1:Cloth::1:0::2:0", -- Bonecaster's Bindings
	[14302]="0:4:2:1:Cloth::1:0::2:0", -- Bonecaster's Gloves
	[14303]="0:4:2:1:Cloth::1:0::2:0", -- Bonecaster's Shroud
	[14304]="0:4:2:1:Cloth::1:0::2:0", -- Bonecaster's Belt
	[14305]="0:4:2:1:Cloth::1:0::2:0", -- Bonecaster's Sarong
	[14306]="0:4:2:1:Cloth::1:0::2:0", -- Bonecaster's Vest
	[14307]="0:4:2:1:Cloth::1:0::2:0", -- Bonecaster's Crown
	[14308]="0:4:2:1:Cloth::1:0::2:0", -- Celestial Tunic
	[14309]="0:4:2:1:Cloth::1:0::2:0", -- Celestial Belt
	[14310]="0:4:2:1:Cloth::1:0::2:0", -- Celestial Slippers
	[14311]="0:4:2:1:Cloth::1:0::2:0", -- Celestial Bindings
	[14312]="0:4:2:1:Cloth::1:0::2:0", -- Celestial Crown
	[14313]="0:4:2:1:Cloak::1:0::2:0", -- Celestial Cape
	[14314]="0:4:2:1:Cloth::1:0::2:0", -- Celestial Handwraps
	[14315]="0:4:2:1:Cloth::1:0::2:0", -- Celestial Kilt
	[14316]="0:4:2:1:Cloth::1:0::2:0", -- Celestial Pauldrons
	[14317]="0:4:2:1:Cloth::1:0::2:0", -- Celestial Silk Robes
	[14318]="0:4:2:1:Cloth::1:0::2:0", -- Resplendent Tunic
	[14319]="0:4:2:1:Cloth::1:0::2:0", -- Resplendent Boots
	[14320]="0:4:2:1:Cloth::1:0::2:0", -- Resplendent Bracelets
	[14321]="0:4:2:1:Cloak::1:0::2:0", -- Resplendent Cloak
	[14322]="0:4:2:1:Cloth::1:0::2:0", -- Resplendent Circlet
	[14323]="0:4:2:1:Cloth::1:0::2:0", -- Resplendent Gauntlets
	[14324]="0:4:2:1:Cloth::1:0::2:0", -- Resplendent Sarong
	[14325]="0:4:2:1:Cloth::1:0::2:0", -- Resplendent Epaulets
	[14326]="0:4:2:1:Cloth::1:0::2:0", -- Resplendent Robes
	[14327]="0:4:2:1:Cloth::1:0::2:0", -- Resplendent Belt
	[14328]="0:4:2:1:Cloth::1:0::2:0", -- Eternal Chestguard
	[14329]="0:4:2:1:Cloth::1:0::2:0", -- Eternal Boots
	[14330]="0:4:2:1:Cloth::1:0::2:0", -- Eternal Bindings
	[14331]="0:4:2:1:Cloak::1:0::2:0", -- Eternal Cloak
	[14332]="0:4:2:1:Cloth::1:0::2:0", -- Eternal Crown
	[14333]="0:4:2:1:Cloth::1:0::2:0", -- Eternal Gloves
	[14334]="0:4:2:1:Cloth::1:0::2:0", -- Eternal Sarong
	[14335]="0:4:2:1:Cloth::1:0::2:0", -- Eternal Spaulders
	[14336]="0:4:2:1:Cloth::1:0::2:0", -- Eternal Wraps
	[14337]="0:4:2:1:Cloth::1:0::2:0", -- Eternal Cord
	[14338]="0:12:1:1:::1:0::4:0", -- Empty Water Tube
	[14339]="0:12:1:1:::1:0::4:0", -- Moonwell Water Tube
	[14340]="0:4:3:1:Cloth::1:0::3:0", -- Freezing Lich Robes
	[14341]="5000:7:1:20:Cloth:165,197:1:0:989,1148,1286,1347,1454,1474,1672,2225,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3008,3091,3364,3366,3367,3485,3779,3954,3958,4168,4225,4229,4561,4577,4589,4775,4897,5128,5135,5154,5163,5565,5817,6567,6568,6574,7854,7940,7947,8145,8160,8363,8681,8934,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12958,15179,16366,16602,16613,16638,16689,16748,16767,16768,16826,17486,18009,18015,18277,18749,18754,18771,18772,18907,18960,19015,19017,19042,19194,19196,19197,19213,19244,19345,19372,19450,19497,19521,19532,19533,19562,19573,19722,20081,20092,20194,20250,20891,21083,21085,21113,22099,22271,23802,24054,24147,24188,24341,24356,24843,24935,25010,25034,25051,25082,26374,26474,26720,26939,26941,27012,27021,27026,27043,27057,27063,27070,27132,27146,27184,27195,27938,28692,28718,28726,28794,28798,28806,28810,28831,28872,29208,29270,29277,29288,30311,30345,30438,30825,31115,32477,32639,32641,32979,33596,33601,33635,33636,33669,33681,33684,34601,37904,37935,38873,40226,40474,40572,41053,41275,41490,41676,41891,43149,43380,43495,43550,43554,43568,43880,43980,44027,44186,44341,44383,44386,44780,45093,45552,45558,46184,47153,47164,47347,47856,48098,48551,48574,48587,48608,48857,48860,48868,49404,49409,49579,49595,49705,49714,49752,49765,49805,49888,50071,50094,50456,50457,53075,53436,53782:0:0", -- Rune Thread
	[14342]="0:7:1:20:Cloth:165,197:1:0::0:0", -- Mooncloth
	[14343]="0:7:3:20:Enchanting:333:1:0::0:0", -- Small Brilliant Shard
	[14344]="0:7:3:20:Enchanting:333,197:1:0::0:0", -- Large Brilliant Shard
	[14364]="0:4:2:1:Cloth::1:0::2:0", -- Mystic's Slippers
	[14365]="0:4:2:1:Cloak::1:0::2:0", -- Mystic's Cape
	[14366]="0:4:2:1:Cloth::1:0::2:0", -- Mystic's Bracelets
	[14367]="0:4:2:1:Cloth::1:0::2:0", -- Mystic's Gloves
	[14368]="0:4:1:1:Cloth::1:0::0:0", -- Mystic's Shoulder Pads
	[14369]="0:4:2:1:Cloth::1:0::2:0", -- Mystic's Wrap
	[14370]="0:4:2:1:Cloth::1:0::2:0", -- Mystic's Woolies
	[14371]="0:4:2:1:Cloth::1:0::2:0", -- Mystic's Robe
	[14372]="0:4:2:1:Cloth::1:0::2:0", -- Sanguine Armor
	[14373]="0:4:2:1:Cloth::1:0::2:0", -- Sanguine Belt
	[14374]="0:4:2:1:Cloth::1:0::2:0", -- Sanguine Sandals
	[14375]="0:4:2:1:Cloth::1:0::2:0", -- Sanguine Cuffs
	[14376]="0:4:2:1:Cloak::1:0::2:0", -- Sanguine Cape
	[14377]="0:4:2:1:Cloth::1:0::2:0", -- Sanguine Handwraps
	[14378]="0:4:2:1:Cloth::1:0::2:0", -- Sanguine Mantle
	[14379]="0:4:2:1:Cloth::1:0::2:0", -- Sanguine Trousers
	[14380]="0:4:2:1:Cloth::1:0::2:0", -- Sanguine Robe
	[14381]="0:12:1:1:::1:0::4:0", -- Grimtotem Satchel
	[14395]="0:12:1:1:::1:0::4:0", -- Spells of Shadow
	[14396]="0:12:1:1:::1:0::4:0", -- Incantations from the Nether
	[14397]="0:4:2:1:Cloth::1:0::2:0", -- Resilient Mantle
	[14398]="0:4:2:1:Cloth::1:0::2:0", -- Resilient Tunic
	[14399]="0:4:2:1:Cloth::1:0::2:0", -- Resilient Boots
	[14400]="0:4:2:1:Cloak::1:0::2:0", -- Resilient Cape
	[14401]="0:4:2:1:Cloth::1:0::2:0", -- Resilient Cap
	[14402]="0:4:2:1:Cloth::1:0::2:0", -- Resilient Bands
	[14403]="0:4:2:1:Cloth::1:0::2:0", -- Resilient Handgrips
	[14404]="0:4:2:1:Cloth::1:0::2:0", -- Resilient Leggings
	[14405]="0:4:2:1:Cloth::1:0::2:0", -- Resilient Robe
	[14406]="0:4:2:1:Cloth::1:0::2:0", -- Resilient Cord
	[14407]="0:4:2:1:Cloth::1:0::2:0", -- Stonecloth Vest
	[14408]="0:4:2:1:Cloth::1:0::2:0", -- Stonecloth Boots
	[14409]="0:4:2:1:Cloak::1:0::2:0", -- Stonecloth Cape
	[14410]="0:4:2:1:Cloth::1:0::2:0", -- Stonecloth Circlet
	[14411]="0:4:2:1:Cloth::1:0::2:0", -- Stonecloth Gloves
	[14412]="0:4:2:1:Cloth::1:0::2:0", -- Stonecloth Epaulets
	[14413]="0:4:2:1:Cloth::1:0::2:0", -- Stonecloth Robe
	[14414]="0:4:2:1:Cloth::1:0::2:0", -- Stonecloth Belt
	[14415]="0:4:2:1:Cloth::1:0::2:0", -- Stonecloth Britches
	[14416]="0:4:2:1:Cloth::1:0::2:0", -- Stonecloth Bindings
	[14417]="0:4:2:1:Cloth::1:0::2:0", -- Silksand Tunic
	[14418]="0:4:2:1:Cloth::1:0::2:0", -- Silksand Boots
	[14419]="0:4:2:1:Cloth::1:0::2:0", -- Silksand Bracers
	[14420]="0:4:2:1:Cloak::1:0::2:0", -- Silksand Cape
	[14421]="0:4:2:1:Cloth::1:0::2:0", -- Silksand Circlet
	[14422]="0:4:2:1:Cloth::1:0::2:0", -- Silksand Gloves
	[14423]="0:4:2:1:Cloth::1:0::2:0", -- Silksand Shoulder Pads
	[14424]="0:4:2:1:Cloth::1:0::2:0", -- Silksand Legwraps
	[14425]="0:4:2:1:Cloth::1:0::2:0", -- Silksand Wraps
	[14426]="0:4:2:1:Cloth::1:0::2:0", -- Silksand Girdle
	[14427]="0:4:2:1:Cloth::1:0::2:0", -- Windchaser Wraps
	[14428]="0:4:2:1:Cloth::1:0::2:0", -- Windchaser Footpads
	[14429]="0:4:2:1:Cloth::1:0::2:0", -- Windchaser Cuffs
	[14430]="0:4:2:1:Cloak::1:0::2:0", -- Windchaser Cloak
	[14431]="0:4:2:1:Cloth::1:0::2:0", -- Windchaser Handguards
	[14432]="0:4:2:1:Cloth::1:0::2:0", -- Windchaser Amice
	[14433]="0:4:2:1:Cloth::1:0::2:0", -- Windchaser Woolies
	[14434]="0:4:2:1:Cloth::1:0::2:0", -- Windchaser Robes
	[14435]="0:4:2:1:Cloth::1:0::2:0", -- Windchaser Cinch
	[14436]="0:4:2:1:Cloth::1:0::2:0", -- Windchaser Coronet
	[14437]="0:4:2:1:Cloth::1:0::2:0", -- Venomshroud Vest
	[14438]="0:4:2:1:Cloth::1:0::2:0", -- Venomshroud Boots
	[14439]="0:4:2:1:Cloth::1:0::2:0", -- Venomshroud Armguards
	[14440]="0:4:2:1:Cloak::1:0::2:0", -- Venomshroud Cape
	[14441]="0:4:2:1:Cloth::1:0::2:0", -- Venomshroud Mask
	[14442]="0:4:2:1:Cloth::1:0::2:0", -- Venomshroud Mitts
	[14443]="0:4:2:1:Cloth::1:0::2:0", -- Venomshroud Mantle
	[14444]="0:4:2:1:Cloth::1:0::2:0", -- Venomshroud Leggings
	[14445]="0:4:2:1:Cloth::1:0::2:0", -- Venomshroud Silk Robes
	[14446]="0:4:2:1:Cloth::1:0::2:0", -- Venomshroud Belt
	[14447]="0:4:2:1:Cloth::1:0::2:0", -- Highborne Footpads
	[14448]="0:4:2:1:Cloth::1:0::2:0", -- Highborne Bracelets
	[14449]="0:4:2:1:Cloth::1:0::2:0", -- Highborne Crown
	[14450]="0:4:2:1:Cloak::1:0::2:0", -- Highborne Cloak
	[14451]="0:4:2:1:Cloth::1:0::2:0", -- Highborne Gloves
	[14452]="0:4:2:1:Cloth::1:0::2:0", -- Highborne Pauldrons
	[14453]="0:4:2:1:Cloth::1:0::2:0", -- Highborne Robes
	[14454]="0:4:2:1:Cloth::1:0::2:0", -- Highborne Cord
	[14455]="0:4:2:1:Cloth::1:0::2:0", -- Highborne Padded Armor
	[14456]="0:4:2:1:Cloth::1:0::2:0", -- Elunarian Vest
	[14457]="0:4:2:1:Cloth::1:0::2:0", -- Elunarian Cuffs
	[14458]="0:4:2:1:Cloth::1:0::2:0", -- Elunarian Boots
	[14459]="0:4:2:1:Cloak::1:0::2:0", -- Elunarian Cloak
	[14460]="0:4:2:1:Cloth::1:0::2:0", -- Elunarian Diadem
	[14461]="0:4:2:1:Cloth::1:0::2:0", -- Elunarian Handgrips
	[14462]="0:4:2:1:Cloth::1:0::2:0", -- Elunarian Sarong
	[14463]="0:4:2:1:Cloth::1:0::2:0", -- Elunarian Spaulders
	[14464]="0:4:2:1:Cloth::1:0::2:0", -- Elunarian Silk Robes
	[14465]="0:4:2:1:Cloth::1:0::2:0", -- Elunarian Belt
	[14466]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Frostweave Tunic
	[14467]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Frostweave Robe
	[14468]="12000:9:1:1:Tailoring::1:1:11189:0:0", -- Pattern: Runecloth Bag
	[14469]="12000:9:1:1:Tailoring::1:1:7940:0:0", -- Pattern: Runecloth Robe
	[14470]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Runecloth Tunic
	[14471]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Cindercloth Vest
	[14472]="12000:9:1:1:Tailoring::1:1:7940:3:0", -- Pattern: Runecloth Cloak
	[14473]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Ghostweave Belt
	[14474]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Frostweave Gloves
	[14476]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Cindercloth Gloves
	[14477]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Ghostweave Gloves
	[14478]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Brightcloth Robe
	[14479]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Brightcloth Gloves
	[14480]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Ghostweave Vest
	[14481]="0:9:1:1:Tailoring::1:0::0:0", -- Pattern: Runecloth Gloves
	[14482]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Cindercloth Cloak
	[14483]="16000:9:1:1:Tailoring::1:1:12022:0:0", -- Pattern: Felcloth Pants
	[14484]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Brightcloth Cloak
	[14485]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Wizardweave Leggings
	[14486]="0:9:3:1:Tailoring::1:0::3:0", -- Pattern: Cloak of Fire
	[14487]="0:2:3:1:OneHandMace::1:0::3:0", -- Bonechill Hammer
	[14488]="0:9:1:1:Tailoring::1:0::0:0", -- Pattern: Runecloth Boots
	[14489]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Frostweave Pants
	[14490]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Cindercloth Pants
	[14491]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Runecloth Pants
	[14492]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Felcloth Boots
	[14493]="0:9:3:1:Tailoring::1:0::3:0", -- Pattern: Robe of Winter Night
	[14494]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Brightcloth Pants
	[14495]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Ghostweave Pants
	[14496]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Felcloth Hood
	[14497]="0:9:3:1:Tailoring::1:0::0:0", -- Pattern: Mooncloth Leggings
	[14498]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Runecloth Headband
	[14499]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Mooncloth Bag
	[14500]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Wizardweave Robe
	[14501]="0:9:3:1:Tailoring::1:0::0:0", -- Pattern: Mooncloth Vest
	[14502]="0:4:3:1:Leather::1:0::3:0", -- Frostbite Girdle
	[14503]="0:4:3:1:Leather::1:0::3:0", -- Death's Clutch
	[14504]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Runecloth Shoulders
	[14505]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Wizardweave Turban
	[14506]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Felcloth Robe
	[14507]="0:9:3:1:Tailoring::1:0::0:0", -- Pattern: Mooncloth Shoulders
	[14508]="0:9:2:1:Tailoring::1:0::0:0", -- Pattern: Felcloth Shoulders
	[14509]="0:9:3:1:Tailoring::1:0::0:0", -- Pattern: Mooncloth Circlet
	[14510]="0:9:3:1:Tailoring::1:0::0:0", -- Pattern: Bottomless Bag
	[14511]="0:9:4:1:Tailoring::1:0::0:0", -- Pattern: Gloves of Spell Mastery
	[14512]="0:9:4:1:Tailoring::1:0::0:0", -- Pattern: Truefaith Vestments
	[14513]="0:9:4:1:Tailoring::1:0::0:0", -- Pattern: Robe of the Archmage
	[14514]="0:9:4:1:Tailoring::1:0::0:0", -- Pattern: Robe of the Void
	[14522]="0:4:3:1:Mail::1:0::3:0", -- Maelstrom Leggings
	[14523]="0:12:1:1:::1:0::4:0", -- Demon Pick
	[14525]="0:4:3:1:Plate::1:0::3:0", -- Boneclenched Gauntlets
	[14526]="20000:9:1:1:Tailoring::1:0:11189:0:0", -- Pattern: Mooncloth
	[14528]="0:4:3:1:Shield::1:0::3:0", -- Rattlecage Buckler
	[14529]="0:0:1:20:Bandage::1:0::0:0", -- Runecloth Bandage
	[14530]="4000:0:1:20:Bandage::1:1:15471:0:0", -- Heavy Runecloth Bandage
	[14531]="0:2:3:1:TwoHandMace::1:0::3:0", -- Frightskull Shaft
	[14536]="0:4:3:1:Mail::1:0::2:0", -- Bonebrace Hauberk
	[14537]="0:4:3:1:Plate::1:0::3:0", -- Corpselight Greaves
	[14538]="0:4:3:1:Cloth::1:0::3:0", -- Deadwalker Mantle
	[14539]="0:4:3:1:Leather::1:0::3:0", -- Bone Ring Helm
	[14540]="0:12:1:1:::1:0::4:0", -- Taragaman the Hungerer's Heart
	[14541]="0:2:3:1:TwoHandSword::1:0::3:0", -- Barovian Family Sword
	[14542]="0:0:1:1:Consumable::1:0::4:0", -- Kravel's Crate
	[14543]="0:4:3:1:Cloth::1:0::3:0", -- Darkshade Gloves
	[14544]="0:12:1:1:::1:0::4:0", -- Lieutenant's Insignia
	[14545]="0:4:3:1:Leather::1:0::3:0", -- Ghostloom Leggings
	[14546]="0:12:1:1:::1:0::4:0", -- Roon's Kodo Horn
	[14547]="0:12:1:1:::1:0::4:0", -- Hand of Iruxos
	[14548]="0:4:3:1:Mail::1:0::3:0", -- Royal Cap Spaulders
	[14549]="0:4:4:1:Plate::1:0::2:0", -- Boots of Avoidance
	[14551]="0:4:4:1:Mail::1:0::2:0", -- Edgemaster's Handguards
	[14552]="0:4:4:1:Plate::1:0::2:0", -- Stockade Pauldrons
	[14553]="0:4:4:1:Leather::1:0::2:0", -- Sash of Mercy
	[14554]="0:4:4:1:Plate::1:0::2:0", -- Cloudkeeper Legplates
	[14555]="0:2:4:1:Dagger::1:0::2:0", -- Alcor's Sunrazor
	[14557]="0:4:4:1:Trinket::1:0::2:0", -- The Lion Horn of Stormwind
	[14558]="0:4:4:1:Amulet::1:0::2:0", -- Lady Maye's Pendant
	[14559]="0:4:2:1:Leather::1:0::2:0", -- Prospector's Sash
	[14560]="0:4:2:1:Leather::1:0::2:0", -- Prospector's Boots
	[14561]="0:4:2:1:Leather::1:0::2:0", -- Prospector's Cuffs
	[14562]="0:4:2:1:Leather::1:0::2:0", -- Prospector's Chestpiece
	[14563]="0:4:2:1:Cloak::1:0::2:0", -- Prospector's Cloak
	[14564]="0:4:2:1:Leather::1:0::2:0", -- Prospector's Mitts
	[14565]="0:4:2:1:Leather::1:0::2:0", -- Prospector's Woolies
	[14566]="0:4:2:1:Leather::1:0::2:0", -- Prospector's Pads
	[14567]="0:4:2:1:Leather::1:0::2:0", -- Bristlebark Belt
	[14568]="0:4:2:1:Leather::1:0::2:0", -- Bristlebark Boots
	[14569]="0:4:2:1:Leather::1:0::2:0", -- Bristlebark Bindings
	[14570]="0:4:2:1:Leather::1:0::2:0", -- Bristlebark Blouse
	[14571]="0:4:2:1:Cloak::1:0::2:0", -- Bristlebark Cape
	[14572]="0:4:2:1:Leather::1:0::2:0", -- Bristlebark Gloves
	[14573]="0:4:2:1:Leather::1:0::2:0", -- Bristlebark Amice
	[14574]="0:4:2:1:Leather::1:0::2:0", -- Bristlebark Britches
	[14576]="0:2:3:1:OneHandSword::1:0::3:0", -- Ebon Hilt of Marduk
	[14577]="0:4:3:1:Cloth::1:0::3:0", -- Skullsmoke Pants
	[14578]="0:4:2:1:Leather::1:0::2:0", -- Dokebi Cord
	[14579]="0:4:2:1:Leather::1:0::2:0", -- Dokebi Boots
	[14580]="0:4:2:1:Leather::1:0::2:0", -- Dokebi Bracers
	[14581]="0:4:2:1:Leather::1:0::2:0", -- Dokebi Chestguard
	[14582]="0:4:2:1:Cloak::1:0::2:0", -- Dokebi Cape
	[14583]="0:4:2:1:Leather::1:0::2:0", -- Dokebi Gloves
	[14584]="0:4:2:1:Leather::1:0::2:0", -- Dokebi Hat
	[14585]="0:4:2:1:Leather::1:0::2:0", -- Dokebi Leggings
	[14587]="0:4:2:1:Leather::1:0::2:0", -- Dokebi Mantle
	[14588]="0:4:2:1:Leather::1:0::2:0", -- Hawkeye's Cord
	[14589]="0:4:2:1:Leather::1:0::2:0", -- Hawkeye's Shoes
	[14590]="0:4:2:1:Leather::1:0::2:0", -- Hawkeye's Bracers
	[14591]="0:4:2:1:Leather::1:0::2:0", -- Hawkeye's Helm
	[14592]="0:4:2:1:Leather::1:0::2:0", -- Hawkeye's Tunic
	[14593]="0:4:2:1:Cloak::1:0::2:0", -- Hawkeye's Cloak
	[14594]="0:4:2:1:Leather::1:0::2:0", -- Hawkeye's Gloves
	[14595]="0:4:2:1:Leather::1:0::2:0", -- Hawkeye's Breeches
	[14596]="0:4:2:1:Leather::1:0::2:0", -- Hawkeye's Epaulets
	[14598]="0:4:2:1:Leather::1:0::2:0", -- Warden's Waistband
	[14599]="0:4:2:1:Leather::1:0::2:0", -- Warden's Footpads
	[14600]="0:4:2:1:Leather::1:0::2:0", -- Warden's Wristbands
	[14601]="0:4:2:1:Leather::1:0::2:0", -- Warden's Wraps
	[14602]="0:4:2:1:Cloak::1:0::2:0", -- Warden's Cloak
	[14603]="0:4:2:1:Leather::1:0::2:0", -- Warden's Mantle
	[14604]="0:4:2:1:Leather::1:0::2:0", -- Warden's Wizard Hat
	[14605]="0:4:2:1:Leather::1:0::2:0", -- Warden's Woolies
	[14606]="0:4:2:1:Leather::1:0::2:0", -- Warden's Gloves
	[14607]="0:4:2:1:Shield::1:0::2:0", -- Hawkeye's Buckler
	[14608]="0:4:2:1:Shield::1:0::2:0", -- Dokebi Buckler
	[14610]="0:12:1:1:::1:0::4:0", -- Araj's Scarab
	[14611]="0:4:3:1:Mail::1:0::3:0", -- Bloodmail Hauberk
	[14612]="0:4:3:1:Mail::1:0::3:0", -- Bloodmail Legguards
	[14613]="0:12:1:1:::1:0::4:0", -- Taelan's Hammer
	[14614]="0:4:3:1:Mail::1:0::3:0", -- Bloodmail Belt
	[14615]="0:4:3:1:Mail::1:0::3:0", -- Bloodmail Gauntlets
	[14616]="0:4:3:1:Mail::1:0::3:0", -- Bloodmail Boots
	[14617]="0:4:1:1:Shirt::1:0::3:0", -- Sawbones Shirt
	[14619]="0:12:1:20:::1:0::4:0", -- Skeletal Fragments
	[14620]="0:4:3:1:Plate::1:0::3:0", -- Deathbone Girdle
	[14621]="0:4:3:1:Plate::1:0::3:0", -- Deathbone Sabatons
	[14622]="0:4:3:1:Plate::1:0::3:0", -- Deathbone Gauntlets
	[14623]="0:4:3:1:Plate::1:0::3:0", -- Deathbone Legguards
	[14624]="0:4:3:1:Plate::1:0::3:0", -- Deathbone Chestplate
	[14625]="0:12:1:1:::1:0::4:0", -- Symbol of Lost Honor
	[14626]="0:4:3:1:Cloth::1:0::3:0", -- Necropile Robe
	[14627]="800:9:1:1:Tailoring::1:1:2668:0:0", -- Pattern: Bright Yellow Shirt
	[14628]="0:12:1:1:::1:0::4:0", -- Imbued Skeletal Fragments
	[14629]="0:4:3:1:Cloth::1:0::3:0", -- Necropile Cuffs
	[14630]="1000:9:1:1:Tailoring::1:1:2670:0:0", -- Pattern: Enchanter's Cowl
	[14631]="0:4:3:1:Cloth::1:0::3:0", -- Necropile Boots
	[14632]="0:4:3:1:Cloth::1:0::3:0", -- Necropile Leggings
	[14633]="0:4:3:1:Cloth::1:0::3:0", -- Necropile Mantle
	[14634]="2500:9:2:1:Alchemy::1:1:2480:0:0", -- Recipe: Frost Oil
	[14635]="3000:9:1:1:Leatherworking::1:1:2699:0:0", -- Pattern: Gem-Studded Leather Belt
	[14636]="0:4:3:1:Leather::1:0::3:0", -- Cadaverous Belt
	[14637]="0:4:3:1:Leather::1:0::3:0", -- Cadaverous Armor
	[14638]="0:4:3:1:Leather::1:0::3:0", -- Cadaverous Leggings
	[14639]="1500:9:1:1:Engineering::1:1:3495,41435:0:0", -- Schematic: Minor Recombobulator
	[14640]="0:4:3:1:Leather::1:0::3:0", -- Cadaverous Gloves
	[14641]="0:4:3:1:Leather::1:0::3:0", -- Cadaverous Walkers
	[14644]="0:12:1:1:::1:0::4:0", -- Skeleton Key Mold
	[14645]="0:12:1:1:::1:0::4:0", -- Unfinished Skeleton Key
	[14646]="0:12:1:1:::1:0::3:0", -- Goldshire Gift Voucher
	[14647]="0:12:1:1:::1:0::3:0", -- Kharanos Gift Voucher
	[14648]="0:12:1:1:::1:0::3:0", -- Dolanaar Gift Voucher
	[14649]="0:12:1:1:::1:0::3:0", -- Razor Hill Gift Voucher
	[14650]="0:12:1:1:::1:0::3:0", -- Bloodhoof Village Gift Voucher
	[14651]="0:12:1:1:::1:0::3:0", -- Brill Gift Voucher
	[14652]="0:4:2:1:Leather::1:0::2:0", -- Scorpashi Sash
	[14653]="0:4:2:1:Leather::1:0::2:0", -- Scorpashi Slippers
	[14654]="0:4:2:1:Leather::1:0::2:0", -- Scorpashi Wristbands
	[14655]="0:4:2:1:Leather::1:0::2:0", -- Scorpashi Breastplate
	[14656]="0:4:2:1:Cloak::1:0::2:0", -- Scorpashi Cape
	[14657]="0:4:2:1:Leather::1:0::2:0", -- Scorpashi Gloves
	[14658]="0:4:2:1:Leather::1:0::2:0", -- Scorpashi Skullcap
	[14659]="0:4:2:1:Leather::1:0::2:0", -- Scorpashi Leggings
	[14660]="0:4:2:1:Leather::1:0::2:0", -- Scorpashi Shoulder Pads
	[14661]="0:4:2:1:Leather::1:0::2:0", -- Keeper's Cord
	[14662]="0:4:2:1:Leather::1:0::2:0", -- Keeper's Hooves
	[14663]="0:4:2:1:Leather::1:0::2:0", -- Keeper's Bindings
	[14664]="0:4:2:1:Leather::1:0::2:0", -- Keeper's Armor
	[14665]="0:4:2:1:Cloak::1:0::2:0", -- Keeper's Cloak
	[14666]="0:4:2:1:Leather::1:0::2:0", -- Keeper's Gloves
	[14667]="0:4:2:1:Leather::1:0::2:0", -- Keeper's Wreath
	[14668]="0:4:2:1:Leather::1:0::2:0", -- Keeper's Woolies
	[14669]="0:4:2:1:Leather::1:0::2:0", -- Keeper's Mantle
	[14670]="0:4:2:1:Leather::1:0::2:0", -- Pridelord Armor
	[14671]="0:4:2:1:Leather::1:0::2:0", -- Pridelord Boots
	[14672]="0:4:2:1:Leather::1:0::2:0", -- Pridelord Bands
	[14673]="0:4:2:1:Cloak::1:0::2:0", -- Pridelord Cape
	[14674]="0:4:2:1:Leather::1:0::2:0", -- Pridelord Girdle
	[14675]="0:4:2:1:Leather::1:0::2:0", -- Pridelord Gloves
	[14676]="0:4:2:1:Leather::1:0::2:0", -- Pridelord Halo
	[14677]="0:4:2:1:Leather::1:0::2:0", -- Pridelord Pants
	[14678]="0:4:2:1:Leather::1:0::2:0", -- Pridelord Pauldrons
	[14679]="0:12:1:1:::1:0::4:0", -- Of Love and Family
	[14680]="0:4:2:1:Leather::1:0::2:0", -- Indomitable Vest
	[14681]="0:4:2:1:Leather::1:0::2:0", -- Indomitable Boots
	[14682]="0:4:2:1:Leather::1:0::2:0", -- Indomitable Armguards
	[14683]="0:4:2:1:Cloak::1:0::2:0", -- Indomitable Cloak
	[14684]="0:4:2:1:Leather::1:0::2:0", -- Indomitable Belt
	[14685]="0:4:2:1:Leather::1:0::2:0", -- Indomitable Gauntlets
	[14686]="0:4:2:1:Leather::1:0::2:0", -- Indomitable Headdress
	[14687]="0:4:2:1:Leather::1:0::2:0", -- Indomitable Leggings
	[14688]="0:4:2:1:Leather::1:0::2:0", -- Indomitable Epaulets
	[14722]="0:4:2:1:Mail::1:0::2:0", -- War Paint Anklewraps
	[14723]="0:4:2:1:Mail::1:0::2:0", -- War Paint Bindings
	[14724]="0:4:2:1:Cloak::1:0::2:0", -- War Paint Cloak
	[14725]="0:4:2:1:Mail::1:0::2:0", -- War Paint Waistband
	[14726]="0:4:2:1:Mail::1:0::2:0", -- War Paint Gloves
	[14727]="0:4:2:1:Mail::1:0::2:0", -- War Paint Legguards
	[14728]="0:4:1:1:Mail::1:0::0:0", -- War Paint Shoulder Pads
	[14729]="0:4:2:1:Shield::1:0::2:0", -- War Paint Shield
	[14730]="0:4:2:1:Mail::1:0::2:0", -- War Paint Chestpiece
	[14742]="0:4:2:1:Mail::1:0::2:0", -- Hulking Boots
	[14743]="0:4:2:1:Mail::1:0::2:0", -- Hulking Bands
	[14744]="0:4:2:1:Mail::1:0::2:0", -- Hulking Chestguard
	[14745]="0:4:2:1:Cloak::1:0::2:0", -- Hulking Cloak
	[14746]="0:4:2:1:Mail::1:0::2:0", -- Hulking Belt
	[14747]="0:4:2:1:Mail::1:0::2:0", -- Hulking Gauntlets
	[14748]="0:4:2:1:Mail::1:0::2:0", -- Hulking Leggings
	[14749]="0:4:2:1:Mail::1:0::2:0", -- Hulking Spaulders
	[14750]="0:4:2:1:Mail::1:0::2:0", -- Slayer's Cuffs
	[14751]="0:4:2:1:Mail::1:0::2:0", -- Slayer's Surcoat
	[14752]="0:4:2:1:Cloak::1:0::2:0", -- Slayer's Cape
	[14753]="0:4:2:1:Mail::1:0::2:0", -- Slayer's Skullcap
	[14754]="0:4:2:1:Mail::1:0::2:0", -- Slayer's Gloves
	[14755]="0:4:2:1:Mail::1:0::2:0", -- Slayer's Sash
	[14756]="0:4:2:1:Mail::1:0::2:0", -- Slayer's Slippers
	[14757]="0:4:2:1:Mail::1:0::2:0", -- Slayer's Pants
	[14758]="0:4:2:1:Mail::1:0::2:0", -- Slayer's Shoulderguards
	[14759]="0:4:2:1:Mail::1:0::2:0", -- Enduring Bracers
	[14760]="0:4:2:1:Mail::1:0::2:0", -- Enduring Breastplate
	[14761]="0:4:2:1:Mail::1:0::2:0", -- Enduring Belt
	[14762]="0:4:2:1:Mail::1:0::2:0", -- Enduring Boots
	[14763]="0:4:2:1:Cloak::1:0::2:0", -- Enduring Cape
	[14764]="0:4:2:1:Mail::1:0::2:0", -- Enduring Gauntlets
	[14765]="0:4:2:1:Mail::1:0::2:0", -- Enduring Circlet
	[14766]="0:4:2:1:Mail::1:0::2:0", -- Enduring Breeches
	[14767]="0:4:2:1:Mail::1:0::2:0", -- Enduring Pauldrons
	[14768]="0:4:2:1:Mail::1:0::2:0", -- Ravager's Armor
	[14769]="0:4:2:1:Mail::1:0::2:0", -- Ravager's Sandals
	[14770]="0:4:2:1:Mail::1:0::2:0", -- Ravager's Armguards
	[14771]="0:4:2:1:Cloak::1:0::2:0", -- Ravager's Cloak
	[14772]="0:4:2:1:Mail::1:0::2:0", -- Ravager's Handwraps
	[14773]="0:4:2:1:Mail::1:0::2:0", -- Ravager's Cord
	[14774]="0:4:2:1:Mail::1:0::2:0", -- Ravager's Crown
	[14775]="0:4:2:1:Mail::1:0::2:0", -- Ravager's Woolies
	[14776]="0:4:2:1:Mail::1:0::2:0", -- Ravager's Mantle
	[14777]="0:4:2:1:Shield::1:0::2:0", -- Ravager's Shield
	[14778]="0:4:2:1:Mail::1:0::2:0", -- Khan's Bindings
	[14779]="0:4:2:1:Mail::1:0::2:0", -- Khan's Chestpiece
	[14780]="0:4:2:1:Shield::1:0::2:0", -- Khan's Buckler
	[14781]="0:4:2:1:Cloak::1:0::2:0", -- Khan's Cloak
	[14782]="0:4:2:1:Mail::1:0::2:0", -- Khan's Gloves
	[14783]="0:4:2:1:Mail::1:0::2:0", -- Khan's Belt
	[14784]="0:4:2:1:Mail::1:0::2:0", -- Khan's Greaves
	[14785]="0:4:2:1:Mail::1:0::2:0", -- Khan's Helmet
	[14786]="0:4:2:1:Mail::1:0::2:0", -- Khan's Legguards
	[14787]="0:4:2:1:Mail::1:0::2:0", -- Khan's Mantle
	[14788]="0:4:2:1:Mail::1:0::2:0", -- Protector Armguards
	[14789]="0:4:2:1:Mail::1:0::2:0", -- Protector Breastplate
	[14790]="0:4:2:1:Shield::1:0::2:0", -- Protector Buckler
	[14791]="0:4:2:1:Cloak::1:0::2:0", -- Protector Cape
	[14792]="0:4:2:1:Mail::1:0::2:0", -- Protector Gauntlets
	[14793]="0:4:2:1:Mail::1:0::2:0", -- Protector Waistband
	[14794]="0:4:2:1:Mail::1:0::2:0", -- Protector Ankleguards
	[14795]="0:4:2:1:Mail::1:0::2:0", -- Protector Helm
	[14796]="0:4:2:1:Mail::1:0::2:0", -- Protector Legguards
	[14797]="0:4:2:1:Mail::1:0::2:0", -- Protector Pads
	[14798]="0:4:2:1:Mail::1:0::2:0", -- Bloodlust Breastplate
	[14799]="0:4:2:1:Mail::1:0::2:0", -- Bloodlust Boots
	[14800]="0:4:2:1:Shield::1:0::2:0", -- Bloodlust Buckler
	[14801]="0:4:2:1:Cloak::1:0::2:0", -- Bloodlust Cape
	[14802]="0:4:2:1:Mail::1:0::2:0", -- Bloodlust Gauntlets
	[14803]="0:4:2:1:Mail::1:0::2:0", -- Bloodlust Belt
	[14804]="0:4:2:1:Mail::1:0::2:0", -- Bloodlust Helm
	[14805]="0:4:2:1:Mail::1:0::2:0", -- Bloodlust Britches
	[14806]="0:4:2:1:Mail::1:0::2:0", -- Bloodlust Epaulets
	[14807]="0:4:2:1:Mail::1:0::2:0", -- Bloodlust Bracelets
	[14808]="0:4:2:1:Mail::1:0::2:0", -- Warstrike Belt
	[14809]="0:4:2:1:Mail::1:0::2:0", -- Warstrike Sabatons
	[14810]="0:4:2:1:Mail::1:0::2:0", -- Warstrike Armsplints
	[14811]="0:4:2:1:Mail::1:0::2:0", -- Warstrike Chestguard
	[14812]="0:4:2:1:Shield::1:0::2:0", -- Warstrike Buckler
	[14813]="0:4:2:1:Cloak::1:0::2:0", -- Warstrike Cape
	[14814]="0:4:2:1:Mail::1:0::2:0", -- Warstrike Helmet
	[14815]="0:4:2:1:Mail::1:0::2:0", -- Warstrike Gauntlets
	[14816]="0:4:2:1:Mail::1:0::2:0", -- Warstrike Legguards
	[14817]="0:4:2:1:Mail::1:0::2:0", -- Warstrike Shoulder Pads
	[14821]="0:4:2:1:Plate::1:0::2:0", -- Symbolic Breastplate
	[14825]="0:4:2:1:Shield::1:0::2:0", -- Symbolic Crest
	[14826]="0:4:2:1:Plate::1:0::2:0", -- Symbolic Gauntlets
	[14827]="0:4:2:1:Plate::1:0::2:0", -- Symbolic Belt
	[14828]="0:4:2:1:Plate::1:0::2:0", -- Symbolic Greaves
	[14829]="0:4:2:1:Plate::1:0::2:0", -- Symbolic Legplates
	[14830]="0:4:2:1:Plate::1:0::2:0", -- Symbolic Pauldrons
	[14831]="0:4:2:1:Plate::1:0::2:0", -- Symbolic Crown
	[14832]="0:4:2:1:Plate::1:0::2:0", -- Symbolic Vambraces
	[14833]="0:4:2:1:Plate::1:0::2:0", -- Tyrant's Gauntlets
	[14834]="0:4:2:1:Plate::1:0::2:0", -- Tyrant's Armguards
	[14835]="0:4:2:1:Plate::1:0::2:0", -- Tyrant's Chestpiece
	[14838]="0:4:2:1:Plate::1:0::2:0", -- Tyrant's Belt
	[14839]="0:4:2:1:Plate::1:0::2:0", -- Tyrant's Greaves
	[14840]="0:4:2:1:Plate::1:0::2:0", -- Tyrant's Legplates
	[14841]="0:4:2:1:Plate::1:0::2:0", -- Tyrant's Epaulets
	[14842]="0:4:2:1:Shield::1:0::2:0", -- Tyrant's Shield
	[14843]="0:4:2:1:Plate::1:0::2:0", -- Tyrant's Helm
	[14844]="0:4:2:1:Plate::1:0::2:0", -- Sunscale Chestguard
	[14846]="0:4:2:1:Plate::1:0::2:0", -- Sunscale Gauntlets
	[14847]="0:4:2:1:Plate::1:0::2:0", -- Sunscale Belt
	[14848]="0:4:2:1:Plate::1:0::2:0", -- Sunscale Sabatons
	[14849]="0:4:2:1:Plate::1:0::2:0", -- Sunscale Helmet
	[14850]="0:4:2:1:Plate::1:0::2:0", -- Sunscale Legplates
	[14851]="0:4:2:1:Plate::1:0::2:0", -- Sunscale Spaulders
	[14852]="0:4:2:1:Shield::1:0::2:0", -- Sunscale Shield
	[14853]="0:4:2:1:Plate::1:0::2:0", -- Sunscale Wristguards
	[14854]="0:4:2:1:Plate::1:0::2:0", -- Vanguard Breastplate
	[14855]="0:4:2:1:Plate::1:0::2:0", -- Vanguard Gauntlets
	[14856]="0:4:2:1:Plate::1:0::2:0", -- Vanguard Girdle
	[14857]="0:4:2:1:Plate::1:0::2:0", -- Vanguard Sabatons
	[14858]="0:4:2:1:Plate::1:0::2:0", -- Vanguard Headdress
	[14859]="0:4:2:1:Plate::1:0::2:0", -- Vanguard Legplates
	[14860]="0:4:2:1:Plate::1:0::2:0", -- Vanguard Pauldrons
	[14861]="0:4:2:1:Plate::1:0::2:0", -- Vanguard Vambraces
	[14862]="0:4:2:1:Plate::1:0::2:0", -- Warleader's Breastplate
	[14863]="0:4:2:1:Plate::1:0::2:0", -- Warleader's Gauntlets
	[14864]="0:4:2:1:Plate::1:0::2:0", -- Warleader's Belt
	[14865]="0:4:2:1:Plate::1:0::2:0", -- Warleader's Greaves
	[14866]="0:4:2:1:Plate::1:0::2:0", -- Warleader's Crown
	[14867]="0:4:2:1:Plate::1:0::2:0", -- Warleader's Leggings
	[14868]="0:4:2:1:Plate::1:0::2:0", -- Warleader's Shoulders
	[14869]="0:4:2:1:Plate::1:0::2:0", -- Warleader's Bracers
	[14872]="0:12:1:1:::1:0::4:0", -- Tirion's Gift
	[14894]="0:0:1:1:Consumable::1:0::3:0", -- Lily Root
	[14895]="0:4:2:1:Plate::1:0::2:0", -- Saltstone Surcoat
	[14896]="0:4:2:1:Plate::1:0::2:0", -- Saltstone Sabatons
	[14897]="0:4:2:1:Plate::1:0::2:0", -- Saltstone Gauntlets
	[14898]="0:4:2:1:Plate::1:0::2:0", -- Saltstone Girdle
	[14899]="0:4:2:1:Plate::1:0::2:0", -- Saltstone Helm
	[14900]="0:4:2:1:Plate::1:0::2:0", -- Saltstone Legplates
	[14901]="0:4:2:1:Plate::1:0::2:0", -- Saltstone Shoulder Pads
	[14902]="0:4:2:1:Shield::1:0::2:0", -- Saltstone Shield
	[14903]="0:4:2:1:Plate::1:0::2:0", -- Saltstone Armsplints
	[14904]="0:4:2:1:Plate::1:0::2:0", -- Brutish Breastplate
	[14905]="0:4:2:1:Plate::1:0::2:0", -- Brutish Gauntlets
	[14906]="0:4:2:1:Plate::1:0::2:0", -- Brutish Belt
	[14907]="0:4:2:1:Plate::1:0::2:0", -- Brutish Helmet
	[14908]="0:4:2:1:Plate::1:0::2:0", -- Brutish Legguards
	[14909]="0:4:2:1:Plate::1:0::2:0", -- Brutish Shoulders
	[14910]="0:4:2:1:Plate::1:0::2:0", -- Brutish Armguards
	[14911]="0:4:2:1:Plate::1:0::2:0", -- Brutish Boots
	[14912]="0:4:2:1:Shield::1:0::2:0", -- Brutish Shield
	[14913]="0:4:2:1:Plate::1:0::2:0", -- Jade Greaves
	[14914]="0:4:2:1:Plate::1:0::2:0", -- Jade Bracers
	[14915]="0:4:2:1:Plate::1:0::2:0", -- Jade Breastplate
	[14916]="0:4:2:1:Shield::1:0::2:0", -- Jade Deflector
	[14917]="0:4:2:1:Plate::1:0::2:0", -- Jade Gauntlets
	[14918]="0:4:2:1:Plate::1:0::2:0", -- Jade Belt
	[14919]="0:4:2:1:Plate::1:0::2:0", -- Jade Circlet
	[14920]="0:4:2:1:Plate::1:0::2:0", -- Jade Legplates
	[14921]="0:4:2:1:Plate::1:0::2:0", -- Jade Epaulets
	[14922]="0:4:2:1:Plate::1:0::2:0", -- Lofty Sabatons
	[14923]="0:4:2:1:Plate::1:0::2:0", -- Lofty Armguards
	[14924]="0:4:2:1:Plate::1:0::2:0", -- Lofty Breastplate
	[14925]="0:4:2:1:Plate::1:0::2:0", -- Lofty Helm
	[14926]="0:4:2:1:Plate::1:0::2:0", -- Lofty Gauntlets
	[14927]="0:4:2:1:Plate::1:0::2:0", -- Lofty Belt
	[14928]="0:4:2:1:Plate::1:0::2:0", -- Lofty Legguards
	[14929]="0:4:2:1:Plate::1:0::2:0", -- Lofty Shoulder Pads
	[14930]="0:4:2:1:Shield::1:0::2:0", -- Lofty Shield
	[14931]="0:4:2:1:Plate::1:0::2:0", -- Heroic Armor
	[14932]="0:4:2:1:Plate::1:0::2:0", -- Heroic Greaves
	[14933]="0:4:2:1:Plate::1:0::2:0", -- Heroic Gauntlets
	[14934]="0:4:2:1:Plate::1:0::2:0", -- Heroic Girdle
	[14935]="0:4:2:1:Plate::1:0::2:0", -- Heroic Skullcap
	[14936]="0:4:2:1:Plate::1:0::2:0", -- Heroic Legplates
	[14937]="0:4:2:1:Plate::1:0::2:0", -- Heroic Pauldrons
	[14938]="0:4:2:1:Plate::1:0::2:0", -- Heroic Bracers
	[14939]="0:4:2:1:Plate::1:0::2:0", -- Warbringer's Chestguard
	[14940]="0:4:2:1:Plate::1:0::2:0", -- Warbringer's Sabatons
	[14941]="0:4:2:1:Plate::1:0::2:0", -- Warbringer's Armsplints
	[14942]="0:4:2:1:Plate::1:0::2:0", -- Warbringer's Gauntlets
	[14943]="0:4:2:1:Plate::1:0::2:0", -- Warbringer's Belt
	[14944]="0:4:2:1:Plate::1:0::2:0", -- Warbringer's Crown
	[14945]="0:4:2:1:Plate::1:0::2:0", -- Warbringer's Legguards
	[14946]="0:4:2:1:Plate::1:0::2:0", -- Warbringer's Spaulders
	[14947]="0:4:2:1:Shield::1:0::2:0", -- Warbringer's Shield
	[14948]="0:4:2:1:Plate::1:0::2:0", -- Bloodforged Chestpiece
	[14949]="0:4:2:1:Plate::1:0::2:0", -- Bloodforged Gauntlets
	[14950]="0:4:2:1:Plate::1:0::2:0", -- Bloodforged Belt
	[14951]="0:4:2:1:Plate::1:0::2:0", -- Bloodforged Sabatons
	[14952]="0:4:2:1:Plate::1:0::2:0", -- Bloodforged Helmet
	[14953]="0:4:2:1:Plate::1:0::2:0", -- Bloodforged Legplates
	[14954]="0:4:2:1:Shield::1:0::2:0", -- Bloodforged Shield
	[14955]="0:4:2:1:Plate::1:0::2:0", -- Bloodforged Shoulder Pads
	[14956]="0:4:2:1:Plate::1:0::2:0", -- Bloodforged Bindings
	[14957]="0:4:2:1:Plate::1:0::2:0", -- High Chief's Sabatons
	[14958]="0:4:2:1:Plate::1:0::2:0", -- High Chief's Armor
	[14959]="0:4:2:1:Plate::1:0::2:0", -- High Chief's Gauntlets
	[14960]="0:4:2:1:Plate::1:0::2:0", -- High Chief's Belt
	[14961]="0:4:2:1:Plate::1:0::2:0", -- High Chief's Crown
	[14962]="0:4:2:1:Plate::1:0::2:0", -- High Chief's Legguards
	[14963]="0:4:2:1:Plate::1:0::2:0", -- High Chief's Pauldrons
	[14964]="0:4:2:1:Shield::1:0::2:0", -- High Chief's Shield
	[14965]="0:4:2:1:Plate::1:0::2:0", -- High Chief's Bindings
	[14966]="0:4:2:1:Plate::1:0::2:0", -- Glorious Breastplate
	[14967]="0:4:2:1:Plate::1:0::2:0", -- Glorious Gauntlets
	[14968]="0:4:2:1:Plate::1:0::2:0", -- Glorious Belt
	[14969]="0:4:2:1:Plate::1:0::2:0", -- Glorious Headdress
	[14970]="0:4:2:1:Plate::1:0::2:0", -- Glorious Legplates
	[14971]="0:4:2:1:Plate::1:0::2:0", -- Glorious Shoulder Pads
	[14972]="0:4:2:1:Plate::1:0::2:0", -- Glorious Sabatons
	[14973]="0:4:2:1:Shield::1:0::2:0", -- Glorious Shield
	[14974]="0:4:2:1:Plate::1:0::2:0", -- Glorious Bindings
	[14975]="0:4:2:1:Plate::1:0::2:0", -- Exalted Harness
	[14976]="0:4:2:1:Plate::1:0::2:0", -- Exalted Gauntlets
	[14977]="0:4:2:1:Plate::1:0::2:0", -- Exalted Girdle
	[14978]="0:4:2:1:Plate::1:0::2:0", -- Exalted Sabatons
	[14979]="0:4:2:1:Plate::1:0::2:0", -- Exalted Helmet
	[14980]="0:4:2:1:Plate::1:0::2:0", -- Exalted Legplates
	[14981]="0:4:2:1:Plate::1:0::2:0", -- Exalted Epaulets
	[14982]="0:4:2:1:Shield::1:0::2:0", -- Exalted Shield
	[14983]="0:4:2:1:Plate::1:0::2:0", -- Exalted Armsplints
	[15002]="0:12:1:1:::1:0::4:0", -- Nimboya's Pike
	[15003]="0:4:1:1:Leather::1:0::0:0", -- Primal Belt
	[15004]="0:4:1:1:Leather::1:0::0:0", -- Primal Boots
	[15005]="0:4:1:1:Leather::1:0::0:0", -- Primal Bands
	[15006]="0:4:1:1:Shield::1:0::0:0", -- Primal Buckler
	[15007]="0:4:1:1:Cloak::1:0::0:0", -- Primal Cape
	[15008]="0:4:1:1:Leather::1:0::0:0", -- Primal Mitts
	[15009]="0:4:2:1:Leather::1:0::2:0", -- Primal Leggings
	[15010]="0:4:2:1:Leather::1:0::2:0", -- Primal Wraps
	[15011]="0:4:2:1:Leather::1:0::2:0", -- Lupine Cord
	[15012]="0:4:2:1:Leather::1:0::2:0", -- Lupine Slippers
	[15013]="0:4:1:1:Leather::1:0::0:0", -- Lupine Cuffs
	[15014]="0:4:2:1:Shield::1:0::2:0", -- Lupine Buckler
	[15015]="0:4:1:1:Cloak::1:0::0:0", -- Lupine Cloak
	[15016]="0:4:2:1:Leather::1:0::2:0", -- Lupine Handwraps
	[15017]="0:4:2:1:Leather::1:0::2:0", -- Lupine Leggings
	[15018]="0:4:2:1:Leather::1:0::2:0", -- Lupine Vest
	[15019]="0:4:1:1:Leather::1:0::0:0", -- Lupine Mantle
	[15042]="0:12:1:1:::1:0::4:0", -- Empty Termite Jar
	[15043]="0:12:1:100:::1:0::4:0", -- Plagueland Termites
	[15044]="0:12:1:1:::1:0::4:0", -- Barrel of Plagueland Termites
	[15045]="0:4:3:1:Mail::1:0::2:0", -- Green Dragonscale Breastplate
	[15046]="0:4:3:1:Mail::1:0::2:0", -- Green Dragonscale Leggings
	[15047]="0:4:3:1:Mail::1:0::2:0", -- Red Dragonscale Breastplate
	[15048]="0:4:3:1:Mail::1:0::2:0", -- Blue Dragonscale Breastplate
	[15049]="0:4:3:1:Mail::1:0::2:0", -- Blue Dragonscale Shoulders
	[15050]="0:4:3:1:Mail::1:0::2:0", -- Black Dragonscale Breastplate
	[15051]="0:4:3:1:Mail::1:0::2:0", -- Black Dragonscale Shoulders
	[15052]="0:4:3:1:Mail::1:0::2:0", -- Black Dragonscale Leggings
	[15053]="0:4:2:1:Leather::1:0::2:0", -- Volcanic Breastplate
	[15054]="0:4:2:1:Leather::1:0::2:0", -- Volcanic Leggings
	[15055]="0:4:2:1:Leather::1:0::2:0", -- Volcanic Shoulders
	[15056]="0:4:3:1:Leather::1:0::2:0", -- Stormshroud Armor
	[15057]="0:4:3:1:Leather::1:0::2:0", -- Stormshroud Pants
	[15058]="0:4:3:1:Leather::1:0::2:0", -- Stormshroud Shoulders
	[15059]="0:4:3:1:Leather::1:0::2:0", -- Living Breastplate
	[15060]="0:4:3:1:Leather::1:0::2:0", -- Living Leggings
	[15061]="0:4:3:1:Leather::1:0::2:0", -- Living Shoulders
	[15062]="0:4:3:1:Leather::1:0::2:0", -- Devilsaur Leggings
	[15063]="0:4:3:1:Leather::1:0::2:0", -- Devilsaur Gauntlets
	[15064]="0:4:3:1:Leather::1:0::2:0", -- Warbear Harness
	[15065]="0:4:3:1:Leather::1:0::2:0", -- Warbear Woolies
	[15066]="0:4:3:1:Leather::1:0::2:0", -- Ironfeather Breastplate
	[15067]="0:4:3:1:Leather::1:0::2:0", -- Ironfeather Shoulders
	[15068]="0:4:2:1:Leather::1:0::2:0", -- Frostsaber Tunic
	[15069]="0:4:2:1:Leather::1:0::2:0", -- Frostsaber Leggings
	[15070]="0:4:2:1:Leather::1:0::2:0", -- Frostsaber Gloves
	[15071]="0:4:2:1:Leather::1:0::2:0", -- Frostsaber Boots
	[15072]="0:4:2:1:Leather::1:0::2:0", -- Chimeric Leggings
	[15073]="0:4:2:1:Leather::1:0::2:0", -- Chimeric Boots
	[15074]="0:4:2:1:Leather::1:0::2:0", -- Chimeric Gloves
	[15075]="0:4:2:1:Leather::1:0::2:0", -- Chimeric Vest
	[15076]="0:4:2:1:Mail::1:0::2:0", -- Heavy Scorpid Vest
	[15077]="0:4:2:1:Mail::1:0::2:0", -- Heavy Scorpid Bracers
	[15078]="0:4:2:1:Mail::1:0::2:0", -- Heavy Scorpid Gauntlets
	[15079]="0:4:2:1:Mail::1:0::2:0", -- Heavy Scorpid Leggings
	[15080]="0:4:2:1:Mail::1:0::2:0", -- Heavy Scorpid Helm
	[15081]="0:4:2:1:Mail::1:0::2:0", -- Heavy Scorpid Shoulders
	[15082]="0:4:2:1:Mail::1:0::2:0", -- Heavy Scorpid Belt
	[15083]="0:4:2:1:Leather::1:0::2:0", -- Wicked Leather Gauntlets
	[15084]="0:4:2:1:Leather::1:0::2:0", -- Wicked Leather Bracers
	[15085]="0:4:2:1:Leather::1:0::2:0", -- Wicked Leather Armor
	[15086]="0:4:2:1:Leather::1:0::2:0", -- Wicked Leather Headband
	[15087]="0:4:2:1:Leather::1:0::2:0", -- Wicked Leather Pants
	[15088]="0:4:2:1:Leather::1:0::2:0", -- Wicked Leather Belt
	[15090]="0:4:2:1:Leather::1:0::2:0", -- Runic Leather Armor
	[15091]="0:4:2:1:Leather::1:0::2:0", -- Runic Leather Gauntlets
	[15092]="0:4:2:1:Leather::1:0::2:0", -- Runic Leather Bracers
	[15093]="0:4:2:1:Leather::1:0::2:0", -- Runic Leather Belt
	[15094]="0:4:2:1:Leather::1:0::2:0", -- Runic Leather Headband
	[15095]="0:4:2:1:Leather::1:0::2:0", -- Runic Leather Pants
	[15096]="0:4:2:1:Leather::1:0::2:0", -- Runic Leather Shoulders
	[15102]="0:12:1:1:::1:0::4:0", -- Un'Goro Tested Sample
	[15103]="0:12:1:1:::1:0::4:0", -- Corrupt Tested Sample
	[15104]="0:4:3:1:Cloth::1:0::3:0", -- Wingborne Boots
	[15105]="0:2:2:1:Stave::1:0::3:0", -- Staff of Noh'Orahil
	[15106]="0:2:2:1:Stave::1:0::3:0", -- Staff of Dar'Orahil
	[15107]="0:4:3:1:OffHandFrill::1:0::3:0", -- Orb of Noh'Orahil
	[15108]="0:4:3:1:OffHandFrill::1:0::3:0", -- Orb of Dar'Orahil
	[15109]="0:2:2:1:Stave::1:0::3:0", -- Staff of Soran'ruk
	[15110]="0:4:2:1:Leather::1:0::2:0", -- Rigid Belt
	[15111]="0:4:2:1:Leather::1:0::2:0", -- Rigid Moccasins
	[15112]="0:4:2:1:Leather::1:0::2:0", -- Rigid Bracelets
	[15113]="0:4:2:1:Shield::1:0::2:0", -- Rigid Buckler
	[15114]="0:4:2:1:Cloak::1:0::2:0", -- Rigid Cape
	[15115]="0:4:2:1:Leather::1:0::2:0", -- Rigid Gloves
	[15116]="0:4:2:1:Leather::1:0::2:0", -- Rigid Shoulders
	[15117]="0:4:2:1:Leather::1:0::2:0", -- Rigid Leggings
	[15118]="0:4:2:1:Leather::1:0::2:0", -- Rigid Tunic
	[15119]="0:4:2:1:Cloth::1:0::2:0", -- Highborne Pants
	[15120]="0:4:2:1:Leather::1:0::2:0", -- Robust Girdle
	[15121]="0:4:2:1:Leather::1:0::2:0", -- Robust Boots
	[15122]="0:4:2:1:Leather::1:0::2:0", -- Robust Bracers
	[15123]="0:4:2:1:Shield::1:0::2:0", -- Robust Buckler
	[15124]="0:4:2:1:Cloak::1:0::2:0", -- Robust Cloak
	[15125]="0:4:2:1:Leather::1:0::2:0", -- Robust Gloves
	[15126]="0:4:2:1:Leather::1:0::2:0", -- Robust Leggings
	[15127]="0:4:2:1:Leather::1:0::2:0", -- Robust Shoulders
	[15128]="0:4:2:1:Leather::1:0::2:0", -- Robust Tunic
	[15129]="0:4:2:1:Leather::1:0::2:0", -- Robust Helm
	[15130]="0:4:2:1:Leather::1:0::2:0", -- Cutthroat's Vest
	[15131]="0:4:2:1:Leather::1:0::2:0", -- Cutthroat's Boots
	[15132]="0:4:2:1:Leather::1:0::2:0", -- Cutthroat's Armguards
	[15133]="0:4:2:1:Shield::1:0::2:0", -- Cutthroat's Buckler
	[15134]="0:4:2:1:Leather::1:0::2:0", -- Cutthroat's Hat
	[15135]="0:4:2:1:Cloak::1:0::2:0", -- Cutthroat's Cape
	[15136]="0:4:2:1:Leather::1:0::2:0", -- Cutthroat's Belt
	[15137]="0:4:2:1:Leather::1:0::2:0", -- Cutthroat's Mitts
	[15138]="0:4:3:1:Cloak::1:0::2:0", -- Onyxia Scale Cloak
	[15139]="0:4:2:1:Leather::1:0::2:0", -- Cutthroat's Pants
	[15140]="0:4:2:1:Leather::1:0::2:0", -- Cutthroat's Mantle
	[15141]="0:4:4:1:Mail::1:0::2:0", -- Onyxia Scale Breastplate
	[15142]="0:4:2:1:Leather::1:0::2:0", -- Ghostwalker Boots
	[15143]="0:4:2:1:Leather::1:0::2:0", -- Ghostwalker Bindings
	[15144]="0:4:2:1:Leather::1:0::2:0", -- Ghostwalker Rags
	[15145]="0:4:2:1:Shield::1:0::2:0", -- Ghostwalker Buckler
	[15146]="0:4:2:1:Leather::1:0::2:0", -- Ghostwalker Crown
	[15147]="0:4:2:1:Cloak::1:0::2:0", -- Ghostwalker Cloak
	[15148]="0:4:2:1:Leather::1:0::2:0", -- Ghostwalker Belt
	[15149]="0:4:2:1:Leather::1:0::2:0", -- Ghostwalker Gloves
	[15150]="0:4:2:1:Leather::1:0::2:0", -- Ghostwalker Pads
	[15151]="0:4:2:1:Leather::1:0::2:0", -- Ghostwalker Legguards
	[15152]="0:4:2:1:Leather::1:0::2:0", -- Nocturnal Shoes
	[15153]="0:4:2:1:Cloak::1:0::2:0", -- Nocturnal Cloak
	[15154]="0:4:2:1:Leather::1:0::2:0", -- Nocturnal Sash
	[15155]="0:4:2:1:Leather::1:0::2:0", -- Nocturnal Gloves
	[15156]="0:4:2:1:Leather::1:0::2:0", -- Nocturnal Cap
	[15157]="0:4:2:1:Leather::1:0::2:0", -- Nocturnal Leggings
	[15158]="0:4:2:1:Leather::1:0::2:0", -- Nocturnal Shoulder Pads
	[15159]="0:4:2:1:Leather::1:0::2:0", -- Nocturnal Tunic
	[15160]="0:4:2:1:Leather::1:0::2:0", -- Nocturnal Wristbands
	[15161]="0:4:2:1:Leather::1:0::2:0", -- Imposing Belt
	[15162]="0:4:2:1:Leather::1:0::2:0", -- Imposing Boots
	[15163]="0:4:2:1:Leather::1:0::2:0", -- Imposing Bracers
	[15164]="0:4:2:1:Leather::1:0::2:0", -- Imposing Vest
	[15165]="0:4:2:1:Cloak::1:0::2:0", -- Imposing Cape
	[15166]="0:4:2:1:Leather::1:0::2:0", -- Imposing Gloves
	[15167]="0:4:2:1:Leather::1:0::2:0", -- Imposing Bandana
	[15168]="0:4:2:1:Leather::1:0::2:0", -- Imposing Pants
	[15169]="0:4:2:1:Leather::1:0::2:0", -- Imposing Shoulders
	[15170]="0:4:2:1:Leather::1:0::2:0", -- Potent Armor
	[15171]="0:4:2:1:Leather::1:0::2:0", -- Potent Boots
	[15172]="0:4:2:1:Leather::1:0::2:0", -- Potent Bands
	[15173]="0:4:2:1:Cloak::1:0::2:0", -- Potent Cape
	[15174]="0:4:2:1:Leather::1:0::2:0", -- Potent Gloves
	[15175]="0:4:2:1:Leather::1:0::2:0", -- Potent Helmet
	[15176]="0:4:2:1:Leather::1:0::2:0", -- Potent Pants
	[15177]="0:4:2:1:Leather::1:0::2:0", -- Potent Shoulders
	[15178]="0:4:2:1:Leather::1:0::2:0", -- Potent Belt
	[15179]="0:4:2:1:Leather::1:0::2:0", -- Praetorian Padded Armor
	[15180]="0:4:2:1:Leather::1:0::2:0", -- Praetorian Girdle
	[15181]="0:4:2:1:Leather::1:0::2:0", -- Praetorian Boots
	[15182]="0:4:2:1:Leather::1:0::2:0", -- Praetorian Wristbands
	[15183]="0:4:2:1:Cloak::1:0::2:0", -- Praetorian Cloak
	[15184]="0:4:2:1:Leather::1:0::2:0", -- Praetorian Gloves
	[15185]="0:4:2:1:Leather::1:0::2:0", -- Praetorian Coif
	[15186]="0:4:2:1:Leather::1:0::2:0", -- Praetorian Leggings
	[15187]="0:4:2:1:Leather::1:0::2:0", -- Praetorian Pauldrons
	[15188]="0:4:2:1:Leather::1:0::2:0", -- Grand Armguards
	[15189]="0:4:2:1:Leather::1:0::2:0", -- Grand Boots
	[15190]="0:4:2:1:Cloak::1:0::2:0", -- Grand Cloak
	[15191]="0:4:2:1:Leather::1:0::2:0", -- Grand Belt
	[15192]="0:4:2:1:Leather::1:0::2:0", -- Grand Gauntlets
	[15193]="0:4:2:1:Leather::1:0::2:0", -- Grand Crown
	[15194]="0:4:2:1:Leather::1:0::2:0", -- Grand Legguards
	[15195]="0:4:2:1:Leather::1:0::2:0", -- Grand Breastplate
	[15196]="0:4:1:1:Tabard::1:0:5049,5191,5193,12781,12805,16766,52278:3:0", -- Private's Tabard
	[15197]="0:4:1:1:Tabard::1:0:5188,5189,5190,12793,16610:3:0", -- Scout's Tabard
	[15198]="0:4:1:1:Tabard::1:0:5049,5191,5193,12781,12805,16766,52278:3:0", -- Knight's Colors
	[15199]="0:4:1:1:Tabard::1:0:5188,5189,5190,12793,16610:3:0", -- Stone Guard's Herald
	[15200]="1:4:3:1:Amulet::1:0:12795:3:0", -- Senior Sergeant's Insignia
	[15202]="0:4:2:1:Leather::1:0::3:0", -- Wildkeeper Leggings
	[15203]="0:4:2:1:Mail::1:0::3:0", -- Guststorm Legguards
	[15204]="0:2:2:1:Wand::1:0::3:0", -- Moonstone Wand
	[15205]="0:2:2:1:Gun::1:0::3:0", -- Owlsight Rifle
	[15206]="0:4:2:1:OffHandFrill::1:0::3:0", -- Jadefinger Baton
	[15207]="0:4:2:1:Shield::1:0::3:0", -- Steelcap Shield
	[15208]="0:12:1:1:::1:0::4:0", -- Cenarion Moondust
	[15209]="0:12:1:1:::1:0::4:0", -- Relic Bundle
	[15210]="0:2:2:1:OneHandSword::1:0::2:0", -- Raider Shortsword
	[15211]="0:2:2:1:OneHandSword::1:0::2:0", -- Militant Shortsword
	[15212]="0:2:2:1:OneHandSword::1:0::2:0", -- Fighter Broadsword
	[15213]="0:2:2:1:OneHandSword::1:0::2:0", -- Mercenary Blade
	[15214]="0:2:2:1:OneHandSword::1:0::2:0", -- Nobles Brand
	[15215]="0:2:2:1:OneHandSword::1:0::2:0", -- Furious Falchion
	[15216]="0:2:2:1:OneHandSword::1:0::2:0", -- Rune Sword
	[15217]="0:2:2:1:OneHandSword::1:0::2:0", -- Widow Blade
	[15218]="0:2:2:1:OneHandSword::1:0::2:0", -- Crystal Sword
	[15219]="0:2:2:1:OneHandSword::1:0::2:0", -- Dimensional Blade
	[15220]="0:2:2:1:OneHandSword::1:0::2:0", -- Battlefell Sabre
	[15221]="0:2:2:1:OneHandSword::1:0::2:0", -- Holy War Sword
	[15222]="0:2:2:1:OneHandMace::1:0::2:0", -- Barbed Club
	[15223]="0:2:2:1:OneHandMace::1:0::2:0", -- Jagged Star
	[15224]="0:2:2:1:OneHandMace::1:0::2:0", -- Battlesmasher
	[15225]="0:2:2:1:OneHandMace::1:0::2:0", -- Sequoia Hammer
	[15226]="0:2:2:1:OneHandMace::1:0::2:0", -- Giant Club
	[15227]="0:2:2:1:OneHandMace::1:0::2:0", -- Diamond-Tip Bludgeon
	[15228]="0:2:2:1:OneHandMace::1:0::2:0", -- Smashing Star
	[15229]="0:2:2:1:OneHandMace::1:0::2:0", -- Blesswind Hammer
	[15230]="0:2:2:1:OneHandAxe::1:0::2:0", -- Ridge Cleaver
	[15231]="0:2:2:1:OneHandAxe::1:0::2:0", -- Splitting Hatchet
	[15232]="0:2:2:1:OneHandAxe::1:0::2:0", -- Hacking Cleaver
	[15233]="0:2:2:1:OneHandAxe::1:0::2:0", -- Savage Axe
	[15234]="0:2:2:1:OneHandAxe::1:0::2:0", -- Greater Scythe
	[15235]="0:2:2:1:OneHandAxe::1:0::2:0", -- Crescent Edge
	[15236]="0:2:2:1:OneHandAxe::1:0::2:0", -- Moon Cleaver
	[15237]="0:2:2:1:OneHandAxe::1:0::2:0", -- Corpse Harvester
	[15238]="0:2:2:1:OneHandAxe::1:0::2:0", -- Warlord's Axe
	[15239]="0:2:2:1:OneHandAxe::1:0::2:0", -- Felstone Reaver
	[15240]="0:2:2:1:OneHandAxe::1:0::2:0", -- Demon's Claw
	[15241]="0:2:2:1:Dagger::1:0::2:0", -- Battle Knife
	[15242]="0:2:2:1:Dagger::1:0::2:0", -- Honed Stiletto
	[15243]="0:2:2:1:Dagger::1:0::2:0", -- Deadly Kris
	[15244]="0:2:2:1:Dagger::1:0::2:0", -- Razor Blade
	[15245]="0:2:2:1:Dagger::1:0::2:0", -- Vorpal Dagger
	[15246]="0:2:2:1:Dagger::1:0::2:0", -- Demon Blade
	[15247]="0:2:2:1:Dagger::1:0::2:0", -- Bloodstrike Dagger
	[15248]="0:2:2:1:TwoHandSword::1:0::2:0", -- Gleaming Claymore
	[15249]="0:2:2:1:TwoHandSword::1:0::2:0", -- Polished Zweihander
	[15250]="0:2:2:1:TwoHandSword::1:0::2:0", -- Glimmering Flamberge
	[15251]="0:2:2:1:TwoHandSword::1:0::2:0", -- Headstriker Sword
	[15252]="0:2:2:1:TwoHandSword::1:0::2:0", -- Tusker Sword
	[15253]="0:2:2:1:TwoHandSword::1:0::2:0", -- Beheading Blade
	[15254]="0:2:2:1:TwoHandSword::1:0::2:0", -- Dark Espadon
	[15255]="0:2:2:1:TwoHandSword::1:0::2:0", -- Gallant Flamberge
	[15256]="0:2:2:1:TwoHandSword::1:0::2:0", -- Massacre Sword
	[15257]="0:2:2:1:TwoHandSword::1:0::2:0", -- Shin Blade
	[15258]="0:2:2:1:TwoHandSword::1:0::2:0", -- Divine Warblade
	[15259]="0:2:2:1:TwoHandMace::1:0::2:0", -- Hefty Battlehammer
	[15260]="0:2:2:1:TwoHandMace::1:0::2:0", -- Stone Hammer
	[15261]="0:2:2:1:TwoHandMace::1:0::2:0", -- Sequoia Branch
	[15262]="0:2:2:1:TwoHandMace::1:0::2:0", -- Greater Maul
	[15263]="0:2:2:1:TwoHandMace::1:0::2:0", -- Royal Mallet
	[15264]="0:2:2:1:TwoHandMace::1:0::2:0", -- Backbreaker
	[15265]="0:2:2:1:TwoHandMace::1:0::2:0", -- Painbringer
	[15266]="0:2:2:1:TwoHandMace::1:0::2:0", -- Fierce Mauler
	[15267]="0:2:2:1:TwoHandMace::1:0::2:0", -- Brutehammer
	[15268]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Twin-Bladed Axe
	[15269]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Massive Battle Axe
	[15270]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Gigantic War Axe
	[15271]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Colossal Great Axe
	[15272]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Razor Axe
	[15273]="0:2:2:1:TwoHandAxe::1:0::2:0", -- Death Striker
	[15274]="0:2:2:1:Stave::1:0::2:0", -- Diviner Long Staff
	[15275]="0:2:2:1:Stave::1:0::2:0", -- Thaumaturgist Staff
	[15276]="0:2:2:1:Stave::1:0::2:0", -- Magus Long Staff
	[15277]="10000:15:3:1:Mount::1:0:3685:3:0", -- Gray Kodo
	[15278]="0:2:2:1:Stave::1:0::2:0", -- Solstice Staff
	[15279]="0:2:2:1:Wand::1:0::2:0", -- Ivory Wand
	[15280]="0:2:2:1:Wand::1:0::2:0", -- Wizard's Hand
	[15281]="0:2:2:1:Wand::1:0::2:0", -- Glowstar Rod
	[15282]="0:2:2:1:Wand::1:0::2:0", -- Dragon Finger
	[15283]="0:2:2:1:Wand::1:0::2:0", -- Lunar Wand
	[15284]="0:2:2:1:Bow::1:0::2:0", -- Long Battle Bow
	[15285]="0:2:2:1:Bow::1:0::2:0", -- Archer's Longbow
	[15286]="0:2:2:1:Bow::1:0::2:0", -- Long Redwood Bow
	[15287]="0:2:2:1:Bow::1:0::2:0", -- Crusader Bow
	[15288]="0:2:2:1:Bow::1:0::2:0", -- Blasthorn Bow
	[15289]="0:2:2:1:Bow::1:0::2:0", -- Archstrike Bow
	[15290]="10000:15:3:1:Mount::1:0:3685:3:0", -- Brown Kodo
	[15291]="0:2:2:1:Bow::1:0::2:0", -- Harpy Needler
	[15292]="0:15:4:1:Mount::1:0::3:0", -- Green Kodo
	[15293]="0:15:4:1:Mount::1:0::3:0", -- Teal Kodo
	[15294]="0:2:2:1:Bow::1:0::2:0", -- Siege Bow
	[15295]="0:2:2:1:Bow::1:0::2:0", -- Quillfire Bow
	[15296]="0:2:2:1:Bow::1:0::2:0", -- Hawkeye Bow
	[15297]="0:4:1:1:Leather::1:0::0:0", -- Grizzly Bracers
	[15298]="0:4:2:1:Shield::1:0::2:0", -- Grizzly Buckler
	[15299]="0:4:1:1:Cloak::1:0::0:0", -- Grizzly Cape
	[15300]="0:4:1:1:Leather::1:0::0:0", -- Grizzly Gloves
	[15301]="0:4:1:1:Leather::1:0::0:0", -- Grizzly Slippers
	[15302]="0:4:1:1:Leather::1:0::0:0", -- Grizzly Belt
	[15303]="0:4:2:1:Leather::1:0::2:0", -- Grizzly Pants
	[15304]="0:4:2:1:Leather::1:0::2:0", -- Grizzly Jerkin
	[15305]="0:4:2:1:Leather::1:0::2:0", -- Feral Shoes
	[15306]="0:4:2:1:Leather::1:0::2:0", -- Feral Bindings
	[15307]="0:4:2:1:Shield::1:0::2:0", -- Feral Buckler
	[15308]="0:4:2:1:Leather::1:0::2:0", -- Feral Cord
	[15309]="0:4:2:1:Cloak::1:0::2:0", -- Feral Cloak
	[15310]="0:4:2:1:Leather::1:0::2:0", -- Feral Gloves
	[15311]="0:4:2:1:Leather::1:0::2:0", -- Feral Harness
	[15312]="0:4:2:1:Leather::1:0::2:0", -- Feral Leggings
	[15313]="0:4:1:1:Leather::1:0::0:0", -- Feral Shoulder Pads
	[15314]="0:0:1:1:Consumable::1:0::4:0", -- Bundle of Relics
	[15322]="0:2:2:1:Gun::1:0::2:0", -- Smoothbore Gun
	[15323]="0:2:2:1:Gun::1:0::2:0", -- Percussion Shotgun
	[15324]="0:2:2:1:Gun::1:0::2:0", -- Burnside Rifle
	[15325]="0:2:2:1:Gun::1:0::2:0", -- Sharpshooter Harquebus
	[15326]="0:15:1:200:Junk::1:0::0:0", -- Broken Gleaming Throwing Axe
	[15327]="0:15:1:200:Junk::1:0::0:0", -- Broken Wicked Throwing Dagger
	[15328]="0:13:1:1:::1:0::4:0", -- Joseph's Key
	[15329]="0:4:2:1:Leather::1:0::2:0", -- Wrangler's Belt
	[15330]="0:4:2:1:Leather::1:0::2:0", -- Wrangler's Boots
	[15331]="0:4:2:1:Leather::1:0::2:0", -- Wrangler's Wristbands
	[15332]="0:4:2:1:Shield::1:0::2:0", -- Wrangler's Buckler
	[15333]="0:4:2:1:Cloak::1:0::2:0", -- Wrangler's Cloak
	[15334]="0:4:2:1:Leather::1:0::2:0", -- Wrangler's Gloves
	[15335]="0:2:2:1:OneHandSword::1:0::3:0", -- Briarsteel Shortsword
	[15336]="0:4:2:1:Leather::1:0::2:0", -- Wrangler's Leggings
	[15337]="0:4:2:1:Leather::1:0::2:0", -- Wrangler's Wraps
	[15338]="0:4:2:1:Leather::1:0::2:0", -- Wrangler's Mantle
	[15339]="0:4:2:1:Leather::1:0::2:0", -- Pathfinder Hat
	[15340]="0:4:2:1:Cloak::1:0::2:0", -- Pathfinder Cloak
	[15341]="0:4:2:1:Leather::1:0::2:0", -- Pathfinder Footpads
	[15342]="0:4:2:1:Shield::1:0::2:0", -- Pathfinder Guard
	[15343]="0:4:2:1:Leather::1:0::2:0", -- Pathfinder Gloves
	[15344]="0:4:2:1:Leather::1:0::2:0", -- Pathfinder Pants
	[15345]="0:4:2:1:Leather::1:0::2:0", -- Pathfinder Shoulder Pads
	[15346]="0:4:2:1:Leather::1:0::2:0", -- Pathfinder Vest
	[15347]="0:4:2:1:Leather::1:0::2:0", -- Pathfinder Belt
	[15348]="0:4:2:1:Leather::1:0::2:0", -- Pathfinder Bracers
	[15349]="0:4:2:1:Leather::1:0::2:0", -- Headhunter's Belt
	[15350]="0:4:2:1:Leather::1:0::2:0", -- Headhunter's Slippers
	[15351]="0:4:2:1:Leather::1:0::2:0", -- Headhunter's Bands
	[15352]="0:4:2:1:Shield::1:0::2:0", -- Headhunter's Buckler
	[15353]="0:4:2:1:Leather::1:0::2:0", -- Headhunter's Headdress
	[15354]="0:4:2:1:Cloak::1:0::2:0", -- Headhunter's Cloak
	[15355]="0:4:2:1:Leather::1:0::2:0", -- Headhunter's Mitts
	[15356]="0:4:2:1:Leather::1:0::2:0", -- Headhunter's Armor
	[15357]="0:4:2:1:Leather::1:0::2:0", -- Headhunter's Spaulders
	[15358]="0:4:2:1:Leather::1:0::2:0", -- Headhunter's Woolies
	[15359]="0:4:2:1:Leather::1:0::2:0", -- Trickster's Vest
	[15360]="0:4:2:1:Leather::1:0::2:0", -- Trickster's Bindings
	[15361]="0:4:2:1:Leather::1:0::2:0", -- Trickster's Sash
	[15362]="0:4:2:1:Leather::1:0::2:0", -- Trickster's Boots
	[15363]="0:4:2:1:Leather::1:0::2:0", -- Trickster's Headdress
	[15364]="0:4:2:1:Cloak::1:0::2:0", -- Trickster's Cloak
	[15365]="0:4:2:1:Leather::1:0::2:0", -- Trickster's Handwraps
	[15366]="0:4:2:1:Leather::1:0::2:0", -- Trickster's Leggings
	[15367]="0:4:2:1:Shield::1:0::2:0", -- Trickster's Protector
	[15368]="0:4:2:1:Leather::1:0::2:0", -- Trickster's Pauldrons
	[15369]="0:4:2:1:Leather::1:0::2:0", -- Wolf Rider's Belt
	[15370]="0:4:2:1:Leather::1:0::2:0", -- Wolf Rider's Boots
	[15371]="0:4:2:1:Cloak::1:0::2:0", -- Wolf Rider's Cloak
	[15372]="0:4:2:1:Leather::1:0::2:0", -- Wolf Rider's Gloves
	[15373]="0:4:2:1:Leather::1:0::2:0", -- Wolf Rider's Headgear
	[15374]="0:4:2:1:Leather::1:0::2:0", -- Wolf Rider's Leggings
	[15375]="0:4:2:1:Leather::1:0::2:0", -- Wolf Rider's Shoulder Pads
	[15376]="0:4:2:1:Leather::1:0::2:0", -- Wolf Rider's Padded Armor
	[15377]="0:4:2:1:Leather::1:0::2:0", -- Wolf Rider's Wristbands
	[15378]="0:4:2:1:Leather::1:0::2:0", -- Rageclaw Belt
	[15379]="0:4:2:1:Leather::1:0::2:0", -- Rageclaw Boots
	[15380]="0:4:2:1:Leather::1:0::2:0", -- Rageclaw Bracers
	[15381]="0:4:2:1:Leather::1:0::2:0", -- Rageclaw Chestguard
	[15382]="0:4:2:1:Cloak::1:0::2:0", -- Rageclaw Cloak
	[15383]="0:4:2:1:Leather::1:0::2:0", -- Rageclaw Gloves
	[15384]="0:4:2:1:Leather::1:0::2:0", -- Rageclaw Helm
	[15385]="0:4:2:1:Leather::1:0::2:0", -- Rageclaw Leggings
	[15386]="0:4:2:1:Leather::1:0::2:0", -- Rageclaw Shoulder Pads
	[15387]="0:4:2:1:Leather::1:0::2:0", -- Jadefire Bracelets
	[15388]="0:4:2:1:Leather::1:0::2:0", -- Jadefire Belt
	[15389]="0:4:2:1:Leather::1:0::2:0", -- Jadefire Sabatons
	[15390]="0:4:2:1:Leather::1:0::2:0", -- Jadefire Chestguard
	[15391]="0:4:2:1:Leather::1:0::2:0", -- Jadefire Cap
	[15392]="0:4:2:1:Cloak::1:0::2:0", -- Jadefire Cloak
	[15393]="0:4:2:1:Leather::1:0::2:0", -- Jadefire Gloves
	[15394]="0:4:2:1:Leather::1:0::2:0", -- Jadefire Pants
	[15395]="0:4:2:1:Leather::1:0::2:0", -- Jadefire Epaulets
	[15396]="0:2:2:1:Dagger::1:0::3:0", -- Curvewood Dagger
	[15397]="0:2:2:1:Stave::1:0::3:0", -- Oakthrush Staff
	[15398]="0:4:1:1:Cloth::1:0::3:0", -- Sandcomber Boots
	[15399]="0:4:2:1:Leather::1:0::3:0", -- Dryweed Belt
	[15400]="0:4:1:1:Mail::1:0::3:0", -- Clamshell Bracers
	[15401]="0:4:1:1:Cloth::1:0::3:0", -- Welldrip Gloves
	[15402]="0:4:1:1:Mail::1:0::3:0", -- Noosegrip Gauntlets
	[15403]="0:4:2:1:Leather::1:0::3:0", -- Ridgeback Bracers
	[15404]="0:4:2:1:Mail::1:0::3:0", -- Breakwater Girdle
	[15405]="0:4:2:1:Leather::1:0::3:0", -- Shucking Gloves
	[15406]="0:4:2:1:Mail::1:0::3:0", -- Crustacean Boots
	[15407]="0:7:1:20:Leather:202,165:1:0::0:0", -- Cured Rugged Hide
	[15408]="0:7:1:20:Leather:165:1:0::0:0", -- Heavy Scorpid Scale
	[15409]="0:7:1:20:Leather:165:1:0::0:0", -- Refined Deeprock Salt
	[15410]="0:7:3:20:Leather:165:1:0::0:0", -- Scale of Onyxia
	[15411]="0:4:3:1:Amulet::1:0::3:0", -- Mark of Fordring
	[15412]="0:7:1:20:Leather:165:1:0::0:0", -- Green Dragonscale
	[15413]="0:4:3:1:Plate::1:0::3:0", -- Ornate Adamantium Breastplate
	[15414]="0:7:1:20:Leather:165:1:0::0:0", -- Red Dragonscale
	[15415]="0:7:1:20:Leather:165:1:0::0:0", -- Blue Dragonscale
	[15416]="0:7:1:20:Leather:165:1:0::0:0", -- Black Dragonscale
	[15417]="0:7:1:20:Leather:164,165:1:0::0:0", -- Devilsaur Leather
	[15418]="0:2:3:1:TwoHandMace::1:0::3:0", -- Shimmering Platinum Warhammer
	[15419]="0:7:1:20:Leather:165:1:0::0:0", -- Warbear Leather
	[15420]="0:15:0:50:Junk::1:0::0:0", -- Ironfeather
	[15421]="0:4:3:1:Cloak::1:0::3:0", -- Shroud of the Exile
	[15422]="0:15:0:20:Junk::1:0::0:0", -- Frostsaber Leather
	[15423]="0:15:0:20:Junk::1:0::0:0", -- Chimera Leather
	[15424]="0:2:2:1:TwoHandAxe::1:0::3:0", -- Axe of Orgrimmar
	[15425]="0:4:2:1:Leather::1:0::2:0", -- Peerless Bracers
	[15426]="0:4:2:1:Leather::1:0::2:0", -- Peerless Boots
	[15427]="0:4:2:1:Cloak::1:0::2:0", -- Peerless Cloak
	[15428]="0:4:2:1:Leather::1:0::2:0", -- Peerless Belt
	[15429]="0:4:2:1:Leather::1:0::2:0", -- Peerless Gloves
	[15430]="0:4:2:1:Leather::1:0::2:0", -- Peerless Headband
	[15431]="0:4:2:1:Leather::1:0::2:0", -- Peerless Leggings
	[15432]="0:4:2:1:Leather::1:0::2:0", -- Peerless Shoulders
	[15433]="0:4:2:1:Leather::1:0::2:0", -- Peerless Armor
	[15434]="0:4:2:1:Leather::1:0::2:0", -- Supreme Sash
	[15435]="0:4:2:1:Leather::1:0::2:0", -- Supreme Shoes
	[15436]="0:4:2:1:Leather::1:0::2:0", -- Supreme Bracers
	[15437]="0:4:2:1:Cloak::1:0::2:0", -- Supreme Cape
	[15438]="0:4:2:1:Leather::1:0::2:0", -- Supreme Gloves
	[15439]="0:4:2:1:Leather::1:0::2:0", -- Supreme Crown
	[15440]="0:4:2:1:Leather::1:0::2:0", -- Supreme Leggings
	[15441]="0:4:2:1:Leather::1:0::2:0", -- Supreme Shoulders
	[15442]="0:4:2:1:Leather::1:0::2:0", -- Supreme Breastplate
	[15443]="0:2:2:1:Dagger::1:0::3:0", -- Kris of Orgrimmar
	[15444]="0:2:2:1:Stave::1:0::3:0", -- Staff of Orgrimmar
	[15445]="0:2:2:1:OneHandMace::1:0::3:0", -- Hammer of Orgrimmar
	[15447]="0:12:1:20:::1:0::4:0", -- Living Rot
	[15448]="0:12:1:1:::1:0::4:0", -- Coagulated Rot
	[15449]="0:4:2:1:Cloth::1:0::3:0", -- Ghastly Trousers
	[15450]="0:4:2:1:Leather::1:0::3:0", -- Dredgemire Leggings
	[15451]="0:4:2:1:Mail::1:0::3:0", -- Gargoyle Leggings
	[15452]="0:4:2:1:Cloth::1:0::3:0", -- Featherbead Bracers
	[15453]="0:4:2:1:Leather::1:0::3:0", -- Savannah Bracers
	[15454]="0:12:1:1:::1:0::4:0", -- Mortar and Pestle
	[15455]="0:4:2:1:Cloth::1:0::3:0", -- Dustfall Robes
	[15456]="0:4:2:1:Leather::1:0::3:0", -- Lightstep Leggings
	[15457]="0:4:2:1:Cloth::1:0::3:0", -- Desert Shoulders
	[15458]="0:4:2:1:Leather::1:0::3:0", -- Tundra Boots
	[15459]="0:4:2:1:Mail::1:0::3:0", -- Grimtoll Wristguards
	[15461]="0:4:2:1:Cloth::1:0::3:0", -- Lightheel Boots
	[15462]="0:4:2:1:Leather::1:0::3:0", -- Loamflake Bracers
	[15463]="0:4:2:1:Mail::1:0::3:0", -- Palestrider Gloves
	[15464]="0:2:2:1:TwoHandMace::1:0::3:0", -- Brute Hammer
	[15465]="0:2:2:1:Wand::1:0::3:0", -- Stingshot Wand
	[15466]="0:4:2:1:Shield::1:0::3:0", -- Clink Shield
	[15467]="0:4:2:1:Ring::1:0::3:0", -- Inventor's League Ring
	[15468]="0:4:2:1:Cloak::1:0::3:0", -- Windsong Drape
	[15469]="0:4:2:1:Leather::1:0::3:0", -- Windsong Cinch
	[15470]="0:4:2:1:Mail::1:0::3:0", -- Plainsguard Leggings
	[15471]="0:4:2:1:Leather::1:0::3:0", -- Brawnhide Armor
	[15472]="0:4:1:1:Mail::1:0::0:0", -- Charger's Belt
	[15473]="0:4:1:1:Mail::1:0::0:0", -- Charger's Boots
	[15474]="0:4:1:1:Mail::1:0::0:0", -- Charger's Bindings
	[15475]="0:4:1:1:Cloak::1:0::0:0", -- Charger's Cloak
	[15476]="0:4:1:1:Mail::1:0::0:0", -- Charger's Handwraps
	[15477]="0:4:2:1:Mail::1:0::2:0", -- Charger's Pants
	[15478]="0:4:1:1:Shield::1:0::0:0", -- Charger's Shield
	[15479]="0:4:2:1:Mail::1:0::2:0", -- Charger's Armor
	[15480]="0:4:1:1:Mail::1:0::0:0", -- War Torn Girdle
	[15481]="0:4:1:1:Mail::1:0::0:0", -- War Torn Greaves
	[15482]="0:4:1:1:Mail::1:0::0:0", -- War Torn Bands
	[15483]="0:4:1:1:Cloak::1:0::0:0", -- War Torn Cape
	[15484]="0:4:1:1:Mail::1:0::0:0", -- War Torn Handgrips
	[15485]="0:4:2:1:Mail::1:0::2:0", -- War Torn Pants
	[15486]="0:4:2:1:Shield::1:0::2:0", -- War Torn Shield
	[15487]="0:4:2:1:Mail::1:0::2:0", -- War Torn Tunic
	[15488]="0:4:2:1:Mail::1:0::2:0", -- Bloodspattered Surcoat
	[15489]="0:4:2:1:Mail::1:0::2:0", -- Bloodspattered Sabatons
	[15490]="0:4:1:1:Cloak::1:0::0:0", -- Bloodspattered Cloak
	[15491]="0:4:2:1:Mail::1:0::2:0", -- Bloodspattered Gloves
	[15492]="0:4:2:1:Mail::1:0::2:0", -- Bloodspattered Sash
	[15493]="0:4:2:1:Mail::1:0::2:0", -- Bloodspattered Loincloth
	[15494]="0:4:2:1:Shield::1:0::2:0", -- Bloodspattered Shield
	[15495]="0:4:2:1:Mail::1:0::2:0", -- Bloodspattered Wristbands
	[15496]="0:4:1:1:Mail::1:0::0:0", -- Bloodspattered Shoulder Pads
	[15497]="0:4:2:1:Mail::1:0::2:0", -- Outrunner's Cord
	[15498]="0:4:2:1:Mail::1:0::2:0", -- Outrunner's Slippers
	[15499]="0:4:2:1:Mail::1:0::2:0", -- Outrunner's Cuffs
	[15500]="0:4:2:1:Mail::1:0::2:0", -- Outrunner's Chestguard
	[15501]="0:4:2:1:Cloak::1:0::2:0", -- Outrunner's Cloak
	[15502]="0:4:2:1:Mail::1:0::2:0", -- Outrunner's Gloves
	[15503]="0:4:2:1:Mail::1:0::2:0", -- Outrunner's Legguards
	[15504]="0:4:2:1:Shield::1:0::2:0", -- Outrunner's Shield
	[15505]="0:4:1:1:Mail::1:0::0:0", -- Outrunner's Pauldrons
	[15506]="0:4:2:1:Mail::1:0::2:0", -- Grunt's Ankle Wraps
	[15507]="0:4:2:1:Mail::1:0::2:0", -- Grunt's Bracers
	[15508]="0:4:2:1:Cloak::1:0::2:0", -- Grunt's Cape
	[15509]="0:4:2:1:Mail::1:0::2:0", -- Grunt's Handwraps
	[15510]="0:4:2:1:Mail::1:0::2:0", -- Grunt's Belt
	[15511]="0:4:2:1:Mail::1:0::2:0", -- Grunt's Legguards
	[15512]="0:4:2:1:Shield::1:0::2:0", -- Grunt's Shield
	[15513]="0:4:2:1:Mail::1:0::2:0", -- Grunt's Pauldrons
	[15514]="0:4:2:1:Mail::1:0::2:0", -- Grunt's Chestpiece
	[15515]="0:4:2:1:Mail::1:0::2:0", -- Spiked Chain Belt
	[15516]="0:4:2:1:Mail::1:0::2:0", -- Spiked Chain Slippers
	[15517]="0:4:2:1:Mail::1:0::2:0", -- Spiked Chain Wristbands
	[15518]="0:4:2:1:Mail::1:0::2:0", -- Spiked Chain Breastplate
	[15519]="0:4:2:1:Cloak::1:0::2:0", -- Spiked Chain Cloak
	[15520]="0:4:2:1:Mail::1:0::2:0", -- Spiked Chain Gauntlets
	[15521]="0:4:2:1:Mail::1:0::2:0", -- Spiked Chain Leggings
	[15522]="0:4:2:1:Shield::1:0::2:0", -- Spiked Chain Shield
	[15523]="0:4:2:1:Mail::1:0::2:0", -- Spiked Chain Shoulder Pads
	[15524]="0:4:2:1:Mail::1:0::2:0", -- Sentry's Surcoat
	[15525]="0:4:2:1:Mail::1:0::2:0", -- Sentry's Slippers
	[15526]="0:4:2:1:Cloak::1:0::2:0", -- Sentry's Cape
	[15527]="0:4:2:1:Mail::1:0::2:0", -- Sentry's Gloves
	[15528]="0:4:2:1:Mail::1:0::2:0", -- Sentry's Sash
	[15529]="0:4:2:1:Mail::1:0::2:0", -- Sentry's Leggings
	[15530]="0:4:2:1:Shield::1:0::2:0", -- Sentry's Shield
	[15531]="0:4:2:1:Mail::1:0::2:0", -- Sentry's Shoulderguards
	[15532]="0:4:2:1:Mail::1:0::2:0", -- Sentry's Armsplints
	[15533]="0:4:2:1:Mail::1:0::2:0", -- Sentry's Headdress
	[15534]="0:4:2:1:Mail::1:0::2:0", -- Wicked Chain Boots
	[15535]="0:4:2:1:Mail::1:0::2:0", -- Wicked Chain Bracers
	[15536]="0:4:2:1:Mail::1:0::2:0", -- Wicked Chain Chestpiece
	[15537]="0:4:2:1:Cloak::1:0::2:0", -- Wicked Chain Cloak
	[15538]="0:4:2:1:Mail::1:0::2:0", -- Wicked Chain Gauntlets
	[15539]="0:4:2:1:Mail::1:0::2:0", -- Wicked Chain Waistband
	[15540]="0:4:2:1:Mail::1:0::2:0", -- Wicked Chain Helmet
	[15541]="0:4:2:1:Mail::1:0::2:0", -- Wicked Chain Legguards
	[15542]="0:4:2:1:Mail::1:0::2:0", -- Wicked Chain Shoulder Pads
	[15543]="0:4:2:1:Shield::1:0::2:0", -- Wicked Chain Shield
	[15544]="0:4:2:1:Mail::1:0::2:0", -- Thick Scale Sabatons
	[15545]="0:4:2:1:Mail::1:0::2:0", -- Thick Scale Bracelets
	[15546]="0:4:2:1:Mail::1:0::2:0", -- Thick Scale Breastplate
	[15547]="0:4:2:1:Cloak::1:0::2:0", -- Thick Scale Cloak
	[15548]="0:4:2:1:Mail::1:0::2:0", -- Thick Scale Gauntlets
	[15549]="0:4:2:1:Mail::1:0::2:0", -- Thick Scale Belt
	[15550]="0:4:2:1:Mail::1:0::2:0", -- Thick Scale Crown
	[15551]="0:4:2:1:Mail::1:0::2:0", -- Thick Scale Legguards
	[15552]="0:4:2:1:Shield::1:0::2:0", -- Thick Scale Shield
	[15553]="0:4:2:1:Mail::1:0::2:0", -- Thick Scale Shoulder Pads
	[15554]="0:4:2:1:Mail::1:0::2:0", -- Pillager's Girdle
	[15555]="0:4:2:1:Mail::1:0::2:0", -- Pillager's Boots
	[15556]="0:4:2:1:Mail::1:0::2:0", -- Pillager's Bracers
	[15557]="0:4:2:1:Mail::1:0::2:0", -- Pillager's Chestguard
	[15558]="0:4:2:1:Mail::1:0::2:0", -- Pillager's Crown
	[15559]="0:4:2:1:Cloak::1:0::2:0", -- Pillager's Cloak
	[15560]="0:4:2:1:Mail::1:0::2:0", -- Pillager's Gloves
	[15561]="0:4:2:1:Mail::1:0::2:0", -- Pillager's Leggings
	[15562]="0:4:2:1:Mail::1:0::2:0", -- Pillager's Pauldrons
	[15563]="0:4:2:1:Shield::1:0::2:0", -- Pillager's Shield
	[15564]="0:0:1:10:EnhPerm::1:0::0:0", -- Rugged Armor Kit
	[15565]="0:4:2:1:Mail::1:0::2:0", -- Marauder's Boots
	[15566]="0:4:2:1:Mail::1:0::2:0", -- Marauder's Bracers
	[15567]="0:4:2:1:Mail::1:0::2:0", -- Marauder's Tunic
	[15568]="0:4:2:1:Cloak::1:0::2:0", -- Marauder's Cloak
	[15569]="0:4:2:1:Shield::1:0::2:0", -- Marauder's Crest
	[15570]="0:4:2:1:Mail::1:0::2:0", -- Marauder's Gauntlets
	[15571]="0:4:2:1:Mail::1:0::2:0", -- Marauder's Belt
	[15572]="0:4:2:1:Mail::1:0::2:0", -- Marauder's Circlet
	[15573]="0:4:2:1:Mail::1:0::2:0", -- Marauder's Leggings
	[15574]="0:4:2:1:Mail::1:0::2:0", -- Marauder's Shoulder Pads
	[15575]="0:4:2:1:Mail::1:0::2:0", -- Sparkleshell Belt
	[15576]="0:4:2:1:Mail::1:0::2:0", -- Sparkleshell Sabatons
	[15577]="0:4:2:1:Mail::1:0::2:0", -- Sparkleshell Bracers
	[15578]="0:4:2:1:Mail::1:0::2:0", -- Sparkleshell Breastplate
	[15579]="0:4:2:1:Cloak::1:0::2:0", -- Sparkleshell Cloak
	[15580]="0:4:2:1:Mail::1:0::2:0", -- Sparkleshell Headwrap
	[15581]="0:4:2:1:Mail::1:0::2:0", -- Sparkleshell Gauntlets
	[15582]="0:4:2:1:Mail::1:0::2:0", -- Sparkleshell Legguards
	[15583]="0:4:2:1:Mail::1:0::2:0", -- Sparkleshell Shoulder Pads
	[15584]="0:4:2:1:Shield::1:0::2:0", -- Sparkleshell Shield
	[15585]="0:4:2:1:Cloth::1:0::3:0", -- Pardoc Grips
	[15587]="0:4:2:1:Leather::1:0::3:0", -- Ringtail Girdle
	[15588]="0:4:2:1:Mail::1:0::3:0", -- Bracesteel Belt
	[15589]="0:4:2:1:Mail::1:0::2:0", -- Steadfast Stompers
	[15590]="0:4:2:1:Mail::1:0::2:0", -- Steadfast Bracelets
	[15591]="0:4:2:1:Mail::1:0::2:0", -- Steadfast Breastplate
	[15592]="0:4:2:1:Shield::1:0::2:0", -- Steadfast Buckler
	[15593]="0:4:2:1:Mail::1:0::2:0", -- Steadfast Coronet
	[15594]="0:4:2:1:Cloak::1:0::2:0", -- Steadfast Cloak
	[15595]="0:4:2:1:Mail::1:0::2:0", -- Steadfast Gloves
	[15596]="0:4:2:1:Mail::1:0::2:0", -- Steadfast Legplates
	[15597]="0:4:2:1:Mail::1:0::2:0", -- Steadfast Shoulders
	[15598]="0:4:2:1:Mail::1:0::2:0", -- Steadfast Girdle
	[15599]="0:4:2:1:Mail::1:0::2:0", -- Ancient Greaves
	[15600]="0:4:2:1:Mail::1:0::2:0", -- Ancient Vambraces
	[15601]="0:4:2:1:Mail::1:0::2:0", -- Ancient Chestpiece
	[15602]="0:4:2:1:Mail::1:0::2:0", -- Ancient Crown
	[15603]="0:4:2:1:Cloak::1:0::2:0", -- Ancient Cloak
	[15604]="0:4:2:1:Shield::1:0::2:0", -- Ancient Defender
	[15605]="0:4:2:1:Mail::1:0::2:0", -- Ancient Gauntlets
	[15606]="0:4:2:1:Mail::1:0::2:0", -- Ancient Belt
	[15607]="0:4:2:1:Mail::1:0::2:0", -- Ancient Legguards
	[15608]="0:4:2:1:Mail::1:0::2:0", -- Ancient Pauldrons
	[15609]="0:4:2:1:Mail::1:0::2:0", -- Bonelink Armor
	[15610]="0:4:2:1:Mail::1:0::2:0", -- Bonelink Bracers
	[15611]="0:4:2:1:Cloak::1:0::2:0", -- Bonelink Cape
	[15612]="0:4:2:1:Mail::1:0::2:0", -- Bonelink Gauntlets
	[15613]="0:4:2:1:Mail::1:0::2:0", -- Bonelink Belt
	[15614]="0:4:2:1:Mail::1:0::2:0", -- Bonelink Sabatons
	[15615]="0:4:2:1:Mail::1:0::2:0", -- Bonelink Helmet
	[15616]="0:4:2:1:Mail::1:0::2:0", -- Bonelink Legplates
	[15617]="0:4:2:1:Mail::1:0::2:0", -- Bonelink Epaulets
	[15618]="0:4:2:1:Shield::1:0::2:0", -- Bonelink Wall Shield
	[15619]="0:4:2:1:Mail::1:0::2:0", -- Gryphon Mail Belt
	[15620]="0:4:2:1:Mail::1:0::2:0", -- Gryphon Mail Bracelets
	[15621]="0:4:2:1:Shield::1:0::2:0", -- Gryphon Mail Buckler
	[15622]="0:4:2:1:Mail::1:0::2:0", -- Gryphon Mail Breastplate
	[15623]="0:4:2:1:Mail::1:0::2:0", -- Gryphon Mail Crown
	[15624]="0:4:2:1:Cloak::1:0::2:0", -- Gryphon Cloak
	[15625]="0:4:2:1:Mail::1:0::2:0", -- Gryphon Mail Gauntlets
	[15626]="0:4:2:1:Mail::1:0::2:0", -- Gryphon Mail Greaves
	[15627]="0:4:2:1:Mail::1:0::2:0", -- Gryphon Mail Legguards
	[15628]="0:4:2:1:Mail::1:0::2:0", -- Gryphon Mail Pauldrons
	[15629]="0:4:2:1:Mail::1:0::2:0", -- Formidable Bracers
	[15630]="0:4:2:1:Mail::1:0::2:0", -- Formidable Sabatons
	[15631]="0:4:2:1:Mail::1:0::2:0", -- Formidable Chestpiece
	[15632]="0:4:2:1:Cloak::1:0::2:0", -- Formidable Cape
	[15633]="0:4:2:1:Shield::1:0::2:0", -- Formidable Crest
	[15634]="0:4:2:1:Mail::1:0::2:0", -- Formidable Circlet
	[15635]="0:4:2:1:Mail::1:0::2:0", -- Formidable Gauntlets
	[15636]="0:4:2:1:Mail::1:0::2:0", -- Formidable Belt
	[15637]="0:4:2:1:Mail::1:0::2:0", -- Formidable Legguards
	[15638]="0:4:2:1:Mail::1:0::2:0", -- Formidable Shoulder Pads
	[15639]="0:4:2:1:Mail::1:0::2:0", -- Ironhide Bracers
	[15640]="0:4:2:1:Mail::1:0::2:0", -- Ironhide Breastplate
	[15641]="0:4:2:1:Mail::1:0::2:0", -- Ironhide Belt
	[15642]="0:4:2:1:Mail::1:0::2:0", -- Ironhide Greaves
	[15643]="0:4:2:1:Cloak::1:0::2:0", -- Ironhide Cloak
	[15644]="0:4:2:1:Mail::1:0::2:0", -- Ironhide Gauntlets
	[15645]="0:4:2:1:Mail::1:0::2:0", -- Ironhide Helmet
	[15646]="0:4:2:1:Mail::1:0::2:0", -- Ironhide Legguards
	[15647]="0:4:2:1:Mail::1:0::2:0", -- Ironhide Pauldrons
	[15648]="0:4:2:1:Shield::1:0::2:0", -- Ironhide Shield
	[15649]="0:4:2:1:Mail::1:0::2:0", -- Merciless Bracers
	[15650]="0:4:2:1:Mail::1:0::2:0", -- Merciless Surcoat
	[15651]="0:4:2:1:Mail::1:0::2:0", -- Merciless Crown
	[15652]="0:4:2:1:Cloak::1:0::2:0", -- Merciless Cloak
	[15653]="0:4:2:1:Mail::1:0::2:0", -- Merciless Gauntlets
	[15654]="0:4:2:1:Mail::1:0::2:0", -- Merciless Belt
	[15655]="0:4:2:1:Mail::1:0::2:0", -- Merciless Legguards
	[15656]="0:4:2:1:Mail::1:0::2:0", -- Merciless Epaulets
	[15657]="0:4:2:1:Shield::1:0::2:0", -- Merciless Shield
	[15658]="0:4:2:1:Mail::1:0::2:0", -- Impenetrable Sabatons
	[15659]="0:4:2:1:Mail::1:0::2:0", -- Impenetrable Bindings
	[15660]="0:4:2:1:Mail::1:0::2:0", -- Impenetrable Breastplate
	[15661]="0:4:2:1:Cloak::1:0::2:0", -- Impenetrable Cloak
	[15662]="0:4:2:1:Mail::1:0::2:0", -- Impenetrable Gauntlets
	[15663]="0:4:2:1:Mail::1:0::2:0", -- Impenetrable Belt
	[15664]="0:4:2:1:Mail::1:0::2:0", -- Impenetrable Helmet
	[15665]="0:4:2:1:Mail::1:0::2:0", -- Impenetrable Legguards
	[15666]="0:4:2:1:Mail::1:0::2:0", -- Impenetrable Pauldrons
	[15667]="0:4:2:1:Shield::1:0::2:0", -- Impenetrable Wall
	[15668]="0:4:2:1:Mail::1:0::2:0", -- Magnificent Bracers
	[15669]="0:4:2:1:Mail::1:0::2:0", -- Magnificent Breastplate
	[15670]="0:4:2:1:Mail::1:0::2:0", -- Magnificent Helmet
	[15671]="0:4:2:1:Cloak::1:0::2:0", -- Magnificent Cloak
	[15672]="0:4:2:1:Mail::1:0::2:0", -- Magnificent Gauntlets
	[15673]="0:4:2:1:Mail::1:0::2:0", -- Magnificent Belt
	[15674]="0:4:2:1:Mail::1:0::2:0", -- Magnificent Greaves
	[15675]="0:4:2:1:Shield::1:0::2:0", -- Magnificent Guard
	[15676]="0:4:2:1:Mail::1:0::2:0", -- Magnificent Leggings
	[15677]="0:4:2:1:Mail::1:0::2:0", -- Magnificent Shoulders
	[15678]="0:4:2:1:Mail::1:0::2:0", -- Triumphant Sabatons
	[15679]="0:4:2:1:Mail::1:0::2:0", -- Triumphant Bracers
	[15680]="0:4:2:1:Mail::1:0::2:0", -- Triumphant Chestpiece
	[15681]="0:4:2:1:Cloak::1:0::2:0", -- Triumphant Cloak
	[15682]="0:4:2:1:Mail::1:0::2:0", -- Triumphant Gauntlets
	[15683]="0:4:2:1:Mail::1:0::2:0", -- Triumphant Girdle
	[15684]="0:4:2:1:Mail::1:0::2:0", -- Triumphant Skullcap
	[15685]="0:4:2:1:Mail::1:0::2:0", -- Triumphant Legplates
	[15686]="0:4:2:1:Mail::1:0::2:0", -- Triumphant Shoulder Pads
	[15687]="0:4:2:1:Shield::1:0::2:0", -- Triumphant Shield
	[15689]="0:4:2:1:Ring::1:0::3:0", -- Trader's Ring
	[15690]="0:4:2:1:Amulet::1:0::3:0", -- Kodobone Necklace
	[15691]="0:2:2:1:Gun::1:0::3:0", -- Sidegunner Shottie
	[15692]="0:2:2:1:Wand::1:0::3:0", -- Kodo Brander
	[15693]="0:4:2:1:Leather::1:0::2:0", -- Grand Shoulders
	[15694]="0:4:2:1:Mail::1:0::2:0", -- Merciless Greaves
	[15695]="0:4:2:1:Shield::1:0::3:0", -- Studded Ring Shield
	[15696]="0:12:1:1:::1:0::0:0", -- Ruined Tome
	[15697]="0:4:2:1:Cloth::1:0::3:0", -- Kodo Rustler Boots
	[15698]="0:4:2:1:Mail::1:0::3:0", -- Wrangling Spaulders
	[15699]="0:15:1:1:Junk::1:0::3:0", -- Small Brown-Wrapped Package
	[15702]="0:4:2:1:Ring::1:0::3:0", -- Chemist's Ring
	[15703]="0:4:2:1:Cloak::1:0::3:0", -- Chemist's Smock
	[15704]="0:4:2:1:Amulet::1:0::3:0", -- Hunter's Insignia Medal
	[15705]="0:2:2:1:OneHandSword::1:0::3:0", -- Tidecrest Blade
	[15706]="0:2:2:1:Dagger::1:0::3:0", -- Hunt Tracker Blade
	[15707]="0:4:2:1:Cloth::1:0::3:0", -- Brantwood Sash
	[15708]="0:4:2:1:Leather::1:0::3:0", -- Blight Leather Gloves
	[15709]="0:4:3:1:Plate::1:0::3:0", -- Gearforge Girdle
	[15710]="0:12:1:1:::1:0::4:0", -- Cenarion Lunardust
	[15722]="0:12:1:1:::1:0::4:0", -- Spraggle's Canteen
	[15723]="0:0:2:1:Consumable::1:0::3:0", -- Tea with Sugar
	[15724]="12000:9:1:1:Leatherworking::1:1:12956:0:0", -- Pattern: Heavy Scorpid Bracers
	[15725]="12000:9:1:1:Leatherworking::1:1:12942,12943:0:0", -- Pattern: Wicked Leather Gauntlets
	[15726]="0:9:3:1:Leatherworking::1:0::0:0", -- Pattern: Green Dragonscale Breastplate
	[15727]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Heavy Scorpid Vest
	[15728]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Wicked Leather Bracers
	[15729]="0:9:1:1:Leatherworking::1:0::0:0", -- Pattern: Chimeric Gloves
	[15730]="0:9:3:1:Leatherworking::1:0::3:0", -- Pattern: Red Dragonscale Breastplate
	[15731]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Runic Leather Gauntlets
	[15732]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Volcanic Leggings
	[15733]="0:9:3:1:Leatherworking::1:0::0:0", -- Pattern: Green Dragonscale Leggings
	[15734]="14000:9:1:1:Leatherworking::1:1:7854,40226:0:0", -- Pattern: Living Shoulders
	[15735]="14000:9:1:1:Leatherworking::1:1:12958:0:0", -- Pattern: Ironfeather Shoulders
	[15736]="0:12:1:1:::1:0::4:0", -- Smokey's Special Compound
	[15737]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Chimeric Boots
	[15738]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Heavy Scorpid Gauntlets
	[15739]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Runic Leather Bracers
	[15740]="16000:9:1:1:Leatherworking::1:1:11189:0:0", -- Pattern: Frostsaber Boots
	[15741]="16000:9:1:1:Leatherworking::1:1:12942,12943:0:0", -- Pattern: Stormshroud Pants
	[15742]="0:9:1:1:Leatherworking::1:0::0:0", -- Pattern: Warbear Harness
	[15743]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Heavy Scorpid Belt
	[15744]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Wicked Leather Headband
	[15745]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Runic Leather Belt
	[15746]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Chimeric Leggings
	[15747]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Frostsaber Leggings
	[15748]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Heavy Scorpid Leggings
	[15749]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Volcanic Breastplate
	[15750]="0:12:1:1:::1:0::4:0", -- Sceptre of Light
	[15751]="0:9:1:1:Leatherworking::1:0::0:0", -- Pattern: Blue Dragonscale Breastplate
	[15752]="0:9:3:1:Leatherworking::1:0::0:0", -- Pattern: Living Leggings
	[15753]="0:9:3:1:Leatherworking::1:0::0:0", -- Pattern: Stormshroud Armor
	[15754]="0:9:1:1:Leatherworking::1:0::3:0", -- Pattern: Warbear Woolies
	[15755]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Chimeric Vest
	[15756]="0:9:1:1:Leatherworking::1:0::0:0", -- Pattern: Runic Leather Headband
	[15757]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Wicked Leather Pants
	[15758]="22000:9:1:1:Leatherworking::1:1:12959:0:0", -- Pattern: Devilsaur Gauntlets
	[15759]="22000:9:1:1:Leatherworking::1:1:9499:0:0", -- Pattern: Black Dragonscale Breastplate
	[15760]="0:9:3:1:Leatherworking::1:0::0:0", -- Pattern: Ironfeather Breastplate
	[15761]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Frostsaber Gloves
	[15762]="25000:9:1:1:Leatherworking::1:1:12956:0:0", -- Pattern: Heavy Scorpid Helm
	[15763]="0:9:3:1:Leatherworking::1:0::0:0", -- Pattern: Blue Dragonscale Shoulders
	[15764]="0:9:3:1:Leatherworking::1:0::0:0", -- Pattern: Stormshroud Shoulders
	[15765]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Runic Leather Pants
	[15766]="0:12:1:1:::1:0::4:0", -- Gem of the Serpent
	[15768]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Wicked Leather Belt
	[15770]="0:9:3:1:Leatherworking::1:0::0:0", -- Pattern: Black Dragonscale Shoulders
	[15771]="0:9:3:1:Leatherworking::1:0::0:0", -- Pattern: Living Breastplate
	[15772]="30000:9:3:1:Leatherworking::1:1:12959:0:0", -- Pattern: Devilsaur Leggings
	[15773]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Wicked Leather Armor
	[15774]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Heavy Scorpid Shoulders
	[15775]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Volcanic Shoulders
	[15776]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Runic Leather Armor
	[15777]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Runic Leather Shoulders
	[15778]="0:0:2:1:Consumable::1:0::3:0", -- Mechanical Yeti
	[15779]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Frostsaber Tunic
	[15781]="0:9:3:1:Leatherworking::1:0::0:0", -- Pattern: Black Dragonscale Leggings
	[15782]="0:2:2:1:OneHandSword::1:0::3:0", -- Beaststalker Blade
	[15783]="0:2:2:1:Dagger::1:0::3:0", -- Beasthunter Dagger
	[15784]="0:4:2:1:Cloth::1:0::3:0", -- Crystal Breeze Mantle
	[15785]="0:12:1:1:::1:0::4:0", -- Zaeldarr's Head
	[15786]="0:4:2:1:Leather::1:0::3:0", -- Fernpulse Jerkin
	[15787]="0:4:2:1:Mail::1:0::3:0", -- Willow Band Hauberk
	[15788]="0:12:1:1:::1:0::4:0", -- Everlook Report
	[15789]="0:4:2:1:Cloak::1:0::3:0", -- Deep River Cloak
	[15790]="0:12:1:1:::1:0::4:0", -- Studies in Spirit Speaking
	[15791]="0:4:2:1:Cloth::1:0::3:0", -- Turquoise Sash
	[15792]="0:4:2:1:Leather::1:0::3:0", -- Plow Wood Spaulders
	[15793]="0:15:0:20:Junk::1:0::0:0", -- A Chewed Bone
	[15794]="0:4:0:1:Cloth::1:0::0:0", -- Ripped Ogre Loincloth
	[15795]="0:4:2:1:Plate::1:0::3:0", -- Emerald Mist Gauntlets
	[15796]="0:4:2:1:Mail::1:0::3:0", -- Seaspray Bracers
	[15797]="0:4:2:1:Plate::1:0::3:0", -- Shining Armplates
	[15798]="0:15:0:20:Junk::1:0::0:0", -- Chipped Ogre Teeth
	[15799]="0:4:3:1:Amulet::1:0::3:0", -- Heroic Commendation Medal
	[15800]="0:2:3:1:OneHandSword::1:0::3:0", -- Intrepid Shortsword
	[15801]="0:2:3:1:OneHandSword::1:0::3:0", -- Valiant Shortsword
	[15802]="0:4:3:1:Cloth::1:0::2:0", -- Mooncloth Boots
	[15803]="0:12:1:1:::1:0::4:0", -- Book of the Ancients
	[15804]="0:4:2:1:Cloak::1:0::3:0", -- Cerise Drape
	[15805]="0:4:3:1:OffHandFrill::1:0::3:0", -- Penelope's Rose
	[15806]="0:2:3:1:OneHandSword::1:0::3:0", -- Mirah's Song
	[15807]="294:2:1:1:Crossbow::1:0:1287,4602,7976,16715,16919,17667:0:0", -- Light Crossbow
	[15808]="3641:2:1:1:Crossbow::1:0:1287,4602,7976,16715,16919,17667:0:0", -- Fine Light Crossbow
	[15809]="14691:2:1:1:Crossbow::1:0:1287,4602,7976,16715,16919,17667:0:0", -- Heavy Crossbow
	[15810]="10145:2:1:1:Polearm::1:0:1289,4601,44339,47144,47149,47712:0:0", -- Short Spear
	[15811]="27133:2:1:1:Polearm::1:0:1289,4601,44339,47144,47149,47712:0:0", -- Heavy Spear
	[15812]="0:4:2:1:Cloth::1:0::3:0", -- Orchid Amice
	[15813]="0:4:2:1:Mail::1:0::3:0", -- Gold Link Belt
	[15814]="0:2:2:1:OneHandSword::1:0::3:0", -- Hameya's Slayer
	[15815]="0:4:2:1:Cloak::1:0::3:0", -- Hameya's Cloak
	[15822]="0:4:2:1:Leather::1:0::3:0", -- Shadowskin Spaulders
	[15823]="0:4:2:1:Mail::1:0::3:0", -- Bricksteel Gauntlets
	[15824]="0:4:2:1:Cloth::1:0::3:0", -- Astoria Robes
	[15825]="0:4:2:1:Leather::1:0::3:0", -- Traphook Jerkin
	[15826]="0:12:1:1:::1:0::4:0", -- Curative Animal Salve
	[15827]="0:4:2:1:Mail::1:0::3:0", -- Jadescale Breastplate
	[15842]="0:12:1:1:::1:0::4:0", -- Empty Dreadmist Peak Sampler
	[15843]="0:12:1:1:::1:0::4:0", -- Filled Dreadmist Peak Sampler
	[15844]="0:12:1:1:::1:0::4:0", -- Empty Cliffspring Falls Sampler
	[15845]="0:12:1:1:::1:0::4:0", -- Filled Cliffspring Falls Sampler
	[15846]="0:7:1:1:Device::1:0::0:0", -- Salt Shaker
	[15847]="0:12:1:1:::1:0::4:0", -- Quel'Thalas Registry
	[15848]="0:12:1:1:::1:0::4:0", -- Crate of Ghost Magnets
	[15849]="0:12:1:20:::1:0::4:0", -- Ghost-o-Plasm
	[15850]="0:12:1:1:::1:0::4:0", -- Patch of Duskwing's Fur
	[15851]="0:12:1:20:::1:0::4:0", -- Lunar Fungus
	[15852]="0:12:1:20:::1:0::4:0", -- Kodo Horn
	[15853]="0:2:3:1:OneHandAxe::1:0::3:0", -- Windreaper
	[15854]="0:2:3:1:Stave::1:0::3:0", -- Dancing Sliver
	[15855]="0:4:3:1:Ring::1:0::3:0", -- Ring of Protection
	[15856]="0:4:3:1:Amulet::1:0::3:0", -- Archlight Talisman
	[15857]="0:4:3:1:OffHandFrill::1:0::3:0", -- Magebane Scion
	[15858]="0:4:3:1:Cloth::1:0::3:0", -- Freewind Gloves
	[15859]="0:4:3:1:Mail::1:0::3:0", -- Seapost Girdle
	[15860]="0:4:3:1:Plate::1:0::3:0", -- Blinkstrike Armguards
	[15861]="0:4:3:1:Leather::1:0::3:0", -- Swiftfoot Treads
	[15862]="0:2:2:1:OneHandAxe::1:0::3:0", -- Blitzcleaver
	[15863]="0:2:2:1:OneHandMace::1:0::3:0", -- Grave Scepter
	[15864]="0:4:2:1:Cloth::1:0::3:0", -- Condor Bracers
	[15865]="0:4:2:1:Shield::1:0::3:0", -- Anchorhold Buckler
	[15866]="0:4:2:1:OffHandFrill::1:0::3:0", -- Veildust Medicine Bag
	[15867]="0:4:3:1:Trinket::1:0::3:0", -- Prismcharm
	[15868]="0:12:1:1:::1:0::4:0", -- The Grand Crusader's Command
	[15869]="0:13:2:20:::1:0::0:0", -- Silver Skeleton Key
	[15870]="0:13:2:20:::1:0::0:0", -- Golden Skeleton Key
	[15871]="0:13:2:20:::1:0::0:0", -- Truesilver Skeleton Key
	[15872]="0:13:2:20:::1:0::0:0", -- Arcanite Skeleton Key
	[15873]="0:4:3:1:Trinket::1:0::3:0", -- Ragged John's Neverending Cup
	[15874]="0:7:1:20:Other::1:0::4:0", -- Soft-Shelled Clam
	[15875]="0:12:1:1:::1:0::3:0", -- Rotten Apple
	[15876]="0:12:1:1:::1:0::4:0", -- Nathanos' Chest
	[15877]="0:12:1:1:::1:0::4:0", -- Shrine Bauble
	[15878]="0:13:1:1:::1:0::4:0", -- Rackmore's Silver Key
	[15879]="0:12:1:1:::1:0::4:0", -- Overlord Ror's Claw
	[15880]="0:12:1:1:::1:0::4:0", -- Head of Ramstein the Gorger
	[15881]="0:13:1:1:::1:0::4:0", -- Rackmore's Golden Key
	[15882]="0:12:1:1:::1:0::4:0", -- Half Pendant of Aquatic Endurance
	[15883]="0:12:1:1:::1:0::4:0", -- Half Pendant of Aquatic Agility
	[15884]="0:12:1:1:::1:0::4:0", -- Augustus' Receipt Book
	[15885]="0:12:1:1:::1:0::4:0", -- Pendant of the Sea Lion
	[15886]="0:12:1:1:::1:0::3:0", -- Timolain's Phylactery
	[15887]="0:4:2:1:Shield::1:0::2:0", -- Heroic Guard
	[15890]="0:4:2:1:Shield::1:0::2:0", -- Vanguard Shield
	[15891]="0:4:2:1:Shield::1:0::2:0", -- Hulking Shield
	[15892]="0:4:2:1:Shield::1:0::2:0", -- Slayer's Shield
	[15893]="0:4:2:1:Shield::1:0::2:0", -- Prospector's Buckler
	[15894]="0:4:2:1:Shield::1:0::2:0", -- Bristlebark Buckler
	[15895]="0:4:1:1:Shield::1:0::0:0", -- Burnt Buckler
	[15902]="80000:15:1:1:Junk::1:1:12384:3:0", -- A Crazy Grab Bag
	[15903]="8118:2:1:1:FistWeapon::1:0:3361,4203,7976,19047:0:0", -- Right-Handed Claw
	[15904]="21708:2:1:1:FistWeapon::1:0:3361,4203,7976,19047:0:0", -- Right-Handed Blades
	[15905]="2130:2:1:1:FistWeapon::1:0:3361,4203,7976,19047:0:0", -- Right-Handed Brass Knuckles
	[15906]="2138:2:1:1:FistWeapon::1:0:3361,4203,7976,19047:0:0", -- Left-Handed Brass Knuckles
	[15907]="8237:2:1:1:FistWeapon::1:0:3361,4203,7976,19047:0:0", -- Left-Handed Claw
	[15908]="0:12:1:1:::1:0::4:0", -- Taming Rod
	[15909]="22107:2:1:1:FistWeapon::1:0:3361,4203,7976,19047:0:0", -- Left-Handed Blades
	[15911]="0:12:1:1:::1:0::4:0", -- Taming Rod
	[15912]="0:4:2:1:OffHandFrill::1:0::2:0", -- Buccaneer's Orb
	[15913]="0:12:1:1:::1:0::4:0", -- Taming Rod
	[15914]="0:12:1:1:::1:0::4:0", -- Taming Rod
	[15915]="0:12:1:1:::1:0::4:0", -- Taming Rod
	[15916]="0:12:1:1:::1:0::4:0", -- Taming Rod
	[15917]="0:12:1:1:::1:0::4:0", -- Taming Rod
	[15918]="0:4:2:1:OffHandFrill::1:0::2:0", -- Conjurer's Sphere
	[15919]="0:12:1:1:::1:0::4:0", -- Taming Rod
	[15920]="0:12:1:1:::1:0::4:0", -- Taming Rod
	[15921]="0:12:1:1:::1:0::4:0", -- Taming Rod
	[15922]="0:12:1:1:::1:0::4:0", -- Taming Rod
	[15923]="0:12:1:1:::1:0::4:0", -- Taming Rod
	[15924]="0:12:1:10:::1:0::4:0", -- Soft-Shelled Clam Meat
	[15925]="0:4:2:1:OffHandFrill::1:0::2:0", -- Journeyman's Stave
	[15926]="0:4:2:1:OffHandFrill::1:0::2:0", -- Spellbinder Orb
	[15927]="0:4:2:1:OffHandFrill::1:0::2:0", -- Bright Sphere
	[15928]="0:4:2:1:OffHandFrill::1:0::2:0", -- Silver-Thread Rod
	[15929]="0:4:2:1:OffHandFrill::1:0::2:0", -- Nightsky Orb
	[15930]="0:4:2:1:OffHandFrill::1:0::2:0", -- Imperial Red Scepter
	[15931]="0:4:2:1:OffHandFrill::1:0::2:0", -- Arcane Star
	[15932]="0:4:2:1:OffHandFrill::1:0::2:0", -- Disciple's Stein
	[15933]="0:4:2:1:OffHandFrill::1:0::2:0", -- Simple Branch
	[15934]="0:4:2:1:OffHandFrill::1:0::2:0", -- Sage's Stave
	[15935]="0:4:2:1:OffHandFrill::1:0::2:0", -- Durable Rod
	[15936]="0:4:2:1:OffHandFrill::1:0::2:0", -- Duskwoven Branch
	[15937]="0:4:2:1:OffHandFrill::1:0::2:0", -- Hibernal Sphere
	[15938]="0:4:2:1:OffHandFrill::1:0::2:0", -- Mystical Orb
	[15939]="0:4:2:1:OffHandFrill::1:0::2:0", -- Councillor's Scepter
	[15940]="0:4:2:1:OffHandFrill::1:0::2:0", -- Elegant Scepter
	[15941]="0:4:2:1:OffHandFrill::1:0::2:0", -- High Councillor's Scepter
	[15942]="0:4:2:1:OffHandFrill::1:0::2:0", -- Master's Rod
	[15943]="0:4:2:1:Shield::1:0::2:0", -- Imbued Shield
	[15944]="0:4:2:1:OffHandFrill::1:0::2:0", -- Ancestral Orb
	[15945]="0:4:2:1:OffHandFrill::1:0::2:0", -- Runic Stave
	[15946]="0:4:2:1:OffHandFrill::1:0::2:0", -- Mystic's Sphere
	[15947]="0:4:2:1:OffHandFrill::1:0::2:0", -- Sanguine Star
	[15962]="0:4:2:1:OffHandFrill::1:0::2:0", -- Satyr's Rod
	[15963]="0:4:2:1:OffHandFrill::1:0::2:0", -- Stonecloth Branch
	[15964]="0:4:2:1:OffHandFrill::1:0::2:0", -- Silksand Star
	[15965]="0:4:2:1:OffHandFrill::1:0::2:0", -- Windchaser Orb
	[15966]="0:4:2:1:OffHandFrill::1:0::2:0", -- Venomshroud Orb
	[15967]="0:4:2:1:OffHandFrill::1:0::2:0", -- Highborne Star
	[15968]="0:4:2:1:OffHandFrill::1:0::2:0", -- Elunarian Sphere
	[15969]="0:4:2:1:OffHandFrill::1:0::2:0", -- Beaded Orb
	[15970]="0:4:2:1:OffHandFrill::1:0::2:0", -- Native Branch
	[15971]="0:4:2:1:OffHandFrill::1:0::2:0", -- Aboriginal Rod
	[15972]="0:4:2:1:OffHandFrill::1:0::2:0", -- Ritual Stein
	[15973]="0:4:2:1:OffHandFrill::1:0::2:0", -- Watcher's Star
	[15974]="0:4:2:1:OffHandFrill::1:0::2:0", -- Pagan Rod
	[15975]="0:4:2:1:OffHandFrill::1:0::2:0", -- Raincaller Scepter
	[15976]="0:4:2:1:OffHandFrill::1:0::2:0", -- Thistlefur Branch
	[15977]="0:4:2:1:OffHandFrill::1:0::2:0", -- Vital Orb
	[15978]="0:4:2:1:OffHandFrill::1:0::2:0", -- Geomancer's Rod
	[15979]="0:4:2:1:OffHandFrill::1:0::2:0", -- Flamecloth Stave
	[15980]="0:4:2:1:OffHandFrill::1:0::2:0", -- Darkmist Orb
	[15981]="0:4:2:1:OffHandFrill::1:0::2:0", -- Lunar Sphere
	[15982]="0:4:2:1:OffHandFrill::1:0::2:0", -- Bloodwoven Rod
	[15983]="0:4:2:1:OffHandFrill::1:0::2:0", -- Gaea's Scepter
	[15984]="0:4:2:1:OffHandFrill::1:0::2:0", -- Opulent Scepter
	[15985]="0:4:2:1:OffHandFrill::1:0::2:0", -- Arachnidian Branch
	[15986]="0:4:2:1:OffHandFrill::1:0::2:0", -- Bonecaster's Star
	[15987]="0:4:2:1:OffHandFrill::1:0::2:0", -- Astral Orb
	[15988]="0:4:2:1:OffHandFrill::1:0::2:0", -- Resplendent Orb
	[15989]="0:4:2:1:OffHandFrill::1:0::2:0", -- Eternal Rod
	[15990]="0:4:2:1:Shield::1:0::2:0", -- Enduring Shield
	[15991]="0:4:2:1:Shield::1:0::2:0", -- Warleader's Shield
	[15992]="0:7:1:20:Part:202:1:0::0:0", -- Dense Blasting Powder
	[15993]="0:7:1:20:Explosive::1:0::0:0", -- Thorium Grenade
	[15994]="0:7:1:10:Part:202:1:0::0:0", -- Thorium Widget
	[15995]="0:2:2:1:Gun::1:0::2:0", -- Thorium Rifle
	[15996]="0:15:1:1:Companion::1:0::0:0", -- Lifelike Mechanical Toad
	[15997]="0:15:0:1000:Junk::1:0::0:0", -- Thorium Shells
	[15998]="0:12:1:1:::1:0::4:0", -- Lewis' Note
	[15999]="0:4:2:1:Cloth::1:0::2:0", -- Spellpower Goggles Xtreme Plus
	[16000]="0:7:1:20:Part:202:1:0::0:0", -- Thorium Tube
	[16001]="0:12:1:1:::1:0::4:0", -- SI:7 Insignia (Fredo)
	[16002]="0:12:1:1:::1:0::4:0", -- SI:7 Insignia (Turyen)
	[16003]="0:12:1:1:::1:0::4:0", -- SI:7 Insignia (Rutger)
	[16004]="0:2:3:1:Gun::1:0::2:0", -- Dark Iron Rifle
	[16005]="0:7:1:20:Explosive::1:0::0:0", -- Dark Iron Bomb
	[16006]="0:7:1:10:Part:202:1:0::0:0", -- Delicate Arcanite Converter
	[16007]="0:2:3:1:Gun::1:0::2:0", -- Flawless Arcanite Rifle
	[16008]="0:4:2:1:Cloth::1:0::2:0", -- Master Engineer's Goggles
	[16009]="0:4:2:1:Amulet::1:0::2:0", -- Voice Amplification Modulator
	[16022]="0:4:3:1:Trinket::1:0::2:0", -- Arcanite Dragonling
	[16023]="0:7:1:10:Device::1:0::0:0", -- Masterwork Target Dummy
	[16039]="0:2:3:1:TwoHandSword::1:0::2:0", -- Ta'Kierthan Songblade
	[16040]="0:7:1:20:Explosive::1:0::0:0", -- Arcane Bomb
	[16041]="0:9:1:1:Engineering::1:0::0:0", -- Schematic: Thorium Grenade
	[16042]="0:9:1:1:Engineering::1:0::0:0", -- Schematic: Thorium Widget
	[16043]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Thorium Rifle
	[16044]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Lifelike Mechanical Toad
	[16045]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Spellpower Goggles Xtreme Plus
	[16046]="16000:9:1:1:Engineering::1:1:11185:0:0", -- Schematic: Masterwork Target Dummy
	[16047]="0:9:1:1:Engineering::1:0::0:0", -- Schematic: Thorium Tube
	[16048]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Dark Iron Rifle
	[16049]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Dark Iron Bomb
	[16050]="20000:9:1:1:Engineering::1:1:11185:0:0", -- Schematic: Delicate Arcanite Converter
	[16051]="0:15:0:1:Junk::1:0::0:0", -- Ruined Schematic: Thorium Shells
	[16052]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Voice Amplification Modulator
	[16053]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Master Engineer's Goggles
	[16054]="24000:9:2:1:Engineering::1:1:35826:0:0", -- Schematic: Arcanite Dragonling
	[16055]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Arcane Bomb
	[16056]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Flawless Arcanite Rifle
	[16058]="0:4:3:1:Ring::1:0::3:0", -- Fordring's Seal
	[16059]="400:4:1:1:Shirt::1:0:1214,1291,3317,3486,3554,4558,5108,8358,16623,16631,16716,43436:0:0", -- Common Brown Shirt
	[16060]="400:4:1:1:Shirt::1:0:1214,1291,3317,3486,3554,4558,5108,8358,16623,16631,16716,43436:0:0", -- Common White Shirt
	[16072]="0:9:1:1:Cooking::1:0::0:0", -- Expert Cookbook
	[16083]="0:9:1:1:Fishing::1:0::0:0", -- Expert Fishing - The Bass and You
	[16084]="0:9:1:1:FirstAid::1:0::0:0", -- Expert First Aid - Under Wraps
	[16085]="0:9:1:1:FirstAid::1:0::0:0", -- Artisan First Aid - Heal Thyself
	[16110]="12000:9:1:1:Cooking::1:0:2803,11187:0:0", -- Recipe: Monster Omelet
	[16111]="12000:9:1:1:Cooking::1:0:989,1149,4305:0:0", -- Recipe: Spiced Chili Crab
	[16112]="0:9:1:1:FirstAid::1:0::0:0", -- Manual: Heavy Silk Bandage
	[16113]="0:9:1:1:FirstAid::1:0::0:0", -- Manual: Mageweave Bandage
	[16114]="0:12:1:1:::1:0::4:0", -- Foreman's Blackjack
	[16115]="0:12:1:1:::1:0::4:0", -- Osric's Crate
	[16166]="25:0:1:20:FoodDrink::5:0:2303,3961,4167,4181,4266,6091,7941,12019,12026,33209:0:0", -- Bean Soup
	[16167]="125:0:1:20:FoodDrink::5:0:2303,3961,4167,4181,4266,6091,7941,12019,12026,33209:0:0", -- Versicolor Treat
	[16168]="2000:0:1:20:FoodDrink::5:0:2303,3961,4167,4181,4266,6091,7941,12019,12026,33209:0:0", -- Heaven Peach
	[16169]="1000:0:1:20:FoodDrink::5:0:2303,3961,4167,4181,4266,6091,7941,12019,12026,33209:0:0", -- Wild Ricecake
	[16170]="500:0:1:20:FoodDrink::5:0:2303,3961,4167,4181,4266,6091,7941,12019,12026,33209:0:0", -- Steamed Mandu
	[16171]="0:0:1:20:FoodDrink::1:0::0:0", -- Shinsollo
	[16189]="0:12:1:1:::1:0::4:0", -- Maggran's Reserve Letter
	[16190]="0:12:1:1:::1:0::4:0", -- Bloodfury Ripper's Remains
	[16192]="0:12:1:1:::1:0::4:0", -- Besseleth's Fang
	[16202]="0:7:2:10:Enchanting:333:1:0::0:0", -- Lesser Eternal Essence
	[16203]="0:7:2:10:Enchanting:333,197:1:0::0:0", -- Greater Eternal Essence
	[16204]="0:7:1:20:Enchanting:333:1:0::0:0", -- Illusion Dust
	[16205]="0:12:1:10:::1:0::4:0", -- Gaea Seed
	[16206]="0:7:1:1:Enchanting:333:1:0::0:0", -- Arcanite Rod
	[16207]="0:7:2:1:Enchanting:333:1:0::3:0", -- Runed Arcanite Rod
	[16208]="0:12:1:1:::1:0::4:0", -- Enchanted Gaea Seeds
	[16209]="0:12:1:1:::1:0::4:0", -- Morris's Order
	[16210]="0:12:1:1:::1:0::4:0", -- Gordon's Crate
	[16214]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Bracer - Greater Intellect
	[16215]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Boots - Greater Stamina
	[16216]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Cloak - Greater Resistance
	[16217]="12000:9:1:1:Enchanting::1:1:4229,4561:3:0", -- Formula: Enchant Shield - Greater Stamina
	[16218]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Bracer - Superior Spirit
	[16219]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Gloves - Greater Agility
	[16220]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Boots - Spirit
	[16221]="16000:9:1:1:Enchanting::1:1:11189:0:0", -- Formula: Enchant Chest - Major Health
	[16222]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Shield - Superior Spirit
	[16223]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Weapon - Icy Chill
	[16224]="20000:9:1:1:Enchanting::1:1:12022:0:0", -- Formula: Enchant Cloak - Superior Defense
	[16242]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Chest - Major Mana
	[16243]="0:9:1:1:Enchanting::1:0::0:0", -- Formula: Runed Arcanite Rod
	[16244]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Gloves - Greater Strength
	[16245]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Boots - Greater Agility
	[16246]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Bracer - Superior Strength
	[16247]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant 2H Weapon - Superior Impact
	[16248]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Weapon - Unholy
	[16249]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant 2H Weapon - Major Intellect
	[16250]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Weapon - Superior Striking
	[16251]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Bracer - Superior Stamina
	[16252]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Weapon - Crusader
	[16253]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Chest - Greater Stats
	[16254]="0:9:3:1:Enchanting::1:0::0:0", -- Formula: Enchant Weapon - Lifestealing
	[16255]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant 2H Weapon - Major Spirit
	[16262]="0:12:1:1:::1:0::4:0", -- Dolanaar Recipe Book
	[16263]="0:12:1:1:::1:0::4:0", -- Sister Aquinne's Note
	[16282]="0:0:1:1:Consumable::1:0::4:0", -- Bundle of Hides
	[16283]="0:12:1:1:::1:0::4:0", -- Ahanu's Leather Goods
	[16302]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Firebolt (Rank 2)
	[16303]="0:12:2:1:::1:0::3:0", -- Ursangous' Paw
	[16304]="0:12:2:1:::1:0::3:0", -- Shadumbra's Head
	[16305]="0:12:2:1:::1:0::3:0", -- Sharptalon's Claw
	[16306]="0:12:1:1:::1:0::4:0", -- Grimtak's Meats
	[16307]="0:12:1:1:::1:0::4:0", -- Gryshka's Letter
	[16309]="0:4:3:1:Amulet::1:0::3:0", -- Drakefire Amulet
	[16310]="0:12:1:1:::1:0::4:0", -- Gremlock's List
	[16311]="0:12:1:1:::1:0::4:0", -- Honorary Cleavers
	[16312]="0:12:1:10:::1:0::4:0", -- Incendrites
	[16313]="0:12:1:1:::1:0::4:0", -- Felix's Chest
	[16314]="0:12:1:1:::1:0::4:0", -- Felix's Bucket of Bolts
	[16316]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Firebolt (Rank 3)
	[16317]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Firebolt (Rank 4)
	[16318]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Firebolt (Rank 5)
	[16319]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Firebolt (Rank 6)
	[16320]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Firebolt (Rank 7)
	[16321]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Blood Pact (Rank 1)
	[16322]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Blood Pact (Rank 2)
	[16323]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Blood Pact (Rank 3)
	[16324]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Blood Pact (Rank 4)
	[16325]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Blood Pact (Rank 5)
	[16326]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Fire Shield (Rank 1)
	[16327]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Fire Shield (Rank 2)
	[16328]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Fire Shield (Rank 3)
	[16329]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Fire Shield (Rank 4)
	[16330]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Fire Shield (Rank 5)
	[16331]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Phase Shift
	[16332]="0:12:1:1:::1:0::4:0", -- Thazz'ril's Pick
	[16333]="0:12:1:1:::1:0::4:0", -- Samuel's Remains
	[16335]="1:4:3:1:Amulet::1:0:12795:3:0", -- Senior Sergeant's Insignia
	[16341]="42850:4:3:1:Cloak::1:0:12795:3:0", -- Sergeant's Cloak
	[16342]="79482:4:3:1:Cloak::1:0:12785,12805:3:0", -- Sergeant's Cape
	[16345]="428895:2:4:1:OneHandSword::1:0:12794:3:0", -- High Warlord's Blade
	[16346]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Torment (Rank 2)
	[16347]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Torment (Rank 3)
	[16348]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Torment (Rank 4)
	[16349]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Torment (Rank 5)
	[16350]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Torment (Rank 6)
	[16351]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Sacrifice (Rank 1)
	[16352]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Sacrifice (Rank 2)
	[16353]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Sacrifice (Rank 3)
	[16354]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Sacrifice (Rank 4)
	[16355]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Sacrifice (Rank 5)
	[16356]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Sacrifice (Rank 6)
	[16357]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Consume Shadows (Rank 1)
	[16358]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Consume Shadows (Rank 2)
	[16359]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Consume Shadows (Rank 3)
	[16360]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Consume Shadows (Rank 4)
	[16361]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Consume Shadows (Rank 5)
	[16362]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Consume Shadows (Rank 6)
	[16363]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Suffering (Rank 1)
	[16364]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Suffering (Rank 2)
	[16365]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Suffering (Rank 3)
	[16366]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Suffering (Rank 4)
	[16368]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Lash of Pain (Rank 2)
	[16369]="0:4:3:1:Cloth::1:0::3:0", -- Knight-Lieutenant's Silk Boots
	[16371]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Lash of Pain (Rank 3)
	[16372]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Lash of Pain (Rank 4)
	[16373]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Lash of Pain (Rank 5)
	[16374]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Lash of Pain (Rank 6)
	[16375]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Soothing Kiss (Rank 1)
	[16376]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Soothing Kiss (Rank 2)
	[16377]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Soothing Kiss (Rank 3)
	[16378]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Soothing Kiss (Rank 4)
	[16379]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Seduction
	[16380]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Lesser Invisibility
	[16381]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Devour Magic (Rank 2)
	[16382]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Devour Magic (Rank 3)
	[16383]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Devour Magic (Rank 4)
	[16384]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Tainted Blood (Rank 1)
	[16385]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Tainted Blood (Rank 2)
	[16386]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Tainted Blood (Rank 3)
	[16387]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Tainted Blood (Rank 4)
	[16388]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Spell Lock (Rank 1)
	[16389]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Spell Lock (Rank 2)
	[16390]="0:9:1:1:Book::1:0::3:0", -- Grimoire of Paranoia
	[16391]="0:4:3:1:Cloth::1:0::3:0", -- Knight-Lieutenant's Silk Gloves
	[16392]="0:4:3:1:Leather::1:0::3:0", -- Knight-Lieutenant's Leather Boots
	[16393]="0:4:3:1:Leather::1:0::3:0", -- Knight-Lieutenant's Dragonhide Footwraps
	[16396]="0:4:3:1:Leather::1:0::3:0", -- Knight-Lieutenant's Leather Gauntlets
	[16397]="0:4:3:1:Leather::1:0::3:0", -- Knight-Lieutenant's Dragonhide Gloves
	[16401]="0:4:3:1:Mail::1:0::3:0", -- Knight-Lieutenant's Chain Boots
	[16403]="0:4:3:1:Mail::1:0::3:0", -- Knight-Lieutenant's Chain Gauntlets
	[16405]="0:4:3:1:Plate::1:0::3:0", -- Knight-Lieutenant's Plate Boots
	[16406]="0:4:3:1:Plate::1:0::3:0", -- Knight-Lieutenant's Plate Gauntlets
	[16408]="0:12:2:1:::1:0::3:0", -- Befouled Water Globe
	[16409]="0:4:3:1:Plate::1:0::3:0", -- Knight-Lieutenant's Lamellar Sabatons
	[16410]="0:4:3:1:Plate::1:0::3:0", -- Knight-Lieutenant's Lamellar Gauntlets
	[16413]="0:4:3:1:Cloth::1:0::3:0", -- Knight-Captain's Silk Raiment
	[16414]="0:4:3:1:Cloth::1:0::3:0", -- Knight-Captain's Silk Leggings
	[16415]="0:4:3:1:Cloth::1:0::3:0", -- Lieutenant Commander's Silk Spaulders
	[16416]="0:4:3:1:Cloth::1:0::3:0", -- Lieutenant Commander's Crown
	[16417]="0:4:3:1:Leather::1:0::3:0", -- Knight-Captain's Leather Armor
	[16418]="0:4:3:1:Leather::1:0::3:0", -- Lieutenant Commander's Leather Veil
	[16419]="0:4:3:1:Leather::1:0::3:0", -- Knight-Captain's Leather Legguards
	[16420]="0:4:3:1:Leather::1:0::3:0", -- Lieutenant Commander's Leather Spaulders
	[16421]="0:4:3:1:Leather::1:0::3:0", -- Knight-Captain's Dragonhide Tunic
	[16422]="0:4:3:1:Leather::1:0::3:0", -- Knight-Captain's Dragonhide Leggings
	[16423]="0:4:3:1:Leather::1:0::3:0", -- Lieutenant Commander's Dragonhide Epaulets
	[16424]="0:4:3:1:Leather::1:0::3:0", -- Lieutenant Commander's Dragonhide Shroud
	[16425]="0:4:3:1:Mail::1:0::3:0", -- Knight-Captain's Chain Hauberk
	[16426]="0:4:3:1:Mail::1:0::3:0", -- Knight-Captain's Chain Leggings
	[16427]="0:4:3:1:Mail::1:0::3:0", -- Lieutenant Commander's Chain Pauldrons
	[16428]="0:4:3:1:Mail::1:0::3:0", -- Lieutenant Commander's Chain Helmet
	[16429]="0:4:3:1:Plate::1:0::3:0", -- Lieutenant Commander's Plate Helm
	[16430]="0:4:3:1:Plate::1:0::3:0", -- Knight-Captain's Plate Chestguard
	[16431]="0:4:3:1:Plate::1:0::3:0", -- Knight-Captain's Plate Leggings
	[16432]="0:4:3:1:Plate::1:0::3:0", -- Lieutenant Commander's Plate Pauldrons
	[16433]="0:4:3:1:Plate::1:0::3:0", -- Knight-Captain's Lamellar Breastplate
	[16434]="0:4:3:1:Plate::1:0::3:0", -- Lieutenant Commander's Lamellar Headguard
	[16435]="0:4:3:1:Plate::1:0::3:0", -- Knight-Captain's Lamellar Leggings
	[16436]="0:4:3:1:Plate::1:0::3:0", -- Lieutenant Commander's Lamellar Shoulders
	[16437]="118209:4:4:1:Cloth::1:0:12785:3:0", -- Marshal's Silk Footwraps
	[16440]="79648:4:4:1:Cloth::1:0:12785:3:0", -- Marshal's Silk Gloves
	[16441]="124253:4:4:1:Cloth::1:0:12785:3:0", -- Field Marshal's Coronet
	[16442]="160413:4:4:1:Cloth::1:0:12785:3:0", -- Marshal's Silk Leggings
	[16443]="155156:4:4:1:Cloth::1:0:12785:3:0", -- Field Marshal's Silk Vestments
	[16444]="116807:4:4:1:Cloth::1:0:12785:3:0", -- Field Marshal's Silk Spaulders
	[16446]="141936:4:4:1:Leather::1:0:12785:3:0", -- Marshal's Leather Footguards
	[16448]="95332:4:4:1:Leather::1:0:12785:3:0", -- Marshal's Dragonhide Gauntlets
	[16449]="148745:4:4:1:Leather::1:0:12785:3:0", -- Field Marshal's Dragonhide Spaulders
	[16450]="192061:4:4:1:Leather::1:0:12785:3:0", -- Marshal's Dragonhide Legguards
	[16451]="149830:4:4:1:Leather::1:0:12785:3:0", -- Field Marshal's Dragonhide Helmet
	[16452]="200507:4:4:1:Leather::1:0:12785:3:0", -- Field Marshal's Dragonhide Breastplate
	[16453]="201241:4:4:1:Leather::1:0:12785:3:0", -- Field Marshal's Leather Chestpiece
	[16454]="97436:4:4:1:Leather::1:0:12785:3:0", -- Marshal's Leather Handgrips
	[16455]="152016:4:4:1:Leather::1:0:12785:3:0", -- Field Marshal's Leather Mask
	[16456]="196288:4:4:1:Leather::1:0:12785:3:0", -- Marshal's Leather Leggings
	[16457]="153101:4:4:1:Leather::1:0:12785:3:0", -- Field Marshal's Leather Epaulets
	[16459]="138235:4:4:1:Leather::1:0:12785:3:0", -- Marshal's Dragonhide Boots
	[16462]="168521:4:4:1:Mail::1:0:12785:3:0", -- Marshal's Chain Boots
	[16463]="112275:4:4:1:Mail::1:0:12785:3:0", -- Marshal's Chain Grips
	[16465]="175835:4:4:1:Mail::1:0:12785:3:0", -- Field Marshal's Chain Helm
	[16466]="235328:4:4:1:Mail::1:0:12785:3:0", -- Field Marshal's Chain Breastplate
	[16467]="227925:4:4:1:Mail::1:0:12785:3:0", -- Marshal's Chain Legguards
	[16468]="178606:4:4:1:Mail::1:0:12785:3:0", -- Field Marshal's Chain Spaulders
	[16471]="135695:4:4:1:Plate::1:0:12785:3:0", -- Marshal's Lamellar Gloves
	[16472]="202723:4:4:1:Plate::1:0:12785:3:0", -- Marshal's Lamellar Boots
	[16473]="281682:4:4:1:Plate::1:0:12785:3:0", -- Field Marshal's Lamellar Chestplate
	[16474]="211628:4:4:1:Plate::1:0:12785:3:0", -- Field Marshal's Lamellar Faceguard
	[16475]="280883:4:4:1:Plate::1:0:12785:3:0", -- Marshal's Lamellar Legplates
	[16476]="197853:4:4:1:Plate::1:0:12785:3:0", -- Field Marshal's Lamellar Pauldrons
	[16477]="265334:4:4:1:Plate::1:0:12785:3:0", -- Field Marshal's Plate Armor
	[16478]="199390:4:4:1:Plate::1:0:12785:3:0", -- Field Marshal's Plate Helm
	[16479]="258012:4:4:1:Plate::1:0:12785:3:0", -- Marshal's Plate Legguards
	[16480]="200907:4:4:1:Plate::1:0:12785:3:0", -- Field Marshal's Plate Shoulderguards
	[16483]="196087:4:4:1:Plate::1:0:12785:3:0", -- Marshal's Plate Boots
	[16484]="132207:4:4:1:Plate::1:0:12785:3:0", -- Marshal's Plate Gauntlets
	[16485]="0:4:3:1:Cloth::1:0::3:0", -- Blood Guard's Silk Footwraps
	[16486]="51262:4:3:1:Cloth::1:0:12795:3:0", -- First Sergeant's Silk Cuffs
	[16487]="0:4:3:1:Cloth::1:0::3:0", -- Blood Guard's Silk Gloves
	[16489]="0:4:3:1:Cloth::1:0::3:0", -- Champion's Silk Hood
	[16490]="0:4:3:1:Cloth::1:0::3:0", -- Legionnaire's Silk Pants
	[16491]="0:4:3:1:Cloth::1:0::3:0", -- Legionnaire's Silk Robes
	[16492]="0:4:3:1:Cloth::1:0::3:0", -- Champion's Silk Shoulderpads
	[16494]="0:4:3:1:Leather::1:0::3:0", -- Blood Guard's Dragonhide Boots
	[16496]="0:4:3:1:Leather::1:0::3:0", -- Blood Guard's Dragonhide Gauntlets
	[16497]="61927:4:3:1:Leather::1:0:12795:3:0", -- First Sergeant's Leather Armguards
	[16498]="0:4:3:1:Leather::1:0::3:0", -- Blood Guard's Leather Treads
	[16499]="0:4:3:1:Leather::1:0::3:0", -- Blood Guard's Leather Vices
	[16501]="0:4:3:1:Leather::1:0::3:0", -- Champion's Dragonhide Spaulders
	[16502]="0:4:3:1:Leather::1:0::3:0", -- Legionnaire's Dragonhide Trousers
	[16503]="0:4:3:1:Leather::1:0::3:0", -- Champion's Dragonhide Helm
	[16504]="0:4:3:1:Leather::1:0::3:0", -- Legionnaire's Dragonhide Breastplate
	[16505]="0:4:3:1:Leather::1:0::3:0", -- Legionnaire's Leather Hauberk
	[16506]="0:4:3:1:Leather::1:0::3:0", -- Champion's Leather Headguard
	[16507]="0:4:3:1:Leather::1:0::3:0", -- Champion's Leather Mantle
	[16508]="0:4:3:1:Leather::1:0::3:0", -- Legionnaire's Leather Leggings
	[16509]="0:4:3:1:Plate::1:0::3:0", -- Blood Guard's Plate Boots
	[16510]="0:4:3:1:Plate::1:0::3:0", -- Blood Guard's Plate Gloves
	[16513]="0:4:3:1:Plate::1:0::3:0", -- Legionnaire's Plate Armor
	[16514]="0:4:3:1:Plate::1:0::3:0", -- Champion's Plate Headguard
	[16515]="0:4:3:1:Plate::1:0::3:0", -- Legionnaire's Plate Legguards
	[16516]="0:4:3:1:Plate::1:0::3:0", -- Champion's Plate Pauldrons
	[16518]="0:4:3:1:Mail::1:0::3:0", -- Blood Guard's Mail Walkers
	[16519]="0:4:3:1:Mail::1:0::3:0", -- Blood Guard's Mail Grips
	[16521]="0:4:3:1:Mail::1:0::3:0", -- Champion's Mail Helm
	[16522]="0:4:3:1:Mail::1:0::3:0", -- Legionnaire's Mail Chestpiece
	[16523]="0:4:3:1:Mail::1:0::3:0", -- Legionnaire's Mail Leggings
	[16524]="0:4:3:1:Mail::1:0::3:0", -- Champion's Mail Shoulders
	[16525]="0:4:3:1:Mail::1:0::3:0", -- Legionnaire's Chain Breastplate
	[16526]="0:4:3:1:Mail::1:0::3:0", -- Champion's Chain Headguard
	[16527]="0:4:3:1:Mail::1:0::3:0", -- Legionnaire's Chain Leggings
	[16528]="0:4:3:1:Mail::1:0::3:0", -- Champion's Chain Pauldrons
	[16530]="0:4:3:1:Mail::1:0::3:0", -- Blood Guard's Chain Gauntlets
	[16531]="0:4:3:1:Mail::1:0::3:0", -- Blood Guard's Chain Boots
	[16532]="80648:4:3:1:Mail::1:0:12795:3:0", -- First Sergeant's Mail Wristguards
	[16533]="123825:4:4:1:Cloth::1:0:12795:3:0", -- Warlord's Silk Cowl
	[16534]="159877:4:4:1:Cloth::1:0:12795:3:0", -- General's Silk Trousers
	[16535]="166274:4:4:1:Cloth::1:0:12795:3:0", -- Warlord's Silk Raiment
	[16536]="113239:4:4:1:Cloth::1:0:12795:3:0", -- Warlord's Silk Amice
	[16539]="113572:4:4:1:Cloth::1:0:12795:3:0", -- General's Silk Boots
	[16540]="75990:4:4:1:Cloth::1:0:12795:3:0", -- General's Silk Handguards
	[16541]="276658:4:4:1:Plate::1:0:12795:3:0", -- Warlord's Plate Armor
	[16542]="207867:4:4:1:Plate::1:0:12795:3:0", -- Warlord's Plate Headpiece
	[16543]="268939:4:4:1:Plate::1:0:12795:3:0", -- General's Plate Leggings
	[16544]="209384:4:4:1:Plate::1:0:12795:3:0", -- Warlord's Plate Shoulders
	[16545]="202783:4:4:1:Plate::1:0:12795:3:0", -- General's Plate Boots
	[16548]="137702:4:4:1:Plate::1:0:12795:3:0", -- General's Plate Gauntlets
	[16549]="203441:4:4:1:Leather::1:0:12795:3:0", -- Warlord's Dragonhide Hauberk
	[16550]="153131:4:4:1:Leather::1:0:12795:3:0", -- Warlord's Dragonhide Helmet
	[16551]="153681:4:4:1:Leather::1:0:12795:3:0", -- Warlord's Dragonhide Epaulets
	[16552]="198412:4:4:1:Leather::1:0:12795:3:0", -- General's Dragonhide Leggings
	[16554]="149870:4:4:1:Leather::1:0:12795:3:0", -- General's Dragonhide Boots
	[16555]="93218:4:4:1:Leather::1:0:12795:3:0", -- General's Dragonhide Gloves
	[16558]="141420:4:4:1:Leather::1:0:12795:3:0", -- General's Leather Treads
	[16560]="94978:4:4:1:Leather::1:0:12795:3:0", -- General's Leather Mitts
	[16561]="148195:4:4:1:Leather::1:0:12795:3:0", -- Warlord's Leather Helm
	[16562]="148745:4:4:1:Leather::1:0:12795:3:0", -- Warlord's Leather Spaulders
	[16563]="199040:4:4:1:Leather::1:0:12795:3:0", -- Warlord's Leather Breastplate
	[16564]="192769:4:4:1:Leather::1:0:12795:3:0", -- General's Leather Legguards
	[16565]="240609:4:4:1:Mail::1:0:12795:3:0", -- Warlord's Chain Chestpiece
	[16566]="181117:4:4:1:Mail::1:0:12795:3:0", -- Warlord's Chain Helmet
	[16567]="233848:4:4:1:Mail::1:0:12795:3:0", -- General's Chain Legguards
	[16568]="183230:4:4:1:Mail::1:0:12795:3:0", -- Warlord's Chain Shoulders
	[16569]="177445:4:4:1:Mail::1:0:12795:3:0", -- General's Chain Boots
	[16571]="110163:4:4:1:Mail::1:0:12795:3:0", -- General's Chain Gloves
	[16573]="167259:4:4:1:Mail::1:0:12795:3:0", -- General's Mail Boots
	[16574]="111426:4:4:1:Mail::1:0:12795:3:0", -- General's Mail Gauntlets
	[16577]="233591:4:4:1:Mail::1:0:12795:3:0", -- Warlord's Mail Armor
	[16578]="175835:4:4:1:Mail::1:0:12795:3:0", -- Warlord's Mail Helm
	[16579]="227076:4:4:1:Mail::1:0:12795:3:0", -- General's Mail Leggings
	[16580]="177943:4:4:1:Mail::1:0:12795:3:0", -- Warlord's Mail Spaulders
	[16581]="0:12:1:20:::1:0::4:0", -- Resonite Crystal
	[16583]="0:15:0:5:Reagent::1:0::0:0", -- Demonic Figurine
	[16602]="0:12:1:20:::1:0::4:0", -- Troll Charm
	[16603]="0:12:1:1:::1:0::4:0", -- Enchanted Resonite Crystal
	[16604]="0:4:2:1:Cloth::1:0::3:0", -- Moon Robes of Elune
	[16605]="0:4:2:1:Cloth::1:0::3:0", -- Friar's Robes of the Light
	[16606]="0:4:2:1:Cloth::1:0::3:0", -- Juju Hex Robes
	[16607]="0:4:2:1:Cloth::1:0::3:0", -- Acolyte's Sacrificial Robes
	[16608]="0:4:3:1:Leather::1:0::3:0", -- Aquarius Belt
	[16622]="0:2:2:1:Bow::1:0::3:0", -- Thornflinger
	[16623]="0:4:2:1:Amulet::1:0::3:0", -- Opaline Medallion
	[16642]="0:12:1:1:::1:0::3:0", -- Shredder Operating Manual - Chapter 1
	[16643]="0:12:1:1:::1:0::3:0", -- Shredder Operating Manual - Chapter 2
	[16644]="0:12:1:1:::1:0::3:0", -- Shredder Operating Manual - Chapter 3
	[16645]="0:12:1:1:::1:0::0:0", -- Shredder Operating Manual - Page 1
	[16646]="0:12:1:1:::1:0::0:0", -- Shredder Operating Manual - Page 2
	[16647]="0:12:1:1:::1:0::0:0", -- Shredder Operating Manual - Page 3
	[16648]="0:12:1:1:::1:0::0:0", -- Shredder Operating Manual - Page 4
	[16649]="0:12:1:1:::1:0::0:0", -- Shredder Operating Manual - Page 5
	[16650]="0:12:1:1:::1:0::0:0", -- Shredder Operating Manual - Page 6
	[16651]="0:12:1:1:::1:0::0:0", -- Shredder Operating Manual - Page 7
	[16652]="0:12:1:1:::1:0::0:0", -- Shredder Operating Manual - Page 8
	[16653]="0:12:1:1:::1:0::0:0", -- Shredder Operating Manual - Page 9
	[16654]="0:12:1:1:::1:0::0:0", -- Shredder Operating Manual - Page 10
	[16655]="0:12:1:1:::1:0::0:0", -- Shredder Operating Manual - Page 11
	[16656]="0:12:1:1:::1:0::0:0", -- Shredder Operating Manual - Page 12
	[16658]="0:4:2:1:Cloak::1:0::3:0", -- Wildhunter Cloak
	[16659]="0:4:2:1:Leather::1:0::3:0", -- Deftkin Belt
	[16660]="0:4:2:1:Shield::1:0::3:0", -- Driftmire Shield
	[16661]="0:4:2:1:Cloak::1:0::3:0", -- Soft Willow Cape
	[16662]="0:12:1:1:::1:0::4:0", -- Fragment of the Dragon's Eye
	[16663]="0:12:1:1:::1:0::4:0", -- Blood of the Black Dragon Champion
	[16665]="0:9:2:1:Book::1:0::3:0", -- Tome of Tranquilizing Shot
	[16666]="0:4:3:1:Mail::1:0::3:0", -- Vest of Elements
	[16667]="0:4:3:1:Mail::1:0::3:0", -- Coif of Elements
	[16668]="0:4:3:1:Mail::1:0::3:0", -- Kilt of Elements
	[16669]="0:4:3:1:Mail::1:0::3:0", -- Pauldrons of Elements
	[16670]="0:4:3:1:Mail::1:0::3:0", -- Boots of Elements
	[16671]="0:4:3:1:Mail::1:0::2:0", -- Bindings of Elements
	[16672]="0:4:3:1:Mail::1:0::2:0", -- Gauntlets of Elements
	[16673]="0:4:3:1:Mail::1:0::2:0", -- Cord of Elements
	[16674]="0:4:3:1:Mail::1:0::3:0", -- Beaststalker's Tunic
	[16675]="0:4:3:1:Mail::1:0::3:0", -- Beaststalker's Boots
	[16676]="0:4:3:1:Mail::1:0::2:0", -- Beaststalker's Gloves
	[16677]="0:4:3:1:Mail::1:0::3:0", -- Beaststalker's Cap
	[16678]="0:4:3:1:Mail::1:0::3:0", -- Beaststalker's Pants
	[16679]="0:4:3:1:Mail::1:0::3:0", -- Beaststalker's Mantle
	[16680]="0:4:3:1:Mail::1:0::2:0", -- Beaststalker's Belt
	[16681]="0:4:3:1:Mail::1:0::2:0", -- Beaststalker's Bindings
	[16682]="0:4:3:1:Cloth::1:0::3:0", -- Magister's Boots
	[16683]="0:4:3:1:Cloth::1:0::2:0", -- Magister's Bindings
	[16684]="0:4:3:1:Cloth::1:0::2:0", -- Magister's Gloves
	[16685]="0:4:3:1:Cloth::1:0::2:0", -- Magister's Belt
	[16686]="0:4:3:1:Cloth::1:0::3:0", -- Magister's Crown
	[16687]="0:4:3:1:Cloth::1:0::3:0", -- Magister's Leggings
	[16688]="0:4:3:1:Cloth::1:0::3:0", -- Magister's Robes
	[16689]="0:4:3:1:Cloth::1:0::3:0", -- Magister's Mantle
	[16690]="0:4:3:1:Cloth::1:0::3:0", -- Devout Robe
	[16691]="0:4:3:1:Cloth::1:0::3:0", -- Devout Sandals
	[16692]="0:4:3:1:Cloth::1:0::2:0", -- Devout Gloves
	[16693]="0:4:3:1:Cloth::1:0::3:0", -- Devout Crown
	[16694]="0:4:3:1:Cloth::1:0::3:0", -- Devout Skirt
	[16695]="0:4:3:1:Cloth::1:0::3:0", -- Devout Mantle
	[16696]="0:4:3:1:Cloth::1:0::2:0", -- Devout Belt
	[16697]="0:4:3:1:Cloth::1:0::2:0", -- Devout Bracers
	[16698]="0:4:3:1:Cloth::1:0::3:0", -- Dreadmist Mask
	[16699]="0:4:3:1:Cloth::1:0::3:0", -- Dreadmist Leggings
	[16700]="0:4:3:1:Cloth::1:0::3:0", -- Dreadmist Robe
	[16701]="0:4:3:1:Cloth::1:0::3:0", -- Dreadmist Mantle
	[16702]="0:4:3:1:Cloth::1:0::2:0", -- Dreadmist Belt
	[16703]="0:4:3:1:Cloth::1:0::2:0", -- Dreadmist Bracers
	[16704]="0:4:3:1:Cloth::1:0::3:0", -- Dreadmist Sandals
	[16705]="0:4:3:1:Cloth::1:0::2:0", -- Dreadmist Wraps
	[16706]="0:4:3:1:Leather::1:0::3:0", -- Wildheart Vest
	[16707]="0:4:3:1:Leather::1:0::3:0", -- Shadowcraft Cap
	[16708]="0:4:3:1:Leather::1:0::3:0", -- Shadowcraft Spaulders
	[16709]="0:4:3:1:Leather::1:0::3:0", -- Shadowcraft Pants
	[16710]="0:4:3:1:Leather::1:0::2:0", -- Shadowcraft Bracers
	[16711]="0:4:3:1:Leather::1:0::3:0", -- Shadowcraft Boots
	[16712]="0:4:3:1:Leather::1:0::2:0", -- Shadowcraft Gloves
	[16713]="0:4:3:1:Leather::1:0::2:0", -- Shadowcraft Belt
	[16714]="0:4:3:1:Leather::1:0::2:0", -- Wildheart Bracers
	[16715]="0:4:3:1:Leather::1:0::3:0", -- Wildheart Boots
	[16716]="0:4:3:1:Leather::1:0::2:0", -- Wildheart Belt
	[16717]="0:4:3:1:Leather::1:0::2:0", -- Wildheart Gloves
	[16718]="0:4:3:1:Leather::1:0::3:0", -- Wildheart Spaulders
	[16719]="0:4:3:1:Leather::1:0::3:0", -- Wildheart Kilt
	[16720]="0:4:3:1:Leather::1:0::3:0", -- Wildheart Cowl
	[16721]="0:4:3:1:Leather::1:0::3:0", -- Shadowcraft Tunic
	[16722]="0:4:3:1:Plate::1:0::2:0", -- Lightforge Bracers
	[16723]="0:4:3:1:Plate::1:0::2:0", -- Lightforge Belt
	[16724]="0:4:3:1:Plate::1:0::2:0", -- Lightforge Gauntlets
	[16725]="0:4:3:1:Plate::1:0::3:0", -- Lightforge Boots
	[16726]="0:4:3:1:Plate::1:0::3:0", -- Lightforge Breastplate
	[16727]="0:4:3:1:Plate::1:0::3:0", -- Lightforge Helm
	[16728]="0:4:3:1:Plate::1:0::3:0", -- Lightforge Legplates
	[16729]="0:4:3:1:Plate::1:0::3:0", -- Lightforge Spaulders
	[16730]="0:4:3:1:Plate::1:0::3:0", -- Breastplate of Valor
	[16731]="0:4:3:1:Plate::1:0::3:0", -- Helm of Valor
	[16732]="0:4:3:1:Plate::1:0::3:0", -- Legplates of Valor
	[16733]="0:4:3:1:Plate::1:0::3:0", -- Spaulders of Valor
	[16734]="0:4:3:1:Plate::1:0::3:0", -- Boots of Valor
	[16735]="0:4:3:1:Plate::1:0::2:0", -- Bracers of Valor
	[16736]="0:4:3:1:Plate::1:0::2:0", -- Belt of Valor
	[16737]="0:4:3:1:Plate::1:0::2:0", -- Gauntlets of Valor
	[16738]="0:4:2:1:Cloth::1:0::3:0", -- Witherseed Gloves
	[16739]="0:4:2:1:Leather::1:0::3:0", -- Rugwood Mantle
	[16741]="0:4:2:1:Leather::1:0::3:0", -- Oilrag Handwraps
	[16742]="0:12:1:1:::1:0::4:0", -- Warsong Saw Blades
	[16743]="0:12:1:20:::1:0::4:0", -- Logging Rope
	[16744]="0:12:1:20:::1:0::4:0", -- Warsong Oil
	[16745]="0:12:1:1:::1:0::4:0", -- Warsong Axe Shipment
	[16747]="0:15:0:20:Junk::1:0::0:0", -- Broken Lock
	[16748]="0:15:0:20:Junk::1:0::0:0", -- Padded Lining
	[16762]="0:12:1:1:::1:0::4:0", -- Fathom Core
	[16763]="0:12:1:1:::1:0::4:0", -- Warsong Runner Update
	[16765]="0:12:1:1:::1:0::4:0", -- Warsong Outrider Update
	[16766]="0:0:1:20:FoodDrink::1:0::0:0", -- Undermine Clam Chowder
	[16767]="3000:9:1:1:Cooking::1:1:48060,54232:0:0", -- Recipe: Undermine Clam Chowder
	[16768]="150000:4:2:1:OffHandFrill::1:0:11555:3:0", -- Furbolg Medicine Pouch
	[16769]="133081:2:2:1:OneHandMace::1:0:11555:3:0", -- Furbolg Medicine Totem
	[16782]="0:12:2:1:::1:0::3:0", -- Strange Water Globe
	[16784]="0:12:1:20:::1:0::4:0", -- Sapphire of Aku'Mai
	[16785]="0:12:1:1:::1:0::4:0", -- Rokaro's Letter
	[16786]="0:12:1:20:::1:0::4:0", -- Black Dragonspawn Eye
	[16787]="0:4:1:1:Amulet::1:0::4:0", -- Amulet of Draconic Subversion
	[16788]="0:4:2:1:Shield::1:0::3:0", -- Captain Rackmore's Wheel
	[16789]="0:2:2:1:Wand::1:0::3:0", -- Captain Rackmore's Tiller
	[16790]="0:15:1:1:Junk::1:0::3:0", -- Damp Note
	[16791]="0:4:2:1:Cloth::1:0::3:0", -- Silkstream Cuffs
	[16793]="0:4:2:1:Mail::1:0::3:0", -- Arcmetal Shoulders
	[16794]="0:4:2:1:Mail::1:0::3:0", -- Gripsteel Wristguards
	[16795]="0:4:4:1:Cloth::1:0::3:0", -- Arcanist Crown
	[16796]="0:4:4:1:Cloth::1:0::3:0", -- Arcanist Leggings
	[16797]="0:4:4:1:Cloth::1:0::3:0", -- Arcanist Mantle
	[16798]="0:4:4:1:Cloth::1:0::3:0", -- Arcanist Robes
	[16799]="0:4:4:1:Cloth::1:0::2:0", -- Arcanist Bindings
	[16800]="0:4:4:1:Cloth::1:0::3:0", -- Arcanist Boots
	[16801]="0:4:4:1:Cloth::1:0::3:0", -- Arcanist Gloves
	[16802]="0:4:4:1:Cloth::1:0::2:0", -- Arcanist Belt
	[16803]="0:4:4:1:Cloth::1:0::3:0", -- Felheart Slippers
	[16804]="0:4:4:1:Cloth::1:0::2:0", -- Felheart Bracers
	[16805]="0:4:4:1:Cloth::1:0::3:0", -- Felheart Gloves
	[16806]="0:4:4:1:Cloth::1:0::2:0", -- Felheart Belt
	[16807]="0:4:4:1:Cloth::1:0::3:0", -- Felheart Shoulder Pads
	[16808]="0:4:4:1:Cloth::1:0::3:0", -- Felheart Horns
	[16809]="0:4:4:1:Cloth::1:0::3:0", -- Felheart Robes
	[16810]="0:4:4:1:Cloth::1:0::3:0", -- Felheart Pants
	[16811]="0:4:4:1:Cloth::1:0::3:0", -- Boots of Prophecy
	[16812]="0:4:4:1:Cloth::1:0::3:0", -- Gloves of Prophecy
	[16813]="0:4:4:1:Cloth::1:0::3:0", -- Circlet of Prophecy
	[16814]="0:4:4:1:Cloth::1:0::3:0", -- Pants of Prophecy
	[16815]="0:4:4:1:Cloth::1:0::3:0", -- Robes of Prophecy
	[16816]="0:4:4:1:Cloth::1:0::3:0", -- Mantle of Prophecy
	[16817]="0:4:4:1:Cloth::1:0::2:0", -- Girdle of Prophecy
	[16818]="0:4:4:1:Cloth::1:0::3:0", -- Netherwind Belt
	[16819]="0:4:4:1:Cloth::1:0::2:0", -- Vambraces of Prophecy
	[16820]="0:4:4:1:Leather::1:0::3:0", -- Nightslayer Chestpiece
	[16821]="0:4:4:1:Leather::1:0::3:0", -- Nightslayer Cover
	[16822]="0:4:4:1:Leather::1:0::3:0", -- Nightslayer Pants
	[16823]="0:4:4:1:Leather::1:0::3:0", -- Nightslayer Shoulder Pads
	[16824]="0:4:4:1:Leather::1:0::3:0", -- Nightslayer Boots
	[16825]="0:4:4:1:Leather::1:0::2:0", -- Nightslayer Bracelets
	[16826]="0:4:4:1:Leather::1:0::3:0", -- Nightslayer Gloves
	[16827]="0:4:4:1:Leather::1:0::2:0", -- Nightslayer Belt
	[16828]="0:4:4:1:Leather::1:0::2:0", -- Cenarion Belt
	[16829]="0:4:4:1:Leather::1:0::3:0", -- Cenarion Boots
	[16830]="0:4:4:1:Leather::1:0::2:0", -- Cenarion Bracers
	[16831]="0:4:4:1:Leather::1:0::3:0", -- Cenarion Gloves
	[16832]="0:4:4:1:Leather::1:0::3:0", -- Bloodfang Spaulders
	[16833]="0:4:4:1:Leather::1:0::3:0", -- Cenarion Vestments
	[16834]="0:4:4:1:Leather::1:0::3:0", -- Cenarion Helm
	[16835]="0:4:4:1:Leather::1:0::3:0", -- Cenarion Leggings
	[16836]="0:4:4:1:Leather::1:0::3:0", -- Cenarion Spaulders
	[16837]="0:4:4:1:Mail::1:0::3:0", -- Earthfury Boots
	[16838]="0:4:4:1:Mail::1:0::2:0", -- Earthfury Belt
	[16839]="0:4:4:1:Mail::1:0::3:0", -- Earthfury Gauntlets
	[16840]="0:4:4:1:Mail::1:0::2:0", -- Earthfury Bracers
	[16841]="0:4:4:1:Mail::1:0::3:0", -- Earthfury Vestments
	[16842]="0:4:4:1:Mail::1:0::3:0", -- Earthfury Helmet
	[16843]="0:4:4:1:Mail::1:0::3:0", -- Earthfury Legguards
	[16844]="0:4:4:1:Mail::1:0::3:0", -- Earthfury Epaulets
	[16845]="0:4:4:1:Mail::1:0::3:0", -- Giantstalker's Breastplate
	[16846]="0:4:4:1:Mail::1:0::3:0", -- Giantstalker's Helmet
	[16847]="0:4:4:1:Mail::1:0::3:0", -- Giantstalker's Leggings
	[16848]="0:4:4:1:Mail::1:0::3:0", -- Giantstalker's Epaulets
	[16849]="0:4:4:1:Mail::1:0::3:0", -- Giantstalker's Boots
	[16850]="0:4:4:1:Mail::1:0::2:0", -- Giantstalker's Bracers
	[16851]="0:4:4:1:Mail::1:0::2:0", -- Giantstalker's Belt
	[16852]="0:4:4:1:Mail::1:0::3:0", -- Giantstalker's Gloves
	[16853]="0:4:4:1:Plate::1:0::3:0", -- Lawbringer Chestguard
	[16854]="0:4:4:1:Plate::1:0::3:0", -- Lawbringer Helm
	[16855]="0:4:4:1:Plate::1:0::3:0", -- Lawbringer Legplates
	[16856]="0:4:4:1:Plate::1:0::3:0", -- Lawbringer Spaulders
	[16857]="0:4:4:1:Plate::1:0::2:0", -- Lawbringer Bracers
	[16858]="0:4:4:1:Plate::1:0::2:0", -- Lawbringer Belt
	[16859]="0:4:4:1:Plate::1:0::3:0", -- Lawbringer Boots
	[16860]="0:4:4:1:Plate::1:0::3:0", -- Lawbringer Gauntlets
	[16861]="0:4:4:1:Plate::1:0::2:0", -- Bracers of Might
	[16862]="0:4:4:1:Plate::1:0::3:0", -- Sabatons of Might
	[16863]="0:4:4:1:Plate::1:0::3:0", -- Gauntlets of Might
	[16864]="0:4:4:1:Plate::1:0::2:0", -- Belt of Might
	[16865]="0:4:4:1:Plate::1:0::3:0", -- Breastplate of Might
	[16866]="0:4:4:1:Plate::1:0::3:0", -- Helm of Might
	[16867]="0:4:4:1:Plate::1:0::3:0", -- Legplates of Might
	[16868]="0:4:4:1:Plate::1:0::3:0", -- Pauldrons of Might
	[16869]="0:12:1:1:::1:0::4:0", -- The Skull of Scryer
	[16870]="0:12:1:1:::1:0::4:0", -- The Skull of Somnus
	[16871]="0:12:1:1:::1:0::4:0", -- The Skull of Chronalis
	[16872]="0:12:1:1:::1:0::4:0", -- The Skull of Axtroz
	[16873]="0:4:2:1:Leather::1:0::3:0", -- Braidfur Gloves
	[16882]="0:15:1:1:Junk::1:0::0:0", -- Battered Junkbox
	[16883]="0:15:1:1:Junk::1:0::0:0", -- Worn Junkbox
	[16884]="0:15:1:1:Junk::1:0::0:0", -- Sturdy Junkbox
	[16885]="0:12:1:1:::1:0::0:0", -- Heavy Junkbox
	[16886]="0:2:3:1:OneHandSword::1:0::3:0", -- Outlaw Sabre
	[16887]="0:4:3:1:OffHandFrill::1:0::3:0", -- Witch's Finger
	[16888]="0:12:1:1:::1:0::4:0", -- Dull Drakefire Amulet
	[16889]="0:2:2:1:Stave::1:0::3:0", -- Polished Walking Staff
	[16890]="0:2:2:1:OneHandSword::1:0::3:0", -- Slatemetal Cutlass
	[16891]="0:2:2:1:OneHandSword::1:0::3:0", -- Claystone Shortsword
	[16892]="0:0:1:1:Consumable::1:0::3:0", -- Lesser Soulstone
	[16893]="0:0:1:1:Consumable::1:0::3:0", -- Soulstone
	[16894]="0:2:2:1:Stave::1:0::3:0", -- Clear Crystal Rod
	[16895]="0:0:1:1:Consumable::1:0::3:0", -- Greater Soulstone
	[16896]="0:0:1:1:Consumable::1:0::3:0", -- Major Soulstone
	[16897]="0:4:4:1:Leather::1:0::3:0", -- Stormrage Chestguard
	[16898]="0:4:4:1:Leather::1:0::3:0", -- Stormrage Boots
	[16899]="0:4:4:1:Leather::1:0::3:0", -- Stormrage Handguards
	[16900]="0:4:4:1:Leather::1:0::3:0", -- Stormrage Cover
	[16901]="0:4:4:1:Leather::1:0::3:0", -- Stormrage Legguards
	[16902]="0:4:4:1:Leather::1:0::3:0", -- Stormrage Pauldrons
	[16903]="0:4:4:1:Leather::1:0::3:0", -- Stormrage Belt
	[16904]="0:4:4:1:Leather::1:0::3:0", -- Stormrage Bracers
	[16905]="0:4:4:1:Leather::1:0::3:0", -- Bloodfang Chestpiece
	[16906]="0:4:4:1:Leather::1:0::3:0", -- Bloodfang Boots
	[16907]="0:4:4:1:Leather::1:0::3:0", -- Bloodfang Gloves
	[16908]="0:4:4:1:Leather::1:0::3:0", -- Bloodfang Hood
	[16909]="0:4:4:1:Leather::1:0::3:0", -- Bloodfang Pants
	[16910]="0:4:4:1:Leather::1:0::3:0", -- Bloodfang Belt
	[16911]="0:4:4:1:Leather::1:0::3:0", -- Bloodfang Bracers
	[16912]="0:4:4:1:Cloth::1:0::3:0", -- Netherwind Boots
	[16913]="0:4:4:1:Cloth::1:0::3:0", -- Netherwind Gloves
	[16914]="0:4:4:1:Cloth::1:0::3:0", -- Netherwind Crown
	[16915]="0:4:4:1:Cloth::1:0::3:0", -- Netherwind Pants
	[16916]="0:4:4:1:Cloth::1:0::3:0", -- Netherwind Robes
	[16917]="0:4:4:1:Cloth::1:0::3:0", -- Netherwind Mantle
	[16918]="0:4:4:1:Cloth::1:0::3:0", -- Netherwind Bindings
	[16919]="0:4:4:1:Cloth::1:0::3:0", -- Boots of Transcendence
	[16920]="0:4:4:1:Cloth::1:0::3:0", -- Handguards of Transcendence
	[16921]="0:4:4:1:Cloth::1:0::3:0", -- Halo of Transcendence
	[16922]="0:4:4:1:Cloth::1:0::3:0", -- Leggings of Transcendence
	[16923]="0:4:4:1:Cloth::1:0::3:0", -- Robes of Transcendence
	[16924]="0:4:4:1:Cloth::1:0::3:0", -- Pauldrons of Transcendence
	[16925]="0:4:4:1:Cloth::1:0::3:0", -- Belt of Transcendence
	[16926]="0:4:4:1:Cloth::1:0::3:0", -- Bindings of Transcendence
	[16927]="0:4:4:1:Cloth::1:0::3:0", -- Nemesis Boots
	[16928]="0:4:4:1:Cloth::1:0::3:0", -- Nemesis Gloves
	[16929]="0:4:4:1:Cloth::1:0::3:0", -- Nemesis Skullcap
	[16930]="0:4:4:1:Cloth::1:0::3:0", -- Nemesis Leggings
	[16931]="0:4:4:1:Cloth::1:0::3:0", -- Nemesis Robes
	[16932]="0:4:4:1:Cloth::1:0::3:0", -- Nemesis Spaulders
	[16933]="0:4:4:1:Cloth::1:0::3:0", -- Nemesis Belt
	[16934]="0:4:4:1:Cloth::1:0::3:0", -- Nemesis Bracers
	[16935]="0:4:4:1:Mail::1:0::3:0", -- Dragonstalker's Bracers
	[16936]="0:4:4:1:Mail::1:0::3:0", -- Dragonstalker's Belt
	[16937]="0:4:4:1:Mail::1:0::3:0", -- Dragonstalker's Spaulders
	[16938]="0:4:4:1:Mail::1:0::3:0", -- Dragonstalker's Legguards
	[16939]="0:4:4:1:Mail::1:0::3:0", -- Dragonstalker's Helm
	[16940]="0:4:4:1:Mail::1:0::3:0", -- Dragonstalker's Gauntlets
	[16941]="0:4:4:1:Mail::1:0::3:0", -- Dragonstalker's Greaves
	[16942]="0:4:4:1:Mail::1:0::3:0", -- Dragonstalker's Breastplate
	[16943]="0:4:4:1:Mail::1:0::3:0", -- Bracers of Ten Storms
	[16944]="0:4:4:1:Mail::1:0::3:0", -- Belt of Ten Storms
	[16945]="0:4:4:1:Mail::1:0::3:0", -- Epaulets of Ten Storms
	[16946]="0:4:4:1:Mail::1:0::3:0", -- Legplates of Ten Storms
	[16947]="0:4:4:1:Mail::1:0::3:0", -- Helmet of Ten Storms
	[16948]="0:4:4:1:Mail::1:0::3:0", -- Gauntlets of Ten Storms
	[16949]="0:4:4:1:Mail::1:0::3:0", -- Greaves of Ten Storms
	[16950]="0:4:4:1:Mail::1:0::3:0", -- Breastplate of Ten Storms
	[16951]="0:4:4:1:Plate::1:0::3:0", -- Judgement Bindings
	[16952]="0:4:4:1:Plate::1:0::3:0", -- Judgement Belt
	[16953]="0:4:4:1:Plate::1:0::3:0", -- Judgement Spaulders
	[16954]="0:4:4:1:Plate::1:0::3:0", -- Judgement Legplates
	[16955]="0:4:4:1:Plate::1:0::3:0", -- Judgement Crown
	[16956]="0:4:4:1:Plate::1:0::3:0", -- Judgement Gauntlets
	[16957]="0:4:4:1:Plate::1:0::3:0", -- Judgement Sabatons
	[16958]="0:4:4:1:Plate::1:0::3:0", -- Judgement Breastplate
	[16959]="0:4:4:1:Plate::1:0::3:0", -- Bracelets of Wrath
	[16960]="0:4:4:1:Plate::1:0::3:0", -- Waistband of Wrath
	[16961]="0:4:4:1:Plate::1:0::3:0", -- Pauldrons of Wrath
	[16962]="0:4:4:1:Plate::1:0::3:0", -- Legplates of Wrath
	[16963]="0:4:4:1:Plate::1:0::3:0", -- Helm of Wrath
	[16964]="0:4:4:1:Plate::1:0::3:0", -- Gauntlets of Wrath
	[16965]="0:4:4:1:Plate::1:0::3:0", -- Sabatons of Wrath
	[16966]="0:4:4:1:Plate::1:0::3:0", -- Breastplate of Wrath
	[16967]="0:4:1:1:OffHandFrill::1:0::4:0", -- Feralas Ahi
	[16968]="0:12:1:1:::1:0::4:0", -- Sar'theris Striker
	[16969]="0:12:1:1:::1:0::4:0", -- Savage Coast Blue Sailfin
	[16970]="0:12:1:1:::1:0::4:0", -- Misty Reed Mahi Mahi
	[16971]="0:0:1:20:FoodDrink::1:0::0:0", -- Clamlette Surprise
	[16972]="0:12:1:1:::1:0::4:0", -- Senani's Banner
	[16973]="0:12:1:1:::1:0::4:0", -- Vial of Dire Water
	[16974]="0:12:1:1:::1:0::4:0", -- Empty Water Vial
	[16975]="0:4:3:1:Cloth::1:0::3:0", -- Warsong Sash
	[16976]="0:12:1:1:::1:0::4:0", -- Murgut's Totem
	[16977]="0:4:3:1:Leather::1:0::3:0", -- Warsong Boots
	[16978]="0:4:3:1:Mail::1:0::3:0", -- Warsong Gauntlets
	[16979]="0:4:4:1:Cloth::1:0::2:0", -- Flarecore Gloves
	[16980]="0:4:4:1:Cloth::1:0::2:0", -- Flarecore Mantle
	[16981]="0:4:2:1:Cloth::1:0::3:0", -- Owlbeard Bracers
	[16982]="0:4:4:1:Leather::1:0::2:0", -- Corehound Boots
	[16983]="0:4:4:1:Leather::1:0::2:0", -- Molten Helm
	[16984]="0:4:4:1:Mail::1:0::2:0", -- Black Dragonscale Boots
	[16985]="0:4:2:1:Cloth::1:0::3:0", -- Windseeker Boots
	[16986]="0:4:2:1:Mail::1:0::3:0", -- Sandspire Gloves
	[16987]="0:4:2:1:Leather::1:0::3:0", -- Screecher Belt
	[16988]="0:4:4:1:Mail::1:0::2:0", -- Fiery Chain Shoulders
	[16989]="0:4:4:1:Mail::1:0::2:0", -- Fiery Chain Girdle
	[16990]="0:4:2:1:Cloak::1:0::3:0", -- Spritekin Cloak
	[16991]="0:12:1:1:::1:0::4:0", -- Triage Bandage
	[16992]="0:2:2:1:Gun::1:0::3:0", -- Smokey's Explosive Launcher
	[16993]="0:2:2:1:Wand::1:0::3:0", -- Smokey's Fireshooter
	[16994]="0:4:2:1:Leather::1:0::3:0", -- Duskwing Gloves
	[16995]="0:4:2:1:Leather::1:0::3:0", -- Duskwing Mantle
	[16996]="0:2:3:1:Bow::1:0::3:0", -- Gorewood Bow
	[16997]="0:2:3:1:Wand::1:0::3:0", -- Stormrager
	[16998]="0:4:3:1:Shield::1:0::3:0", -- Sacred Protector
	[17001]="0:4:2:1:Ring::1:0::3:0", -- Elemental Circle
	[17002]="0:2:2:1:OneHandAxe::1:0::3:0", -- Ichor Spitter
	[17003]="0:2:2:1:OneHandMace::1:0::3:0", -- Skullstone Hammer
	[17004]="0:2:2:1:Stave::1:0::3:0", -- Sarah's Guide
	[17005]="0:4:2:1:Leather::1:0::3:0", -- Boorguard Tunic
	[17006]="0:4:2:1:Mail::1:0::3:0", -- Cobalt Legguards
	[17007]="0:4:4:1:Mail::1:0::2:0", -- Stonerender Gauntlets
	[17008]="0:12:1:1:::1:0::3:0", -- Small Scroll
	[17009]="0:12:1:1:::1:0::4:0", -- Ambassador Malcin's Head
	[17010]="0:7:3:10:Other:164,202,165,186,197:1:0::0:0", -- Fiery Core
	[17011]="0:7:3:10:Other:164,202,165,197:1:0::0:0", -- Lava Core
	[17012]="0:7:1:20:Leather:164,165,197:1:0::0:0", -- Core Leather
	[17013]="0:4:4:1:Plate::1:0::2:0", -- Dark Iron Leggings
	[17014]="0:4:4:1:Plate::1:0::2:0", -- Dark Iron Bracers
	[17015]="0:2:3:1:OneHandSword::1:0::2:0", -- Dark Iron Reaver
	[17016]="0:2:3:1:OneHandAxe::1:0::2:0", -- Dark Iron Destroyer
	[17017]="180000:9:1:1:Tailoring::1:1:12944:3:0", -- Pattern: Flarecore Mantle
	[17018]="80000:9:1:1:Tailoring::1:1:12944:3:0", -- Pattern: Flarecore Gloves
	[17020]="1000:15:1:100:Reagent:202,-8:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3405,3490,3500,3562,3700,3970,4083,4220,4562,4575,4896,5110,5139,5151,8361,10364,12096,12097,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,24313,24349,24357,24396,24780,24843,24935,25010,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29561,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33630,33633,33669,33674,33676,33871,35642,36375,37904,37935,39144,39878,41053,41275,41490,41508,41623,41676,41891,42622,42878,42910,42967,43152,43155,43381,43405,43411,43493,43547,43551,43555,43563,43619,43646,43774,43887,43964,44047,44115,44187,44313,44333,44970,45289,45290,45361,47860,48553,48885,49401,49410,49578,49594,49601,49733,49754,49766,50070,50462,52914,53040,53076,53781:0:0", -- Arcane Powder
	[17021]="0:15:0:20:Reagent:-11:1:0::0:0", -- Wild Berries
	[17022]="150000:9:1:1:Leatherworking::1:1:12944:3:0", -- Pattern: Corehound Boots
	[17023]="160000:9:1:1:Leatherworking::1:1:12944:3:0", -- Pattern: Molten Helm
	[17025]="160000:9:1:1:Leatherworking::1:1:12944:3:0", -- Pattern: Black Dragonscale Boots
	[17026]="0:15:0:20:Reagent:-11:1:0::0:0", -- Wild Thornroot
	[17028]="0:15:0:20:Reagent:-5:1:0::0:0", -- Holy Candle
	[17029]="0:15:1:20:Reagent:-5:1:0::0:0", -- Sacred Candle
	[17030]="2000:15:1:10:Reagent:-7:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3405,3490,3500,3562,3700,3970,4083,4220,4562,4575,4896,5110,5139,5151,8361,10364,12096,12097,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,24313,24349,24357,24396,24780,24843,24935,25010,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29561,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33630,33633,33669,33674,33676,33871,35642,36375,37904,37935,39144,39878,41053,41275,41490,41508,41623,41676,41891,42622,42878,42910,42967,43152,43155,43381,43405,43411,43493,43547,43551,43555,43563,43619,43646,43774,43887,43964,44047,44115,44187,44313,44333,44970,45289,45290,45361,47860,48553,48885,49401,49410,49578,49594,49601,49733,49754,49766,50070,50462,52914,53040,53076,53781:0:0", -- Ankh
	[17031]="1000:15:1:20:Reagent:-8:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3405,3490,3500,3562,3700,3970,4083,4220,4562,4575,4896,5110,5139,5151,8361,10364,12096,12097,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,24313,24349,24357,24396,24780,24843,24935,25010,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29561,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33630,33633,33669,33674,33676,33871,35642,36375,37904,37935,39144,39878,41053,41275,41490,41508,41623,41676,41891,42622,42878,42910,42967,43152,43155,43381,43405,43411,43493,43547,43551,43555,43563,43619,43646,43774,43887,43964,44047,44115,44187,44313,44333,44970,45289,45290,45361,47860,48553,48885,49401,49410,49578,49594,49601,49733,49754,49766,50070,50462,52914,53040,53076,53781:0:0", -- Rune of Teleportation
	[17032]="2000:15:1:20:Reagent:-8:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3405,3490,3500,3562,3700,3970,4083,4220,4562,4575,4896,5110,5139,5151,8361,10364,12096,12097,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,24313,24349,24357,24396,24780,24843,24935,25010,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29561,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33630,33633,33669,33674,33676,33871,35642,36375,37904,37935,39144,39878,41053,41275,41490,41508,41623,41676,41891,42622,42878,42910,42967,43152,43155,43381,43405,43411,43493,43547,43551,43555,43563,43619,43646,43774,43887,43964,44047,44115,44187,44313,44333,44970,45289,45290,45361,47860,48553,48885,49401,49410,49578,49594,49601,49733,49754,49766,50070,50462,52914,53040,53076,53781:0:0", -- Rune of Portals
	[17033]="0:15:0:5:Reagent:-2:1:0::0:0", -- Symbol of Divinity
	[17034]="200:15:1:20:Reagent:-11:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3405,3490,3500,3562,3700,3970,4083,4220,4562,4575,4896,5110,5139,5151,8361,10364,12096,12097,14739,15175,16015,16611,16612,16706,16757,16829,18006,18019,18243,19004,19678,19718,20081,22479,23112,24313,24349,24357,24396,24843,24935,25010,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33630,33633,33669,33674,33676,33871,36375,37904,37935,39144,39878,41053,41275,41490,41508,41623,41676,41891,42622,42878,42910,42967,43152,43155,43381,43405,43411,43493,43547,43551,43555,43563,43619,43646,43774,43887,43964,44047,44115,44187,44313,44333,44970,45289,45290,45361,47860,48553,48885,49401,49410,49578,49594,49601,49733,49754,49766,50070,50462,52914,53040,53076,53781:0:0", -- Maple Seed
	[17035]="0:15:1:20:Reagent:-11:1:0::0:0", -- Stranglethorn Seed
	[17036]="0:15:1:20:Reagent:-11:1:0::0:0", -- Ashwood Seed
	[17037]="1400:15:1:20:Reagent:-11:1:0:16588,17518,18017,18802,18998,19013,19014,19235,19535,19679,20092,20915,23145,23157,23373,24313,24780,25039,26382,26908,27138,27935,30345,30825,33669,37904,37935:0:0", -- Hornbeam Seed
	[17038]="0:15:1:20:Reagent:-11:1:0::0:0", -- Ironwood Seed
	[17039]="0:2:3:1:OneHandMace::1:0::3:0", -- Skullbreaker
	[17042]="0:2:3:1:Gun::1:0::3:0", -- Nail Spitter
	[17043]="0:4:3:1:Cloth::1:0::3:0", -- Zealot's Robe
	[17044]="0:4:3:1:Amulet::1:0::3:0", -- Will of the Martyr
	[17045]="0:4:3:1:Ring::1:0::3:0", -- Blood of the Martyr
	[17046]="0:2:2:1:OneHandAxe::1:0::3:0", -- Gutterblade
	[17047]="0:4:2:1:Cloth::1:0::3:0", -- Luminescent Amice
	[17048]="0:0:1:10:Consumable::1:0::3:0", -- Rumsey Rum
	[17049]="90000:9:3:1:Blacksmithing::1:1:12944:3:0", -- Plans: Fiery Chain Girdle
	[17050]="0:4:3:1:Cloth::1:0::2:0", -- Chan's Imperial Robes
	[17051]="70000:9:3:1:Blacksmithing::1:1:12944:3:0", -- Plans: Dark Iron Bracers
	[17052]="180000:9:3:1:Blacksmithing::1:0:12944:3:0", -- Plans: Dark Iron Leggings
	[17053]="200000:9:3:1:Blacksmithing::1:0:12944:3:0", -- Plans: Fiery Chain Shoulders
	[17054]="0:2:3:1:OneHandSword::1:0::2:0", -- Joonho's Mercy
	[17055]="0:2:3:1:OneHandMace::1:0::2:0", -- Changuk Smasher
	[17056]="0:15:1:20:Reagent:165,-8,-5:1:0::0:0", -- Light Feather
	[17057]="0:15:1:20:Reagent:-7:1:0::0:0", -- Shiny Fish Scales
	[17058]="0:15:1:20:Reagent:-7:1:0::0:0", -- Fish Oil
	[17059]="220000:9:3:1:Blacksmithing::1:1:12944:3:0", -- Plans: Dark Iron Reaver
	[17060]="220000:9:3:1:Blacksmithing::1:1:12944:3:0", -- Plans: Dark Iron Destroyer
	[17061]="0:4:3:1:Cloak::1:0::2:0", -- Juno's Shadow
	[17062]="2200:9:1:1:Cooking::1:0:2664,3178,3333,4574,5162,12033,12962:0:0", -- Recipe: Mithril Head Trout
	[17063]="0:4:4:1:Ring::1:0::3:0", -- Band of Accuria
	[17064]="0:4:4:1:Trinket::1:0::3:0", -- Shard of the Scale
	[17065]="0:4:4:1:Amulet::1:0::3:0", -- Medallion of Steadfast Might
	[17066]="0:4:4:1:Shield::1:0::3:0", -- Drillborer Disk
	[17067]="0:4:4:1:OffHandFrill::1:0::3:0", -- Ancient Cornerstone Grimoire
	[17068]="0:2:4:1:OneHandAxe::1:0::3:0", -- Deathbringer
	[17069]="0:2:4:1:Bow::1:0::3:0", -- Striker's Mark
	[17070]="0:2:4:1:Dagger::1:0::3:0", -- Fang of the Mystics
	[17071]="0:2:4:1:Dagger::1:0::3:0", -- Gutgore Ripper
	[17072]="0:2:4:1:Gun::1:0::3:0", -- Blastershot Launcher
	[17073]="0:2:4:1:TwoHandMace::1:0::3:0", -- Earthshaker
	[17074]="0:2:4:1:Polearm::1:0::3:0", -- Shadowstrike
	[17075]="0:2:4:1:OneHandSword::1:0::3:0", -- Vis'kag the Bloodletter
	[17076]="0:2:4:1:TwoHandSword::1:0::3:0", -- Bonereaver's Edge
	[17077]="0:2:4:1:Wand::1:0::3:0", -- Crimson Shocker
	[17078]="0:4:4:1:Cloak::1:0::3:0", -- Sapphiron Drape
	[17082]="0:4:4:1:Trinket::1:0::3:0", -- Shard of the Flame
	[17102]="0:4:4:1:Cloak::1:0::3:0", -- Cloak of the Shrouded Mists
	[17103]="0:2:4:1:OneHandSword::1:0::3:0", -- Azuresong Mageblade
	[17104]="0:2:4:1:TwoHandAxe::1:0::3:0", -- Spinal Reaper
	[17105]="0:2:4:1:OneHandMace::1:0::3:0", -- Aurastone Hammer
	[17106]="0:4:4:1:Shield::1:0::3:0", -- Malistar's Defender
	[17107]="0:4:4:1:Cloak::1:0::3:0", -- Dragon's Blood Cape
	[17109]="0:4:4:1:Amulet::1:0::3:0", -- Choker of Enlightenment
	[17110]="0:4:4:1:Ring::1:0::3:0", -- Seal of the Archmagus
	[17111]="0:4:4:1:Amulet::1:0::3:0", -- Blazefury Medallion
	[17112]="0:2:4:1:OneHandMace::1:0::3:0", -- Empyrean Demolisher
	[17113]="0:2:4:1:Stave::1:0::3:0", -- Amberseal Keeper
	[17114]="0:12:1:1:::1:0::4:0", -- Araj's Phylactery Shard
	[17117]="0:12:1:1:::1:0::4:0", -- Rat Catcher's Flute
	[17118]="0:12:1:1:::1:0::4:0", -- Carton of Mystery Meat
	[17119]="125:0:1:20:FoodDrink::5:0:13018:0:0", -- Deeprun Rat Kabob
	[17124]="0:12:1:100:::1:0::3:0", -- Syndicate Emblem
	[17125]="0:12:1:1:::1:0::4:0", -- Seal of Ravenholdt
	[17126]="0:12:1:1:::1:0::4:0", -- Elegant Letter
	[17142]="0:2:5:1:Dagger::1:0::3:0", -- Shard of the Defiler
	[17182]="0:2:5:1:TwoHandMace::1:0::3:0", -- Sulfuras, Hand of Ragnaros
	[17183]="36:4:1:1:Shield::1:0:2116,3075,3161,4559,16693:0:0", -- Dented Buckler
	[17184]="36:4:1:1:Shield::1:0:1104,1213,3592,4240,16762,16917:0:0", -- Small Shield
	[17185]="260:4:1:1:Shield::1:0:2135,3080,3167,3319,4559,16258,16693,43955,43957,44339:0:0", -- Round Buckler
	[17186]="260:4:1:1:Shield::1:0:1249,2046,3613,4240,5106,16762,17930:0:0", -- Small Targe
	[17187]="1161:4:1:1:Shield::1:0:3319,4187,4559,4560,5107,8360,16693,16762,43955,43957:0:0", -- Banded Buckler
	[17188]="2447:4:1:1:Shield::1:0:793,1319,3319,3493,4240,5126,8360,16693,16762,33381,47106,47144:0:0", -- Ringed Buckler
	[17189]="13054:4:1:1:Shield::1:0:1319,1322,1323,1349,1381,2845,3095,4177,4240,5125,5126,5812,5819,8129,43750,47106,47144,53641:0:0", -- Metal Buckler
	[17190]="37647:4:1:1:Shield::1:0:980,1319,1323,1349,3095,4177,4240,5126,5508,5812,5819,8129,11182,12040,16626,16753,25274,27067,45500,46512,47106,47144,49549,53641:0:0", -- Ornate Buckler
	[17191]="0:2:3:1:Stave::1:0::3:0", -- Scepter of Celebras
	[17192]="4820:4:1:1:Shield::1:0:226,1319,1323,1349,1450,3095,4240,4886,5126,5812,5819,6028,16693,16762,31027,34624,47106,47144,53641:0:0", -- Reinforced Targe
	[17193]="0:2:4:1:TwoHandMace::1:0::2:0", -- Sulfuron Hammer
	[17194]="0:15:1:20:Holiday:185:1:0::0:0", -- Holiday Spices
	[17195]="0:15:1:20:Junk::1:0::0:0", -- Fake Mistletoe
	[17196]="0:0:1:20:FoodDrink:185:1:0::0:0", -- Holiday Spirits
	[17197]="0:0:1:20:FoodDrink::1:0::0:0", -- Gingerbread Cookie
	[17198]="0:0:1:20:FoodDrink::1:0::0:0", -- Egg Nog
	[17200]="0:9:1:1:Cooking::1:0::0:0", -- Recipe: Gingerbread Cookie
	[17201]="0:9:1:1:Cooking::1:0::0:0", -- Recipe: Egg Nog
	[17202]="0:15:1:20:Holiday:202:1:0::0:0", -- Snowball
	[17203]="0:7:4:20:MetalStone:164:1:0::0:0", -- Sulfuron Ingot
	[17204]="0:7:5:1:Other::1:0::3:0", -- Eye of Sulfuras
	[17222]="0:0:1:20:FoodDrink::1:0::0:0", -- Spider Sausage
	[17223]="0:2:4:1:Polearm::1:0::3:0", -- Thunderstrike
	[17224]="0:12:2:1:::1:0::3:0", -- Scrying Scope
	[17242]="0:13:1:1:::1:0::0:0", -- Key to Salem's Chest
	[17262]="0:13:1:1:::1:0::0:0", -- James' Key
	[17302]="0:0:1:1:Other::1:0::0:0", -- Blue Ribboned Holiday Gift
	[17303]="0:0:1:10:Other::1:0::0:0", -- Blue Ribboned Wrapping Paper
	[17304]="0:0:1:10:Other::1:0::0:0", -- Green Ribboned Wrapping Paper
	[17305]="0:0:1:1:Other::1:0::0:0", -- Green Ribboned Holiday Gift
	[17306]="0:12:1:100:::1:0::3:0", -- Stormpike Soldier's Blood
	[17307]="0:0:1:10:Other::1:0::0:0", -- Purple Ribboned Wrapping Paper
	[17308]="0:0:1:1:Other::1:0::0:0", -- Purple Ribboned Holiday Gift
	[17309]="0:12:1:20:::1:0::4:0", -- Discordant Bracers
	[17310]="0:12:1:1:::1:0::4:0", -- Aspect of Neptulon
	[17322]="0:12:1:1:::1:0::4:0", -- Eye of the Emberseer
	[17326]="0:12:1:100:::1:0::3:0", -- Stormpike Soldier's Flesh
	[17327]="0:12:1:100:::1:0::3:0", -- Stormpike Lieutenant's Flesh
	[17328]="0:12:1:100:::1:0::3:0", -- Stormpike Commander's Flesh
	[17333]="0:12:1:1:::1:0::3:0", -- Aqual Quintessence
	[17344]="0:0:1:20:FoodDrink::1:0::0:0", -- Candy Cane
	[17345]="0:12:1:20:::1:0::4:0", -- Silithid Goo
	[17346]="0:12:1:1:::1:0::4:0", -- Encrusted Silithid Object
	[17348]="1000:0:1:20:Potion::1:0:13216,13217,13218,13219,14753,14754:3:0", -- Major Healing Draught
	[17349]="500:0:1:20:Potion::1:0:13216,13217,13218,13219,14753,14754,15126,15127:3:0", -- Superior Healing Draught
	[17351]="1000:0:1:20:Potion::1:0:13216,13217,13218,13219,14753,14754:3:0", -- Major Mana Draught
	[17352]="500:0:1:20:Potion::1:0:13216,13217,13218,13219,14753,14754,15126,15127:3:0", -- Superior Mana Draught
	[17355]="0:12:1:1:::1:0::4:0", -- Rabine's Letter
	[17363]="0:12:1:1:::1:0::4:0", -- Ryson's Beacon
	[17364]="0:12:2:1:::1:0::3:0", -- Scrying Scope
	[17384]="0:12:3:1:::1:0::3:0", -- Zinfizzlex's Portable Shredder Unit
	[17402]="0:0:1:20:FoodDrink::1:0::0:0", -- Greatfather's Winter Ale
	[17403]="0:0:1:20:FoodDrink::1:0::0:0", -- Steamwheedle Fizzy Spirits
	[17404]="0:0:1:20:FoodDrink::1:0::0:0", -- Blended Bean Brew
	[17405]="0:15:1:20:Holiday::1:0::0:0", -- Green Garden Tea
	[17406]="0:0:1:20:FoodDrink::1:0::0:0", -- Holiday Cheesewheel
	[17407]="0:0:1:20:FoodDrink::1:0::0:0", -- Graccu's Homemade Meat Pie
	[17408]="0:0:1:20:FoodDrink::1:0::0:0", -- Spicy Beefstick
	[17410]="0:12:3:1:::1:0::3:0", -- Zinfizzlex's Portable Shredder Unit
	[17411]="0:12:1:1:::1:0::4:0", -- Steamsaw
	[17413]="0:9:0:1:Book::1:0::0:0", -- Codex: Prayer of Fortitude
	[17414]="0:9:0:1:Book::1:0::0:0", -- Codex: Prayer of Fortitude
	[17422]="0:12:1:100:::1:0::3:0", -- Armor Scraps
	[17423]="0:12:1:100:::1:0::3:0", -- Storm Crystal
	[17442]="0:12:1:1:::1:0::3:0", -- Frostwolf Assault Orders
	[17502]="0:12:1:100:::1:0::3:0", -- Frostwolf Soldier's Medal
	[17503]="0:12:1:100:::1:0::3:0", -- Frostwolf Lieutenant's Medal
	[17504]="0:12:1:100:::1:0::3:0", -- Frostwolf Commander's Medal
	[17508]="0:4:2:1:Shield::1:0::3:0", -- Forcestone Buckler
	[17522]="0:12:1:20:::1:0::4:0", -- Irondeep Supplies
	[17523]="0:4:2:1:Cloak::1:0::3:0", -- Smokey's Drape
	[17542]="0:12:1:20:::1:0::4:0", -- Coldtooth Supplies
	[17562]="0:4:3:1:Cloth::1:0::3:0", -- Knight-Lieutenant's Dreadweave Boots
	[17564]="0:4:3:1:Cloth::1:0::3:0", -- Knight-Lieutenant's Dreadweave Gloves
	[17566]="0:4:3:1:Cloth::1:0::3:0", -- Lieutenant Commander's Headguard
	[17567]="0:4:3:1:Cloth::1:0::3:0", -- Knight-Captain's Dreadweave Leggings
	[17568]="0:4:3:1:Cloth::1:0::3:0", -- Knight-Captain's Dreadweave Robe
	[17569]="0:4:3:1:Cloth::1:0::3:0", -- Lieutenant Commander's Dreadweave Mantle
	[17570]="0:4:3:1:Cloth::1:0::3:0", -- Champion's Dreadweave Hood
	[17571]="0:4:3:1:Cloth::1:0::3:0", -- Legionnaire's Dreadweave Leggings
	[17572]="0:4:3:1:Cloth::1:0::3:0", -- Legionnaire's Dreadweave Robe
	[17573]="0:4:3:1:Cloth::1:0::3:0", -- Champion's Dreadweave Shoulders
	[17576]="0:4:3:1:Cloth::1:0::3:0", -- Blood Guard's Dreadweave Boots
	[17577]="0:4:3:1:Cloth::1:0::3:0", -- Blood Guard's Dreadweave Gloves
	[17578]="118556:4:4:1:Cloth::1:0:12785:3:0", -- Field Marshal's Coronal
	[17579]="153098:4:4:1:Cloth::1:0:12785:3:0", -- Marshal's Dreadweave Leggings
	[17580]="119424:4:4:1:Cloth::1:0:12785:3:0", -- Field Marshal's Dreadweave Shoulders
	[17581]="159819:4:4:1:Cloth::1:0:12785:3:0", -- Field Marshal's Dreadweave Robe
	[17583]="116499:4:4:1:Cloth::1:0:12785:3:0", -- Marshal's Dreadweave Boots
	[17584]="79977:4:4:1:Cloth::1:0:12785:3:0", -- Marshal's Dreadweave Gloves
	[17586]="109325:4:4:1:Cloth::1:0:12795:3:0", -- General's Dreadweave Boots
	[17588]="73442:4:4:1:Cloth::1:0:12795:3:0", -- General's Dreadweave Gloves
	[17590]="115047:4:4:1:Cloth::1:0:12795:3:0", -- Warlord's Dreadweave Mantle
	[17591]="115475:4:4:1:Cloth::1:0:12795:3:0", -- Warlord's Dreadweave Hood
	[17592]="154553:4:4:1:Cloth::1:0:12795:3:0", -- Warlord's Dreadweave Robe
	[17593]="149700:4:4:1:Cloth::1:0:12795:3:0", -- General's Dreadweave Pants
	[17594]="0:4:3:1:Cloth::1:0::3:0", -- Knight-Lieutenant's Satin Boots
	[17596]="0:4:3:1:Cloth::1:0::3:0", -- Knight-Lieutenant's Satin Gloves
	[17598]="0:4:3:1:Cloth::1:0::3:0", -- Lieutenant Commander's Diadem
	[17599]="0:4:3:1:Cloth::1:0::3:0", -- Knight-Captain's Satin Leggings
	[17600]="0:4:3:1:Cloth::1:0::3:0", -- Knight-Captain's Satin Robes
	[17601]="0:4:3:1:Cloth::1:0::3:0", -- Lieutenant Commander's Satin Amice
	[17602]="123433:4:4:1:Cloth::1:0:12785:3:0", -- Field Marshal's Headdress
	[17603]="159372:4:4:1:Cloth::1:0:12785:3:0", -- Marshal's Satin Pants
	[17604]="124313:4:4:1:Cloth::1:0:12785:3:0", -- Field Marshal's Satin Mantle
	[17605]="166337:4:4:1:Cloth::1:0:12785:3:0", -- Field Marshal's Satin Vestments
	[17607]="109727:4:4:1:Cloth::1:0:12785:3:0", -- Marshal's Satin Sandals
	[17608]="73434:4:4:1:Cloth::1:0:12785:3:0", -- Marshal's Satin Gloves
	[17610]="0:4:3:1:Cloth::1:0::3:0", -- Champion's Satin Cowl
	[17611]="0:4:3:1:Cloth::1:0::3:0", -- Legionnaire's Satin Trousers
	[17612]="0:4:3:1:Cloth::1:0::3:0", -- Legionnaire's Satin Vestments
	[17613]="0:4:3:1:Cloth::1:0::3:0", -- Champion's Satin Shoulderpads
	[17616]="0:4:3:1:Cloth::1:0::3:0", -- Blood Guard's Satin Boots
	[17617]="0:4:3:1:Cloth::1:0::3:0", -- Blood Guard's Satin Gloves
	[17618]="117406:4:4:1:Cloth::1:0:12795:3:0", -- General's Satin Boots
	[17620]="78836:4:4:1:Cloth::1:0:12795:3:0", -- General's Satin Gloves
	[17622]="123421:4:4:1:Cloth::1:0:12795:3:0", -- Warlord's Satin Mantle
	[17623]="123861:4:4:1:Cloth::1:0:12795:3:0", -- Warlord's Satin Cowl
	[17624]="165735:4:4:1:Cloth::1:0:12795:3:0", -- Warlord's Satin Robes
	[17625]="160474:4:4:1:Cloth::1:0:12795:3:0", -- General's Satin Leggings
	[17626]="0:12:1:1:::1:0::3:0", -- Frostwolf Muzzle
	[17642]="0:12:1:100:::1:0::3:0", -- Alterac Ram Hide
	[17643]="0:12:1:100:::1:0::3:0", -- Frostwolf Hide
	[17662]="0:12:1:1:::1:0::4:0", -- Stolen Treats
	[17682]="0:9:0:1:Book::1:0::0:0", -- Book: Gift of the Wild
	[17683]="0:9:0:1:Book::1:0::0:0", -- Book: Gift of the Wild
	[17684]="0:12:1:30:::1:0::4:0", -- Theradric Crystal Carving
	[17685]="0:15:1:1:Junk::1:0::3:0", -- Smokywood Pastures Sampler
	[17686]="0:2:2:1:Bow::1:0::3:0", -- Master Hunter's Bow
	[17687]="0:2:2:1:Gun::1:0::3:0", -- Master Hunter's Rifle
	[17688]="0:4:2:1:Plate::1:0::3:0", -- Jungle Boots
	[17689]="0:12:1:1:::1:0::3:0", -- Stormpike Training Collar
	[17690]="0:4:2:1:Trinket::1:0::3:0", -- Frostwolf Insignia Rank 1
	[17691]="0:4:2:1:Trinket::1:0::3:0", -- Stormpike Insignia Rank 1
	[17692]="0:4:2:1:Ring::1:0::3:0", -- Horn Ring
	[17693]="0:12:1:1:::1:0::4:0", -- Coated Cerulean Vial
	[17694]="0:4:2:1:Ring::1:0::3:0", -- Band of the Fist
	[17695]="0:4:2:1:Cloth::1:0::3:0", -- Chestnut Mantle
	[17696]="0:12:1:1:::1:0::4:0", -- Filled Cerulean Vial
	[17702]="0:12:1:1:::1:0::4:0", -- Celebrian Rod
	[17703]="0:12:1:1:::1:0::4:0", -- Celebrian Diamond
	[17704]="0:2:2:1:OneHandAxe::1:0::2:0", -- Edge of Winter
	[17705]="0:2:3:1:OneHandSword::1:0::3:0", -- Thrash Blade
	[17706]="0:9:2:1:Blacksmithing::1:0::0:0", -- Plans: Edge of Winter
	[17707]="0:4:3:1:Amulet::1:0::3:0", -- Gemshard Heart
	[17708]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Frost Power
	[17709]="0:9:1:1:Alchemy::1:0::0:0", -- Recipe: Elixir of Frost Power
	[17710]="0:2:3:1:Dagger::1:0::3:0", -- Charstone Dirk
	[17711]="0:4:3:1:Mail::1:0::3:0", -- Elemental Rockridge Leggings
	[17712]="0:15:1:1:Junk::1:0::3:0", -- Winter Veil Disguise Kit
	[17713]="0:4:3:1:Ring::1:0::3:0", -- Blackstone Ring
	[17714]="0:4:3:1:Mail::1:0::3:0", -- Bracers of the Stone Princess
	[17715]="0:4:3:1:Cloth::1:0::3:0", -- Eye of Theradras
	[17716]="0:7:1:1:Device::1:0::0:0", -- Snowmaster 9000
	[17717]="0:2:3:1:Gun::1:0::3:0", -- Megashot Rifle
	[17718]="0:4:3:1:Shield::1:0::3:0", -- Gizlock's Hypertech Buckler
	[17719]="0:2:3:1:OneHandSword::1:0::3:0", -- Inventor's Focal Sword
	[17720]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Snowmaster 9000
	[17721]="0:4:2:1:Leather::1:0::2:0", -- Gloves of the Greatfather
	[17722]="0:9:2:1:Leatherworking::1:0::0:0", -- Pattern: Gloves of the Greatfather
	[17723]="0:4:1:1:Shirt::1:0::0:0", -- Green Holiday Shirt
	[17724]="0:9:1:1:Tailoring::1:0::0:0", -- Pattern: Green Holiday Shirt
	[17725]="0:9:2:1:Enchanting::1:0::0:0", -- Formula: Enchant Weapon - Winter's Might
	[17726]="0:15:1:1:Junk::1:0::3:0", -- Smokywood Pastures Special Gift
	[17727]="0:15:1:1:Junk::1:0::3:0", -- Smokywood Pastures Gift Pack
	[17728]="0:4:3:1:Leather::1:0::3:0", -- Albino Crocscale Boots
	[17730]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Gatorbite Axe
	[17732]="0:4:3:1:Cloth::1:0::3:0", -- Rotgrip Mantle
	[17733]="0:2:3:1:OneHandMace::1:0::3:0", -- Fist of Stone
	[17734]="0:4:3:1:Mail::1:0::3:0", -- Helm of the Mountain
	[17735]="0:12:1:1:::1:0::4:0", -- The Feast of Winter Veil
	[17736]="0:4:3:1:Mail::1:0::3:0", -- Rockgrip Gauntlets
	[17737]="0:4:3:1:OffHandFrill::1:0::3:0", -- Cloud Stone
	[17738]="0:2:3:1:FistWeapon::1:0::3:0", -- Claw of Celebras
	[17739]="0:4:3:1:Cloak::1:0::3:0", -- Grovekeeper's Drape
	[17740]="0:4:3:1:Leather::1:0::3:0", -- Soothsayer's Headdress
	[17741]="0:4:3:1:Cloth::1:0::3:0", -- Nature's Embrace
	[17742]="0:4:3:1:Leather::1:0::3:0", -- Fungus Shroud Armor
	[17743]="0:2:3:1:Stave::1:0::3:0", -- Resurgence Rod
	[17744]="0:4:3:1:Trinket::1:0::3:0", -- Heart of Noxxion
	[17745]="0:2:3:1:Wand::1:0::3:0", -- Noxious Shooter
	[17746]="0:4:3:1:Mail::1:0::3:0", -- Noxxion's Shackles
	[17747]="0:0:1:5:Other::1:0::0:0", -- Razorlash Root
	[17748]="0:4:3:1:Cloth::1:0::3:0", -- Vinerot Sandals
	[17749]="0:4:3:1:Leather::1:0::3:0", -- Phytoskin Spaulders
	[17750]="0:4:3:1:Cloth::1:0::3:0", -- Chloromesh Girdle
	[17751]="0:4:3:1:Leather::1:0::3:0", -- Brusslehide Leggings
	[17752]="0:2:3:1:Dagger::1:0::3:0", -- Satyr's Lash
	[17753]="0:2:3:1:Bow::1:0::3:0", -- Verdant Keeper's Aim
	[17754]="0:4:3:1:Mail::1:0::3:0", -- Infernal Trickster Leggings
	[17755]="0:4:3:1:Cloth::1:0::3:0", -- Satyrmane Sash
	[17756]="0:12:1:20:::1:0::4:0", -- Shadowshard Fragment
	[17757]="0:12:1:1:::1:0::4:0", -- Amulet of Spirits
	[17758]="0:12:1:1:::1:0::4:0", -- Amulet of Union
	[17759]="0:4:3:1:Trinket::1:0::3:0", -- Mark of Resolution
	[17760]="0:12:1:1:::1:0::4:0", -- Seed of Life
	[17761]="0:12:1:1:::1:0::3:0", -- Gem of the First Khan
	[17762]="0:12:1:1:::1:0::3:0", -- Gem of the Second Khan
	[17763]="0:12:1:1:::1:0::3:0", -- Gem of the Third Khan
	[17764]="0:12:1:1:::1:0::3:0", -- Gem of the Fourth Khan
	[17765]="0:12:1:1:::1:0::3:0", -- Gem of the Fifth Khan
	[17766]="0:2:3:1:TwoHandMace::1:0::3:0", -- Princess Theradras' Scepter
	[17767]="0:4:3:1:Mail::1:0::3:0", -- Bloomsprout Headpiece
	[17768]="0:4:3:1:Ring::1:0::3:0", -- Woodseed Hoop
	[17770]="0:4:3:1:Plate::1:0::3:0", -- Branchclaw Gauntlets
	[17771]="0:7:5:20:MetalStone::1:0::0:0", -- Enchanted Elementium Bar
	[17772]="0:4:3:1:Amulet::1:0::3:0", -- Zealous Shadowshard Pendant
	[17773]="0:4:3:1:Amulet::1:0::3:0", -- Prodigious Shadowshard Pendant
	[17774]="0:4:3:1:Trinket::1:0::3:0", -- Mark of the Chosen
	[17775]="0:4:3:1:Cloth::1:0::3:0", -- Acumen Robes
	[17776]="0:4:3:1:Leather::1:0::3:0", -- Sprightring Helm
	[17777]="0:4:3:1:Mail::1:0::3:0", -- Relentless Chain
	[17778]="0:4:3:1:Leather::1:0::3:0", -- Sagebrush Girdle
	[17779]="0:4:3:1:Mail::1:0::3:0", -- Hulkstone Pauldrons
	[17780]="0:2:4:1:Dagger::1:0::3:0", -- Blade of Eternal Darkness
	[17781]="0:12:1:1:::1:0::0:0", -- The Pariah's Instructions
	[17782]="0:4:5:1:Amulet::1:0::3:0", -- Talisman of Binding Shard
	[17822]="0:12:1:1:::1:0::4:0", -- Frostwolf Maps
	[17823]="0:12:1:1:::1:0::4:0", -- Stormpike Battle Plans
	[17849]="0:12:1:1:::1:0::4:0", -- Stormpike Banner
	[17850]="0:12:1:1:::1:0::4:0", -- Frostwolf Banner
	[17900]="0:4:2:1:Trinket::1:0::3:0", -- Stormpike Insignia Rank 2
	[17901]="0:4:2:1:Trinket::1:0::3:0", -- Stormpike Insignia Rank 3
	[17902]="0:4:3:1:Trinket::1:0::3:0", -- Stormpike Insignia Rank 4
	[17903]="0:4:3:1:Trinket::1:0::3:0", -- Stormpike Insignia Rank 5
	[17904]="0:4:4:1:Trinket::1:0::3:0", -- Stormpike Insignia Rank 6
	[17905]="0:4:2:1:Trinket::1:0::3:0", -- Frostwolf Insignia Rank 2
	[17906]="0:4:2:1:Trinket::1:0::3:0", -- Frostwolf Insignia Rank 3
	[17907]="0:4:3:1:Trinket::1:0::3:0", -- Frostwolf Insignia Rank 4
	[17908]="0:4:3:1:Trinket::1:0::3:0", -- Frostwolf Insignia Rank 5
	[17909]="0:4:4:1:Trinket::1:0::3:0", -- Frostwolf Insignia Rank 6
	[17922]="0:4:2:1:Leather::1:0::2:0", -- Lionfur Armor
	[17943]="0:2:3:1:OneHandMace::1:0::3:0", -- Fist of Stone
	[17962]="0:15:2:1:Junk::1:0::3:0", -- Blue Sack of Gems
	[17963]="0:15:2:1:Junk::1:0::0:0", -- Green Sack of Gems
	[17964]="0:15:2:1:Junk::1:0::0:0", -- Gray Sack of Gems
	[17965]="0:15:2:1:Junk::1:0::0:0", -- Yellow Sack of Gems
	[17966]="0:1:2:1:Bag::1:0::3:0", -- Onyxia Hide Backpack
	[17967]="0:7:3:20:Leather::1:0::0:0", -- Refined Scale of Onyxia
	[17968]="0:7:3:20:Other::1:0::0:0", -- Charged Scale of Onyxia
	[17969]="0:15:2:1:Junk::1:0::0:0", -- Red Sack of Gems
	[17982]="0:4:3:1:Ring::1:0::3:0", -- Ragnaros Core
	[18022]="0:4:3:1:Ring::1:0::3:0", -- Royal Seal of Alexis
	[18042]="0:15:0:1000:Junk::1:0::0:0", -- Thorium Headed Arrow
	[18043]="0:4:3:1:Leather::1:0::3:0", -- Coal Miner Boots
	[18044]="0:2:3:1:OneHandMace::1:0::3:0", -- Hurley's Tankard
	[18045]="0:0:1:20:FoodDrink::1:0::0:0", -- Tender Wolf Steak
	[18046]="12000:9:1:1:Cooking::1:0:4782,7733,40589:0:0", -- Recipe: Tender Wolf Steak
	[18047]="0:4:3:1:Mail::1:0::3:0", -- Flame Walkers
	[18048]="0:2:3:1:OneHandMace::1:0::3:0", -- Mastersmith's Hammer
	[18082]="0:2:3:1:Stave::1:0::3:0", -- Zum'rah's Vexing Cane
	[18083]="0:4:3:1:Cloth::1:0::3:0", -- Jumanza Grips
	[18102]="0:4:3:1:Cloth::1:0::3:0", -- Dragonrider Boots
	[18103]="0:4:3:1:Ring::1:0::3:0", -- Band of Rumination
	[18104]="0:4:3:1:Mail::1:0::3:0", -- Feralsurge Girdle
	[18142]="0:12:1:100:::1:0::3:0", -- Severed Night Elf Head
	[18143]="0:12:1:100:::1:0::3:0", -- Tuft of Gnome Hair
	[18144]="0:12:1:100:::1:0::3:0", -- Human Bone Chip
	[18145]="0:12:1:100:::1:0::3:0", -- Tauren Hoof
	[18146]="0:12:1:100:::1:0::3:0", -- Darkspear Troll Mojo
	[18147]="0:12:1:100:::1:0::3:0", -- Forsaken Heart
	[18148]="0:12:1:1:::1:0::4:0", -- Skull of Korrak
	[18149]="0:12:2:1:::1:0::3:0", -- Rune of Recall
	[18150]="0:12:2:1:::1:0::3:0", -- Rune of Recall
	[18151]="0:12:1:1:::1:0::4:0", -- Filled Amethyst Phial
	[18152]="0:12:1:1:::1:0::4:0", -- Amethyst Phial
	[18154]="0:0:1:1:Other::1:0::0:0", -- Blizzard Stationery
	[18160]="200:9:2:1:Cooking::1:0:6779:3:0", -- Recipe: Thistle Tea
	[18168]="0:4:4:1:Shield::1:0::2:0", -- Force Reactive Disk
	[18169]="100000:0:2:1:EnhPerm::1:0:10857,11536:3:0", -- Flame Mantle of the Dawn
	[18170]="100000:0:2:1:EnhPerm::1:0:10857,11536:3:0", -- Frost Mantle of the Dawn
	[18171]="100000:0:2:1:EnhPerm::1:0:10857,11536:3:0", -- Arcane Mantle of the Dawn
	[18172]="100000:0:2:1:EnhPerm::1:0:10857,11536:3:0", -- Nature Mantle of the Dawn
	[18173]="100000:0:2:1:EnhPerm::1:0:10857,11536:3:0", -- Shadow Mantle of the Dawn
	[18182]="400000:0:2:1:EnhPerm::1:0:11536:3:0", -- Chromatic Mantle of the Dawn
	[18202]="0:2:4:1:FistWeapon::1:0::3:0", -- Eskhandar's Left Claw
	[18203]="0:2:4:1:FistWeapon::1:0::3:0", -- Eskhandar's Right Claw
	[18204]="0:4:4:1:Cloak::1:0::3:0", -- Eskhandar's Pelt
	[18205]="0:4:4:1:Amulet::1:0::3:0", -- Eskhandar's Collar
	[18206]="0:12:1:100:::1:0::3:0", -- Dwarf Spine
	[18207]="0:12:1:100:::1:0::3:0", -- Orc Tooth
	[18208]="0:4:4:1:Cloak::1:0::3:0", -- Drape of Benediction
	[18222]="0:15:0:20:Junk::1:0::0:0", -- Thorny Vine
	[18223]="0:15:0:20:Junk::1:0::0:0", -- Serrated Petal
	[18224]="0:15:0:40:Junk::1:0::0:0", -- Lasher Blossom
	[18225]="0:15:0:20:Junk::1:0::0:0", -- Worn Running Shoes
	[18226]="0:15:0:20:Junk::1:0::0:0", -- A Sealed Pact
	[18227]="0:15:0:20:Junk::1:0::0:0", -- Nubless Pacifier
	[18228]="0:15:0:1:Junk::1:0::0:0", -- Autographed Picture of Foror & Tigule
	[18229]="0:15:0:1:Junk::1:0::0:0", -- Nat Pagle's Guide to Extreme Anglin'
	[18230]="0:15:0:20:Junk::1:0::0:0", -- Broken I.W.I.N. Button
	[18231]="0:4:1:1:Shirt::1:0::0:0", -- Sleeveless T-Shirt
	[18232]="0:7:1:5:Device:202:1:0::0:0", -- Field Repair Bot 74A
	[18233]="0:15:0:20:Junk::1:0::0:0", -- Tear Stained Handkerchief
	[18234]="0:15:0:20:Junk::1:0::0:0", -- Document from Boomstick Imports
	[18236]="0:15:0:20:Junk::1:0::0:0", -- Gordok Chew Toy
	[18237]="0:15:0:20:Junk::1:0::0:0", -- Mastiff Jawbone
	[18238]="0:4:3:1:Leather::1:0::2:0", -- Shadowskin Gloves
	[18239]="3500:9:1:1:Leatherworking::1:1:2699:0:0", -- Pattern: Shadowskin Gloves
	[18240]="0:7:2:20:Other:165,197:1:0::3:0", -- Ogre Tannin
	[18249]="0:13:1:1:::1:0::3:0", -- Crescent Key
	[18250]="0:13:2:1:::1:0::3:0", -- Gordok Shackle Key
	[18251]="0:0:3:10:EnhPerm::1:0::0:0", -- Core Armor Kit
	[18252]="0:9:3:1:Leatherworking::1:0::3:0", -- Pattern: Core Armor Kit
	[18253]="0:0:1:20:Potion::1:0::0:0", -- Major Rejuvenation Potion
	[18254]="0:0:1:20:FoodDrink::1:0::0:0", -- Runn Tum Tuber Surprise
	[18255]="0:0:1:20:FoodDrink:185:1:0::0:0", -- Runn Tum Tuber
	[18256]="0:7:0:20:Other::1:0::0:0", -- Melted Vial
	[18257]="0:9:3:1:Alchemy::1:0::0:0", -- Recipe: Major Rejuvenation Potion
	[18258]="0:12:2:1:::1:0::0:0", -- Gordok Ogre Suit
	[18259]="0:9:3:1:Enchanting::1:0::0:0", -- Formula: Enchant Weapon - Spellpower
	[18260]="0:9:3:1:Enchanting::1:0::0:0", -- Formula: Enchant Weapon - Healing Power
	[18261]="0:12:1:1:::1:0::4:0", -- Book of Incantations
	[18262]="0:0:2:20:EnhTemp::1:0::0:0", -- Elemental Sharpening Stone
	[18263]="0:4:4:1:Cloth::1:0::2:0", -- Flarecore Wraps
	[18264]="0:9:3:1:Blacksmithing::1:0::3:0", -- Plans: Elemental Sharpening Stone
	[18265]="0:9:3:1:Tailoring::1:0::0:0", -- Pattern: Flarecore Wraps
	[18266]="0:13:1:1:::1:0::3:0", -- Gordok Courtyard Key
	[18267]="0:9:2:1:Cooking::1:0::3:0", -- Recipe: Runn Tum Tuber Surprise
	[18268]="0:13:1:1:::1:0::3:0", -- Gordok Inner Door Key
	[18269]="1500:0:2:10:Consumable::1:0:14322:3:0", -- Gordok Green Grog
	[18282]="0:2:4:1:Gun::1:0::2:0", -- Core Marksman Rifle
	[18283]="0:0:3:5:EnhPerm::1:0::0:0", -- Biznicks 247x128 Accurascope
	[18284]="1500:0:2:10:Consumable::1:0:14322:3:0", -- Kreeg's Stout Beatdown
	[18285]="0:15:0:20:Junk::1:0::0:0", -- Crystallized Mana Shard
	[18286]="0:15:0:20:Junk::1:0::0:0", -- Condensed Mana Fragment
	[18287]="200:0:1:20:FoodDrink::1:0:14322:0:0", -- Evermurky
	[18288]="1000:0:1:20:FoodDrink::1:0:14322:0:0", -- Molasses Firewater
	[18289]="0:4:3:1:Amulet::1:0::2:0", -- Barbed Thorn Necklace
	[18290]="0:9:3:1:Engineering::1:0::3:0", -- Schematic: Biznicks 247x128 Accurascope
	[18291]="0:9:3:1:Engineering::1:0::3:0", -- Schematic: Force Reactive Disk
	[18292]="0:9:3:1:Engineering::1:0::3:0", -- Schematic: Core Marksman Rifle
	[18294]="0:0:1:20:Elixir::1:0::0:0", -- Elixir of Greater Water Breathing
	[18295]="0:4:3:1:Cloth::1:0::2:0", -- Phasing Boots
	[18296]="0:4:3:1:Mail::1:0::2:0", -- Marksman Bands
	[18297]="0:0:1:5:Consumable::1:0::3:0", -- Thornling Seed
	[18298]="0:4:3:1:Leather::1:0::2:0", -- Unbridled Leggings
	[18299]="0:12:1:1:::1:0::4:0", -- Hydrospawn Essence
	[18300]="0:0:1:20:FoodDrink::1:0::0:0", -- Hyjal Nectar
	[18301]="0:2:3:1:Wand::1:0::3:0", -- Lethtendris' Wand
	[18302]="0:4:3:1:Ring::1:0::3:0", -- Band of Vigor
	[18305]="0:4:3:1:Mail::1:0::3:0", -- Breakwater Legguards
	[18306]="0:4:3:1:Cloth::1:0::3:0", -- Gloves of Shadowy Mist
	[18307]="0:4:3:1:Cloth::1:0::3:0", -- Riptide Shoes
	[18308]="0:4:3:1:Leather::1:0::3:0", -- Clever Hat
	[18309]="0:4:3:1:Leather::1:0::3:0", -- Gloves of Restoration
	[18310]="0:2:3:1:OneHandSword::1:0::3:0", -- Fiendish Machete
	[18311]="0:2:3:1:Stave::1:0::3:0", -- Quel'dorei Channeling Rod
	[18312]="0:4:3:1:Mail::1:0::3:0", -- Energized Chestplate
	[18313]="0:4:3:1:Mail::1:0::3:0", -- Helm of Awareness
	[18314]="0:4:3:1:Ring::1:0::3:0", -- Ring of Demonic Guile
	[18315]="0:4:3:1:Ring::1:0::3:0", -- Ring of Demonic Potency
	[18317]="0:4:3:1:Amulet::1:0::3:0", -- Tempest Talisman
	[18318]="0:4:3:1:Leather::1:0::3:0", -- Merciful Greaves
	[18319]="0:4:3:1:Leather::1:0::3:0", -- Fervent Helm
	[18321]="0:2:3:1:OneHandMace::1:0::3:0", -- Energetic Rod
	[18322]="0:4:3:1:Leather::1:0::3:0", -- Waterspout Boots
	[18323]="0:2:3:1:Bow::1:0::3:0", -- Satyr's Bow
	[18324]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Waveslicer
	[18325]="0:4:3:1:Leather::1:0::3:0", -- Felhide Cap
	[18326]="0:4:3:1:Mail::1:0::3:0", -- Razor Gauntlets
	[18327]="0:4:3:1:Cloth::1:0::3:0", -- Whipvine Cord
	[18328]="0:4:3:1:Cloak::1:0::3:0", -- Shadewood Cloak
	[18329]="0:0:2:1:EnhPerm::1:0::3:0", -- Arcanum of Rapidity
	[18330]="0:0:2:1:EnhPerm::1:0::3:0", -- Arcanum of Focus
	[18331]="0:0:2:1:EnhPerm::1:0::3:0", -- Arcanum of Protection
	[18332]="0:9:2:1:Book::1:0::0:0", -- Libram of Rapidity
	[18333]="0:9:2:1:Book::1:0::0:0", -- Libram of Focus
	[18334]="0:9:2:1:Book::1:0::0:0", -- Libram of Protection
	[18335]="0:12:3:20::755:1:0::0:0", -- Pristine Black Diamond
	[18336]="0:12:1:1:::1:0::4:0", -- Gauntlet of Gordok Might
	[18337]="0:4:3:1:Cloth::1:0::2:0", -- Orphic Bracers
	[18338]="0:2:3:1:Wand::1:0::2:0", -- Wand of Arcane Potency
	[18339]="0:4:3:1:Cloak::1:0::2:0", -- Eidolon Cloak
	[18340]="0:4:3:1:Amulet::1:0::2:0", -- Eidolon Talisman
	[18343]="0:4:2:1:Ring::1:0::2:0", -- Petrified Band
	[18344]="0:4:3:1:Leather::1:0::2:0", -- Stonebark Gauntlets
	[18345]="0:4:3:1:Ring::1:0::3:0", -- Murmuring Ring
	[18346]="0:4:3:1:Cloth::1:0::3:0", -- Threadbare Trousers
	[18347]="0:2:3:1:OneHandAxe::1:0::3:0", -- Well Balanced Axe
	[18348]="0:2:4:1:OneHandSword::1:0::3:0", -- Quel'Serrar
	[18349]="0:4:3:1:Mail::1:0::3:0", -- Gauntlets of Accuracy
	[18350]="0:4:3:1:Cloak::1:0::3:0", -- Amplifying Cloak
	[18351]="0:4:3:1:Plate::1:0::3:0", -- Magically Sealed Bracers
	[18352]="0:4:3:1:Shield::1:0::3:0", -- Petrified Bark Shield
	[18353]="0:2:3:1:Stave::1:0::3:0", -- Stoneflower Staff
	[18354]="0:4:3:1:Trinket::1:0::3:0", -- Pimgib's Collar
	[18356]="0:12:3:1:::1:0::0:0", -- Garona: A Study on Stealth and Treachery
	[18357]="0:12:3:1:::1:0::0:0", -- Codex of Defense
	[18358]="0:12:3:1:::1:0::0:0", -- The Arcanist's Cookbook
	[18359]="0:12:3:1:::1:0::0:0", -- The Light and How to Swing It
	[18360]="0:12:3:1:::1:0::0:0", -- Harnessing Shadows
	[18361]="0:12:3:1:::1:0::0:0", -- The Greatest Race of Hunters
	[18362]="0:12:3:1:::1:0::0:0", -- Holy Bologna: What the Light Won't Tell You
	[18363]="0:12:3:1:::1:0::0:0", -- Frost Shock and You
	[18364]="0:12:3:1:::1:0::0:0", -- The Emerald Dream
	[18365]="0:15:0:1:Junk::1:0::0:0", -- A Thoroughly Read Copy of "Nat Pagle's Extreme' Anglin."
	[18366]="0:4:3:1:Plate::1:0::3:0", -- Gordok's Handguards
	[18367]="0:4:3:1:Mail::1:0::3:0", -- Gordok's Gauntlets
	[18368]="0:4:3:1:Leather::1:0::3:0", -- Gordok's Gloves
	[18369]="0:4:3:1:Cloth::1:0::3:0", -- Gordok's Handwraps
	[18370]="0:4:3:1:Trinket::1:0::3:0", -- Vigilance Charm
	[18371]="0:4:3:1:Trinket::1:0::3:0", -- Mindtap Talisman
	[18372]="0:2:3:1:Dagger::1:0::3:0", -- Blade of the New Moon
	[18373]="0:4:3:1:Leather::1:0::3:0", -- Chestplate of Tranquility
	[18374]="0:4:3:1:Leather::1:0::3:0", -- Flamescarred Shoulders
	[18375]="0:4:3:1:Leather::1:0::3:0", -- Bracers of the Eclipse
	[18376]="0:2:3:1:OneHandMace::1:0::3:0", -- Timeworn Mace
	[18377]="0:4:3:1:Leather::1:0::3:0", -- Quickdraw Gloves
	[18378]="0:4:3:1:Mail::1:0::3:0", -- Silvermoon Leggings
	[18379]="0:4:3:1:Mail::1:0::3:0", -- Odious Greaves
	[18380]="0:4:3:1:Plate::1:0::3:0", -- Eldritch Reinforced Legplates
	[18381]="0:4:3:1:Amulet::1:0::3:0", -- Evil Eye Pendant
	[18382]="0:4:3:1:Cloak::1:0::3:0", -- Fluctuating Cloak
	[18383]="0:4:3:1:Plate::1:0::3:0", -- Force Imbued Gauntlets
	[18384]="0:4:3:1:Plate::1:0::3:0", -- Bile-Etched Spaulders
	[18385]="0:4:3:1:Cloth::1:0::3:0", -- Robe of Everlasting Night
	[18386]="0:4:3:1:Cloth::1:0::3:0", -- Padre's Trousers
	[18387]="0:4:3:1:Cloth::1:0::3:0", -- Brightspark Gloves
	[18388]="0:2:3:1:Crossbow::1:0::3:0", -- Stoneshatter
	[18389]="0:4:3:1:Cloak::1:0::3:0", -- Cloak of the Cosmos
	[18390]="0:4:3:1:Leather::1:0::3:0", -- Tanglemoss Leggings
	[18391]="0:4:3:1:Leather::1:0::3:0", -- Eyestalk Cord
	[18392]="0:2:3:1:Dagger::1:0::3:0", -- Distracting Dagger
	[18393]="0:4:3:1:Mail::1:0::3:0", -- Warpwood Binding
	[18394]="0:4:3:1:Mail::1:0::3:0", -- Demon Howl Wristguards
	[18395]="0:4:3:1:Ring::1:0::3:0", -- Emerald Flame Ring
	[18396]="0:2:3:1:OneHandSword::1:0::3:0", -- Mind Carver
	[18397]="0:4:3:1:Amulet::1:0::3:0", -- Elder Magus Pendant
	[18398]="0:4:3:1:Ring::1:0::3:0", -- Tidal Loop
	[18399]="0:4:3:1:Ring::1:0::3:0", -- Ocean's Breeze
	[18400]="0:4:2:1:Ring::1:0::3:0", -- Ring of Living Stone
	[18401]="0:12:0:1:::1:0::0:0", -- Foror's Compendium of Dragon Slaying
	[18402]="0:4:2:1:Ring::1:0::3:0", -- Glowing Crystal Ring
	[18403]="0:4:4:1:Ring::1:0::3:0", -- Dragonslayer's Signet
	[18404]="0:4:4:1:Amulet::1:0::3:0", -- Onyxia Tooth Pendant
	[18405]="0:4:4:1:Cloth::1:0::2:0", -- Belt of the Archmage
	[18406]="0:4:4:1:Trinket::1:0::3:0", -- Onyxia Blood Talisman
	[18407]="0:4:3:1:Cloth::1:0::2:0", -- Felcloth Gloves
	[18408]="0:4:3:1:Cloth::1:0::2:0", -- Inferno Gloves
	[18409]="0:4:3:1:Cloth::1:0::2:0", -- Mooncloth Gloves
	[18410]="0:2:2:1:TwoHandSword::1:0::3:0", -- Sprinter's Sword
	[18411]="0:4:2:1:Leather::1:0::3:0", -- Spry Boots
	[18412]="0:12:1:1:::1:0::4:0", -- Core Fragment
	[18413]="0:4:3:1:Cloak::1:0::2:0", -- Cloak of Warding
	[18414]="0:9:4:1:Tailoring::1:0::0:0", -- Pattern: Belt of the Archmage
	[18415]="0:9:3:1:Tailoring::1:0::3:0", -- Pattern: Felcloth Gloves
	[18416]="0:9:3:1:Tailoring::1:0::3:0", -- Pattern: Inferno Gloves
	[18417]="0:9:3:1:Tailoring::1:0::3:0", -- Pattern: Mooncloth Gloves
	[18418]="0:9:3:1:Tailoring::1:0::3:0", -- Pattern: Cloak of Warding
	[18420]="0:2:3:1:TwoHandMace::1:0::3:0", -- Bonecrusher
	[18421]="0:4:3:1:Mail::1:0::3:0", -- Backwood Helm
	[18422]="0:12:4:1:::1:0::3:0", -- Head of Onyxia
	[18423]="0:12:4:1:::1:0::3:0", -- Head of Onyxia
	[18424]="0:4:3:1:Leather::1:0::3:0", -- Sedge Boots
	[18425]="0:4:3:1:OffHandFrill::1:0::3:0", -- Kreeg's Mug
	[18426]="0:12:1:1:::1:0::4:0", -- Lethtendris' Web
	[18427]="13223:4:3:1:Cloak::1:0:12795:3:0", -- Sergeant's Cloak
	[18428]="1:4:3:1:Amulet::1:0:12795:3:0", -- Senior Sergeant's Insignia
	[18429]="93296:4:3:1:Plate::1:0:12795:3:0", -- First Sergeant's Plate Bracers
	[18430]="50658:4:3:1:Plate::1:0:12795:3:0", -- First Sergeant's Plate Bracers
	[18432]="43485:4:3:1:Mail::1:0:12795:3:0", -- First Sergeant's Mail Wristguards
	[18434]="67447:4:3:1:Leather::1:0:12795:3:0", -- First Sergeant's Dragonhide Armguards
	[18435]="36623:4:3:1:Leather::1:0:12795:3:0", -- First Sergeant's Leather Armguards
	[18436]="34173:4:3:1:Leather::1:0:12795:3:0", -- First Sergeant's Dragonhide Armguards
	[18437]="27442:4:3:1:Cloth::1:0:12795:3:0", -- First Sergeant's Silk Cuffs
	[18440]="12887:4:3:1:Cloak::1:0:12785,12805:3:0", -- Sergeant's Cape
	[18441]="41782:4:3:1:Cloak::1:0:12785,12805:3:0", -- Sergeant's Cape
	[18442]="1:4:3:1:Amulet::1:0:12785,12805:3:0", -- Master Sergeant's Insignia
	[18443]="1:4:3:1:Amulet::1:0:12785,12805:3:0", -- Master Sergeant's Insignia
	[18444]="1:4:3:1:Amulet::1:0:12785,12805:3:0", -- Master Sergeant's Insignia
	[18445]="91946:4:3:1:Plate::1:0:12785,12805:3:0", -- Sergeant Major's Plate Wristguards
	[18447]="50110:4:3:1:Plate::1:0:12785,12805:3:0", -- Sergeant Major's Plate Wristguards
	[18448]="79218:4:3:1:Mail::1:0:12785,12805:3:0", -- Sergeant Major's Chain Armguards
	[18449]="43014:4:3:1:Mail::1:0:12785,12805:3:0", -- Sergeant Major's Chain Armguards
	[18450]="0:4:3:1:Cloth::1:0::3:0", -- Robe of Combustion
	[18451]="0:4:3:1:Leather::1:0::3:0", -- Hyena Hide Belt
	[18452]="62199:4:3:1:Leather::1:0:12785,12805:3:0", -- Sergeant Major's Leather Armsplints
	[18453]="33780:4:3:1:Leather::1:0:12785,12805:3:0", -- Sergeant Major's Leather Armsplints
	[18454]="62672:4:3:1:Leather::1:0:12785,12805:3:0", -- Sergeant Major's Dragonhide Armsplints
	[18455]="34040:4:3:1:Leather::1:0:12785,12805:3:0", -- Sergeant Major's Dragonhide Armsplints
	[18456]="50521:4:3:1:Cloth::1:0:12785,12805:3:0", -- Sergeant Major's Silk Cuffs
	[18457]="27436:4:3:1:Cloth::1:0:12785,12805:3:0", -- Sergeant Major's Silk Cuffs
	[18458]="0:4:3:1:Mail::1:0::3:0", -- Modest Armguards
	[18459]="0:4:3:1:Plate::1:0::3:0", -- Gallant's Wristguards
	[18460]="0:2:3:1:Gun::1:0::3:0", -- Unsophisticated Hand Cannon
	[18461]="77204:4:3:1:Cloak::1:0:12795:3:0", -- Sergeant's Cloak
	[18462]="0:2:3:1:FistWeapon::1:0::3:0", -- Jagged Bone Fist
	[18463]="0:2:3:1:OneHandSword::1:0::3:0", -- Ogre Pocket Knife
	[18464]="0:4:3:1:Ring::1:0::3:0", -- Gordok Nose Ring
	[18465]="0:4:3:1:Trinket::1:0::3:0", -- Royal Seal of Eldre'Thalas
	[18466]="0:4:3:1:Trinket::1:0::3:0", -- Royal Seal of Eldre'Thalas
	[18467]="0:4:3:1:Trinket::1:0::3:0", -- Royal Seal of Eldre'Thalas
	[18468]="0:4:3:1:Trinket::1:0::3:0", -- Royal Seal of Eldre'Thalas
	[18469]="0:4:3:1:Trinket::1:0::3:0", -- Royal Seal of Eldre'Thalas
	[18470]="0:4:3:1:Trinket::1:0::3:0", -- Royal Seal of Eldre'Thalas
	[18471]="0:4:3:1:Trinket::1:0::3:0", -- Royal Seal of Eldre'Thalas
	[18472]="0:4:3:1:Trinket::1:0::3:0", -- Royal Seal of Eldre'Thalas
	[18473]="0:4:3:1:Trinket::1:0::3:0", -- Royal Seal of Eldre'Thalas
	[18475]="0:4:3:1:Cloth::1:0::3:0", -- Oddly Magical Belt
	[18476]="0:4:3:1:Leather::1:0::3:0", -- Mud Stained Boots
	[18477]="0:4:3:1:Leather::1:0::3:0", -- Shaggy Leggings
	[18478]="0:4:3:1:Leather::1:0::3:0", -- Hyena Hide Jerkin
	[18479]="0:4:3:1:Mail::1:0::3:0", -- Carrion Scorpid Helm
	[18480]="0:4:3:1:Plate::1:0::3:0", -- Scarab Plate Helm
	[18481]="0:2:3:1:TwoHandMace::1:0::3:0", -- Skullcracking Mace
	[18482]="0:2:3:1:Bow::1:0::3:0", -- Ogre Toothpick Shooter
	[18483]="0:2:3:1:Wand::1:0::3:0", -- Mana Channeling Wand
	[18484]="0:2:3:1:OneHandSword::1:0::3:0", -- Cho'Rush's Blade
	[18485]="0:4:3:1:Shield::1:0::3:0", -- Observer's Shield
	[18486]="0:4:3:1:Cloth::1:0::2:0", -- Mooncloth Robe
	[18487]="40000:9:1:1:Tailoring::1:1:14371:0:0", -- Pattern: Mooncloth Robe
	[18488]="0:12:1:1:::1:0::4:0", -- Heated Ancient Blade
	[18489]="0:12:4:1:::1:0::3:0", -- Unfired Ancient Blade
	[18490]="0:4:3:1:Leather::1:0::3:0", -- Insightful Hood
	[18491]="0:2:3:1:Dagger::1:0::3:0", -- Lorespinner
	[18492]="0:12:1:1:::1:0::4:0", -- Treated Ancient Blade
	[18493]="0:4:3:1:Plate::1:0::3:0", -- Bulky Iron Spaulders
	[18494]="0:4:3:1:Mail::1:0::3:0", -- Denwatcher's Shoulders
	[18495]="0:4:3:1:Cloak::1:0::3:0", -- Redoubt Cloak
	[18496]="0:4:3:1:Cloak::1:0::3:0", -- Heliotrope Cloak
	[18497]="0:4:3:1:Cloth::1:0::3:0", -- Sublime Wristguards
	[18498]="0:2:3:1:OneHandAxe::1:0::3:0", -- Hedgecutter
	[18499]="0:4:3:1:Shield::1:0::3:0", -- Barrier Shield
	[18500]="0:4:3:1:Ring::1:0::3:0", -- Tarnished Elven Ring
	[18501]="0:12:1:1:::1:0::3:0", -- Felvine Shard
	[18502]="0:2:3:1:Polearm::1:0::3:0", -- Monstrous Glaive
	[18503]="0:4:3:1:Plate::1:0::3:0", -- Kromcrush's Chestplate
	[18504]="0:4:3:1:Leather::1:0::2:0", -- Girdle of Insight
	[18505]="0:4:3:1:Leather::1:0::3:0", -- Mugger's Belt
	[18506]="0:4:3:1:Leather::1:0::2:0", -- Mongoose Boots
	[18507]="0:4:3:1:Cloth::1:0::3:0", -- Boots of the Full Moon
	[18508]="0:4:3:1:Mail::1:0::2:0", -- Swift Flight Bracers
	[18509]="0:4:4:1:Cloak::1:0::2:0", -- Chromatic Cloak
	[18510]="0:4:4:1:Cloak::1:0::2:0", -- Hide of the Wild
	[18511]="0:4:4:1:Cloak::1:0::2:0", -- Shifting Cloak
	[18512]="0:15:0:5:Junk::1:0::0:0", -- Larval Acid
	[18513]="0:12:4:1:::1:0::3:0", -- A Dull and Flat Elven Blade
	[18514]="0:9:3:1:Leatherworking::1:0::3:0", -- Pattern: Girdle of Insight
	[18515]="0:9:3:1:Leatherworking::1:0::3:0", -- Pattern: Mongoose Boots
	[18516]="0:9:3:1:Leatherworking::1:0::3:0", -- Pattern: Swift Flight Bracers
	[18517]="0:9:4:1:Leatherworking::1:0::0:0", -- Pattern: Chromatic Cloak
	[18518]="0:9:4:1:Leatherworking::1:0::0:0", -- Pattern: Hide of the Wild
	[18519]="0:9:4:1:Leatherworking::1:0::0:0", -- Pattern: Shifting Cloak
	[18520]="0:2:3:1:TwoHandSword::1:0::3:0", -- Barbarous Blade
	[18521]="0:4:3:1:Plate::1:0::3:0", -- Grimy Metal Boots
	[18522]="0:4:3:1:Ring::1:0::3:0", -- Band of the Ogre King
	[18523]="0:4:3:1:OffHandFrill::1:0::3:0", -- Brightly Glowing Stone
	[18524]="0:4:3:1:Mail::1:0::3:0", -- Leggings of Destruction
	[18525]="0:4:3:1:Leather::1:0::3:0", -- Bracers of Prosperity
	[18526]="0:4:3:1:Cloth::1:0::3:0", -- Crown of the Ogre King
	[18527]="0:4:3:1:Mail::1:0::3:0", -- Harmonious Gauntlets
	[18528]="0:4:3:1:Leather::1:0::3:0", -- Cyclone Spaulders
	[18529]="0:4:3:1:Plate::1:0::3:0", -- Elemental Plate Girdle
	[18530]="0:4:3:1:Mail::1:0::3:0", -- Ogre Forged Hauberk
	[18531]="0:2:3:1:TwoHandMace::1:0::3:0", -- Unyielding Maul
	[18532]="0:4:3:1:Cloth::1:0::3:0", -- Mindsurge Robe
	[18533]="0:4:3:1:Plate::1:0::3:0", -- Gordok Bracers of Power
	[18534]="0:2:3:1:Stave::1:0::3:0", -- Rod of the Ogre Magi
	[18535]="0:4:3:1:Shield::1:0::3:0", -- Milli's Shield
	[18536]="0:4:3:1:OffHandFrill::1:0::3:0", -- Milli's Lexicon
	[18537]="0:4:3:1:Trinket::1:0::3:0", -- Counterattack Lodestone
	[18538]="0:2:4:1:TwoHandAxe::1:0::3:0", -- Treant's Bane
	[18539]="0:12:1:1:::1:0::4:0", -- Reliquary of Purity
	[18540]="0:12:1:1:::1:0::4:0", -- Sealed Reliquary of Purity
	[18541]="0:4:4:1:Cloak::1:0::3:0", -- Puissant Cape
	[18542]="0:2:4:1:TwoHandSword::1:0::3:0", -- Typhoon
	[18543]="0:4:4:1:Ring::1:0::3:0", -- Ring of Entropy
	[18544]="0:4:4:1:Leather::1:0::3:0", -- Doomhide Gauntlets
	[18545]="0:4:4:1:Cloth::1:0::3:0", -- Leggings of Arcane Supremacy
	[18546]="0:4:4:1:Mail::1:0::3:0", -- Infernal Headcage
	[18547]="0:4:4:1:Plate::1:0::3:0", -- Unmelting Ice Girdle
	[18562]="0:7:4:20:MetalStone:186:1:0::0:0", -- Elementium Ingot
	[18563]="0:12:5:1:::1:0::3:0", -- Bindings of the Windseeker
	[18564]="0:12:5:1:::1:0::3:0", -- Bindings of the Windseeker
	[18567]="30000:7:1:20:MetalStone:164,186:1:0:790,1690,2844,2847,2999,3343,3356,3477,4257,4259,4597,4888,5411,5512,8161,8176,14624,14737,15176,15400,16376,16583,16670,16713,16823,17245,17655,19011,19012,19056,19342,19520,19530,19662,19879,20082,20463,22264,22476,23144,23908,24052,26081,26599,26934,27019,27045,27062,27134,27267,28344,28716,28796,29252,29253,29907,29923,29964,29969,30241,30253,30336,30436,31024,32594,33231,33599,33631,33675,41054,41274,41493,41675,41890,43410,43548,43564,43615,43625,43772,43882,43998,44022,44181,44195,44279,44311,44337,44377,45148,45451,45549,46359,46702,47059,47267,47286,47532,47864,47937,48057,48228,48251,48258,48356,48573,49549,49575,49592,49605,49695,49726,49756,49768,49800,50129,52641:0:0", -- Elemental Flux
	[18582]="0:2:6:1:OneHandSword::1:0::3:0", -- The Twin Blades of Azzinoth
	[18583]="0:2:6:1:OneHandSword::1:0::3:0", -- Warglaive of Azzinoth (Right)
	[18584]="0:2:6:1:OneHandSword::1:0::3:0", -- Warglaive of Azzinoth (Left)
	[18585]="0:4:3:1:Ring::1:0::3:0", -- Band of Allegiance
	[18586]="0:4:3:1:Ring::1:0::3:0", -- Lonetree's Circle
	[18587]="0:7:1:1:Device::1:0::0:0", -- Goblin Jumper Cables XL
	[18588]="0:7:1:20:Explosive::1:0::0:0", -- Ez-Thro Dynamite II
	[18590]="0:12:1:30:::1:0::4:0", -- Raging Beast's Blood
	[18591]="0:12:1:1:::1:0::4:0", -- Case of Blood
	[18592]="0:9:4:1:Blacksmithing::1:0::0:0", -- Plans: Sulfuron Hammer
	[18594]="0:7:1:20:Explosive::1:0::0:0", -- Powerful Seaforium Charge
	[18597]="0:15:1:1:Junk::1:0::3:0", -- Orcish Orphan Whistle
	[18598]="0:15:1:1:Junk::1:0::3:0", -- Human Orphan Whistle
	[18600]="0:9:0:1:Book::1:0::0:0", -- Tome of Arcane Brilliance
	[18601]="0:12:1:1:::1:0::4:0", -- Glowing Crystal Prison
	[18602]="0:4:3:1:OffHandFrill::1:0::3:0", -- Tome of Sacrifice
	[18603]="0:12:1:15:::1:0::4:0", -- Satyr Blood
	[18604]="0:12:1:5:::1:0::4:0", -- Tears of the Hederine
	[18605]="0:12:1:1:::1:0::4:0", -- Imprisoned Doomguard
	[18606]="0:0:1:1:Consumable::1:0:12781,12805:3:0", -- Alliance Battle Standard
	[18607]="0:0:1:1:Consumable::1:0:12793:3:0", -- Horde Battle Standard
	[18608]="0:2:4:1:Stave::1:0::3:0", -- Benediction
	[18609]="0:2:4:1:Stave::1:0::3:0", -- Anathema
	[18610]="0:2:1:1:OneHandSword::1:0::0:0", -- Keen Machete
	[18611]="0:4:1:1:Leather::1:0::0:0", -- Gnarlpine Leggings
	[18612]="0:4:1:1:Mail::1:0::0:0", -- Bloody Chain Boots
	[18625]="0:12:1:1:::1:0::4:0", -- Kroshius' Infernal Core
	[18626]="0:12:1:1:::1:0::4:0", -- Fel Fire
	[18628]="0:12:4:1:::1:0::3:0", -- Thorium Brotherhood Contract
	[18629]="500000:12:1:1:::1:0:14437:3:0", -- Black Lodestone
	[18631]="0:7:1:10:Part:202:1:0::0:0", -- Truesilver Transformer
	[18632]="1000:0:1:20:FoodDrink::5:0:15353,15354,49893:0:0", -- Moonbrook Riot Taffy
	[18633]="125:0:1:20:FoodDrink::5:0:15353,15354,49893:0:0", -- Styleen's Sour Suckerpop
	[18634]="0:4:3:1:Trinket::1:0::2:0", -- Gyrofreeze Ice Reflector
	[18635]="2000:0:1:20:FoodDrink::5:0:15353,15354,49893:0:0", -- Bellara's Nutterbar
	[18636]="0:7:1:1:Device::1:0::0:0", -- Ruined Jumper Cables XL
	[18637]="0:4:2:1:Trinket::1:0::0:0", -- Major Recombobulator
	[18638]="0:4:3:1:Trinket::1:0::2:0", -- Hyper-Radiant Flame Reflector
	[18639]="0:4:3:1:Trinket::1:0::2:0", -- Ultra-Flash Shadow Reflector
	[18640]="0:0:1:4:Other::1:0::0:0", -- Happy Fun Rock
	[18641]="0:7:1:20:Explosive::1:0::0:0", -- Dense Dynamite
	[18642]="0:12:1:1:::1:0::4:0", -- Jaina's Autograph
	[18645]="0:7:2:20:Device::1:0::0:0", -- Gnomish Alarm-o-Bot
	[18646]="0:4:4:1:Trinket::1:0::3:0", -- The Eye of Divinity
	[18647]="1800:9:1:1:Engineering::1:1:3413,45546,49918,52655:0:0", -- Schematic: Red Firework
	[18648]="1800:9:1:1:Engineering::1:1:2838,3495,49918:0:0", -- Schematic: Green Firework
	[18649]="1800:9:1:1:Engineering::1:1:1304,5175,49918:0:0", -- Schematic: Blue Firework
	[18650]="5000:9:1:1:Engineering::1:1:8131,49918:0:0", -- Schematic: EZ-Thro Dynamite II
	[18651]="0:9:1:1:Engineering::1:0::0:0", -- Schematic: Truesilver Transformer
	[18652]="12000:9:1:1:Engineering::1:1:11185:0:0", -- Schematic: Gyrofreeze Ice Reflector
	[18653]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Goblin Jumper Cables XL
	[18654]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Gnomish Alarm-o-Bot
	[18655]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Major Recombobulator
	[18656]="16000:9:1:1:Engineering::1:1:11185:0:0", -- Schematic: Powerful Seaforium Charge
	[18657]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Hyper-Radiant Flame Reflector
	[18658]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: Ultra-Flash Shadow Reflector
	[18659]="0:12:4:1:::1:0::3:0", -- Splinter of Nordrassil
	[18660]="0:7:2:1:Device::1:0::0:0", -- World Enlarger
	[18661]="0:9:2:1:Engineering::1:0::0:0", -- Schematic: World Enlarger
	[18662]="20:0:1:5:Other::1:0:14860:0:0", -- Heavy Leather Ball
	[18663]="1500000:12:1:1:::1:0:14437:3:0", -- J'eevee's Jar
	[18664]="0:15:1:1:Junk::1:0::0:0", -- A Treatise on Military Ranks
	[18665]="0:4:4:1:Trinket::1:0::2:0", -- The Eye of Shadow
	[18670]="500000:12:1:1:::1:0:14437:3:0", -- Xorothian Glyphs
	[18671]="0:2:3:1:OneHandMace::1:0::2:0", -- Baron Charr's Sceptre
	[18672]="0:4:2:1:OffHandFrill::1:0::2:0", -- Elemental Ember
	[18673]="0:4:3:1:Shield::1:0::2:0", -- Avalanchion's Stony Hide
	[18674]="0:4:2:1:Ring::1:0::2:0", -- Hardened Stone Band
	[18675]="0:15:1:1:Junk::1:0::0:0", -- Military Ranks of the Horde & Alliance
	[18676]="0:4:3:1:Mail::1:0::2:0", -- Sash of the Windreaver
	[18677]="0:4:2:1:Cloak::1:0::2:0", -- Zephyr Cloak
	[18678]="0:4:3:1:Amulet::1:0::2:0", -- Tempestria's Frozen Necklace
	[18679]="0:4:2:1:Ring::1:0::2:0", -- Frigid Ring
	[18680]="0:2:3:1:Bow::1:0::3:0", -- Ancient Bone Bow
	[18681]="0:4:3:1:Cloth::1:0::3:0", -- Burial Shawl
	[18682]="0:4:3:1:Leather::1:0::3:0", -- Ghoul Skin Leggings
	[18683]="0:2:3:1:OneHandMace::1:0::3:0", -- Hammer of the Vesper
	[18684]="0:4:3:1:Ring::1:0::3:0", -- Dimly Opalescent Ring
	[18686]="0:4:3:1:Mail::1:0::3:0", -- Bone Golem Shoulders
	[18687]="0:12:1:1:::1:0::4:0", -- Xorothian Stardust
	[18688]="0:12:1:1:::1:0::0:0", -- Imp in a Jar
	[18689]="0:4:3:1:Cloak::1:0::3:0", -- Phantasmal Cloak
	[18690]="0:4:3:1:Plate::1:0::3:0", -- Wraithplate Leggings
	[18691]="0:4:3:1:Amulet::1:0::3:0", -- Dark Advisor's Pendant
	[18692]="0:4:3:1:Plate::1:0::3:0", -- Death Knight Sabatons
	[18693]="0:4:3:1:Cloth::1:0::3:0", -- Shivery Handwraps
	[18694]="0:4:3:1:Mail::1:0::3:0", -- Shadowy Mail Greaves
	[18695]="0:4:3:1:OffHandFrill::1:0::3:0", -- Spellbound Tome
	[18696]="0:4:3:1:Shield::1:0::3:0", -- Intricately Runed Shield
	[18697]="0:4:3:1:Cloth::1:0::2:0", -- Coldstone Slippers
	[18698]="0:4:3:1:Leather::1:0::2:0", -- Tattered Leather Hood
	[18699]="0:4:3:1:Leather::1:0::2:0", -- Icy Tomb Spaulders
	[18700]="0:4:3:1:Leather::1:0::2:0", -- Malefic Bracers
	[18701]="0:4:3:1:Ring::1:0::2:0", -- Innervating Band
	[18702]="0:4:3:1:Plate::1:0::2:0", -- Belt of the Ordained
	[18704]="0:12:4:1:::1:0::0:0", -- Mature Blue Dragon Sinew
	[18705]="0:12:4:1:::1:0::4:0", -- Mature Black Dragon Sinew
	[18706]="0:4:2:1:Trinket::1:0::3:0", -- Arena Master
	[18707]="0:12:4:1:::1:0::3:0", -- Ancient Rune Etched Stave
	[18709]="0:4:3:1:Cloth::1:0::2:0", -- Arena Wristguards
	[18710]="0:4:3:1:Leather::1:0::2:0", -- Arena Bracers
	[18711]="0:4:3:1:Mail::1:0::2:0", -- Arena Bands
	[18712]="0:4:3:1:Plate::1:0::2:0", -- Arena Vambraces
	[18713]="0:2:4:1:Bow::1:0::3:0", -- Rhok'delar, Longbow of the Ancient Keepers
	[18714]="0:1:4:1:Bag::1:0::3:0", -- Ancient Sinew Wrapped Lamina
	[18715]="0:2:4:1:Stave::1:0::3:0", -- Lok'delar, Stave of the Ancient Keepers
	[18716]="0:4:3:1:Leather::1:0::3:0", -- Ash Covered Boots
	[18717]="0:2:3:1:TwoHandMace::1:0::3:0", -- Hammer of the Grand Crusader
	[18718]="0:4:3:1:Plate::1:0::3:0", -- Grand Crusader's Helm
	[18719]="0:12:1:1:::1:0::4:0", -- The Traitor's Heart
	[18720]="0:4:3:1:Cloth::1:0::3:0", -- Shroud of the Nathrezim
	[18721]="0:4:3:1:Mail::1:0::3:0", -- Barrage Girdle
	[18722]="0:4:3:1:Plate::1:0::3:0", -- Death Grips
	[18723]="0:4:3:1:Amulet::1:0::3:0", -- Animated Chain Necklace
	[18724]="0:12:4:1:::1:0::3:0", -- Enchanted Black Dragon Sinew
	[18725]="0:2:3:1:Polearm::1:0::3:0", -- Peacemaker
	[18726]="0:4:3:1:Leather::1:0::3:0", -- Magistrate's Cuffs
	[18727]="0:4:3:1:Cloth::1:0::3:0", -- Crimson Felt Hat
	[18728]="0:4:3:1:Amulet::1:0::3:0", -- Anastari Heirloom
	[18729]="0:2:3:1:Bow::1:0::3:0", -- Screeching Bow
	[18730]="0:4:3:1:Cloth::1:0::3:0", -- Shadowy Laced Handwraps
	[18731]="2000:9:1:1:Leatherworking::1:1:3366,5128:0:0", -- Pattern: Heavy Leather Ball
	[18734]="0:4:3:1:Cloak::1:0::3:0", -- Pale Moon Cloak
	[18735]="0:4:3:1:Cloth::1:0::3:0", -- Maleki's Footwraps
	[18736]="0:4:3:1:Leather::1:0::2:0", -- Plaguehound Leggings
	[18737]="0:2:3:1:OneHandAxe::1:0::3:0", -- Bone Slicing Hatchet
	[18738]="0:2:3:1:Crossbow::1:0::3:0", -- Carapace Spine Crossbow
	[18739]="0:4:3:1:Plate::1:0::3:0", -- Chitinous Plate Legguards
	[18740]="0:4:3:1:Cloth::1:0::3:0", -- Thuzadin Sash
	[18741]="0:4:3:1:Plate::1:0::2:0", -- Morlune's Bracer
	[18742]="0:4:3:1:Mail::1:0::2:0", -- Stratholme Militia Shoulderguard
	[18743]="0:4:3:1:Cloak::1:0::2:0", -- Gracious Cape
	[18744]="0:4:3:1:Leather::1:0::2:0", -- Plaguebat Fur Gloves
	[18745]="0:4:3:1:Cloth::1:0::2:0", -- Sacred Cloth Leggings
	[18746]="0:12:1:1:::1:0::4:0", -- Divination Scryer
	[18749]="0:12:1:1:::1:0::4:0", -- Charger's Lost Soul
	[18752]="0:12:1:1:::1:0::4:0", -- Exorcism Censer
	[18753]="0:12:1:1:::1:0::4:0", -- Arcanite Barding
	[18754]="0:4:3:1:Plate::1:0::3:0", -- Fel Hardened Bracers
	[18755]="0:2:3:1:Gun::1:0::3:0", -- Xorothian Firestick
	[18756]="0:4:3:1:Shield::1:0::3:0", -- Dreadguard's Protector
	[18757]="0:4:3:1:Cloth::1:0::3:0", -- Diabolic Mantle
	[18758]="0:2:3:1:Dagger::1:0::3:0", -- Specter's Blade
	[18759]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Malicious Axe
	[18760]="0:4:3:1:Ring::1:0::3:0", -- Necromantic Band
	[18761]="0:2:3:1:Wand::1:0::3:0", -- Oblivion's Touch
	[18762]="0:4:3:1:OffHandFrill::1:0::3:0", -- Shard of the Green Flame
	[18766]="100000:15:4:1:Mount::1:0:4730:3:0", -- Reins of the Swift Frostsaber
	[18767]="100000:15:4:1:Mount::1:0:4730:3:0", -- Reins of the Swift Mistsaber
	[18769]="0:12:3:1:::1:0::0:0", -- Enchanted Thorium Platemail
	[18770]="0:12:3:1:::1:0::0:0", -- Enchanted Thorium Platemail
	[18771]="0:12:3:1:::1:0::0:0", -- Enchanted Thorium Platemail
	[18772]="100000:15:4:1:Mount::1:0:7955:3:0", -- Swift Green Mechanostrider
	[18773]="100000:15:4:1:Mount::1:0:7955:3:0", -- Swift White Mechanostrider
	[18774]="100000:15:4:1:Mount::1:0:7955:3:0", -- Swift Yellow Mechanostrider
	[18775]="0:12:1:1:::1:0::4:0", -- Manna-Enriched Horse Feed
	[18776]="100000:15:4:1:Mount::1:0:384,4885,43694:3:0", -- Swift Palomino
	[18777]="100000:15:4:1:Mount::1:0:384,4885,43694:3:0", -- Swift Brown Steed
	[18778]="100000:15:4:1:Mount::1:0:384,4885,43694:3:0", -- Swift White Steed
	[18779]="0:12:3:1:::1:0::0:0", -- Bottom Half of Advanced Armorsmithing: Volume I
	[18780]="0:12:3:1:::1:0::0:0", -- Top Half of Advanced Armorsmithing: Volume I
	[18781]="0:12:3:1:::1:0::0:0", -- Bottom Half of Advanced Armorsmithing: Volume II
	[18782]="0:12:3:1:::1:0::0:0", -- Top Half of Advanced Armorsmithing: Volume II
	[18783]="0:12:3:1:::1:0::0:0", -- Bottom Half of Advanced Armorsmithing: Volume III
	[18784]="0:12:3:1:::1:0::0:0", -- Top Half of Advanced Armorsmithing: Volume III
	[18785]="100000:15:4:1:Mount::1:0:1261:3:0", -- Swift White Ram
	[18786]="100000:15:4:1:Mount::1:0:1261:3:0", -- Swift Brown Ram
	[18787]="100000:15:4:1:Mount::1:0:1261:3:0", -- Swift Gray Ram
	[18788]="100000:15:4:1:Mount::1:0:7952:3:0", -- Swift Blue Raptor
	[18789]="100000:15:4:1:Mount::1:0:7952:3:0", -- Swift Olive Raptor
	[18790]="100000:15:4:1:Mount::1:0:7952:3:0", -- Swift Orange Raptor
	[18791]="100000:15:4:1:Mount::1:0:4731:3:0", -- Purple Skeletal Warhorse
	[18792]="0:12:1:1:::1:0::4:0", -- Blessed Arcanite Barding
	[18793]="100000:15:4:1:Mount::1:0:3685:3:0", -- Great White Kodo
	[18794]="100000:15:4:1:Mount::1:0:3685:3:0", -- Great Brown Kodo
	[18795]="100000:15:4:1:Mount::1:0:3685:3:0", -- Great Gray Kodo
	[18796]="100000:15:4:1:Mount::1:0:3362:3:0", -- Horn of the Swift Brown Wolf
	[18797]="100000:15:4:1:Mount::1:0:3362:3:0", -- Horn of the Swift Timber Wolf
	[18798]="100000:15:4:1:Mount::1:0:3362:3:0", -- Horn of the Swift Gray Wolf
	[18799]="0:12:1:1:::1:0::3:0", -- Charger's Redeemed Soul
	[18802]="60000:12:1:5:::3:0:14437:3:0", -- Shadowy Potion
	[18803]="0:2:4:1:TwoHandMace::1:0::3:0", -- Finkle's Lava Dredger
	[18804]="0:12:1:1:::1:0::4:0", -- Lord Grayson's Satchel
	[18805]="0:2:4:1:Dagger::1:0::3:0", -- Core Hound Tooth
	[18806]="0:4:4:1:Plate::1:0::3:0", -- Core Forged Greaves
	[18807]="0:4:3:1:Mail::1:0::3:0", -- Helm of Latent Power
	[18808]="0:4:4:1:Cloth::1:0::3:0", -- Gloves of the Hypnotic Flame
	[18809]="0:4:4:1:Cloth::1:0::3:0", -- Sash of Whispered Secrets
	[18810]="0:4:4:1:Leather::1:0::3:0", -- Wild Growth Spaulders
	[18811]="0:4:4:1:Cloak::1:0::3:0", -- Fireproof Cloak
	[18812]="0:4:4:1:Mail::1:0::3:0", -- Wristguards of True Flight
	[18813]="0:4:4:1:Ring::1:0::3:0", -- Ring of Binding
	[18814]="0:4:4:1:Amulet::1:0::3:0", -- Choker of the Fire Lord
	[18815]="0:4:4:1:Trinket::1:0::3:0", -- Essence of the Pure Flame
	[18816]="0:2:4:1:Dagger::1:0::3:0", -- Perdition's Blade
	[18817]="0:4:4:1:Mail::1:0::3:0", -- Crown of Destruction
	[18818]="0:12:1:1:::1:0::3:0", -- Mor'zul's Instructions
	[18819]="0:12:1:1:::1:0::4:0", -- Rohan's Exorcism Censer
	[18820]="0:4:4:1:Trinket::1:0::3:0", -- Talisman of Ephemeral Power
	[18821]="0:4:4:1:Ring::1:0::3:0", -- Quick Strike Ring
	[18822]="0:2:4:1:TwoHandSword::1:0::3:0", -- Obsidian Edged Blade
	[18823]="0:4:4:1:Leather::1:0::3:0", -- Aged Core Leather Gloves
	[18824]="0:4:4:1:Plate::1:0::3:0", -- Magma Tempered Boots
	[18825]="275688:4:4:1:Shield::1:0:12784:3:0", -- Grand Marshal's Aegis
	[18826]="276644:4:4:1:Shield::1:0:12794:3:0", -- High Warlord's Shield Wall
	[18827]="433792:2:4:1:OneHandAxe::1:0:12784:3:0", -- Grand Marshal's Handaxe
	[18828]="435328:2:4:1:OneHandAxe::1:0:12794:3:0", -- High Warlord's Cleaver
	[18829]="0:4:4:1:Mail::1:0::3:0", -- Deep Earth Spaulders
	[18830]="496016:2:4:1:TwoHandAxe::1:0:12784:3:0", -- Grand Marshal's Sunderer
	[18831]="497936:2:4:1:TwoHandAxe::1:0:12794:3:0", -- High Warlord's Battle Axe
	[18832]="0:2:4:1:OneHandSword::1:0::3:0", -- Brutality Blade
	[18833]="301034:2:4:1:Bow::1:0:12784:3:0", -- Grand Marshal's Bullseye
	[18834]="1:4:3:1:Trinket::1:0:12795:3:0", -- Insignia of the Horde
	[18835]="303337:2:4:1:Bow::1:0:12794:3:0", -- High Warlord's Recurve
	[18836]="304489:2:4:1:Crossbow::1:0:12784:3:0", -- Grand Marshal's Repeater
	[18837]="305609:2:4:1:Crossbow::1:0:12794:3:0", -- High Warlord's Crossbow
	[18838]="420013:2:4:1:Dagger::1:0:12784:3:0", -- Grand Marshal's Dirk
	[18839]="1000:0:1:20:Potion::1:0:12781,12793:3:0", -- Combat Healing Potion
	[18840]="423085:2:4:1:Dagger::1:0:12794:3:0", -- High Warlord's Razor
	[18841]="1000:0:1:20:Potion::1:0:12781,12793:3:0", -- Combat Mana Potion
	[18842]="0:2:4:1:Stave::1:0::3:0", -- Staff of Dominance
	[18843]="427650:2:4:1:FistWeapon::1:0:12784:3:0", -- Grand Marshal's Right Hand Blade
	[18844]="429186:2:4:1:FistWeapon::1:0:12794:3:0", -- High Warlord's Right Claw
	[18845]="1:4:3:1:Trinket::1:0:12795:3:0", -- Insignia of the Horde
	[18846]="1:4:3:1:Trinket::1:0:12795:3:0", -- Insignia of the Horde
	[18847]="433751:2:4:1:FistWeapon::1:0:12784:3:0", -- Grand Marshal's Left Hand Blade
	[18848]="435245:2:4:1:FistWeapon::1:0:12794:3:0", -- High Warlord's Left Claw
	[18849]="1:4:3:1:Trinket::1:0:12795:3:0", -- Insignia of the Horde
	[18850]="1:4:3:1:Trinket::1:0:12795:3:0", -- Insignia of the Horde
	[18851]="1:4:3:1:Trinket::1:0:12795:3:0", -- Insignia of the Horde
	[18852]="1:4:3:1:Trinket::1:0:12795:3:0", -- Insignia of the Horde
	[18853]="1:4:3:1:Trinket::1:0:12795:3:0", -- Insignia of the Horde
	[18854]="1:4:3:1:Trinket::1:0:12785,12805:3:0", -- Insignia of the Alliance
	[18855]="311555:2:4:1:Gun::1:0:12784:3:0", -- Grand Marshal's Hand Cannon
	[18856]="1:4:3:1:Trinket::1:0:12785,12805:3:0", -- Insignia of the Alliance
	[18857]="1:4:3:1:Trinket::1:0:12785,12805:3:0", -- Insignia of the Alliance
	[18858]="1:4:3:1:Trinket::1:0:12785,12805:3:0", -- Insignia of the Alliance
	[18859]="1:4:3:1:Trinket::1:0:12785,12805:3:0", -- Insignia of the Alliance
	[18860]="317251:2:4:1:Gun::1:0:12794:3:0", -- High Warlord's Street Sweeper
	[18861]="0:4:4:1:Plate::1:0::3:0", -- Flamewaker Legplates
	[18862]="1:4:3:1:Trinket::1:0:12785,12805:3:0", -- Insignia of the Alliance
	[18863]="1:4:3:1:Trinket::1:0:12785,12805:3:0", -- Insignia of the Alliance
	[18864]="1:4:3:1:Trinket::1:0:12785,12805:3:0", -- Insignia of the Alliance
	[18865]="430638:2:4:1:OneHandMace::1:0:12784:3:0", -- Grand Marshal's Punisher
	[18866]="432174:2:4:1:OneHandMace::1:0:12794:3:0", -- High Warlord's Bludgeon
	[18867]="542085:2:4:1:TwoHandMace::1:0:12784:3:0", -- Grand Marshal's Battle Hammer
	[18868]="544004:2:4:1:TwoHandMace::1:0:12794:3:0", -- High Warlord's Pulverizer
	[18869]="493993:2:4:1:Polearm::1:0:12784:3:0", -- Grand Marshal's Glaive
	[18870]="0:4:4:1:Mail::1:0::3:0", -- Helm of the Lifegiver
	[18871]="511528:2:4:1:Polearm::1:0:12794:3:0", -- High Warlord's Pig Sticker
	[18872]="0:4:4:1:Cloth::1:0::3:0", -- Manastorm Leggings
	[18873]="515367:2:4:1:Stave::1:0:12784:3:0", -- Grand Marshal's Stave
	[18874]="517287:2:4:1:Stave::1:0:12794:3:0", -- High Warlord's War Staff
	[18875]="0:4:4:1:Leather::1:0::3:0", -- Salamander Scale Pants
	[18876]="521074:2:4:1:TwoHandSword::1:0:12784:3:0", -- Grand Marshal's Claymore
	[18877]="522993:2:4:1:TwoHandSword::1:0:12794:3:0", -- High Warlord's Greatsword
	[18878]="0:2:4:1:Dagger::1:0::3:0", -- Sorcerous Dagger
	[18879]="0:4:4:1:Ring::1:0::3:0", -- Heavy Dark Iron Ring
	[18880]="0:12:1:1:::1:0::4:0", -- Darkreaver's Head
	[18902]="100000:15:4:1:Mount::1:0:4730:3:0", -- Reins of the Swift Stormsaber
	[18904]="0:12:1:1:::1:0::4:0", -- Zorbin's Ultra-Shrinker
	[18922]="0:12:1:1:::1:0::4:0", -- Secret Plans: Fiery Flux
	[18943]="0:12:1:20:::1:0::4:0", -- Dark Iron Pillow
	[18944]="0:12:1:100:::1:0::0:0", -- Incendosaur Scale
	[18945]="0:12:1:100:::1:0::0:0", -- Dark Iron Residue
	[18946]="0:12:1:1:::1:0::4:0", -- Head of Overseer Maltorius
	[18947]="0:12:1:20:::1:0::4:0", -- Feral Scar Yeti Hide
	[18948]="0:4:3:1:Leather::1:0::2:0", -- Barbaric Bracers
	[18949]="2000:9:1:1:Leatherworking::1:1:4225,4589:0:0", -- Pattern: Barbaric Bracers
	[18950]="0:12:1:1:::1:0::4:0", -- Chambermaid Pillaclencher's Pillow
	[18951]="0:4:2:1:Trinket::1:0::3:0", -- Evonice's Landin' Pilla
	[18956]="0:12:1:20:::1:0::4:0", -- Miniaturization Residue
	[18957]="0:2:2:1:OneHandSword::1:0::3:0", -- Brushwood Blade
	[18958]="0:12:1:20:::1:0::4:0", -- Water Elemental Core
	[18959]="0:12:1:1:::1:0::4:0", -- Smithing Tuyere
	[18960]="0:12:1:1:::1:0::4:0", -- Lookout's Spyglass
	[18961]="0:12:1:20:::1:0::4:0", -- Zukk'ash Carapace
	[18962]="0:12:1:1:::1:0::4:0", -- Stinglasher's Glands
	[18964]="0:15:1:1:Companion::1:0::0:0", -- Turtle Egg (Loggerhead)
	[18969]="0:12:1:1:::1:0::3:0", -- Pristine Yeti Hide
	[18972]="0:12:1:1:::1:0::3:0", -- Perfect Yeti Hide
	[18984]="0:4:2:1:Miscellaneous::1:0::1:0", -- Dimensional Ripper - Everlook
	[18986]="0:4:2:1:Miscellaneous::1:0::1:0", -- Ultrasafe Transporter: Gadgetzan
	[18987]="0:12:1:1:::1:0::3:0", -- Blackhand's Command
	[19002]="0:12:4:1:::1:0::3:0", -- Head of Nefarian
	[19003]="0:12:4:1:::1:0::3:0", -- Head of Nefarian
	[19004]="0:0:1:1:Other::1:0::0:0", -- Healthstone
	[19005]="0:0:1:1:Other::1:0::0:0", -- Healthstone
	[19006]="0:0:1:1:Other::1:0::0:0", -- Lesser Healthstone
	[19007]="0:0:1:1:Other::1:0::0:0", -- Lesser Healthstone
	[19008]="0:0:1:1:Other::1:0::0:0", -- Healthstone
	[19009]="0:0:1:1:Other::1:0::0:0", -- Healthstone
	[19010]="0:0:1:1:Other::1:0::0:0", -- Greater Healthstone
	[19011]="0:0:1:1:Other::1:0::0:0", -- Greater Healthstone
	[19012]="0:0:1:1:Other::1:0::0:0", -- Major Healthstone
	[19013]="0:0:1:1:Other::1:0::0:0", -- Major Healthstone
	[19016]="0:12:5:1:::1:0::3:0", -- Vessel of Rebirth
	[19017]="0:12:1:1:::1:0::4:0", -- Essence of the Firelord
	[19018]="0:12:5:1:::1:0::3:0", -- Dormant Wind Kissed Blade
	[19019]="0:2:5:1:OneHandSword::1:0::3:0", -- Thunderfury, Blessed Blade of the Windseeker
	[19020]="0:12:1:1:::1:0::4:0", -- Camp Mojache Zukk'ash Report
	[19022]="0:2:2:1:FishingPole::1:0::3:0", -- Nat Pagle's Extreme Angler FC-5000
	[19023]="0:12:1:1:::1:0::4:0", -- Katoom's Best Lure
	[19024]="0:4:3:1:Trinket::1:0::3:0", -- Arena Grand Master
	[19025]="0:12:1:1:::1:0::4:0", -- Skylord Plume
	[19026]="0:0:1:10:Other::1:0::0:0", -- Snake Burst Firework
	[19027]="5000:9:1:1:Engineering::1:0:14637:3:0", -- Schematic: Snake Burst Firework
	[19028]="0:4:1:1:Miscellaneous::1:0::0:0", -- Elegant Dress
	[19029]="0:15:4:1:Mount::1:0:13218,13219:3:0", -- Horn of the Frostwolf Howler
	[19030]="0:15:4:1:Mount::1:0:13216,13217:3:0", -- Stormpike Battle Charger
	[19031]="0:4:1:1:Tabard::1:0:5188,5189,5190,13218,13219,16610:3:0", -- Frostwolf Battle Tabard
	[19032]="0:4:1:1:Tabard::1:0:5049,5191,5193,13216,13217,16766,52278:3:0", -- Stormpike Battle Tabard
	[19033]="0:12:1:1:::1:0::4:0", -- Slagtree's Lost Tools
	[19034]="0:12:1:1:::1:0::4:0", -- Lard's Lunch
	[19035]="0:15:2:1:Junk::1:0::3:0", -- Lard's Special Picnic Basket
	[19036]="0:12:1:1:::1:0::4:0", -- Final Message to the Wildhammer
	[19037]="0:4:2:1:Plate::1:0::3:0", -- Emerald Peak Spaulders
	[19038]="0:4:2:1:Ring::1:0::3:0", -- Ring of Subtlety
	[19039]="0:4:2:1:Leather::1:0::3:0", -- Zorbin's Water Resistant Hat
	[19040]="0:2:2:1:OneHandSword::1:0::3:0", -- Zorbin's Mega-Slicer
	[19041]="0:4:2:1:Leather::1:0::3:0", -- Pratt's Handcrafted Tunic
	[19042]="0:4:2:1:Leather::1:0::3:0", -- Jangdor's Handcrafted Tunic
	[19043]="0:4:3:1:Mail::1:0::2:0", -- Heavy Timbermaw Belt
	[19044]="0:4:3:1:Leather::1:0::2:0", -- Might of the Timbermaw
	[19045]="0:0:3:1:Consumable::1:0:13216,13217:3:0", -- Stormpike Battle Standard
	[19046]="0:0:3:1:Consumable::1:0:13218,13219:3:0", -- Frostwolf Battle Standard
	[19047]="0:4:3:1:Cloth::1:0::2:0", -- Wisdom of the Timbermaw
	[19048]="0:4:3:1:Mail::1:0::2:0", -- Heavy Timbermaw Boots
	[19049]="0:4:3:1:Leather::1:0::2:0", -- Timbermaw Brawlers
	[19050]="0:4:3:1:Cloth::1:0::2:0", -- Mantle of the Timbermaw
	[19051]="0:4:3:1:Plate::1:0::2:0", -- Girdle of the Dawn
	[19052]="0:4:3:1:Leather::1:0::2:0", -- Dawn Treaders
	[19054]="0:15:1:1:Companion::1:0::3:0", -- Red Dragon Orb
	[19055]="0:15:1:1:Companion::1:0::3:0", -- Green Dragon Orb
	[19056]="0:4:3:1:Cloth::1:0::2:0", -- Argent Boots
	[19057]="0:4:3:1:Plate::1:0::2:0", -- Gloves of the Dawn
	[19058]="0:4:3:1:Leather::1:0::2:0", -- Golden Mantle of the Dawn
	[19059]="0:4:3:1:Cloth::1:0::2:0", -- Argent Shoulders
	[19060]="2000:0:1:20:Consumable::5:0:14753,14754:3:0", -- Warsong Gulch Enriched Ration
	[19061]="1500:0:1:20:Consumable::5:0:14753,14754:3:0", -- Warsong Gulch Iron Ration
	[19062]="1000:0:1:20:Consumable::5:0:14753,14754:3:0", -- Warsong Gulch Field Ration
	[19066]="2000:0:1:20:Bandage::5:0:14753,14754:3:0", -- Warsong Gulch Runecloth Bandage
	[19067]="1500:0:1:20:Bandage::5:0:14753,14754:3:0", -- Warsong Gulch Mageweave Bandage
	[19068]="1000:0:1:20:Bandage::5:0:14753,14754:3:0", -- Warsong Gulch Silk Bandage
	[19069]="0:12:1:1:::1:0::4:0", -- Huntsman Malkhor's Skull
	[19070]="0:12:1:1:::1:0::4:0", -- Huntsman Malkhor's Bones
	[19071]="0:12:1:10:::1:0::4:0", -- Vessel of Tainted Blood
	[19083]="75224:4:3:1:Cloak::1:0:13218,13219:3:0", -- Frostwolf Legionnaire's Cloak
	[19084]="75500:4:3:1:Cloak::1:0:13216,13217:3:0", -- Stormpike Soldier's Cloak
	[19085]="75776:4:3:1:Cloak::1:0:13218,13219:3:0", -- Frostwolf Advisor's Cloak
	[19086]="76045:4:3:1:Cloak::1:0:13216,13217:3:0", -- Stormpike Sage's Cloak
	[19087]="89550:4:3:1:Plate::1:0:13218,13219:3:0", -- Frostwolf Plate Belt
	[19088]="76597:4:3:1:Mail::1:0:13218,13219:3:0", -- Frostwolf Mail Belt
	[19089]="64055:4:3:1:Leather::1:0:13218,13219:3:0", -- Frostwolf Leather Belt
	[19090]="51428:4:3:1:Cloth::1:0:13218,13219:3:0", -- Frostwolf Cloth Belt
	[19091]="90837:4:3:1:Plate::1:0:13216,13217:3:0", -- Stormpike Plate Girdle
	[19092]="77694:4:3:1:Mail::1:0:13216,13217:3:0", -- Stormpike Mail Girdle
	[19093]="64969:4:3:1:Leather::1:0:13216,13217:3:0", -- Stormpike Leather Girdle
	[19094]="52159:4:3:1:Cloth::1:0:13216,13217:3:0", -- Stormpike Cloth Girdle
	[19095]="1:4:3:1:Amulet::1:0:13218,13219:3:0", -- Frostwolf Legionnaire's Pendant
	[19096]="1:4:3:1:Amulet::1:0:13218,13219:3:0", -- Frostwolf Advisor's Pendant
	[19097]="1:4:3:1:Amulet::1:0:13216,13217:3:0", -- Stormpike Soldier's Pendant
	[19098]="1:4:3:1:Amulet::1:0:13216,13217:3:0", -- Stormpike Sage's Pendant
	[19099]="264333:2:3:1:Dagger::1:0:13218,13219:3:0", -- Glacial Blade
	[19100]="265317:2:3:1:Dagger::1:0:13216,13217:3:0", -- Electrified Dagger
	[19101]="332844:2:3:1:Stave::1:0:13218,13219:3:0", -- Whiteout Staff
	[19102]="334075:2:3:1:Stave::1:0:13216,13217:3:0", -- Crackling Staff
	[19103]="268244:2:3:1:OneHandAxe::1:0:13218,13219:3:0", -- Frostbite
	[19104]="269202:2:3:1:OneHandMace::1:0:13216,13217:3:0", -- Stormstrike Hammer
	[19105]="0:4:3:1:Cloth::1:0::3:0", -- Frost Runed Headdress
	[19106]="0:2:3:1:Polearm::1:0::3:0", -- Ice Barbed Spear
	[19107]="0:2:3:1:Crossbow::1:0::3:0", -- Bloodseeker
	[19108]="0:2:3:1:Wand::1:0::3:0", -- Wand of Biting Cold
	[19109]="0:4:3:1:Ring::1:0::3:0", -- Deep Rooted Ring
	[19110]="0:2:3:1:OneHandSword::1:0::3:0", -- Cold Forged Blade
	[19111]="0:4:3:1:Mail::1:0::3:0", -- Winteraxe Epaulets
	[19112]="0:4:3:1:Plate::1:0::3:0", -- Frozen Steel Vambraces
	[19113]="0:4:3:1:Leather::1:0::3:0", -- Yeti Hide Bracers
	[19114]="0:2:2:1:Bow::1:0::3:0", -- Highland Bow
	[19115]="0:4:2:1:OffHandFrill::1:0::3:0", -- Flask of Forest Mojo
	[19116]="0:4:2:1:Cloth::1:0::3:0", -- Greenleaf Handwraps
	[19117]="0:4:2:1:Plate::1:0::3:0", -- Laquered Wooden Plate Legguards
	[19118]="0:2:2:1:Wand::1:0::3:0", -- Nature's Breath
	[19119]="0:4:2:1:Leather::1:0::3:0", -- Owlbeast Hide Gloves
	[19120]="0:4:2:1:Trinket::1:0::3:0", -- Rune of the Guard Captain
	[19121]="0:4:3:1:Cloak::1:0::3:0", -- Deep Woodlands Cloak
	[19123]="0:4:2:1:Cloth::1:0::3:0", -- Everwarm Handwraps
	[19124]="0:4:2:1:Plate::1:0::3:0", -- Slagplate Leggings
	[19125]="0:4:2:1:Mail::1:0::3:0", -- Seared Mail Girdle
	[19126]="0:4:2:1:Plate::1:0::3:0", -- Slagplate Gauntlets
	[19127]="0:4:2:1:Leather::1:0::3:0", -- Charred Leather Tunic
	[19128]="0:4:2:1:Mail::1:0::3:0", -- Seared Mail Vest
	[19129]="0:4:2:1:Cloth::1:0::3:0", -- Everglowing Robe
	[19130]="0:2:4:1:Wand::1:0::3:0", -- Cold Snap
	[19131]="0:4:4:1:Cloth::1:0::3:0", -- Snowblind Shoes
	[19132]="0:4:4:1:Cloth::1:0::3:0", -- Crystal Adorned Crown
	[19133]="0:4:4:1:Cloth::1:0::3:0", -- Fel Infused Leggings
	[19134]="0:4:4:1:Leather::1:0::3:0", -- Flayed Doomguard Belt
	[19135]="0:4:4:1:Cloth::1:0::3:0", -- Blacklight Bracer
	[19136]="0:4:4:1:Cloth::1:0::3:0", -- Mana Igniting Cord
	[19137]="0:4:4:1:Plate::1:0::3:0", -- Onslaught Girdle
	[19138]="0:4:4:1:Ring::1:0::3:0", -- Band of Sulfuras
	[19139]="0:4:4:1:Leather::1:0::3:0", -- Fireguard Shoulders
	[19140]="0:4:4:1:Ring::1:0::3:0", -- Cauterizing Band
	[19141]="0:4:2:1:Trinket::1:0::3:0", -- Luffa
	[19142]="0:4:4:1:OffHandFrill::1:0::3:0", -- Fire Runed Grimoire
	[19143]="0:4:4:1:Plate::1:0::3:0", -- Flameguard Gauntlets
	[19144]="0:4:4:1:Mail::1:0::3:0", -- Sabatons of the Flamewalker
	[19145]="0:4:4:1:Cloth::1:0::3:0", -- Robe of Volatile Power
	[19146]="0:4:4:1:Leather::1:0::3:0", -- Wristguards of Stability
	[19147]="0:4:4:1:Ring::1:0::3:0", -- Ring of Spell Power
	[19148]="0:4:4:1:Plate::1:0::2:0", -- Dark Iron Helm
	[19149]="0:4:4:1:Leather::1:0::2:0", -- Lava Belt
	[19150]="0:0:1:1:Consumable::1:0::3:0", -- Sentinel Basic Care Package
	[19151]="0:0:1:1:Consumable::1:0::3:0", -- Sentinel Standard Care Package
	[19152]="0:0:1:1:Consumable::1:0::3:0", -- Sentinel Advanced Care Package
	[19153]="0:0:1:1:Consumable::1:0::3:0", -- Outrider Advanced Care Package
	[19154]="0:0:1:1:Consumable::1:0::3:0", -- Outrider Basic Care Package
	[19155]="0:0:1:1:Consumable::1:0::3:0", -- Outrider Standard Care Package
	[19156]="0:4:4:1:Cloth::1:0::2:0", -- Flarecore Robe
	[19157]="0:4:4:1:Mail::1:0::2:0", -- Chromatic Gauntlets
	[19159]="0:4:3:1:Amulet::1:0::3:0", -- Woven Ivy Necklace
	[19160]="0:4:1:1:Tabard::1:0::3:0", -- Contest Winner's Tabard
	[19162]="0:4:4:1:Leather::1:0::2:0", -- Corehound Belt
	[19163]="0:4:4:1:Leather::1:0::2:0", -- Molten Belt
	[19164]="0:4:4:1:Plate::1:0::2:0", -- Dark Iron Gauntlets
	[19165]="0:4:4:1:Cloth::1:0::2:0", -- Flarecore Leggings
	[19166]="0:2:4:1:Dagger::1:0::2:0", -- Black Amnesty
	[19167]="0:2:4:1:Polearm::1:0::2:0", -- Blackfury
	[19168]="0:2:4:1:OneHandSword::1:0::2:0", -- Blackguard
	[19169]="0:2:4:1:TwoHandAxe::1:0::2:0", -- Nightfall
	[19170]="0:2:4:1:OneHandMace::1:0::2:0", -- Ebon Hand
	[19182]="0:0:1:200:Consumable::1:0::3:0", -- Tattered Darkmoon Faire Prize Ticket
	[19183]="0:0:1:200:Other::1:0::0:0", -- Hourglass Sand
	[19202]="22000:9:1:1:Blacksmithing::1:0:11557:3:0", -- Plans: Heavy Timbermaw Belt
	[19203]="22000:9:1:1:Blacksmithing::1:0:10856,10857,11536:3:0", -- Plans: Girdle of the Dawn
	[19204]="40000:9:1:1:Blacksmithing::1:0:11557:3:0", -- Plans: Heavy Timbermaw Boots
	[19205]="40000:9:1:1:Blacksmithing::1:0:10856,10857,11536:3:0", -- Plans: Gloves of the Dawn
	[19206]="60000:9:1:1:Blacksmithing::1:1:12944:3:0", -- Plans: Dark Iron Helm
	[19207]="80000:9:1:1:Blacksmithing::1:0:12944:3:0", -- Plans: Dark Iron Gauntlets
	[19208]="70000:9:1:1:Blacksmithing::1:0:12944:3:0", -- Plans: Black Amnesty
	[19209]="70000:9:1:1:Blacksmithing::1:0:12944:3:0", -- Plans: Blackfury
	[19210]="120000:9:1:1:Blacksmithing::1:0:12944:3:0", -- Plans: Ebon Hand
	[19211]="120000:9:1:1:Blacksmithing::1:0:12944:3:0", -- Plans: Blackguard
	[19212]="120000:9:1:1:Blacksmithing::1:0:12944:3:0", -- Plans: Nightfall
	[19213]="0:12:2:250:::1:0::3:0", -- Silverwing Talisman of Merit
	[19215]="22000:9:1:1:Tailoring::1:0:11557:3:0", -- Pattern: Wisdom of the Timbermaw
	[19216]="22000:9:1:1:Tailoring::1:0:10856,10857,11536:3:0", -- Pattern: Argent Boots
	[19217]="40000:9:1:1:Tailoring::1:0:10856,10857,11536:3:0", -- Pattern: Argent Shoulders
	[19218]="40000:9:1:1:Tailoring::1:0:11557:3:0", -- Pattern: Mantle of the Timbermaw
	[19219]="60000:9:1:1:Tailoring::1:1:12944:3:0", -- Pattern: Flarecore Robe
	[19220]="90000:9:1:1:Tailoring::1:0:12944:3:0", -- Pattern: Flarecore Leggings
	[19221]="50:0:1:10:FoodDrink::1:0:14844:0:0", -- Darkmoon Special Reserve
	[19222]="10:0:1:10:FoodDrink::1:0:14844,20377:0:0", -- Cheap Beer
	[19223]="25:0:1:20:FoodDrink::5:0:14845:0:0", -- Darkmoon Dog
	[19224]="1000:0:1:20:FoodDrink::5:0:14845:0:0", -- Red Hot Wings
	[19225]="4000:0:1:20:FoodDrink::5:0:14845:0:0", -- Deep Fried Candybar
	[19227]="0:12:3:20:::1:0::0:0", -- Ace of Beasts
	[19228]="0:12:4:1:::1:0::0:0", -- Beasts Deck
	[19229]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #1
	[19230]="0:12:3:20:::1:0::0:0", -- Two of Beasts
	[19231]="0:12:3:20:::1:0::0:0", -- Three of Beasts
	[19232]="0:12:3:20:::1:0::0:0", -- Four of Beasts
	[19233]="0:12:3:20:::1:0::0:0", -- Five of Beasts
	[19234]="0:12:3:20:::1:0::0:0", -- Six of Beasts
	[19235]="0:12:3:20:::1:0::0:0", -- Seven of Beasts
	[19236]="0:12:3:20:::1:0::0:0", -- Eight of Beasts
	[19237]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #19
	[19238]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #3
	[19239]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #4
	[19240]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #5
	[19241]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #6
	[19242]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #7
	[19243]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #8
	[19244]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #9
	[19245]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #10
	[19246]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #11
	[19247]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #12
	[19248]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #13
	[19249]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #14
	[19250]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #15
	[19251]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #16
	[19252]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #18
	[19253]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #17
	[19254]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #21
	[19255]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #22
	[19256]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #2
	[19257]="0:12:4:1:::1:0::0:0", -- Warlords Deck
	[19258]="0:12:3:20:::1:0::0:0", -- Ace of Warlords
	[19259]="0:12:3:20:::1:0::0:0", -- Two of Warlords
	[19260]="0:12:3:20:::1:0::0:0", -- Three of Warlords
	[19261]="0:12:3:20:::1:0::0:0", -- Four of Warlords
	[19262]="0:12:3:20:::1:0::0:0", -- Five of Warlords
	[19263]="0:12:3:20:::1:0::0:0", -- Six of Warlords
	[19264]="0:12:3:20:::1:0::0:0", -- Seven of Warlords
	[19265]="0:12:3:20:::1:0::0:0", -- Eight of Warlords
	[19266]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #20
	[19267]="0:12:4:1:::1:0::0:0", -- Elementals Deck
	[19268]="0:12:3:20:::1:0::0:0", -- Ace of Elementals
	[19269]="0:12:3:20:::1:0::0:0", -- Two of Elementals
	[19270]="0:12:3:20:::1:0::0:0", -- Three of Elementals
	[19271]="0:12:3:20:::1:0::0:0", -- Four of Elementals
	[19272]="0:12:3:20:::1:0::0:0", -- Five of Elementals
	[19273]="0:12:3:20:::1:0::0:0", -- Six of Elementals
	[19274]="0:12:3:20:::1:0::0:0", -- Seven of Elementals
	[19275]="0:12:3:20:::1:0::0:0", -- Eight of Elementals
	[19276]="0:12:3:20:::1:0::0:0", -- Ace of Portals
	[19277]="0:12:4:1:::1:0::0:0", -- Portals Deck
	[19278]="0:12:3:20:::1:0::0:0", -- Two of Portals
	[19279]="0:12:3:20:::1:0::0:0", -- Three of Portals
	[19280]="0:12:3:20:::1:0::0:0", -- Four of Portals
	[19281]="0:12:3:20:::1:0::0:0", -- Five of Portals
	[19282]="0:12:3:20:::1:0::0:0", -- Six of Portals
	[19283]="0:12:3:20:::1:0::0:0", -- Seven of Portals
	[19284]="0:12:3:20:::1:0::0:0", -- Eight of Portals
	[19287]="0:4:4:1:Trinket::1:0::2:0", -- Darkmoon Card: Heroism
	[19288]="0:4:4:1:Trinket::1:0::2:0", -- Darkmoon Card: Blue Dragon
	[19289]="0:4:4:1:Trinket::1:0::2:0", -- Darkmoon Card: Maelstrom
	[19290]="0:4:4:1:Trinket::1:0::2:0", -- Darkmoon Card: Twisting Nether
	[19291]="100000:1:1:1:Bag::1:0:14828:0:0", -- Darkmoon Storage Box
	[19292]="20113:2:1:1:OneHandMace::1:0:56041:0:0", -- Last Month's Mutton
	[19293]="96881:2:1:1:OneHandMace::1:0:56041:0:0", -- Last Year's Mutton
	[19295]="3000:4:1:1:OffHandFrill::1:0:14828:0:0", -- Darkmoon Flower
	[19296]="0:0:2:1:Other::1:0::0:0", -- Greater Darkmoon Prize
	[19297]="0:0:2:1:Other::1:0::0:0", -- Lesser Darkmoon Prize
	[19298]="0:0:2:1:Other::1:0::0:0", -- Minor Darkmoon Prize
	[19299]="500:0:1:20:FoodDrink::5:0:14844:0:0", -- Fizzy Faire Drink
	[19300]="2000:0:1:20:FoodDrink::5:0:14844:0:0", -- Bottled Winterspring Water
	[19301]="7000:0:1:20:FoodDrink::5:0:13216,13217,13218,13219:3:0", -- Alterac Manna Biscuit
	[19302]="0:4:3:1:Ring::1:0::3:0", -- Darkmoon Ring
	[19303]="50000:4:2:1:Amulet::1:1:14846:3:0", -- Darkmoon Necklace
	[19304]="125:0:1:20:FoodDrink::5:0:14845:0:0", -- Spiced Beef Jerky
	[19305]="500:0:1:20:FoodDrink::5:0:14845:0:0", -- Pickled Kodo Foot
	[19306]="2000:0:1:20:FoodDrink::5:0:14845:0:0", -- Crunchy Frog
	[19307]="8000:0:1:100:Bandage::20:0:13216,13217,13218,13219:3:0", -- Alterac Heavy Runecloth Bandage
	[19308]="1:4:4:1:OffHandFrill::1:0:13216,13217,13218,13219:3:0", -- Tome of Arcane Domination
	[19309]="1:4:4:1:OffHandFrill::1:0:13216,13217,13218,13219:3:0", -- Tome of Shadow Force
	[19310]="1:4:4:1:OffHandFrill::1:0:13216,13217,13218,13219:3:0", -- Tome of the Ice Lord
	[19311]="1:4:4:1:OffHandFrill::1:0:13216,13217,13218,13219:3:0", -- Tome of Fiery Arcana
	[19312]="1:4:4:1:OffHandFrill::1:0:13216,13217,13218,13219:3:0", -- Lei of the Lifegiver
	[19315]="1:4:4:1:OffHandFrill::1:0:13216,13217,13218,13219:3:0", -- Therazane's Touch
	[19316]="0:15:0:1000:Junk::1:0::3:0", -- Ice Threaded Arrow
	[19317]="0:15:0:1000:Junk::1:0::3:0", -- Ice Threaded Bullet
	[19318]="5000:0:1:20:Consumable::5:0:13216,13217,13218,13219:3:0", -- Bottled Alterac Spring Water
	[19319]="1:1:3:1:Bag::1:0:13216,13217:3:0", -- Harpy Hide Quiver
	[19320]="1:1:3:1:Bag::1:0:13216,13217:3:0", -- Gnoll Skin Bandolier
	[19321]="222226:4:4:1:Shield::1:0:13216,13217,13218,13219:3:0", -- The Immovable Object
	[19323]="437273:2:4:1:TwoHandMace::1:0:13216,13217,13218,13219:3:0", -- The Unstoppable Force
	[19324]="351131:2:4:1:Dagger::1:0:13216,13217,13218,13219:3:0", -- The Lobotomizer
	[19325]="1:4:4:1:Ring::1:0:13216,13217,13218,13219:3:0", -- Don Julio's Band
	[19326]="22000:9:1:1:Leatherworking::1:0:11557:3:0", -- Pattern: Might of the Timbermaw
	[19327]="40000:9:1:1:Leatherworking::1:0:11557:3:0", -- Pattern: Timbermaw Brawlers
	[19328]="22000:9:1:1:Leatherworking::1:0:10856,10857,11536:3:0", -- Pattern: Dawn Treaders
	[19329]="40000:9:1:1:Leatherworking::1:0:10856,10857,11536:3:0", -- Pattern: Golden Mantle of the Dawn
	[19330]="60000:9:1:1:Leatherworking::1:1:12944:3:0", -- Pattern: Lava Belt
	[19331]="90000:9:1:1:Leatherworking::1:0:12944:3:0", -- Pattern: Chromatic Gauntlets
	[19332]="90000:9:1:1:Leatherworking::1:0:12944:3:0", -- Pattern: Corehound Belt
	[19333]="90000:9:1:1:Leatherworking::1:0:12944:3:0", -- Pattern: Molten Belt
	[19334]="0:2:4:1:TwoHandSword::1:0::3:0", -- The Untamed Blade
	[19335]="0:2:4:1:OneHandMace::1:0::3:0", -- Spineshatter
	[19336]="0:4:4:1:Trinket::1:0::3:0", -- Arcane Infused Gem
	[19337]="0:4:4:1:Trinket::1:0::3:0", -- The Black Book
	[19338]="0:12:1:1:::1:0::4:0", -- Free Ticket Voucher
	[19339]="0:4:4:1:Trinket::1:0::3:0", -- Mind Quickening Gem
	[19340]="0:4:4:1:Trinket::1:0::3:0", -- Rune of Metamorphosis
	[19341]="0:4:4:1:Trinket::1:0::3:0", -- Lifegiving Gem
	[19342]="0:4:4:1:Trinket::1:0::3:0", -- Venomous Totem
	[19343]="0:4:4:1:Trinket::1:0::3:0", -- Scrolls of Blinding Light
	[19344]="0:4:4:1:Trinket::1:0::3:0", -- Natural Alignment Crystal
	[19345]="0:4:4:1:Trinket::1:0::3:0", -- Aegis of Preservation
	[19346]="0:2:4:1:Dagger::1:0::3:0", -- Dragonfang Blade
	[19347]="0:2:4:1:Dagger::1:0::3:0", -- Claw of Chromaggus
	[19348]="0:4:4:1:Shield::1:0::3:0", -- Red Dragonscale Protector
	[19349]="0:4:4:1:Shield::1:0::3:0", -- Elementium Reinforced Bulwark
	[19350]="0:2:4:1:Bow::1:0::3:0", -- Heartstriker
	[19351]="0:2:4:1:OneHandSword::1:0::3:0", -- Maladath, Runed Blade of the Black Flight
	[19352]="0:2:4:1:OneHandSword::1:0::3:0", -- Chromatically Tempered Sword
	[19353]="0:2:4:1:TwoHandAxe::1:0::3:0", -- Drake Talon Cleaver
	[19354]="0:2:4:1:TwoHandAxe::1:0::3:0", -- Draconic Avenger
	[19355]="0:2:4:1:Stave::1:0::3:0", -- Shadow Wing Focus Staff
	[19356]="0:2:4:1:Stave::1:0::3:0", -- Staff of the Shadow Flame
	[19357]="0:2:4:1:TwoHandMace::1:0::3:0", -- Herald of Woe
	[19358]="0:2:4:1:TwoHandMace::1:0::3:0", -- Draconic Maul
	[19360]="0:2:4:1:OneHandMace::1:0::3:0", -- Lok'amir il Romathis
	[19361]="0:2:4:1:Crossbow::1:0::3:0", -- Ashjre'thul, Crossbow of Smiting
	[19362]="0:2:4:1:OneHandAxe::1:0::3:0", -- Doom's Edge
	[19363]="0:2:4:1:OneHandAxe::1:0::3:0", -- Crul'shorukh, Edge of Chaos
	[19364]="0:2:4:1:TwoHandSword::1:0::3:0", -- Ashkandi, Greatsword of the Brotherhood
	[19365]="0:2:4:1:FistWeapon::1:0::3:0", -- Claw of the Black Drake
	[19366]="0:4:4:1:OffHandFrill::1:0::3:0", -- Master Dragonslayer's Orb
	[19367]="0:2:4:1:Wand::1:0::3:0", -- Dragon's Touch
	[19368]="0:2:4:1:Gun::1:0::3:0", -- Dragonbreath Hand Cannon
	[19369]="0:4:4:1:Cloth::1:0::3:0", -- Gloves of Rapid Evolution
	[19370]="0:4:4:1:Cloth::1:0::3:0", -- Mantle of the Blackwing Cabal
	[19371]="0:4:4:1:Amulet::1:0::3:0", -- Pendant of the Fallen Dragon
	[19372]="0:4:4:1:Plate::1:0::3:0", -- Helm of Endless Rage
	[19373]="0:4:4:1:Mail::1:0::3:0", -- Black Brood Pauldrons
	[19374]="0:4:4:1:Cloth::1:0::3:0", -- Bracers of Arcane Accuracy
	[19375]="0:4:4:1:Cloth::1:0::3:0", -- Mish'undare, Circlet of the Mind Flayer
	[19376]="0:4:4:1:Ring::1:0::3:0", -- Archimtiros' Ring of Reckoning
	[19377]="0:4:4:1:Amulet::1:0::3:0", -- Prestor's Talisman of Connivery
	[19378]="0:4:4:1:Cloak::1:0::3:0", -- Cloak of the Brood Lord
	[19379]="0:4:4:1:Trinket::1:0::3:0", -- Neltharion's Tear
	[19380]="0:4:4:1:Mail::1:0::3:0", -- Therazane's Link
	[19381]="0:4:4:1:Leather::1:0::3:0", -- Boots of the Shadow Flame
	[19382]="0:4:4:1:Ring::1:0::3:0", -- Pure Elementium Band
	[19383]="0:4:4:1:Amulet::1:0::3:0", -- Master Dragonslayer's Medallion
	[19384]="0:4:4:1:Ring::1:0::3:0", -- Master Dragonslayer's Ring
	[19385]="0:4:4:1:Cloth::1:0::3:0", -- Empowered Leggings
	[19386]="0:4:4:1:Cloak::1:0::3:0", -- Elementium Threaded Cloak
	[19387]="0:4:4:1:Plate::1:0::3:0", -- Chromatic Boots
	[19388]="0:4:4:1:Cloth::1:0::3:0", -- Angelista's Grasp
	[19389]="0:4:4:1:Leather::1:0::3:0", -- Taut Dragonhide Shoulderpads
	[19390]="0:4:4:1:Leather::1:0::3:0", -- Taut Dragonhide Gloves
	[19391]="0:4:4:1:Cloth::1:0::3:0", -- Shimmering Geta
	[19392]="0:4:4:1:Plate::1:0::3:0", -- Girdle of the Fallen Crusader
	[19393]="0:4:4:1:Mail::1:0::3:0", -- Primalist's Linked Waistguard
	[19394]="0:4:4:1:Plate::1:0::3:0", -- Drake Talon Pauldrons
	[19395]="0:4:4:1:Trinket::1:0::3:0", -- Rejuvenating Gem
	[19396]="0:4:4:1:Leather::1:0::3:0", -- Taut Dragonhide Belt
	[19397]="0:4:4:1:Ring::1:0::3:0", -- Ring of Blackrock
	[19398]="0:4:4:1:Cloak::1:0::3:0", -- Cloak of Firemaw
	[19399]="0:4:4:1:Cloth::1:0::3:0", -- Black Ash Robe
	[19400]="0:4:4:1:Cloth::1:0::3:0", -- Firemaw's Clutch
	[19401]="0:4:4:1:Mail::1:0::3:0", -- Primalist's Linked Legguards
	[19402]="0:4:4:1:Plate::1:0::3:0", -- Legguards of the Fallen Crusader
	[19403]="0:4:4:1:Ring::1:0::3:0", -- Band of Forced Concentration
	[19405]="0:4:4:1:Leather::1:0::3:0", -- Malfurion's Blessed Bulwark
	[19406]="0:4:4:1:Trinket::1:0::3:0", -- Drake Fang Talisman
	[19407]="0:4:4:1:Cloth::1:0::3:0", -- Ebony Flame Gloves
	[19422]="0:12:1:1:::1:0::3:0", -- Darkmoon Faire Fortune
	[19423]="0:12:1:1:::1:0::3:0", -- Sayge's Fortune #23
	[19424]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #24
	[19425]="0:0:2:1:Consumable::1:0::3:0", -- Mysterious Lockbox
	[19426]="0:4:4:1:Amulet::1:0::3:0", -- Orb of the Darkmoon
	[19430]="0:4:4:1:Cloak::1:0::3:0", -- Shroud of Pure Thought
	[19431]="0:4:4:1:Trinket::1:0::3:0", -- Styleen's Impeding Scarab
	[19432]="0:4:4:1:Ring::1:0::3:0", -- Circle of Applied Force
	[19433]="0:4:4:1:Mail::1:0::3:0", -- Emberweave Leggings
	[19434]="0:4:4:1:Ring::1:0::3:0", -- Band of Dark Dominion
	[19435]="0:2:4:1:Wand::1:0::3:0", -- Essence Gatherer
	[19436]="0:4:4:1:Cloak::1:0::3:0", -- Cloak of Draconic Might
	[19437]="0:4:4:1:Cloth::1:0::3:0", -- Boots of Pure Thought
	[19438]="0:4:4:1:Cloth::1:0::3:0", -- Ringo's Blizzard Boots
	[19439]="0:4:4:1:Leather::1:0::3:0", -- Interlaced Shadow Jerkin
	[19440]="0:0:1:10:Other::1:0::0:0", -- Powerful Anti-Venom
	[19441]="0:7:1:5:Other:129:1:0::0:0", -- Huge Venom Sac
	[19442]="100000:9:1:1:FirstAid::1:0:10856,10857,11536:3:0", -- Formula: Powerful Anti-Venom
	[19443]="0:12:1:1:::1:0::3:0", -- Sayge's Fortune #25
	[19444]="30000:9:1:1:Enchanting::1:1:12944:3:0", -- Formula: Enchant Weapon - Strength
	[19445]="30000:9:1:1:Enchanting::1:0:11557:3:0", -- Formula: Enchant Weapon - Agility
	[19446]="30000:9:1:1:Enchanting::1:0:10856,10857,11536:3:0", -- Formula: Enchant Bracer - Mana Regeneration
	[19447]="60000:9:1:1:Enchanting::1:0:10856,10857,11536:3:0", -- Formula: Enchant Bracer - Healing Power
	[19448]="80000:9:1:1:Enchanting::1:1:12944:3:0", -- Formula: Enchant Weapon - Mighty Spirit
	[19449]="100000:9:1:1:Enchanting::1:1:12944:3:0", -- Formula: Enchant Weapon - Mighty Intellect
	[19450]="0:15:1:1:Companion::1:0::3:0", -- A Jubling's Tiny Home
	[19451]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #26
	[19452]="0:12:1:1:::1:0::3:0", -- Sayge's Fortune #27
	[19453]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #28
	[19454]="0:15:1:1:Junk::1:0::3:0", -- Sayge's Fortune #29
	[19462]="0:15:1:1:Companion::1:0::3:0", -- Unhatched Jubling Egg
	[19483]="0:15:1:1:Junk::1:0::0:0", -- Peeling the Onion
	[19484]="0:15:1:1:Junk::1:0::0:0", -- The Frostwolf Artichoke
	[19491]="0:4:4:1:Amulet::1:0::3:0", -- Amulet of the Darkmoon
	[19505]="0:4:1:1:Tabard::1:0:5188,5189,5190,14754,16610:3:0", -- Warsong Battle Tabard
	[19506]="0:4:1:1:Tabard::1:0:5049,5191,5193,14753,16766,52278:3:0", -- Silverwing Battle Tabard
	[19507]="0:4:3:1:Cloth::1:0::3:0", -- Inquisitor's Shawl
	[19508]="0:4:3:1:Leather::1:0::3:0", -- Branded Leather Bracers
	[19509]="0:4:3:1:Mail::1:0::3:0", -- Dusty Mail Boots
	[19510]="1:4:3:1:Ring::1:0:14754:3:0", -- Legionnaire's Band
	[19511]="1:4:3:1:Ring::1:0:14754:3:0", -- Legionnaire's Band
	[19512]="1:4:3:1:Ring::1:0:14754:3:0", -- Legionnaire's Band
	[19513]="1:4:3:1:Ring::1:0:14754:3:0", -- Legionnaire's Band
	[19514]="1:4:3:1:Ring::1:0:14753:3:0", -- Protector's Band
	[19515]="1:4:3:1:Ring::1:0:14753:3:0", -- Protector's Band
	[19516]="1:4:3:1:Ring::1:0:14753:3:0", -- Protector's Band
	[19517]="1:4:3:1:Ring::1:0:14753:3:0", -- Protector's Band
	[19518]="1:4:3:1:Ring::1:0:14754:3:0", -- Advisor's Ring
	[19519]="1:4:3:1:Ring::1:0:14754:3:0", -- Advisor's Ring
	[19520]="1:4:3:1:Ring::1:0:14754:3:0", -- Advisor's Ring
	[19521]="1:4:3:1:Ring::1:0:14754:3:0", -- Advisor's Ring
	[19522]="1:4:3:1:Ring::1:0:14753:3:0", -- Lorekeeper's Ring
	[19523]="1:4:3:1:Ring::1:0:14753:3:0", -- Lorekeeper's Ring
	[19524]="1:4:3:1:Ring::1:0:14753:3:0", -- Lorekeeper's Ring
	[19525]="1:4:3:1:Ring::1:0:14753:3:0", -- Lorekeeper's Ring
	[19526]="81527:4:3:1:Cloak::1:0:14754:3:0", -- Battle Healer's Cloak
	[19527]="48159:4:3:1:Cloak::1:0:14754:3:0", -- Battle Healer's Cloak
	[19528]="23904:4:3:1:Cloak::1:0:14754:3:0", -- Battle Healer's Cloak
	[19529]="10613:4:3:1:Cloak::1:0:14754:3:0", -- Battle Healer's Cloak
	[19530]="76948:4:3:1:Cloak::1:0:14753:3:0", -- Caretaker's Cape
	[19531]="50242:4:3:1:Cloak::1:0:14753:3:0", -- Caretaker's Cape
	[19532]="24934:4:3:1:Cloak::1:0:14753:3:0", -- Caretaker's Cape
	[19533]="10772:4:3:1:Cloak::1:0:14753:3:0", -- Caretaker's Cape
	[19534]="1:4:3:1:Amulet::1:0:14754:3:0", -- Scout's Medallion
	[19535]="1:4:3:1:Amulet::1:0:14754:3:0", -- Scout's Medallion
	[19536]="1:4:3:1:Amulet::1:0:14754:3:0", -- Scout's Medallion
	[19537]="1:4:3:1:Amulet::1:0:14754:3:0", -- Scout's Medallion
	[19538]="1:4:3:1:Amulet::1:0:14753:3:0", -- Sentinel's Medallion
	[19539]="1:4:3:1:Amulet::1:0:14753:3:0", -- Sentinel's Medallion
	[19540]="1:4:3:1:Amulet::1:0:14753:3:0", -- Sentinel's Medallion
	[19541]="1:4:3:1:Amulet::1:0:14753:3:0", -- Sentinel's Medallion
	[19542]="267922:2:3:1:Dagger::1:0:14754:3:0", -- Scout's Blade
	[19543]="174910:2:3:1:Dagger::1:0:14754:3:0", -- Scout's Blade
	[19544]="86791:2:3:1:Dagger::1:0:14754:3:0", -- Scout's Blade
	[19545]="34845:2:3:1:Dagger::1:0:14754:3:0", -- Scout's Blade
	[19546]="252659:2:3:1:Dagger::1:0:14753:3:0", -- Sentinel's Blade
	[19547]="164981:2:3:1:Dagger::1:0:14753:3:0", -- Sentinel's Blade
	[19548]="81882:2:3:1:Dagger::1:0:14753:3:0", -- Sentinel's Blade
	[19549]="35372:2:3:1:Dagger::1:0:14753:3:0", -- Sentinel's Blade
	[19550]="256468:2:3:1:OneHandSword::1:0:14754:3:0", -- Legionnaire's Sword
	[19551]="167459:2:3:1:OneHandSword::1:0:14754:3:0", -- Legionnaire's Sword
	[19552]="83107:2:3:1:OneHandSword::1:0:14754:3:0", -- Legionnaire's Sword
	[19553]="35899:2:3:1:OneHandSword::1:0:14754:3:0", -- Legionnaire's Sword
	[19554]="260277:2:3:1:OneHandSword::1:0:14753:3:0", -- Protector's Sword
	[19555]="169937:2:3:1:OneHandSword::1:0:14753:3:0", -- Protector's Sword
	[19556]="84324:2:3:1:OneHandSword::1:0:14753:3:0", -- Protector's Sword
	[19557]="36427:2:3:1:OneHandSword::1:0:14753:3:0", -- Protector's Sword
	[19558]="198065:2:3:1:Bow::1:0:14754:3:0", -- Outrider's Bow
	[19559]="129311:2:3:1:Bow::1:0:14754:3:0", -- Outrider's Bow
	[19560]="64162:2:3:1:Bow::1:0:14754:3:0", -- Outrider's Bow
	[19561]="25735:2:3:1:Bow::1:0:14754:3:0", -- Outrider's Bow
	[19562]="186617:2:3:1:Bow::1:0:14753:3:0", -- Outrunner's Bow
	[19563]="121864:2:3:1:Bow::1:0:14753:3:0", -- Outrunner's Bow
	[19564]="60480:2:3:1:Bow::1:0:14753:3:0", -- Outrunner's Bow
	[19565]="26131:2:3:1:Bow::1:0:14753:3:0", -- Outrunner's Bow
	[19566]="315791:2:3:1:Stave::1:0:14754:3:0", -- Advisor's Gnarled Staff
	[19567]="206205:2:3:1:Stave::1:0:14754:3:0", -- Advisor's Gnarled Staff
	[19568]="102332:2:3:1:Stave::1:0:14754:3:0", -- Advisor's Gnarled Staff
	[19569]="44211:2:3:1:Stave::1:0:14754:3:0", -- Advisor's Gnarled Staff
	[19570]="320553:2:3:1:Stave::1:0:14753:3:0", -- Lorekeeper's Staff
	[19571]="209282:2:3:1:Stave::1:0:14753:3:0", -- Lorekeeper's Staff
	[19572]="103864:2:3:1:Stave::1:0:14753:3:0", -- Lorekeeper's Staff
	[19573]="44870:2:3:1:Stave::1:0:14753:3:0", -- Lorekeeper's Staff
	[19574]="0:4:2:1:Amulet::1:0::3:0", -- Strength of Mugamba
	[19575]="0:4:3:1:Amulet::1:0::3:0", -- Strength of Mugamba
	[19576]="0:4:3:1:Amulet::1:0::3:0", -- Strength of Mugamba
	[19577]="0:4:4:1:Amulet::1:0::3:0", -- Rage of Mugamba
	[19578]="130566:4:4:1:Plate::1:0:14753,14754:3:0", -- Berserker Bracers
	[19579]="0:4:2:1:Amulet::1:0::3:0", -- Heathen's Brand
	[19580]="84690:4:4:1:Plate::1:0:14753,14754:3:0", -- Berserker Bracers
	[19581]="43638:4:4:1:Plate::1:0:14753,14754:3:0", -- Berserker Bracers
	[19582]="102188:4:4:1:Mail::1:0:14753,14754:3:0", -- Windtalker's Wristguards
	[19583]="73012:4:4:1:Mail::1:0:14753,14754:3:0", -- Windtalker's Wristguards
	[19584]="37619:4:4:1:Mail::1:0:14753,14754:3:0", -- Windtalker's Wristguards
	[19585]="0:4:3:1:Amulet::1:0::3:0", -- Heathen's Brand
	[19586]="0:4:3:1:Amulet::1:0::3:0", -- Heathen's Brand
	[19587]="86780:4:4:1:Leather::1:0:14753,14754:3:0", -- Forest Stalker's Bracers
	[19588]="0:4:4:1:Amulet::1:0::3:0", -- Hero's Brand
	[19589]="62239:4:4:1:Leather::1:0:14753,14754:3:0", -- Forest Stalker's Bracers
	[19590]="32062:4:4:1:Leather::1:0:14753,14754:3:0", -- Forest Stalker's Bracers
	[19591]="0:4:2:1:Amulet::1:0::3:0", -- The Eye of Zuldazar
	[19592]="0:4:3:1:Amulet::1:0::3:0", -- The Eye of Zuldazar
	[19593]="0:4:3:1:Amulet::1:0::3:0", -- The Eye of Zuldazar
	[19594]="0:4:4:1:Amulet::1:0::3:0", -- The All-Seeing Eye of Zuldazar
	[19595]="73390:4:4:1:Cloth::1:0:14753,14754:3:0", -- Dryad's Wrist Bindings
	[19596]="52427:4:4:1:Cloth::1:0:14753,14754:3:0", -- Dryad's Wrist Bindings
	[19597]="27006:4:4:1:Cloth::1:0:14753,14754:3:0", -- Dryad's Wrist Bindings
	[19598]="0:4:2:1:Amulet::1:0::3:0", -- Pebble of Kajaro
	[19599]="0:4:3:1:Amulet::1:0::3:0", -- Pebble of Kajaro
	[19600]="0:4:3:1:Amulet::1:0::3:0", -- Pebble of Kajaro
	[19601]="0:4:4:1:Amulet::1:0::3:0", -- Jewel of Kajaro
	[19602]="0:4:2:1:Amulet::1:0::3:0", -- Kezan's Taint
	[19603]="0:4:3:1:Amulet::1:0::3:0", -- Kezan's Taint
	[19604]="0:4:3:1:Amulet::1:0::3:0", -- Kezan's Taint
	[19605]="0:4:4:1:Amulet::1:0::3:0", -- Kezan's Unstoppable Taint
	[19606]="0:4:2:1:Amulet::1:0::3:0", -- Vision of Voodress
	[19607]="0:4:3:1:Amulet::1:0::3:0", -- Vision of Voodress
	[19608]="0:4:3:1:Amulet::1:0::3:0", -- Vision of Voodress
	[19609]="0:4:4:1:Amulet::1:0::3:0", -- Unmarred Vision of Voodress
	[19610]="0:4:2:1:Amulet::1:0::3:0", -- Enchanted South Seas Kelp
	[19611]="0:4:3:1:Amulet::1:0::3:0", -- Enchanted South Seas Kelp
	[19612]="0:4:3:1:Amulet::1:0::3:0", -- Enchanted South Seas Kelp
	[19613]="0:4:4:1:Amulet::1:0::3:0", -- Pristine Enchanted South Seas Kelp
	[19614]="0:4:2:1:Amulet::1:0::3:0", -- Zandalarian Shadow Talisman
	[19615]="0:4:3:1:Amulet::1:0::3:0", -- Zandalarian Shadow Talisman
	[19616]="0:4:3:1:Amulet::1:0::3:0", -- Zandalarian Shadow Talisman
	[19617]="0:4:4:1:Amulet::1:0::3:0", -- Zandalarian Shadow Mastery Talisman
	[19618]="0:4:2:1:Amulet::1:0::3:0", -- Maelstrom's Tendril
	[19619]="0:4:3:1:Amulet::1:0::3:0", -- Maelstrom's Tendril
	[19620]="0:4:3:1:Amulet::1:0::3:0", -- Maelstrom's Tendril
	[19621]="0:4:4:1:Amulet::1:0::3:0", -- Maelstrom's Wrath
	[19642]="0:12:1:1:::1:0::4:0", -- iCoke Prize Voucher
	[19682]="0:4:3:1:Cloth::1:0::2:0", -- Bloodvine Vest
	[19683]="0:4:3:1:Cloth::1:0::2:0", -- Bloodvine Leggings
	[19684]="0:4:3:1:Cloth::1:0::2:0", -- Bloodvine Boots
	[19685]="0:4:3:1:Leather::1:0::2:0", -- Primal Batskin Jerkin
	[19686]="0:4:3:1:Leather::1:0::2:0", -- Primal Batskin Gloves
	[19687]="0:4:3:1:Leather::1:0::2:0", -- Primal Batskin Bracers
	[19688]="0:4:3:1:Leather::1:0::2:0", -- Blood Tiger Breastplate
	[19689]="0:4:3:1:Leather::1:0::2:0", -- Blood Tiger Shoulders
	[19690]="0:4:3:1:Mail::1:0::2:0", -- Bloodsoul Breastplate
	[19691]="0:4:3:1:Mail::1:0::2:0", -- Bloodsoul Shoulders
	[19692]="0:4:3:1:Mail::1:0::2:0", -- Bloodsoul Gauntlets
	[19693]="0:4:3:1:Plate::1:0::2:0", -- Darksoul Breastplate
	[19694]="0:4:3:1:Plate::1:0::2:0", -- Darksoul Leggings
	[19695]="0:4:3:1:Plate::1:0::2:0", -- Darksoul Shoulders
	[19696]="0:0:1:20:FoodDrink::1:0::3:0", -- Harvest Bread
	[19697]="0:4:1:1:Miscellaneous::1:0::3:0", -- Bounty of the Harvest
	[19698]="0:12:2:250:::1:0::0:0", -- Zulian Coin
	[19699]="0:12:2:250:::1:0::0:0", -- Razzashi Coin
	[19700]="0:12:2:250:::1:0::0:0", -- Hakkari Coin
	[19701]="0:12:2:250:::1:0::0:0", -- Gurubashi Coin
	[19702]="0:12:2:250:::1:0::0:0", -- Vilebranch Coin
	[19703]="0:12:2:250:::1:0::0:0", -- Witherbark Coin
	[19704]="0:12:2:250:::1:0::0:0", -- Sandfury Coin
	[19705]="0:12:2:250:::1:0::0:0", -- Skullsplitter Coin
	[19706]="0:12:2:250:::1:0::0:0", -- Bloodscalp Coin
	[19707]="0:12:3:250:::1:0::0:0", -- Red Hakkari Bijou
	[19708]="0:12:3:250:::1:0::0:0", -- Blue Hakkari Bijou
	[19709]="0:12:3:250:::1:0::0:0", -- Yellow Hakkari Bijou
	[19710]="0:12:3:250:::1:0::0:0", -- Orange Hakkari Bijou
	[19711]="0:12:3:250:::1:0::0:0", -- Green Hakkari Bijou
	[19712]="0:12:3:250:::1:0::0:0", -- Purple Hakkari Bijou
	[19713]="0:12:3:250:::1:0::0:0", -- Bronze Hakkari Bijou
	[19714]="0:12:3:250:::1:0::0:0", -- Silver Hakkari Bijou
	[19715]="0:12:3:250:::1:0::0:0", -- Gold Hakkari Bijou
	[19716]="0:12:4:250:::1:0::3:0", -- Primal Hakkari Bindings
	[19717]="0:12:4:250:::1:0::3:0", -- Primal Hakkari Armsplint
	[19718]="0:12:4:250:::1:0::3:0", -- Primal Hakkari Stanchion
	[19719]="0:12:4:250:::1:0::3:0", -- Primal Hakkari Girdle
	[19720]="0:12:4:250:::1:0::3:0", -- Primal Hakkari Sash
	[19721]="0:12:4:250:::1:0::3:0", -- Primal Hakkari Shawl
	[19722]="0:12:4:250:::1:0::3:0", -- Primal Hakkari Tabard
	[19723]="0:12:4:250:::1:0::3:0", -- Primal Hakkari Kossack
	[19724]="0:12:4:250:::1:0::3:0", -- Primal Hakkari Aegis
	[19725]="0:12:1:20:::1:0::4:0", -- Arathi Resource Crate
	[19726]="0:7:0:20:Herb::1:0::0:0", -- Bloodvine
	[19727]="0:7:3:1:Herb::1:0::3:0", -- Blood Scythe
	[19767]="0:7:1:20:Leather:165:1:0::0:0", -- Primal Bat Leather
	[19768]="0:7:1:20:Leather:165:1:0::0:0", -- Primal Tiger Leather
	[19774]="0:3:0:20:GemSimple::1:0::0:0", -- Souldarite
	[19775]="0:12:1:1:::1:0::4:0", -- Sealed Azure Bag
	[19782]="0:0:3:1:EnhPerm::1:0::3:0", -- Presence of Might
	[19783]="0:0:3:1:EnhPerm::1:0::3:0", -- Syncretist's Sigil
	[19784]="0:0:3:1:EnhPerm::1:0::3:0", -- Death's Embrace
	[19785]="0:0:3:1:EnhPerm::1:0::3:0", -- Falcon's Call
	[19786]="0:0:3:1:EnhPerm::1:0::3:0", -- Vodouisant's Vigilant Embrace
	[19787]="0:0:3:1:EnhPerm::1:0::3:0", -- Presence of Sight
	[19788]="0:0:3:1:EnhPerm::1:0::3:0", -- Hoodoo Hex
	[19789]="0:0:3:1:EnhPerm::1:0::3:0", -- Prophetic Aura
	[19790]="0:0:3:1:EnhPerm::1:0::3:0", -- Animist's Caress
	[19802]="0:12:4:1:::1:0::3:0", -- Heart of Hakkar
	[19803]="0:12:2:20:::1:0::3:0", -- Brownell's Blue Striped Racer
	[19805]="0:12:2:20:::1:0::3:0", -- Keefer's Angelfish
	[19806]="0:12:2:20:::1:0::3:0", -- Dezian Queenfish
	[19807]="0:12:1:20:::1:0::3:0", -- Speckled Tastyfish
	[19808]="0:2:2:1:OneHandMace::1:0::2:0", -- Rockhide Strongfish
	[19812]="0:4:3:1:Trinket::1:0::3:0", -- Rune of the Dawn
	[19813]="0:12:2:1:::1:0::0:0", -- Punctured Voodoo Doll
	[19814]="0:12:2:1:::1:0::0:0", -- Punctured Voodoo Doll
	[19815]="0:12:2:1:::1:0::0:0", -- Punctured Voodoo Doll
	[19816]="0:12:2:1:::1:0::0:0", -- Punctured Voodoo Doll
	[19817]="0:12:2:1:::1:0::0:0", -- Punctured Voodoo Doll
	[19818]="0:12:2:1:::1:0::0:0", -- Punctured Voodoo Doll
	[19819]="0:12:2:1:::1:0::0:0", -- Punctured Voodoo Doll
	[19820]="0:12:2:1:::1:0::0:0", -- Punctured Voodoo Doll
	[19821]="0:12:2:1:::1:0::0:0", -- Punctured Voodoo Doll
	[19822]="0:4:4:1:Plate::1:0::3:0", -- Zandalar Vindicator's Breastplate
	[19823]="0:4:4:1:Plate::1:0::3:0", -- Zandalar Vindicator's Belt
	[19824]="0:4:4:1:Plate::1:0::3:0", -- Zandalar Vindicator's Armguards
	[19825]="0:4:4:1:Plate::1:0::3:0", -- Zandalar Freethinker's Breastplate
	[19826]="0:4:4:1:Plate::1:0::3:0", -- Zandalar Freethinker's Belt
	[19827]="0:4:4:1:Plate::1:0::3:0", -- Zandalar Freethinker's Armguards
	[19828]="0:4:4:1:Mail::1:0::3:0", -- Zandalar Augur's Hauberk
	[19829]="0:4:4:1:Mail::1:0::3:0", -- Zandalar Augur's Belt
	[19830]="0:4:4:1:Mail::1:0::3:0", -- Zandalar Augur's Bracers
	[19831]="0:4:4:1:Mail::1:0::3:0", -- Zandalar Predator's Mantle
	[19832]="0:4:4:1:Mail::1:0::3:0", -- Zandalar Predator's Belt
	[19833]="0:4:4:1:Mail::1:0::3:0", -- Zandalar Predator's Bracers
	[19834]="0:4:4:1:Leather::1:0::3:0", -- Zandalar Madcap's Tunic
	[19835]="0:4:4:1:Leather::1:0::3:0", -- Zandalar Madcap's Mantle
	[19836]="0:4:4:1:Leather::1:0::3:0", -- Zandalar Madcap's Bracers
	[19838]="0:4:4:1:Leather::1:0::3:0", -- Zandalar Haruspex's Tunic
	[19839]="0:4:4:1:Leather::1:0::3:0", -- Zandalar Haruspex's Belt
	[19840]="0:4:4:1:Leather::1:0::3:0", -- Zandalar Haruspex's Bracers
	[19841]="0:4:4:1:Cloth::1:0::3:0", -- Zandalar Confessor's Mantle
	[19842]="0:4:4:1:Cloth::1:0::3:0", -- Zandalar Confessor's Bindings
	[19843]="0:4:4:1:Cloth::1:0::3:0", -- Zandalar Confessor's Wraps
	[19845]="0:4:4:1:Cloth::1:0::3:0", -- Zandalar Illusionist's Mantle
	[19846]="0:4:4:1:Cloth::1:0::3:0", -- Zandalar Illusionist's Wraps
	[19848]="0:4:4:1:Cloth::1:0::3:0", -- Zandalar Demoniac's Wraps
	[19849]="0:4:4:1:Cloth::1:0::3:0", -- Zandalar Demoniac's Mantle
	[19850]="0:12:1:1:::1:0::4:0", -- Uther's Tribute
	[19851]="0:12:1:1:::1:0::4:0", -- Grom's Tribute
	[19852]="0:2:4:1:OneHandAxe::1:0::3:0", -- Ancient Hakkari Manslayer
	[19853]="0:2:4:1:Gun::1:0::3:0", -- Gurubashi Dwarf Destroyer
	[19854]="0:2:4:1:TwoHandSword::1:0::3:0", -- Zin'rokh, Destroyer of Worlds
	[19855]="0:4:4:1:Plate::1:0::3:0", -- Bloodsoaked Legplates
	[19856]="0:4:4:1:Amulet::1:0::3:0", -- The Eye of Hakkar
	[19857]="0:4:4:1:Cloak::1:0::3:0", -- Cloak of Consumption
	[19858]="0:12:2:250:::1:0::3:0", -- Zandalar Honor Token
	[19859]="0:2:4:1:Dagger::1:0::3:0", -- Fang of the Faceless
	[19861]="0:2:4:1:Wand::1:0::3:0", -- Touch of Chaos
	[19862]="0:4:4:1:Shield::1:0::3:0", -- Aegis of the Blood God
	[19863]="0:4:3:1:Ring::1:0::3:0", -- Primalist's Seal
	[19864]="0:2:4:1:OneHandSword::1:0::3:0", -- Bloodcaller
	[19865]="0:2:4:1:OneHandSword::1:0::3:0", -- Warblade of the Hakkari
	[19866]="0:2:4:1:OneHandSword::1:0::3:0", -- Warblade of the Hakkari
	[19867]="0:2:4:1:OneHandSword::1:0::3:0", -- Bloodlord's Defender
	[19869]="0:4:3:1:Leather::1:0::3:0", -- Blooddrenched Grips
	[19870]="0:4:3:1:Cloak::1:0::3:0", -- Hakkari Loa Cloak
	[19871]="0:4:3:1:Amulet::1:0::3:0", -- Talisman of Protection
	[19872]="0:15:4:1:Mount::1:0::3:0", -- Swift Razzashi Raptor
	[19873]="0:4:3:1:Ring::1:0::3:0", -- Overlord's Crimson Band
	[19874]="0:2:4:1:Polearm::1:0::3:0", -- Halberd of Smiting
	[19875]="0:4:3:1:Mail::1:0::3:0", -- Bloodstained Coif
	[19876]="0:4:4:1:Amulet::1:0::3:0", -- Soul Corrupter's Necklace
	[19877]="0:4:3:1:Leather::1:0::3:0", -- Animist's Leggings
	[19878]="0:4:3:1:Plate::1:0::3:0", -- Bloodsoaked Pauldrons
	[19880]="0:12:1:1:::1:0::4:0", -- Gurubashi Head Collection
	[19881]="0:12:1:20:::1:0::4:0", -- Channeler's Head
	[19882]="0:12:1:20:::1:0::4:0", -- The Hexxer's Head
	[19883]="0:12:1:1:::1:0::4:0", -- Sacred Cord
	[19884]="0:2:4:1:Stave::1:0::3:0", -- Jin'do's Judgement
	[19885]="0:4:4:1:Amulet::1:0::3:0", -- Jin'do's Evil Eye
	[19886]="0:4:3:1:Cloth::1:0::3:0", -- The Hexxer's Cover
	[19887]="0:4:3:1:Mail::1:0::3:0", -- Bloodstained Legplates
	[19888]="0:4:3:1:Cloak::1:0::3:0", -- Overlord's Embrace
	[19889]="0:4:3:1:Leather::1:0::3:0", -- Blooddrenched Leggings
	[19890]="0:2:4:1:OneHandMace::1:0::3:0", -- Jin'do's Hexxer
	[19891]="0:4:4:1:OffHandFrill::1:0::3:0", -- Jin'do's Bag of Whammies
	[19892]="0:4:3:1:Leather::1:0::3:0", -- Animist's Boots
	[19893]="0:4:3:1:Ring::1:0::3:0", -- Zanzil's Seal
	[19894]="0:4:3:1:Plate::1:0::3:0", -- Bloodsoaked Gauntlets
	[19895]="0:4:3:1:Cloth::1:0::3:0", -- Bloodtinged Kilt
	[19896]="0:2:4:1:FistWeapon::1:0::3:0", -- Thekal's Grasp
	[19897]="0:4:4:1:Cloth::1:0::3:0", -- Betrayer's Boots
	[19898]="0:4:3:1:Ring::1:0::3:0", -- Seal of Jin
	[19899]="0:4:3:1:Cloth::1:0::3:0", -- Ritualistic Legguards
	[19900]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Zulian Stone Axe
	[19901]="0:2:3:1:OneHandSword::1:0::3:0", -- Zulian Slicer
	[19902]="0:15:4:1:Mount::1:0::3:0", -- Swift Zulian Tiger
	[19903]="0:2:4:1:Dagger::1:0::3:0", -- Fang of Venoxis
	[19904]="0:4:4:1:Mail::1:0::3:0", -- Runed Bloodstained Hauberk
	[19905]="0:4:3:1:Ring::1:0::3:0", -- Zanzil's Band
	[19906]="0:4:3:1:Leather::1:0::3:0", -- Blooddrenched Footpads
	[19907]="0:4:3:1:Cloak::1:0::3:0", -- Zulian Tigerhide Cloak
	[19908]="0:2:3:1:OneHandMace::1:0::3:0", -- Sceptre of Smiting
	[19909]="0:2:4:1:Stave::1:0::3:0", -- Will of Arlokk
	[19910]="0:2:4:1:FistWeapon::1:0::3:0", -- Arlokk's Grasp
	[19911]="0:12:1:5:::1:0::4:0", -- Whipweed Heart
	[19912]="0:4:3:1:Ring::1:0::3:0", -- Overlord's Onyx Band
	[19913]="0:4:3:1:Plate::1:0::3:0", -- Bloodsoaked Greaves
	[19914]="0:1:3:1:Bag::1:0::3:0", -- Panther Hide Sack
	[19915]="0:4:3:1:Shield::1:0::3:0", -- Zulian Defender
	[19918]="0:2:4:1:TwoHandMace::1:0::3:0", -- Jeklik's Crusher
	[19919]="0:4:3:1:Mail::1:0::3:0", -- Bloodstained Greaves
	[19920]="0:4:3:1:Ring::1:0::3:0", -- Primalist's Band
	[19921]="0:2:3:1:OneHandAxe::1:0::2:0", -- Zulian Hacker
	[19922]="0:4:3:1:OffHandFrill::1:0::3:0", -- Arlokk's Hoodoo Stick
	[19923]="0:4:3:1:Amulet::1:0::3:0", -- Jeklik's Opaline Talisman
	[19925]="0:4:3:1:Ring::1:0::3:0", -- Band of Jin
	[19927]="0:2:4:1:Wand::1:0::3:0", -- Mar'li's Touch
	[19928]="0:4:3:1:Leather::1:0::3:0", -- Animist's Spaulders
	[19929]="0:4:3:1:Cloth::1:0::3:0", -- Bloodtinged Gloves
	[19930]="0:4:3:1:Trinket::1:0::3:0", -- Mar'li's Eye
	[19931]="0:12:3:20:::1:0::0:0", -- Gurubashi Mojo Madness
	[19933]="0:15:1:10:Junk::1:0::0:0", -- Glowing Scorpid Blood
	[19934]="0:15:0:20:Junk::1:0::0:0", -- Large Scorpid Claw
	[19935]="0:15:0:20:Junk::1:0::0:0", -- Empty Venom Sac
	[19936]="0:15:0:20:Junk::1:0::0:0", -- Dried Scorpid Carapace
	[19937]="0:15:0:20:Junk::1:0::0:0", -- Small Scorpid Claw
	[19938]="0:15:0:20:Junk::1:0::0:0", -- Heavy Scorpid Leg
	[19939]="0:12:2:1:::1:0::3:0", -- Gri'lek's Blood
	[19940]="0:12:2:1:::1:0::3:0", -- Renataki's Tooth
	[19941]="0:12:2:1:::1:0::3:0", -- Wushoolay's Mane
	[19942]="0:12:2:1:::1:0::3:0", -- Hazza'rah's Dream Thread
	[19943]="0:7:1:20:Other:171:1:0::0:0", -- Massive Mojo
	[19944]="0:2:4:1:Stave::1:0::3:0", -- Nat Pagle's Fish Terminator
	[19945]="0:4:4:1:Leather::1:0::3:0", -- Foror's Eyepatch
	[19946]="0:2:3:1:Polearm::1:0::3:0", -- Tigule's Harpoon
	[19947]="0:4:3:1:Trinket::1:0::3:0", -- Nat Pagle's Broken Reel
	[19948]="0:4:4:1:Trinket::1:0::3:0", -- Zandalarian Hero Badge
	[19949]="0:4:4:1:Trinket::1:0::3:0", -- Zandalarian Hero Medallion
	[19950]="0:4:4:1:Trinket::1:0::3:0", -- Zandalarian Hero Charm
	[19951]="0:4:4:1:Trinket::1:0::3:0", -- Gri'lek's Charm of Might
	[19952]="0:4:4:1:Trinket::1:0::3:0", -- Gri'lek's Charm of Valor
	[19953]="0:4:4:1:Trinket::1:0::3:0", -- Renataki's Charm of Beasts
	[19954]="0:4:4:1:Trinket::1:0::3:0", -- Renataki's Charm of Trickery
	[19955]="0:4:4:1:Trinket::1:0::3:0", -- Wushoolay's Charm of Nature
	[19956]="0:4:4:1:Trinket::1:0::3:0", -- Wushoolay's Charm of Spirits
	[19957]="0:4:4:1:Trinket::1:0::3:0", -- Hazza'rah's Charm of Destruction
	[19958]="0:4:4:1:Trinket::1:0::3:0", -- Hazza'rah's Charm of Healing
	[19959]="0:4:4:1:Trinket::1:0::3:0", -- Hazza'rah's Charm of Magic
	[19960]="0:12:1:1:::1:0::0:0", -- Crystalized Honey
	[19961]="0:2:3:1:OneHandMace::1:0::3:0", -- Gri'lek's Grinder
	[19962]="0:2:3:1:TwoHandAxe::1:0::3:0", -- Gri'lek's Carver
	[19963]="0:2:3:1:Polearm::1:0::3:0", -- Pitchfork of Madness
	[19964]="0:2:3:1:OneHandSword::1:0::3:0", -- Renataki's Soul Conduit
	[19965]="0:2:3:1:Dagger::1:0::3:0", -- Wushoolay's Poker
	[19967]="0:2:3:1:Wand::1:0::3:0", -- Thoughtblighter
	[19968]="0:2:3:1:OneHandSword::1:0::3:0", -- Fiery Retributer
	[19969]="0:4:2:1:Cloth::1:0::3:0", -- Nat Pagle's Extreme Anglin' Boots
	[19970]="0:2:3:1:FishingPole::1:0::3:0", -- Arcanite Fishing Pole
	[19971]="0:0:2:5:EnhPerm::1:0::3:0", -- High Test Eternium Fishing Line
	[19972]="0:4:2:1:Cloth::1:0::3:0", -- Lucky Fishing Hat
	[19974]="10000:12:1:20:::1:0:12919:0:0", -- Mudskunk Lure
	[19975]="0:12:1:20:::1:0::0:0", -- Zulian Mudskunk
	[19978]="0:15:1:1:Junk::1:0::0:0", -- Fishing Tournament!
	[19979]="0:4:3:1:Trinket::1:0::3:0", -- Hook of the Master Angler
	[19982]="0:4:3:1:Cloak::1:0::3:0", -- Duskbat Drape
	[19984]="0:4:3:1:Leather::1:0::3:0", -- Ebon Mask
	[19990]="0:4:3:1:Trinket::1:0::3:0", -- Blessed Prayer Beads
	[19991]="0:4:3:1:Trinket::1:0::3:0", -- Devilsaur Eye
	[19992]="0:4:3:1:Trinket::1:0::3:0", -- Devilsaur Tooth
	[19993]="0:2:3:1:Bow::1:0::3:0", -- Hoodoo Hunting Bow
	[19994]="0:0:1:20:FoodDrink::1:0::3:0", -- Harvest Fruit
	[19995]="0:0:1:20:FoodDrink::1:0::3:0", -- Harvest Boar
	[19996]="0:0:1:20:FoodDrink::1:0::3:0", -- Harvest Fish
	[19997]="0:0:1:20:Consumable::1:0::3:0", -- Harvest Nectar
	[19998]="0:4:3:1:Leather::1:0::2:0", -- Bloodvine Lens
	[19999]="0:4:3:1:Cloth::1:0::2:0", -- Bloodvine Goggles
	[20002]="0:0:1:20:Potion::1:0::0:0", -- Greater Dreamless Sleep Potion
	[20004]="0:0:1:20:Elixir::1:0::0:0", -- Mighty Troll's Blood Elixir
	[20006]="0:4:3:1:Ring::1:0::3:0", -- Circle of Hope
	[20007]="0:0:1:20:Elixir::1:0::0:0", -- Mageblood Elixir
	[20008]="2400:0:1:20:Potion::1:1:11188:0:0", -- Living Action Potion
	[20009]="0:12:1:1:::1:0::0:0", -- For the Light!
	[20010]="0:12:1:1:::1:0::0:0", -- The Horde's Hellscream
	[20013]="47000:9:1:1:Alchemy::1:0:11188:3:0", -- Recipe: Living Action Potion
	[20015]="0:15:0:20:Junk::1:0::0:0", -- Elder Raptor Feathers
	[20016]="0:15:0:20: